/*
 * This file was automatically generated, do not edit.
 */

#include <geogram/lua/lua_io.h>

void register_embedded_lua_files(void);
   
void register_embedded_lua_files() {
     register_embedded_lua_file("lib/preamble.lua",
        "--             preamble.lua \n"
        "-- FR bibliotheque interne, incluse par defaut \n"
        "-- FR ce fichier est toujours execute avant votre programme \n"
        "-- EN internal library, included by default \n"
        "-- EN this file is always executed before your program \n"
        " \n"
        "-- FR une fonction qui ne fait rien \n"
        "-- EN a function that does nothing \n"
        "function NOP() \n"
        "end \n"
        " \n"
        "-- EN by-default definition for functions called by GEOCOD \n"
        "-- FR definition par defaut des fonctions appelees par GEOCOD \n"
        "GLUP.draw_scene = NOP \n"
        "imgui.draw_application_menus = NOP \n"
        "imgui.draw_object_properties = NOP \n"
        "imgui.on_key_pressed = NOP \n"
        "imgui.on_key_released = NOP \n"
        " \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "    GLUP.SetRegionOfInterest(0,0,0,1,1,1) \n"
        "end \n"
        " \n"
        "-- Commented-out (I want to keep user's view when \n"
        "-- F5 is pushed). \n"
        "-- GLUP.ResetViewer() \n"
        " \n"
        " \n"
     );

     register_embedded_lua_file("lib/pixel.lua",
        "--             pixel.lua \n"
        "-- FR bibliotheque interne, incluse quand on appelle require(\"pixel\") \n"
        "-- FR fournit des fonctions simples pour afficher des (gros) pixels \n"
        "-- EN internal library, included when one calls require(\"pixel\") \n"
        "-- EN defines easy-to-use functions for displaying (big) pixels \n"
        " \n"
        "function GLUP.Pixel3D(x,y,z) \n"
        "   GLUP.Vertex(x,y,z) \n"
        "   GLUP.Vertex(x+1,y,z) \n"
        "   GLUP.Vertex(x,y+1,z) \n"
        "   GLUP.Vertex(x+1,y+1,z) \n"
        "   GLUP.Vertex(x,y,z+1) \n"
        "   GLUP.Vertex(x+1,y,z+1) \n"
        "   GLUP.Vertex(x,y+1,z+1) \n"
        "   GLUP.Vertex(x+1,y+1,z+1) \n"
        "end \n"
        " \n"
        "function GLUP.Pixel2D(x,y) \n"
        "   GLUP.Pixel3D(x,y,0.0) \n"
        "end \n"
        " \n"
        "pix = GLUP.Pixel2D \n"
        "pix3d = GLUP.Pixel3D \n"
        "col = GLUP.Color \n"
        " \n"
        "function pixBegin() \n"
        "   GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "   GLUP.Begin(GLUP.HEXAHEDRA) \n"
        "end \n"
        " \n"
        "function pixEnd() \n"
        "   GLUP.End() \n"
        "   GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "end \n"
        " \n"
        " \n"
        "GLUP.numbersGeom = { \n"
        "   {{1/6,1/8}, {2/6,1/8}}, \n"
        "   {{1/6,1/2}, {2/6,1/2}}, \n"
        "   {{1/6,7/8}, {2/6,7/8}}, \n"
        "   {{1/6,1/8}, {1/6,1/2}}, \n"
        "   {{2/6,1/8}, {2/6,1/2}}, \n"
        "   {{1/6,1/2}, {1/6,7/8}}, \n"
        "   {{2/6,1/2}, {2/6,7/8}} \n"
        "} \n"
        " \n"
        "GLUP.numbersSeg = { \n"
        "   0x7D, 0x50, 0x4F, 0x57, 0xF2, 0x37, 0x3F, 0x54, 0x7F, 0x77 \n"
        "} \n"
        " \n"
        "function GLUP.drawDigit(x,y,n) \n"
        "   for i=0,6 do \n"
        "       if (GLUP.numbersSeg[n+1] & (1 << i)) ~= 0 then \n"
        "	   GLUP.Vertex(GLUP.numbersGeom[i+1][1][1]+x, GLUP.numbersGeom[i+1][1][2]+y) \n"
        "	   GLUP.Vertex(GLUP.numbersGeom[i+1][2][1]+x, GLUP.numbersGeom[i+1][2][2]+y) \n"
        "       end \n"
        "   end \n"
        "end \n"
        " \n"
        "function GLUP.drawNumber(x,y,n) \n"
        "    if n >= 100 then \n"
        "    else \n"
        "        if n < 10 then \n"
        "	   GLUP.drawDigit(x+0.25,y,math.floor(n)) \n"
        "	else \n"
        "	   GLUP.drawDigit(x,y,math.floor(n/10))	 \n"
        "	   GLUP.drawDigit(x+0.5,y,math.floor(n%10)) \n"
        "	end \n"
        "    end \n"
        "end \n"
        " \n"
        " \n"
        "function pixGrid() \n"
        "   GLUP.SetColor(GLUP.FRONT_COLOR,0,0,0.5) \n"
        "   GLUP.Begin(GLUP.LINES) \n"
        "   local xm,ym,zm,xM,yM,zM \n"
        "   xm,ym,zm,xM,yM,zM = GLUP.GetRegionOfInterest() \n"
        "   for x=xm,xM,1 do \n"
        "      GLUP.Vertex(x,ym-0.5,0) \n"
        "      GLUP.Vertex(x,yM,0) \n"
        "   end \n"
        "   for y=ym,yM,1 do \n"
        "      GLUP.Vertex(xm-0.5,y,0) \n"
        "      GLUP.Vertex(xM,y,0) \n"
        "   end \n"
        "   GLUP.End() \n"
        "   GLUP.SetColor(GLUP.FRONT_COLOR,0.2,0.2,0.2) \n"
        "   GLUP.Begin(GLUP.LINES) \n"
        "   for x=xm,xM-1,1 do \n"
        "       GLUP.drawNumber(x,ym-1.2,x) \n"
        "   end \n"
        "   for y=ym,yM-1,1 do \n"
        "       GLUP.drawNumber(xm-1.2,y,y) \n"
        "   end \n"
        "   GLUP.End() \n"
        "end \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,21,21,1) \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "   pixGrid() \n"
        "end \n"
        " \n"
     );

     register_embedded_lua_file("lib/turtle.lua",
        "--             turtle.lua \n"
        "-- FR bibliotheque interne, incluse quand on appelle require(\"turtle\") \n"
        "-- FR fournit des fonctions pour l'affichage graphique en mode \"tortue\" \n"
        "-- EN internal library, included when one calls require(\"turtle\") \n"
        "-- EN defines functions for \"turtle\" graphics \n"
        " \n"
        "turtle={} \n"
        " \n"
        "function turtle.pendown() \n"
        "   if not turtle.pen then \n"
        "      turtle.pen=true \n"
        "      turtle.first=true \n"
        "      GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "      GLUP.Begin(GLUP.QUADS) \n"
        "   end \n"
        "end \n"
        " \n"
        "function turtle.penup() \n"
        "   if turtle.pen then \n"
        "      turtle.pen=false \n"
        "      GLUP.End() \n"
        "      GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "   end \n"
        "end \n"
        " \n"
        "function turtle.forward(dist) \n"
        "   local new_x = turtle.x + math.cos(turtle.alpha)*dist \n"
        "   local new_y = turtle.y + math.sin(turtle.alpha)*dist \n"
        "   if turtle.pen then \n"
        "      local Nx = turtle.width * (turtle.y - new_y) / dist \n"
        "      local Ny = turtle.width * (new_x - turtle.x) / dist \n"
        "      GLUP.Vertex(turtle.x+Nx,turtle.y+Ny,0) \n"
        "      GLUP.Vertex(turtle.x-Nx,turtle.y-Ny,0) \n"
        "      GLUP.Vertex(new_x-Nx, new_y-Ny,0) \n"
        "      GLUP.Vertex(new_x+Nx, new_y+Ny,0) \n"
        "   end \n"
        "   turtle.x = new_x \n"
        "   turtle.y = new_y \n"
        "end \n"
        " \n"
        "function turtle.backward(dist) \n"
        "   turtle.alpha = turtle.alpha + math.pi \n"
        "   turtle.forward(dist) \n"
        "   turtle.alpha = turtle.alpha - math.pi \n"
        "end \n"
        " \n"
        "function turtle.left(dalpha) \n"
        "   turtle.alpha = turtle.alpha + dalpha * math.pi / 180 \n"
        "end \n"
        " \n"
        "function turtle.right(dalpha) \n"
        "   turtle.alpha = turtle.alpha - dalpha * math.pi / 180 \n"
        "end \n"
        " \n"
        "function turtle.home() \n"
        "   turtle.x=0 \n"
        "   turtle.y=0 \n"
        "   turtle.alpha=math.pi/2 \n"
        "   if turtle.pen then \n"
        "      turtle.penup() \n"
        "   end \n"
        "   turtle.width=0.2 \n"
        "   turtle.first=true \n"
        "end \n"
        " \n"
        "function turtle.penwidth(w) \n"
        "   turtle.width = w \n"
        "end \n"
        " \n"
        "turtle.pencolor = GLUP.Color \n"
        " \n"
        "-- FR fonctions \"raccourcis\" \n"
        "-- FR (ca va plus vite a taper !) \n"
        "-- EN shorthands \n"
        " \n"
        "pu = turtle.penup \n"
        "pd = turtle.pendown \n"
        "fd = turtle.forward \n"
        "bk = turtle.backward \n"
        "tl = turtle.left \n"
        "tr = turtle.right \n"
        "home = turtle.home \n"
        "pcol = turtle.pencolor \n"
        "pwidth = turtle.penwidth \n"
        " \n"
        "turtle.pu = turtle.penup \n"
        "turtle.pd = turtle.pendown \n"
        "turtle.fd = turtle.forward \n"
        "turtle.bk = turtle.backward \n"
        "turtle.tl = turtle.left \n"
        "turtle.tr = turtle.right \n"
        "turtle.pcol = turtle.pencolor \n"
        "turtle.pwidth = turtle.penwidth \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(-50,-50,1,50,50,1) \n"
        "end \n"
        " \n"
     );

     register_embedded_lua_file("templates/pixel_program.lua",
        "require(\"pixel\") \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,11,11,1) \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        " \n"
        "    GLUP.Enable(GLUP.DRAW_MESH) \n"
        "    GLUP.SetCellsShrink(0.1) \n"
        "    pixGrid() \n"
        " \n"
        "    pixBegin() \n"
        "    col(\"blue\") \n"
        "    pix(1,1) \n"
        "    pixEnd() \n"
        "end \n"     );

     register_embedded_lua_file("templates/turtle_program.lua",
        "require(\"turtle\") \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "    home() \n"
        "    pcol(\"black\") \n"
        "    pd() \n"
        "    fd(100) \n"
        "    pu() \n"
        "end \n"     );

     register_embedded_lua_file("examples/arbre.lua",
        "require(\"turtle\") \n"
        " \n"
        "a=30 \n"
        "level=5 \n"
        "r=0 \n"
        "lr=0.3 \n"
        "threed=false \n"
        " \n"
        "function feuille() \n"
        "    local h=30/math.exp(level*lr) \n"
        "    pwidth(h/3) \n"
        "    pcol(0,1,0) \n"
        "    local a = math.random(-r,r) \n"
        "    tr(a) \n"
        "    fd(h) \n"
        "    tr(180) \n"
        "    pwidth(0.001) \n"
        "    pcol(0,0,0) \n"
        "    fd(h) \n"
        "    tl(180) \n"
        "    tl(a) \n"
        "end \n"
        " \n"
        "function arbre(i) \n"
        "   local b = a + math.random(-r,r) \n"
        "   local h = 30*math.exp(i*lr)/math.exp(level*lr) \n"
        "   pwidth(h*0.05) \n"
        "   pcol(0,i/level,1-i/level) \n"
        "   fd(h) \n"
        "   if i>1 then \n"
        "      tl(b) \n"
        "      arbre(i-1) \n"
        "      tr(b) \n"
        "      tr(b) \n"
        "      arbre(i-1) \n"
        "      tl(b) \n"
        "   else \n"
        "      feuille() \n"
        "   end \n"
        "   tr(180) \n"
        "   fd(h) \n"
        "   tl(180) \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "   if threed then \n"
        "      GLUP.Enable(GLUP.LIGHTING) \n"
        "   else \n"
        "      GLUP.Disable(GLUP.LIGHTING) \n"
        "   end \n"
        "   math.randomseed(0) \n"
        "   home() \n"
        "   pcol(\"green\") \n"
        " \n"
        "   if threed then \n"
        "       GLUP.MatrixMode(GLUP.MODELVIEW_MATRIX) \n"
        "       GLUP.PushMatrix() \n"
        "       GLUP.Rotate(os.clock()*50,0,1,0) \n"
        "   end \n"
        " \n"
        "   tr(180) \n"
        "   fd(20) \n"
        "   tr(180) \n"
        "   bk(30) \n"
        " \n"
        "   pd() \n"
        "   arbre(level) \n"
        "   pu() \n"
        " \n"
        "   if threed then \n"
        "       for i=1,3,1 do \n"
        "	   GLUP.Rotate(120,0,1,0) \n"
        "	   pd() \n"
        "	   arbre(level) \n"
        "	   pu() \n"
        "       end \n"
        "       GLUP.PopMatrix() \n"
        "    end \n"
        "end \n"
        " \n"
        "function imgui.draw_object_properties() \n"
        "   local b \n"
        "   b,a = imgui.SliderFloat(\"angle\", a, 0, 180, \"%3f\", 1.0) \n"
        "   b,r = imgui.SliderInt(\"rnd\", r, 0, 100, \"%.0f\") \n"
        "   b,level = imgui.SliderInt(\"level\", level, 1, 15, \"%.0f\") \n"
        "   b,lr = imgui.SliderFloat(\"ratio\", lr, 0.1, 0.5, \"%3f\", 1.0) \n"
        "   b,threed = imgui.Checkbox(\"3D\",threed) \n"
        "end \n"
     );

     register_embedded_lua_file("examples/flake.lua",
        "require(\"turtle\") \n"
        " \n"
        "function VonKoch(level) \n"
        "   if level==1 then \n"
        "      fd(1) \n"
        "   else \n"
        "      VonKoch(level-1) \n"
        "      tl(60) \n"
        "      VonKoch(level-1) \n"
        "      tr(120) \n"
        "      VonKoch(level-1) \n"
        "      tl(60) \n"
        "      VonKoch(level-1) \n"
        "   end \n"
        "end \n"
        " \n"
        "function Flake(level) \n"
        "   pd() \n"
        "   VonKoch(level) \n"
        "   tr(120) \n"
        "   VonKoch(level) \n"
        "   tr(120) \n"
        "   VonKoch(level) \n"
        "   pu() \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "    home() \n"
        "    fd(40) \n"
        "    tl(90) \n"
        "    fd(40) \n"
        "    tr(90) \n"
        "    pwidth(0.1) \n"
        "    tr(90) \n"
        "    GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "    GLUP.Disable(GLUP.LIGHTING) \n"
        "    pcol(\"gray\") \n"
        "    Flake(5) \n"
        "end \n"
     );

     register_embedded_lua_file("examples/sponge.lua",
        "require(\"pixel\") \n"
        " \n"
        "N=3*3 \n"
        " \n"
        "function sponge(x,y,z,d) \n"
        "  if d < 1 then \n"
        "     pix3d(x,y,z) \n"
        "  else \n"
        "     sponge(x,y,z,d/3) \n"
        "     sponge(x+d,y,z,d/3) \n"
        "     sponge(x+2*d,y,z,d/3) \n"
        "     sponge(x,y+d,z,d/3) \n"
        "     sponge(x+2*d,y+d,z,d/3) \n"
        "     sponge(x,y+2*d,z,d/3) \n"
        "     sponge(x+d,y+2*d,z,d/3) \n"
        "     sponge(x+2*d,y+2*d,z,d/3) \n"
        "     sponge(x,y,z+d,d/3) \n"
        "     sponge(x+2*d,y,z+d,d/3) \n"
        "     sponge(x,y+2*d,z+d,d/3) \n"
        "     sponge(x+2*d,y+2*d,z+d,d/3) \n"
        "     sponge(x,y,z+2*d,d/3) \n"
        "     sponge(x+d,y,z+2*d,d/3) \n"
        "     sponge(x+2*d,y,z+2*d,d/3) \n"
        "     sponge(x,y+d,z+2*d,d/3) \n"
        "     sponge(x+2*d,y+d,z+2*d,d/3) \n"
        "     sponge(x,y+2*d,z+2*d,d/3) \n"
        "     sponge(x+d,y+2*d,z+2*d,d/3) \n"
        "     sponge(x+2*d,y+2*d,z+2*d,d/3) \n"
        "  end \n"
        "end \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "  GLUP.SetRegionOfInterest(1,1,1,N*3,N*3,N*3) \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "  GLUP.Enable(GLUP.DRAW_MESH) \n"
        "  pixBegin() \n"
        "  col(\"yellow\") \n"
        "  sponge(1,1,1,N) \n"
        "  pixEnd() \n"
        "end \n"
     );

     register_embedded_lua_file("examples/creeper.lua",
        "-- Dessin d'un \"creeper\" \n"
        "-- Par Nathan Levy, Decembre 2016 \n"
        " \n"
        "require(\"pixel\") \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "   GLUP.SetCellsShrink(0.1) \n"
        "   GLUP.Enable(GLUP.DRAW_MESH) \n"
        "   GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "   pixBegin(); \n"
        "   col(\"green\") \n"
        "   pix(1,1) \n"
        "   pix(2,1) \n"
        "   pix(3,1) \n"
        "   pix(4,1) \n"
        "   pix(5,1) \n"
        "   pix(6,1) \n"
        "   pix(7,1) \n"
        "   pix(8,1) \n"
        "   pix(1,2) \n"
        "   col(\"black\") \n"
        "   pix(2,2) \n"
        "   pix(3,2) \n"
        "   col(\"green\") \n"
        "   pix(4,2) \n"
        "   pix(5,2) \n"
        "   col(\"black\") \n"
        "   pix(6,2) \n"
        "   pix(7,2) \n"
        "   col(\"green\") \n"
        "   pix(8,2) \n"
        "   pix(1,3) \n"
        "   col(\"black\") \n"
        "   for x=1,7,1 do \n"
        "      pix(x,3) \n"
        "   end \n"
        "   col(\"green\") \n"
        "   pix(8,3) \n"
        "   pix(1,4) \n"
        "   pix(2,4) \n"
        "   pix(3,4) \n"
        "   col(\"black\") \n"
        "   pix(4,4) \n"
        "   pix(5,4) \n"
        "   col(\"green\") \n"
        "   pix(6,4) \n"
        "   pix(7,4) \n"
        "   pix(8,4) \n"
        "   for x=1,8,1 do \n"
        "      pix(x,5) \n"
        "   end \n"
        "   pix(1,6) \n"
        "   col(\"black\") \n"
        "   pix(2,6) \n"
        "   pix(3,6) \n"
        "   col(\"green\") \n"
        "   pix(4,6) \n"
        "   pix(5,6) \n"
        "   col(\"black\") \n"
        "   pix(6,6) \n"
        "   pix(7,6) \n"
        "   col(\"green\") \n"
        "   pix(8,6) \n"
        "   pix(1,7) \n"
        "   col(\"black\") \n"
        "   pix(2,7) \n"
        "   pix(3,7) \n"
        "   col(\"green\") \n"
        "   pix(4,7) \n"
        "   pix(5,7) \n"
        "   col(\"black\") \n"
        "   pix(6,7) \n"
        "   pix(7,7) \n"
        "   col(\"green\") \n"
        "   pix(8,7) \n"
        "   for x=1,8,1 do \n"
        "      pix(x,8) \n"
        "   end \n"
        " \n"
        "   pixEnd() \n"
        "end \n"
     );

     register_embedded_lua_file("examples/plotter.lua",
        "--------------------------------------------------------------- \n"
        " \n"
        "-- FR Un programme d'exemple qui affiche une fonction mathematique \n"
        "-- EN An example program that plots a mathematical function \n"
        " \n"
        "--------------------------------------------------------------- \n"
        " \n"
        "-- FR La fonction peut etre changee ici \n"
        "-- EN The function can be changed here \n"
        " \n"
        "function f(x,y) \n"
        "   return 0.5+0.3*math.sin(x*5)*math.sin(y*5) \n"
        "end \n"
        " \n"
        "--------------------------------------------------------------- \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) \n"
        "end \n"
        " \n"
        " \n"
        " \n"
        "nx = 10 \n"
        "ny = 10 \n"
        " \n"
        "function point(i,j) \n"
        "    local x = i/(nx-1) \n"
        "    local y = j/(ny-1) \n"
        "    local z = f(x,y) \n"
        "    return x,y,z \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "    GLUP.Enable(GLUP.DRAW_MESH) \n"
        "    GLUP.SetPointSize(4.0) \n"
        "    GLUP.SetColor(GLUP.FRONT_COLOR, 1.0, 1.0, 1.0) \n"
        "    GLUP.Begin(GLUP.QUADS) \n"
        "    for j=0,ny-2 do \n"
        "	for i=0,nx-2 do \n"
        "	    GLUP.Vertex(point(i,j)) \n"
        "	    GLUP.Vertex(point(i+1,j)) \n"
        "	    GLUP.Vertex(point(i+1,j+1)) \n"
        "	    GLUP.Vertex(point(i,j+1)) \n"
        "	end \n"
        "    end \n"
        "    GLUP.End() \n"
        "end \n"
        " \n"
        "function save() \n"
        "    print(\"Saving plot to plot.obj\") \n"
        "    local file = io.open(\"plot.obj\",\"w\") \n"
        "    for j=0,(ny-1) do \n"
        "	for i=0,(nx-1) do \n"
        "	   local x,y,z = point(i,j) \n"
        "	   file:write(\"v \"..x..\" \"..y..\" \"..z..\"\\n\") \n"
        "	end \n"
        "    end \n"
        "    for j=0,ny-2 do \n"
        "       for i=0,nx-2 do \n"
        "          local v00 = math.floor(j*nx+i)+1 \n"
        "	  local v10 = math.floor(j*nx+i+1)+1 \n"
        "	  local v01 = math.floor((j+1)*nx+i)+1 \n"
        "	  local v11 = math.floor((j+1)*nx+i+1)+1 \n"
        "	  file:write(\"f \"..v00..\" \"..v10..\" \"..v11..\"\\n\") \n"
        "	  file:write(\"f \"..v00..\" \"..v11..\" \"..v01..\"\\n\") \n"
        "       end \n"
        "    end	 \n"
        "    file:close() \n"
        "end \n"
        " \n"
        "function imgui.draw_object_properties() \n"
        "    local b \n"
        "    b,nx = imgui.SliderInt(\"nx\", nx, 2, 100, \"%.0f\") \n"
        "    b,ny = imgui.SliderInt(\"ny\", ny, 2, 100, \"%.0f\") \n"
        "    imgui.Separator() \n"
        "    if imgui.Button(\"Save as plot.obj\") then \n"
        "	save() \n"
        "    end \n"
        "end \n"
     );

     register_embedded_lua_file("examples/maison.lua",
        "require(\"pixel\") \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,31,31,1) \n"
        "end \n"
        " \n"
        " \n"
        "function carre(x1,y1,x2,y2,z) \n"
        "    for x=x1,x2 do \n"
        "       pix3d(x,y1,z) \n"
        "       pix3d(x,y2,z) \n"
        "    end \n"
        "    for y=y1+1,y2-1 do \n"
        "       pix3d(x1,y,z) \n"
        "       pix3d(x2,y,z) \n"
        "    end \n"
        "end \n"
        " \n"
        "function colonne(x,y,h) \n"
        "   col(\"white\") \n"
        "   carre(x-1,y-1,x+1,y+1,0) \n"
        "   carre(x-1,y-1,x+1,y+1,h) \n"
        "   col(\"pink\") \n"
        "   for z=1,h-1 do \n"
        "      pix3d(x,y,z) \n"
        "   end \n"
        "end \n"
        " \n"
        " \n"
        "function arbre(x,y,h) \n"
        "   col(\"brown\") \n"
        "   for z=0,h-2 do \n"
        "      pix3d(x,y,z) \n"
        "   end \n"
        "   col(\"green\") \n"
        "   for z=h-2,h do \n"
        "     carre(x-1,y-1,x+1,y+1,z) \n"
        "   end \n"
        "end \n"
        " \n"
        " \n"
        "function GLUP.draw_scene() \n"
        " \n"
        "    GLUP.Enable(GLUP.DRAW_MESH) \n"
        "    GLUP.SetCellsShrink(0.1) \n"
        "    pixGrid() \n"
        " \n"
        "    pixBegin() \n"
        "    col(\"blue\") \n"
        "    for z=0,5 do \n"
        "      carre(2,2,10,10,z) \n"
        "    end \n"
        "    col(\"red\") \n"
        "    for z=5,10 do \n"
        "      d = z-5 \n"
        "      carre(1+d,1+d,11-d,11-d,z) \n"
        "    end \n"
        "    for x=1,30,5 do \n"
        "       colonne(x,15,3) \n"
        "    end \n"
        "    for x=1,30,5 do \n"
        "       z = math.sin(x/3+GLUP.ElapsedTime()*3)*4+10 \n"
        "       arbre(x,20,z) \n"
        "    end \n"
        "    pixEnd() \n"
        "end \n"
     );

     register_embedded_lua_file("examples/radis.lua",
        "require(\"pixel\") \n"
        " \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "  radis=math.floor(GLUP.ElapsedTime()*4) % 4 \n"
        "  if radis==0 then \n"
        "     draw_radis0(0,0) \n"
        "  elseif radis==1 then \n"
        "     draw_radis1(0,0) \n"
        "  elseif radis==2 then \n"
        "     draw_radis2(0,0) \n"
        "  elseif radis==3 then \n"
        "     draw_radis3(0,0) \n"
        "  end \n"
        "end \n"
        " \n"
        "function draw_radis0(x,y) \n"
        "  pixBegin() \n"
        "  GLUP.Disable(GLUP.DRAW_MESH) \n"
        "  col(0,0,0) \n"
        "  pix(x+1,y+10) \n"
        "  pix(x+2,y+10) \n"
        "  pix(x+6,y+10) \n"
        "  pix(x+7,y+10) \n"
        "  pix(x+8,y+10) \n"
        "  pix(x+0,y+9) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+9) \n"
        "  pix(x+2,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+9) \n"
        "  pix(x+5,y+9) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+9) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+9) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+9) \n"
        "  pix(x+1,y+8) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+8) \n"
        "  pix(x+3,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+8) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+8) \n"
        "  pix(x+6,y+8) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+8) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+8) \n"
        "  pix(x+11,y+8) \n"
        "  pix(x+0,y+7) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+7) \n"
        "  pix(x+2,y+7) \n"
        "  pix(x+3,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+7) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+7) \n"
        "  pix(x+6,y+7) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+7) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+7) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+7) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+10,y+7) \n"
        "  pix(x+11,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+12,y+7) \n"
        "  pix(x+1,y+6) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+6) \n"
        "  pix(x+3,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+6) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+6) \n"
        "  pix(x+6,y+6) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+6) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+6) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+6) \n"
        "  pix(x+11,y+6) \n"
        "  pix(x+0,y+5) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+5) \n"
        "  pix(x+2,y+5) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+5) \n"
        "  pix(x+5,y+5) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+5) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+5) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+5) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+5) \n"
        "  pix(x+1,y+4) \n"
        "  pix(x+2,y+4) \n"
        "  pix(x+6,y+4) \n"
        "  pix(x+7,y+4) \n"
        "  pix(x+8,y+4) \n"
        "  pix(x+5,y+3) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+7,y+3) \n"
        "  pix(x+5,y+2) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+7,y+2) \n"
        "  pix(x+5,y+1) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+1) \n"
        "  pix(x+7,y+1) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+1) \n"
        "  pix(x+6,y+0) \n"
        "  pix(x+7,y+0) \n"
        "  pixEnd() \n"
        "end \n"
        " \n"
        "function draw_radis1(x,y) \n"
        "  pixBegin() \n"
        "  col(0,0,0) \n"
        "  pix(x+1,y+11) \n"
        "  pix(x+2,y+11) \n"
        "  pix(x+6,y+11) \n"
        "  pix(x+7,y+11) \n"
        "  pix(x+8,y+11) \n"
        "  pix(x+0,y+10) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+10) \n"
        "  pix(x+2,y+10) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+10) \n"
        "  pix(x+5,y+10) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+10) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+10) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+10) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+10) \n"
        "  pix(x+1,y+9) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+9) \n"
        "  pix(x+3,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+9) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+9) \n"
        "  pix(x+6,y+9) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+9) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+9) \n"
        "  pix(x+11,y+9) \n"
        "  pix(x+0,y+8) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+8) \n"
        "  pix(x+2,y+8) \n"
        "  pix(x+3,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+8) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+8) \n"
        "  pix(x+6,y+8) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+8) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+8) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+8) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+10,y+8) \n"
        "  pix(x+11,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+12,y+8) \n"
        "  pix(x+1,y+7) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+7) \n"
        "  pix(x+3,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+7) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+7) \n"
        "  pix(x+6,y+7) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+7) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+7) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+7) \n"
        "  pix(x+11,y+7) \n"
        "  pix(x+0,y+6) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+6) \n"
        "  pix(x+2,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+6) \n"
        "  pix(x+5,y+6) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+6) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+6) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+6) \n"
        "  pix(x+1,y+5) \n"
        "  pix(x+2,y+5) \n"
        "  pix(x+5,y+5) \n"
        "  pix(x+6,y+5) \n"
        "  pix(x+7,y+5) \n"
        "  pix(x+8,y+5) \n"
        "  pix(x+4,y+4) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+5,y+4) \n"
        "  col(0,0,0) \n"
        "  pix(x+6,y+4) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+7,y+4) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+4) \n"
        "  pix(x+10,y+4) \n"
        "  pix(x+3,y+3) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+4,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+5,y+3) \n"
        "  pix(x+7,y+3) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+8,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+3) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+10,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+11,y+3) \n"
        "  pix(x+2,y+2) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+3,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+2) \n"
        "  pix(x+8,y+2) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+9,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+2) \n"
        "  pix(x+3,y+1) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+4,y+1) \n"
        "  col(0,0,0) \n"
        "  pix(x+5,y+1) \n"
        "  pix(x+9,y+1) \n"
        "  pix(x+4,y+0) \n"
        "  pixEnd() \n"
        "end \n"
        " \n"
        "function draw_radis2(x,y) \n"
        "  pixBegin() \n"
        "  col(0,0,0) \n"
        "  pix(x+1,y+10) \n"
        "  pix(x+2,y+10) \n"
        "  pix(x+6,y+10) \n"
        "  pix(x+7,y+10) \n"
        "  pix(x+8,y+10) \n"
        "  pix(x+0,y+9) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+9) \n"
        "  pix(x+2,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+9) \n"
        "  pix(x+5,y+9) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+9) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+9) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+9) \n"
        "  pix(x+1,y+8) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+8) \n"
        "  pix(x+3,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+8) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+8) \n"
        "  pix(x+6,y+8) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+8) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+8) \n"
        "  pix(x+11,y+8) \n"
        "  pix(x+0,y+7) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+7) \n"
        "  pix(x+2,y+7) \n"
        "  pix(x+3,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+7) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+7) \n"
        "  pix(x+6,y+7) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+7) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+7) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+7) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+10,y+7) \n"
        "  pix(x+11,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+12,y+7) \n"
        "  pix(x+1,y+6) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+6) \n"
        "  pix(x+3,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+6) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+6) \n"
        "  pix(x+6,y+6) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+6) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+6) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+6) \n"
        "  pix(x+11,y+6) \n"
        "  pix(x+0,y+5) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+5) \n"
        "  pix(x+2,y+5) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+5) \n"
        "  pix(x+5,y+5) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+5) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+5) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+5) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+5) \n"
        "  pix(x+1,y+4) \n"
        "  pix(x+2,y+4) \n"
        "  pix(x+6,y+4) \n"
        "  pix(x+7,y+4) \n"
        "  pix(x+8,y+4) \n"
        "  pix(x+5,y+3) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+7,y+3) \n"
        "  pix(x+5,y+2) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+7,y+2) \n"
        "  pix(x+5,y+1) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+6,y+1) \n"
        "  pix(x+7,y+1) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+1) \n"
        "  pix(x+6,y+0) \n"
        "  pix(x+7,y+0) \n"
        "  pixEnd() \n"
        "end \n"
        " \n"
        "function draw_radis3(x,y) \n"
        "  pixBegin() \n"
        "  col(0,0,0) \n"
        "  pix(x+1,y+11) \n"
        "  pix(x+2,y+11) \n"
        "  pix(x+6,y+11) \n"
        "  pix(x+7,y+11) \n"
        "  pix(x+8,y+11) \n"
        "  pix(x+0,y+10) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+10) \n"
        "  pix(x+2,y+10) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+10) \n"
        "  pix(x+5,y+10) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+10) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+10) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+10) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+10) \n"
        "  pix(x+1,y+9) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+9) \n"
        "  pix(x+3,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+9) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+9) \n"
        "  pix(x+6,y+9) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+9) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+9) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+9) \n"
        "  pix(x+11,y+9) \n"
        "  pix(x+0,y+8) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+8) \n"
        "  pix(x+2,y+8) \n"
        "  pix(x+3,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+8) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+8) \n"
        "  pix(x+6,y+8) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+8) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+8) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+8) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+10,y+8) \n"
        "  pix(x+11,y+8) \n"
        "  col(0,0,0) \n"
        "  pix(x+12,y+8) \n"
        "  pix(x+1,y+7) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+2,y+7) \n"
        "  pix(x+3,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+7) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+5,y+7) \n"
        "  pix(x+6,y+7) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+7) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+7) \n"
        "  col(0.952941,0.560784,0.560784) \n"
        "  pix(x+9,y+7) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+7) \n"
        "  pix(x+11,y+7) \n"
        "  pix(x+0,y+6) \n"
        "  col(0.180392,0.65098,0.0862745) \n"
        "  pix(x+1,y+6) \n"
        "  pix(x+2,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+3,y+6) \n"
        "  pix(x+5,y+6) \n"
        "  col(0.952941,0.133333,0.133333) \n"
        "  pix(x+6,y+6) \n"
        "  col(0.952941,0.239216,0.239216) \n"
        "  pix(x+7,y+6) \n"
        "  col(0.952941,0.380392,0.380392) \n"
        "  pix(x+8,y+6) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+6) \n"
        "  pix(x+1,y+5) \n"
        "  pix(x+2,y+5) \n"
        "  pix(x+5,y+5) \n"
        "  pix(x+6,y+5) \n"
        "  pix(x+7,y+5) \n"
        "  pix(x+8,y+5) \n"
        "  pix(x+4,y+4) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+5,y+4) \n"
        "  col(0,0,0) \n"
        "  pix(x+6,y+4) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+7,y+4) \n"
        "  col(0,0,0) \n"
        "  pix(x+8,y+4) \n"
        "  pix(x+10,y+4) \n"
        "  pix(x+3,y+3) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+4,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+5,y+3) \n"
        "  pix(x+7,y+3) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+8,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+9,y+3) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+10,y+3) \n"
        "  col(0,0,0) \n"
        "  pix(x+11,y+3) \n"
        "  pix(x+2,y+2) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+3,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+4,y+2) \n"
        "  pix(x+8,y+2) \n"
        "  col(0.752941,0.752941,0.752941) \n"
        "  pix(x+9,y+2) \n"
        "  col(0,0,0) \n"
        "  pix(x+10,y+2) \n"
        "  pix(x+3,y+1) \n"
        "  col(0.952941,0.952941,0.952941) \n"
        "  pix(x+4,y+1) \n"
        "  col(0,0,0) \n"
        "  pix(x+5,y+1) \n"
        "  pix(x+9,y+1) \n"
        "  pix(x+4,y+0) \n"
        "  pixEnd() \n"
        "end \n"
     );

     register_embedded_lua_file("games/hackman.lua",
        "require(\"pixel\") \n"
        " \n"
        "GLUP.ArcadeStyle() \n"
        " \n"
        "joueurx=13 \n"
        "joueury=10 \n"
        "vx=0 \n"
        "vy=0 \n"
        "newvx=0 \n"
        "newvy=0 \n"
        "lasttime=0 \n"
        "lastfantomtime=0 \n"
        " \n"
        "gumtime=0 \n"
        "gummode=false \n"
        "eatentime=0 \n"
        "eatenmode=false \n"
        "frozen=true \n"
        "gameover=false \n"
        " \n"
        "fantomx=13 \n"
        "fantomy=15 \n"
        "fantomvx=0 \n"
        "fantomvy=1 \n"
        " \n"
        " \n"
        "score=0 \n"
        "level=1 \n"
        "lives=3 \n"
        " \n"
        "niveau = { \n"
        "\"*************************\", \n"
        "\"*...........*...........*\", \n"
        "\"*.****.****.*.****.****.*\", \n"
        "\"*O*  *.*  *.*.*  *.*  *O*\", \n"
        "\"*.****.****.*.****.****.*\", \n"
        "\"*.......................*\", \n"
        "\"*.****.*.*******.*.****.*\", \n"
        "\"*......*....*....*......*\", \n"
        "\"******.**** * ****.******\", \n"
        "\"     *.*         *.*     \", \n"
        "\"******.* ******* *.******\", \n"
        "\"      .  *     *  .      \", \n"
        "\"******.* *     * *.******\", \n"
        "\"     *.* ******* *.*     \", \n"
        "\"     *.*         *.*     \", \n"
        "\"******.* ******* *.******\", \n"
        "\"*...........*...........*\", \n"
        "\"*.****.****.*.****.****.*\", \n"
        "\"*O...*.............*...O*\", \n"
        "\"****.*.*.*******.*.*.****\", \n"
        "\"*......*....*....*......*\", \n"
        "\"*.*********.*.*********.*\", \n"
        "\"*.......................*\", \n"
        "\"*************************\" \n"
        "} \n"
        " \n"
        "niveauH=#niveau \n"
        "niveauL=#niveau[1] \n"
        " \n"
        "function youwin() \n"
        "    niveau = { \n"
        "    \"O.O.O.O.O.O.O.O.O.O.O.O.O\", \n"
        "    \".                       .\", \n"
        "    \"O  *   *    ***   *  *  O\", \n"
        "    \".  *   *   *   *  *  *  .\", \n"
        "    \"O  *   *   *   *  *  *  O\", \n"
        "    \".   * *    *   *  *  *  .\", \n"
        "    \"O    *     *   *  *  *  O\", \n"
        "    \".    *     *   *  *  *  .\", \n"
        "    \"O    *     *   *  *  *  O\", \n"
        "    \".    *      ***    **   .\", \n"
        "    \"O                       O\", \n"
        "    \".                       .\", \n"
        "    \"O                       O\", \n"
        "    \".  * * *  ***  **    *  .\", \n"
        "    \"O  * * *   *   * *   *  O\", \n"
        "    \".  * * *   *   * *   *  .\", \n"
        "    \"O  * * *   *   *  *  *  O\", \n"
        "    \".  * * *   *   *  *  *  .\", \n"
        "    \"O  * * *   *   *   * *  O\", \n"
        "    \".  * * *   *   *   * *  .\", \n"
        "    \"O   ***   ***  *    **  O\", \n"
        "    \".                       .\", \n"
        "    \"O.O.O.O.O.O.O.O.O.O.O.O.O\" \n"
        "    } \n"
        "    niveauH=#niveau \n"
        "    niveauL=#niveau[1] \n"
        "    gameover=true \n"
        "end \n"
        " \n"
        "function youlose() \n"
        "    niveau = { \n"
        "    \"O.O.O.O.O.O.O.O.O.O.O.O.O\", \n"
        "    \".                       .\", \n"
        "    \"O       *********       O\", \n"
        "    \".      * ... ... *      .\", \n"
        "    \"O     *   O   O   *     O\", \n"
        "    \".    *             *    .\", \n"
        "    \"O    *  .       .  *    O\", \n"
        "    \".    *   .......   *    .\", \n"
        "    \"O    *             *    O\", \n"
        "    \".    * **  **  **  *    .\", \n"
        "    \"O    **  **  **  ***    O\", \n"
        "    \".                       .\", \n"
        "    \"O                       O\", \n"
        "    \".  ****    ***    ***   .\", \n"
        "    \"O  *   *  *   *  *   *  O\", \n"
        "    \".  *   *  *   *  *   *  .\", \n"
        "    \"O  ****   *   *  *   *  O\", \n"
        "    \".  *   *  *   *  *   *  .\", \n"
        "    \"O  *   *  *   *  *   *  O\", \n"
        "    \".  *   *  *   *  *   *  .\", \n"
        "    \"O  ****    ***    ***   O\", \n"
        "    \".                       .\", \n"
        "    \"O.O.O.O.O.O.O.O.O.O.O.O.O\" \n"
        "    } \n"
        "    niveauH=#niveau \n"
        "    niveauL=#niveau[1] \n"
        "    gameover=true \n"
        "end \n"
        " \n"
        " \n"
        "function getniveau(x,y) \n"
        "   return niveau[#niveau-y+1]:sub(x,x) \n"
        "end \n"
        " \n"
        "function setniveau(x,y,c) \n"
        "    local s = niveau[#niveau-y+1] \n"
        "    s = s:sub(1,x-1) .. c .. s:sub(x+1) \n"
        "    niveau[#niveau-y+1] = s \n"
        "end \n"
        " \n"
        "function nbballs() \n"
        "    local result = 0 \n"
        "    for y=1,niveauH,1 do \n"
        "	for x=1,niveauL,1 do \n"
        "	    if getniveau(x,y) == \".\" then \n"
        "		result = result + 1 \n"
        "	    end \n"
        "	end \n"
        "    end \n"
        "    return result \n"
        "end \n"
        " \n"
        "niveauBalls = nbballs() \n"
        " \n"
        "function terrain() \n"
        "   pixBegin() \n"
        "   col(\"blue\") \n"
        "   for y=1,niveauH,1 do \n"
        "      for x=1,niveauL,1 do \n"
        "	  if getniveau(x,y) == \"*\" then \n"
        "	      pix(x,y)	 \n"
        "	  end \n"
        "      end \n"
        "   end \n"
        "   pixEnd() \n"
        "   GLUP.SetColor(GLUP.FRONT_COLOR,\"white\") \n"
        "   local Rgum = ((GLUP.ElapsedTime()*5)%2)*0.2+0.1 \n"
        "   GLUP.Begin(GLUP.SPHERES) \n"
        "   for y=1,niveauH,1 do \n"
        "      for x=1,niveauL,1 do \n"
        "          local c = getniveau(x,y) \n"
        "	  if c == \".\" then \n"
        "	      GLUP.Vertex(x+0.5,y+0.5,0.5,0.2) \n"
        "	  elseif c == \"O\" then \n"
        "	      GLUP.Vertex(x+0.5,y+0.5,0.5,Rgum)	 \n"
        "	  end \n"
        "      end \n"
        "   end \n"
        "   GLUP.End() \n"
        "end \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,niveauH,niveauH,1) \n"
        "end \n"
        " \n"
        "function imgui.on_key_pressed(key) \n"
        "   frozen = false \n"
        "   if key == \"left\" then \n"
        "      newvx=-1 \n"
        "      newvy=0 \n"
        "   elseif key == \"right\" then \n"
        "      newvx=1 \n"
        "      newvy=0 \n"
        "   elseif key == \"up\" then \n"
        "      newvx=0 \n"
        "      newvy=1 \n"
        "   elseif key == \"down\" then \n"
        "      newvx=0 \n"
        "      newvy=-1 \n"
        "   end \n"
        "end \n"
        " \n"
        "function dessinjoueur(x,y,vx,vy) \n"
        "    GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "    GLUP.Begin(GLUP.SPHERES) \n"
        "    col(\"yellow\") \n"
        "    GLUP.Vertex(x+0.5, y+0.5, 0.5, 0.5) \n"
        "    col(\"white\") \n"
        "    GLUP.Vertex(x+0.35+0.25*vx, y+0.5+0.25*vy, 1.0, 0.15) \n"
        "    GLUP.Vertex(x+0.65+0.25*vx, y+0.5+0.25*vy, 1.0, 0.15) \n"
        "    col(\"black\") \n"
        "    GLUP.Vertex(x+0.35+0.27*vx, y+0.5+0.27*vy, 1.1, 0.1) \n"
        "    GLUP.Vertex(x+0.65+0.27*vx, y+0.5+0.27*vy, 1.1, 0.1) \n"
        "    GLUP.End() \n"
        "    GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "end \n"
        " \n"
        "function dessinfantome(x,y,vx,vy,c) \n"
        "    GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "    GLUP.Begin(GLUP.SPHERES) \n"
        "    if not eatenmode then \n"
        "        if gummode then \n"
        "	   col(\"blue\") \n"
        "	else \n"
        "	   col(c) \n"
        "        end \n"
        "        GLUP.Vertex(x+0.5, y+0.5, 0.5, 0.5) \n"
        "        for xx=x+0.2,x+0.8,0.3 do \n"
        "            GLUP.Vertex(xx,y+0.1,0.5,0.3) \n"
        "        end \n"
        "    end \n"
        "    col(\"white\") \n"
        "    GLUP.Vertex(x+0.35+0.3*vx, y+0.5+0.3*vy, 1.0, 0.15) \n"
        "    GLUP.Vertex(x+0.65+0.3*vx, y+0.5+0.3*vy, 1.0, 0.15) \n"
        "    if eatenmode or not gummode then \n"
        "        col(\"black\") \n"
        "    	GLUP.Vertex(x+0.35+0.32*vx, y+0.5+0.32*vy, 1.1, 0.1) \n"
        "        GLUP.Vertex(x+0.65+0.32*vx, y+0.5+0.32*vy, 1.1, 0.1) \n"
        "    end \n"
        "    GLUP.End() \n"
        "    GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "end \n"
        " \n"
        "function killed() \n"
        "   frozen=true \n"
        "   joueurx=13 \n"
        "   joueury=10 \n"
        "   vx=0 \n"
        "   vy=0 \n"
        "   newvx=0 \n"
        "   newvy=0 \n"
        "   lasttime=0 \n"
        "   lastfantomtime=0 \n"
        " \n"
        "   gumtime=0 \n"
        "   gummode=false \n"
        "   eatentime=0 \n"
        "   eatenmode=false \n"
        " \n"
        "   fantomx=13 \n"
        "   fantomy=15 \n"
        "   fantomvx=0 \n"
        "   fantomvy=1 \n"
        "   lives = lives - 1 \n"
        "   if lives == 0 then \n"
        "       youlose() \n"
        "   end \n"
        "end \n"
        " \n"
        "function collision(time) \n"
        "   if joueurx == fantomx and joueury == fantomy then \n"
        "      if gummode then \n"
        "          score = score + 100 \n"
        "          eatenmode = true \n"
        "          eatentime = time \n"
        "       elseif not eatenmode then \n"
        "          killed() \n"
        "       end \n"
        "   end \n"
        "end \n"
        " \n"
        "function joueur() \n"
        " \n"
        "    local time = GLUP.ElapsedTime() \n"
        " \n"
        "    if gummode then \n"
        "	if (time - gumtime) > 5 then \n"
        "	    gummode = false \n"
        "	end \n"
        "    end \n"
        " \n"
        "    if not frozen and time-lasttime > 0.075 then \n"
        "	lasttime = time \n"
        "	local newx,newy \n"
        "	newx = joueurx+newvx \n"
        "	newy = joueury+newvy \n"
        "	if newx < 1 then \n"
        "	    newx = niveauL \n"
        "        elseif newx > niveauL then \n"
        "	    newx = 1 \n"
        "	end \n"
        "	if newy < 1 then \n"
        "	    newy = niveauH \n"
        "        elseif newy > niveauH then \n"
        "	    newy = 1 \n"
        "	end \n"
        "	local c = getniveau(newx,newy) \n"
        "	if c == \" \" or c == \".\" or c == \"O\" then \n"
        "	    joueurx = newx \n"
        "	    joueury = newy \n"
        "	    vx = newvx \n"
        "	    vy = newvy \n"
        "        else \n"
        "	    newx = joueurx + vx \n"
        "	    newy = joueury + vy \n"
        "	    c = getniveau(newx,newy) \n"
        "	    if c == \" \" or c == \".\" or c == \"O\" then \n"
        "	        joueurx = newx \n"
        "		joueury = newy \n"
        "	    end \n"
        "	end \n"
        "	if c == \"O\" then \n"
        "	    gumtime = time \n"
        "	    gummode = true \n"
        "	    fantomvx = -fantomvx \n"
        "	    fantomvy = -fantomvy \n"
        "	elseif c == \".\" then \n"
        "	    score = score + 10 \n"
        "	    niveauBalls = niveauBalls - 1 \n"
        "	    if niveauBalls == 0 then \n"
        "		youwin() \n"
        "	    end \n"
        "	end \n"
        "	setniveau(joueurx, joueury, \" \") \n"
        "    end \n"
        "    collision(time) \n"
        "    dessinjoueur(joueurx,joueury,vx,vy) \n"
        "end \n"
        " \n"
        "function fantome() \n"
        "    local time = GLUP.ElapsedTime() \n"
        "    local delay = 0.1 \n"
        "    if gummode then \n"
        "       delay = 0.2 \n"
        "    end \n"
        "    if eatenmode and (time - eatentime) > 5 then \n"
        "       eatenmode = false \n"
        "    end \n"
        "    if not frozen and time-lastfantomtime > delay then \n"
        "	lastfantomtime = time \n"
        "        while getniveau(fantomx + fantomvx, fantomy + fantomvy) ~= \" \" do \n"
        "	   local v = math.random(1,4) \n"
        "	   if v == 1 then \n"
        "	      fantomvx = -1 \n"
        "	      fantomvy = 0 \n"
        "	   elseif v == 2 then \n"
        "	      fantomvx = 1 \n"
        "	      fantomvy = 0 \n"
        "	   elseif v == 3 then \n"
        "	      fantomvx = 0 \n"
        "	      fantomvy = -1 \n"
        "	   elseif v == 4 then \n"
        "	      fantomvx = 0 \n"
        "	      fantomvy = 1 \n"
        "	   end \n"
        "	end \n"
        "	fantomx = fantomx + fantomvx \n"
        "        fantomy = fantomy + fantomvy \n"
        "    end \n"
        "    collision(time) \n"
        "    dessinfantome(fantomx,fantomy,fantomvx,fantomvy,\"pink\") \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "   GLUP.Enable(GLUP.DRAW_MESH) \n"
        "   GLUP.SetColor(GLUP.MESH_COLOR, 0,0,0.5) \n"
        "   GLUP.SetMeshWidth(2) \n"
        "   terrain() \n"
        "   if not gameover then \n"
        "       joueur() \n"
        "       fantome() \n"
        "   end \n"
        "end \n"
        " \n"
        "function imgui.draw_object_properties() \n"
        "   imgui.Text(\"Level: \" .. level) \n"
        "   imgui.Text(\"Score: \" .. score) \n"
        "   imgui.Text(\"Lives: \" .. lives) \n"
        "end \n"
     );

     register_embedded_lua_file("games/labyrinthe.lua",
        "require(\"pixel\") \n"
        " \n"
        "-- Petit jeu de type Labyrinthe \n"
        "-- Par Laszlo Schaffer & Nathan Levy \n"
        " \n"
        "-- Definir la taille du terrain \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,21,21,1) \n"
        "end \n"
        " \n"
        "-- Est-ce que le joueur a les clefs ? \n"
        "joueurk=0 \n"
        "joueurb=0 \n"
        "joueurp=0 \n"
        "joueurr=0 \n"
        " \n"
        "-- Deplacement que le joueur veut faire \n"
        "dx=0 \n"
        "dy=0 \n"
        " \n"
        "-- Dernier moment ou on a appuye sur une touche \n"
        "last_time=0 \n"
        " \n"
        "-- Delai de repetition des touches \n"
        "delta_time=0.1 \n"
        " \n"
        "-- Temps de demarrage du programme \n"
        "init_time=GLUP.ElapsedTime() \n"
        " \n"
        "niv=0 \n"
        "niveau = {} \n"
        " \n"
        "function niveau1() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*              D  O*\", \n"
        "   \"* *********b********\", \n"
        "   \"* *     *   *****B**\", \n"
        "   \"* * *** * *     * **\", \n"
        "   \"* * *K* * ***** * **\", \n"
        "   \"* *   * *     * * **\", \n"
        "   \"* ***** * ***** * **\", \n"
        "   \"*       * *       **\", \n"
        "   \"*********r**********\", \n"
        "   \"**                 *\", \n"
        "   \"** *****************\", \n"
        "   \"*                  *\", \n"
        "   \"* **************** *\", \n"
        "   \"*  R*   p  *       *\", \n"
        "   \"***** **** *       *\", \n"
        "   \"*        * ******  *\", \n"
        "   \"* **** *** ****   **\", \n"
        "   \"* *P   *        ****\", \n"
        "   \"********************\" \n"
        "  } \n"
        "end \n"
        " \n"
        "function niveau2() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*        b         *\", \n"
        "   \"* **************** *\", \n"
        "   \"* *       D      * *\", \n"
        "   \"* * ************ * *\", \n"
        "   \"* * *    r     * * *\", \n"
        "   \"* * * ******** * *B*\", \n"
        "   \"* * * *      * * * *\", \n"
        "   \"* * * * xxxx * * * *\", \n"
        "   \"* * * * xO x * * * *\", \n"
        "   \"* * * *    x * * * *\", \n"
        "   \"* * * ****** * * * *\", \n"
        "   \"* * *        * * * *\", \n"
        "   \"* * ********** * * *\", \n"
        "   \"* *     R      * * *\", \n"
        "   \"* ************** * *\", \n"
        "   \"*      K         *p*\", \n"
        "   \"****************** *\", \n"
        "   \"* P                *\", \n"
        "   \"********************\" \n"
        "   } \n"
        "end \n"
        " \n"
        "function niveau3() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*O* * * * * * * * **\", \n"
        "   \"*D            x    *\", \n"
        "   \"*x*x*x*x*x*x* * * **\", \n"
        "   \"*             x x  *\", \n"
        "   \"*x* *x*x* *x* * * **\", \n"
        "   \"*   x   x xBx xKx  *\", \n"
        "   \"*b*x* * *x* * *x* **\", \n"
        "   \"*     x     x      *\", \n"
        "   \"*x*r*x*x*x*x*x*x*x**\", \n"
        "   \"*                  *\", \n"
        "   \"*x*x*x*p*x*x*x*x* **\", \n"
        "   \"*P      x      Rx  *\", \n"
        "   \"*x*x* *x* *x*x*x* **\", \n"
        "   \"*     x x          *\", \n"
        "   \"* * * * * * * * * **\", \n"
        "   \"********************\" \n"
        "   } \n"
        "end \n"
        " \n"
        "function niveau4() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*                  *\", \n"
        "   \"*  E            E  *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"*             O    *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"*     M N Q S      *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"*  E            E  *\", \n"
        "   \"*                  *\", \n"
        "   \"*                  *\", \n"
        "   \"********************\" \n"
        "   } \n"
        "end \n"
        " \n"
        "function niveau5() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*                  *\", \n"
        "   \"* xxxxxxxxxxxxxxxx *\", \n"
        "   \"* x       x      x *\", \n"
        "   \"* x xxxxxxx xxxx x *\", \n"
        "   \"* x x     x x    x *\", \n"
        "   \"* x   x x x x xxxx *\", \n"
        "   \"* xxxxx x   x    x *\", \n"
        "   \"* x      xxxxxxx x *\", \n"
        "   \"* x****xOxxx   x x *\", \n"
        "   \"*  *    x   *  * x *\", \n"
        "   \"*  *  x * x ** * x *\", \n"
        "   \"*  ** x * x * ** x *\", \n"
        "   \"*  *  x * x *  * x *\", \n"
        "   \"*    xx   x      x *\", \n"
        "   \"*xxxxxxxxxxxxxxxxx *\", \n"
        "   \"*                  *\", \n"
        "   \"********************\" \n"
        "   } \n"
        "end \n"
        " \n"
        "function niveau6() \n"
        "  niveau = { \n"
        "   \"********************\", \n"
        "   \"*                  *\", \n"
        "   \"*    ***  *****    *\", \n"
        "   \"*    *      *      *\", \n"
        "   \"*    **     *      *\", \n"
        "   \"*    *      *      *\", \n"
        "   \"*    ***    *      *\", \n"
        "   \"*                * *\", \n"
        "   \"* *  * *** *  *  * *\", \n"
        "   \"* ** * * * ** *  * *\", \n"
        "   \"* * ** * * * **    *\", \n"
        "   \"* *  * *** *  *  * *\", \n"
        "   \"*                  *\", \n"
        "   \"*  *    ***  *     *\", \n"
        "   \"*  *    * *  *     *\", \n"
        "   \"*  ***  ***  ***   *\", \n"
        "   \"********************\" \n"
        "   } \n"
        "end \n"
        " \n"
        "function niveausuivant() \n"
        "   niv = niv+1 \n"
        "   if niv == 1 then \n"
        "       niveau1() \n"
        "   end \n"
        " \n"
        "   if niv == 2 then \n"
        "       niveau2() \n"
        "   end \n"
        " \n"
        "   if niv == 3 then \n"
        "       niveau3() \n"
        "   end \n"
        " \n"
        "   if niv == 4 then \n"
        "       niveau4() \n"
        "   end \n"
        "   if niv == 5 then \n"
        "       niveau5() \n"
        "   end \n"
        "   if niv == 6 then \n"
        "       niveau6() \n"
        "   end \n"
        " \n"
        "   joueurk=0 \n"
        "   joueurb=0 \n"
        "   joueurp=0 \n"
        "   joueurr=0 \n"
        "   joueurx=2 \n"
        "   joueury=2 \n"
        "   niveauH=#niveau \n"
        "   niveauL=#niveau[1] \n"
        "end \n"
        " \n"
        "niveausuivant() \n"
        " \n"
        "function getniveau(x,y) \n"
        "   return niveau[#niveau-y+1]:sub(x,x) \n"
        "end \n"
        " \n"
        "function setniveau(x,y,c) \n"
        "    local s = niveau[#niveau-y+1] \n"
        "    s = s:sub(1,x-1) .. c .. s:sub(x+1) \n"
        "    niveau[#niveau-y+1] = s \n"
        "end \n"
        " \n"
        "function line(x1,x2,y) \n"
        "   for x=x1,x2 do \n"
        "      pix3d(x,y,-1) \n"
        "   end \n"
        " \n"
        "end \n"
        " \n"
        "function dessinekey(x,y,couleur) \n"
        "   GLUP.PushMatrix() \n"
        "   GLUP.Translate(x+0.5,y+0.5,0.5) \n"
        "   local alpha = (GLUP.ElapsedTime() - init_time)*200.0 \n"
        "   GLUP.Rotate(alpha,1,1,1) \n"
        "   GLUP.Scale(0.7,0.7,0.7) \n"
        "   GLUP.Translate(-0.5,-0.5,0) \n"
        "   GLUP.SetColor(GLUP.FRONT_COLOR,couleur) \n"
        "   GLUP.Begin(GLUP.SPHERES) \n"
        "   GLUP.Vertex(0.5, 0.65, 0, 0.25) \n"
        "   GLUP.End() \n"
        "   GLUP.SetColor(GLUP.MESH_COLOR,couleur) \n"
        "   GLUP.Begin(GLUP.LINES) \n"
        "   GLUP.Vertex(0.5,  0.5,  0) \n"
        "   GLUP.Vertex(0.5,  0,    0) \n"
        "   GLUP.Vertex(0.5,  0,    0) \n"
        "   GLUP.Vertex(0.75, 0,    0) \n"
        "   GLUP.Vertex(0.5,  0.25, 0) \n"
        "   GLUP.Vertex(0.75, 0.25, 0) \n"
        "   GLUP.End() \n"
        "   GLUP.PopMatrix() \n"
        "end \n"
        " \n"
        "function dessineporte(x,y,couleur) \n"
        "   pixBegin() \n"
        "   col(couleur) \n"
        "   pix(x,y) \n"
        "   pixEnd() \n"
        "end \n"
        " \n"
        "function dessineEpee(x,y) \n"
        "   GLUP.PushMatrix() \n"
        "   GLUP.Translate(x-0.1,y-0.1,0.5) \n"
        "   GLUP.Scale(0.1,0.1,0.1) \n"
        " \n"
        "   GLUP.Translate(0.5,0.5,0.5) \n"
        "   local alpha = (GLUP.ElapsedTime() - init_time)*200.0 \n"
        "   GLUP.Rotate(alpha,1,1,0) \n"
        "   GLUP.Translate(-0.5,-0.5,-0.5) \n"
        " \n"
        "   pixBegin() \n"
        "   col(\"gray\") \n"
        "   for i=1,10 do \n"
        "      pix(i,i) \n"
        "   end \n"
        "   col(\"white\") \n"
        "   for i=3,9 do \n"
        "      pix(i,i+1) \n"
        "   end \n"
        "   col(\"black\") \n"
        "   for i=4,10 do \n"
        "      pix(i,i-1) \n"
        "   end \n"
        "   pix(2,3) \n"
        "   pix(1,4) \n"
        "   pix(3,2) \n"
        "   pix(4,1) \n"
        "   pixEnd() \n"
        "   GLUP.PopMatrix() \n"
        "end \n"
        " \n"
        "function dessineFantome(x,y,c) \n"
        "    vx = (joueurx - x) / 10.0 \n"
        "    vy = (joueury - y) / 10.0 \n"
        "    GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "    GLUP.Begin(GLUP.SPHERES) \n"
        "    col(c) \n"
        "    GLUP.Vertex(x+0.5, y+0.5, 0.5, 0.5) \n"
        "    for xx=x+0.2,x+0.8,0.3 do \n"
        "        GLUP.Vertex(xx,y+0.1,0.5,0.3) \n"
        "    end \n"
        "    col(\"white\") \n"
        "    GLUP.Vertex(x+0.35+0.3*vx, y+0.5+0.3*vy, 1.0, 0.15) \n"
        "    GLUP.Vertex(x+0.65+0.3*vx, y+0.5+0.3*vy, 1.0, 0.15) \n"
        "    col(\"black\") \n"
        "    GLUP.Vertex(x+0.35+0.32*vx, y+0.5+0.32*vy, 1.1, 0.1) \n"
        "    GLUP.Vertex(x+0.65+0.32*vx, y+0.5+0.32*vy, 1.1, 0.1) \n"
        "    GLUP.End() \n"
        "    GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "end \n"
        " \n"
        " \n"
        "function dessineniveau() \n"
        "    GLUP.Disable(GLUP.DRAW_MESH) \n"
        "    GLUP.SetCellsShrink(0) \n"
        " \n"
        "    -- pixGrid() \n"
        " \n"
        "    -- dessin du terrain et des blocs verts \n"
        " \n"
        "    pixBegin() \n"
        "    col(\"green\") \n"
        " \n"
        "    for y=1,niveauH do \n"
        "       line(1,niveauL,y) \n"
        "    end \n"
        " \n"
        "   for y=1,niveauH do \n"
        "      for x=1, niveauL do \n"
        "         -- regarder ce qu'il y a dans la case x,y \n"
        "         local c = getniveau(x,y) \n"
        "         if c == '*' then \n"
        "             GLUP.Color(0,0.5,0) \n"
        "             pix(x,y) \n"
        "         end \n"
        " \n"
        "         if c == 'O' then \n"
        "            col(\"yellow\") \n"
        "            pix(x,y) \n"
        "         end \n"
        " \n"
        "       end \n"
        "   end \n"
        " \n"
        "   pixEnd() \n"
        " \n"
        "   -- dessins des autres objets (clefs et portes) \n"
        " \n"
        "   for y=1,niveauH do \n"
        "      for x=1, niveauH do \n"
        "         -- regarder ce qu'il y a dans la case x,y \n"
        "         local c = getniveau(x,y) \n"
        "         if c == 'K' then \n"
        "            dessinekey(x,y,\"red\") \n"
        "         end \n"
        " \n"
        "         if c == 'B' then \n"
        "            dessinekey(x,y,\"blue\") \n"
        "         end \n"
        " \n"
        "         if c == 'P' then \n"
        "            dessinekey(x,y,\"black\") \n"
        "         end \n"
        " \n"
        "         if c == 'R' then \n"
        "            dessinekey(x,y,\"pink\") \n"
        "         end \n"
        " \n"
        "         if c == 'D' then \n"
        "            dessineporte(x,y,\"red\") \n"
        "         end \n"
        " \n"
        "         if c == 'b' then \n"
        "            dessineporte(x,y,\"blue\") \n"
        "         end \n"
        " \n"
        "         if c == 'p' then \n"
        "            dessineporte(x,y,\"black\") \n"
        "         end \n"
        " \n"
        "         if c == 'r' then \n"
        "            dessineporte(x,y,\"pink\") \n"
        "         end \n"
        " \n"
        "         if c == 'E' then \n"
        "	    dessineEpee(x,y) \n"
        "	 end \n"
        " \n"
        "         if c == 'M' then \n"
        "	    dessineFantome(x,y,\"red\") \n"
        "	 end \n"
        " \n"
        "         if c == 'N' then \n"
        "	    dessineFantome(x,y,\"blue\") \n"
        "	 end \n"
        " \n"
        "         if c == 'Q' then \n"
        "	    dessineFantome(x,y,\"pink\") \n"
        "	 end \n"
        " \n"
        "         if c == 'S' then \n"
        "	    dessineFantome(x,y,\"yellow\")	 \n"
        "	 end \n"
        " \n"
        " \n"
        "      end \n"
        " \n"
        "   end \n"
        " \n"
        "end \n"
        " \n"
        "-- parametres: x,y = la ou on veut dessiner le \"pacman\" \n"
        "--             vx,vy = direction vers ou le pacman regarde \n"
        "function pacman(x,y,vx,vy) \n"
        "    GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "    GLUP.Begin(GLUP.SPHERES) \n"
        "    col(\"yellow\") \n"
        "    GLUP.Vertex(x+0.5, y+0.5, 0.5, 0.5) \n"
        "    col(\"white\") \n"
        "    GLUP.Vertex(x+0.35+0.25*vx, y+0.5+0.25*vy, 1.0, 0.15) \n"
        "    GLUP.Vertex(x+0.65+0.25*vx, y+0.5+0.25*vy, 1.0, 0.15) \n"
        "    col(\"black\") \n"
        "    GLUP.Vertex(x+0.35+0.27*vx, y+0.5+0.27*vy, 1.1, 0.1) \n"
        "    GLUP.Vertex(x+0.65+0.27*vx, y+0.5+0.27*vy, 1.1, 0.1) \n"
        "    GLUP.End() \n"
        "    GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "end \n"
        " \n"
        "function inventaire() \n"
        "    pixBegin() \n"
        "    col(\"gray\") \n"
        "    pix(1,-1) \n"
        "    pix(2,-1) \n"
        "    pix(0,-1) \n"
        "    pix(0,-2) \n"
        "    pix(2,-2) \n"
        "    pix(2,-3) \n"
        "    pix(0,-3) \n"
        "    pix(1,-3) \n"
        "    pix(3,-3) \n"
        "    pix(4,-3) \n"
        "    pix(4,-2) \n"
        "    pix(4,-1) \n"
        "    pix(3,-1) \n"
        "    pix(2,-1) \n"
        "    pix(5,-3) \n"
        "    pix(6,-3) \n"
        "    pix(6,-2) \n"
        "    pix(6,-1) \n"
        "    pix(5,-1) \n"
        "    pix(7,-1) \n"
        "    pix(8,-1) \n"
        "    pix(8,-2) \n"
        "    pix(8,-3) \n"
        "    pix(7,-3) \n"
        " \n"
        "    pixEnd() \n"
        " \n"
        "   if joueurk == 1 then \n"
        "      dessinekey(7,-2,\"red\") \n"
        "   end \n"
        " \n"
        "   if joueurb == 1 then \n"
        "      dessinekey(5,-2,\"blue\") \n"
        "   end \n"
        " \n"
        "   if joueurp == 1 then \n"
        "      dessinekey(1,-2,\"black\") \n"
        "   end \n"
        " \n"
        "   if joueurr == 1 then \n"
        "      dessinekey(3,-2,\"pink\") \n"
        "   end \n"
        " \n"
        "end \n"
        " \n"
        "function imgui.on_key_pressed(k) \n"
        "  last_time = GLUP.ElapsedTime() - delta_time \n"
        "  dx = 0 \n"
        "  dy = 0 \n"
        " \n"
        "  if k == \"left\" then \n"
        "     dx = -1 \n"
        "     dy = 0 \n"
        "  end \n"
        " \n"
        "  if k == \"right\" then \n"
        "     dx = 1 \n"
        "     dy = 0 \n"
        "  end \n"
        " \n"
        "  if k == \"up\" then \n"
        "     dx = 0 \n"
        "     dy = 1 \n"
        "  end \n"
        " \n"
        "  if k == \"down\" then \n"
        "     dx = 0 \n"
        "     dy = -1 \n"
        "  end \n"
        " \n"
        "end \n"
        " \n"
        "function imgui.on_key_released(k) \n"
        "   dx = 0 \n"
        "   dy = 0 \n"
        "end \n"
        " \n"
        "function player_move(dx, dy) \n"
        "  -- regarder ce qu il y a la ou on veut aller \n"
        "  local c = getniveau(joueurx+dx, joueury+dy) \n"
        "  if c == \" \" then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "  end \n"
        " \n"
        "  if c == 'K' then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "     joueurk=1 \n"
        "  end \n"
        " \n"
        "  if c == 'B' then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "     joueurb=1 \n"
        "  end \n"
        " \n"
        "  if c == 'R' then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "     joueurr=1 \n"
        "  end \n"
        " \n"
        "  if c == 'P' then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "     joueurp=1 \n"
        "  end \n"
        " \n"
        "  if c == 'D' and joueurk == 1 then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "  end \n"
        " \n"
        "  if c == 'b' and joueurb == 1 then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "  end \n"
        " \n"
        "  if c == 'p' and joueurp == 1 then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "  end \n"
        " \n"
        "  if c == 'r' and joueurr == 1 then \n"
        "     joueurx = joueurx + dx \n"
        "     joueury = joueury + dy \n"
        "     setniveau(joueurx,joueury,' ') \n"
        "  end \n"
        " \n"
        "  if c == 'O' then \n"
        "     niveausuivant() \n"
        "  end \n"
        " \n"
        "end \n"
        " \n"
        "function player_update() \n"
        "   local t = GLUP.ElapsedTime() \n"
        "   if t - last_time > delta_time then \n"
        "      last_time = t \n"
        "      player_move(dx,dy) \n"
        "   end \n"
        "end \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "    dessineniveau() \n"
        "    pacman(joueurx,joueury,dx,dy) \n"
        "    player_update() \n"
        "    inventaire() \n"
        "end \n"
     );

     register_embedded_lua_file("games/asteroids.lua",
        " \n"
        "require(\"pixel\") \n"
        " \n"
        "-- EN A simple scrolling shoot-em-up \n"
        "-- EN Collect the yellow ones, avoid the red ones \n"
        "-- FR Un jeu de tir a deplacement vertical \n"
        "-- FR Prenez les jaunes, evitez les rouges. \n"
        " \n"
        "niveau = { \n"
        "     \"...................\", \n"
        "     \". ... .. ... . .. *\", \n"
        "     \" . .. .  . . .  .  \", \n"
        "     \" .  .  .   .  .  . \", \n"
        "     \"      .       .    \", \n"
        "     \"   .   .   .   .   \", \n"
        "     \"                   \", \n"
        "     \"                   \", \n"
        "     \"                   \", \n"
        "     \"                   \", \n"
        "     \"     -     -       \", \n"
        "     \"   / |`  / |`      \", \n"
        "     \"   | | | | | |     \", \n"
        "     \"   | | | | | |     \", \n"
        "     \"   | | | - | |     \", \n"
        "     \"   | | | | | |     \" \n"
        "} \n"
        " \n"
        "game = true \n"
        " \n"
        "niveauH=#niveau \n"
        "niveauL=#niveau[1] \n"
        " \n"
        "level=1 \n"
        "score=0 \n"
        "lives=1 \n"
        "delay=0.1 \n"
        "started = false \n"
        "thrust = false \n"
        "laser = false \n"
        " \n"
        "function imgui.draw_object_properties() \n"
        "   imgui.Text(\"Level: \" .. level) \n"
        "   imgui.Text(\"Score: \" .. score) \n"
        "   imgui.Text(\"Lives: \" .. lives) \n"
        "end \n"
        " \n"
        " \n"
        "function gameover() \n"
        "   game = false \n"
        "   niveau = { \n"
        "     \"|||||||||||||||||||\", \n"
        "     \" ... .. . .. ... . \", \n"
        "     \" OO         . ..   \", \n"
        "     \"O     OOO OOOOO OOO\", \n"
        "     \"O OO  O O O O O OO \", \n"
        "     \"O  O  OOO O   O O  \", \n"
        "     \" OOO  O O O   O OOO\", \n"
        "     \" .     . ... .     \", \n"
        "     \"  OO .         . . \", \n"
        "     \" O..O O O OOO OOO  \", \n"
        "     \" O .O O O OO  O O  \", \n"
        "     \" O. O O O O . OO   \", \n"
        "     \"  OO   O .OOO O O  \", \n"
        "     \" .. . ... ... . .. \", \n"
        "     \"|||||||||||||||||||\" \n"
        "   } \n"
        "   niveauH=#niveau \n"
        "   niveauL=#niveau[1] \n"
        "end \n"
        " \n"
        " \n"
        " \n"
        "function avance() \n"
        "   if not started then \n"
        "      return \n"
        "   end \n"
        "   for y=niveauH-1,1,-1 do \n"
        "      niveau[y+1] = niveau[y] \n"
        "   end \n"
        "   for x=1,niveauL do \n"
        "      local rnd = math.random(1,niveauL) \n"
        "      if rnd == 1 then \n"
        "          setniveau(x,niveauH,'O') \n"
        "      elseif rnd == 2 then \n"
        "          setniveau(x,niveauH,'*') \n"
        "      elseif rnd < 4 then \n"
        "          setniveau(x,niveauH,'.') \n"
        "      elseif rnd < 8 then \n"
        "          setniveau(x,niveauH,'o') \n"
        "      else \n"
        "          setniveau(x,niveauH,' ') \n"
        "      end \n"
        "      score=score+1 \n"
        "   end \n"
        "end \n"
        " \n"
        "function getniveau(x,y) \n"
        "   return niveau[#niveau-y+1]:sub(x,x) \n"
        "end \n"
        " \n"
        "function setniveau(x,y,c) \n"
        "    local s = niveau[#niveau-y+1] \n"
        "    s = s:sub(1,x-1) .. c .. s:sub(x+1) \n"
        "    niveau[#niveau-y+1] = s \n"
        "end \n"
        " \n"
        "function etoile(x,y,dx,dy) \n"
        "   GLUP.Color(\"white\") \n"
        "   GLUP.Vertex(x+0.5+dx, y+0.5+dy, 0.0, 0.1) \n"
        "end \n"
        " \n"
        "function asteroide(x,y,coul) \n"
        "   GLUP.Color(coul) \n"
        "   GLUP.Vertex(x+0.5, y+0.5, 0.0, 0.45) \n"
        "   GLUP.Vertex(x+0.8, y+0.8, 0.0, 0.1) \n"
        "   GLUP.Vertex(x+0.2, y+0.5, 0.3, 0.1) \n"
        "   GLUP.Vertex(x+0.7, y+0.4, 0.3, 0.1) \n"
        "end \n"
        " \n"
        " \n"
        "function barre(x,y,c) \n"
        "    GLUP.Color(\"green\") \n"
        "    if c == '|' then \n"
        "       GLUP.Vertex(x+0.5, y,      0, 0.1) \n"
        "       GLUP.Vertex(x+0.5, y+0.25, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.5, y+0.5,  0, 0.1) \n"
        "       GLUP.Vertex(x+0.5, y+0.75, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.5, y+1   , 0, 0.1) \n"
        "    elseif c == '-' then \n"
        "       GLUP.Vertex(x,      y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.25, y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.5,  y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.75, y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+1,    y+0.5, 0, 0.1) \n"
        "    elseif c == '/' then \n"
        "       GLUP.Vertex(x+0.75,  y+0.25, 0, 0.1) \n"
        "       GLUP.Vertex(x+1, y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+1.25,    y+0.75, 0, 0.1) \n"
        "       GLUP.Vertex(x+1.5, y+1, 0, 0.1) \n"
        "       GLUP.Vertex(x+1.75,  y+1.25, 0, 0.1) \n"
        "    elseif c == '`' then \n"
        "       GLUP.Vertex(x+0.25, y+1.25, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.5,  y+1, 0, 0.1) \n"
        "       GLUP.Vertex(x+0.75, y+0.75, 0, 0.1) \n"
        "       GLUP.Vertex(x+1,    y+0.5, 0, 0.1) \n"
        "       GLUP.Vertex(x+1.25, y+0.25, 0, 0.1) \n"
        "    end \n"
        "end \n"
        " \n"
        "function dessine_niveau() \n"
        "   GLUP.PushMatrix() \n"
        "   if game and started then \n"
        "      GLUP.Translate(0,-(GLUP.ElapsedTime()-t0)/delay,0) \n"
        "   end \n"
        "-- pixGrid() \n"
        "   GLUP.Enable(GLUP.VERTEX_COLORS) \n"
        "   GLUP.Begin(GLUP.SPHERES) \n"
        "   for y = 1,niveauH do \n"
        "      for x = 1,niveauL do \n"
        "         local c = getniveau(x,y) \n"
        "         if c == '.' then \n"
        "            etoile(x,y, 0, 0) \n"
        "         elseif c == 'o' then \n"
        "            etoile(x,y, -0.1, 0.2) \n"
        "         elseif c == 'O' then \n"
        "            asteroide(x,y,\"red\") \n"
        "         elseif c == '*' then \n"
        "            asteroide(x,y,\"yellow\") \n"
        "         else \n"
        "            barre(x,y,c) \n"
        "         end \n"
        "      end \n"
        "   end \n"
        "   GLUP.Disable(GLUP.VERTEX_COLORS) \n"
        "   GLUP.End() \n"
        "   GLUP.PopMatrix() \n"
        "   pixBegin() \n"
        "   col(\"blue\") \n"
        "   for x=1,niveauL do \n"
        "      pix(x,0,0) \n"
        "      pix(x,niveauH,0) \n"
        "   end \n"
        "   pixEnd() \n"
        "end \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.ArcadeStyle() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,niveauL+1,niveauH+1,1) \n"
        "end \n"
        " \n"
        "function fusee(x,y) \n"
        "   GLUP.PushMatrix() \n"
        " \n"
        "   GLUP.Translate(x+0.5, y+0.5, 0) \n"
        "   GLUP.Scale(1.0/5.0, 1.0/5.0, 1.0/5.0) \n"
        "   if started then \n"
        "      local alpha = (GLUP.ElapsedTime() - torigin) * 200.0 \n"
        "      GLUP.Rotate(alpha, 0, 1, 0) \n"
        "   end \n"
        "   GLUP.Translate(-3.5, -4.5, -0.5) \n"
        "   pixBegin() \n"
        "   col(\"black\") \n"
        "   pix(1,1) \n"
        "   pix(1,2) \n"
        "   pix(3,1) \n"
        "   pix(3,2) \n"
        "   pix(5,1) \n"
        "   pix(5,2) \n"
        " \n"
        "   col(\"red\") \n"
        "   pix(2,3) \n"
        "   pix(4,3) \n"
        "   pix(3,4) \n"
        "   pix(2,5) \n"
        "   pix(4,5) \n"
        " \n"
        "   col(\"white\") \n"
        "   pix(2,2) \n"
        "   pix(4,2) \n"
        "   pix(3,3) \n"
        "   pix(2,4) \n"
        "   pix(4,4) \n"
        "   pix(3,5) \n"
        "   pix(2,6) \n"
        "   pix(3,6) \n"
        "   pix(4,6) \n"
        "   pix(3,7) \n"
        "   pix(3,8) \n"
        " \n"
        "   if thrust then \n"
        "      col(\"yellow\") \n"
        "      pix(3,-1) \n"
        "      pix(3,-2) \n"
        "   end \n"
        " \n"
        "   if laser then \n"
        "      col(\"red\") \n"
        "      pix(3,10) \n"
        "      pix(3,11) \n"
        "      col(\"yellow\") \n"
        "      pix(3,12) \n"
        "      col(\"white\") \n"
        "      pix(3,13) \n"
        " \n"
        "      for y = 15,5*(niveauH-joueury+1),2 do \n"
        "         pix(3,y) \n"
        "      end \n"
        "   end \n"
        " \n"
        "   pixEnd() \n"
        "   GLUP.PopMatrix() \n"
        "end \n"
        " \n"
        "joueurx = math.floor(niveauL/2) \n"
        "joueury = 1 \n"
        " \n"
        "function imgui.on_key_pressed(k) \n"
        "   started = true \n"
        "   if k == \"left\" and joueurx > 1 then \n"
        "        joueurx = joueurx - 1 \n"
        "   end \n"
        "   if k == \"right\" and joueurx < niveauL then \n"
        "        joueurx = joueurx + 1 \n"
        "   end \n"
        "   if k == \"up\" and joueury < niveauH-1 then \n"
        "        joueury = joueury + 1 \n"
        "        thrust = true \n"
        "   end \n"
        "   if k == \"down\" and joueury > 1 then \n"
        "        joueury = joueury - 1 \n"
        "   end \n"
        "   if k == \" \" then \n"
        "      laser = true \n"
        "       for y=joueury,niveauH do \n"
        "          setniveau(joueurx,y,' ') \n"
        "       end \n"
        "   end \n"
        "end \n"
        " \n"
        "function imgui.on_key_released() \n"
        "   thrust = false \n"
        "   laser = false \n"
        "end \n"
        " \n"
        "t0 = GLUP.ElapsedTime() \n"
        "torigin = t0 \n"
        " \n"
        "function GLUP.draw_scene() \n"
        "-- pixGrid() \n"
        "   GLUP.Enable(GLUP.LIGHTING) \n"
        "   GLUP.Disable(GLUP.DRAW_MESH) \n"
        "   GLUP.SetCellsShrink(0) \n"
        "   dessine_niveau() \n"
        "   if game then \n"
        "      fusee(joueurx,joueury) \n"
        "      local c = getniveau(joueurx,joueury) \n"
        "      if c == 'O' or c == '|' or c == '-' or c == '/' or c == '`' then \n"
        "         gameover() \n"
        "      elseif getniveau(joueurx,joueury) == '*' then \n"
        "         score = score + 100 \n"
        "         setniveau(joueurx, joueury, ' ') \n"
        "      else \n"
        "         local t = GLUP.ElapsedTime() \n"
        "         if t - t0 > delay then \n"
        "            t0 = t \n"
        "            avance() \n"
        "         end \n"
        "      end \n"
        "   end \n"
        "end \n"
     );

     register_embedded_lua_file("games/invaders.lua",
        "require(\"pixel\") \n"
        " \n"
        "-- Simple Space Invaders game \n"
        "-- By Alicia Levy \n"
        " \n"
        "function GLUP.init_graphics() \n"
        "   GLUP.SetRegionOfInterest(1,1,1,11,11,1) \n"
        "end \n"
        " \n"
        "oldtime=GLUP.ElapsedTime() \n"
        " \n"
        "x=5 \n"
        "y=1 \n"
        "missile=false \n"
        "missileX=x \n"
        "missileY=y+1 \n"
        " \n"
        "alien=true \n"
        "alienTime=0 \n"
        "alienX=5 \n"
        "alienY=10 \n"
        " \n"
        "extra=true \n"
        "extraTime=0 \n"
        "extraX=5 \n"
        "extraY=9 \n"
        " \n"
        "function animate() \n"
        " \n"
        "  alienTime=alienTime+1 \n"
        "   if alienTime==4 then \n"
        "     alienTime=0 \n"
        "   end \n"
        " \n"
        "  extraTime=extraTime+1 \n"
        "   if extraTime==2 then \n"
        "     extraTime=0 \n"
        "   end \n"
        " \n"
        "  if missile then \n"
        "   missileY=missileY+1 \n"
        "  end \n"
        " \n"
        " if alienTime==0 then \n"
        "    alienX=alienX+1 \n"
        "    if alienX==11 then \n"
        "     alienX=1 \n"
        "    end \n"
        "  end \n"
        " \n"
        " if extraTime==0 then \n"
        "    extraX=extraX-1 \n"
        "    if extraX==0 then \n"
        "     extraX=10 \n"
        "    end \n"
        "  end \n"
        "end \n"
        " \n"
        "function imgui.on_key_pressed(k) \n"
        "   if k=='right' then \n"
        "      x=x+1 \n"
        "   end \n"
        "   if k=='left' then \n"
        "      x=x-1 \n"
        "   end \n"
        "   if k=='up' and not missile then \n"
        "      missileY=2 \n"
        "      missileX=x \n"
        "      missile=true \n"
        "     end \n"
        "end \n"
        " \n"
        "function Missile(x,y) \n"
        "   GLUP.Begin(GLUP.SPHERES) \n"
        "      GLUP.Vertex(x+0.5, y+0.5, 0.0, 0.1) \n"
        "   GLUP.End() \n"
        "end \n"
        " \n"
        "function Rocket(x,y) \n"
        "    GLUP.PushMatrix() \n"
        "    GLUP.Translate(x+2.0/9.0,y,0) \n"
        "    GLUP.Scale(1.0/9.0, 1.0/7.0, 0.3) \n"
        "    x=0 \n"
        "    y=0 \n"
        "    pixBegin() \n"
        "    col(\"black\") \n"
        "    pix(x,y) \n"
        "    pix(x,y+1) \n"
        "    pix(x,y+2) \n"
        "    pix(x+4,y) \n"
        "    pix(x+4,y+1) \n"
        "    pix(x+4,y+2) \n"
        "    pix(x+1,y+1) \n"
        "    pix(x+2,y+1) \n"
        "    pix(x+3,y+1) \n"
        "    pix(x+1,y+2) \n"
        "    pix(x+2,y+2) \n"
        "    pix(x+3,y+2) \n"
        "    pix(x+1,y+3) \n"
        "    pix(x+2,y+3) \n"
        "    pix(x+3,y+3) \n"
        "    pix(x+1,y+4) \n"
        "    pix(x+2,y+4) \n"
        "    pix(x+3,y+4) \n"
        "    pix(x+1,y+5) \n"
        "    pix(x+2,y+5) \n"
        "    pix(x+3,y+5) \n"
        "    pix(x+2,y+6) \n"
        "    pix(x+2,y+7) \n"
        "    pixEnd() \n"
        "    GLUP.PopMatrix() \n"
        "end \n"
        " \n"
        "function Alien(x,y,color) \n"
        "    GLUP.PushMatrix() \n"
        "    GLUP.Translate(x,y,0) \n"
        "    GLUP.Scale(1.0/9.0, 1.0/7.0, 0.3) \n"
        "    x=0 \n"
        "    y=0 \n"
        "    pixBegin() \n"
        "    col(color) \n"
        "    pix(x,y) \n"
        "    pix(x,y+1) \n"
        "    pix(x+1,y+2) \n"
        "    pix(x+2,y+2) \n"
        "    pix(x+2,y+1) \n"
        "    pix(x+3,y) \n"
        "    pix(x+5,y+2) \n"
        "    pix(x+4,y+2) \n"
        "    pix(x+3,y+2) \n"
        "    pix(x+6,y+2) \n"
        "    pix(x+6,y+1) \n"
        "    pix(x+5,y) \n"
        "    pix(x+7,y+2) \n"
        "    pix(x+8,y+1) \n"
        "    pix(x+8,y) \n"
        "    pix(x+1,y+3) \n"
        "    pix(x+2,y+4) \n"
        "    pix(x+3,y+4) \n"
        "    pix(x+4,y+4) \n"
        "    pix(x+5,y+4) \n"
        "    pix(x+6,y+4) \n"
        "    pix(x+7,y+3) \n"
        "    pix(x+3,y+3) \n"
        "    pix(x+4,y+3) \n"
        "    pix(x+5,y+3) \n"
        "    pix(x+2,y+5) \n"
        "    pix(x+1,y+6) \n"
        "    pix(x+6,y+5) \n"
        "    pix(x+7,y+6) \n"
        "    pixEnd() \n"
        "    GLUP.PopMatrix() \n"
        "end \n"
        " \n"
        " \n"
        "function GLUP.draw_scene() \n"
        " \n"
        "    GLUP.Enable(GLUP.DRAW_MESH) \n"
        "    GLUP.SetCellsShrink(0.1) \n"
        "    pixGrid() \n"
        " \n"
        "    Rocket(x,y) \n"
        " \n"
        "    if alien==true then \n"
        "       Alien(alienX,alienY,\"blue\") \n"
        "    end \n"
        " \n"
        "    if extra==true then \n"
        "       Alien(extraX,extraY,\"red\") \n"
        "    end \n"
        " \n"
        "    if GLUP.ElapsedTime()-oldtime>0.025 then \n"
        "       oldtime=GLUP.ElapsedTime() \n"
        "       animate() \n"
        "    end \n"
        " \n"
        "    if missileY>10 then \n"
        "       missile=false \n"
        "    end \n"
        " \n"
        "    if missile then \n"
        "       Missile(missileX,missileY) \n"
        "    end \n"
        " \n"
        "    if missileX==alienX and missileY==alienY then \n"
        "       alien=false \n"
        "    end \n"
        " \n"
        "    if missileX==extraX and missileY==extraY then \n"
        "       extra=false \n"
        "    end \n"
        "end \n"
        " \n"
     );

     register_embedded_lua_file("book/S01E01.lua",
        "-- FR Repare la fusee de Shift et Tab en utilisant pix et col \n"
        "-- EN Repair Shift and Tab's rocket by using pix and col \n"
        " \n"
        "require(\"pixel\") \n"
        " \n"
        "function GLUP.draw_scene() \n"
        " \n"
        "   -- FR Pour afficher les aretes des pixels \n"
        "   -- EN To display the edges of the pixels \n"
        "   GLUP.Enable(GLUP.DRAW_MESH) \n"
        " \n"
        "   -- FR Rend les pixels un peu plus petits \n"
        "   -- EN Makes the pixels a little bit smaller \n"
        "   GLUP.SetCellsShrink(0.1) \n"
        " \n"
        "   -- FR Affiche une grille pour mieux reperer les pixels \n"
        "   -- EN Displays a grid to help locating pixels \n"
        "   pixGrid() \n"
        " \n"
        "   pixBegin() \n"
        "   col(\"black\") \n"
        "   pix(1,1) \n"
        "   pix(1,2) \n"
        "   pix(3,1) \n"
        "   pix(3,2) \n"
        "   pix(5,2) \n"
        " \n"
        "   col(\"white\") \n"
        "   pix(2,2) \n"
        "   pix(4,2) \n"
        " \n"
        "   col(\"red\") \n"
        "   pix(2,3) \n"
        "   pix(3,4) \n"
        "   pix(2,5) \n"
        " \n"
        "   col(\"white\") \n"
        "   pix(3,3) \n"
        "   pix(2,4) \n"
        " \n"
        "   pixEnd() \n"
        "end \n"
     );

     register_embedded_lua_file("book/S01E02.lua",
        "-- FR Fais decoller la fusee de Shift et Tab \n"
        "-- EN Launch Shift and Tab's rocket \n"
        " \n"
        "require(\"pixel\") \n"
        " \n"
        "function GLUP.draw_scene() \n"
        " \n"
        "   -- FR Pour afficher les aretes des pixels \n"
        "   -- EN To display the edges of the pixels \n"
        "   GLUP.Enable(GLUP.DRAW_MESH) \n"
        " \n"
        "   -- FR Rend les pixels un peu plus petits \n"
        "   -- EN Makes the pixels a little bit smaller \n"
        "   GLUP.SetCellsShrink(0.1) \n"
        " \n"
        "   -- FR Affiche une grille pour mieux reperer les pixels \n"
        "   -- EN Displays a grid to help locating pixels \n"
        "   pixGrid() \n"
        " \n"
        "   pixBegin() \n"
        "   col(\"black\") \n"
        "   pix(1,1) \n"
        "   pix(1,2) \n"
        "   pix(3,1) \n"
        "   pix(3,2) \n"
        "   pix(5,1) \n"
        "   pix(5,2) \n"
        " \n"
        "   col(\"white\") \n"
        "   pix(2,2) \n"
        "   pix(4,2) \n"
        " \n"
        "   col(\"red\") \n"
        "   pix(2,3) \n"
        "   pix(4,3) \n"
        "   pix(3,4) \n"
        "   pix(2,5) \n"
        "   pix(4,5) \n"
        " \n"
        "   col(\"white\") \n"
        "   pix(3,3) \n"
        "   pix(2,4) \n"
        "   pix(4,4) \n"
        "   pix(3,5) \n"
        "   pix(2,6) \n"
        "   pix(3,6) \n"
        "   pix(4,6) \n"
        "   pix(3,7) \n"
        "   pix(3,8) \n"
        " \n"
        "   pixEnd() \n"
        "end \n"
     );

}
