#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Parche 1.0.1.0 no instalado"},
    {TR_NO_PATCH_MESSAGE,
        "Tu instalación de Caesar 3 no tiene el parche 1.0.1.0 instalado. "
        "Puedes descargar el parche en:\n"
        URL_PATCHES "\n"
        "Continúa bajo tu propio riesgo."},
    {TR_MISSING_FONTS_TITLE, "No se han encontrado archivos de fuente"},
    {TR_MISSING_FONTS_MESSAGE,
        "Tu instalación de Caesar 3 requiere archivos de fuente adicionales. "
        "Puedes descargar las fuentes requeridas para tu idioma en:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor no instalado"},
    {TR_NO_EDITOR_MESSAGE,
        "Tu instalación de Caesar 3 no contiene los archivos del editor. "
        "Puedes descargar los archivos requeridos en:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Directorio de idioma inválido"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "El directorio que has seleccionado no contiene un paquete de idioma válido. "
        "Por favor, comprueba el registro de errores."},
    {TR_BUILD_ALL_TEMPLES, "Todo"},
    {TR_BUTTON_OK, "Aceptar"},
    {TR_BUTTON_CANCEL, "Cancelar"},
    {TR_BUTTON_RESET_DEFAULTS, "Por defecto"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Atajos de teclado"},
    {TR_CONFIG_TITLE, "Opciones de configuración de Augustus"},
    {TR_CONFIG_LANGUAGE_LABEL, "Idioma:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(por defecto)"},
    {TR_CONFIG_DISPLAY_SCALE, "Escala del monitor:"},
    {TR_CONFIG_CURSOR_SCALE, "Tamaño del cursor:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Cambios en la interfaz"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Cambios en el juego"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Reproducir videos al inicio"},
    {TR_CONFIG_SIDEBAR_INFO, "Mostrar información adicional en el panel de control"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Activar desplazamiento suave del mapa"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Desactivar click derecho para desplazar el mapa"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Mejorar la retroalimentación visual al limpiar terreno"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Permitir construcción secuencial de templos"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Mostrar área cubierta por depósitos de agua, fuentes y pozos al construir"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Mostrar medidas de construcción al arrastrar"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Resaltar legión bajo el cursor"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotar Portón y Arco del Triunfo manualmente"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Activar barra militar lateral"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Corregir bug impidiendo inmigración en Muy Difícil"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Corregir bug creando fantasmas con 100 años"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Corregir cambio de Emperador y tiempo de supervivencia en misiones del editor"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Ver ruta de caminantes en Capas al hacer click derecho en un edificio"},
    {TR_CONFIG_ENABLE_ZOOM, "Habilitar zoom (usa más RAM, puede ralentizar el juego)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Arreglar columnas de puntuación incompletas con bajos requerimientos"},
    {TR_CONFIG_GRANDFESTIVAL, "Super-Festivales permiten bendiciones extras de un dios"},
    {TR_CONFIG_JEALOUS_GODS, "Desactivar la envidia entre dioses"},
    {TR_CONFIG_GLOBAL_LABOUR, "Activar mano de obra global"},
    {TR_CONFIG_SCHOOL_WALKERS, "Extender el rango de los caminantes de los colegios"},
    {TR_CONFIG_RETIRE_AT_60, "Cambiar le edad de jubilación de 50 a 60 años"},
    {TR_CONFIG_FIXED_WORKERS, "Mano de obra fija - 38% de la población plebeya"},
    {TR_CONFIG_EXTRA_FORTS, "Permite construir 4 fuertes adicionales"},
    {TR_CONFIG_WOLVES_BLOCK, "Deshabilitar la construcción alrededor de lobos"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloquear los caminos no conectados de un granero"},
    {TR_CONFIG_MORE_STOCKPILE, "Las residencias reservan más bienes del mercado"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Las mercaderes que compran no distribuyen bienes"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Destruir edificios inmediatamente"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Los carreteros de graneros que obtienen bienes no necesitan caminos"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doblar la capacidad de carreteros de graneros que obtienen bienes"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Los centinelas de las torres no necesitan conexión a una barraca"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Granjas y dársenas solo distribuyen a graneros cercanos"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "No distribuir alimentos a graneros que obtienen bienes"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Todas las residencias se unen"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Las rutas de comercio abiertas cuentan como provisión de distintos tipos de vino"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Pozos de arcilla y minas de hierro cobran dinero en vez de inundarse o colapsar"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Permite construir múltiples barracas"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Los almacenes no aceptan bienes cuando se construyen"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Las residencias no se expanden hacia los jardines"},
    {TR_HOTKEY_TITLE, "Configuración de atajos de teclado de Augustus"},
    {TR_HOTKEY_LABEL, "Principal"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Secundaria"},
    {TR_HOTKEY_HEADER_ARROWS, "Teclas de dirección"},
    {TR_HOTKEY_HEADER_GLOBAL, "Atajos globales"},
    {TR_HOTKEY_HEADER_CITY, "Atajos de la ciudad"},
    {TR_HOTKEY_HEADER_ADVISORS, "Asesores"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Capas"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Atajos de mapa"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Atajos de construcción"},
    {TR_HOTKEY_ARROW_UP, "Arriba"},
    {TR_HOTKEY_ARROW_DOWN, "Abajo"},
    {TR_HOTKEY_ARROW_LEFT, "Izquierda"},
    {TR_HOTKEY_ARROW_RIGHT, "Derecha"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Activar pantalla completa"},
    {TR_HOTKEY_CENTER_WINDOW, "Centrar pantalla"},
    {TR_HOTKEY_RESIZE_TO_640, "Redimensionar a 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Redimensionar a 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Redimensionar a 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Capturar pantalla"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Capturar ciudad completa"},
    {TR_HOTKEY_BUILD_CLONE, "Clonar edificio bajo el cursor"},
    {TR_HOTKEY_LOAD_FILE, "Cargar partida"},
    {TR_HOTKEY_SAVE_FILE, "Guardar partida"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Subir velocidad de juego"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Bajar velocidad de juego"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Activar pausa"},
    {TR_HOTKEY_CYCLE_LEGION, "Circular entre legiones"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Rotar mapa a la izquierda"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Rotar mapa a la derecha"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Asesor laboral"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Asesor militar"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Asesor imperial"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Asesor de puntuación"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Asesor de comercio"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Asesor de población"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Asesor de sanidad"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Asesor de educación"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Asesor de entretenimiento"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Asesor de religión"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Asesor de finanzas"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Asesor jefe"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Asesor de vivienda"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Capa actual"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Capa de agua"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Capa de riesgo de fuego"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Capa de riesgo de daño"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Capa de criminalidad"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Capa de problemas"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotar edificio"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Ir a atajo de mapa 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Ir a atajo de mapa 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Ir a atajo de mapa 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Ir a atajo de mapa 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Definir atajo de mapa 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Definir atajo de mapa 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Definir atajo de mapa 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Definir atajo de mapa 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Activar información de batalla"},
    {TR_HOTKEY_EDIT_TITLE, "Presiona nueva tecla"},
    {TR_BUILDING_ROADBLOCK, "Control de carretera"},
    {TR_BUILDING_ROADBLOCK_DESC, "Los controles de carretera detienen a los ciudadanos ociosos."},
    {TR_BUILDING_ARCHITECT_GUILD, "Gremio de Arquitectos"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Aquí trabajan arquitectos sin cesar para construir monumentos a la gloria de Roma."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Confiere un epíteto al templo"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptuno"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercurio"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Marte"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus"},
    {TR_BUILDING_PANTHEON, "Panteón"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Gran templo de Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Gran templo de Neptuno"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Gran templo de Mercurio"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Gran templo de Marte"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Gran templo de Venus"},
    {TR_BUILDING_PANTHEON_DESC, "Panteón"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Los carreteros de las granjas son un 50% más rápidos."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Otorga +1 rango a los pozos y fuentes y +2 a depósitos. Los servicios hidráulicos usan 50% menos trabajadores. Los barcos mercantes viajan un 25% más rápido."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Los comerciantes terrestres y marítimos tienen un 50% más de capacidad. Las caravanas de mercaderes son un 25% más rápidas."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Entrena soldados como una barraca. Se pueden construir 4 fuertes adicionales."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Jardines, estatuas y templos de la ciudad brillan con increíble belleza, aumentando su atractivo. Las residencias reservan más bienes y demoran más en disminuir de nivel."},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Otorga acceso a todos los dioses. Celebra festivales anuales y reduce el costo por mantenimiento de las iglesias y edificios culturales un 25%."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Los sacerdotes reducen el consumo de alimento en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Los templos producen cuadrigas para el Hipódromo."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Los sacerdotes reducen el consumo de cerámica y muebles en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Los templos generan alimentos en una cantidad proporcional al número de casas que cubren y lo entregan al puesto de suministro. El costo de mantenimiento de los fuertes se reduce un 25%."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "El Gran templo produce vino en una cantidad proporcional a la población con acceso a templos de Venus. Los templos lo recolectan y distribuyen a las residencias."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Los sacerdotes recolectan y distribuyen aceite y un tipo de alimento del disponible en la ciudad."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Los sacerdotes expanden la capacidad de las viviendas en un 5%. El Gran templo provee agua como si fuese un depósito."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Los sacerdotes reducen el consumo de aceite y vino en un 20%."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Los sacerdotes reducen el consumo de todos los bienes en un 10%."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Los sacerdotes proveen entretenimiento y hermosean las residencias, aumentando el atractivo del vecindario sin necesidad de decoraciones adicionales."},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Todos los templos en la ciudad envían sacerdotes al Panteón, esparciendo la fé y bendiciones de sus dioses."},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Las residencias con acceso al Panteón puede evolucionar un nivel adicional."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Templo de Ceres Fecunda"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Templo de Ceres Frugifera"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Templo de Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Templo de Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Templo de Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Templo de Mercurius Mercator"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Templo de Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Templo de Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Templo de Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Templo de Venus Genetrix"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Gran templo"},
    {TR_BUILDING_WORK_CAMP, "Campamento de trabajo"},
    {TR_BUILDING_WORK_CAMP_DESC, "Los trabajadores se reunen aquí para transportar los materiales necesarios a los sitios de construcción."},
    {TR_HEADER_HOUSING, "Vivienda"},
    {TR_ADVISOR_HOUSING_ROOM, "En la ciudad hay habitaciones para"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "No hay habitaciones disponibles en la ciudad."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Residencias usando cerámica"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Residencias usando muebles"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Residencias usando aceite"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Residencias usando vino"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Residencias totales:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacidad disponible:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacidad total:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Población - Vivienda"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Gráficos"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "La puntuación de prosperidad de las viviendas es"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "El porcentaje de tu población en villas y palacios es"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "El porcentaje de tu población en tiendas y tugurios es"},
    {TR_ADVISOR_AVERAGE_TAX, "El ingreso promedio de impuestos por residencia es"},
    {TR_ADVISOR_AVERAGE_AGE, "La edad promedio de tu población es"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "El porcentaje de tu población en la fuerza de trabajo es"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Nacimientos el año pasado:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Muertes el año pasado:"},
    {TR_ADVISOR_TOTAL_POPULATION, "residentes totales"},
    {TR_REQUIRED_RESOURCES, "Recursos entregados para la fase actual:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Construir Grandes templos requiere material de un almacén, mano de obra de un campamento de trabajo y arquitectos de un gremio de arquitectos."},
    {TR_CONSTRUCTION_PHASE, "Fase de construcción:"},
    {TR_ADD_MODULE, "¿Rededicar templo?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epíteto conferido."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Primero, Ceres enseñó a sus ciervos laboriosos a arar,\nLuego, a fecundar la tierra sembrando la semilla viva,\npor primera vez el hombre pudo proporcionarse alimentos sanos,\ny con leyes justas suministró alimentos a este mundo perverso.\n-Ovidio, Metamorfosis, Libro V"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "La ira del mar y su oleaje decaen, mientras Neptuno suelta su tricúspide arma\nlas aguas se calman ante su regente, y desde sus profundidades\nemerge Tritón por sobre las olas,\nvistiendo su túnica de tirio,\ny en su mano una trompeta encorvada,\npara dar la señal de un soplido.\n-Ovidio, Metamorfosis, Libro I"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Puedes preparar ganado y ovejas gordas para el largo viaje,\npuedes adquirir trípodes para el comercio y sementales de melena rubia;\npero no es posible hacer volver el alma humana,\nuna vez que se ha colado por entre los dientes apretados de un hombre.\n-Homero, La Iliada, Libro IX"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Trabajaban con afán en concluir un carro\ny unas veloces ruedas para Marte,\ncon que concita a los hombres y las ciudades.\n-Virgilio, La Eneida, Libro VIII"},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Por Venus y con su tierna madre el volador Cupido,\ngoces cuán grandes sentí, cuán manifiesto deleite,\ncuán relajada hasta en las médulas he quedado\ncómo acordarse agrada.\n-Ovidio, Metamorfosis, Libro IX"},
    {TR_BUILDING_PANTHEON_QUOTE, "Abrese en tanto la morada del omnipotente Olimpo,\ny el padre de los dioses y rey de los hombres\nconvoca a concilio en la estrellada mansión,\ndesde donde abarca con la vista toda la tierra, y\nlos reales de los Troyanos y los pueblos latinos.\nToman asiento los dioses\nen una estancia abierta por ambos lados.\n-Virgilio, La Eneida, Libro X"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Los trabajadores construyen el podium que elevará el templo y proveerá una sólida fundación para hacer frente al paso del tiempo."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Los artesanos elaboran el pórtico, que contiene el altar de sacrificios del templo."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Los arquitectos elaboran la cella, la cámara que albergará sagradas imágenes."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Ha comenzado el trabajo en el praecinctum del templo, donde los fieles se reunirán para las ceremonias públicas."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Con el templo casi completo, los sacerdotes se reunen para ejecutar los ritos de dedicación."},
    {TR_BUILDING_MENU_TREES, "Árboles"},
    {TR_BUILDING_MENU_PATHS, "Caminos"},
    {TR_BUILDING_MENU_PARKS, "Parques"},
    {TR_BUILDING_SMALL_POND, "Estanque pequeño"},
    {TR_BUILDING_LARGE_POND, "Estanque grande"},
    {TR_BUILDING_PINE_TREE, "Pino"},
    {TR_BUILDING_FIR_TREE, "Abeto"},
    {TR_BUILDING_OAK_TREE, "Roble"},
    {TR_BUILDING_ELM_TREE, "Olmo"},
    {TR_BUILDING_FIG_TREE, "Higuera"},
    {TR_BUILDING_PLUM_TREE, "Ciruelo"},
    {TR_BUILDING_PALM_TREE, "Palmera"},
    {TR_BUILDING_DATE_TREE, "Datilero"},
    {TR_BUILDING_PINE_PATH, "Camino de pinos"},
    {TR_BUILDING_FIR_PATH, "Camino de abetos"},
    {TR_BUILDING_OAK_PATH, "Camino de robles"},
    {TR_BUILDING_ELM_PATH, "Camino de olmos"},
    {TR_BUILDING_FIG_PATH, "Camino de higueras"},
    {TR_BUILDING_PLUM_PATH, "Camino de ciruelos"},
    {TR_BUILDING_PALM_PATH, "Camino de palmeras"},
    {TR_BUILDING_DATE_PATH, "Camino de datileros"},
    {TR_BUILDING_BLUE_PAVILION, "Pabellón azúl"},
    {TR_BUILDING_RED_PAVILION, "Pabellón rojo"},
    {TR_BUILDING_ORANGE_PAVILION, "Pabellón naranja"},
    {TR_BUILDING_YELLOW_PAVILION, "Pabellón amarillo"},
    {TR_BUILDING_GREEN_PAVILION, "Pabellón verde"},
    {TR_BUILDING_SMALL_STATUE_ALT, "Estatua de la diosa"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Estatua del senador"},
    {TR_BUILDING_OBELISK, "Obelisco"},
    {TR_BUILDING_POND_DESC, "Depósitos llenan los estanques que proveen agua para plantas y animales y un fresco y relajante oasis para la gente. Todos los ciudadanos amarían vivir cerca de un estanque."},
    {TR_BUILDING_WINDOW_POND, "Estanque"},
    {TR_BUILDING_OBELISK_DESC, "Un prestigioso monumento, el trabajo de un antiguo rey del Nilo. Los Egipcios no lo necesitaban."},
    {TR_ADVISOR_FINANCE_LEVIES, "Mantenimiento de edificios"},
    {TR_CONFIRM_DELETE_MONUMENT, "Demoliendo este monumento"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Selecciona el epíteto a conferir"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Conferir un epíteto dedicará permanentemente tu templo a un aspecto de su deidad, inbuyendo a los sacerdotes de poder divino."},
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/mes"},
    {TR_BUILDING_MESS_HALL, "Puesto de suministro"},
    {TR_BUILDING_MESS_HALL_DESC, "El puesto de suministro recolecta alimentos de los graneros de la ciudad para alimentar a los soldados de los fuertes. Un mal abastecimiento ralentizará el reclutamiento y dañará la moral."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Provisiones del mes pasado:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Los soldados están: "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Bien alimentados"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Alimentados"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Hambrientos"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Muy hambrientos"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Famélicos"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "La variada dieta de tus soldados aumenta mucho su moral."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "La diversa y nutritiva dieta que gozan tus soldados aumenta mucho su moral."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "No tienes soldados que alimentar."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Meses de comida almacenados:"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "La escasez de alimento en tu puesto de suministro ralentiza el reclutamiento."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "La escasez crítica de alimento en tu puesto de suministro estropea el reclutamiento."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "La reciente escasez de alimento disminuyó la moral."},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "La reciente escasez de alimento disminuyó mucho la moral."},
    {TR_BUILDING_LEGION_STARVING, "Escasez de alimento."},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Tus soldados tienen todo el alimento que necesitan."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Tus soldados necesitan más alimento."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "¡Tus soldados están famélicos!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Meses de comida almacenados en puestos de suministros:"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldados hambrientos"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Tu puesto de suministro tiene muy poca comida, y la moral de tus tropas mengua. Asegúrate de que tu puesto de suministros puede acceder a un granero bien surtido."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Tu ciudad perdió su puesto de suministros, y tus tropas tienen hambre. Construye un puesto de suministros inmediatamente."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Bienes a recolectar"},
    {TR_WARNING_NO_MESS_HALL, "Debes construir primero un puesto de suministro para alimentar a tus tropas."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "Solo dos Grandes templos pueden construirse."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Gran templo completado"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Sacerdotes y fieles se congregan en el nuevo Gran templo para los ritos de consagración. Tu gente ve asombrada la majestuosidad de tus obras, y tu deidad elegida te colma de favor."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Una bendición de Mercurio"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Encantado por tu atención, Mercurio bendice tu industria, descubriendo materias primas para tus artesanos."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Capataz"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Transportista"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Arquitecto"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Intendente militar"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Sirviente del campo"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "El Gran templo coordina a los sacerdotes de Ceres para ayudar distribuyendo comida y aceite a tus hambrientos ciudadanos."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "El Gran templo permite la distribución de vino sagrado a tus ciudadanos por los sacerdotes de Venus ."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "El Gran templo coordina la entrega de provisiones a tu puesto de suministros por los sacerdotes de Marte."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Templo de Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Templo de Neptuno"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Templo de Mercurio"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Templo de Marte"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Templo de Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Sacerdote"},
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Haré lo que pueda para aplacar a estos bárbaros. Estoy seguro de que dejarán de atacar la ciudad cuando haya hablado con ellos.\""},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Festival anual"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Los fieles acuden a los templos para la celebración de Cerealia, en honor a Ceres. Granjeros ofrecen sacrificios a cambio de abundantes cosechas en los años venideros."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Hoy es el festival de Neptunalia, en honor a Neptuno. Los fieles construyen chozas de ramas y follaje y festejan bajo el calor abrasador del verano"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Comerciantes y mercaderes salen en masa a celebrar Mercuralia. Agua sagrada es rociada en barcos y almacenes buscando la divina protección del dios Mercurio."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Ciudadanos se reunen en las afueras de la ciudad para la celebración de Equirria, buscando el favor de Marte. El aire se llena con el trueno de los cascos y el crujir de los carros mientras los fieles compiten en honor a su dios."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Los fieles se reunen para la celebración de Veneralia, día consagrado a Venus. Tus ciudadanos ruegan por buena fortuna en asuntos del corazón."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Borrar mensajes leídos"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Deshabilitar este edificio"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Habilitar este edificio"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Permite a las mercaderes comprar aquí"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Permite a las caravanas mercantes comerciar aquí"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Permite a los barcos mercantes comerciar aquí"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Gestión de la ciudad"},
    {TR_BUILDING_LIGHTHOUSE, "Faro"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Cimientos)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Torre)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Cima)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Los arquitectos sientan sólidos cimientos para soportar el peso de la gran torre de piedra."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Canteros construyen el pedestal que elevará la llama del faro por sobre el horizonte."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "La torre del faro se eleva cada día más a medida que los canteros cuidadosamente llevan a cabo su labor."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Arquitectos realizan toques finales al faro. Pronto brillará por kilómetros, guiando a los barcos a su destino."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Construir el faro requiere material de un almacén, mano de obra de un campamento de trabajo y arquitectos provenientes del gremio de arquitectos."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Barcos pesqueros se mueven un 10% más rápido. Las tormentas marinas duran la mitad de tiempo."},
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumentos"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "El faro, una enorme torre de piedra, se cierne sobre el horizonte. Que su baliza guíe a los barcos a su destino hasta el fin de los tiempos."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "El Panteón está completo. Se erige incomparable como monumento al asombroso poder de los dioses y del pueblo de Roma."},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monumento finalizado"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Bendición de Neptuno"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Premiando la devoción de tu ciudad, Neptuno otorga viaje seguro a comerciantes por doce meses, durante los cuales tus exportaciones valdrán un 50% adicional."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Bendición de Venus"},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Encantada por la alegre reverencia mostrada a ella, Venus otorga juventud, salud y felicidad a tu gente, aumentando el número de trabajadores en tu ciudad."},
    {TR_BUILDING_MENU_STATUES, "Estatuas"},
    {TR_BUILDING_MENU_GOV_RES, "Mansión del gobernador"},
    {TR_OVERLAY_ROADS, "Caminos"},
    {TR_NO_EXTRA_ASSETS_TITLE, "La carpeta '/assets' no está"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Tu instalación de Caesar 3 no tiene bien instalada la carpeta '/assets' "
        "Los nuevos elementos no se mostrarán correctamente.\n"
        "Asegúrate de que la carpeta '/assets' existe en el directorio de instalación de Caesar 3. "},
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "El faro debe ser construido cerca del agua."},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Esta casa tiene acceso a todos los dioses del Panteón"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "La abundante comida aumenta la moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Estado nutricional"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Permite a los intendentes militares obtener alimentos aquí"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "No puedes obtener los materiales necesarios"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Grandes templos completados otorgan +6 de puntuación de cultura"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Volver al menú principal"},
    {TR_LABEL_PAUSE_MENU, "Pausa"},
    {TR_OVERLAY_LEVY, "Mantenimiento"},
    {TR_TOOLTIP_OVERLAY_LEVY, "Denarios pagados mensualmente para dar mantenimiento."},
    {TR_MAP_EDITOR_OPTIONS, "Configuración de escenario"},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Este templo recolectará comida para tu puesto de suministro, una vez lo construyas."},
    {TR_BUTTON_GO_TO_SITE, "Ir al sitio" },
    {TR_RETURN_ALL_TO_FORT, "Regresar todo" },
    {TR_OPTION_MENU_COST, "Esto costará" },
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "¿Estás seguro? " },
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Despachando alimentos desde otros graneros." },
    {TR_ADVISOR_FROM_GRANARIES, "Desde otros graneros " },
    {TR_ADVISOR_IN_STORAGE, "En almacén " },
    {TR_ADVISOR_KEEP_STOCKPILING, "Continuar acumulando este recurso." },
    {TR_ADVISOR_OPEN_TO_EXPORT, "Abrir ruta comercial para exportar." },
    {TR_ADVISOR_OPEN_TO_IMPORT, "Abrir ruta comercial para importar." },
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable" },
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable" },
    {TR_ADVISOR_TRADE_MAX, "Máximo" },
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "No se está exportando." },
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "No se está importando." },
    {TR_ADVISOR_TRADE_NO_BUYERS, "No existen compradores para este recurso." },
    {TR_ADVISOR_TRADE_NO_LIMIT, "máximo" },
    {TR_ADVISOR_TRADE_NO_SELLERS, "No existen vendedores para este recurso." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_CARAVANSERAI, "Caravasar" },
    {TR_BUILDING_CARAVANSERAI_DESC, "Las caravanas de mercaderes aprovechan este lugar de descanso y consumen alimentos. Las interrupciones al comercio por rutas terrestres duran la mitad del tiempo." },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Sin políticas de comercio para rutas terrestres." },
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "Cimientos" },
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Los trabajadores cavan los cimientos de este futuro lugar de descanso." },
    { TR_BUILDING_CARAVANSERAI_POLICY_1, "Caravanas mercantes pagan un 20% adicional por los bienes y productos de tu ciudad, pero las importaciones terrestres aumentan un 10% su valor de compra." },
    { TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium Venditor" },
    { TR_BUILDING_CARAVANSERAI_POLICY_2, "Caravanas mercantes venden sus bienes y productos un 20% más barato, pero las exportaciones terrestres generan un 10% menos de ingresos." },
    { TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium Acquisitionem" },
    { TR_BUILDING_CARAVANSERAI_POLICY_3, "Caravanas mercantes transladan 4 unidades adicionales de bienes y productos, pero consumen un 20% más de alimento en el caravasar." },
    { TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium Quantitas" },
    { TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Selecciona una política para el comercio terrestre en tu ciudad." },
    { TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Política para el comercio terrestre" },
    { TR_BUILDING_COLONNADE, "Columnata" },
    { TR_BUILDING_COLOSSEUM_PHASE_1, "(Hipogeo)" },
    { TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Trabajadores están cavando el hipogeo subterráneo, los túneles y la maquinaria de donde surgirán grandes espectáculos." },
    { TR_BUILDING_COLOSSEUM_PHASE_2, "(Cimientos)" },
    { TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Las paredes del Coliseo toman forma a medida que se colocan filas de asientos tanto para plebeyos como para emperadores." },
    { TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcade)" },
    { TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Elegantes arcos se elevan hacia los cielos para sostener en lo más alto al imponente Coliseo." },
    { TR_BUILDING_COLOSSEUM_PHASE_4, "Galería" },
    { TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "A medida que el Coliseo se eleva hacia el cielo, sus paredes son revestidas de estatuas y reluciente mármol." },
    { TR_BUILDING_DECORATIVE_COLUMN, "Columna de mármol" },
    { TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Ciudades con comercio marítimo abierto:" },
    { TR_BUILDING_DOCK_CITIES_NO_ROUTES, "No existen rutas de comercio marítimo abiertas." },
    { TR_BUILDING_DOLPHIN_FOUNTAIN, "Fuente de delfines" },
    { TR_BUILDING_GARDEN_PATH, "Sendero de jardínes" },
    { TR_BUILDING_GARDEN_WALL, "Jardín mural" },
    { TR_BUILDING_GRAND_GARDEN, "Jardín grande" },
    { TR_BUILDING_HEDGE_DARK, "Seto verde" },
    { TR_BUILDING_HEDGE_LIGHT, "Seto soleado" },
    { TR_BUILDING_HIPPODROME_PHASE_1, "(Pista)" },
    { TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Este enorme sitio está siendo minuciosamente examinado y despejado para un proyecto de escala sin precedentes." },
    { TR_BUILDING_HIPPODROME_PHASE_2, "(Cimientos)" },
    { TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Se están construyendo accesos y estructuras de soporte alrededor de la pista." },
    { TR_BUILDING_HIPPODROME_PHASE_3, "(Soportes)" },
    { TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Los albañiles están tallando asientos de piedra para decenas de miles." },
    { TR_BUILDING_HIPPODROME_PHASE_4, "(Fachada)" },
    { TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Más que una simple pista de carreras, los artesanos están levantando un monumento digno de los dioses y del pueblo de Roma." },
    { TR_BUILDING_HORSE_STATUE, "Estatua ecuestre" },
    { TR_BUILDING_INFO_TOURISM, "(viajeros)" },
    { TR_BUILDING_LARARIUM, "Lararium" },
    { TR_BUILDING_LARGE_MAUSOLEUM, "Mausoleo grande" },
    { TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Las paredes de mármol pulido de esta magnífica estructura reflejan las grandes hazañas de los patricios más distinguidos que se ganaron el privilegio de descansar aquí." },
    { TR_BUILDING_LEGION_STATUE, "Estatua del legionario" },
    { TR_BUILDING_LIBRARY_UPGRADE_DESC, "El desarrollo local permitió ampliar enormemente esta biblioteca. Los nuevos manuscritos pueden satisfacer las necesidades educativas de un mayor número de romanos." },
    { TR_BUILDING_LIGHTHOUSE_NO_POLICY, "No existen políticas para el comercio marítimo." },
    { TR_BUILDING_LIGHTHOUSE_POLICY_1, "Barcos mercantes pagan un 20% adicional por los bienes y productos de tu ciudad, pero las importaciones marítimas aumentan un 10% su valor de compra." },
    { TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Commercium Retribuentis" },
    { TR_BUILDING_LIGHTHOUSE_POLICY_2, "Barcos mercantes venden sus bienes y productos un 20% más barato, pero las exportaciones marítimas generan un 10% menos de ingresos." },
    { TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Libratum Artis" },
    { TR_BUILDING_LIGHTHOUSE_POLICY_3, "Barcos mercantes transladan 4 unidades adicionales de bienes y productos, pero el faro consume un 20% más de leña." },
    { TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Abundat Artis" },
    { TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Selecciona una política para el comercio marítimo en tu ciudad." },
    { TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Política para el comercio marítimo" },
    { TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Este monumento tiene todos los materiales necesarios para esta fase y espera a un arquitecto experto del gremio de arquitectos para supervisar su construcción." },
    { TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "La construcción de este monumento requiere materiales provenientes de un almacén, mano de obra desde un campamento de trabajo y arquitectos pertenecientes al gremio de arquitectos." },
    { TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "La construcción se ha detenido." },
    { TR_BUILDING_NYMPHAEUM, "Ninfeo" },
    { TR_BUILDING_NYMPHAEUM_DESC, "Un gran templo consagrado a las ninfas que promete fortuna a los terrenos circundantes y el favor de lo divino a la ciudad." },
    { TR_BUILDING_SCHOOL_UPGRADE_DESC, "Esta escuela está operativa y el desarrollo local ha permitido su expansión. Ahora más niños pueden estudiar al mismo tiempo." },
    { TR_BUILDING_SMALL_MAUSOLEUM, "Mausoleo pequeño" },
    { TR_BUILDING_SMALL_MAUSOLEUM_DESC, "El lugar de descanso de las familias adineradas es la envidia de muchos vivos." },
    { TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "La construcción de este templo requiere materiales provenientes de un almacén, mano de obra desde un campamento de trabajo y arquitectos pertenecientes al gremio de arquitectos." },
    { TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construcción)" },
    { TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Albañiles y arquitectos están construyendo cuidadosamente esta estructura de mármol reluciente." },
    { TR_BUILDING_TAVERN, "Taberna" },
    { TR_BUILDING_TAVERN_DESC_1, "Esta taberna no tiene trabajadores y por ello, no puede abrir al público." },
    { TR_BUILDING_TAVERN_DESC_2, "Esta taberna no tiene vino y por ello, no puede abrir al público." },
    { TR_BUILDING_TAVERN_DESC_3, "Esta taberna ofrece entretenimiento siempre que el vino siga fluyendo. Un suministro de carne aumentaría su atractivo." },
    { TR_BUILDING_TAVERN_DESC_4, "El abundante vino y el olor a carne asada atraen a una multitud animada a esta taberna para jugar, escuchar música y divertirse." },
    { TR_BUILDING_THEATRE_UPGRADE_DESC, "El desarrollo del área ha permitido la expansión del teatro. Ahora, este grandioso teatro puede satisfacer las necesidades de entretenimiento de más ciudadanos." },
    { TR_BUILDING_WATCHTOWER, "Torre de vigilancia" },
    { TR_BUILDING_WATCHTOWER_DESC, "Los arqueros en la almena vigilan en caso de invasores, mientras que los centinelas patrullan las calles." },
    { TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Los residentes están desanimados debido a un evento reciente." },
    { TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "El ánimo de los residentes ha aumentado debido a un evento reciente." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Los residentes aborrecen escuchar tu nombre." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Los residentes están encantados contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Los residentes te aman." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Los residentes te idolatran como a un dios." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Los residentes están furiosos contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Los residentes están muy enojados contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Los residentes están enojados contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Los residentes están muy molestos contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Los residentes están molestos contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Los residentes son indiferentes contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Los residentes están contentos contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Los residentes están muy contentos contigo." },
    { TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Los residentes apreciarían un vecindario más bello." },
    { TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Los residentes apreciarían más entretenimiento en la zona." },
    { TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Los residentes apreciarían una dieta más variada." },
    { TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Los residentes están molestos debido a los altos impuestos." },
    { TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Los residentes están molestos debido a los bajos salarios." },
    { TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Los residentes se sienten abatidos por las pobres condiciones de sus viviendas." },
    { TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Los residentes están molestos por la falta de puestos de trabajo." },
    { TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Detener construcción" },
    { TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Reanudar construcción" },
    { TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instrucciones para el Caravasar" },
    { TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Las últimas bestias salvajes yacen muertas en las arenas del Coliseo, donde su sangre se mezcla con la de los condenados. Dando por finalizados los Juegos de Animales." },
    { TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Cargamentos extraños comienzan a aparecer en tu ciudad a medida que comerciantes provenientes de los confines de la tierra entregan bestias aterradoras a las jaulas debajo del Coloso. Pronto, un espectáculo espantoso deleitará a tu pueblo." },
    { TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Los criminales y gladiadores condenados que buscan la gloria suprema se enfrentan a la muerte en forma de garras y dientes. Con un toque de trompetas, ¡han comenzado los Juegos de animales!" },
    { TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "¡El Coliseo ha sido completado! ¡Que comiencen los Juegos!" },
    { TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Han comenzado los juegos inaugurales de tu Coliseo. ¡A tus órdenes, este monumento será consagrado con la sangre de los valientes!" },
    { TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Se ha completado el Hipódromo. ¡Tus ciudadanos esperan ansiosamente tu orden para que las carreras comiencen!" },
    { TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Tu ciudad queda vacía cuando las personas acuden en multitud al Hipódromo para presenciar la inauguración de las carreras de carros. ¡Un grito ensordecedor llena el aire al abrirse las puertas!" },
    { TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "El último día de los juegos romanos ha llegado a su fin. Rebosantes de emoción y el estómago lleno, todos tus ciudadanos han saboreado la grandeza de la vida romana. ¡Gloria a los vencedores de los juegos y gloria al gobernador!" },
    { TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Con el anuncio de los Juegos Romanos, personas provenientes de las tierras más lejanas y recónditas del Imperio acuden en masa a tu ciudad, muchos con la esperanza de alcanzar la gloria en las próximas competiciones. Se necesitará no menos de un año para completar todos los posibles preparativos necesarios." },
    { TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Comienza la procesión solemne y, con ella, los Juegos Romanos. Que sea el propio Júpiter quien seleccione a los campeones de las carreras, combates de lucha libre y otros concursos de resistencia y agilidad. El Coliseo está repleto de ciudadanos que esperan los juegos y los habituales regalos de trigo y aceite de oliva. ¡Que empiecen los juegos!" },
    { TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Los augurios predicen que los dioses se encuentran complacidos gracias a nuestros grandes juegos, debido a los sacrificios y la reverencia que se les ha mostrado. ¡Podemos esperar un año muy rentable!" },
    { TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Saludaremos el año nuevo con unos juegos gloriosos en honor a los dioses. A cambio, pedimos fortuna, prosperidad y bendiciones en materia de comercio." },
    { TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Los Juegos comienzan al amanecer en las calendas de Ianurius. Los sacerdotes realizan sacrificios de animales mientras los gladiadores ciñen los brazos para morir buscando el favor de lo divino." },
    { TR_CITY_MESSAGE_TEXT_LOOTING, "Un almacén o granero fue saqueado por ciudadanos enfurecidos, siendo robados bienes y productos. Un nivel bajo de confianza ciudadana hace que estos incidentes se vuelvan más recurrentes." },
    { TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Comienza un largo proceso de limpieza para el Coliseo, drenando el agua acumulada y preparándolo para su uso normal. Tu gente hablará sobre este espectáculo acuático durante años." },
    { TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "El agua de los embalses de la ciudad están llenando lentamente el Coliseo. Los carpinteros comienzan a montar barcos de guerra realistas mientras los gladiadores se entrenan en combates acuáticos. ¡Pronto comenzarán los Juegos Navales!" },
    { TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "El Coliseo se ha convertido en un verdadero lago artificial, mientras los gladiadores recrean las grandes victorias romanas en mar abierto. La sangre y el agua se mezclan mientras la multitud ruge. ¡La Naumaquia -los juegos navales- han comenzado!" },
    { TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "La llamada sagrada se apaga mientras viajeros y ciudadanos regresan a casa cansados de júbilo. La gloria eterna es tuya por organizar exitosamente esta antigua y sagrada celebración de mortales sobre fuerzo y honor." },
    { TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Todos los ojos estarán puestos en tu ciudad mientras los Juegos Olímpicos atraen viajeros, competidores y dignatarios romanos de todo el mundo. Será necesario al menos un año para completar todos los preparativos posibles." },
    { TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Por fin ha llegado el día tan esperado. La llama sagrada se enciende y las calles de tu ciudad están desiertas, mientras todos tus ciudadanos se aglomeran en el gran hipódromo. ¡Que comiencen los juegos!" },
    { TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Juegos inaugurales" },
    { TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Los Grandes Juegos" },
    { TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Comienzan las carreras" },
    { TR_CITY_MESSAGE_TITLE_LOOTING, "Saqueos en la ciudad." },
    { TR_CITY_WARNING_GRANARY_BREAKIN, "Un granero ha sido saqueado." },
    { TR_CITY_WARNING_SECESSION, "Algunos plebeyos se niegan a trabajar." },
    { TR_CITY_WARNING_THEFT, "Las arcas de un foro o Senado fueron robadas." },
    { TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Un almacén fue saqueado." },
    { TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Permitir a comerciantes importar y exportar alimentos desde los graneros" },
    { TR_CONFIG_ARE_YOU_SURE, "¿Restablecer configuración predeterminada?" },
    { TR_CONFIG_AUDIO, "Opciones de audio" },
    { TR_CONFIG_CITY_SOUNDS, "Habilitar sonidos de la ciudad" },
    { TR_CONFIG_DIFFICULTY, "Dificultad:" },
    { TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Deshabilitar el desplazamiento del mapa en el borde de la ventana" },
    { TR_CONFIG_EFFECTS, "Habilitar efectos de sonido" },
    { TR_CONFIG_ENABLE_AUDIO, "Habilitar audio" },
    { TR_CONFIG_FULLSCREEN, "Pantalla completa" },
    { TR_CONFIG_GAME_SPEED, "Velocidad de juego:" },
    { TR_CONFIG_GODS_EFFECTS, "Habilitar maldiciones/bendiciones de los dioses" },
    { TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Deshabilitar la generación infinita de lobos" },
    { TR_CONFIG_HEADER_GENERAL, "Configuración general" },
    { TR_CONFIG_MUSIC, "Habilitar música" },
    { TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Caminantes no saltan las esquinas de camino" },
    { TR_CONFIG_SCROLL_SPEED, "Velocidad de desplazamiento" },
    { TR_CONFIG_SPEECH, "Habilitar diálogos" },
    { TR_CONFIG_VIDEO, "Opciones de video" },
    { TR_CONFIG_VOLUME, "Volumen" },
    { TR_CONFIG_WINDOWED_RESOLUTION, "Resolución de ventana:" },
    { TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Perderás todas tus configuraciones personalizadas" },
    { TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Perderás todas tus teclas de acceso rápido personalizadas" },
    { TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE, 
	"Su sistema no tiene suficiente memoria gráfica para habilitar el zoom de la ciudad. \n" 
	"No se ha habilitado el zoom de la ciudad"},
    { TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "No se pudo habilitar el zoom de la ciudad" },
    { TR_DOCK_SPECIAL_ORDERS_HEADER, "Instrucciones del muelle" },
    { TR_FIGURE_TYPE_BARKEEP, "Camarera" },
    { TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Abastecedora de la taberna" },
    { TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Abastacedor del caravasar" },
    { TR_FIGURE_TYPE_LOOTER, "Saqueador" },
    { TR_FIGURE_TYPE_ROBBER, "Ladrón" },
    { TR_FIGURE_TYPE_TOURIST, "Viajero" },
    { TR_FIGURE_TYPE_WATCHMAN, "Vigilante" },
    { TR_HOTKEY_DUPLICATE_MESSAGE, "Esta combinación de teclas ya está asignada a la siguiente acción:" },
    { TR_HOTKEY_DUPLICATE_TITLE, "Ya estás utilizando esta tecla de acceso rápido" },
    { TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Mostrar accesos de servicios por capa " },
    { TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instrucciones para el puesto de suministros" },
    { TR_OPTION_MENU_APPLY, "Solicitar" },
    { TR_OVERLAY_ARENA_COL, "Arena" },
    { TR_OVERLAY_SENTIMENT, "Confianza ciudadana" },
    { TR_OVERLAY_TAVERN, "Taberna" },
    { TR_RESOURCE_FISH, "Pescado" },
    { TR_SAVEGAME_LARGER_VERSION_MESSAGE, "La partida guardada que estás intentando cargar es para una versión más reciente de Augusutus. \nPor favor, actualiza Augustus a la versión más reciente." },
    { TR_SAVEGAME_LARGER_VERSION_TITLE, "Versión de partida guardada incompatible" },
    { TR_SELECT_GAMES_HEADER, "Juegos" },
    { TR_SELECT_GAMES_TEXT, "Los juegos se llevarán a cabo en el Coliseo, a expensas de tus fondos personales, además de recursos de la ciudad." },
    { TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Enemigos acercándose" },
    { TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Enemigos a lo lejos" },
    { TR_SIDEBAR_EXTRA_GODS, "Dioses" },
    { TR_SIDEBAR_EXTRA_INVASIONS, "Invasiones" },
    { TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasión inminente" },
    { TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasión en curso" },
    { TR_SIDEBAR_EXTRA_NO_INVASIONS, "Sin invasiones" },
    { TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Ejército de tamaño medio" },
    { TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Ejército de gran tamaño" },
    { TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Enviar solicitud" },
    { TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Ejército de tamaño pequeño" },
    { TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Almacenar" },
    { TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Detener almacenamiento" },
    { TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Ver todo" },
    { TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instrucciones de Taberna" },
    { TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instrucciones del Templo" },
    { TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Información de juegos" },
    { TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Ir a gráficos de población" },
    { TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Visitar a tu asesor de vivienda" },
    { TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Seleccionar una política de comercio terrestre" },
    { TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Seleccionar una política de comercio marítimo" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Alternar pase de caminantes educativos" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Alternar pase de caminantes de entretenimiento" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Alternar pase del caminante de empleos" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Alternar pase de ingenieros y prefectos" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Alternar pase de abastecedores del mercado" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Alternar pase de caminantes de salud" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Alternar pase de misioneros" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Alternar pase de sacerdotes" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Alternar pase de recaudadores de impuestos" },
    { TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Alternar pase de vigilantes" },
    { TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Esta vivienda no tiene acceso a una Arena o al Coliseo." },
    { TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Esta vivienda tiene acceso a una Arena con solo un espectáculo." },
    { TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Esta vivienda tiene acceso a una Arena con dos espectáculos." },
    { TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Esta vivienda tiene acceso al Coliseo con solo un espectáculo." },
    { TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Esta vivienda tiene acceso al Coliseo con dos espectáculos." },
    { TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Esperando al carretero" },
    { TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Edificio paralizado" },
    { TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "No hay recursos disponibles" },
    { TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Sin acceso a agua" },
    { TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Trabajadores en huelga" },
    { TR_TOOLTIP_OVERLAY_TAVERN_1, "Esta casa no tiene acceso a una taberna, o su taberna cercana se ha quedado sin vino." },
    { TR_TOOLTIP_OVERLAY_TAVERN_2, "Hace tiempo que no ha pasado ninguna camarera por acá. Esta casa pronto perderá el acceso a su taberna." },
    { TR_TOOLTIP_OVERLAY_TAVERN_3, "Una camarera de una taberna con vino ha pasado por esta casa." },
    { TR_TOOLTIP_OVERLAY_TAVERN_4, "Una camarera de una taberna con vino y carne ha pasado por esta casa." },
    { TR_TOOLTIP_OVERLAY_TAVERN_5, "Una camarera de una taberna con vino ha pasado recién por esta casa." },
    { TR_TOOLTIP_OVERLAY_TAVERN_6, "Una camarera de una taberna con vino y carne ha pasado recién por esta casa. ¡Qué comience el jolgorio!" },
    { TR_WARNING_VARIANT_TOGGLE, "Pulsa la tecla de rotación para recorrer las variantes de este edificio." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenas" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Todos" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Organizar juegos" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Meses de espera para organizar nuevos juegos:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Grandes Juegos fueron realizados hace poco." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Los Grandes Juegos del Coliseo requieren de tu patrocinio, por lo que costará parte de tus fondos personales y recursos de la ciudad." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Juegos" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Los preparativos para los Grandes Juegos están en marcha." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "¡Los Grandes Juegos están en marcha! Tu ciudad está llena de viajeros y juerga." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Nadie" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Meses de espera para los Juegos de Animales:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Meses de espera para los Juegos Romanos:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Meses de espera para los Juegos de Calendas:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Meses de espera para los Juegos Navales:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Meses de espera para los Juegos Olímpicos:" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tabernas" },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Los Juegos de Animales están en marcha. Hombro con hombro, la multitud grita afónica mientras las bestias salvajes achechan a sus presas humanas." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Los Juegos Romanos están en marcha. Cada participante derrama sangre, sudor y lágrimas para demostrar que es el mejor romano." }, 
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Los Juegos de Calendas están en marcha. El olor de los sacrificios animales y el incienso predomina incluso por sobre el olor a sangre y sudor de la arena." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Los Juegos Navales están en marcha. El chapoteo del agua, el crujir de la madera y los gritos de batalla de los gladiadores, se suman al rugido de la multitud." },
    { TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Los Juegos Olímpicos están en marcha. El fuego sagrado arde día y noche mientras los atletas compiten por la gloria eterna." },
    { TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tributo/intereses" },
    { TR_WINDOW_ADVISOR_TOURISM, "Misceláneo" },
    { TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Esta Arena alberga gladiadores y cacerías de animales, para el deleite de los lugareños." },
    { TR_WINDOW_BUILDING_ARENA_CLOSED, "La Arena está cerrada. Los pájaros hacen nidos en sus asientos vacíos." },
    { TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Las bestias hambrientas merodean por la arena en búsqueda de presas, pero la falta de gladiadores entrenados hace que los espectáculos sean breves." },
    { TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Las luchas regulares de gladiadores mantienen entretenida a la multitud, pero los leones elevarían el espectáculo." },
    { TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Esta Arena no alberga leones ni gladiadores y provee muy poco entretenimiento." },
    { TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Los Grandes Juegos continuarán por otros:" }, // ...XX Days,
    { TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Si pudieses brindarle acceso a una red de agua de un depósito, esta estatua se vería aún más grandiosa con su fuente funcionando." },
    { TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "No es posible acceder a este sitio en construcción por ningún camino. Conecta una carretera a una de las baldosas céntricas de este monumento." },
    { TR_WINDOW_BUILDING_LARARIUM_DESC, "Este pequeño santuario está dedicado a los espíritus ancestrales del pueblo romano. Aquí se pueden hacer pequeños sacrificios y oraciones." },
    { TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Ingresos económicos por viajeros este año:" },
    { TR_WINDOW_BUILDING_TOURISM_DISABLED, "Existen demasiados edificios de este tipo, debido a esto, los viajeros evitan este lugar." },
    { TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Tu asesor comercial ordenó detener la producción pesquera." },
    { TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Debido al bajo nivel de confianza ciudadana, los plebeyos de este taller se han declarado en huelga, negándose a trabajar." },
    { TR_WINDOW_FIGURE_TOURIST, "Este viajero ha gastado:" },
    { TR_WINDOW_GAMES_COST, "Costo:" },
    { TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "No tienes suficientes fondos personales." },
    { TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "No existen suficientes recursos almacenados en la ciudad." },
    { TR_WINDOW_GAMES_NO_VENUE, "El edificio para albergar este evento aún no ha sido construido o no posee trabajadores suficientes." },
    { TR_WINDOW_GAMES_OPTION_1, "Organizar los Juegos Navales" },
    { TR_WINDOW_GAMES_OPTION_1_DESC, "El Coliseo se inundará para recrear una gran batalla naval. La velocidad de movimiento de tus tropas y su fuerza en batallas distantes se incrementará durante el próximo año." },
    { TR_WINDOW_GAMES_OPTION_2, "Organizar los Juegos de Animales" },
    { TR_WINDOW_GAMES_OPTION_2_DESC, "El Coliseo albergará horribles cacerías de animales y ejecuciones realizadas por bestias salvajes, las que deleitarán a las masas plebeyas. El crimen, los disturbios y las revueltas serán reprimidas durante el próximo año. Los gladiadores ayudarán a defender la ciudad durante la próxima invasión." },
    { TR_WINDOW_GAMES_OPTION_3, "Organizar las Calendas de Enero" },
    { TR_WINDOW_GAMES_OPTION_3_DESC, "El Coliseo albergará juegos en honor a los dioses el primer día del próximo año, suplicando fortuna y prosperidad. Las cuotas comerciales se duplicarán el próximo año." },
    { TR_WINDOW_GAMES_OPTION_4, "Organizar los Juegos Olímpicos" },
    { TR_WINDOW_GAMES_OPTION_4_DESC, "EL Hipódromo será la sede de los Juegos Olímpicos. Tu ciudad recibirá miles de visitantes, y si tus atletas rinden honor a este evento, obtendrás un aumento permanente en el turismo y el favor." },
    { TR_WINDOW_GAMES_OPTION_5, "Organizar los Juegos Romanos" },
    { TR_WINDOW_GAMES_OPTION_5_DESC, "El Coliseo será la sede de los Juegos Romanos, con personas de todo el imperio viajarán a tu ciudad para competir. Será un espectáculo tan grandioso que seguramente te hará ganar el favor del Emperador como de los plebeyos durante el próximo año." },
    { TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fondos personales)" },
	{ TR_WINDOW_GAMES_NO_WATER_ACCESS, "El Coliseo no tiene acceso a una red de agua proveniente de un depósito."},

};

void translation_spanish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
