#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 ist nicht installiert"},
    {TR_NO_PATCH_MESSAGE,
        "Deine Caesar 3 Installation wurde noch nicht auf Version 1.0.1.0 aktualisiert. "
        "Der Patch kann hier heruntergeladen werden:\n"
        URL_PATCHES "\n"
        "Fortfahren auf eigene Gefahr."},
    {TR_MISSING_FONTS_TITLE, "Schriftarten fehlen"},
    {TR_MISSING_FONTS_MESSAGE,
        "Deine Caesar 3 Installation benötigt zusätzliche Schriftarten. "
        "Du kannst Schriftarten für deine Sprache hier herunterladen:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Editor nicht installiert"},
    {TR_NO_EDITOR_MESSAGE,
        "Deiner Caesar 3 Installation fehlen die Dateien für den Editor. "
        "Du kannst die fehlenden Dateien hier herunterladen:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Ungültiges Sprachverzeichnis"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Das gewählte Verzeichnis enthält kein gültiges Sprachpaket. "
        "Bitte überprüfe das Protokoll auf Fehler."},
    {TR_BUILD_ALL_TEMPLES, "Alle"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Abbrechen"},
    {TR_BUTTON_RESET_DEFAULTS, "Zurücksetzen"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Tastenkombinationen"},
    {TR_CONFIG_ARE_YOU_SURE, "Auf Standard zurücksetzen?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Sie verlieren alle Ihre benutzerdefinierten Konfigurationen."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Sie verlieren alle Ihre benutzerdefinierten Tastenkombinationen."},
    {TR_CONFIG_TITLE, "Augustus Einstellungen"},
    {TR_CONFIG_HEADER_GENERAL, "Allgemeine Einstellungen"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Benutzeroberfläche"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Schwierigkeit"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Stadtverwaltung"},
    {TR_CONFIG_LANGUAGE_LABEL, "Sprache:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(Standard)"},
    {TR_CONFIG_GAME_SPEED, "Spielgeschwindigkeit:"},
    {TR_CONFIG_VIDEO, "Videoauflösung"},
    {TR_CONFIG_FULLSCREEN, "Vollbild"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Auflösung Fenstermodus:"},
    {TR_CONFIG_DISPLAY_SCALE, "Skalierung der Anzeige:"},
    {TR_CONFIG_CURSOR_SCALE, "Skalierung des Mauszeigers:"},
    {TR_CONFIG_AUDIO, "Audio Optionen"},
    {TR_CONFIG_VOLUME, "Lautstärke"},
    {TR_CONFIG_ENABLE_AUDIO, "Audio einschalten"},
    {TR_CONFIG_MUSIC, "Musik einschalten"},
    {TR_CONFIG_SPEECH, "Sprache einschalten"},
    {TR_CONFIG_EFFECTS, "Soundeffekte einschalten"},
    {TR_CONFIG_CITY_SOUNDS, "Stadtgeräusche einschalten"},
    {TR_CONFIG_SCROLL_SPEED, "Scrollgeschwindigkeit:"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Intro-Videos abspielen"},
    {TR_CONFIG_SIDEBAR_INFO, "Zusätzliche Informationen am rechten Bildschirmrand anzeigen"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Sanftes Scrollen aktivieren"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Verschieben der Karte am Fensterrand deaktivieren"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Verschieben der Karte mit der rechten Maustaste deaktivieren"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Das visuelle Feedback beim Planieren verbessern"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Erlaube alle Tempel nacheinander zu bauen"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Zeige Reichweite beim Bauen von Reservoirs und Brunnen"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Zeige Konstruktionsgröße beim Bauen"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Hebe Soldaten bei Berührung mit der Maus hervor"},
    {TR_CONFIG_ROTATE_MANUALLY, "Drehe Torhaus und Triumphbogen mit Tastenkombination"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Zeige Legionen am rechten Bildschirmrand"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Verschieben der Karte mit der rechten Maustaste deaktivieren"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Behebe Immigrationsfehler auf 'Sehr schwierig'"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Behebe '100 Jahre alte Geister'"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Behebe Wechsel- und Überlebenszeit des Imperators in eigenen Missionen"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Setze Fußgängerwegpunkte durch Rechtsklicken der Zielgebäude"},
    {TR_CONFIG_ENABLE_ZOOM, "Aktiviere Zoom (langsamer, benötigt mehr RAM)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Behebe unvollständige Bewertungsspalten bei geringen Zielen"},
    {TR_CONFIG_GRANDFESTIVAL, "Große Feste ermöglichen einen zusätzlichen Segen von einem Gott"},
    {TR_CONFIG_DIFFICULTY, "Schwierigkeit:"},
    {TR_CONFIG_GODS_EFFECTS, "Götterflüche/-segnungen aktivieren"},
    {TR_CONFIG_JEALOUS_GODS, "Deaktiviere Eifersucht der Götter"},
    {TR_CONFIG_GLOBAL_LABOUR, "Aktiviere globalen Arbeiterpool"},
    {TR_CONFIG_SCHOOL_WALKERS, "Vergrößere Laufreichweite von Schülern"},
    {TR_CONFIG_RETIRE_AT_60, "Erhöhe Rentenalter von 50 auf 60 Jahre"},
    {TR_CONFIG_FIXED_WORKERS, "Fester Arbeiterpool - 38% der Bevölkerung"},
    {TR_CONFIG_EXTRA_FORTS, "Ermögliche das Bauen 4 zusätzlicher Forts"},
    {TR_CONFIG_WOLVES_BLOCK, "Blockiere Gebäude in der Nähe von Wölfen"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Blockiere getrennte Straßen eines Silos"},
    {TR_CONFIG_MORE_STOCKPILE, "Häuser horten mehr Güter von Märkten"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Einkaufende Marktfrauen verteilen keine Güter"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Gebäude sofort zerstören"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Wagenschieber von sammelnden Silos können neben der Straße fahren"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doppelte Kapazität für Wagenschieber sammelnder Silos"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Erlaube Händlern Nahrung von Silos zu exportieren"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Turmwächter brauchen keine Straßenverbindung zu einer Kaserne"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Farmen und Kais liefern nur an nahegelegene Silos"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Essen wird nicht an sammelnde Silos geliefert"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Alle Häuser verschmelzen"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Das öffnen einer Handelsroute, stellt eine andere Weinsorte bereit"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Zufällig einstürzende Lehmgruben und Eisenminen nehmen hingegen Geld"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Erlaube das Errichten mehrerer Kasernen"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Warenhäuser nehmen nach dem Bau nichts an"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Häuser erweitern sich nicht in Gärten"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Wandernde Arbeiter kürzen an Ecken nicht ab"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "Stadt-Zoom konnte nicht aktiviert werden."},
		{TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Ihr System verfügt nicht über genügend Grafikspeicher, um den Stadt-Zoom zu aktivieren.\n"
        "Der Stadt-Zoom wurde nicht aktiviert."},
		{TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Anzeige des maximal erreichbaren Wohlstands mit aktuellen Behausungen."},
    {TR_HOTKEY_TITLE, "Augustus Tastenkombinationen"},
    {TR_HOTKEY_LABEL, "Schnelltasten"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativ"},
    {TR_HOTKEY_HEADER_ARROWS, "Richtungstasten"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globale Tastenkombinationen"},
    {TR_HOTKEY_HEADER_CITY, "Stadt"},
    {TR_HOTKEY_HEADER_ADVISORS, "Berater"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Spezialkarten"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Lesezeichen für Stadtkarten"},
    {TR_HOTKEY_HEADER_EDITOR, "Editor"},
    {TR_HOTKEY_HEADER_BUILD, "Tastenkombinationen zum Bauen"},
    {TR_HOTKEY_ARROW_UP, "Hoch"},
    {TR_HOTKEY_ARROW_DOWN, "Runter"},
    {TR_HOTKEY_ARROW_LEFT, "Links"},
    {TR_HOTKEY_ARROW_RIGHT, "Rechts"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Vollbild ein-/ausschalten"},
    {TR_HOTKEY_CENTER_WINDOW, "Fenster zentrieren"},
    {TR_HOTKEY_RESIZE_TO_640, "Fenstergröße: 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Fenstergröße: 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Fenstergröße: 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Screenshot speichern"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Stadtweiten Screenshot sp."},
    {TR_HOTKEY_BUILD_CLONE, "Gebäude am Mauszeiger klonen"},
    {TR_HOTKEY_LOAD_FILE, "Datei laden"},
    {TR_HOTKEY_SAVE_FILE, "Datei speichern"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Spielgeschwindigkeit erhöhen"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Spielgeschwindigkeit reduzieren"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Spiel pausieren"},
    {TR_HOTKEY_CYCLE_LEGION, "Durch Legionen schalten"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Karte nach links drehen"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Karte nach rechts drehen"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Arbeitsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Militärberater"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperiumsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Wertungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Handelsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Bevölkerungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Gesundheitsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Bildungsbearter"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Unterhaltungsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religionsberater"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finanzberater"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Hauptberater"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Wohnraumberater"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Akt. Spezialkarte umschalten"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Zeige relative Einblendung"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Wasserkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Feuerkarte"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Schadenskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Kriminalitätskarte"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problemkarte"},
    {TR_HOTKEY_ROTATE_BUILDING, "Gebäude drehen"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Gehe zu Lesezeichen 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Gehe zu Lesezeichen 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Gehe zu Lesezeichen 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Gehe zu Lesezeichen 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Setze Lesezeichen 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Setze Lesezeichen 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Setze Lesezeichen 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Setze Lesezeichen 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Kampfinfos ein-/ausblenden"},
    {TR_HOTKEY_EDIT_TITLE, "Neue Tastenkombination"},
    {TR_BUILDING_ROADBLOCK, "Straßensperre"},
    {TR_BUILDING_ROADBLOCK_DESC, "Straßensperren verhindern das unkontrollierte Umherwandern von Einwohnern."},
    {TR_BUILDING_ARCHITECT_GUILD, "Baumeistergilde"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Die Baumeister arbeiten unermüdlich an der Konstruktion von Monumenten für den Ruhm und die Pracht Roms."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Tempel eine Widmung geben"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres' Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptuns Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Merkurs Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars' Prachttempel"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus' Prachttempel"},
    {TR_BUILDING_PANTHEON, "Pantheon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Prachttempel der Ceres"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Prachttempel des Neptun"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Prachttempel des Merkur"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Prachttempel des Mars"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Prachttempel der Venus"},
    {TR_BUILDING_PANTHEON_DESC, "Pantheon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Wagenschieber von Farmen bewegen sich 50% schneller"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Reichweite von Brunnen und Ziehbrunnen +1, Reservoirs +2. Benötigte Arbeitskräfte für Wasserdienste um 50% reduziert. Handelsschiffe bewegen sich 25% schneller."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Händler zur See und an Land haben 50% zusätzliche Kapazität. Händler an Land bewegen sich 25% schneller."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Gestattet den Bau von vier extra Forts und funktioniert als zusätzliche Barracke."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Dekorationen und Tempel erstrahlen in neuem Glanz und steigern die Attraktivität. Häuser lagern mehr Waren und bleiben auch ohne Dienste und Waren länger bestehen."},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Priester des Pantheons bieten Zugang zu allen fünf Gottheiten. Reduziert die Kosten von Tempelarbeitern um 25% und hält kostenlos kleine jährliche Feste ab."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Priester reduzieren Nahrungsverbrauch um 20% in Häusern mit Zugang zu einem Tempel der Ceres."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Tempel des Neptun produzieren Wagenlenker für die Hippodrome."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Priester des Merkur reduzieren Geschirr- und Möbelverbrauch um 20% in Häusern mit Zugang zu einem Tempel des Merkur."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Priester des Mars erzeugen einmal pro Monat Nahrung, wenn sie Häuser passieren und liefern diese an den Versorgungsposten, sobald eine gewisse Menge erreicht ist. Dies erfordert eine Straßenverbindung."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Der Prachttempel produziert Wein im Verhältnis zur Bevölkerung mit Zugang zu Tempeln der Venus. Priester verteilen ihn an die Häuser."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Tempel der Ceres agieren als Märkte. Sie sammeln und verteilen ein lokal produziertes Nahrungsmittel und Öl."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Priester erhöhen das Limit an Bewohnern um 5% für Häuser mit Zugang zu Tempeln des Neptun. Der Prachttempel des Neptun dient als gefülltes Reservoir ohne Zugang zu Gewässern zu benötigen."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Priester reduzieren Öl- und Weinkonsum um 20% in Häusern mit Zugang zu einem Tempel des Merkur."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Priester reduzieren den Verbrauch aller Waren um 10% in Häusern mit Zugang zu einem Tempel des Mars."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Priester bieten Unterhaltung und verschönern Häuser, dies steigert die Attraktivität der Nachbarschaft ohne weitere Dekorationen."},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Alle Tempel der Stadt senden Priester zum Pantheon. Diese Priester verbreiten den Glauben und Segen ihrer Götter!"},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Häuser mit Zugang zum Pantheon können sich eine Stufe weiterentwickeln."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Templum Ceres Promitor"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Templum Ceres Reparator"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Templum Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Templum Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Templum Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Templum Mercurius Abundantia"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Templum Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Templum Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Templum Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Templum Venus Genetrix"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Prachttempel"},
    {TR_BUILDING_WORK_CAMP, "Arbeiterlager"},
    {TR_BUILDING_WORK_CAMP_DESC, "Arbeiter versammeln sich hier, um Materialien an Baustellen zu liefern."},
    {TR_HEADER_HOUSING, "Wohnungsberater"},
    {TR_ADVISOR_HOUSING_ROOM, "In der Stadt gibt es noch Platz für"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "In der Stadt gibt es keinen Wohnraum mehr."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Bevölkerungsnachfrage an Einheiten Geschirr"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Bevölkerungsnachfrage an Einheiten Möbeln"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Bevölkerungsnachfrage an Einheiten Öl"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Bevölkerungsnachfrage an Einheiten Wein"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Wohnhäuser insg.:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Verf. Kapazität:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Kapazität insg.:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Bevölkerung - Wohnraum"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Diagramme"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Der Wohnungswohlstand beträgt"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Die Bevölkerungszahl in Villen und Palästen beträgt"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Die Bevölkerungszahl in Zelten und Baracken beträgt"},
    {TR_ADVISOR_AVERAGE_TAX, "Durchschnittl. Steuereinnahmen pro Wohnhaus betragen"},
    {TR_ADVISOR_AVERAGE_AGE, "Das durchschnittliche Alter der Bevölkerung beträgt"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Die Bevölkerungszahl in der Arbeiterschaft beträgt"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Geburten im vergangen Jahr:"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Tode im vergangen Jahr:"},
    {TR_ADVISOR_TOTAL_POPULATION, "Einwohner"},
    {TR_ADVISOR_IN_STORAGE, "im Lager"},
    {TR_ADVISOR_FROM_GRANARIES, "von Silos"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Auslieferung von Nahrung aus Silos"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Seid Ihr sicher?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Ressource weiter hamstern"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Der maximale Wohlstand für die aktuelle Behausungsstufe ist"},
    {TR_REQUIRED_RESOURCES, "Gelieferte Ressourcen für aktuelle Phase:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "Der Bau eines Prachttempels benötigt in einem Lagerhaus gelagerte Waren, Arbeiter von einem Arbeiterlager und Baumeister von einer Baumeistergilde."},
    {TR_CONSTRUCTION_PHASE, "Konstruktionsphase:"},
    {TR_ADD_MODULE, "Tempel umwidmen?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Widmung zugewiesen."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Ceres teilte zuerst mit gebogenem Pfluge die Schollen,\nGab Feldfrüchte den Ländern zuerst\n und mildere Nahrung,\nOrdnete Sitten zuerst; ja, alles ist Gabe der Ceres.\nCeres gebührt mein Sang.\n-Ovid, die Metamorphose; Ceres und Proserpina"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Nicht bleibt zürnend die See. Hinlegend die zackige Waffe\nGlättet die Flut der Beherrscher des Meers,\nUnd den bläulichen Triton rufet er,\nDer an der Schulter bedeckt von haftenden Schnecken\nÜber der Tiefe sich hebt und heißt in die tönende Muschel.\n-Ovid, die Metamorphose; Deukalion und Pyrrha"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Beutet man doch im Kriege gemästete Rinder und Schafe,\nUnd gewinnt Dreifüß' und braungemähnete Rosse;\nAber des Menschen Geist kehrt niemals,\nweder erbeutet, noch erlangt, \nnachdem er des Sterbenden Lippen entflohn ist.\n-Homer, Die Ilias; 9. Gesang"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Andere schufen für Mars ein Fahrzeug\nmit fliegenden Rädern, wie er es braucht,\num Menschen und Städte aufs Schlachtfeld zu hetzen.\n-Virgil, die Aeneis; achter Gesang"},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Venus du holde mitsamt dem beflügelten Sohne Cupido,\nOh, was empfand ich für Lust!\n Wie deutlich gefühltes Entzücken nahm mich dahin!\nWie lag ich gelöst im innersten Marke!\n-Ovid, Die Metamorphose; Byblis"},
    {TR_BUILDING_PANTHEON_QUOTE, "Weit auf tut sich indes des Olymps allmächtiges Haus,\nes Ruft zur Versammlung der Vater der Götter\nund König der Menschen.\nIn dem gestirnumstrahlten Palast,\nvon wo er auf alle Länder, der Dardaner Burg\nund Latiums Völker hinabschaut.\n-Virgil, Die Aeneis; Zehnter Gesang"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Bauarbeiter errichten das Podium, welches den Tempel emporheben und als solides Fundament dienen wird, um die Zeit zu überdauern."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Handwerker fertigen den Portico, in welchem sich der Opferaltar des Tempels befindet."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Baumeister errichten die Cella. In diesem innersten Raum des Tempels steht die Statue der Gottheit. Die Cella gilt als heiliger Ort der Gottheit. "},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Die Arbeit am Praecinctum hat begonnen, wo Gläubige sich für öffentliche Zeremonien versammeln."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Mit dem Tempel beinahe fertiggestellt, sammeln sich Priester um die Rieten der Tempelweihe durchzuführen. "},
    {TR_BUILDING_MENU_TREES, "Bäume"},
    {TR_BUILDING_MENU_PATHS, "Pfade"},
    {TR_BUILDING_MENU_PARKS, "Parkanlagen"},
    {TR_BUILDING_SMALL_POND, "Kleiner Teich"},
    {TR_BUILDING_LARGE_POND, "Großer Teich"},
    {TR_BUILDING_PINE_TREE, "Tanne"},
    {TR_BUILDING_FIR_TREE, "Kiefer"},
    {TR_BUILDING_OAK_TREE, "Eiche"},
    {TR_BUILDING_ELM_TREE, "Ulme"},
    {TR_BUILDING_FIG_TREE, "Feige"},
    {TR_BUILDING_PLUM_TREE, "Pflaume"},
    {TR_BUILDING_PALM_TREE, "Palme"},
    {TR_BUILDING_DATE_TREE, "Dattel"},
    {TR_BUILDING_PINE_PATH, "Tannenpfad"},
    {TR_BUILDING_FIR_PATH, "Kiefernpfad"},
    {TR_BUILDING_OAK_PATH, "Eichenpfad"},
    {TR_BUILDING_ELM_PATH, "Ulmenpfad"},
    {TR_BUILDING_FIG_PATH, "Feigenpfad"},
    {TR_BUILDING_PLUM_PATH, "Pflaumenpfad"},
    {TR_BUILDING_PALM_PATH, "Palmenpfad"},
    {TR_BUILDING_DATE_PATH, "Dattelpfad"},
    {TR_BUILDING_BLUE_PAVILION, "farbige Pavillons"}, //Ehemals blauer Pavillon jetzt aber mit Farbrotation.
    {TR_BUILDING_RED_PAVILION, "Roter Pavillon"}, //inaktiv
    {TR_BUILDING_ORANGE_PAVILION, "Oranger Pavillon"}, //inaktiv
    {TR_BUILDING_YELLOW_PAVILION, "Gelber Pavillon"}, //inaktiv
    {TR_BUILDING_GREEN_PAVILION, "Grüner Pavillon"}, //inaktiv
    {TR_BUILDING_SMALL_STATUE_ALT, "Göttinenstatue"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Senatorenstatue"},
    {TR_BUILDING_OBELISK, "Obelisk"},
    {TR_BUILDING_POND_DESC, "Teiche füllen sich aus Reservoirs und versorgen Pflanzen und Tiere mit Wasser und als Oase der Natur dienen Einwohnern zur Entspannung. Alle Bewohner würden liebend gerne in der Nähe eines Teiches wohnen."},
    {TR_BUILDING_WINDOW_POND, "Teich"},
    {TR_BUILDING_OBELISK_DESC, "Ein prestigeträchtiges Monument, die Arbeit eines antiken König des Nils. Die Ägypter hatten keine Verwendung dafür."},
    {TR_ADVISOR_FINANCE_LEVIES, "Gebäudekosten"},
    {TR_CONFIRM_DELETE_MONUMENT, "Dieses Monument abreißen?"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Widmung auswählen"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Die Wahl einer Widmung wird den Tempel unwiderruflich und dauerhaft auf einen Aspekt seiner Gottheit spezialisieren und die Priester mit göttlicher Macht erfüllen. Die kosten dafür betragen 1000 Dn."},
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/ Monat"},
    {TR_BUILDING_MESS_HALL, "Versorgungsposten"},
    {TR_BUILDING_MESS_HALL_DESC, "Der Versorgungsposten sammelt Nahrung aus Silos, um die Soldaten der Stadt zu versorgen. Ein schlecht versorgter Posten verlangsamt die Ausbildung neuer Soldaten und verringert die Moral der Truppen."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Versorgung des letzten Monats:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Soldaten sind: "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "gut genährt"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "satt"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "hungrig"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "sehr hungrig"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "am Verhungern"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Die abwechslungsreiche Ernährung verbessert die Moral Ihrer Soldaten."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Ihre Soldaten genießen das vielfältige und reichhaltige Nahrungsangebot. Ihre Moral steigt enorm."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Ihr habt keine Soldaten zu ernähren."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Gelagerte Nahrung in Monaten:"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Anweisungen für Posten"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Nahrungsknappheit im Versorgungsposten verlangsamt die Ausbildung neuer Soldaten."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Kritische Nahrungsknappheiten an deinen Versorgungsposten verlangsamen die Sodatenrekrutierung."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Kürzliche Nahrungsknappheit verringert die Moral."},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Moral durch Nahrungsknappheit enorm verringert."},
    {TR_BUILDING_LEGION_STARVING, "Schwach vor Hunger"},
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "Keine Begrenzung"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importierbar"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportierbar"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Niemand kauft diese Ressource."},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Niemand verkauft diese Ressource."},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "kein Import"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "kein Export"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Öffnet Handelsroute für Import"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Öffnet Handelsroute für Export"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Ihre Soldaten haben ausreichend Nahrung."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Ihre Soldaten benötigen mehr Nahrung."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Ihre Soldaten verhungern!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Gelagerter Nahrung im Versorgungsposten in Monaten:"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Hungrige Soldaten"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "In Ihrem Versorgungsposten befindet sich sehr wenig Nahrung und die Moral der Truppen schwindet. Stellt sicher, der Versorgungsposten Zugang zu einem gut gefüllten Silo hat."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Ihre Stadt hat den Versorgungsposten verloren und die Soldaten hungern! Baut umgehend einen neuen!"},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Zu sammelnde Waren"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Anweisungen für Dock"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Anweisungen für Tempel"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Anweisungen für Taverne"},
    {TR_WARNING_NO_MESS_HALL, "Ihr müsst zunächst einen Versorgungsposten bauen, um Ihre Soldaten zu ernähren."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "In einer Stadt können nur zwei Prachttempel gebaut werden."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Prachttempel fertiggestellt"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Priester und Verehrer der Gottheit sammeln sich für die Riten der Tempelweihe in Scharen am neuen Prachttempel. Ihre Einwohner bewundern das majestätische Bauwerk und die Gottheit überhäuft Sie mit ihrer Gunst."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Eine Segnung des Merkur"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Hocherfreut von Ihrer Hingabe, hat Merkur die Industrie der Stadt gesegnet und Ihre Lager mit Rohmaterialien gefüllt."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Vorarbeiter"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Träger"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Baumeister"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Quartiermeister"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Lagerarbeiter"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Die Priester des Prachttempels der Ceres unterstützen die Versorgung hungriger Einwohner mit Nahrung und Öl."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Der Prachttempel der Venus ermöglicht ihren Priestern, die Bevölkerung mit gesegnetem Wein zu versorgen."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Die Priester des Prachttempels des Mars sammeln Lebensmittelspenden für Ihre Truppen, um diese an den Versorgungsposten zu liefern."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Tempel der Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Tempel des Neptun"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Tempel des Merkur"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Tempel des Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Tempel der Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Priester"},
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Städte mit eröffneter Seeroute:"},
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Es wurden keine Seerouten eröffnet."},
    // Transkription von mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Ich werde tun, was ich kann, um diese Barbaren zu beruhigen. Ich bin sicher, dass sie ihre Angriffe auf die Stadt einstellen werden, wenn ich einfach nur mit ihnen spreche.\""},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Ein jährliches Fest"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Die Gläubigen strömen zu Tempeln, um Cerealia zu Ehren von Ceres zu feiern. Landwirte bringen Opfer für reiche Ernten in den kommenden Jahren."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Heute ist das Fest von Neptunalia zu Ehren des Neptun. Die Gläubigen bauen Hütten aus Ästen und Blattwerk und feiern fröhlich unter der lodernden Hitze der Mittsommersonne."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Händler und Kaufleute feiern in Scharen Mercuralia. In der Hoffnung auf göttlichen Schutz durch den Gott Merkur wird heiliges Wasser auf Schiffe und Lagerhäuser gespritzt."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Die Bürger versammeln sich außerhalb der Stadt zur Feier von Equirria, um die Gunst des Mars zu ersuchen. Die Luft ist erfüllt vom Donner der Hufe und dem Knarren der Streitwagen, wenn Gläubige Rennen zu Ehren ihres Gottes veranstalten."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Die Gläubigen versammeln sich zur Feier von Veneralia, einem Tag, der der Venus heilig ist. Ihre Bürger bitten sie um Glück in Herzensangelegenheiten."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Gelesene Nachrichten löschen"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Gebäude deaktivieren"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Gebäude aktivieren"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Erlaube Marktfrauen von hier Waren zu holen"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Erlaube Karawanen hier Handel zu treiben"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Erlaube Handelsschiffen hier Handel zu treiben"},
    {TR_BUILDING_CARAVANSERAI, "Karavanserai"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Die Handelskarawanen nutzen diesen Rastplatz und verzehren Lebensmittel."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Anweisungen für Karavanserai"}, //vielleicht zu lang
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fundament)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Arbeiter legen das Fundament des zukünftigen Rastplatzes."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Karavanserai-Lieferant"},
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Landhandelspolitik"},
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Keine Landhandelspolitik."},
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Wählen Sie die Handelspolitik in Ihrer Stadt. Dies kostet 500 Dn."},
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium Venditor"},
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Karawanen bezahlen 20% mehr für Waren, aber Verkaufen ihre Ware 10% teurer."},
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium Acquisitionem"},
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Karawanen verkaufen ihre Waren 20% günstiger, aber zahlen 10% weniger für Waren."},
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium Quantitas"},
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Karawanen tragen 4 Waren mehr, aber ihre Geschwindigkeit ist um 10% reduziert."},
    {TR_BUILDING_LIGHTHOUSE, "Leuchtturm"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fundament)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Sockel)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Turm)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(First)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Bauarbeiter legen ein starkes Fundament, um das Gewicht eines großen steinernen Turms zu tragen."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Baumeister konstruieren den Sockel, der die Flamme des Leuchtturms weit über den Hoizont erheben wird."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Der Leuchtturm wächst jeden Tag etwas höher, während die Bauarbeiter ihre Arbeit verrichten."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Baumeister geben dem Leuchtturm den letzten Schliff. Bald schon wird er kilometerweit leuchten und Schiffen den Weg weisen."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Die Konstruktion des Leuchtturms benötigt gelagerte Materialien aus einem Lagerhaus, Bauarbeiter aus einem Arbeiterlager und Baumeister einer Baumeister Gilde."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Fischerboote bewegen sich 10% schneller und eine stürmische See beruhigt sich doppelt so schnell."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Seehandelspolitik" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Keine Seehandelspolitik." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Wählen Sie eine Seehandelspolitik für Ihre Stadt. Sie können sie jederzeit kostenpflichtig ändern." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Maritime Verkaufspolitik: Exporte per Handelsschiff bringen 20% mehr Gewinn, aber Importe per Schiff sind 10% teurer." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Maritime Einkaufspolitik: Handelsschiff-Importe sind 20% billiger, aber seegestützte Exporte bringen 10% weniger Gewinn." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Maritime Mengenpolitik: Handelsschiffe transportieren 4 Waren mehr, bewegen sich aber 15% langsamer." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monumente"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Der fertige Leuchtturm, ein mächtiger Turm aus Stein, der über den Horizont ragt. Möge sein Leuchtfeuer Seefahrer bis zum Ende der Zeit nach Hause leiten."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Das Pantheon ist fertiggestellt. Unerreicht steht es als Monument für die großartige Macht der Götter und des Volkes von Roms."},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument fertiggestellt"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Eine Segnung von Neptun"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Neptun belohnt die Hingabe Ihrer Einwohner und garantiert Seefahrern eine sichere Überfahrt für 12 Monate und 50% mehr Einnahmen aus Exporten in diesem Zeitraum."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Eine Segnung von Venus"},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Erfreut über die Ehrfurcht, die ihr entgegengebracht wird, verleiht Venus Ihrem Volk Jugendlichkeit, Gesundheit und Glück und erhöht so die Größe Ihrer arbeitenden Bevölkerung."},
    {TR_BUILDING_MENU_STATUES, "Statuen"},
    {TR_BUILDING_MENU_GOV_RES, "Gouverneursanwesen"},
    {TR_OVERLAY_ROADS, "Straßen"},
    {TR_NO_EXTRA_ASSETS_TITLE, " Extra Assets wurden nicht geladen"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Extra Augustus Assets wurden nicht geladen.\n"
        "Das kann durch ein fehlendes oder veraltetes Assetverzeichnis passieren.\n"
        "Bitte stellen Sie sicher, dass die das aktuellste Assetverzeichnis haben, welches durch Github bereitgestellt wird."},
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Leuchtturm muss nah am Wasser platziert werden."},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Dieses Haus hat durch das Pantheon Zugang zu allen fünf Göttern."},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Reichhaltiges Nahrungsangebot steigert die Moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Versorgungsstatus"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Erlaube Quartiermeister von hier Nahrung zu holen"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Ihr könnt die benötigten Waren nicht erhalten."},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Abgeschlossene Prachttempel gewähren eine Kulturbewertung von +8"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Deaktiviere unendliches Erscheinen von Wölfen"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Zurück zum Hauptmenü"},
    {TR_LABEL_PAUSE_MENU, "Pause"},
    {TR_OVERLAY_LEVY, "Abgaben"},
    {TR_TOOLTIP_OVERLAY_LEVY, " Monatlich Abgaben in Denarii."},
    {TR_MAP_EDITOR_OPTIONS, "Szenario Einstellungen"},
    {TR_BUILDING_TAVERN, "Taverne"},
    {TR_BUILDING_GRAND_GARDEN, "Großer Garten"},
    {TR_BUILDING_TAVERN_DESC_1, "Diese Taverne hat keine Arbeiter und kann das Geschäft nicht eröffnen."},
    {TR_BUILDING_TAVERN_DESC_2, "Diese Taverne hat keinen Wein und kann das Geschäft nicht eröffnen."},
    {TR_BUILDING_TAVERN_DESC_3, "Diese Taverne bietet Unterhaltung solange der Wein fließt. Eine Versorgung mit Fleisch würde ihre Attraktivität erhöhen."},
    {TR_BUILDING_TAVERN_DESC_4, "Reichlich Wein und der Geruch von gebratenem Fleisch locken ein lebhaftes Publikum in diese Taverne zu Glücksspiel, Musik und Fröhlichkeit."},
    {TR_FIGURE_TYPE_BARKEEP, "Gastwirt"},
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Tavernen-Lieferant"},
    {TR_OVERLAY_TAVERN, "Taverne"},
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Dieses Haus hat keinen Zugang zu einer Taverne oder die Taverne hat keinen Wein mehr."},
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Kein Gastwirt kam in letzter Zeit vorbei. Dieses Haus wird bald den Zugang zu seiner Taverne verlieren."},
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Dieses Haus wurde von einem Gastwirt einer Taverne mit Wein besucht."},
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Dieses Haus wurde von einem Gastwirt einer Taverne mit Wein und Fleisch besucht."},
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Dieses Haus wurde kürzlich von einem Gastwirt einer Taverne mit Wein besucht."},
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Dieses Haus wurde kürzlich von einem Gastwirt einer Taverne mit Wein und Fleisch besucht. Hoch die Gläser!"},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Die Bewohner verabscheuen Ihren Namen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Die Bewohner sind sehr sauer auf Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Die Bewohner sind sauer auf Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Die Bewohner sind sehr verärgert von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Die Bewohner sind verärgert von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Die Bewohner sind genervt von Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Die Bewohner sind gleichgültig gegenüber Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Die Bewohner sind zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Die Bewohner sind sehr zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Die Bewohner sind extrem zufrieden mit Ihnen."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Die Bewohner lieben Sie."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Die Bewohner vergöttern Sie wie einen Gott."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Die Bewohner sind verärgert über hohe Steuern."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Die Bewohner sind verärgert über niedrige Bezahlung."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Die Bewohner sind verärgert über fehlende Arbeitsplätze."},
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Die Bewohner sind verzweifelt über ihre schlechte Unterbringung."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Die Bewohner würden mehr Unterhaltung schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Die Bewohner würden eine abwechslungsreiche Ernährung schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Die Bewohner würden mehr Attraktivität schätzen."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Die Stimmung der Bewohner wird durch ein kürzlich stattgefundenes Ereignis gehoben."},
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Die Bewohner sind durch ein aktuelles Ereignis entmutigt."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tavernen"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Spiele"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Sponsern Sie große Spiele in Ihrem Kolosseum, die persönliches Sparguthaben und Ressourcen Ihrer Stadt kosten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Spiele abhalten"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Die Großen Spiele werden vorbereitet."},
    {TR_SELECT_GAMES_HEADER, "Spiele"},
    {TR_SELECT_GAMES_TEXT, "Die Spiele werden im Kolosseum ausgetragen und kosten persönliches Sparguthaben und Ressourcen Ihrer Stadt."},
    {TR_BUILDING_ARENA, "Arena"},
    {TR_BUILDING_HORSE_STATUE, "Reiterstatue"},
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Delphinbrunnen"},
    {TR_BUILDING_HEDGE_DARK, "dunkle Hecke"},
    {TR_BUILDING_HEDGE_LIGHT, "helle Hecke"},
    {TR_BUILDING_GARDEN_WALL, "Gartenmauer"},
    {TR_BUILDING_LEGION_STATUE, "Legionärsstatue"},
    {TR_BUILDING_DECORATIVE_COLUMN, "Marmorsäule"},
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogäum)"},
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fundament)"},
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arkaden)"},
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Gallerie)"},
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Arbeiter graben im Untergrund das Hypogäum, Tunnel und konstruieren die Maschinen aus den die großen Spektakel entspringen."},
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Die Mauern des Kolosseums nehmen Gestalt an, während Sitzreihen für Bürgerliche und Kaiser angelegt werden."},
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Anmutige Bögen ragen in den Himmel, um das mächtige Kolosseum in die Höhe zu halten."},
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Das Kolosseum ragt in den Himmel, seine Wände sind mit schimmerndem Marmor und Statuen verkleidet."},
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Rennbahn)"},
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fundament)"},
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Tribüne)"},
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fassade)"},
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Das riesige Gelände wird derzeit akribisch vermessen und für ein Projekt von noch nie dagewesenem Ausmaß gerodet."},
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Zufahrten und Stützkonstruktionen werden um die Strecke herum gebaut."},
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Steinmetze meißeln Sitzgelegenheiten für Zehntausende."},
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Mehr als eine bloße Rennstrecke: Handwerker erschaffen ein Monument, das den Göttern und dem Volk von Rom würdig ist."},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Für den Bau des Monuments werden in einem Lagerhaus gelagerte Materialien, Arbeiter aus einem Arbeitslager und Baumeister aus einer Baumeistergilde benötigt."},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Bau gestoppt."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenen"},
    {TR_BUILDING_INFO_TOURISM, "(Reisende)"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Das Kolosseum ist fertig! Last die Spiele beginnen!"},
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Das Hippodrom ist fertiggestellt. Die Bürger warten sehnsüchtig auf Ihr Kommando die Rennen zu beginnen!"},
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Einweihungsspiele"},
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Die Rennen beginnen"},
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Die Einweihungsspiele für Ihr Kolosseum haben begonnen. Auf Ihren Befehl hin wird dieses Monument mit dem Blut der Tapferen geweiht!"},
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Die Stadt leert sich, als die Menschen zum Hippodrom strömen, um die ersten Wagenrennen zu sehen. Ein ohrenbetäubender Jubel erfüllt die Luft, als sich die Tore öffnen!"},
    {TR_WINDOW_GAMES_OPTION_1, "Naumachie abhalten"},
    {TR_WINDOW_GAMES_OPTION_2, "Tierhetze abhalten"},
    {TR_WINDOW_GAMES_OPTION_3, "Kalendae des Januarius abhalten"},
    {TR_WINDOW_GAMES_OPTION_4, "Olympische Spiele abhalten"},
    {TR_WINDOW_GAMES_OPTION_5, "Römische Spiele abhalten"},
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Das Kolosseum wird geflutet, um eine große Seeschlacht nachzuspielen. Die Bewegungsgeschwindigkeit Ihrer Truppen und ihre Stärke in entfernten Schlachten werden für das nächste Jahr erhöht."},
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Das Kolosseum wird Schauplatz grausamer Tierhetzen und Hinrichtungen durch wilde Bestien, die die plebejischen Klassen erfreuen. Verbrechen, Aufruhr und Revolten werden für das nächste Jahr unterdrückt. Gladiatoren werden helfen, die Stadt vor der nächsten Invasion zu verteidigen."},
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Im Kolosseum finden am ersten Tag des nächsten Jahres Spiele zu Ehren der Götter statt, bei denen Glück und Wohlstand erbeten werden. Die Handelsquoten werden im nächsten Jahr verdoppelt."},
    {TR_WINDOW_GAMES_OPTION_4_DESC, "Das Hippodrom wird Ort der Olympischen Spiele sein. Ihre Stadt wird Scharen von Besuchern beherbergen, und wenn die Athleten Ihre Stadt gut ehren, werdet Ihr einen dauerhaften Anstieg des Tourismus und der Gunst gewinnen."},
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Im Kolosseum finden die Römischen Spiele statt, zu denen Menschen aus dem ganzen Reich in Ihre Stadt reisen, um sich zu messen. Ein solch großes Spektakel wird Ihnen sicherlich die Gunst des Kaisers und des einfachen Volkes für das nächste Jahr einbringen."},
    {TR_WINDOW_GAMES_COST, "Kosten:"},
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(Sparguthaben)"},
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Nicht genügend Sparguthaben."},
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Nicht genügend Ressourcen gelagert."}, 	
    {TR_WINDOW_GAMES_NO_VENUE, "Anlage nicht gebaut oder hat keine Arbeiter."},
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Konstruktion)"},
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Steinmetze und Baumeister bauen dieses Bauwerk aus schimmerndem Marmor sorgfältig auf."},
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Für den Bau dieses Tempels werden Material aus einem Lager, Arbeiter aus einem Arbeitslager und Baumeister aus einer Baumeistergilde benötigt."},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Wasser aus den Reservoirs der Stadt füllt langsam das Kolosseum. Zimmerleute beginnen, lebensechte Kriegsschiffe zu montieren, während Gladiatoren den Kampf auf dem Wasser trainieren. Bald beginnen die Seeschlachten!"},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Das Kolosseum ist zu einem künstlichen See geworden, in dem Gladiatoren große römische Siege zu Wasser nachspielen. Blut und Wasser vermischen sich, während die Menge ihre Zustimmung brüllt. Die Naumachien - die Seeschlachten - haben begonnen.!"},
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Für das Kolosseum beginnt ein langer Aufräumprozess, denn es wird trockengelegt und für die normale Nutzung vorbereitet. Ihr Volk wird noch jahrelang über dieses nasse Spektakel sprechen."},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Seltsame Fracht beginnt in Ihrer Stadt aufzutauchen, als Händler aus den Weiten der Erde schreckliche Bestien in die Käfige unter dem Kolossum liefern. Bald wird ein grausiges Spektakel Ihr Volk begeistern."},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Verurteilte Verbrecher und Gladiatoren auf der Suche nach dem ultimativen Ruhm stellen sich dem Tod in Form von Zähnen und Klauen. Mit einem Trompetenstoß haben die Tierhetzen begonnen!"},
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Die letzten der wilden Tiere liegen erschlagen im Sand des Kolosseums, ihr Blut vermischt sich mit dem der Verurteilten. Die Tierhetzen haben ein Ende."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Wir begrüßen das neue Jahr mit einem glorreichen Spiel zu Ehren der Götter. Im Gegenzug bitten wir um Glück, Wohlstand und Segen in Sachen Handel."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Die Spiele beginnen bei Sonnenaufgang an den Kalenden des Ianuarius. Priester führen Tieropfer durch, während Gladiatoren ihre Arme gürten, um auf der Suche nach der Gunst des Göttlichen zu sterben."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Auguren vermuten, dass die Götter über unsere großen Spiele und die ihnen dargebrachten Opfer und Ehrerbietungen sehr erfreut waren. Wir können ein sehr profitables Jahr erwarten!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Alle Augen werden auf Ihre Stadt gerichtet sein, wenn die Olympischen Spiele Reisende, Wettkämpfer und römische Würdenträger aus aller Welt anlocken. Es wird nicht weniger als ein ganzes Jahr dauern, bis alle möglichen Vorbereitungen getroffen sind."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Endlich ist der Tag gekommen. Die heilige Flamme wird entzündet, und die Straßen der Stadt sind menschenleer, während die Bürger in das große Hippodrom strömen. Lasst die Rennen beginnen!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Die heilige Flamme ist erloschen, und Reisende und Bürger strömen in müdem Jubel nach Hause. Ewiger Ruhm gebührt Ihnen für die erfolgreiche Ausrichtung dieser uralten und heiligen Feier der sterblichen Stärke und Ehre."},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Mit der Ankündigung der Römischen Spiele strömen Menschen aus den entlegensten Winkeln des Imperiums in Ihre Stadt, viele in der Hoffnung, die bevorstehenden Wettbewerbe zu gewinnen. Es wird nicht weniger als ein ganzes Jahr dauern, um jede mögliche Vorbereitung abgeschlossen zu sehen."},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Die feierliche Prozession beginnt, und mit ihr die Römischen Spiele. Möge Jupiter selbst über die Besten der heutigen Wettkämpfer bei Rennen, Kämpfen und anderen Leistungsprüfungen richten. Das Kolosseum ist bis zum Rand mit Bürgern gefüllt, die auf die Spiele und die üblichen Geschenke von Getreide und Olivenöl warten. Mögen die Spiele beginnen!"},
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Der letzte Tag der Römischen Spiele neigt sich dem Ende zu. Voller Aufregung und mit vollen Mägen hat jeder Bürger die Herrlichkeit des römischen Lebens gekostet. Ruhm für die Sieger der Spiele und Ruhm für den Statthalter!"},
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Die Großen Spiele"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Monate, bis neue Spiele abgehalten werden können:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Monate bis zur Naumachie:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Die Seeschlacht ist in vollem Gange. Das Plätschern des Wassers, das Knarren der Balken und die Kampfschreie der Gladiatoren mischen sich mit dem Gebrüll der Menge."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Monate bis zur Tierhetze:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Die Tierhetzen sind in vollem Gange. Schulter an Schulter schreit sich der Mob heiser, während  die wilden Bestien ihre menschliche Beute jagen."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Monate bis zu den Kalendae des Ianuarius:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Die Kalendae des Ianuarius sind in vollem Gange. Der Geruch von Tieropfern und Weihrauch überwältigt sogar das stechende Blut und den Schweiß der Arena."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Monate bis zu den Olympischen Spielen:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Die Olympischen Spiele sind in vollem Gange. Das heilige Feuer brennt Tag und Nacht, während die Athleten um unsterblichen Ruhm wettstreiten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Monate bis zu den Römischen Spielen:"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Die Römischen Spiele sind in vollem Gange. Jeder Teilnehmer setzt sein Blut, seinen Schweiß und seine Tränen ein, um sich als der beste Römer zu beweisen."},
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Die Großen Spiele werden fortgesetzt für weitere"}, // ...XX Days, 
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "Die Großen Spiele wurden kürzlich abgehalten."},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Die Großen Spiele sind im Gange! Ihre Stadt wimmelt von Reisenden und Feiernden."},
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Die Arena ist geschlossen. Vögel bauen Nester auf den leeren Plätzen."},
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Diese Arena beherbergt weder Löwen noch Gladiatoren, und bietet wenig Unterhaltung."},
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "In dieser Arena finden Gladiatorenkämpfe und Tierhetzen statt, zur Freude der Einheimischen."},
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Regelmäßige Vorstellungen von Gladiatoren unterhalten den Mob, aber Löwen würden das Spektakel aufwerten."},
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Hungrige Bestien streifen durch die Arena auf der Suche nach Beute, aber ein Mangel an trainierten Gladiatoren sorgt für kurze Vorstellungen."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Dieser Tempel sammelt Nahrung für Ihre Versorgungsposten, sobald er gebaut ist."},
    {TR_OVERLAY_ARENA_COL, "Arena"},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Dieses Haus hat keinen Zugang zu einer Arena oder dem Kolosseum."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Dieses Haus hat Zugang zu einer Arena mit einer Vorstellung."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Dieses Haus hat Zugang zu einer Arena mit zwei Vorstellungen."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Dieses Haus hat Zugang zum Kolosseum, mit einer Vorstellung."},
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Dieses Haus hat Zugang zum Kolosseum, mit zwei Vorstellungen."},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Die Arbeiter streiken"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Kein Wasserzugang"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Warten auf den Wagenschieber"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Keine Ressourcen verfügbar"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Gebäude stillgelegt"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Zu viele Gebäude dieses Typs - Reisende meiden diesen Ort."},
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Einnahmen von Reisenden in diesem Jahr:"},
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Ihr Handelsberater hat einen Stopp der Fischproduktion angeordnet."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribut/Zins"},
    {TR_WINDOW_ADVISOR_TOURISM, "Sonstiges"},
    {TR_WINDOW_FIGURE_TOURIST, "Dieser Reisende hat:"},
    {TR_FIGURE_TYPE_TOURIST,  "Reisender"},
    {TR_MAP_EDITOR_OPTIONS, "Szenario Einstellungen"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Inkompatible Speicherstand-Version"},
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Der Speicherstand, den Sie zu laden versuchen, ist für eine neuere Version von Augustus.\n Bitte aktualisieren Sie Augustus auf die neueste Version."},
    {TR_BUILDING_COLONNADE, "Kolonnade"},
    {TR_BUILDING_LARARIUM, "Lararium"},
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Dieser kleine Schrein ist den Ahnengeistern des römischen Volkes gewidmet. Hier können kleine Opfer und Gebete dargebracht werden."},
    {TR_BUILDING_WATCHTOWER, "Wachturm"},
    {TR_BUILDING_WATCHTOWER_DESC, "Bogenschützen auf den Zinnen dieses Turms halten wachsam Ausschau nach jedem Anzeichen von Eindringlingen, während Wächter unten auf den Straßen patrouillieren."},
    {TR_BUILDING_NYMPHAEUM, "Nymphaeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Dieser große Tempel ist den Wassernymphen gewidmet - kleineren Gottheiten des Frühlings, des Flusses und des Meeres. Er verspricht dem umliegenden Land Schönheit und Überfluss und der Stadt die Gunst des Göttlichen."},
    {TR_BUILDING_SMALL_MAUSOLEUM, "Kleines Mausoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Dieses Gebäude ist die letzte Ruhestätte vieler vergangener Generationen der stolzen Familien Ihrer Stadt, und der Neid vieler unter den Lebenden."},
    {TR_BUILDING_LARGE_MAUSOLEUM, "Großes Mausoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Die polierten Marmorwände und schimmernden Statuen dieses prächtigen Bauwerks spiegeln die großen Taten der bedeutendsten Patrizier wider, die sich das Privileg verdient haben, hier zu ruhen."},
    {TR_FIGURE_TYPE_WATCHMAN, "Wächter"},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Dieser Tempel wird Essen für deinen Versorgungsposten sammeln, sobald er gebaut wurde."},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Durchlass für Präfekten und Ingenieure umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Durchlass für Priester umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Durchlass für Marktfrauen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Durchlass für Unterhaltungswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Durchlass für Bildungswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Durchlass für Gesundheitswesen umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Durchlass für Steuereintreiber umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Durchlass für Arbeitssuchende umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Durchlass für Missionare umschalten"},
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Durchlass für Wächter umschalten"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Tastenkombination bereits in Verwendung"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Diese Tastenkombination ist bereits folgender Aktion zugewiesen:"},
    {TR_BUILDING_GARDEN_PATH, "Gartenpfad"},
    {TR_BUTTON_GO_TO_SITE, "Geht zum Standort"},
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Bau stoppen"},
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Bau wiederaufnehmen"},
    {TR_RESOURCE_FISH, "Fisch"},
    {TR_WARNING_VARIANT_TOGGLE, "Drücken Sie die Rotationstaste, um die Varianten dieses Gebäudes umzuschalten"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Diese Schule ist in Betrieb. Lokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, so dass mehr Kinder zur gleichen Zeit lernen können."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Dieses Theater ist in Betrieb. Lokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, so dass mehr Menschen die Vorstellungen sehen können."},
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Diese Bibliothek ist in Betrieb. LLokale Entwicklungen ermöglichten es Ihren Bürgern, das Gebäude zu erweitern, wodurch zusätzliche Regale mit Schriftrollen für mehr Menschen zur Verfügung stehen."},
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Diese Monumentbaustelle hat keinen Straßenzugang. Damit ein Bau möglich ist, stellt sicher, dass eine Straße an eine der mittleren Platten angeschlossen ist."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Aufgrund der schlechten Stimmung in der Stadt haben die Plebejer dieser Werkstatt einen Streik ausgerufen und verweigern die Arbeit!"},
    {TR_CITY_WARNING_SECESSION, "Plebejer verweigern die Arbeit!"},
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Ein Lagerhaus wurde geplündert!"},
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Ein Silo wurde geplündert!"},
    {TR_CITY_WARNING_THEFT, "Gelder wurden aus einem Forum oder dem Senat gestohlen!"},
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Plünderungen in der Stadt!"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Ein Lagerhaus oder Getreidespeicher wurde von aufgebrachten Bürgern geplündert und Waren gestohlen! Niedrige Stimmung macht diese Vorfälle wahrscheinlicher."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasionen"},
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion im Gange"},
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Keine Invasionen"},
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion steht bevor"},
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Feinde nähern sich"},
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Feinde weit entfernt"},
    {TR_SIDEBAR_EXTRA_GODS, "Götter"},
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Alle anzeigen"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "kleine Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "mittelgroße Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "große Armee"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Anfrage senden"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Lager"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Einlagerung stoppen"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Zu den Bevölkerungsdiagrammen"},
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Besucht den Wohnraumberater"},
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Dieses Denkmal verfügt über alle Materialien, die für diese Phase benötigt werden. Die Arbeiter warten auf einen qualifizierten Baumeister aus einer Baumeistergilde, der den weiteren Bau überwacht."},
    {TR_RETURN_ALL_TO_FORT, "Alle"},
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informationen zu Spielen"},
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Diese Statue sieht fabelhaft aus, aber sie würde noch großartiger aussehen, wenn der Springbrunnen aktiv wäre. Sorgen Sie für einen Zugang zum Wasser."},
    {TR_OPTION_MENU_APPLY, "Anwenden"},
    {TR_OPTION_MENU_COST, "Die Kosten betragen"},
    {TR_FIGURE_TYPE_LOOTER, "Plünderer"},
    {TR_FIGURE_TYPE_ROBBER, "Räuber"},
    {TR_OVERLAY_SENTIMENT, "Stimmung"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Niemand"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Alle"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Wählen Sie eine Landhandelspolitik"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Eine Karawanserei wird in Ihrer Stadt benötigt, um eine Landhandelspolitik zu wählen"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Wählen Sie eine Seehandelspolitik"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Ein Leuchtturm wird in Ihrer Stadt benötigt, um eine Seehandelspolitik zu wählen"},
    {TR_TOOLTIP_HOLD_GAME, "Spiele abhalten"},
    {TR_TOOLTIP_NO_GAME, "Spiele nicht abhalten"},
    {TR_WARNING_NEARBY_WOLF, "Kann nicht gebaut werden, wenn Wölfe in der Nähe sind" },
    {TR_MARKET_TRADING, "Handel"},
    {TR_MARKET_NOT_TRADING, "kein Handel"},
    {TR_TEMPLE_DISTRIBUTING, "Verteilung"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "keine Verteilung"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Schlechte Wohnbedingungen verhindern Zuwanderung"},
};

void translation_german(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
