#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 manquant"},
    {TR_NO_PATCH_MESSAGE,
        "Votre installation de Caesar 3 ne contient pas le patch 1.0.1.0. "
        "Vous pouvez le télécharger depuis : \n"
        URL_PATCHES "\n"
        "Procédez à vos risques et périls."},
    {TR_MISSING_FONTS_TITLE, "Polices manquantes"},
    {TR_MISSING_FONTS_MESSAGE,
        "Votre installation de Caesar 3 requiert des polices d'écriture supplémentaires. "
        "Vous pouvez les télécharger pour votre langue depuis : \n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Éditeur manquant"},
    {TR_NO_EDITOR_MESSAGE,
        "Votre installation de Caesar 3 ne contient pas le fichier éditeur. "
        "Vous pouvez le télécharger depuis : \n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Répertoire de langue invalide"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Le répertoire que vous avez sélectionné ne contient pas de pack de langue valide. "
        "Veuillez consulter les erreurs dans le fichier de log."},
    {TR_BUILD_ALL_TEMPLES, "Tout"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Annuler"},
    {TR_BUTTON_RESET_DEFAULTS, "Réinitialiser"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Contrôles"},
    {TR_CONFIG_ARE_YOU_SURE, "Réinitialiser les paramètres par défaut ?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Vous perdrez toutes vos personnalisations."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Vous perdrez tous vos raccourcis."},
    {TR_CONFIG_TITLE, "Options de configuration d'Augustus"},
    {TR_CONFIG_HEADER_GENERAL, "Configuration générale"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Configuration de l'interface"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Difficulté"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Gestion de la cité"},
    {TR_CONFIG_LANGUAGE_LABEL, "Langue :"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(par défaut)"},
    {TR_CONFIG_GAME_SPEED, "Vitesse du jeu :"},
    {TR_CONFIG_VIDEO, "Options vidéo"},
    {TR_CONFIG_FULLSCREEN, "Plein écran"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Résolution :"},
    {TR_CONFIG_DISPLAY_SCALE, "Mise à l'échelle de l'affichage :"},
    {TR_CONFIG_CURSOR_SCALE, "Taille du curseur de souris :"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Utiliser des curseurs colorés"},
    {TR_CONFIG_AUDIO, "Options audio"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Activer l'audio"},
    {TR_CONFIG_MUSIC, "Activer la musique"},
    {TR_CONFIG_SPEECH, "Activer les voix"},
    {TR_CONFIG_EFFECTS, "Activer les effets sonores"},
    {TR_CONFIG_CITY_SOUNDS, "Activer les sons de la cité"},
    {TR_CONFIG_SCROLL_SPEED, "Vitesse de défilement :"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Jouer la vidéo d'introduction"},
    {TR_CONFIG_SIDEBAR_INFO, "Afficher des informations supplémentaires dans le panneau latéral"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Activer le défilement doux"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Désactiver le défilement de la carte sur le bord de la fenêtre "},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Désactiver le clic droit pour déplacer la vue de la cité"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Améliore le retour visuel durant le dégagement du terrain"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Permet de construire tous les temples successivement"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Voir la zone d'effet en plaçant les bâtiments de distribution d'eau"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Voir la taille des constructions durant le glissement de la souris"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Mettre en surbrillance les légions au survol du curseur"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotation corps de garde et l'arc de triomphe par raccourci clavier"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Activer barre latérale militaire"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Désactiver le glissement avec bouton droit de souris"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Corrige le bug d'immigration en mode très difficile"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Corrige le bug des fantômes de 100 ans"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Corrige \"Nouvel Empereur\" et la survie des parties créees avec l'éditeur"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Afficher l'itinéraire du marcheur en cliquant droit sur un bâtiment"},
    {TR_CONFIG_ENABLE_ZOOM, "Activer le zoom (peut être lent et utilise plus de RAM)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Corrige les colonnes d'évaluation incomplètes"},
    {TR_CONFIG_GRANDFESTIVAL, "Les grandes fêtes permettent une bénédiction supplémentaire d'un dieu"},
    {TR_CONFIG_DIFFICULTY, "Difficulté :"},
    {TR_CONFIG_GODS_EFFECTS, "Activer les malédictions/bénédictions des Dieux"},
    {TR_CONFIG_JEALOUS_GODS, "Désactiver la jalousie des dieux"},
    {TR_CONFIG_GLOBAL_LABOUR, "Activer la main-d'œuvre globale"},
    {TR_CONFIG_SCHOOL_WALKERS, "Augmente la couverture des écoliers"},
    {TR_CONFIG_RETIRE_AT_60, "Changer l'âge de retraite des citoyens de 50 à 60 ans"},
    {TR_CONFIG_FIXED_WORKERS, "Corriger la force travail - 38 % de la population"},
    {TR_CONFIG_EXTRA_FORTS, "Autoriser la construction de 4 forts supplémentaires"},
    {TR_CONFIG_WOLVES_BLOCK, "Bloquer la construction autour des loups"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloque les routes des greniers non connectées"},
    {TR_CONFIG_MORE_STOCKPILE, "Les maisons stockent plus de marchandises du marché"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Les acheteuses du marché ne distribuent pas les marchandises"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Destruction immédiate des bâtiments"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Autoriser les magasiniers des greniers à évoluer hors route"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doubler la capacité des magasiniers sortant des greniers"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Permettre aux commerçants d'exporter de la nourriture depuis les greniers"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Les patrouilleurs de la tour de guet n'ont plus besoin de route"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Fermes et quais ne livrent plus qu'aux grenier à proximité"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Fermes et quais ne livrent plus aux greniers demandeurs"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Toutes les maisons fusionnent"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Ouvre des routes commerciales qui founissent différents types de vins"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Les effondrements coutent de l'argent au lieu de détruire les mines"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Autoriser la construction de plusieurs casernes"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Les entrepôts et les greniers n'acceptent rien par défaut"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Les maisons ne s'étendent pas sur les jardins"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Les marcheurs itinérants ne sautent pas les coins"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "Le zoom de la ville n'a pas pu être activé"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Votre système ne dispose pas de suffisamment de mémoire graphique pour activer le zoom sur la ville.\n"
        "Le zoom de la ville n'a pas été activé."},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Afficher la prospérité maximale atteignable avec le logement actuel"},
    {TR_HOTKEY_TITLE, "Configuration raccourcis clavier"},
    {TR_HOTKEY_LABEL, "Touche"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternative"},
    {TR_HOTKEY_HEADER_ARROWS, "Flèches directionnelles"},
    {TR_HOTKEY_HEADER_GLOBAL, "Contrôles globaux"},
    {TR_HOTKEY_HEADER_CITY, "Contrôles de la cité"},
    {TR_HOTKEY_HEADER_ADVISORS, "Rapports des conseillers"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Cartes de visualisation"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Points d'intérêt de la cité"},
    {TR_HOTKEY_HEADER_EDITOR, "Éditeur"},
    {TR_HOTKEY_HEADER_BUILD, "Contrôles de construction"},
    {TR_HOTKEY_ARROW_UP, "Haut"},
    {TR_HOTKEY_ARROW_DOWN, "Bas"},
    {TR_HOTKEY_ARROW_LEFT, "Gauche"},
    {TR_HOTKEY_ARROW_RIGHT, "Droite"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Basculer en plein écran"},
    {TR_HOTKEY_CENTER_WINDOW, "Centrer la fenêtre"},
    {TR_HOTKEY_RESIZE_TO_640, "Redimensionner en 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Redimensionner en 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Redimensionner en 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Capturer l'écran de jeu"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Capturer la cité entière"},
    {TR_HOTKEY_BUILD_CLONE, "Cloner le bâtiment sous le curseur"},
    {TR_HOTKEY_LOAD_FILE, "Charger une partie"},
    {TR_HOTKEY_SAVE_FILE, "Sauvegarder une partie"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Augmenter la vitesse du jeu"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Diminuer la vitesse du jeu"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Mettre en pause"},
    {TR_HOTKEY_CYCLE_LEGION, "Parcourir les légions en boucle"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Tourner la carte vers la gauche"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Tourner la carte vers la droite"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Main-d'œuvre"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Légion"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Empereur"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Évaluation"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Commerce"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Population"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Hygiène"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Éducation"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Loisirs"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religion"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finances"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Conseiller personnel"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Conseiller en logement"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Cartes de visualisation"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Cartes de visualisation relatif"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Eau"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Incendies"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Dégats"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Criminalité"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotation de bâtiment suivante"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Rotation de bâtiment précédente"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problèmes"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Aller au point d'intérêt 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Aller au point d'intérêt 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Aller au point d'intérêt 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Aller au point d'intérêt 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Définir comme point d'intérêt 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Définir comme point d'intérêt 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Définir comme point d'intérêt 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Définir comme point d'intérêt 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Afficher les infos de bataille"},
    {TR_HOTKEY_EDIT_TITLE, "Appuyez sur une touche"},
    {TR_BUILDING_ROADBLOCK, "Barrage routier" },
    {TR_BUILDING_ROADBLOCK_DESC, "Les barrages routiers arrêtent les citoyens errants."},
    {TR_BUILDING_ARCHITECT_GUILD, "Guilde des architectes"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Ici, les architectes travaillent sans relâche pour construire des monuments pour la gloire de Rome."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Accorder une épithète au temple"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Cérès"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptune"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercure"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Vénus"},
    {TR_BUILDING_PANTHEON, "Panthéon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Temple monumental de Cérès"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Temple monumental de Neptune"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Temple monumental de Mercure"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Temple monumental de Mars"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Temple monumental de Vénus"},
    {TR_BUILDING_PANTHEON_DESC, "Panthéon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Les charretiers des fermes se déplacent 50 % plus vite."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Accorde +1 distance pour les fontaines et puits et +2 pour les réservoirs. La main-d'œuvre des services d'eau est réduite de 50 %. Les navires marchands voyagent 25 % plus vite."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Les commerçants terrestres et maritimes ont une capacité supplémentaire de 50 %. Les commerçants terrestres se déplacent 25 % plus vite."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Forme les soldats comme une caserne. Quatre forts supplémentaires peuvent être construits."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Les jardins, les statues et les temples de la cité brillent d'une beauté accrue, ce qui augmente leur attrait. Les maisons stockent plus de marchandises et décroissent plus lentement."},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Donne accès à tous les dieux. Organise des festivals annuels et réduit les taxes du temple de 25 %."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Les prêtres réduisent la consommation alimentaire de 20 %."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Les temples produisent des conducteurs de char pour l'Hippodrome."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Les prêtres réduisent de 20 % la consommation de poterie et de meubles."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Les temples génèrent de la nourriture, en fonction du nombre de maisons qu'ils couvrent, et la livrent au poste de ravitaillement."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Le Temple monumental produit du vin en quantité adaptée à la population de la cité avec accès au temple de Vénus. Les temples le collectent et le distribuent dans les maisons."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Les prêtres collectent et distribuent à la fois de l'huile et un type de nourriture dans les entrepôts de la cité."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Les prêtres augmentent la capacité d'hébergement de 5 %. Le Temple monumental fournit de l'eau comme un réservoir rempli."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Les prêtres réduisent de 20 % la consommation d'huile et de vin."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Les prêtres réduisent de 10 % la consommation de tous les biens."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Les prêtres fournissent des divertissements et embellissent eux-mêmes les maisons, augmentant ainsi l'attractivité du quartier sans décoration supplémentaire."},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Tous les temples de la cité envoient des prêtres au Panthéon, répandant la foi et les bénédictions de leurs dieux."},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Les maisons avec accès au Panthéon peuvent évoluer d'une étape supplémentaire."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Temple de Ceres Promitor"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Temple de Ceres Reparator"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Temple de Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Temple de Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Temple de Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Temple de Mercurius Abundantia"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Temple de Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Temple de Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Temple de Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Temple de Venus Genetrix"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Temple monumental"},
    {TR_BUILDING_WORK_CAMP, "Camp de travail"},
    {TR_BUILDING_WORK_CAMP_DESC, "Les ouvriers se rassemblent ici pour transporter les matériaux vers les chantiers de construction."},
    {TR_HEADER_HOUSING, "Logement"},
    {TR_ADVISOR_HOUSING_ROOM, "Les logements ont de la place pour"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Il n'y a plus de place dans les logements."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Résidences exigeant des poteries"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Résidences exigeant des meubles"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Résidences exigeant de huile"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Résidences exigeant du vin"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Total des résidences :"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacité disponible :"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacité totale :"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Population - Logement"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Graphiques"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Cote de prospérité du logement :"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Pourcentage de la population dans des villas et palais :"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Pourcentage de la population dans des tentes et cabanes :"},
    {TR_ADVISOR_AVERAGE_TAX, "Revenu fiscal moyen par résidence :"},
    {TR_ADVISOR_AVERAGE_AGE, "Âge moyen de la population :"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Pourcentage de la population active :"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Naissances l'an dernier :"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Morts l'an dernier :"},
    {TR_ADVISOR_TOTAL_POPULATION, "Résidents"},
    {TR_ADVISOR_IN_STORAGE, "en stock"},
    {TR_ADVISOR_FROM_GRANARIES, "depuis les greniers"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Expédier depuis les greniers" },
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT,"Êtes-vous sûr ?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Continuer à stocker la ressource"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "La prospérité maximale pour le niveau actuel de logement est"},
    {TR_REQUIRED_RESOURCES, "Ressources livrées pour la phase actuelle :"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "La construction de temple monumentaux nécessite du matériel stocké dans un entrepôt, des ouvriers d'un camp de travail et des architectes d'une guilde des architectes."},
    {TR_CONSTRUCTION_PHASE, "Phase de construction :"},
    {TR_ADD_MODULE, "Redédier le temple ?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Épithète accordée."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Cérès inventa le soc qui déchire et féconde la terre.\nL'homme lui doit ses premiers fruits, des aliments\nplus doux, et ses premières lois. Nous devons tout\naux bienfaits de Cérès. C'est elle que je vais chanter\n-Ovide, les Métamorphoses, Livre V"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Les flots tombent, tandis que Neptune pose sa masse\nSur la mer agitée et lisse son visage sillonné.\nDéjà Triton, à son appel, apparaît au-dessus des vagues;\nil porte la robe tyrienne;\nEt dans sa main une trompette tordue.\n-Ovide, les Métamorphoses, Livre I "},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Le bétail et les gros moutons peuvent tous être \nobtenus par le raid, tripodes pour le commerce et \nétalons à tête fauve. Mais le souffle de vie d'un homme\n ne peut pas revenir, ni la force, ni aucun commerce ne le ramène, \nquand il glisse entre ses dents serrées.\n-Homer, L'Iliade, Livre IX "},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Pour Mars, réparez ses essieux cassés et sa guerre,\nEt renvoyez-le avec les armes fournies,\nPour réveiller la guerre paresseuse avec les alarmes bruyantes des trompettes.\n-Virgil, l'Énéide, Livre VIII"},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Par Cupidon ailé et Vénus, sa tendre mère,\nQuelle grande joie j'ai eue !\nComment la passion m'a clairement touché !\nComment mon cœur a fondu là où je gisais !\n-Ovide, les Métamorphoses, Livre IX "},
    {TR_BUILDING_PANTHEON_QUOTE, "Les portes du ciel se dévoilent : Jupiter convoque tous\nLes dieux au conseil dans la salle commune.\nSublimement assis, il observe de loin\nLes champs, le camp, la fortune de la guerre,\nEt tout le monde inférieur. Du premier au dernier,\nLe sénat souverain en degrés est placé.\n-Virgile, L'Enéide, Livre X "},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Les ouvriers construisent le podium qui élèvera le temple et fournira une base solide pour résister au passage du temps."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Les artisans fabriquent le portique qui porte l'autel sacrificiel du temple."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Les ingénieurs sont en train de fabriquer la cella, l'intérieur du temple qui abrite les images sacrées."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Les travaux sur le praecinctum du temple ont commencé, où les fidèles se rassembleront à l'extérieur pour des cérémonies publiques."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Le temple étant presque terminé, les prêtres se rassemblent pour accomplir les rites de consécration."},
    {TR_BUILDING_MENU_TREES, "Arbres"},
    {TR_BUILDING_MENU_PATHS, "Chemins"},
    {TR_BUILDING_MENU_PARKS, "Parcs"},
    {TR_BUILDING_SMALL_POND, "Petit bassin"},
    {TR_BUILDING_LARGE_POND, "Grand bassin"},
    {TR_BUILDING_PINE_TREE, "Pin"},
    {TR_BUILDING_FIR_TREE, "Sapin"},
    {TR_BUILDING_OAK_TREE, "Chêne"},
    {TR_BUILDING_ELM_TREE, "Orme"},
    {TR_BUILDING_FIG_TREE, "Figuier"},
    {TR_BUILDING_PLUM_TREE, "Prunier"},
    {TR_BUILDING_PALM_TREE, "Palmier"},
    {TR_BUILDING_DATE_TREE, "Datier"},
    {TR_BUILDING_PINE_PATH, "Chemin de pin"},
    {TR_BUILDING_FIR_PATH, "Chemin de sapin"},
    {TR_BUILDING_OAK_PATH, "Chemin de chêne"},
    {TR_BUILDING_ELM_PATH, "Chemin d'orme"},
    {TR_BUILDING_FIG_PATH, "Chemin de figuier"},
    {TR_BUILDING_PLUM_PATH, "Chemin de prunier"},
    {TR_BUILDING_PALM_PATH, "Chemin de palmier"},
    {TR_BUILDING_DATE_PATH, "Chemin de datier"},
    {TR_BUILDING_BLUE_PAVILION, "Pavillon bleu"},
    {TR_BUILDING_RED_PAVILION, "Pavillon rouge"},
    {TR_BUILDING_ORANGE_PAVILION, "Pavillon orange"},
    {TR_BUILDING_YELLOW_PAVILION, "Pavillon jaune"},
    {TR_BUILDING_GREEN_PAVILION, "Pavillon vert"},
    {TR_BUILDING_SMALL_STATUE_ALT, "Statue de Déesse"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Statue de Sénateur"},
    {TR_BUILDING_OBELISK, "Obélisque"},
    {TR_BUILDING_POND_DESC, "Les bassins se remplissent des réservoirs de la cité et fournissent de l'eau pour les plantes et les animaux et une oasis fraiche et relaxante pour les gens. Tous les citoyens aimeraient vivre près d'un basin."},
    {TR_BUILDING_WINDOW_POND, "Bassin"},
    {TR_BUILDING_OBELISK_DESC, "Un monument prestigieux, œuvre d'un ancien roi du Nil. Les Égyptiens ne l'utilisaient pas."},
    {TR_ADVISOR_FINANCE_LEVIES, "Taxes de construction"},
    {TR_CONFIRM_DELETE_MONUMENT, "Démolir ce monument"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Sélectionnez l'épithète à accorder"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Accorder une épithète consacrera en permanence votre temple à un aspect de sa divinité, conférant aux prêtres un pouvoir divin."},
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/Mois"},
    {TR_BUILDING_MESS_HALL, "Poste de ravitaillement"},
    {TR_BUILDING_MESS_HALL_DESC, "Le poste de ravitaillement recueille de la nourriture des greniers de la cité pour nourrir les soldats stationnés dans les forts. Un mauvais approvisionnement ralentira le recrutement et nuira au moral."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "L'approvisionnement du mois dernier :"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Les soldats sont : "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Bien nourris"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Nourris"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Affamés"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Très affamés"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "En famine"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Le régime alimentaire varié de vos soldats augmente considérablement le moral."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Le régime alimentaire varié et nutritif dont bénéficient vos soldats augmente considérablement le moral."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Vous n'avez pas de soldats à nourrir."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Mois de nourriture stockée :"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instructions pour l'intendant"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Les pénuries alimentaires à votre poste de ravitaillement ralentissent le recrutement de soldats."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Les pénuries alimentaires critiques à votre poste de ravitaillement paralysent le recrutement de soldats."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "La récente pénurie alimentaire a fait baisser le moral"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "La récente pénurie alimentaire a considérablement réduit le moral"},
    {TR_BUILDING_LEGION_STARVING, "Pénurie alimentaire"},
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "Sans limite"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Aucun acheteur pour cette ressource"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Aucun vendeur pour cette ressource"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Ne pas importer"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Ne pas exporter"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Commencer l'importation"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Commencer l'exportation"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Vos soldats ont toute la nourriture dont ils ont besoin."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Vos soldats ont besoin de plus de nourriture."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Vos soldats meurent de faim !"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Mois de nourriture stockée au poste de ravitaillement :"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldats affamés"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Votre poste de ravitaillement manque cruellement de nourriture et le moral de vos troupes diminue. Assurez-vous que votre poste de ravitaillement peut accéder à un grenier bien approvisionné."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Votre cité a perdu son poste de ravitaillement et vos troupes meurent de faim. Construisez immédiatement un poste de ravitaillement."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Marchandises à collecter"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instructions du dock"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instructions du temple"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instructions de la taverne"},
    {TR_WARNING_NO_MESS_HALL, "Vous devez d'abord construire un poste de ravitaillement pour nourrir vos soldats."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "Seuls deux temples monumentaux peuvent être construits."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Temple monumental terminé"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Les prêtres et les fidèles affluent vers le nouveau temple monumental pour les rites de consécration. Votre peuple est impressionné par la majesté de vos œuvres et la divinité que vous avez choisie vous comble de faveur."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Une bénédiction de Mercure"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Ravi de votre dévouement, Mercure a béni votre industrie en découvrant des matières premières pour vos artisans."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Contremaitre"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Transporteur"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architecte"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Intendant"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Collecteur"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Le temple monumental envoie des prêtres de Cérès pour aider à distribuer de la nourriture et de l'huile à vos citoyens affamés."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Le temple monumental permet aux prêtres de Vénus de fournir du vin sacré à vos citoyens."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Le temple monumental forme les prêtres de Mars à fournir de la nourriture à votre poste de ravitaillement."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Temple de Cérès"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Temple de Neptune"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Temple de Mercure"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Temple de Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Temple de Vénus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Prêtre"},
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Cités avec commerce maritime ouvert :" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Il n'y a pas de routes commerciales maritimes." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Je ferai ce que je peux pour calmer ces barbares. Je suis sûr qu'ils arrêteront d'attaquer la cité quand j'aurai eu un mot avec eux.\""},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Festival annuel"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Les fidèles affluent vers les temples pour la célébration de Cerealia, en l'honneur de Cérès. Les agriculteurs offrent des sacrifices pour de riches récoltes dans les années à venir."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "C'est aujourd'hui la fête de Neptunalia, en l'honneur de Neptune. Les fidèles construisent des huttes de branches et de feuillages et se réjouissent sous la chaleur ardente du soleil d'été."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Les commerçants et les marchands se rassemblent en masse pour célébrer Mercuralia. De l'eau sacrée est aspergée sur les navires et les entrepôts dans l'espoir d'une protection divine contre le dieu Mercure."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Les citoyens se rassemblent à l'extérieur de la cité pour la célébration d'Equirria, pour chercher la faveur de Mars. L'air est rempli du tonnerre des sabots et du grincement des chars pendant que les fidèles font la course en l'honneur de leur dieu."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Les fidèles se rassemblent pour la célébration de Veneralia, un jour sacré à Vénus. Vos citoyens la supplient de leur donner bonne fortune en matière de cœur."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Supprimer les messages lus"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Désactivez ce bâtiment"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Activez ce bâtiment"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Autoriser les acheteuses du marché à acheter ici"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Autoriser les caravanes à commercer ici"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Permettre aux navires de commerce de commercer ici"},
    {TR_BUILDING_LIGHTHOUSE, "Phare"},
    {TR_BUILDING_CARAVANSERAI, "Caravansérail"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Les caravanes marchandes profitent de ce lieu de repos, consomment de la nourriture et reposent leurs bêtes. Les perturbations commerciales terrestres durent deux fois moins longtemps."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Marchandises à collecter"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fondations)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Les ingénieurs terrassent les fondations du futur ce lieu de repos."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Fournisseur du caravansérail" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Porteur du caravansérail" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Commerce terrestre" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Aucune politique commerciale terrestre actuellement" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Séléctionner une politique commerciale terrestre pour votre cité. Vous pourrez modifier à tout moment pour le même cout." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Les caravanes achètent leurs biens 20 % plus cher, mais vos importations terrestres vous coutent 10 % de plus." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium acquisitionem terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Les caravanes vendent leurs biens 20 % moins cher, mais vos exportations terrestres vous rapportent 10 % de moins." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Les caravanes peuvent porter 4 biens de plus, mais consomment 20 % plus de nourriture dans le Caravansérail." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fondations)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Piédestal)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Tour)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Couronne)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Les ingénieurs posent des bases solides pour supporter le poids d'une grande tour de pierre."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Les maçons construisent le piédestal qui élèvera la flamme du phare bien au-dessus de l'horizon."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "La tour du phare monte encore plus haut chaque jour alors que les maçons érigent l'édifice pierre après pierre."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Les ingénieurs sont en train d'effectuer les dernières retouches sur le phare. Bientôt, il brillera sur des kilomètres, guidant les navires vers la maison."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "La construction du phare nécessite du matériel stocké dans un entrepôt, des ouvriers d'un camp de travail et des ingénieurs d'une guilde d'ingénieurs."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Sa lumière guide les marins de l'empire vers votre cité. Les navires de pêche se déplacent 10 % plus vite. Les tempêtes marines durent deux fois moins longtemps."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Commerce maritime" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Aucune politique commerciale maritime actuellement" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Séléctionner une politique commerciale maritime pour votre cité." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Les navires marchants achètent leurs biens 20 % plus cher, mais vos importations maritimes vous coutent 10 % de plus." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Les navires marchants vendent leurs biens 20 % moins cher, mais vos exportations maritimes vous rapportent 10 % de moins." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Les navires marchants peuvent emporter 4 biens de plus, mais le phare consomme 20 % plus de bois." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monuments"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Le phare achevé, une puissante tour de pierre se profile à l'horizon. Que sa lumière guide les navires jusqu'à la fin des temps."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Le Panthéon est achevé. Il trône inégalé en tant que monument dédié à la puissance impressionnante des dieux et du peuple de Rome."},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument achevé"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Une bénédiction de Neptune"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Récompensant le dévouement de votre cité, Neptune accorde un passage en douceur aux commerçants pendant douze mois, pendant lesquels vos exportations rapporteront la moitié du prix en plus."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Une bénédiction de Vénus"},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Ravie de la vénération joyeuse qui lui est témoignée, Vénus accorde jeunesse, santé et bonheur à votre peuple, augmentant ainsi la taille de votre population active."},
    {TR_BUILDING_MENU_STATUES, "Statues"},
    {TR_BUILDING_MENU_GOV_RES, "Gouverneur"},
    {TR_OVERLAY_ROADS, "Routes"},
    {TR_NO_EXTRA_ASSETS_TITLE, "Le dossier assets ne peut être trouvé"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Votre installation de Caesar 3 n'a pas de dossier assets correctement installé. "
        "Les nouveaux batiments ne seront pas correctement affichés.\n"
        "Veuillez vous assurer qu'un répertoire '/assets' existe dans le répertoire d'installation de Caesar 3."},
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Le phare doit être placé près de l'eau"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Cette maison a accès aux cinq dieux du Panthéon"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Une nourriture abondante remonte le moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Statut alimentaire"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Autoriser l'intendant à trouver de la nourriture ici"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Vous ne pouvez pas obtenir le matériel nécessaire"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Les temples monumentaux confèrent un bonus de culture de +8"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Désactiver la réapparition des loups"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Retour menu principal"},
    {TR_LABEL_PAUSE_MENU, "Pause"},
    {TR_OVERLAY_LEVY, "Taxes"},
    {TR_TOOLTIP_OVERLAY_LEVY, " denarii payées en taxes par mois."},
    {TR_MAP_EDITOR_OPTIONS, "Réglages du scénario" },
    {TR_BUILDING_TAVERN, "Taverne" },
    {TR_BUILDING_GRAND_GARDEN, "Grand jardin" },
    {TR_BUILDING_TAVERN_DESC_1, "Cette taverne n'a pas de travailleurs et ne peut pas fonctionner correctement." },
    {TR_BUILDING_TAVERN_DESC_2, "Cette taverne n'a pas de vin et ne peut pas fonctionner correctement." },
    {TR_BUILDING_TAVERN_DESC_3, "La taverne propose des divertissements tant que le vin coule à flot. Un approvisionnement en viande augmenterait son attrait." },
    {TR_BUILDING_TAVERN_DESC_4, "Le vin abondant et l'odeur de la viande rôtie attirent une foule animée dans cette taverne pour les jeux de hasard, la musique et la bonne ambiance." },
    {TR_FIGURE_TYPE_BARKEEP, "Tavernier" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Fournisseur de la taverne" },
    {TR_OVERLAY_TAVERN, "Taverne" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Cette maison n'a pas accès à une taverne, ou sa taverne n'a plus de vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Aucun tavernier n'est passé depuis un moment. Cette maison perdra bientôt l'accès à sa taverne." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Cette maison a vu passer le tavernier avec du vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Cette maison a vu passer le tavernier avec du vin et de la viande." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Cette maison a récemment vu passer le tavernier avec du vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Cette maison a récemment vu passer le tavernier avCette maison a récemment vu passer le tavernier avec du vinec du vin et de la viande. Que la fête commence !" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Les résidents détestent votre nom."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Les résidents sont très furieux contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Les résidents sont furieux contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Les résidents sont très en colère contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Les résidents sont en colère contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Les résidents sont agacé contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Les résidents sont indifférent envers vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Les résidents sont satisfaits de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Les résidents sont très satisfaits de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10,"Les résidents sont extrêmement satisfaits de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Les résidents vous aiment." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Vous êtes un dieu au yeux des résidents" },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Les résidents sont mécontents du fort taux d'imposition." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Les résidents sont mécontents des bas salaires." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Les résidents sont mécontents du manque d'emplois." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Les résidents sont découragés par leur logement insalubre." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Les résidents apprécieraient plus de divertissement." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Les résidents apprécieraient une alimentation plus variée." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Les résidents apprécieraient un meilleur cadre de vie." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "L'esprit des résidents est remonté par un événement récent." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Les résidents sont découragés par un événement récent." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tavernes" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Jeux" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Financer les Grands Jeux du Colisée ou de l'hippodrome en utilisant des fonds personnels." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Tenir des Jeux" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Les préparatifs des Grands Jeux sont en cours." },
    {TR_SELECT_GAMES_HEADER, "Jeux" },
    {TR_SELECT_GAMES_TEXT, "Les Jeux auront lieu au Colisée ou à l'hippodrome et couteront des fonds et des ressources personnelles." },
    {TR_BUILDING_ARENA, "Arène" },
    {TR_BUILDING_HORSE_STATUE, "Statue équestre" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fontaine dauphin" },
    {TR_BUILDING_HEDGE_DARK, "Haie verdoyante" },
    {TR_BUILDING_HEDGE_LIGHT, "Haie ensoleillée" },
    {TR_BUILDING_GARDEN_WALL, "Muret" },
    {TR_BUILDING_LEGION_STATUE, "Statue de légionnaire" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Colonne de marbre" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fondations)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcade)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galerie)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Les travailleurs creusent l'hypogée souterrain, les tunnels et les machines d'où jailliront de grands spectacles." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Les murs du Colisée prennent forme en tant que gradins de sièges pour les roturiers et les empereurs sont posés." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Des arcs gracieux s'élèvent vers les cieux, pour maintenir le puissant Colisée au firmament." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Alors que le Colisée touche le ciel, ses murs sont revêtus de marbre brillant et de statues." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Piste)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fondations)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Gradins)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Facade)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Ce site massif est minutieusement étudié et nettoyé pour un projet d'une ampleur sans précédent." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Des accès et des structures de soutien sont en cours de construction autour de la piste." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Les maçons sculptent des sièges en pierre pour des dizaines de milliers de personnes." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Plus qu'une simple piste de course, les artisans construisent un monument digne des dieux et du peuple de Rome." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "La construction du monument nécessite des matériaux stockés dans un entrepôt, des ouvriers d'un camp de travail et des ingénieurs d'une guilde d'ingénieurs." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construction interrompue." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arènes" },
    {TR_BUILDING_INFO_TOURISM, "(Voyageurs)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Le Colisée est terminé ! Que les jeux commencent !" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "L'Hippodrome est terminé. Vos citoyens attendent avec impatience que les premières courses commencent !" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Jeux inauguraux" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Les courses commencent" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Les Jeux inauguraux de votre Colisée ont commencé. A votre ordre, ce monument sera consacré du sang des braves !" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Votre cité se vide alors que des foules grouillantes affluent vers l'Hippodrome pour les courses de chars inaugurales. Une joie assourdissante remplit l'air alors que les portes s'ouvrent !" },
    {TR_WINDOW_GAMES_OPTION_1, "Combats Navals" },
    {TR_WINDOW_GAMES_OPTION_2, "Jeux des Fauves" },
    {TR_WINDOW_GAMES_OPTION_3, "Jeux des Calendes" },
    {TR_WINDOW_GAMES_OPTION_4, "Jeux Olympiques" },
    {TR_WINDOW_GAMES_OPTION_5, "Jeux Romains" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Le Colisée sera inondé pour reconstituer une grande bataille navale. Augmente la vitesse de déplacement des soldats, ainsi que la force des soldats dans les batailles lointaines, pendant 12 mois." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Le Colisée accueillera des chasses d'animaux sauvages, ravissant les plébéiens. Les criminels, les émeutes et les révoltes seront réprimés pendant 12 mois. Les gladiateurs défendront la cité lors des prochaines invasions." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Le Colisée accueillera des jeux en l'honneur des dieux le premier jour de l'année prochaine, implorant fortune et prospérité. Les quotas commerciaux seront doublés l'année prochaine." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "L'Hippodrome accueillera les Jeux Olympiques. Votre cité accueillera des foules de visiteurs, et si vos athlètes honorent bien votre cité, vous obtiendrez une augmentation permanente du tourisme et de la faveur." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Le Colisée accueillera les Jeux Romains. Votre ville accueillera de nombreux voyageurs, désireux de prouver leurs forces. Ces célébrations vous apportera les faveurs de l'empereur et de votre peuple pendant 12 mois." },
    {TR_WINDOW_GAMES_COST, "Cout :" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fonds personnels)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Fonds personnels insuffisants." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Pas assez de ressources stockées." },
    {TR_WINDOW_GAMES_NO_VENUE, "Le lieu n'est pas construit ou n'a pas de travailleurs." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construction)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Les maçons et les ingénieurs construisent soigneusement cette structure à partir de marbre brillant." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "La construction de ce temple nécessitera du matériel stocké dans un entrepôt, des ouvriers d'un camp de travail et des architectes d'une guilde des architectes." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "L'eau des réservoirs de la cité remplit lentement le Colisée. Les charpentiers commencent à assembler des navires de guerre alors que les gladiateurs s'entraînent au combat naval. Bientôt les Combats Navals commenceront !" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Le Colisée est devenu un lac artificiel alors que les gladiateurs reconstituent de grandes victoires romaines en mer. Le sang et l'eau se mélangent alors que la foule exulte. La Naumachie - les Combats Navals - ont commencé !" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Un long processus de nettoyage commence pour le Colisée car il est drainé et prêt pour une utilisation normale. Votre peuple parlera de ce spectacle aquatique pendant des années." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Une cargaison étrange commence à apparaître dans votre cité alors que des commerçants du bout du monde livrent des bêtes terrifiantes dans les cages sous le colisée. Bientôt, un spectacle horrible ravira votre peuple." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Les criminels et les gladiateurs condamnés à la recherche de la gloire ultime font face à une mort sauvage. Aux sons des trompettes, les Jeux des Fauves ont commencé !" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Les dernières bêtes sauvages gisent dans les sables du Colisée, leur sang se mêlant à celui des condamnés. Les Jeux des Fauves sont terminés." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Nous saluerons la nouvelle année avec des jeux glorieux en l'honneur des dieux. En retour, nous demandons fortune, prospérité et bénédictions en matière de commerce." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Les jeux commencent au lever du soleil sur les Calendes de Janvier. Les prêtres effectuent des sacrifices d'animaux pendant que les gladiateurs se préparent à mourir à la faveur des dieux."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Les augures suggèrent que les dieux étaient satisfaits de nos grands jeux, des sacrifices et de l'intêret qui leur étaient montrés. On peut s'attendre à une année très rentable !"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Tous les yeux seront rivés sur votre cité alors que les Jeux Olympiques attirent des voyageurs, des concurrents et des dignitaires romains du monde entier. Il ne faudra pas moins d'une année complète de préparations."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Pour durer longtemps, le jour est venu. La flamme sacrée est allumée et les rues de votre cité sont désertes alors que les citoyens se rassemblent dans le grand hippodrome. Que les jeux commencent !"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "La flamme sacrée est éteinte, et les voyageurs et les citoyens rentrent chez eux exténué mais heureux. La gloire éternelle sur vous pour avoir accueilli avec succès cette célébration ancienne et sacrée en l'honneur des mortels." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Avec l'annonce des Jeux Romains, les gens de tout l'Empire affluent dans votre cité, beaucoup espérant gagner les prochaines compétitions. Il ne faudra pas moins d'une année complète de préparations." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "La procession solennelle commence, et avec elle, les Jeux Romains. Puisse Jupiter lui-même juger le meilleur des concurrents, de courses, de combats et d'autres épreuves. Le Colisée est rempli à ras bord de citoyens qui attendent les jeux ainsi que des offrandes de blé et d'huile d'olive. Que les jeux commencent !" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Les Jeux Romains touchent à leurs fins. Plein d'excitation et rassasié, chaque citoyen a goûté à la grandeur de Rome. Gloire aux vainqueurs des jeux et gloire au gouverneur !" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Les grands jeux"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Mois restants avant la tenue des prochains jeux : " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Mois restants avant les Combats Navals :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Les Combats Navals sont en cours. Les éclaboussures d'eau, le grincement coques et les cris de guerre des gladiateurs s'ajoutent au rugissement de la foule." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Mois restants avant les Jeux des Fauves :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Les Jeux des Fauves sont en cours. Épaule contre épaule, la foule hurle d'elle-même alors que les bêtes sauvages traquent leur proie humaine." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Mois restants avant les Jeux des Calendes :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Les Jeux des Calendes sont en cours. L'odeur des sacrifices d'animaux et de l'encens domine même le sang et la sueur de l'arène." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Mois restants avant les Jeux Olympiques :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Les Jeux Olympiques sont en cours. Le feu sacré brûle jour et nuit alors que les athlètes se disputent la gloire immortelle." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Mois restants avant les Jeux Romains :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Les Jeux Romains sont en cours. Chaque participant met son sang, sa sueur et ses larmes pour prouver qu'il est le meilleur des Romains." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Les grands jeux continueront encore" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "De Grands Jeux ont eu lieu récemment." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Les Grands Jeux sont en cours ! Votre cité regorge de voyageurs et de réjouissances." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "L'arène est fermée. Les oiseaux font des nids dans les sièges vides." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Cette arène n'accueille ni lions ni gladiateurs et offre peu de divertissement." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Des spectacles de gladiateurs réguliers divertissent la foule, mais les lions rendraient les spectacles plus attrayant." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Des spectacles de gladiateurs réguliers divertissent la foule, mais les lions rendraient le spectacle plus incroyable." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Des bêtes affamées rôdent dans l'arène à la recherche de proies, mais le manque de gladiateurs entraînés permet de brefs spectacles." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Ce temple collectera de la nourriture pour votre poste de ravitaillement, une fois qu'il sera construit." },
    {TR_OVERLAY_ARENA_COL, "Arêne" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Cette maison n'a pas accès à une arène ou au Colisée." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Cette maison a accès à une arêne, avec un spectacle." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Cette maison a accès à une arêne, avec deux spectacles." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Cette maison a accès au Colisée, avec un spectacle." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Cette maison a accès au Colisée, avec deux spectacles." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Travailleurs en grève" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Pas d'accès à l'eau" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "En attendant le charretier" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Aucune ressource disponible" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Bâtiment mis en pause" },
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Trop de bâtiments de ce type - les voyageurs évitent cet endroit." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Revenus des voyageurs cette année :" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Votre conseiller commercial a ordonné l'arrêt de la pêche."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Hommage / intérêt"},
    {TR_WINDOW_ADVISOR_TOURISM, "Divers"},
    {TR_WINDOW_FIGURE_TOURIST, "Ce voyageur a dépensé : "},
    {TR_FIGURE_TYPE_TOURIST,  "Voyageurs"},
    {TR_MAP_EDITOR_OPTIONS, "Réglages du scénario"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Version de sauvegarde incompatible" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "La sauvegarde que vous essayez de charger concerne une version différente d'Augustus.\nVeuillez mettre à jour Augustus vers la version la plus récente." },
    {TR_BUILDING_COLONNADE, "Colonnade" },
    {TR_BUILDING_LARARIUM, "Laraire" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Un petit sanctuaire pour les dieux et les ancêtres du peuple romain. De petits sacrifices et des prières peuvent être faits ici."},
    {TR_BUILDING_WATCHTOWER, "Tour de guet"},
    {TR_BUILDING_WATCHTOWER_DESC, "Les archers sur le rempart guettent les envahisseurs, tandis que des gardiens patrouillent dans les rues." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Cette tour nécessite un patrouilleur provenant de la caserne avant de pouvoir protéger la ville."},
    {TR_BUILDING_NYMPHAEUM, "Nymphée"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Un grand temple consacré aux nymphes promet la fortune à la terre voisine et la faveur du divin à la cité." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Petit mausolée"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Le lieu de repos des familles riches que de nombreux habitants envient." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Grand mausolée"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Les murs de marbre poli de cette magnifique structure reflètent les grandes actions des patriciens les plus distingués qui ont gagné le privilège de se reposer ici." },
    {TR_FIGURE_TYPE_WATCHMAN, "Gardien" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Ce temple collectera de la nourriture pour le poste de ravitaillement, une fois construit." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Régler l'accès des préfets et ingénieurs" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Régler l'accès des prêtres" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Régler l'accès des acheteurs de marché" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Régler l'accès des animateurs" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Régler l'accès des travailleurs éducatifs" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Régler l'accès des travailleurs de santé" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Régler l'accès des collecteurs de taxes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Régler l'accès des demandeurs d'emploi" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Régler l'accès des missionnaires" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Régler l'accès des gardiens" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Raccourci déjà utilisé"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Cette combinaison de touches est déjà affectée à l'action suivante :"},
    {TR_BUILDING_GARDEN_PATH, "Chemin de jardin" },
    {TR_BUTTON_GO_TO_SITE, "Aller sur le site" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Stopper la construction" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Reprendre la construction" },
    {TR_RESOURCE_FISH, "Poisson" },
    {TR_WARNING_VARIANT_TOGGLE, "Variants du bâtiment disponibles avec la touche rotation"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "L'école est opérationnelle et le développement de la zone a permis son expansion. Cela permet à plus d'enfants d'étudier en même temps."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Le développement de la zone a permis l'agrandissement du théâtre. Le théâtre plus grand peut satisfaire les besoins de divertissement d'un plus grand nombre de citoyens." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Le développement de la zone a permis d'agrandir considérablement la bibliothèque. Les nouveaux parchemins peuvent satisfaire les besoins éducatifs d'un plus grand nombre de Romains." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Le monument n'a pas d'accès à une route. Pour vous assurer que la construction soit possible, assurez-vous que le monument soit relié à une route."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "En raison de la mauvaise humeur dans la cité, les plébiens de cet atelier ont déclaré la sécession et refusent de travailler !" },
    {TR_CITY_WARNING_SECESSION, "Les Plébiens refusent de travailler" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Un entrepôt a été pillé" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Un grenier a été pillé" },
    {TR_CITY_WARNING_THEFT, "Des fonds ont été volés dans un forum ou au Sénat" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Pillage dans la cité"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Un entrepôt ou un grenier a été pillé par des citoyens en colère et des biens ont été volés. Une mauvaise humeur rend ces incidents plus probables."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion en cours" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Aucune invasion" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion imminente" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Ennemis proches" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Ennemis éloignés" },
    {TR_SIDEBAR_EXTRA_GODS, "Dieux" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Tout voir" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Troupe modeste"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Troupe moyenne"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Troupe importante"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Envoyer la requête"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Stocker"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Arrêter de stocker"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Afficher les informations de population" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Afficher les informations de logement" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Ce monument dispose de tous les matériaux nécessaires pour cette phase et attend un architecte qualifié de la guilde des architectes pour superviser sa construction." },
    {TR_RETURN_ALL_TO_FORT, "Tout retourner" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informations sur les Jeux" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "La statue a l'air fabuleuse, mais elle aurait l'air encore plus incroyable avec un accès à l'eau." },
    {TR_OPTION_MENU_APPLY, "Appliquer"},
    {TR_OPTION_MENU_COST, "Cela vous coutera"},
    {TR_FIGURE_TYPE_LOOTER, "Pillard" },
    {TR_FIGURE_TYPE_ROBBER, "Voleur" },
    {TR_OVERLAY_SENTIMENT, "Humeur" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Personne" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Tout le monde" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Sélectionner une politique commerciale terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Un Caravansérail est nécessaire dans votre cité pour choisir une politique commerciale terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Sélectionner une politique commerciale maritime"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Un Phare est nécessaire dans votre cité pour choisir une politique commerciale maritime"},
    {TR_TOOLTIP_HOLD_GAME, "Organiser les jeux"},
    {TR_TOOLTIP_NO_GAME, "Ne pas organiser les jeux"},
    {TR_WARNING_NEARBY_WOLF, "Impossible de construire lorsque les loups sont à proximité" },
    {TR_MARKET_TRADING, "Commercer"},
    {TR_MARKET_NOT_TRADING, "Ne pas commercer"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuer"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Ne pas distribuer"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Des logements sordides et des bidonvilles empêchent l'immigration"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Gardien du phare"},
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Le lieu n'a pas accès à un réservoir."}
};

void translation_french(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
