
// ========================================================================
// Arachne Icons (.IKN) library
// (c)1997,1998,1999,2000 Zdenek Harovnik + Michael Polak, Arachne Labs
// ========================================================================

// HARO version : 02.02.1998
// Version : uses ie_swap... function
// version without messages, for game universe and Arachne WWW Browser

#include "arachne.h"
#include "v_putimg.h"
#include "putikons.h"

void memerr(void);
int  PresspalO (int multip, char *Palin[], int *Npalin, char  *palout,
               int *npalout, int *mapio, int *Mmapio[],
               int Swinout, int TypFuse, int Tolerance,
               char *Savecols );
void z_bitbyte(unsigned char *buf1, unsigned char *buf2, int delka);
int  z_bytebit(char *inp, char *out, int npix);
int  bit_pix8(char *sourc, char *dest, int npix, int nbit);
void x_img256to2(unsigned char *bi, unsigned char *bo);
void x_img256to16(unsigned char *bi, unsigned char *bo);
int v_transpimg(int x0, int y0, unsigned char *bi1, int Transp);

int ie_swap(int newswap);

extern int swapmod;   //priznak modifikace swapovane pameti
    // tr.: type of modification of swapped memory

#define BUFERSIZE 16100l

#define MAX_ICNINDEX 120         // max. ikon v seznamu
                          // tr.: max. icons in index
#define MAX_ICNLIST  480         // max. pocet ikon v draw listu
                          // tr.: max. number of icons in draw list/page
#define MAX_ICONSWAP 16384       // buffer pro N-ikon (swap)
                          // tr.: buffer for N-ikon (swap)

#define DRAW_LIST_IKN 16         // optimalizace kresleni seznamu
                          // tr.: optimalization of drawing index

//#define IKNDEBUG printf("Line: %d\n",__LINE__)
#define IKNDEBUG

// Icons in index of icons (there can be max MAX_ICNINDEX)
struct IknIndex
{ char iconame[80];      // name of icon
  XSWAP  hSwap;          // handle of swap with buffer
  unsigned int  Off;     // offset in swap
};

// seznam ikon pro hromadne vykresleni
// tr.: index of icons for drawing alltogether

struct IknList
{  XSWAP hSwap;
   unsigned int Off;
   int          x0;
   int          y0;
};

#ifdef POSIX
struct IknIndex *IknPtr=NULL;
#else
XSWAP g_hIndex=IE_NULL;    // handle swapu s indexem a listem ikon
               // tr.: handle of swap with index and page/list of icons
#endif
unsigned int g_AktIndex=0;  // prvni volne misto pro pridani ikony do indexu
               // tr.: first free space for adding icons to index
unsigned int g_BegList; // Offset v B na zacatek listu v bufru
               // tr.: Offset in B at the beginning of page/list in buffer
unsigned int g_AktList; // Prvni volny IknList
               // tr.: First free IknList

XSWAP g_AktImgSwap = IE_NULL; // handle swapu pro pridavani
                // tr.: handle of swap for adding
unsigned int g_FreeOff = 0;       // kolik mam mista ve swapu pro IMG
                // tr.: how much space do I have in swap for IMG
unsigned int g_maxswap = 0;       // velikost bufru pro ikony
                // tr.: size of buffer for icons
unsigned int g_AktPalLen = 0;     // pamatovani si minule delky palety
                // tr.: remembering last length of palette
//int          g_UpIcnData = 0;     //no longer used
char         g_LastPal[768];      // minula paleta (pro porovnani s akt)
                // tr.: last palette (for comparing with current one)
//int          g_UpAllIcn = 0;      // pocet ikon nad FIRSTHTMLSWAP
                // tr.: number of icons above FIRSTHTMLSWAP

int          g_SetTransp= 1;      // Kreslit transparentne$$
                // tr.: draw transparently$$

// ----- Internal auxiliary fce for icons
void freeinkons(void);
void DrawIcon1(int x0, int y0, XSWAP int hSwap, unsigned int Off);
int  PrepareIconDraw(XSWAP hSwap, unsigned int Off, char **bo, int *TrCol);
int  GetListNext(int From, int Kolik, struct IknList *List);
int  SortListIcons(void);
void RepalIcon1(short int mcol, short int mrow, unsigned char *bwork, int
*Mmapio[]);
void RepalIcon2(short int mcol, short int mrow, unsigned char* bwork,
                unsigned char* bio, int *Mmapio[]);
int  MergePalIcons(int npalikn, char *palin, int *mapio, int *Mmapio[],
                  int *Mapujo);

// ------ Public interface for icons
void InitIcons(void);
void DrawIcons(void);
void DrawIconLater(char *iconame,int x0, int y0);
void DrawIconNow(char *iconame,int x0, int y0);
//void UpdIconIndex(void);

//##----------- Initialization
void InitIcons(void)
{
  unsigned int LenBuf;

  if(!egamode && !vga16mode)
   IiNpal=0;             // no palette at all
  g_AktPalLen = 0;
  memset(g_LastPal, 0, 768);

#ifdef POSIX
  IKNDEBUG;
  if(IknPtr == NULL)     //allocation of space for index
  {
    g_BegList = MAX_ICNINDEX * sizeof(struct IknIndex);
    LenBuf    = g_BegList + MAX_ICNLIST * sizeof(struct IknList);
    IknPtr = malloc(LenBuf);
    if(!IknPtr)
     memerr();
    //printf("%d of memory allocated for icon index....\n",LenBuf);
#else
  if(g_hIndex == IE_NULL)     //allocation of space for index
  { g_BegList = MAX_ICNINDEX * sizeof(struct IknIndex);
    LenBuf    = g_BegList + MAX_ICNLIST * sizeof(struct IknList);

   //printf("allocating XSWAP for index..\n");
   g_hIndex = ie_putswap("",LenBuf,CONTEXT_ICONS);
#endif

    g_AktIndex = 0;      // Pri opetovnem zavolani InitIcons se index
    g_AktList  = 0;      // pouzije znova od zacatku
       // tr.: if InitIcons is called repeatedly, the index will
       //      be used again from the beginning
    g_maxswap  = 0;
    g_FreeOff  = 0;

  }

  freeinkons();        // but what about IMG swaps ?
}

//##----------- Add to list
//You have to call DrawIcon to draw
void DrawIconLater(char *iconame,int x0, int y0)
{
  Putikonx(x0, y0, iconame, 0);
}

//##----------- Drawing immediately now
void DrawIconNow(char *iconame,int x0, int y0)
{
  Putikonx(x0, y0, iconame, 1);
#ifdef GGI
  Smart_ggiFlush();
#endif
}

//##----------- Vykresleni ikon v seznamu a jeho zruseni
// tr.: Drawing icons in the index and its deleting
void DrawIcons(void)
{
  int      nIcon, From, i, ist, Transp;
#ifdef POSIX
 struct   IknList *List;
#else
  struct   IknList List[DRAW_LIST_IKN];
#endif
  XSWAP YhSwap, YOff;
  char     *bi1 = NULL;

  if((xg_256 != MM_256 && !xg_video_XMS) || (xg_256 == MM_Hic)) //HARO
  { if(g_AktPalLen == IiNpal)
    { if(memcmp(Iipal, g_LastPal, 3*IiNpal) == 0 ) goto Ident1;
    }
    x_palett(IiNpal, Iipal);
    g_AktPalLen = IiNpal;
    memcpy(g_LastPal, Iipal, 3*IiNpal);
    Ident1:;
  }

  YhSwap = YOff = 0xFFFF;

#ifndef POSIX
  // sort list of icons
  //not really needed with linear access to memory
  i = SortListIcons();
  if(i != 1) return;
#endif
  g_AktPalLen = IiNpal;
  memcpy(g_LastPal, Iipal, 3*IiNpal);

  swapmod = 1;
  From =  0;

#ifdef POSIX
  List=( struct   IknList *)((void *)IknPtr+g_BegList);
  nIcon=g_AktList;
#else
  Next_draw:
  nIcon = GetListNext(From, DRAW_LIST_IKN, List);  // Optimalization of swapping
#endif

  if(nIcon > 0)
  {
   for(i=0; i<nIcon; i++)
   { if(xg_256 != MM_256)
     {
      //printf("Drawing icon No. %d at %d, %d\n",i,List[i].x0, List[i].y0 );
      DrawIcon1(List[i].x0, List[i].y0, List[i].hSwap, List[i].Off);
     }
     else
     { if(!(YhSwap == List[i].hSwap && YOff == List[i].Off))
       { if(bi1 != NULL) farfree(bi1);

         ist = PrepareIconDraw(List[i].hSwap, List[i].Off, &bi1, &Transp);
         if(ist != 1) goto cont1;
         YhSwap = List[i].hSwap;
         YOff = List[i].Off;

         if(!xg_video_XMS || xg_256 == MM_Hic)
         {
           if(g_AktPalLen == IiNpal)
           { if(memcmp(Iipal, g_LastPal, 3*IiNpal) == 0) goto Ident2;
           }
           x_palett(IiNpal, Iipal);
           g_AktPalLen = IiNpal;
           memcpy(g_LastPal, Iipal, 3*IiNpal);
           Ident2:;
         }
       }
#ifdef TRANSPARENT_ICONS
       if(Transp >= 0 && g_SetTransp > 0) // Transparent icon $$
       { v_transpimg(List[i].x0, List[i].y0, (unsigned char *)bi1, Transp);
       }
       else
#endif
       {
  IKNDEBUG;
         v_putimg(List[i].x0, List[i].y0, bi1);
       }
     }
    cont1:;
   }
   From += nIcon;
#ifndef POSIX
   goto Next_draw;
#endif
  }

  if(bi1 != NULL) farfree(bi1);
#ifdef GGI
  Smart_ggiFlush();
#endif
  freeinkons();
}

// Volat pri uvolneni swapu nad FIRSTHTMLSWAP
// Oznaci nektere ikony v indexu za neplatne
// tr.: Call when releasing of swap above FIRSTHTMLSWAP
//      marks some icons in index as invalid


// -------- INTERNAL FCE --------------------------
int PrepareIconDraw(XSWAP hSwap, unsigned int Off, char **bo, int *TrCol)
{
     char *BufImg,*bi1, *palin, *boo;
     int  npalikn,Mapuj;
     short int mcol,mrow;
     int  ist, Transp;
     int   *mapio, *Mmapio[2], *mapio2;

     BufImg = ie_getswap(hSwap);
     if(!BufImg)
      MALLOCERR();

     mapio=farmalloc(512*sizeof(int));
     if(mapio == NULL) return( 0 );

     memcpy(&npalikn, BufImg+Off, sizeof(int));
     memcpy(&Transp, BufImg+Off+sizeof(int), sizeof(int));
     palin = BufImg + Off + 2*sizeof(int);
     bi1   = BufImg + Off + (2*sizeof(int) + npalikn*3);

     ist = MergePalIcons(npalikn, palin, mapio, Mmapio, &Mapuj);
     if(ist != 1) return( 0 );

     memcpy(&mcol, bi1, sizeof(short));
     memcpy(&mrow, bi1+2, sizeof(short)); //16 bit integers
     //??mcol=(short int) *bi1;
     //??mrow=(short int) *(bi1+2);
     boo = farmalloc(mcol*mrow+16);
     if(boo == NULL) return( 0 );

     if(Mapuj)
     { memcpy(boo, &mcol, sizeof(short));
      memcpy(boo+2, &mrow, sizeof(short)); //16 bit integers!!!
       RepalIcon2(mcol, mrow, (unsigned char*)bi1, (unsigned char*)boo, Mmapio);
       if(Transp >= 0)
       { mapio2=Mmapio[1];
         *TrCol = mapio2[Transp];
       }
       else
       { *TrCol = Transp;
       }
     }
     else
     { memcpy(boo, bi1, mcol*mrow+4);
      *TrCol = Transp;
     }
     farfree(mapio);
     *bo = boo;

     return( 1 );
}


void DrawIcon1(int x0, int y0, XSWAP hSwap, unsigned int Off)
{
    char *BufImg, *bi1, *bo=NULL;
    int ist,  Transp = -1;
#ifdef TRANSPARENT_ICONS
    int i;
    short int *bi2, HiTransp;
#endif

    if(xg_256 != MM_256)       // mam pripraveny IMG ve swapu
                            // tr.: I have IMG prepared in swap
    {
      if(!xg_video_XMS || xg_256 == MM_Hic)
      { if(g_AktPalLen == IiNpal)
        { if(memcmp(Iipal, g_LastPal, 3*IiNpal) == 0) goto Ident1;
        }
        x_palett(IiNpal, Iipal);
        g_AktPalLen = IiNpal;
        memcpy(g_LastPal, Iipal, 3*IiNpal);
        Ident1:;
      }

      BufImg = ie_getswap(hSwap);
      if(!BufImg) //return on error !
       MALLOCERR();

      bi1    = BufImg + Off;

#ifdef TRANSPARENT_ICONS
      if(xg_256 == MM_Hic)
      {
        bi2 = (short *)bi1;
        i = 2 + bi2[0] * bi2[1];
        if(bi2[i] != 0)  // Hicolor transparent colour
        { HiTransp = bi2[i+1]; Transp = 1;
        }
      }

      if(Transp >= 0 && g_SetTransp > 0) // Transparent icon $$
      {
       //printf("Icon is transparent?\n");
       v_transpimg(x0, y0, (unsigned char*)bi1, HiTransp);
      }
      else
#endif
      {
/*
       int w;
       int h;

       w = *(short int *)bi1;
       h = *(short int *)&bi1[sizeof(short int)];
       printf("In DrawIcon1, x=%d, y=%d, w=%d, h=%d\n",x0,y0,h,w);
       IKNDEBUG;

//       if(x0>=0 && x0+w<=x_maxx() && y0>=0 && y0+h<=x_maxy())
*/
        v_putimg( x0, y0, bi1);
      }
    }
    else                     // in 256 color mode I need to create IMG
    { g_AktPalLen = IiNpal;
      memcpy(g_LastPal, Iipal, 3*IiNpal);

      ist = PrepareIconDraw(hSwap, Off, &bo, &Transp);
      if(ist != 1) return;

      if(!xg_video_XMS || xg_256 == MM_Hic)
      { if(g_AktPalLen == IiNpal)
        { if(memcmp(Iipal, g_LastPal, 3*IiNpal) == 0) goto Ident2;
        }
        x_palett(IiNpal, Iipal);
        g_AktPalLen = IiNpal;
        memcpy(g_LastPal, Iipal, 3*IiNpal);
        Ident2:;
      }

#ifdef TRANSPARENT_ICONS
      if(Transp >= 0 && g_SetTransp > 0) // Transparent icon $$
      { v_transpimg(x0, y0, (unsigned char*)bo, Transp);
      }
      else
#endif
      {
  IKNDEBUG;
        v_putimg(x0, y0, bo);
      }
      if(bo != NULL) farfree(bo);
    }
}

void freeinkons(void)   //releasing index of icons
{
   g_AktList  = 0;
}

// Zda je ikona v indexu
// tr.: Whether the icon is in index
int IsInIndex(char *iconame, XSWAP *hSwap, unsigned int *Off,
              int *InxDel)
{
    char  *BegSwap;
    struct IknIndex *IknInx;
    int    i;

#ifdef POSIX
    IKNDEBUG;
    IknInx=IknPtr;
#else
    BegSwap = ie_getswap(g_hIndex);
    if(!BegSwap)
     MALLOCERR();
    IknInx = (struct IknIndex *)BegSwap;
#endif

    for(i=0; i<g_AktIndex; i++)
    { if(strcmpi(iconame, IknInx[i].iconame) == 0)
      { goto Mam_ji;
      }
    }
    *InxDel = -1;
    return( -1 );

    Mam_ji:
    *hSwap = IknInx[i].hSwap;
    *Off   = IknInx[i].Off;
    /*
    if(IknInx[i].Del != 0)
    { *InxDel = i;
      return( -1 );
    }
    else
    */
    { *InxDel = -1;
      return( i );
    }
}

// Prida ikonu do seznamu pro pozdejsi vykresleni
// tr.: Adds icon to the index in order to draw it later
int AddToList(int x0, int y0, int JeVinx)
{
    char *BegSwap;
    struct IknIndex *IknInx;
    struct IknList  *IknLst;

    if(g_AktList >= MAX_ICNLIST) return( -1 );


#ifdef POSIX
    IKNDEBUG;
    IknInx = IknPtr;
    IknLst = (struct IknList *)((void *)IknPtr+g_BegList);
#else
    BegSwap = ie_getswap(g_hIndex);
    if(!BegSwap)
     MALLOCERR();
    IknInx = (struct IknIndex *)BegSwap;
    IknLst = (struct IknList *)(BegSwap+g_BegList);
#endif

//    printf("g_AktList=%d, g_BegList=%d, IknLst[0].x0=%p, x0=%d\n",g_AktList,g_BegList,&(IknLst[0].x0),x0);
    IknLst[g_AktList].x0 = x0;
    IknLst[g_AktList].y0 = y0;
    IknLst[g_AktList].hSwap = IknInx[JeVinx].hSwap;
    IknLst[g_AktList].Off = IknInx[JeVinx].Off;
    g_AktList++;

    return( 1 );
}

// Prida ikonu do indexu
// tr.: Adds icon to the index
int  AddIconToIndex(char *iconame, XSWAP hSwap,
                    unsigned int Off, int AddOrRw)
{
// AddOrRw : -1 = pridat na konec indexu
//                tr.: add at the end of the index
//          >=0 = prepsat tento index
//                tr.: overwrite this index
    char *BegSwap;
    struct IknIndex *IknInx;
    unsigned int kludge;   //!!JdS 2004/10/29 ... see below

    if(g_AktIndex >= MAX_ICNINDEX) return( -1 );

#ifdef POSIX
    IKNDEBUG;
    IknInx = IknPtr;
#else
    BegSwap = ie_getswap(g_hIndex);
    if(!BegSwap)
     MALLOCERR();
    IknInx = (struct IknIndex *)BegSwap;
#endif

    if(AddOrRw < 0)  // pripsat do indexu (tr.: add into index)
    {
    IknInx[g_AktIndex].hSwap = hSwap;
    IknInx[g_AktIndex].Off   = Off;
/*
    IknInx[g_AktIndex].Up    = Up;
    IknInx[g_AktIndex].Del   = 0;
*/
    strcpy(IknInx[g_AktIndex].iconame, iconame);

    //!!JdS: 2004/10/29 {
    // MHT discovered faulty code from the BC++ 3.1 compiler here when the
    // "Suppress Redundant Loads" optimization was enabled, when returning
    // the decremented value of a just-incremented variable (in this case,
    // g_AktIndex). A simple work-around is implemented below ...
    kludge = g_AktIndex;
    g_AktIndex++;
    //return(g_AktIndex-1);
    return(kludge);
    //!!JdS: 2004/10/29 }
    }
    else   // prepsat jiz existujici (tr.: overwrite already existing one)
    {
    IknInx[AddOrRw].hSwap = hSwap;
    IknInx[AddOrRw].Off   = Off;
/*
    IknInx[AddOrRw].Up    = Up;
    IknInx[AddOrRw].Del   = 0;
*/
    return(AddOrRw);
    }
}

// Vraci poitr na buffer + handle a offset
// Predpoklada se pouze pridavani !
// tr.: Returns pointer for buffer + handle and offset
//      presumed is only adding !
//. low level funtion for icon management
char *MemIconImg(unsigned int Len, XSWAP *hSwap, unsigned int *Off, int *Up)
{
   char *BufImg,*RetMem;
   unsigned int FreeMem;

   FreeMem = g_maxswap - g_FreeOff;

   if(Len > FreeMem)    // V akt. swapu uz neni misto -> zalozit novy
                    // tr.: There is no more space left in current swap
                    //      -> create a new one
   {  g_maxswap = max(Len, MAX_ICONSWAP);
      // no longer needed: ie_swap(0);
      //printf("allocating XSWAP for icon..\n");
      g_AktImgSwap = ie_putswap("",g_maxswap,CONTEXT_ICONS);
//      g_UpIcnData = 0;
      g_FreeOff = 0;
   }

   BufImg = ie_getswap(g_AktImgSwap);
   if(!BufImg)
     MALLOCERR();

   RetMem = BufImg + g_FreeOff;
   *hSwap = g_AktImgSwap;
   *Off   = g_FreeOff;
//   *Up    = g_UpIcnData;
   *Up    = 0;

   g_FreeOff += Len;
   return( RetMem );
}

// Slucovani palet ikon (tr.: combining palettes of icons)
//.Pal : Pallete
int MergePalIcons(int npalikn, char *palin, int *mapio, int *Mmapio[],
                  int *Mapujo)
{
  int   maxpalview, Mapuj, irc, n1, i;
  char *Palin[2];
  int   Npalin[2];
  int   npalout;
  char *Savecols/*[512]*/;

  if(xg_256 == MM_Hic)
   maxpalview= 256;
  else
   maxpalview= x_getmaxcol() + 1;
  Mapuj=0;
  Savecols=farmalloc(256*sizeof(int));
  if(Savecols == NULL)
  {
   //printf("Could not allocate ?!\n");
   return( 0 );
  }

  if(IiNpal<=0)     //1.icon
  { IiNpal= npalikn;
    memmove(Iipal,palin, 3 * IiNpal);
    if(IiNpal<=maxpalview) goto Kresli;
  }

  if(egamode)
  {
   int i=0;
   while(i<npalikn*3)
   {
    palin[i]=egafilter(palin[i]);
    i++;
   }
  }
  if(vga16mode && !vgamono)
  {
   int i=0;
   while(i<npalikn*3)
   {
    palin[i]=vgafilter(palin[i]);
    i++;
   }
  }

  // Slucovani palet (tr.: combining palettes)
  Palin[0]= Iipal; Palin[1]= palin;
  Npalin[0]= IiNpal; Npalin[1]= npalikn;
  npalout= maxpalview;
  n1=min(IiNpal,maxpalview); //(muze zabrat pri 1.ikone)
       // tr.: (this can help/work with the first icon)
  memset( Savecols, 1, n1); memset( &Savecols[n1], 0, npalikn);
  irc=PresspalO(2, Palin, Npalin, Iipal,
                &npalout, mapio, Mmapio,
                2, 1, 4,  Savecols );
  if((irc&1)==0) { ; }      // Error ?!

  if(!xg_video_XMS || xg_256 == MM_Hic) //!!mp
  {
   if(npalout > IiNpal)      // New colours
   { for(i=IiNpal; i<npalout; i++) x_pal_1(i, &Iipal[i]);
   }
  }
  IiNpal=npalout; Mapuj=1;

  Kresli:
  *Mapujo = Mapuj;
  farfree(Savecols);
  return( 1 );
}

// vrati ikonu v 256 color modu (bud alokuje, nebo je to puvodni bi)
// tr: returns in 256 color mode (either allocates or it is
//     an original bi)
unsigned char *TransferTo256(short mcol, short mrow, unsigned char *bi,
              int inp16, int *Nbworko)
{
// Nbwork: 0 == vraceny buffer je vstupni, jinak delka alloc bufru
// tr.: Nbwork: 0 == returned buffer is input buffer,
//      otherwise length alloc of buffer/buffers
 int ikkk, Nbwork, len8, len2, i, j;
 unsigned char *bwork = NULL;

 if(inp16 == 1)  // 16 color IKN
 {
   // transfer to 256
   Nbwork = (int)mcol * (int)mrow + 16;      // length of working buffer
   //printf("Allocating: mcol=%d,mrow=%d\n",mcol,mrow);
   bwork  = farmalloc(Nbwork);
   if(bwork == NULL)
   {
    //printf("malloc failed! Nbwork=%d\n",Nbwork);
    goto No_mem;
   }

   ikkk=4;
   memcpy(bwork, &mcol,sizeof(short));
   memcpy(&bwork[2], &mrow,sizeof(short));
   len2= (mcol+7)/8; len8= len2 * 8;
   for(i=0,j=4;i<mrow;i++)
   { bit_pix8((char *)&bi[j], (char *)&bwork[ikkk], len8, 4);
     j += 4 * len2; ikkk += mcol;
   }
 }
 else           // 256 color IKN
 { bwork = bi;
   Nbwork = 0;
 }

 No_mem:
 *Nbworko = Nbwork;
 return( bwork );
}

//. Repal : change pallete
void RepalIcon1(short mcol, short mrow, unsigned char *bwork, int *Mmapio[])
{
   int *mapio2, ikk, i, j;

   if(!bwork || !Mmapio || !Mmapio || !Mmapio[1])
    return; // to avoid SIGSEGV

   mapio2=Mmapio[1];
   ikk= ((int)mcol * (int)mrow) + 4;
   //printf("RepalIcon1: mcol=%d,mrow=%d,ikk=%d\n",mcol,mrow,ikk);
   for(i=4;i<ikk;i++)
   { j= bwork[i]; bwork[i]= mapio2[j];
   }
}

void RepalIcon2(short int mcol, short int mrow, unsigned char* bwork,
                unsigned char* bio, int *Mmapio[])
{
   int *mapio2, ikk, i, j;

   mapio2=Mmapio[1];
   ikk= (mcol * mrow) + 4;
   for(i=4;i<ikk;i++)
   { j= bwork[i]; bio[i]= mapio2[j];
   }
}

#ifdef TRANSPARENT_ICONS
//. transparent icons.  not used by Arachne yet
int v_transpimg(int x0, int y0, unsigned char *bi1, int Transp)
{
   unsigned int  ncol, nrow, i, nEnd;
   unsigned short int HiTransp, *getHiBit, *bi1Hi;
   unsigned char ChTransp;
   unsigned char *getBit;
   long Size;

   bi1Hi = (unsigned int*)bi1;
   ncol = bi1Hi[0];
   nrow = bi1Hi[1];

   if(xg_256 == MM_256)
   { ChTransp = (unsigned char)Transp;
     Size = (long)ncol * (long)nrow + 8;
     nEnd =  ncol*nrow+4;
   }
   else if(xg_256 == MM_Hic)
   { HiTransp = Transp;
     Size = 2*(long)ncol * (long)nrow + 8;
     nEnd =  ncol*nrow+2;
   }
   else
   { return( 10 );
   }

   getBit = farmalloc(Size);
   if(getBit == NULL) return( 2 );

   v_getimg(x0, y0, x0+ncol-1, y0+nrow-1, (char*)getBit);
   getHiBit = (unsigned int*)getBit;

   if(xg_256 == MM_256)
   {  for(i = 4; i<nEnd; i++)
      { if(bi1[i] != ChTransp)
        { getBit[i] = bi1[i];
        }
      }
   }
   else
   {  for(i = 2; i<nEnd; i++)
      { if(bi1Hi[i] != HiTransp)
        { getHiBit[i] = bi1Hi[i];
        }
      }
   }
   v_putimg(x0, y0, (char*)getBit);
   farfree(getBit);
   return( 1 );
}
#endif
//##---------------------------------------------------------------------

//nacteni 1 ikony do pameti, pripadne vykresleni
// tr.: load 1 icon to memory, and draw if needed
void Putikonx(int x0, int y0, char *iconame, char noswap)
//priznak noswap=1 -> rovnou vykresli
//              =0 -> jen prida do seznamu
// tr.: type noswap=1 -> draw immediately
//                 =0 -> only add to index
{
  short int ip1;
  int ik,len1;
  short int mcol,mrow;
  int inp16,npalikn;
  int   irc,Mapuj, Npalw;
  int   *mapio/*[512]*/, *Mmapio[2];
  char  *palin;
  unsigned short nbufo;
  unsigned char *bi1;
  short *bi2;
  int  fin, Nbwork, lenpix, Nbufw;
  char filnam[77];
#ifndef POSIX
  char dir[77],drive[4];
#endif
  char dummy[10],iconame2[10];
  char          *bufw= NULL;
  unsigned char *bi=NULL;
  unsigned char *bwork = NULL;
  char          *palcpy = NULL;
  XSWAP   hSwap = 0;
  unsigned int Off = 0;
#ifdef HICOLOR
  unsigned short int   *biHi = NULL;
  int i;
#endif
  int      JeVinx, AddInx, InxDel, UpIcnMem;
  int      Transp;      // Transparent icons

  // -------------------------------------------------
#ifdef POSIX
  // will be ../lib/arachne/ikons/
  strcpy(filnam, sharepath);
  strcat(filnam, "ikons/");
  {
   char *ptr=strrchr(iconame,'/');
   if(ptr)
    strncat(filnam,&ptr[1],12);
   else
    strncat(filnam,iconame,12);
   filnam[76]='\0';
  }
  strlwr(filnam);
  if(!strstr(filnam,".ikn"))
   strcat(filnam,".ikn");
//  printf("Ikon to draw: %s at x=%d,y=%d\n",filnam,x0,y0);
#else
  strcpy(filnam, exepath);
  strcat(filnam, "system\\ikons\\");
  fnsplit(iconame, drive,dir, iconame2, dummy);
  fnsplit(filnam, drive, dir, dummy, dummy);
  fnmerge(filnam, drive, dir, iconame2,".ikn");
#endif
  // Zda je jiz v indexu, nebo -1, neni
  // tr.: whether it is already in index, or -1 if not
  JeVinx = IsInIndex(filnam, &hSwap, &Off, &InxDel); // returns index
  if( JeVinx >= 0)                // ?? problem of palettes ??
  {
   if(!noswap)                    //  add to index
   { AddToList(x0,y0, JeVinx);
     swapmod = 1;
   }
   else                           // I draw immediately
   { //x__palett(IiNpal, Iipal);     // palette ?
     DrawIcon1(x0, y0, hSwap, Off);
   }
   return;
  }

  // Ikonu je treba nacist, prevest,... a ulozit do swapu
  // tr.: icon must be loaded, converted, ... and saved to swap
  bi=farmalloc(BUFERSIZE);   // temporary buffer for Read() from disk
  mapio=farmalloc(512*sizeof(int));
  if(!bi || !mapio) goto freebi;

  bi1=bi;
  bi2= (short *)bi;

/*   structure of files IKN:
 +----------------------------------+--------------+
 | palette (= 16*3 B) |(mcolview-1) | (mrowview-1) |
 +----------------------------------+--------------+

 +-------------------------------------------------------------------+
 | ip1 | nbuf1 | data1 | ip2 | nbuf2 | data2 ...         ... | 0 | 0 |
 +-------------------------------------------------------------------+

   structure of the beginning of IKN file for 256 colour mode:
 +----+-----+----+---------------------+-------------+--------------+
 | Npal(2B) | FF | paleta (= Npal*3 B) |(mcolview-1) | (mrowview-1) |
 +----+-----+----+---------------------+-------------+--------------+
*/
#ifdef POSIX
  if ((fin = a_open(filnam, O_RDONLY | O_BINARY, S_IREAD | S_IWRITE )) == -1 )
#else
  if ((fin = a_sopen(filnam, O_RDONLY | O_BINARY,
                   SH_COMPAT | SH_DENYNONE,S_IREAD | S_IWRITE )) == -1 )
#endif
  { goto freebi;
  }


//------- input of 1st buffer --------->>
  if ( (len1=a_read( fin, bi, 779u )) == -1 ) goto ErrRead;

  if(bi[2]==0xFF)
  {
   inp16=0;
   npalikn=bi2[0]; palin=(char *) &bi[3];
   ik= 7 + 3 * npalikn;
   memcpy(&ip1, &bi[ik],sizeof(short));
   memcpy(&nbufo, &bi[ik+2],sizeof(short));
   ik += 4;
   //printf("Icon %s at %d, %d is 256 color...\n",filnam,x0,y0);
  }
  else
  {
   inp16=1;//type of representation "getimg/16barev"
   npalikn=16; palin=(char *) bi;
   ip1  =bi2[26]; nbufo=bi2[27]; ik=56;
  }

  // Transparent icons $$
  Transp = -1;
#ifdef TRANSPARENT_ICONS
  for(i=0; i<3*npalikn; i += 3)
  { if(palin[i+1] & 0x80)         // Nastaveny nejvyssi bit v G slozce
                        // tr.: highest bit set/defined in G folder
    { if(Transp < 0)              // Jenom prvni
                        // tr.: only first
      { Transp = i/3;
      }
      palin[i+1] &= 0x7F;         // Vynulovat  vsechny
                        // tr.: erase all
    }
  }
#endif
  //----------------- osetreni palet ------------->
  // tr.: palette treatment
  if(xg_256 != MM_256)   // I am not in 256 color mode
  {
    irc = MergePalIcons(npalikn, palin, mapio, Mmapio, &Mapuj);
    //printf("After MergePalIcons, IiNpal=%d\n", IiNpal);
    if(irc == 0) goto Memover;
  }
  else  // schovat si paletu na pozdejc
   // tr.: keep the palette for later use
  { palcpy = farmalloc(npalikn*3);
    if(palcpy == NULL) goto Memover;
    memcpy(palcpy, palin, npalikn*3);
  }

//Draw:
  //--------------------------------- input of N buffer --------->>
  len1= len1 -ik;       //precteny kus bufferu
                        // tr.: part of buffer loaded
  memmove(bi, &bi[ik], len1);
  ik= len1;
  len1= nbufo - len1 +4;

Dalsi:
 if(len1>0)
 {  if ( (a_read( fin, &bi[ik], len1)) == -1 ) goto ErrRead;
    len1=0; ik=0;
 }

 // bi,bi2 - input buffer (file IKN)
 bi2=(short *)bi;
 mcol= bi2[0];
 mrow= bi2[1];

 if(xg_256==MM_2)
   { lenpix=1; }
 else if(xg_256==MM_16)
   { lenpix = 4; }
 else if(xg_256==MM_256)
   { lenpix = 8; }
 else
   { lenpix = 16; }

 // bi - vstupni buffer s IMG ikony v inp16 modu
 // bwork - pracovni buffer s 1B/pixel  (schova se v 256 color modu)
 // bufw - buffer s IMG v aktualnim grf. modu (schova se v ostatnich modech)
 // tr.: bi - input buffer with IMG icons in inp16 mode
 //      bwork - working buffer with 1B/pixel
 //       (will be saved in 256 color mode)
 //      bufw - buffer with IMG in current graphical mode
 //       (will be saved in the other modes)

 if(xg_256 == MM_256)  // only: save palette + 256 color img
 {
   bwork = TransferTo256(mcol, mrow, bi, inp16, &Nbwork);
   if(bwork == NULL)  goto Memover;

   Npalw = 2*sizeof(int) + 3*npalikn;     // length of palette, Transparent, palette
   Nbufw = (mcol*lenpix)/8 * mrow + 16;  // (img icons)

   bufw= MemIconImg((unsigned int)(Npalw+Nbufw), &hSwap, &Off, &UpIcnMem);
   if(bufw==NULL) goto Memover;

   memcpy(bufw, &npalikn, sizeof(int));
   memcpy(bufw+sizeof(int), &Transp, sizeof(int));
   memcpy(bufw+2*sizeof(int), palcpy, 3*npalikn);
   if(palcpy != NULL) { farfree(palcpy); palcpy = NULL;}
   memcpy(bufw+Npalw, bwork, Nbufw);


   // michani palet a repaletizace se odlozi az do kresleni !!
   // tr.: mixing palettes and repalettizing postponed to
   //     the time of drawing
 }
 else                  // v ostatnich modech repal+ulozeni vysedneho IMG
             // tr.: in other modes repal+save of resulting(???) IMG
 {
   if(inp16 == 1 && xg_256 == MM_16 && Mapuj == 0)  // special case
   { Nbwork = 0;
     bwork = bi;
   }
   else
   {
     bwork = TransferTo256(mcol, mrow, bi, inp16, &Nbwork);
     if(bwork == NULL)
     {
      goto Memover;
     }
   }
   //---------- translation of colours according to mapiol ------------------
   if(Mapuj)
   { RepalIcon1(mcol, mrow, bwork, Mmapio);
   }

   //------------ allocation of out buffer (in swap) for icon
   if(xg_256 == MM_2 || xg_256 == MM_16)         // 2,16 colours
    Nbufw = ((mcol+7)/8 * lenpix) * mrow + 16;
   else                                          // 256,Hi-col colours
    Nbufw = (mcol*lenpix)/8 * mrow + 16;

   bufw= MemIconImg((unsigned int)Nbufw, &hSwap, &Off, &UpIcnMem);
   if(bufw==NULL) goto Memover;
   bi1 = (unsigned char *) bufw;
#ifdef HICOLOR
   biHi = (unsigned short int *)bufw;
#endif

   //----- Convert icons into the right format according to graphic mode
   // IKN je vetsinou ted v 256 barvach, nekdy v 16 barvach
   // tr.: IKN is mostly now in 256 colours, sometimes in 16 colours
  if(inp16 == 1 && xg_256 == MM_16 && Mapuj == 0)
  {
   memcpy(bi1, bi, nbufo);
  }
  else        // in workb is a 256 color icon
  {
  switch(xg_256)
   { case   MM_Hic:        // Hi color

#ifdef HICOLOR
     memcpy(bi1, &mcol,sizeof(short));
     memcpy(&bi1[2],&mrow,sizeof(short));

     // Musi byt nastavena paleta (je volano x__palett() ?)
     // tr.: The palette must be defined (has x__palett() been called?)
     memcpy(xg_hipal, Iipal, 3*IiNpal);
     for(i=0; i<IiNpal; i++)
     { xg_hival[i]=xh_RgbHiPal(xg_hipal[3*i],xg_hipal[3*i+1],xg_hipal[3*i+2]);
     }
     xh_ByteToHi(&bwork[4], &bi1[4], mcol,mrow,mcol);
     i = 2 + mcol * mrow;   // na konci bufru mam 12B rezervu
                      // tr.: at the end of buffer I have 12B reserve
     if(Transp < 0)         // 4B pro ulozeni transp. barvy v HiCol
                      // tr.: 4B to save transp. colours in HiCol
     { biHi[i] = 0;
     }
     else
     { biHi[i] = 1; biHi[i+1] = xg_hival[Transp];
     }
#endif //HICOLOR
               break;
     case MM_2: x_img256to2(bwork, bi1);       // Binary
               break;
     case MM_16: x_img256to16(bwork, bi1);
               break;
     case MM_256: memcpy(bi1, bwork, Nbufw);   // sem se to nedostane!
                                  // tr.: it cannot get here!
               break;
     default :
               break;
   }
  }
 }// end if 256|others

 swapmod=1;  // I have written data

 // I add them to the index
   AddInx = AddIconToIndex(filnam, hSwap, Off, InxDel);
   if(!noswap && AddInx >= 0)
   {
    //printf("Adding to list at coordinates %d,%d, index=%d\n",x0,y0,AddInx);
    AddToList(x0,y0, AddInx);      // I add to index
   }
  swapmod=1;  // I have written to index

  if(Nbwork > 0)      // I have allocated auxiliary buffer
  { farfree(bwork);
  }

  bi2= (short *)&bi[nbufo];
  ip1=  bi2[0];
  nbufo=bi2[1];
  if( ip1 > 0){ len1 +=nbufo+4; goto Dalsi; }  // icons with more than one frame?

  a_close(fin);
  goto freebi;

//------------ Error status
Memover:
  memerr();
ErrRead:
Error:
  x_grf_mod(3);
  printf(MSG_ERRIKN);
  exit(EXIT_ABNORMAL);

//--------- OK termination
  freebi:

  if(mapio)
   farfree(mapio);
  if(bi)
   farfree(bi);

  if(noswap)
  {
    if (hSwap) DrawIcon1(x0, y0, hSwap, Off);
  }
}

#ifndef POSIX

//optimalization sorting is not really required if we have linear access to memory.
//it was just optimizing access to memory areas swapped to XMS/EMS/disk

int  GetListNext(int From, int Kolik, struct IknList *List)
{
    char   *BegSwap;
    struct IknList  *IknLst;
    int    Kopiruj;

    BegSwap = ie_getswap(g_hIndex);
    if(!BegSwap)
     MALLOCERR();
    IknLst = (struct IknList *)(BegSwap+g_BegList);

    if((From + Kolik) > g_AktList)
    { Kopiruj = g_AktList - From;
      if(Kopiruj <= 0) return( 0 );
    }
    else
     Kopiruj = Kolik;
    memcpy(List, &IknLst[From], Kopiruj*sizeof(struct IknList));
    return( Kopiruj );
}

#define MQSTA  64

#define SIZEOFICON (sizeof(XSWAP)+3*sizeof(int))
//  quick sort na setrideni listu ikon (optimalizace kresleni)
//  tr.: quick sort to sort list of icons (optimalization of drawing)

int SortListIcons(void)
{
    char   *BegSwap;
    unsigned int *A;
    int           N4;
    int      QSTA[MQSTA];       // Zasobnik (tr.: storage)
    int      L,R,I,J,IS,ISPR;
    int      X,X2;
    char pom[SIZEOFICON];

    BegSwap = ie_getswap(g_hIndex);
    if(!BegSwap)
     MALLOCERR();
    A  = (unsigned int *)(BegSwap+g_BegList);

    if(g_AktList <= 1) return( 1 );
    N4 =  g_AktList*4 - 4;

// ***************************************************************
      IS=0;               // CELE POLE DO ZASOBNIKU
                          // tr.: entire field to storage
      QSTA[IS]=0;
      QSTA[IS+1]=N4;
//--------------------
 _10: L=QSTA[IS];         // VYBER ZE ZASOBNIKU
                          // tr.: retrieve from storage
      R=QSTA[IS+1];
      IS=IS-2;
//--------------------
 _20: I=L;                // TRIDENI USEKU <I,J>
                          // tr.: sort section <I,J>
      J=R;
      ISPR=((L+R)/2)/4*4;
      if(ISPR > R) ISPR=R;
      if(ISPR < L) ISPR=L;
      X =A[ISPR];        // STREDOVY PRVEK  X (handle swapu)
                         // tr.: middle element X (handle of swap)
      X2=A[ISPR+1];      // Offset in swap
//--------------------
 _30: if(A[I] <=  X)
      {
       if(A[I] == X)
        if(A[I+1] >= X2) goto _40;
      }
      else
      { goto _40;
      }
      I=I+4;
      goto _30;

 _40: if(A[J] >= X)
      {
       if(A[J] == X)
         if(A[J+1] <= X2) goto _50;
      }
      else
      { goto _50;
      }
      J=J-4;
      goto _40;

 _50: if(I <= J)   // PROHOZENI
                   // tr.: exchange
      {
       memcpy(pom, &A[I], SIZEOFICON);
       memcpy(&A[I], &A[J], SIZEOFICON);
       memcpy(&A[J], pom, SIZEOFICON);
       I=I+4;
       J=J-4;
      }
      if(I <= J) goto _30;

      if(I < R)      // ULOZENI PRAVE CASTI DO STACKU
                     // tr.: save right part to stack
      {
       IS=IS+2;
       if(IS >= MQSTA) return( 2 );
       QSTA[IS]=I;
       QSTA[IS+1]=R;
      }
      R=J;                 // TRIDENI ZBYTKU LEVE CASTI
                           // tr.: sort the rest of the left part
      if(L  <  R) goto _20;
      if(IS >= 0) goto _10;

      return( 1 );
}

#endif

int z_bytebit(char *inp, char *out, int npix)
{
/* inp   - field with one pixel row                    */
/* out   - field with bit level                        */
/* npix  - number of pixels in inp                     */

   int i,lenbit,zbt;

   zbt = npix & 0x0007;
   lenbit = npix>>3;
   if(zbt != 0) lenbit++;      /* Bytu na 1 bit. rovinu */
                               /* tr.: Bytes for/at 1 bit. level */

   memset(out,0,lenbit);       /* reset field dest   */

   for(i=0; i<npix; i++)       /* loop through pixels */
     { if(inp[i] & 0x01) out[(i>>3)] |= (0x80 >> (i & 0x07));
     }
   return(1);

}

//--------------- iknbuf ----------------
struct iknbuf
{
  void far *nextikn;
  int x0,y0,mcol,mrow,inp16,ip1;
  char iconame[80];
  unsigned char *bufimg;
};
#define LENIKNBUF sizeof(struct iknbuf)
//---------- global variables -------------
//(z ...\flood\xvirt.c  :)
void z_bitbyte(unsigned char *buf1, unsigned char *buf2, int delka);
int bit_pix8(char *sourc, char *dest, int npix, int nbit);
int pix8_bit(char *sour8, char *dest4, int npix, int nbit);
//##---------------------------------------------------------------------
//------ convert img/16 to img/256 --------
void x_img16to256(char *bi, char *bo)
{
// bi buffer ziskany z getimg v 16-ti barev. modu
// bo buffer urceny pro putimg v 256-ti barev. modu
// bo = vystup, musi byt prislusne dlouhy!(max. 65K!)
// tr.: bi buffer acquired from getimg in 16 color mode
//      bo buffer assigned for putimg in 256 color mode
//      bo = output, must be accordingly long! (max. 65K!)
  short int mcol, mrow;
  int ikkk,len2,mcol8,i,j;

        memcpy(&mcol,bi,sizeof(short int)); memcpy(&mrow, &bi[2],sizeof(short));
        memcpy(bo, &mcol,sizeof(short int)); memcpy(&bo[2], &mrow,sizeof(short));
        ikkk=4;
        len2= (mcol+7)/8;
        mcol8= len2 * 8;
        for(i=0,j=4;i<mrow;i++)
        {
          bit_pix8(&bi[j], &bo[ikkk], mcol8, 4);
          j += 4 * len2; ikkk += mcol;
        }//konec cyklu pres radky (tr.: end of loop on rows)
        return;
}
//##---------------------------------------------------------------------
//------ convert img/256 to img/16 --------
void x_img256to16(unsigned char *bi, unsigned char *bo)
{
// bi buffer ziskany z getimg v 256-ti barev. modu
// bo buffer urceny pro putimg v 16-ti barev. modu
// predpoklada se samozrejme, ze v bi se vyskytuji pouze
// barvy 0..15 resp. horni 4 bity v pixelu se ignoruji!
// !! obe pole jsou max.65K, (zvlaste bi)
// tr.: bi buffer acquired from getimg in 256 color mode
//      bo buffer assigned for putimg in 16 color mode
//      Of course it is presumed that bi contains only
//      colours 0..15 resp. the upper 4 bits in the pixel
//      will be ignored.
//      !! Both fields have max. 65K (especially bi)

  short int mcol, mrow;
  int ikkk,len2,mcol8,j,irow;

        memcpy(&mcol,bi,sizeof(short));
        memcpy(&mrow, &bi[2],sizeof(short));
        memcpy(bo, &mcol,sizeof(short));
        memcpy(&bo[2], &mrow,sizeof(short));
        ikkk=4;
        len2= (mcol+7)/8;
        mcol8= len2 * 8;
        for(irow=0,j=4;irow<mrow;irow++)
        {
          pix8_bit((char *)&bi[ikkk], (char *)&bo[j], mcol8, 4);
          j += 4 * len2; ikkk += mcol;
        }//konec cyklu pres radky (tr.: end of loop on rows)
        return;
}
//##---------------------------------------------------------------------
//------ convert img/256 to img/2 --------
void x_img256to2(unsigned char *bi, unsigned char *bo)
{
// bi buffer ziskany z getimg v 256-ti barev. modu
// bo buffer urceny pro putimg v 2 barev. modu
// predpoklada se samozrejme, ze v bi se vyskytuji pouze
// barvy 0/1 resp. hornich 7 bitu v pixelu se ignoruje!
// !! obe pole jsou max.65K, (zvlaste bi)
// tr.: bi buffer acquired from getimg in 256 color mode
//      bo buffer assigned for putimg in 2 color mode
//      Of course it is presumed that bi contains only
//      colours 0/1 resp. the upper 7 bits in the pixel
//      will be ignored.
//      !! Both fields have max. 65K (especially bi)
  short int mcol, mrow;
  int ikkk,len2,mcol8,j,irow;

        memcpy(&mcol,bi,sizeof(short));
        memcpy(&mrow, &bi[2],sizeof(short));
        memcpy(bo, &mcol,sizeof(short));
        memcpy(&bo[2], &mrow,sizeof(short));
        ikkk=4;
        len2= (mcol+7)/8;
        mcol8= len2 * 8;
        for(irow=0,j=4;irow<mrow;irow++)
        {
          z_bytebit((char *)&bi[ikkk], (char *)&bo[j], mcol8);
          j +=  len2; ikkk += mcol;
        }//konec cyklu pres radky (tr.: end of loop on rows)
        return;
}
//##---------------------------------------------------------------------
//------ convert img/2 to img/256 --------
void x_img2to256(unsigned char *bi, unsigned char *bo)
{
// bi buffer ziskany z getimg v 16-ti barev. modu
// bo buffer urceny pro putimg v 256-ti barev. modu
// bo = vystup, musi byt prislusne dlouhy!(max. 65K!)
// tr.: bi buffer acquired from getimg in 16 color mode
//      bo buffer assigned for putimg in 256 color mode
//      bo = output, must be accordingly long! (max. 65K!)
  short int mcol, mrow;
  int ikkk,len2,i,j;

        memcpy(&mcol,bi,sizeof(short));
        memcpy(&mrow, &bi[2],sizeof(short));
        memcpy(bo, &mcol,sizeof(short));
        memcpy(&bo[2], &mrow,sizeof(short));
        ikkk=4;
        len2= (mcol+7)/8;
        //mcol8= len2 * 8;
        for(i=0,j=4;i<mrow;i++)
        {
//void z_bitbyte(unsigned char *buf1, unsigned char *buf2, int delka);
          z_bitbyte((unsigned char *)&bi[j], (unsigned char *)&bo[ikkk], mcol);
          j += len2; ikkk += mcol;
        }//konec cyklu pres radky (tr.: end of loop on rows)
        return;
}
//----- Prevod bytoveho radku na radek po bitovych rovinach ----
//----- tr.: Convert byte row to row in bit levels ----
int pix8_bit(char *sour8, char *dest4, int npix, int nbit)
/* sour8  - pole s jednim radkem pixlu                  */
/* dest4 - pole s jednim radkem po bit. rovinach       */
/* npix  - pocet pixlu na radek                        */
/* nbit  - pocet bitovych rovin  1..8                  */
/* tr.: sour8  - field with one pixel row                   */
/*      dest4 - field with one row in bit levels            */
/*      npix  - number of pixels in each row                */
/*      nbit  - number of bit levels 1..8                   */
{
        int i,j,k,nb,npix8;
        unsigned char c;

        memset(dest4,0,npix/2);       /* reset field dest   */
        npix8 = npix/8;
        nb = npix8*(nbit-1);

        for(j=0; j<nbit; j++)      /* loop through bit levels */
         {
/*p  for(i=0; i< npix8; i++)
                 {  c =  dest4[i+nb];
                         for(k=0; k<8; k++)
                         { if(c & 0x80) sour8[(i<<3) + k] |= 1<<j;
                                c = c<<1;
                         }
                 }
                nb -= npix8;*/
          for(i=0; i< npix8; i++)
                 { c = 0;
                   for(k=0; k<8; k++)
                   {
                     c = c<<1;
           if( sour8[(i<<3) + k] & (1<<j)) c |= 1;
                   }
                   dest4[i+nb]= c;
                 }
                nb -= npix8;
          }//endcykl pres bit.roviny (tr.: end of loop on bit levels)
        return 1;
}

