/*
    sticks.c
    Functions to simulate "throwing sticks" in Senet.
    copyright (C) 2020 Jim Hall <jhall@freedos.org>

    This is free software under the GNU GPL (only version 2).
    See the file COPYING for the full text of the GNU GPL.
*/

#include <stdio.h> /* sprintf() */
#include <stdlib.h> /* rand() */
#include <graph.h>
#include "sticks.h"

/*
    "Throwing sticks" are flat sticks that are black on one side, and white
    on the other. They are a replacement for dice. You throw or "cast" four
    sticks at once, and your move is the same number of white sides showing.
    That means if all four white sides showing, move=4. If no white sides
    are showing, move=0 (lose a turn).
*/

int
throw_sticks(void)
{
    /* returns four "throwing sticks" as a single bit pattern in the last
	four bit positions: 8421 */

    int throw;

    /* assumes you've already seeded with srandom(__) */

    throw = (int) rand();

    /* I just want the last four bits, so mask with 15 (00001111) */

    return (throw & 15);
}

void
show_sticks(int sticks)
{
    /* remember, the throw is stored in a single int variable, and the
	black/white values are 0/1 bits in the last four positions. */

    /* that means I can evaluate each "stick" as a separate bit */

    char display[] = "0 2 4 6";
    char mesg[10];
    int row;

    /* fill in the display for each bit: 8421 */

    display[0] = (sticks&8 ? '\333' : '\260');
    display[2] = (sticks&4 ? '\333' : '\260');
    display[4] = (sticks&2 ? '\333' : '\260');
    display[6] = (sticks&1 ? '\333' : '\260');

    /* display the results on the screen */

    _settextwindow(18,55, 22,79);
    _setbkcolor(6); /* brown */
    _clearscreen(_GWINDOW);

    _settextposition(2,2);
    _outtext("throwing sticks");

    for (row = 2; row < 5; row++) {
	_settextposition(row,18);
	_outtext(display);
    }

    sprintf(mesg, "move: %d", sticks_value(sticks));

    _settextposition(4,2);
    _outtext(mesg);

}

int
sticks_value(int sticks)
{
    /* determine the value of a "throw" of throwing sticks */

    int nmoves = 0;
    int bitshift;

    for (bitshift = 0; bitshift <= 3; bitshift++) {
	if (sticks & (1<<bitshift)) {
	    nmoves++;
	}
    }

    return nmoves;
}