/*
    senet.c
    An implementation of the Senet board game (ancient Egyptian board game).
    copyright (C) 2020 Jim Hall <jhall@freedos.org>

    This is free software under the GNU GPL (only version 2).
    See the file COPYING for the full text of the GNU GPL.
*/

#include <stdio.h> /* sprintf() */
#include <stdlib.h> /* srand() */
#include <conio.h>
#include <graph.h>
#include <time.h> /* time() */
#include "board.h"
#include "play.h"
#include "sticks.h"
#include "win.h"

int
main()
{
    int board[30];
    int sq;
    int move;
    int sticks;
    int tmp;
    int player;
    int winner;
    char msg[40];

    /* clear screen */

    _setvideomode(_TEXTC80);
    _displaycursor(_GCURSOROFF);

    /* create the board */

    for (sq = 0; sq < 10; sq += 2) {
	board[sq] = 1;
	board[sq+1] = 2;
    }

    for (sq = 10; sq < 30; sq++) {
	board[sq] = 0;
    }

    /* draw the board to the screen */

    _setbkcolor(2); /* green */
    _clearscreen(_GCLEARSCREEN);

    for (sq = 0; sq < 30; sq++) {
	draw_square(sq, board[sq], 0); /* not active */
    }

    print_title("SIMPLE SENET");
    print_error("Welcome to Simple Senet [read the README.TXT file for how to play]");

    /* initialize the random number generator */

    srand((unsigned int) time(NULL));

    /* play the game */

    player = 1;
    winner = 0;

    /* loop until there's a winner */

    while (winner == 0) {
	sticks = throw_sticks();
	show_sticks(sticks);
	move = sticks_value(sticks);

	if (move == 0) {
	    print_error("sticks are zero [lose a turn]");
	}
	else if (any_valid_move(board, player, move)) {
	    /* make the move */

	    sq = select_move(board, player, move);

	    if (sq >= 0) {
		if (sq+move > 29) {
		    /* move off the board */

		    board[sq] = 0;

		    /* update board */

		    print_message("You moved a piece off the board");
		    draw_square(sq, board[sq], 0);
		}
		else if (board[sq+move] == 0) {
		    /* advance the player */

		    if (sq+move == 26) {
			/* trap square .. move to sq 14 */
			board[14] = board[sq];
			board[sq] = 0;

			/* update board */

			print_message("You fell into the trap and are resurrected");
			draw_square(14, board[14], 0); /* not active */
			draw_square(sq, board[sq], 0); /* not active */
		    }
		    else {
			/* regular move */
			board[sq+move] = board[sq];
			board[sq] = 0;

			/* update board */

			print_message("You moved ahead");
			draw_square(sq+move, board[sq+move], 0); /* not active */
			draw_square(sq, board[sq], 0); /* not active */
		    }
		}
		else {
		    /* capture */

		    tmp = board[sq+move]; /* swap the value */
		    board[sq+move] = board[sq];
		    board[sq] = tmp;

		    /* update board */

		    print_message("You captured your opponent's piece");
		    draw_square(sq+move, board[sq+move], 0); /* not active */
		    draw_square(sq, board[sq], 0); /* not active */
		}

		/* check if any pieces left */
		/* if not, declare the winner (exits loop) */

		for (sq = 0; (board[sq] != player) && (sq < 30); sq++); /* empty loop */

		if (sq == 30) {
		    /* if the "for" loop exited early, we found at least
			one player piece still on the board */
		    /* if the "for" loop went to the end, there are none */

		    winner = player;
		    print_error("You have moved all your pieces off the board.");
		}
	    }
	    else {
		/* player quit .. forfeit game */

		winner = (player==1 ? 2 : 1);
		print_error("You forfeit the game.");
	    }
	}
	else {
	    /* move is nonzero, but no valid moves possible */
	    print_error("no valid moves [lose a turn]");
	}

	/* swap players */

	player = (player==1 ? 2 : 1);
    }

    /* show the winner */

    sprintf(msg, "Player %s wins! [press any key to end]", player_ch(winner));
    popup_message(msg);
    getch();

    /* reset screen and quit */

    _displaycursor(_GCURSORON);
    _setvideomode(_DEFAULTMODE); 

    return 0;
}