/*
 * four-in-a-row game: messages
 * Copyright (c) 2017-2019 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Note: this is not used for the CGI-program.
 */

#include <stdlib.h>
#include <strings.h>
#include "row4.h"

struct messages msg;

static enum languages system_language P_ ((void));


extern void
messages (l)
     enum languages l;
{
  if (l == unknown_language)
    l = system_language ();

  if (l == unknown_language)
    l = english;

  msg.language = l;
  msg.copyright = "Copyright (c) 2019 Andreas K. Foerster";

  switch (l)
    {
    default:
    case english:
      msg.language_name = "English";
      msg.title = "Four in a row";
      msg.optionerror = "Unknown option";
      msg.key = "Press any key...";
      msg.win = "? wins!";
      msg.player_1 = "1 player";
      msg.player_2 = "2 players";
      msg.license = "L: License";
      msg.quit = "E: Exit";
      msg.new_start = "N: New start";
      msg.license_text = "\
https://akfoerster.de/p/row4/\r\n\
\r\n\
This program is free software: you can redistribute it and/or modify\r\n\
it under the terms of the GNU Affero General Public License as\r\n\
published by the Free Software Foundation, either version 3 of the\r\n\
License, or (at your option) any later version.\r\n\
\r\n\
This program is distributed in the hope that it will be useful,\r\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\n\
GNU Affero General Public License for more details.\r\n\
\r\n\
You should have received a copy of the GNU Affero General Public License\r\n\
along with this program.  If not, see <http://www.gnu.org/licenses/>.";
      break;

    case deutsch:
      msg.language_name = "Deutsch";
      msg.title = "Vier in einer Reihe";
      msg.optionerror = "Unbekannte Option";
      msg.key = "Bitte beliebige Taste druecken...";
      msg.win = "? gewinnt!";
      msg.player_1 = "1 Spieler";
      msg.player_2 = "2 Spieler";
      msg.license = "L: Lizenz";
      msg.quit = "E: Ende";
      msg.new_start = "N: Neuanfang";
      msg.license_text = "\
https://akfoerster.de/p/row4/\r\n\
\r\n\
Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen\r\n\
der GNU Affero General Public License, wie von der Free Software\r\n\
Foundation veroeffentlicht, weitergeben und/oder modifizieren, entweder\r\n\
gemaess Version 3 der Lizenz oder (nach Ihrer Option) jeder spaeteren\r\n\
Version.\r\n\
\r\n\
Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es\r\n\
Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne\r\n\
die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN\r\n\
BESTIMMTEN ZWECK. Details finden Sie in der GNU Affero General Public\r\n\
License.\r\n\
\r\n\
Sie sollten ein Exemplar der GNU Affero General Public License zusammen\r\n\
mit diesem Programm erhalten haben.\r\n\
Falls nicht, siehe <http://www.gnu.org/licenses/>.";
      break;
    }
}


extern void
next_language ()
{
  enum languages l;

  l = (msg.language + 1) % (LANGUAGES + 1);

  if (unknown_language == l)
    ++l;

  messages (l);
}


#if defined(_WIN32) || defined(__WIN32__) || defined(__WINDOWS__)
#include <winnls.h>

static enum languages
system_language ()
{
  LANGID l;

  l = GetUserDefaultLangID ();

  switch (PRIMARYLANGID (l))
    {
    case LANG_ENGLISH:
      return english;

    case LANG_GERMAN:
      return deutsch;
    }

  return unknown_language;
}

#else /* not Windows */

/* this is the Unix way */
static enum languages
system_language ()
{
  const char *l;

  if (!(l = getenv ("LC_ALL")) && !(l = getenv ("LC_MESSAGES"))
      && !(l = getenv ("LANG")))
    return unknown_language;

  if (!strncasecmp (l, "en", 2))
    return english;

  if (!strncasecmp (l, "de", 2))
    return deutsch;

  return unknown_language;
}

#endif /* not Windows */
