#include <assert.h>
#include <stdio.h>
#ifdef __PACIFIC__
#include <unixio.h>
#else
#include <io.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "kitten.h"
#include "awale.h"

#if defined(__GNUC__) && (!defined(__DJGPP__) && !defined(__MINGW__) && !defined(__CYGWIN__))
/****************************/
void clrscr(void)
/****************************/
{
        puts("\033[2J");
        puts("\033[H");
}
#else

#if !defined(__TURBOC__)

#define MAX_X (*(unsigned int  far*)MK_FP(0x40, 0x4a))
#define MAX_Y (*(unsigned char far*)MK_FP(0x40, 0x84))
#define SCREEN_COLS MAX_X
#define SCREEN_ROWS (MAX_Y + 1)

/****************************/
static void gotoxy(const unsigned char x, const unsigned char y)
/****************************/
{
	union REGS regs;

	assert(x > 0);
	assert(y > 0);

	regs.h.ah = 2;                /* set cursor position */
	regs.h.dh = y - 1;
	regs.h.dl = x - 1;
	regs.h.bh = 0;                /* video page 0 */
	int86(0x10, &regs, &regs);
}

/****************************/
void clrscr(void)
/****************************/
{
	union REGS r;

	/* Now roll the screen */
	r.x.ax = 0x0600;	/* Scroll window up // entire window */
	r.x.bx = 0x0700;	/* Attribute to write */
	r.x.cx = 0x0000;	/* Upper left */
	r.x.dx = ((SCREEN_ROWS - 1) << 8) | (SCREEN_COLS - 1); /* Lower right */
	int86(0x10, &r, &r);
	gotoxy(1, 1);			/* home the cursor */
}

#endif

#endif

/****************************/
int getcharacter(int mode)
/****************************/
{
	int tmp;
	tmp = mode ? getch() : getche();
	if(tmp == 0x1b)
	{
		printf("\n%s\n", kittengets(1,19,"Bye!"));
		exit(0);
	}
	put_console('\n');
	return tmp-48;
}

/****************************/
void pause(void)
/****************************/
{
	fprintf(stderr, "%s",kittengets(2,18,"Press enter to continue..."));
	getcharacter(1);
}
