;-----------------------------------------------------------------------------
; name		: TEDEFS.ASM
; object	: Tiny Editor - global definitions
; type		: include file
; version	: 1.7
; date		: Feb 20, 2000
; author	: J R Ferguson
;-----------------------------------------------------------------------------

false		equ	0
true		equ	not false

CGASNOW		equ	false		;include CGA snow check

bs		equ	08h
tab		equ	09h
ff		equ	0Ch
cr		equ	0Dh
lf		equ	0Ah
crlf		equ	0A0Dh
eofchr		equ	1Ah
escape		equ	1Bh
rubout		equ	7Fh		;ctr-BS
ctrl		equ	40h		;control-char shift value
cmchg		equ	'#'		;mark char text changed
cmcrlf		equ	'<'		;mark char CR-LF pair
cmcr		equ	'-'		;mark char single CR
cmlf		equ	'L'		;mark char single LF
cmff		equ	'P'		;mark char FF
cmmore		equ	'+'		;mark char "more"
cmeof		equ	'.'		;mark char "end-of-file"

stksiz		equ	1024		;stack size
maxtxtptr	equ	0FFFEh		;max text pointer value
nil		equ	0FFFFh		;"undefined" text pointer value
maxlindel	equ	256		;line undel buffer size
maxchrdel	equ	256		;char undel buffer size
maxfsp		equ	53		;max length filespec
maxfind		equ	40		;max length find/replace string
maxfopt		equ	10		;max length find/replace option string
maxlnr		equ	4		;max length line number string
maxmar		equ	3		;max length margin string
maxinp		equ	53		;highest of maxfsp..maxmar

fatrarch	equ	00100000b	;archive file attribute

;main status masks
drwrow		equ	01h		;redraw current row
drwdwn		equ	02h		;redraw current row and below
drwwin		equ	04h		;redraw complete window
drwinf		equ	08h		;redraw info line
drwsta		equ	10h		;redraw status line
updcol		equ	20h		;adjust cursor column
updrow		equ	40h		;adjust cursor row
updptr		equ	80h		;adjust pointer from sol

;find/replace option masks
foptgen		equ	01h		;General
foptupp		equ	02h		;Upcase
foptnoq		equ	04h		;No questions
;foptbck	equ	08h		;Backward
;foptwrd	equ	10h		;Words only

;disk I/O return codes
errok		equ	0		;success
errfnf		equ	1		;file not found
errmem		equ	2		;out of memory
errread		equ	3		;disk read error
errwrite	equ	4		;disk write error

;monochrome video attributes
attrnormmono	equ	07h		;normal
attrhighmono	equ	0Fh		;highlighted
attrinvmono	equ	70h		;invers

;cga/ega video attributes
attrnormcolor	equ	17h		;normal
attrhighcolor	equ	1Fh		;highlighted
attrinvcolor	equ	71h		;invers

;other video adapter related constants
vidstamono	equ	03BAh		;monochrome adapter status port
vidsegmono	equ	0B000h		;monochrome video buffer seg
vidsegcolor	equ	0B800h		;cga/ega video buffer seg
skipsnow	equ	03EBh		;"jmp short $+3" to skip snow check

;--- END TEDEFS.ASM ----------------------------------------------------------
