/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis and Jason Hood
 * Date:             August 9, 1998
 *
 * This file contains the pull-down menu and strings for the keys.
 */

#include "tdestr.h"
#include "define.h"

/*
 * simple pull-down menu stuff
 *
 * pull.c auto calculates the number of selections under each menu choice.
 *  end the selections with a NULL string and ERROR in the function list.
 *  pull.c also calculates the width of the pull menu.
 *
 * jmh - added some extra functions and spacing
 * jmh 980524: removed the borders, added the #defines.
 * jmh 980809: use sizeof to calculate the number of selections,
 *              removing the need for the last NULL.
 */

#define Separator     { "", ERROR },
#define Begin( name ) MINOR_STR name[] = { Separator
#define End           Separator };

#if defined( __UNIX__ )
#define SeparatorTitle( title ) { "-"title, ERROR },
#else
#define SeparatorTitle( title ) { ""title, ERROR },
#endif


Begin( file_opts )
   { "Dir",             DirList           },
   { "Load",            EditFile          },
   { "Load Next",       EditNextFile      },
   { "Save",            Save              },
   { "Save as",         SaveAs            },
   { "File attr",       SetFileAttributes },
   Separator
   { "Insert File",     InsertFile        },
   { "Write Block",     BlockToFile       },
   { "Print",           PrintBlock        },
   Separator
   { "File Find",       DefineGrep        },
   { "File Grep",       DefineRegXGrep    },
   { "Next File",       RepeatGrep        },
   Separator
   { "Select Language", SyntaxSelect      },
   { "Read Config",     ReadConfig        },
   Separator
   { "Exit",            QuitAll           },
   { "Save and Exit",   FileAll           },
End


Begin( search_opts )
   { "Find forward",  FindForward            },
   { "Find backward", FindBackward           },
   { "Repeat >",      RepeatFindForward      },
   { "Repeat <",      RepeatFindBackward     },
   Separator
   { "Find Regx",     FindRegX               },
   { "Next Regx",     RepeatFindRegX         },
   { "Prev Regx",     RepeatFindRegXBackward },
   Separator
   { "Replace",       ReplaceString          },
   Separator
   { "Toggle Case",   ToggleSearchCase       },
   Separator
   { "Begin Diff",    DefineDiff             },
   { "Next Diff",     RepeatDiff             },
   Separator
   { "Next Dirty L",  NextDirtyLine          },
   { "Prev Dirty L",  PrevDirtyLine          },
   Separator
   { "Top of File",   TopOfFile              },
   { "End of File",   EndOfFile              },
   { "Goto Line",     JumpToLine             },
End


Begin( block_opts )
   { "Copy",         CopyBlock         },
   { "Kopy",         KopyBlock         },
   { "Delete",       DeleteBlock       },
   { "Move",         MoveBlock         },
   { "Swap",         SwapBlock         },
   { "Upper Case",   BlockUpperCase    },
   { "Lower Case",   BlockLowerCase    },
   { "Strip hi bit", BlockStripHiBit   },
   { "Rot13",        BlockRot13        },
   { "Fix UUE prob", BlockFixUUE       },
   SeparatorTitle( "Line only" )
   { "Expand Tabs",  BlockExpandTabs   },
   { "Compress Tab", BlockCompressTabs },
   { "Indent Tabs",  BlockIndentTabs   },
   { "Trim Trail",   BlockTrimTrailing },
   { "E-mail '>'",   BlockEmailReply   },
   SeparatorTitle( "Box only" )
   { "Fill",         FillBlock         },
   { "Number",       NumberBlock       },
   { "Overlay",      OverlayBlock      },
   { "Sort",         SortBoxBlock      },
   { "Border",       BorderBlock       },
End


Begin( toggle_opts )
   { "Insert",             ToggleOverWrite    },
   { "Indent",             ToggleIndent       },
   { "Word wrap",          ToggleWordWrap     },
   { "crlf/lf/bin",        ToggleCRLF         },
   { "Trim trail",         ToggleTrailing     },
   { "Control Z",          ToggleZ            },
   { "EOL display",        ToggleEol          },
   { "Cursor sync",        ToggleSync         },
   { "Ruler",              ToggleRuler        },
   { "Syntax highlight",   ToggleSyntax       },
   { "Cursor cross",       ToggleCursorCross  },
#if !defined( __UNIX__ )
   { "Graphic characters", ToggleGraphicChars },
#endif
   { "Cursor direction",   ChangeCurDir       },
   Separator
   { "Set tabs",           SetTabs            },
   { "Smart tabs",         ToggleSmartTabs    },
   { "Inflate tabs",       ToggleTabInflate   },
   Separator
   { "Break point",        SetBreakPoint      },
End


Begin( other_opts )
   { "Date Stamp",   DateTimeStamp  },
   { "Stamp Format", StampFormat    },
   SeparatorTitle( "Line" )
   { "Add",          AddLine        },
   { "Split",        SplitLine      },
   { "Join",         JoinLine       },
   { "Duplicate",    DuplicateLine  },
   { "Delete",       DeleteLine     },
   { "Delete end",   DelEndOfLine   },
   { "Undelete",     UndoDelete     },
   { "Undo",         UndoLine       },
   SeparatorTitle( "Macro" )
   { "Record/Stop",  RecordMacro    },
   { "Pseudo-macro", PseudoMacro    },
   { "Repeat",       Repeat         },
   { "Load",         LoadMacro      },
   { "Save",         SaveMacro      },
   { "Clear",        ClearAllMacros },
   Separator
#if !defined( __UNIX__ )
   { "Shell to DOS", DosShell       },
   { "DOS Screen",   DosScreen      },
#else
   { "Shell",        DosShell       },
#endif
End


Begin( word_opts )
   { "Format Paragraph", FormatParagraph    },
   { "Format forward",   FormatText         },
   SeparatorTitle("Margin")
   { "Left",             SetLeftMargin      },
   { "Right",            SetRightMargin     },
   { "Paragraph",        SetParagraphMargin },
   SeparatorTitle("Justify")
   { "Left",             LeftJustify        },
   { "Right",            RightJustify       },
   { "Center",           CenterJustify      },
   SeparatorTitle("Block Justify")
   { "Left",             BlockLeftJustify   },
   { "Right",            BlockRightJustify  },
   { "Center",           BlockCenterJustify },
   Separator
   { "Indent spaces",    BlockIndentN       },
   { "Undent spaces",    BlockUndentN       },
   { "Indent",           BlockIndent        },
   { "Undent",           BlockUndent        },
End


Begin( window_opts )
   { "Top line",         TopOfScreen      },
   { "Center line",      CenterWindow     },
   { "Bottom line",      BotOfScreen      },
   Separator
   { "Split horizontal", SplitHorizontal  },
   { "Split vertical",   SplitVertical    },
   { "Size",             SizeWindow       },
   { "Zoom",             ZoomWindow       },
   { "Redraw Screen",    RedrawScreen     },
   Separator
   { "Next",             NextWindow       },
   { "Previous",         PreviousWindow   },
   { "Next Hidden",      NextHiddenWindow },
   { "Prev Hidden",      PrevHiddenWindow },
   Separator
   { "Close",            Quit             },
   { "Close & Save",     File             },
End


/*
 * here's the main headings in the pull-down menu.  in TDESTR.H the number
 *  of headings is defined as MAJOR or 7.
 */

#define Menu( name, menu ) \
  { name, menu, sizeof(menu) / sizeof(*menu), 0, 0, 0, 0 },

MENU_STR menu = {
   Menu( "File",      file_opts )
   Menu( "Search",  search_opts )
   Menu( "Block",    block_opts )
   Menu( "Toggles", toggle_opts )
   Menu( "Other",    other_opts )
   Menu( "Word",      word_opts )
   Menu( "Window",  window_opts )
};


char *key_word[MAX_KEYS] = {
/* 256 */
/* jmh 980819: Utilise this space for Space (required for two-keys).  */
  "Space",                      /* DO NOT assign this to any function */
  "Alt+Esc",
  "Esc",
  "Shift+Esc",
/* 260 */
  "Ctrl+Esc",
  "",                           /* no key assigned here */
  "Enter",
  "Shift+Enter",
  "Ctrl+Enter",
  "Backspace",
  "Shift+Backspace",
  "Ctrl+Backspace",
  "Tab",
  ""  ,                         /* Control-Break */
/* 270 */
  "Alt+Backspace",
  "Shift+Tab",
  "Alt+Q",
  "Alt+W",
  "Alt+E",
  "Alt+R",
  "Alt+T",
  "Alt+Y",
  "Alt+U",
  "Alt+I",
/* 280 */
  "Alt+O",
  "Alt+P",
  "Alt+[",
  "Alt+]",
  "Alt+Enter",
  "GreyEnter",
  "Alt+A",
  "Alt+S",
  "Alt+D",
  "Alt+F",
/* 290 */
  "Alt+G",
  "Alt+H",
  "Alt+J",
  "Alt+K",
  "Alt+L",
  "Alt+;",
  "Alt+'",
  "Alt+`",
  "Shift+GreyEnter",
  "Ctrl+GreyEnter",
/* 300 */
  "Alt+Z",
  "Alt+X",
  "Alt+C",
  "Alt+V",
  "Alt+B",
  "Alt+N",
  "Alt+M",
  "Alt+<",
  "Alt+>",
  "Alt+?",
/* 310 */
  "Shift+Up",                   /* added by jmh 980807  */
  "Shift+Down",                 /* added by jmh 980807  */
  "Shift+Left",                 /* added by jmh 980807  */
  "Shift+Right",                /* added by jmh 980807  */
  "",                           /* no key assigned here */
  "F1",
  "F2",
  "F3",
  "F4",
  "F5",
/* 320 */
  "F6",
  "F7",
  "F8",
  "F9",
  "F10",
  "",                           /* no key assigned here */
  "",                           /* no key assigned here */
  "Home",
  "Up",
  "PgUp",
/* 330 */
  "",                           /* no key assigned here */
  "Left",
  "Center",
  "Right",
  "",                           /* no key assigned here */
  "End",
  "Down",
  "PgDn",
  "Insert",
  "Delete",
/* 340 */
  "Shift+F1",
  "Shift+F2",
  "Shift+F3",
  "Shift+F4",
  "Shift+F5",
  "Shift+F6",
  "Shift+F7",
  "Shift+F8",
  "Shift+F9",
  "Shift+F10",
/* 350 */
  "Ctrl+F1",
  "Ctrl+F2",
  "Ctrl+F3",
  "Ctrl+F4",
  "Ctrl+F5",
  "Ctrl+F6",
  "Ctrl+F7",
  "Ctrl+F8",
  "Ctrl+F9",
  "Ctrl+F10",
/* 360 */
  "Alt+F1",
  "Alt+F2",
  "Alt+F3",
  "Alt+F4",
  "Alt+F5",
  "Alt+F6",
  "Alt+F7",
  "Alt+F8",
  "Alt+F9",
  "Alt+F10",
/* 370 */
  "",                           /* no key assigned here */
  "Ctrl+Left",
  "Ctrl+Right",
  "Ctrl+End",
  "Ctrl+PgDn",
  "Ctrl+Home",
  "Alt+1",
  "Alt+2",
  "Alt+3",
  "Alt+4",
/* 380 */
  "Alt+5",
  "Alt+6",
  "Alt+7",
  "Alt+8",
  "Alt+9",
  "Alt+0",
  "Alt+-",
  "Alt+=",
  "Ctrl+PgUp",
  "F11",
/* 390 */
  "F12",
  "Shift+F11",
  "Shift+F12",
  "Ctrl+F11",
  "Ctrl+F12",
  "Alt+F11",
  "Alt+F12",
  "Ctrl+Up",
  "Ctrl+Grey-",
  "Ctrl+Center",
/* 400 */
  "Ctrl+Grey+",
  "Ctrl+Down",
  "Ctrl+Insert",
  "Ctrl+Delete",
  "Ctrl+Tab",
  "Ctrl+Grey/",
  "Ctrl+Grey*",
  "Alt+GreyHome",
  "Alt+GreyUp",
  "Alt+GreyPgUp",
/* 410 */
  "",                           /* no key assigned here */
  "Alt+GreyLeft",
  "",                           /* no key assigned here */
  "Alt+GreyRight",
  "",                           /* no key assigned here */
  "Alt+GreyEnd",
  "Alt+GreyDown",
  "Alt+GreyPgDn",
  "Alt+GreyInsert",
  "Alt+GreyDelete",
/* 420 */
  "Alt+Grey/",
  "Alt+Tab",
  "Alt+GreyEnter",
  "Shift+Grey-",
  "Shift+Grey+",
  "Enter",
  "Shift+Ctrl+Left",
  "Shift+Ctrl+Right",
  "Shift+Ctrl+Up",              /* added by jmh 980807 */
  "Shift+Ctrl+Down",            /* added by jmh 980807 */
/* 430 */
  "Ctrl+@",
  "Ctrl+A",
  "Ctrl+B",
  "Ctrl+C",
  "Ctrl+D",
  "Ctrl+E",
  "Ctrl+F",
  "Ctrl+G",
  "Ctrl+H",
  "Ctrl+I",
/* 440 */
  "Ctrl+J",
  "Ctrl+K",
  "Ctrl+L",
  "Ctrl+M",
  "Ctrl+N",
  "Ctrl+O",
  "Ctrl+P",
  "Ctrl+Q",
  "Ctrl+R",
  "Ctrl+S",
/* 450 */
  "Ctrl+T",
  "Ctrl+U",
  "Ctrl+V",
  "Ctrl+W",
  "Ctrl+X",
  "Ctrl+Y",
  "Ctrl+Z",
  "Ctrl+[",
  "Ctrl+\\",
  "Ctrl+]",
/* 460 */
  "Ctrl+^",
  "Ctrl+_",
  "Shift+Alt+1",
  "Shift+Alt+2",
  "Shift+Alt+3",
  "Shift+Alt+4",
  "Shift+Alt+5",
  "Shift+Alt+6",
  "Shift+Alt+7",
  "Shift+Alt+8",
/* 470 */
  "Shift+Alt+9",
  "Shift+Alt+0",
  "Shift+Alt+-",
  "Shift+Alt+=",
  "Shift+Alt+Q",
  "Shift+Alt+W",
  "Shift+Alt+E",
  "Shift+Alt+R",
  "Shift+Alt+T",
  "Shift+Alt+Y",
/* 480 */
  "Shift+Alt+U",
  "Shift+Alt+I",
  "Shift+Alt+O",
  "Shift+Alt+P",
  "Shift+Alt+[",
  "Shift+Alt+]",
  "Shift+Alt+Enter",
  "",                           /* no key assigned here */
  "Shift+Alt+A",
  "Shift+Alt+S",
/* 490 */
  "Shift+Alt+D",
  "Shift+Alt+F",
  "Shift+Alt+G",
  "Shift+Alt+H",
  "Shift+Alt+J",
  "Shift+Alt+K",
  "Shift+Alt+L",
  "Shift+Alt+;",
  "Shift+Alt+'",
  "Shift+Alt+`",
/* 500 */
  "",                           /* no key assigned here */
  "",                           /* no key assigned here */
  "Shift+Alt+Z",
  "Shift+Alt+X",
  "Shift+Alt+C",
  "Shift+Alt+V",
  "Shift+Alt+B",
  "Shift+Alt+N",
  "Shift+Alt+M",
  "Shift+Alt+<",
/* 510 */
  "Shift+Alt+>",
  "Shift+Alt+?",
};
