/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * This file contains all prototypes for every function in tde.  It should
 * be included in every source code module.
 *
 * I'm so stupid, I can't keep up with which functions are used in which
 * files.  Let's gather all prototypes into one file, so I don't have
 * to remember too much.
 */


/***********************  function prototypes in bj_ctype.c *************/
int  bj_tolower( int );
int  bj_toupper( int );
/************************************************************************/


/*************************  function prototypes in block.c *************/
int  mark_block( TDE_WIN * );
int  unmark_block( TDE_WIN * );
void restore_marked_block( TDE_WIN *, int );
int  prepare_block( TDE_WIN *, line_list_ptr, int );
int  pad_dest_line( TDE_WIN *, file_infos *, line_list_ptr );
int  move_copy_delete_overlay_block( TDE_WIN * );
void do_line_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,  file_infos *,
                    line_list_ptr,  line_list_ptr,  line_list_ptr,
                    line_list_ptr,  long,  long,  int * );
void do_stream_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,
                      file_infos *,  line_list_ptr,  line_list_ptr,
                      line_list_ptr,  line_list_ptr,
                      long,  long,  long,  int,  int,  int,  int * );
void do_box_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,  file_infos *,
                   line_list_ptr, line_list_ptr,  long,  long, long,
                   long,  long,  int,  int, int,
                   int,  int,  int,  int,  int * );
void load_box_buff( char *, line_list_ptr, int, int, char );
int  copy_buff_2file( TDE_WIN *, char *, line_list_ptr, int, int, int );
void block_fill( char *, int, int );
void number_block_buff( char *, int, long, int );
void restore_cursors( file_infos * );
int  delete_box_block( TDE_WIN *, line_list_ptr, int, int );
void check_block( void );
void find_begblock( file_infos * );
void find_endblock( file_infos * );
int  block_write( TDE_WIN * );
int  block_print( TDE_WIN * );
int  get_block_fill_char( TDE_WIN *, int * );
int  get_block_numbers( TDE_WIN *, long *, long *, int * );
int  block_trim_trailing( TDE_WIN * );
int  block_email_reply( TDE_WIN * );
int  block_convert_case( TDE_WIN * );
void upper_case( text_ptr, size_t );
void lower_case( text_ptr, size_t );
void rot13( text_ptr, size_t );
void fix_uue( text_ptr, size_t );
void strip_hi( text_ptr, size_t );
/************************************************************************/

/**********************  function prototypes in capslock.c  **************/
int  capslock_active( void );
int  nothing( TDE_WIN * );
/************************************************************************/

/**********************  function prototypes in config.c   ***************/
int  tdecfgfile( TDE_WIN * );
void remove_cr( char * );
void parse_line( char *, int );
char *parse_token( char *, char * );
int  search( char *, CONFIG_DEFS *, int );
void parse_macro( int , char *, int );
int  parse_literal( int, char *, char *, char ** );
void initialize_macro( int );
void clear_previous_macro( int );
void check_macro( int );
int  cfg_record_keys( int, int, int );
void new_sort_order( unsigned char *, unsigned char * );
int  get_stroke_count( void );
int  cfg_getfunc( int );
void clear_previous_twokey( int );
int  insert_twokey( int, int, int );
/************************************************************************/

/**********************  function prototypes in console.c  **************/
void video_config( struct vcfg *cfg );
int  getkey( void );
int  waitkey( int );
void flush_keyboard( void );
void xygoto( int, int );
void update_line( TDE_WIN * );
void c_output( int, int, int, int );
void s_output( char FAR *, int, int, int );
void eol_clear( int, int, int );
void window_eol_clear( TDE_WIN *, int );
void hlight_line( int, int, int, int );
void cls( void );
void set_cursor_size( int );
void set_overscan_color( int );
#if defined( __UNIX__ )
void save_screen_line( int, int, chtype * );      /* chtype is in curses.h */
void restore_screen_line( int, int, chtype * );   /* chtype is in curses.h */
void save_minor_area( chtype *, int, int, int, int );
void restore_minor_area( chtype *, int, int, int, int );
#else
void save_screen_line( int, int, char * );
void restore_screen_line( int, int, char * );
void save_minor_area( int *, int, int, int, int );
void restore_minor_area( int *, int, int, int, int );
#endif
int  getfunc( int );
int  two_key( TDE_WIN * );
int  getanswerkey( void );
/************************************************************************/


/*************************  function prototypes in diff.c  **************/
int  define_diff( TDE_WIN * );
int  repeat_diff( TDE_WIN * );
int  differ( int, int, int );
int  skip_leading_space( text_ptr, int );
line_list_ptr skip_eol( line_list_ptr, int *, int *, long *, long * );
void show_diff_window( TDE_WIN * );
int  verify_number( char *, int * );
int  verify_letter( char *, int *, TDE_WIN ** );
/************************************************************************/


/*************************  function prototypes in dirlist.c *************/
int  dir_help( TDE_WIN * );
int  dir_help_name( TDE_WIN *, char * );
void FAR *my_calloc( unsigned, unsigned );
int  validate_path( char *, char * );
int  list_and_pick( char *, char *, TDE_WIN * );
void setup_directory_window( DIRECTORY *, int );
void recalculate_dir( DIRECTORY *, FTYPE *, int );
void write_directory_list( FTYPE *, DIRECTORY );
int  select_file( FTYPE *, char *, DIRECTORY * );
void shell_sort( FTYPE *, int );
/************************************************************************/


/*************************  function prototypes in ed.c *****************/
int  insert_newline( TDE_WIN * );
int  insert_overwrite( TDE_WIN * );
int  join_line( TDE_WIN * );
int  dup_line( TDE_WIN * );
int  word_delete( TDE_WIN * );
int  back_space( TDE_WIN * );
int  line_kill( TDE_WIN * );
int  char_del_under( TDE_WIN * );
int  eol_kill( TDE_WIN * );
int  undo_line( TDE_WIN * );
int  undo( TDE_WIN * );
int  beg_next_line( TDE_WIN * );
int  next_line( TDE_WIN * );
int  home( TDE_WIN * );
int  goto_eol( TDE_WIN * );
int  goto_top( TDE_WIN * );
int  goto_bottom( TDE_WIN * );
int  set_tabstop( TDE_WIN * );
void show_line_col( TDE_WIN * );
void show_asterisk( TDE_WIN * );
int  toggle_overwrite( TDE_WIN * );
int  toggle_smart_tabs( TDE_WIN * );
int  toggle_indent( TDE_WIN * );
int  set_left_margin( TDE_WIN * );
int  set_right_margin( TDE_WIN * );
int  set_paragraph_margin( TDE_WIN * );
int  toggle_ww( TDE_WIN * );
int  toggle_crlf( TDE_WIN * );
int  toggle_trailing( TDE_WIN * );
int  toggle_z( TDE_WIN * );
int  toggle_eol( TDE_WIN * );
int  toggle_search_case( TDE_WIN * );
int  toggle_sync( TDE_WIN * );
int  toggle_ruler( TDE_WIN * );
int  toggle_tabinflate( TDE_WIN * );
void cursor_sync( TDE_WIN * );
void editor( void );
void display_dirty_windows( TDE_WIN * );
void show_dirty_window( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in file.c  **************/
int  write_file( char *, int, file_infos *, long, long, int );
int  hw_save( char *, file_infos *, long, long, int );
int  hw_append( char *, file_infos *, long, long, int );
int  load_file( char *, file_infos *, int *, int );
void insert_node( file_infos *, line_list_ptr, line_list_ptr );
int  show_file_2big( char *, int, line_list_ptr, text_ptr );
int  backup_file( TDE_WIN * );
int  edit_file( char *, int, int );
int  edit_another_file( TDE_WIN * );
int  attempt_edit_display( char *, int, int, int );
int  file_file( TDE_WIN * );
int  save_file( TDE_WIN * );
int  save_backup( TDE_WIN * );
int  save_as_file( TDE_WIN * );
#if defined( __UNIX__ )
void make_backup_fname( file_infos * );
int  write_to_disk( TDE_WIN *, char * );
int  search_and_seize( TDE_WIN * );
int  edit_next_file( TDE_WIN * );
int  hw_fattrib( char * );
int  change_mode( char *, int );
int  change_fattr( TDE_WIN * );
int  get_fattr( char *, mode_t * );
int  set_fattr( char *, mode_t );
int  get_current_directory( char *, size_t );
int  set_current_directory( char * );
#else
void make_backup_fname( file_infos * );
int  write_to_disk( TDE_WIN *, char * );
int  search_and_seize( TDE_WIN * );
int  edit_next_file( TDE_WIN * );
int  hw_fattrib( char * );
int  change_mode( char *, int );
int  change_fattr( TDE_WIN * );
int  get_fattr( char FAR *, int * );
int  set_fattr( char FAR *, int );
int  get_current_directory( char FAR *, int );
int  set_current_directory( char FAR * );
#endif
/************************************************************************/


/*************************  function prototypes in findrep.c ************/
int  get_replacement_flags( int );
int  ask_replace( TDE_WIN *, int * );
int  ask_wrap_replace( TDE_WIN *, int * );
void do_replace( TDE_WIN *, int );
int  find_string( TDE_WIN * );
void build_boyer_array( void );
void build_forward_skip( boyer_moore_type * );
void build_backward_skip( boyer_moore_type * );
int  calculate_forward_md2( char *, int );
int  calculate_backward_md2( char *, int );
line_list_ptr forward_boyer_moore_search( TDE_WIN *, long *, int * );
line_list_ptr search_forward( line_list_ptr, long *, unsigned * );
line_list_ptr backward_boyer_moore_search( TDE_WIN *, long *, int * );
line_list_ptr search_backward( line_list_ptr, long *, unsigned * );
void show_search_message( int, int );
void bin_offset_adjust( TDE_WIN *, long );
void find_adjust( TDE_WIN *, line_list_ptr, long, int );
int  replace_string( TDE_WIN * );
int  replace_and_display( TDE_WIN *, line_list_ptr, long, int, int *, int *, int );
line_list_ptr scan_forward( long *, int *, line_list_ptr, char, char, int * );
line_list_ptr scan_backward( long *, int *, line_list_ptr, char, char, int * );
int  match_pair( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in hwind.c **************/
void get_date( int *, int *, int *, int * );
void get_time( int *, int *, int *, int * );
void show_end_mem( void );
void show_end_text( TDE_WIN * );
void show_modes( void );
void show_file_count( int );
void show_window_count( int );
void show_avail_mem( void );
void show_tab_modes( void );
void show_indent_mode( void );
void show_search_case( void );
void show_sync_mode( void );
void show_wordwrap_mode( void );
void show_trailing( void );
void show_control_z( void );
void show_insert_mode( void );
void my_scroll_down( TDE_WIN * );
void combine_strings( char *, char *, char *, char * );
void make_ruler( TDE_WIN * );
void show_ruler( TDE_WIN * );
void show_ruler_char( TDE_WIN * );
void show_ruler_pointer( TDE_WIN * );
void show_all_rulers( void );
/************************************************************************/


/************************  function prototypes in macro.c  **************/
int  record_on_off( TDE_WIN * );
void record_keys( int );
void show_avail_strokes( void );
int  save_strokes( TDE_WIN * );
int  load_strokes( TDE_WIN * );
int  clear_macros( TDE_WIN * );
void connect_macros( void );
int  play_back( TDE_WIN * );
int  push_macro_stack( int );
int  pop_macro_stack( int * );
int  macro_pause( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in main.c  **************/
int  main( int, char *[] );
void error( int, int, char * );
#if defined( __UNIX__ )
  void harmless( void );
#else
 #if defined( __MSC__ )
  void interrupt FAR harmless( void );
  void interrupt FAR ctrl_break( void );
 #else
  static int harmless( void );
 #endif
#endif
void terminate( void );
int  initialize( void );
void hw_initialize( void );
int  get_help( TDE_WIN * );
void show_credits( void );
/************************************************************************/


/*************************  function prototypes in port.c *************/
#if defined( __UNIX__ )
 void *my_malloc( size_t, int * );
 void my_free( void * );
 long my_heapavail( void );
 void my_memcpy( void *, void *, size_t );
 void my_memmove( void *, void *, size_t );
 char *my_ltoa( int, char *, int );
 int  my_findfirst( DTA FAR *, char FAR *, int );
 int  my_findnext( DIR *, UNIX_DTA * );
#else
 void FAR *my_malloc( size_t, int * );
 void my_free( void FAR * );
 long my_heapavail( void );
 void my_memcpy( void FAR *dest, void FAR *src, size_t size );
 void my_memmove( void FAR *dest, void FAR *src, size_t size );
 char *my_ltoa( long, char *, int );
 int  my_findfirst( DTA FAR *, char FAR *, int );
 int  my_findnext( DTA FAR * );
#endif
/************************************************************************/

/*************************  function prototypes in pull.c *************/
int  main_pull_down( TDE_WIN * );
void draw_lite_alt( int, int [] );
int  lite_bar_menu( int *, int * );
int  pull_me( int, int, int, int, int * );
void get_bar_spacing( int, int *, int * );
void draw_lite_head( int, int [] );
void get_minor_counts( void );
/************************************************************************/


/*************************  function prototypes in regx.c *************/
int  find_regx( TDE_WIN * );
line_list_ptr forward_regx_search( TDE_WIN *, long *, int * );
line_list_ptr regx_search_forward( line_list_ptr, long *, int * );
line_list_ptr backward_regx_search( TDE_WIN *, long *, int * );
line_list_ptr regx_search_backward( line_list_ptr, long *, int * );
int  nfa_match( void );
int  build_nfa( void );
int  expression( void );
int  term( void );
int  factor( void );
int  escape_char( int );
void emit_cnode( int, int, int, int );
void emit_nnode( int, int, int, int, int );
int  put_dq( int );
int  push_dq( int );
int  pop_dq( void );
int  dequeempty( void );
void init_nfa( void );
void regx_error( char * );
int  separator( int );
int  Kleene_star( int );
int  letter( int );
/**********************************************************************/


/*************************  function prototypes in sort.c *************/
int  sort_box_block( TDE_WIN * );
void quick_sort_block( long, long, line_list_ptr, line_list_ptr );
void insertion_sort_block( long, long, line_list_ptr );
void load_pivot( line_list_ptr );
int  compare_pivot( line_list_ptr );
int  my_memcmp( text_ptr, text_ptr, int );
/************************************************************************/


/**********************  function prototypes in tab.c  ******************/
int  tab_key( TDE_WIN * );
int  backtab( TDE_WIN * );
int  next_smart_tab( TDE_WIN * );
int  prev_smart_tab( TDE_WIN * );
text_ptr entab( text_ptr, int );
void detab_linebuff( void );
void entab_linebuff( void );
text_ptr detab_a_line( text_ptr, int * );
int  detab_adjust_rcol( text_ptr, int );
int  entab_adjust_rcol( text_ptr, int, int );
int  block_expand_tabs( TDE_WIN * );
int  block_compress_tabs( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in utils.c **************/
int  myiswhitespc( int );
void check_virtual_col( TDE_WIN *, int, int );
void copy_line( line_list_ptr );
int  un_copy_line( line_list_ptr,  TDE_WIN * , int );
int  un_copy_tab_buffer( line_list_ptr, TDE_WIN * );
void load_undo_buffer( file_infos *, text_ptr, int );
void set_prompt( char *, int );
int  get_name( char *, int, char *, int );
int  get_sort_order( TDE_WIN * );
int  get_replace_direction( TDE_WIN * );
int  get_yn( void );
int  get_lr( void );
int  get_bc( void );
int  get_oa( void );
void show_eof( TDE_WIN * );
void display_current_window( TDE_WIN * );
int  redraw_screen( TDE_WIN * );
void redraw_current_window( TDE_WIN * );
void show_changed_line( TDE_WIN * );
void show_curl_line( TDE_WIN * );
void dup_window_info( TDE_WIN *, TDE_WIN * );
void adjust_windows_cursor( TDE_WIN *, long );
int  first_non_blank( text_ptr, int );
int  find_end( text_ptr, int );
int  is_line_blank( text_ptr, int );
int  page_up( TDE_WIN * );
int  page_down( TDE_WIN * );
int  scroll_down( TDE_WIN * );
int  scroll_up( TDE_WIN * );
int  pan_up( TDE_WIN * );
int  pan_down( TDE_WIN * );
void show_window_header( TDE_WIN * );
void show_window_number_letter( TDE_WIN * );
void show_window_fname( TDE_WIN * );
void show_crlf_mode( TDE_WIN * );
void show_size( TDE_WIN * );
int  quit( TDE_WIN * );
int  move_up( TDE_WIN * );
int  move_down( TDE_WIN * );
int  prepare_move_down( TDE_WIN * );
int  move_left( TDE_WIN * );
int  move_right( TDE_WIN * );
int  pan_left( TDE_WIN * );
int  pan_right( TDE_WIN * );
int  word_left( TDE_WIN * );
int  word_right( TDE_WIN * );
int  next_dirty_line( TDE_WIN * );
int  prev_dirty_line( TDE_WIN * );
int  center_window( TDE_WIN * );
int  horizontal_screen_right( TDE_WIN * );
int  horizontal_screen_left( TDE_WIN * );
int  goto_top_file( TDE_WIN * );
int  goto_end_file( TDE_WIN * );
int  goto_line( TDE_WIN * );
int  set_marker( TDE_WIN * );
int  goto_marker( TDE_WIN * );
int  date_time_stamp( TDE_WIN * );
int  add_chars( char *, TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in window.c *************/
int  initialize_window( void );
int  get_next_letter( int );
void choose_window( char *, TDE_WIN * );
int  next_window( TDE_WIN * );
int  prev_window( TDE_WIN * );
int  split_horizontal( TDE_WIN * );
int  split_vertical( TDE_WIN * );
void show_vertical_separator( TDE_WIN * );
int  size_window( TDE_WIN * );
int  zoom_window( TDE_WIN * );
int  next_hidden_window( TDE_WIN * );
void setup_window( TDE_WIN * );
void finish( TDE_WIN * );
int  create_window( TDE_WIN **, int, int, int, int, file_infos * );
/************************************************************************/


/**********************  function prototypes in wordwrap.c **************/
int  find_left_margin( line_list_ptr, int );
void word_wrap( TDE_WIN * );
int  format_paragraph( TDE_WIN * );
void combine_wrap_spill( TDE_WIN *, int, int, int, int, int );
void justify_right_margin( TDE_WIN *, line_list_ptr, int, int, int );
void remove_spaces( int );
int  find_word( text_ptr, int, int );
int  flush_left( TDE_WIN * );
int  flush_right( TDE_WIN * );
int  flush_center( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in tdeasm.c *************/
#if defined( __UNIX__ )
void *ptoul( void * );
#else
unsigned long  ptoul( void FAR * );
#endif
text_ptr tabout( text_ptr, int * );
/*****************************************************/


/***********  function prototype for simul101.asm *************/
void FAR simulate_enh_kbd( int );
/*****************************************************/


/***********  function prototype for criterr.asm *************/
void FAR install_ceh( void FAR * );
/*****************************************************/


/***********  function prototype for criterr.c   *************/
#if defined( __UNIX__ )
 void crit_err_handler( int );
 void show_error_screen( int, int );
 void save_area( chtype * );
 void restore_area( chtype * );
#else
 int  FAR crit_err_handler( void );
 void show_error_screen( int, int );
 void save_area( char FAR * );
 void restore_area( char FAR * );
#endif
/*****************************************************/
