/*
 * Most of this info is regurgitated stuff from IBM and Microsoft Technical
 * Reference manuals and the Microsoft Knowledge Base.  The error messages
 * are copyright by either Microsoft or IBM.
 *
 * See:
 *
 *   Microsoft Corporation, _Programmer's Reference Manual_, 1986,
 *    Redmond, Washingtion, Document No. 410630014-320-003-1285,
 *    pp. 1-20 thru 1-21, 1-37 thru 1-38, 1-216 thru 1-218.
 *
 *   IBM Corporation, _Disk Operating System: Technical Reference_, 1985,
 *    Boca Raton, Florida, pp. 6-14 thru 6-21, 6-38 thru 6-44.
 *
 *   Microsoft Knowledge Base, "Extended Error Code Information",
 *    Microsoft Corporation, Redmond, Wash., 1992, Document Number: Q74463,
 *    Publication Date:  March 24, 1993.
 *
 *
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             April 1, 1992
 *
 * This program is released into the public domain, Frank Davis.
 *   You may distribute it freely.
 */


#if defined( __UNIX__ )

/*
 **********************************************************************
 ******************************  PART 1  ******************************
 **********************************************************************
 *
 * Let's try to make unix have the look and feel of a PC.
 */

char *criterr_screen[] = {
"Ŀ",
"                          TDE signal handler                       ",
"                                                                   ",
"        Signal:                                                    ",
"         info1:                                                    ",
"         info2:                                                    ",
"         info3:                                                    ",
"   Error Class:                                                    ",
"         Locus:                                                    ",
"   Device Type:                                                    ",
"   Device Name:                                                    ",
"                                                                   ",
"            Please enter action:  (Q)uit or (R)etry?               ",
"               (ONLY AS A LAST RESORT -- (A)bort)                  ",
"",
NULL
};

char *sigabrt_1  = "SIGABRT";
char *sigabrt_2  = "abort( ) generates this signal";
char *sigabrt_3  = "possible error in TDE";


char *sigalrm_1  = "SIGALRM";
char *sigalrm_2  = "this signal is generated by a timer";


char *sigchld_1  = "SIGCHLD";
char *sigchld_2  = "child process died";
char *sigchld_3  = "continue with editor";
char *sigchld_4  = "job control signal";


char *sigcont_1  = "SIGCONT";
char *sigcont_2  = "continue a stopped process";
char *sigcont_3  = "redraw the screen and continue";
char *sigcont_4  = "job control signal";


char *sigfpe_1   = "SIGFPE";
char *sigfpe_2   = "arithmetic exception, divide by 0, domain error...";
char *sigfpe_3   = "No floats are used in TDE.  Error in Unix??";


char *sighup_1   = "SIGHUP";
char *sighup_2   = "controlling terminal was disconnected";
char *sighup_3   = "terminate TDE";


char *sigill_1   = "SIGILL";
char *sigill_2   = "illegal hardware instruction";
char *sigill_3   = "possible error in TDE";


char *sigint_1   = "SIGINT";
char *sigint_2   = "interrupt character";
char *sigint_3   = "halting editor functions in progress";


char *sigio_1    = "SIGIO";
char *sigio_2    = "terminal or network event";
char *sigio_3    = "TDE is not sure how to handle this signal";


char *sigiot_1   = "SIGIOT";
char *sigiot_2   = "input/output Trap";
char *sigiot_3   = "hardware error not the fault of TDE";


char *sigkill_1  = "SIGKILL";
char *sigkill_2  = "unknown process sent a kill signal to TDE";
char *sigkill_3  = "response is unknown ";


char *sigpipe_1  = "SIGPIPE";
char *sigpipe_2  = "Write to a pipe with no reader";
char *sigpipe_3  = "need to stop the write";


char *sigpoll_1  = "SIGPOLL";
char *sigpoll_2  = "poll event caught";


char *sigpwr_1   = "SIGPWR";
char *sigpwr_2   = "power failure, save work before battery runs down";
char *sigpwr_3   = "F2 saves, F3 Quits, and F4 saves and quits";


char *sigquit_1  = "SIGQUIT";
char *sigquit_2  = "terminal quit key pressed";
char *sigquit_3  = "F3 is the TDE quit key";


char *sigsegv_1  = "SIGSEGV";
char *sigsegv_2  = "segment violation:  invalid memory reference";
char *sigsegv_3  = "possible error in TDE - call Frank Davis";


char *sigstop_1  = "SIGSTOP";
char *sigstop_2  = "job control signal:  cannot be caught.";
char *sigstop_3  = "possible error in Unix if TDE caught this.";


char *sigterm_1  = "SIGTERM";
char *sigterm_2  = "some process wants to terminate TDE";
char *sigterm_3  = "F2 saves, F3 quits, and F4 quits and saves";


char *sigtrap_1  = "SIGTRAP";
char *sigtrap_2  = "hardware fault:  not fault of TDE";
char *sigtrap_3  = "TDE aborting";


char *sigtstp_1  = "SIGTSTP";
char *sigtstp_2  = "terminal stop character, job control signal";
char *sigtstp_3  = "F3 quits TDE";


char *sigttin_1  = "SIGTTIN";
char *sigttin_2  = "a background process is trying to read";
char *sigttin_3  = "F3 quits TDE";


char *sigttou_1  = "SIGTTOU";
char *sigttou_2  = "a background process is trying to write";
char *sigttou_3  = "F3 quits TDE";


char *sigurg_1   = "SIGURG";
char *sigurg_2   = "urgent condition";
char *sigurg_3   = "network error";


char *sigusr1_1  = "SIGUSR1";
char *sigusr1_2  = "user signal 1 received";
char *sigusr1_3  = "unknown origin or action";


char *sigusr2_1  = "SIGUSR2";
char *sigusr2_2  = "user signal 2 received";
char *sigusr2_3  = "unknown origin or action";


char *sigvtalrm_1 = "SIGVTALRM";
char *sigvtalrm_2 = "virtual timer alarm";


char *sigwinch_1 = "SIGWINCH";
char *sigwinch_2 = "window size change detected";
char *sigwinch_3 = "F3 quits TDE";


char *sigxcpu_1  = "SIGXCPU";
char *sigxcpu_2  = "process exceeded CPU time limit";
char *sigxcpu_3  = "F3 quits TDE, F4 saves work";


char *sigxfsz_1  = "SIGXFSZ";
char *sigxfsz_2  = "process exceeded file size limit";
char *sigxfsz_3  = "F3 quits TDE, F4 saves work";



#else

/*
 **********************************************************************
 ******************************  PART 2  ******************************
 **********************************************************************
 *
 * DOS critical error handler.
 */


char *criterr_screen[] = {
"Ŀ",
"                  tde critical error handler                       ",
"                                                                   ",
"    Error code:                                                    ",
"     Operation:                                                    ",
"         Drive:                                                    ",
" Extended Code:                                                    ",
"   Error Class:                                                    ",
"         Locus:                                                    ",
"   Device Type:                                                    ",
"   Device Name:                                                    ",
"                                                                   ",
"            Please enter action:  (Q)uit or (R)etry?               ",
"               (ONLY AS A LAST RESORT -- (A)bort)                  ",
"",
NULL
};

/*
 * codes from register di
 */
char *error_code[] = {
   "Attempt to write on write-protected disk",    /* 0 */
   "Unknown unit",
   "Drive not ready",
   "Unknown command",
   "Data error (CRC)",
   "Bad drive request structure length",          /* 5 */
   "Seek error",
   "Unknown media type",
   "Sector not found",
   "Printer out of paper",
   "Write fault",                                 /* 10 */
   "Read fault",
   "General failure"
};


/*
 * from bit 0 of ah
 */
char *operation[] = {
   "Read",
   "Write"
};


/*
 * extended error, error class, register bh.
 */
char *error_class[] = {
   "Unknown",
   "Out of Resource:  space, channels, etc...",         /* 1 */
   "Temporary Situation:  expected to end",
   "Authorization: permission problem",
   "Internal: error in system software",
   "Hardware Failure:  not the fault of tde",           /* 5 */
   "System Failure:  system software",
   "Application Program Error",
   "Not Found:  file/item not found",
   "Bad Format:  invalid format, type",
   "Locked:  file/item locked",                         /* 10 */
   "Media:  wrong disk, bad spot, etc...",
   "Already Exists:  collision with existing",
   "Unknown"
};


/*
 * extended error, locus, register ch
 */
char *locus[] = {
   "Unknown",
   "Unknown",
   "Block Device (disk or disk emulator)",
   "Network",
   "Serial Device:  keyboard, printer, plotter, modem",
   "Memory:  random access memory"
};


/*
 * bit 7 of ah and device header when needed.
 */
char *device_type[] = {
   "Block",
   "Character"
};


/*
 * In int24.asm, check for errors greater than 88.  Set any extended error
 *   code above 88 to 0.
 */
char *ext_err[] = {
   "Frank has no idea what this error is",              /* 0 */
   "Function number invalid",
   "File not found",
   "Path not found",
   "Too many open files (no handles left)",
   "Access denied",
   "Handle invalid",
   "Memory control blocks destroyed",
   "Insufficient memory",
   "Memory block address invalid",
   "Environment invalid",                               /* 10 */
   "Format invalid",
   "Access code invalid",
   "Data invalid",
   "Unknown unit",
   "Invalid drive was specified",
   "Attempt to remove current directory",
   "Not same device",
   "No more files",
   "Attempt to write on write-protected disk",
   "Unknown unit",                                      /* 20 */
   "Drive not ready",
   "Unknown command",
   "Data error (CRC)",
   "Bad request structure length",
   "Seek error",
   "Unknown media type",
   "Sector not found",
   "Printer out of paper",
   "Write fault",
   "Read fault",                                        /* 30 */
   "General failure",
   "Sharing violation",
   "File-lock voilation",
   "Invalid disk change",
   "FCB unavailable",
   "Sharing buffer overflow",
   "37",
   "38",
   "39",
   "40",
   "41",
   "42",
   "43",
   "44",
   "45",
   "46",
   "47",
   "48",
   "49",
   "Unsupported network request",
   "Remote machine not listening",
   "Duplicate name on network",
   "Network name not found",
   "Network busy",
   "Device no longer exists on network",
   "NetBIOS command limit exceeded",
   "Network adapter hardware failure",
   "Incorrect response from network",
   "Unexpected network error",
   "Incompatible remote adapter",                       /* 60 */
   "Print queue full",
   "Not enough room for print file",
   "Print file was deleted",
   "Network name deleted",
   "Network access denied",
   "Incorrect network device type",
   "Network name not found",
   "Network name limit exceeded",
   "Net BIOS session limit exceeded",
   "Temporarily paused",                                /* 70 */
   "Network request not accepted",
   "Print or disk redirection is paused",
   "73",
   "74",
   "75",
   "76",
   "77",
   "78",
   "79",
   "File already exists",                               /* 80 */
   "Reserved",
   "Cannot make directory entry",
   "Fail on INT 24",
   "Too many redirections",
   "Duplicate redirection",
   "Invalid password",
   "Invalid parameter",
   "Network device fault"                               /* 88 */
};
#endif
