/*
 * Copyright (C) 1992 by Rush Record
 * Copyright (C) 1993-2009 by Charles Sandmann
 *
 * This file is part of ED.
 *
 * ED is free software; you can redistribute it and/or modify it under the terms
 * of the GNU General Public License as published by the Free Software Foundation.
 *
 * ED is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 */
#include "opsys.h"

#ifndef show_select
#include <string.h>
#include "ctyp_dec.h"
#include "rec.h"
#include "window.h"
#include "ed_dec.h"
#include "handy.h"

static Int top = 0,bot = 0;

/******************************************************************************\
|Routine: unshow_select
|Callby: unselect, show_select
|Purpose: Erases reversed-out select range, if any.
|Arguments:
|    none
\******************************************************************************/
void unshow_select()
{
	if(top)
	{
		normal();
		paint(top,bot,FIRSTCOL);
		top = 0;
	}
}

/******************************************************************************\
|Routine: show_select
|Callby: edit
|Purpose: Displays the select range in reverse video.
|Arguments:
|    none
\******************************************************************************/
void show_select()
{
	rec_ptr r;
	Char *buf,c;
	Int toprow,botrow,dir,i,j,k;

	if(!(dir = get_seldir()))
		return;
	if(WINDOW[CURWINDOW].news & 3 || WINDOW[CURWINDOW].diredit)
		return;
	if(WINDOW[CURWINDOW].binary && BOXCUT)
	{
		unshow_select();
		return;
	}
	if(BOXCUT)
	{
		i = get_column(SELREC,SELBYT);
		j = get_column(CURREC,CURBYT);
		if(i > j)
		{
			k = i;
			i = j;
			j = k;
		}
		if(dir < 0)	/* cursor after select */
		{
			for(toprow = botrow = CURROW,r = CURREC; ;r = r->prev,toprow--)
			{
				if(express(r->length,r->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
				{
					normal();
					move(toprow,1);
					putz(buf);
					reverse();
					k = strlen(buf) + 1;
					buf[min(j,k)] = '\0';
					k = min(i,k);
					move(toprow,k);
					putz(buf + k - 1);
				}
				if(r == SELREC || r == TOPREC)
					break;
			}
		}
		else	/* dir > 0, cursor before select */
		{
			for(toprow = botrow = CURROW,r = CURREC;r != BASE;r = r->next,botrow++)
			{
				if(express(r->length,r->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
				{
					normal();
					move(botrow,1);
					putz(buf);
					reverse();
					k = strlen(buf) + 1;
					buf[min(j,k)] = '\0';
					k = min(i,k);
					move(botrow,k);
					putz(buf + k - 1);
				}
				if(r == SELREC || r == BOTREC)
					break;
			}
		}
	}
	else /* Not BOXCUT */
	{
		reverse();
		if(dir < 0)	/* cursor after select */
		{
			if(CURREC == SELREC)
			{
				if(express(CURREC->length,CURREC->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
				{
					normal();
					move(CURROW,1);
					putz(buf);
					reverse();
					buf[get_column(CURREC,CURBYT)-1] = '\0';
					i = get_column(CURREC,SELBYT);
					move(CURROW,i);
					putz(buf + i - 1);
					toprow = botrow = CURROW;
				}
			}
			else
			{
				for(toprow = botrow = CURROW,r = CURREC;r != TOPREC;r = r->prev,toprow--)
					if(r == SELREC)
						break;
				if(r == SELREC)
				{
					if(express(r->length,r->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
					{
						normal();
						move(toprow,1);
						putz(buf);
						reverse();
						i = get_column(SELREC,SELBYT);
						move(toprow,i);
						putz(buf + i - 1);
					}
				}
				else
					paint(toprow, toprow, FIRSTCOL);
				if(toprow + 1 < botrow)
					paint(toprow + 1,botrow - 1,FIRSTCOL);
				if(botrow < BOTROW)
					if(express(CURREC->length,CURREC->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
					{
						normal();
						move(botrow,1);
						putz(buf);
						reverse();
						i = get_column(CURREC,CURBYT);
						buf[i-1] = '\0';
						move(botrow,1);
						putz(buf);
					}
			}
		}
		else	/* dir > 0 , cursor before select */
		{
			if(CURREC == SELREC)
			{
				if(express(CURREC->length,CURREC->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
				{
					normal();
					move(CURROW,1);
					putz(buf);
					reverse();
					buf[get_column(CURREC,SELBYT)] = '\0';
					i = get_column(CURREC,CURBYT);
					move(CURROW,i);
					putz(buf + i - 1);
					toprow = botrow = CURROW;
				}
			}
			else
			{
				if(express(CURREC->length,CURREC->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
				{
					normal();
					move(CURROW,1);
					putz(buf);
					reverse();
					i = get_column(CURREC,CURBYT);
					move(CURROW,i);
					putz(buf + i - 1);
				}
				for(toprow = botrow = CURROW,r = CURREC;r != BASE && r != BOTREC;r = r->next,botrow++)
					if(r == SELREC)
						break;
				if(toprow + 1 < botrow)
					paint(toprow + 1,botrow - 1,FIRSTCOL);
				if(r == SELREC)
				{
					if(express(r->length,r->data,TAB_STRING[CUR_TAB_SETUP],TAB_LENGTH[CUR_TAB_SETUP],&buf,FIRSTCOL + NCOL,0))
					{
						normal();
						move(botrow,1);
						putz(buf);
						reverse();
						i = get_column(SELREC,SELBYT);
						buf[i] = '\0';
						move(botrow,1);
						putz(buf);
					}
				}
				else
					paint(botrow, botrow, FIRSTCOL);
			}
		}
	}
	top = toprow;
	bot = botrow;
	normal();
	if(TOPROW < top)
		paint(TOPROW, top-1, FIRSTCOL);
	if(BOTROW > bot)
		paint(bot+1, BOTROW, FIRSTCOL);
}

#endif
