/* Included by: all routines */
#include "config.h"
#ifdef GNUOS2
#define GNUDOS
#endif

#ifdef NeXT
#define NO_SBRK
#define CUSERID_ENV "USER"
#endif

#ifdef __bsdi__
#define CUSERID_ENV "USER"
#endif

#ifdef _CRAY
#define NO_MMAP
#define REGEX_MALLOC
#endif

#ifdef __osf__
#define NO_SBRK
#endif

typedef int Int;
typedef long Long;
#ifdef NO_SIGNED_CHAR
typedef char Schar;
#else
typedef signed char Schar;
#endif
typedef char Char;
typedef unsigned char Uchar;

extern void *imalloc();

#ifdef VMS
#define HAVE_SYSERRLIST
#endif

#ifdef linux
#define USE_NCS
#define HAVE_SYSERRLIST
#define my_fscanf fscanf
#define my_sscanf sscanf
#endif

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__APPLE_CC__)
#define USE_NCS
#define HAVE_SYSERRLIST
#define CUSERID_ENV "USER"
#define my_fscanf fscanf
#define my_sscanf sscanf
#endif

/* GCC 3.2.1+ dislikes varargs, assume scanf OK if recent enough for gcc 3 */
#if __GNUC__ > 2
#define my_fscanf fscanf
#define my_sscanf sscanf
#endif

#ifdef NO_HIGHLIGHT
#define show_select()
#define unshow_select()
#endif

#ifdef USE_NCS
#define NONPRINTNCS(c) (c & 0x7f) < 32 || (c & 0x7f) > 126
#else
#define NONPRINTNCS(c) c < 32 || c > 126
#endif
