{**********************************************************************
Copyright (C) 2011 by Salvatore Licciardi

Web http://turylicciardi.altervista.org    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit T_Edit30;    // contiene la gestione dei formati Html e Rtf
{$GOTO on}        // e tutto cio' che vi e' legato,
{$MACRO on}       // principalmente a partire dalla versione 3.0.0
{$MODE objfpc}
{$H+}  // longstring
{$I txt_mode.inc}

interface

 uses Crt,Sysutils,Math,Video,Keyboard,Dos,
      {$ifdef Go32v2}
       MsMouse,
       {$else}
       Mouse,
      {$endif}
      Altro32,Altro32D,Type_var,
      T_edit1x,T_Edit20,T_Edit24,
      {$ifdef TxtCrt}
       Menu_X,Menu_Y;
      {$endif}
      {$ifdef TxtVideo}
       Menu_X_V,Menu_Y_V,TxtVideo;
      {$endif}

// gestione dei formati Html e Rtf
procedure M_File__Converti__txt(const htm:boolean);  // ver 2.77
procedure M_File__Converti__Configura(const html:boolean);  // ver 2.77 , 2.81
{$ifndef Linux}
procedure M_Stampa__Foglio_Attuale;
procedure M_Stampa__Tutto;
procedure M_Stampa__Selezione;   {stampa il testo selezionato}
procedure M_Stampa__Fogli;       {stampa fogli da ... a}
procedure M_Stampa__Righe;       {stampa righe da ... a}
{$endif}

// menu speciale e formattato
procedure DoppioClick;
procedure Seleziona_paragrafo;
procedure Seleziona_parola;  //  ver 3.03
procedure Seleziona_Riga_Attuale; // ver 2.45
procedure m_speciale__seleziona(menu_selezione_speciale:byte);  // ver 3.03
procedure Menu_Formattato(c:byte);
procedure M_speciale__seleziona_Righe;
procedure m_speciale__copia(menu_selezione_speciale:byte);      // ver 3.03

procedure Redo__Menu_Formattato(riga:string);    // ver 3.15
procedure Redo__Formattato(c,riga:integer);      // ver 3.15
procedure Redo__TE_Righe;                        // ver 3.15
procedure Redo__TE_Esa2;                         // ver 3.15
procedure Redo__TE_Quadrato;                     // ver 3.15
procedure Redo__TE_Esa(selezione:boolean=false); // ver 3.15
procedure Redo__Invio;                           // ver 3.15
procedure Redo__Back_Space;                      // ver 3.15
procedure Redo__F1_F2(riga:string; ann:boolean); // ver 3.15
procedure Redo__Mouse_CL(const riga:string);     // ver 3.15
procedure Redo__UnoS(riga:string);               // ver 3.15
procedure Redo__Insert(riga:string);             // ver 3.15
procedure messaggio(num:integer);
procedure M_opzioni__Cambia_Lingua;              // ver 3.20

function  files_non_salvati():boolean;           // ver 3.13
function  vai_al_paragrafo(paragrafo:longint):longint; // ver 3.22
procedure get_pragrafo_attuale_e_max(var p_att,p_max:longint); // ver 3.22
procedure M_file__Cambia_numero_di_colonne;      // ver 3.26
procedure M_file__Ricarica;   // ver 2.54 , 2.69
procedure M_opzioni__Informazioni_legali;        // ver 3.28   GPL 3
procedure M_speciale__Svuota_Appunti;            // ver 3.30
procedure M_opzioni__Informazioni_sul_File;      // ver 2.20
procedure BackUp_automatico(cond:char; n:longint; the_binario:boolean; the_percorso,the_nomefile:string);   // ver 3.40
procedure M_File__Salva_Copia__Crea_BackUp_Ora;  // ver 3.40
procedure M_File__Salva_Copia__BackUp_di_tutti;  // ver 3.50
procedure M_File__Salva_Copia__BackUp_di_solo_TXT; // ver 3.50
procedure M_File__Salva_Copia__BackUp_di_solo_ESA; // ver 3.50

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_riga_per_xxx(riga:longint):shortstring;  // ver 2.81
var s:shortstring;
begin
s:=copy_end(testo[riga],2);  // escludo il primo carattere che e' invio
if not htm.selezione then exit(s);
if (riga>selezionato.y1)and(riga<selezionato.y2) then exit(s);
if (riga=selezionato.y1)and(riga=selezionato.y2) then exit(copy(s,selezionato.x1,selezionato.x2-selezionato.x1+1));
if (riga=selezionato.y1) then exit(copy_end(s,selezionato.x1));
if (riga=selezionato.y2) then exit(copy(s,1,selezionato.x2));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_riga_per_htm(riga:longint):shortstring;  // ver 2.96
var testo1,testo2:string;
    i:longint;
begin
testo1:=get_riga_per_xxx(riga);
testo2:='';
for i:=1 to length(testo1) do
    case testo1[i] of
          '<': testo2:=testo2+'&lt';
          '>': testo2:=testo2+'&gt';
          '"': testo2:=testo2+'&quot';
          '&': testo2:=testo2+'&amp';
          else  testo2:=testo2+testo1[i]
          end;
exit(testo2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_riga_per_rtf(riga:longint):shortstring;  // ver 2.96
var testo1,testo2:string;
    i:longint;
begin
testo1:=get_riga_per_xxx(riga);
testo2:='';
for i:=1 to length(testo1) do
    if testo1[i]<>'\' then testo2:=testo2+testo1[i]
                      else testo2:=testo2+'\\';
exit(testo2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function scrivi_htm(nomefilex:shortstring):boolean;  // ver 2.77
var filex:text;
    i,riga,riga_min,riga_max:longint;
    tag_testa,tag_coda,font_info,stringa:string;
    non_colore:boolean;
begin
tag_testa:='';
tag_coda:='';
font_info:='';
scrivi_htm:=false;
assign(filex,nomefilex);
{$i-}
rewrite(filex);
{$i+}
if IOResult<>0 then Exit;
{$i-}
write(filex,'<html>'+get_delimitatore());
{$i+}
if IOResult<>0 then Exit;

if htm.titolo then
   begin
   {$i-}
   write(filex,'<head>'+get_delimitatore()+'<title>'+nameof(nomefilex)+'</title>'+get_delimitatore+'</head>'+get_delimitatore()+get_delimitatore());
   {$i+}
   if IOResult<>0 then Exit;
   end;

non_colore:=false;   // colore sfondo
if htm.colore_sfondo='' then non_colore:=true
                        else
                         for i:=1 to length(htm.colore_sfondo) do
                             if not (htm.colore_sfondo[i] in ['0'..'9','a'..'f','A'..'F']) then
                                begin
                                non_colore:=true;
                                break;
                                end;
if not non_colore then
                   begin
                   {$i-}
                   write(filex,'<body bgcolor="#'+upcase(htm.colore_sfondo)+'">'+get_delimitatore());
                   {$i+}
                   if IOResult<>0 then Exit;
                   end
                  else
                   begin
                   {$i-}
                   write(filex,'<body>'+get_delimitatore());
                   {$i+}
                   if IOResult<>0 then Exit;
                   end;

if htm.h in [1..6] then
   begin
   {$i-}
   write(filex,'<h'+intToStr(htm.h)+'>'+get_delimitatore());  // dentro il body
   {$i+}
   if IOResult<>0 then Exit;
   end;

if htm.corsivo then
   begin
   {$i-}
   write(filex,'<i>'+get_delimitatore());  // dentro il body
   {$i+}
   if IOResult<>0 then Exit;
   end;
if htm.grassetto then
   begin
   {$i-}
   write(filex,'<b>'+get_delimitatore());  // dentro il body
   {$i+}
   if IOResult<>0 then Exit;
   end;
if htm.sottolineato then // ver 2.95          dentro il body
   begin
   {$i-}
   write(filex,'<u>'+get_delimitatore());  // dentro il body
   {$i+}
   if IOResult<>0 then Exit;
   end;

// dentro il font
if htm.colore_testo<>'' then font_info:=font_info+'color="#'+upcase(htm.colore_testo)+'"';
if htm.size>0 then font_info:=font_info+' size="'+IntToStr(htm.size)+'"';
if htm.font<>'' then font_info:=font_info+' face="'+htm.font+'"';

if htm.selezione then
                 begin
                 riga_min:=selezionato.y1;
                 riga_max:=selezionato.y2;
                 end
                else
                 begin
                 riga_min:=1;
                 riga_max:=ymax;
                 end;
if htm.selezione and T_Edit20.non_selezione() then else  // ver 2.92
for riga:=riga_min to riga_max do
    begin
    stringa:=get_riga_per_htm(riga);
    if htm.allinea=0 then
                     if htm.fine_riga_br then tag_coda:='<br>'  // <br>
                                         else
                                          begin
                                          tag_testa:='<p>';
                                          tag_coda:='</p>';
                                          end
                     else
                      begin  // testo da allineare
                      tag_testa:='<p ';
                      case htm.allinea of
                           1: tag_testa:=tag_testa+'align="right">';
                           2: tag_testa:=tag_testa+'align="left">';
                           3: tag_testa:=tag_testa+'align="center">';
                           4: tag_testa:=tag_testa+'align="justify">';
                           end;
                      tag_coda:='</p>';
                      end;
    non_colore:=false;    // colore testo
    if htm.colore_testo='' then non_colore:=true
                           else
                            for i:=1 to length(htm.colore_testo) do
                                if not (htm.colore_testo[i] in ['0'..'9','a'..'f','A'..'F']) then
                                   begin
                                   non_colore:=true;
                                   break;
                                   end;
    {$i-}
    write(filex,tag_testa);
    {$i+}
    if IOResult<>0 then Exit;
    if font_info<>'' then
                      begin
                      {$i-}
                      write(filex,'<font '+font_info+'>'+stringa+'</font>');
                      {$i+}
                      if IOResult<>0 then Exit;
                      end
                     else
                      begin
                      {$i-}
                      write(filex,stringa);
                      {$i+}
                      if IOResult<>0 then Exit;
                      end;
    {$i-}
    write(filex,tag_coda+get_delimitatore());
    {$i+}
    if IOResult<>0 then Exit;
    end;

stringa:='';     // preparo la fine del Body
if htm.grassetto then stringa:=stringa+'</b>'+get_delimitatore();
if htm.corsivo then stringa:=stringa+'</i>'+get_delimitatore();
if htm.sottolineato then stringa:=stringa+'</u>'+get_delimitatore();
if htm.h in [1..6] then stringa:=stringa+'</h>'+get_delimitatore();
{$i-}
write(filex,stringa+'</body>'+get_delimitatore()+'</html>');
{$i+}
if IOResult<>0 then Exit;
{$i-}
close(filex);
{$i+}
if IOResult<>0 then Exit;
scrivi_htm:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function scrivi_rtf(nomefilex:shortstring):boolean;  // ver 2.96
var filex:text;
    nome_font,tmp,colore:string;
    riga,riga_min,riga_max:longint;
begin
scrivi_rtf:=false;
assign(filex,nomefilex);
{$i-}
rewrite(filex);
{$i+}
if IOResult<>0 then Exit;

{$i-} // parte di inizio
write(filex,'{\rtf1\ansi'+get_delimitatore());
{$i+}
if IOResult<>0 then Exit;

testa_coda(htm.font,',',nome_font,tmp);
if nome_font<>'' then
   begin
   {$i-}
   write(filex,get_delimitatore()+'{\fonttbl'+get_delimitatore()+' {\f0 '+nome_font+';}'+get_delimitatore()+'}'+get_delimitatore());
   {$i+}
   if IOResult<>0 then Exit;
   end;

if nome_font='' then tmp:=get_delimitatore()+'{'+get_delimitatore()
                else
                 if (htm.size_rtf>0) and (htm.size_rtf<=max_rtf_size) then tmp:=get_delimitatore()+'{\f0\fs'+inttostr(htm.size_rtf)+get_delimitatore()
                                                                      else tmp:=get_delimitatore()+'{\f0'+get_delimitatore();
if htm.colore_testo<>'' then
    begin
    colore:=htm.colore_testo;
    while length(colore)<6 do colore:='0'+colore;
    tmp:=tmp+'{\colortbl ;\red'+FromTo(colore[1]+colore[2],16,10)+'\green'+FromTo(colore[3]+colore[4],16,10)+'\blue'+FromTo(colore[5]+colore[6],16,10)+';}'+get_delimitatore()+'\viewkind4\pard\cf1';
    end;
if htm.sottolineato then tmp:=tmp+'\ul';
if htm.corsivo then tmp:=tmp+'\i';
if htm.grassetto then tmp:=tmp+'\b';
case htm.allinea of
     0: ;  // 0=ignora, 1=sinistra, 2=destra, 3=centro 4=giustificato
     1: tmp:=tmp+'\ql';
     2: tmp:=tmp+'\qr';
     3: tmp:=tmp+'\qc';
     4: tmp:=tmp+'\qj';  // non supportato da wordpad
     end;

{$i-}
write(filex,tmp+get_delimitatore());
{$i+}
if IOResult<>0 then Exit;

if htm.selezione then
                 begin
                 riga_min:=selezionato.y1;
                 riga_max:=selezionato.y2;
                 end
                else
                 begin
                 riga_min:=1;
                 riga_max:=ymax;
                 end;
if htm.selezione and T_Edit20.non_selezione() then else
for riga:=riga_min to riga_max do
    begin
    {$i-}
    write(filex,get_riga_per_rtf(riga)+'\par'+get_delimitatore());
    {$i+}
    if IOResult<>0 then Exit;
    end;

{$i-} // parte di fine testo e fine file
write(filex,'}'+get_delimitatore()+'}');
{$i+}
if IOResult<>0 then Exit;

{$i-}
close(filex);
{$i+}
if IOResult<>0 then Exit;
scrivi_rtf:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Converti__txt(const htm:boolean);  // ver 2.77
var nomefilex,old_the_files{le estensioni per sfoglia}:string;
    a:byte;
label inizio,scrittura;

begin
grafica; // add ver 2.92
inizio:
HideMouse;
colore;
gotoxy(1,riga_menu+1);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+2);
write('                                                              ');
nomefilex:=nomefile;
a:=posRL('.',nomefilex,255);
if a<>0 then nomefilex:=Copy(nomefilex,1,a);
if htm then nomefilex:=percorso+nomefilex+'.htm'
       else nomefilex:=percorso+nomefilex+'.rtf';
ShowMouse;
old_the_files:=the_files;
if htm then the_files:='*.htm*'
       else the_files:='*.rtf';
if htm then ingresso(nomefilex,Lingue.get_txt(324)+' Htm')
       else ingresso(nomefilex,Lingue.get_txt(324)+' Rtf'); // 'Converti in'
the_files:=old_the_files;
if nomefilex='' then Exit;
colore;
gotoxy(1,riga_menu+1);
clreol;
gotoxy(1,riga_menu+2);
clreol;
if Exist(nomefilex)<0 then
      begin
      scrittura:
      if htm then scrivi_htm(nomefilex)
             else scrivi_rtf(nomefilex);
      end
     else
      begin
      Sovrascrivere(nomefilex);
      case Tasti_SNA(31,riga_menu+4) of
           'S': goto scrittura;
           'A': ;
           'N': goto inizio; {riprova}
           end;
      end;
gotoxy(1,riga_menu+3);
colore;
clreol;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure indica_scelta_allinea(pos:integer); // ver 2.77
const base:byte=16;
begin
hidemouse;
htm.allinea:=pos;
case htm.allinea of
     0: begin
        gotoxy(4,base+1);
        write(' ');
        gotoxy(4,base+2);
        write(' ');
        gotoxy(4,base+3);
        write(' ');
        gotoxy(4,base+4);
        write(' ');
        gotoxy(4,base);
        write('*');
        gotoxy(4,base);
        end;
     1: begin
        gotoxy(4,base);
        write(' ');
        gotoxy(4,base+2);
        write(' ');
        gotoxy(4,base+3);
        write(' ');
        gotoxy(4,base+4);
        write(' ');
        gotoxy(4,base+1);
        write('*');
        gotoxy(4,base+1);
        end;
     2: begin
        gotoxy(4,base);
        write(' ');
        gotoxy(4,base+1);
        write(' ');
        gotoxy(4,base+3);
        write(' ');
        gotoxy(4,base+4);
        write(' ');
        gotoxy(4,base+2);
        write('*');
        gotoxy(4,base+2);
        end;
     3: begin
        gotoxy(4,base);
        write(' ');
        gotoxy(4,base+1);
        write(' ');
        gotoxy(4,base+2);
        write(' ');
        gotoxy(4,base+4);
        write(' ');
        gotoxy(4,base+3);
        write('*');
        gotoxy(4,base+3);
        end;
     4: begin
        gotoxy(4,base);
        write(' ');
        gotoxy(4,base+1);
        write(' ');
        gotoxy(4,base+2);
        write(' ');
        gotoxy(4,base+3);
        write(' ');
        gotoxy(4,base+4);
        write('*');
        gotoxy(4,base+4);
        end;
     end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Converti__Configura(const html:boolean);  // ver 2.77 , 2.81
{$define Stato_Cursore:=
          begin
          case stato_ of
             1: gotoxy(2,3);
             2: gotoxy(2,4);
             3: gotoxy(2,5);
             4: gotoxy(2,6);
             5: gotoxy(2,7);
             6: gotoxy(2,8);
             7: gotoxy(2,9);
             8: gotoxy(2,10);
             9: gotoxy(2,11);
            10: gotoxy(2,12);
            11: gotoxy(4,16);
            12: gotoxy(4,17);
            13: gotoxy(4,18);
            14: gotoxy(4,19);
            15: gotoxy(4,20);
            16: gotoxy(2,22);
            end;
          cursorON;
          end  }
{$define stato_OK:=
         begin
         gotoxy(34,25);
         write(' ');
         gotoxy(39,25);
         write('  ');
         gotoxy(46,25);
         write(' ');
         end; }
{$define assegna_stato:=
           begin
           if upcase(c[1])=lingue.get_charUp(486) then stato_:=1 else   // 'T'
           if upcase(c[1])=lingue.get_charUp(487) then stato_:=2 else   // 'R'
           if upcase(c[1])='I' then stato_:=3 else
           if upcase(c[1])='B' then stato_:=4 else
           if upcase(c[1])='U' then stato_:=5 else
           if upcase(c[1])=lingue.get_charUp(491) then stato_:=6 else   // 'M'
           if upcase(c[1])=lingue.get_charUp(493) then stato_:=7 else   // 'H'
           if upcase(c[1])=lingue.get_charUp(494) then stato_:=8 else   // 'E'
           if upcase(c[1])=lingue.get_charUp(496) then stato_:=9 else   // 'O'
           if upcase(c[1])=lingue.get_charUp(497) then stato_:=10 else  // 'F'
           if upcase(c[1])=lingue.get_charUp(500) then stato_:=11 else  // 'N'
           if upcase(c[1])=lingue.get_charUp(501) then stato_:=12 else  // 'D'
           if upcase(c[1])=lingue.get_charUp(502) then stato_:=13 else  // 'S'
           if upcase(c[1])=lingue.get_charUp(503) then stato_:=14 else  // 'C'
           if upcase(c[1])=lingue.get_charUp(504) then stato_:=15 else  // 'G'
           if upcase(c[1])=lingue.get_charUp(505) then stato_:=16;      // 'Z'
           end; }
var cliccato,insert,modifica_configurazione_htm:boolean;
    i,posto,posto0,posto1,posto2,stato_,cursore_,x_:byte;
    error:word;
    tasti_veloci_htm,tasti_veloci_rtf,stringa,c:shortstring;
    old_htm:attributi_Htm;
const tasto_ok=17;
label theMouse,tasti,read_uscita;

begin
// was   tasti_veloci_htm=['T','R','I','B','U','M','H','E','O','F','N','D','S','C','Z','G'];
// was   tasti_veloci_rtf=[        'I','B','U','M',    'E','O',    'N','D','S','C','Z','G'];
tasti_veloci_rtf:='IBU'+Lingue.get_char(500){N}+Lingue.get_char(501){D}+Lingue.get_char(502){S}+Lingue.get_char(504){G}+
   Lingue.get_char(491){m}+Lingue.get_char(494){e}+Lingue.get_char(496){o}+Lingue.get_char(505){z}+Lingue.get_char(503){C};
tasti_veloci_htm:=tasti_veloci_rtf+Lingue.get_char(486){t}+Lingue.get_char(487){r}+
     Lingue.get_char(493){h}+Lingue.get_char(497){f};
tasti_veloci_rtf:=upcase(tasti_veloci_rtf);
tasti_veloci_htm:=upcase(tasti_veloci_htm);
cursore_:=1;
x_:=1;
modifica_configurazione_htm:=true;
hidemouse;
stato_:=tasto_ok;
cursoroff;
textcolor(lightred);
textbackground(blue);
clrscr;
gotoxy(38-Lingue.get_length_txt(485)div 2,1);
if html then writeln(Lingue.get_txt(485)+' Htm'+invio)  // 'Impostazioni per conversione in'
        else writeln(Lingue.get_txt(485)+' Rtf'+invio+invio+invio);
textcolor(white);
if html then writeln(Lingue.get_txt(486)); // '[ ] Inserisci come titolo, il nome del file (consigliato/predefinito)'
if html then writeln(Lingue.get_txt(487)+' <p></p>'); // '[ ] Vai a capo usando <br> (predefinito/consigliato) anziche'''
write(Lingue.get_txt(488));
if html then
         begin
         gotoxy(25,whereY);
         writeln('<i></i>');  // '[ ] Corsivo'
         end
        else writeln;
write(Lingue.get_txt(489));
if html then
        begin
        gotoxy(25,whereY);
        writeln('<b></b>');  // '[ ] Grassetto'
        end
       else writeln;

write(Lingue.get_txt(490));
if html then
        begin
        gotoxy(25,whereY);
        writeln('<u></u>');   // '[ ] Sottolineato'  ver 2.95
        end
       else writeln;

writeln(Lingue.get_txt(491)+' (Arial,Helvetica,Verdana,Textile,...)');  // ver 2.95 // '[                   ] Nome font'
if html then writeln(Lingue.get_txt(493)+' 0..6 '+Lingue.get_txt(492))  // '[  ] Dimensione testo <h></h> da'  '(predefinito/consigliato: 0 per ignorare)'
        else writeln;
if html then writeln(Lingue.get_txt(494)+' 0..7  '+Lingue.get_txt(492)) // '[         ] Dimensione testo da'  '(predefinito/consigliato: 0 per ignorare)'
        else writeln(Lingue.get_txt(494)+' 0..',max_rtf_size,' '+Lingue.get_txt(492));  // '[         ] Dimensione testo'  '(predefinito/consigliato: 0 per ignorare)'
writeln(Lingue.get_txt(496)+Lingue.get_txt(495)); // '[         ] Colore del testo'   ' (consigliato/predefinito: stringa vuota)'
if html then writeln(Lingue.get_txt(497)+Lingue.get_txt(495)); // '[         ] Colore di sfondo'   ' (consigliato/predefinito: stringa vuota)'
writeln('   ',Lingue.get_txt(498),' 000000 .. FFFFFF (RGB)');  // 'Valori validi per i colori:'
if not html then writeln;
writeln;   // tipi di font: Arial,Helvetica,Verdana,FrenchScript,Comic Sans MS,Textile,Lucida Handwriting
writeln(Lingue.get_txt(499));  // 'Allineamento'
writeln('  ( ) '+Lingue.get_txt(500));  // 'Nessuno (predefinito/consigliato)'
writeln('  ( ) '+Lingue.get_txt(501));  // 'Destra'
writeln('  ( ) '+Lingue.get_txt(502));  // 'Sinistra'
writeln('  ( ) '+Lingue.get_txt(503));  // 'Centro'
writeln('  ( ) '+Lingue.get_txt(504));  // ver 2.95   'Giustificato'
writeln;
writeln(Lingue.get_txt(505));  // '[ ] Solo selezione (Non predefinita. Opzione non salvata nella configurazione.)'
showmouse;
Pre_Tasti(35,25);
gotoxy(34,25);
write('[');
gotoxy(39,25);
write(']');
gotoxy(2,8);
write(htm.font);
old_htm:=htm;     {salvo i valori prima di modificarli}

textcolor(13);
if html then
        begin
        gotoxy(Lingue.get_pos_rosso(486),3);
        write(Lingue.get_char(486){'t'});
        gotoxy(Lingue.get_pos_rosso(487),4);
        write(Lingue.get_char(487){'r'});
        gotoxy(Lingue.get_pos_rosso(493),9);
        write(Lingue.get_char(493){'h'});
        gotoxy(Lingue.get_pos_rosso(497),12);
        write(Lingue.get_char(497){'f'});
        end;
gotoxy(26,5);
write('i');
gotoxy(26,6);
write('b');
gotoxy(26,7);
write('u');
gotoxy(Lingue.get_pos_rosso(491),8);
write(Lingue.get_char(491){'m'});
gotoxy(Lingue.get_pos_rosso(494),10);
write(Lingue.get_char(494){'e'});
gotoxy(Lingue.get_pos_rosso(496),11);
write(Lingue.get_char(496{'o'}));
gotoxy(Lingue.get_pos_rosso(505),22);
write(Lingue.get_char(505){'z'});

gotoxy(6+Lingue.get_pos_rosso(500),16);
write(Lingue.get_char(500){'N'});
gotoxy(6+Lingue.get_pos_rosso(501),17);
write(Lingue.get_char(501){'D'});
gotoxy(6+Lingue.get_pos_rosso(502),18);
write(Lingue.get_char(502){'S'});
gotoxy(6+Lingue.get_pos_rosso(503),19);
write(Lingue.get_char(503){'C'});
gotoxy(6+Lingue.get_pos_rosso(504),20);
write(Lingue.get_char(504){'G'});

insert:=false;
posto:=1;
posto0:=1;
posto1:=1;
posto2:=1;
if html then
        begin
        Metti_X(2,3,htm.titolo);  {sono ripetuti per non annullare il vero valore}
        Metti_X(2,3,htm.titolo);
        Metti_X(2,4,htm.fine_riga_br);
        Metti_X(2,4,htm.fine_riga_br);
        gotoxy(2,9);
        write(htm.h);
        gotoxy(2,12);
        write(htm.colore_sfondo);
        end;
Metti_X(2,5,htm.corsivo);
Metti_X(2,5,htm.corsivo);
Metti_X(2,6,htm.grassetto);
Metti_X(2,6,htm.grassetto);
Metti_X(2,7,htm.sottolineato); // ver 2.95
Metti_X(2,7,htm.sottolineato);
Metti_X(2,22,htm.selezione);
Metti_X(2,22,htm.selezione);
gotoxy(2,10);
if html then write(htm.size)
        else write(htm.size_rtf);  // ver 2.96
gotoxy(2,11);
write(htm.colore_testo);
indica_scelta_allinea(htm.allinea);

showmouse;
repeat
 if (PollKeyEvent=0) and topo then
           begin
           sleep(5);
           {$ifdef go32v2}
            cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
           {$else}
            cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
           {$endif}
           if cliccato then stato:=1
                       else stato:=0;
    theMouse:
           if (stato=1)and(moy=21)and(mox= 2) then
                                              begin
                                              Metti_X(mox,moy,htm.selezione);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=15;
                                              end else
           if (stato=1)and(moy= 3)and(mox= 2) and html then
                                              begin
                                              Metti_X(mox,moy,htm.titolo);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=1;
                                              end else
           if (stato=1)and(moy= 4)and(mox= 2) and html then
                                              begin
                                              Metti_X(mox,moy,htm.fine_riga_br);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=2;
                                              end else
           if (stato=1)and(moy= 5)and(mox= 2) then
                                              begin
                                              Metti_X(mox,moy,htm.corsivo);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=3;
                                              end else
           if (stato=1)and(moy= 6)and(mox= 2) then
                                              begin
                                              Metti_X(mox,moy,htm.grassetto);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=4;
                                              end else
           if (stato=1)and(moy= 7)and(mox= 2) then  // ver 2.93
                                              begin
                                              Metti_X(mox,moy,htm.sottolineato);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=5;
                                              end else
           if (stato=1)and(moy=16)and(mox= 4) then
                                              begin
                                              indica_scelta_allinea(0); // htm.allinea
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=11;
                                              end else
           if (stato=1)and(moy=17)and(mox= 4) then
                                              begin
                                              indica_scelta_allinea(1);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=12;
                                              end else
           if (stato=1)and(moy=18)and(mox= 4) then
                                              begin
                                              indica_scelta_allinea(2);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=13;
                                              end else
           if (stato=1)and(moy=19)and(mox= 4) then
                                              begin
                                              indica_scelta_allinea(3);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=14;
                                              end else
           if (stato=1)and(moy=20)and(mox= 4) then
                                              begin
                                              indica_scelta_allinea(4);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=15;
                                              end;

           if stato=1 then if stato_<tasto_ok then cursorON
                                              else cursorOFF;
           if (stato=1)and(mox>40)and(mox<46)and(moy=25) then  {ESC}
                     begin
                read_uscita:
                     modifica_configurazione_htm:=false;
                     htm:=old_htm;   {ripristino i valori originali}
                     Break;
                     end;
           if (stato=1)and(mox>34)and(mox<39)and(moy=25) then break;  {INVIO}

           if (stato=1)and(mox>1)and(mox<10)and(moy=8) then  // nome font
                   begin
                   stato_OK;
                   cursorON;
                   stato_:=6;
                   stringa:=htm.font;
                   repeat
                    gotoxy(wherex,moy);
                    stringa:=ReadString2(stringa,2,21,0,topo,true,mancino,false,insert,moy,mox,cursore_,x_);
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    error:=0;
                    if (error>0)or(length(stringa)>240) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if error=0 then htm.font:=stringa;
                    if moy=255 then  // ALT+?
                       if (html and ( pos(upcase(char(mox)),tasti_veloci_htm)>0) ) or (not html and (pos(upcase(char(mox)),tasti_veloci_rtf)>0) ) then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_OK;
                                          stato_:=5;
                                          mox:=2;
                                          moy:=7;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          continue;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=7+byte(not html);
                                          mox:=2;
                                          moy:=9+byte(not html);
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;
           if (stato=1)and(mox>1)and(mox<10)and(moy=10) then  // dimensione testo in size
                   begin
                   stato_OK;
                   stato_:=8;
                   if html then stringa:=IntToStr(htm.size)
                           else stringa:=IntToStr(htm.size_rtf);
                   repeat
                    gotoxy(wherex,moy);
                    stringa:=ReadString(stringa,2,10,0,topo,true,mancino,insert,moy,mox,posto);
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    if stringa='' then
                                  begin
                                  stringa:='0';
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    if html then Val_Try(stringa,htm.size,error)
                            else Val_Try(stringa,htm.size_rtf,error);
                    if (error>0)or
                      ( ( (htm.size<0) or (htm.size>7) ) and html) or
                      ( ( (htm.size_rtf<0) or (htm.size_rtf>max_rtf_size) ) and not html)
                                then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if moy=255 then  // ALT+?
                       if (html and ( pos(upcase(char(mox)),tasti_veloci_htm)>0) ) or (not html and ( pos(upcase(char(mox)),tasti_veloci_rtf)>0) ) then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_OK;
                                          stato_:=7-byte(not html);
                                          mox:=2;
                                          moy:=9-byte(not html);
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=9;
                                          mox:=2;
                                          moy:=11;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;
           if (stato=1)and(mox>1)and(mox<10)and(moy=11) then  // colore testo
                   begin
                   stato_OK;
                   stato_:=9;
                   stringa:=htm.colore_testo;
                   repeat
                    gotoxy(wherex,moy);
                    stringa:=trim(ReadString(stringa,2,10,0,topo,true,mancino,insert,moy,mox,posto2));
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    error:=0;
                    for i:=1 to length(stringa) do
                        if not (stringa[i] in ['0'..'9','a'..'f','A'..'F']) then
                           begin
                           error:=1;
                           break;
                           end;
                    if (error>0)or(length(stringa)>6) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if error=0 then htm.colore_testo:=stringa;
                    if moy=255 then  // ALT+?
                       if (html and ( pos(upcase(char(mox)),tasti_veloci_htm)>0) ) or (not html and ( pos(upcase(char(mox)),tasti_veloci_rtf)>0) ) then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_OK;
                                          stato_:=8;
                                          mox:=2;
                                          moy:=10;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=10+byte(not html);
                                          mox:=2;
                                          if html then moy:=12
                                                  else moy:=16;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;

           if (stato=1)and(mox>1)and(mox<4)and(moy=9) and html then  // tag H: dimensione testo 1..6
                   begin
                   stato_OK;
                   stato_:=7;
                   stringa:=intToStr(htm.h);
                   repeat
                    gotoxy(wherex,moy);
                    stringa:=trim(ReadString(stringa,2,3,0,topo,true,mancino,insert,moy,mox,posto0));
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    if stringa='' then
                                  begin
                                  stringa:=intToStr(old_htm.h);
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    error:=0;
                    if not ( (length(stringa)=1)and(stringa[1] in ['0'..'6']) ) then
                           begin
                           error:=1;
                           sonoro;
                           Continue;
                           end
                          else htm.h:=byte(StrToInt(stringa));
                    if moy=255 then  // ALT+?
                       if (html and ( pos(upcase(char(mox)),tasti_veloci_htm)>0) ) or (not html and ( pos(upcase(char(mox)),tasti_veloci_rtf)>0) ) then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_OK;
                                          stato_:=6;
                                          mox:=2;
                                          moy:=8;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=8;
                                          mox:=2;
                                          moy:=10;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;

           if (stato=1)and(mox>1)and(mox<10)and(moy=12) and html then  // colore sfondo
                   begin
                   stato_OK;
                   stato_:=10;
                   stringa:=htm.colore_sfondo;
                   repeat
                    gotoxy(wherex,moy);
                    stringa:=trim(ReadString(stringa,2,10,0,topo,true,mancino,insert,moy,mox,posto1));
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    error:=0;
                    for i:=1 to length(stringa) do
                        if not (stringa[i] in ['0'..'9','a'..'f','A'..'F']) then
                           begin
                           error:=1;
                           break;
                           end;
                    if (error>0)or(length(stringa)>6) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if error=0 then htm.colore_sfondo:=stringa;
                    if moy=255 then  // ALT+?
                       if (html and ( pos(upcase(char(mox)),tasti_veloci_htm)>0) ) or (not html and (pos(upcase(char(mox)),tasti_veloci_rtf)>0) ) then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_OK;
                                          stato_:=10;
                                          mox:=2;
                                          moy:=11;
                                          stato:=1;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=11;
                                          Stato_Cursore;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;
           end
          else
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if length(c)=1 then c:=upcase(c);
           if c=#32 then
                    case stato_ of
                      1 : c:=Lingue.get_charUp(486);  // 'T'
                      2 : c:=Lingue.get_charUp(487);  // 'R'
                      3 : c:='I';
                      4 : c:='B';
                      5 : c:='U';
                      6 : c:=Lingue.get_charUp(491);  // 'M'
                      7 : c:=Lingue.get_charUp(493);  // 'H'
                      8 : c:=Lingue.get_charUp(494);  // 'E'
                      9 : c:=Lingue.get_charUp(496);  // 'O'
                     10 : c:=Lingue.get_charUp(497);  // 'F'
                     11 : c:=Lingue.get_charUp(500);  // 'N'
                     12 : c:=Lingue.get_charUp(501);  // 'D'
                     13 : c:=Lingue.get_charUp(502);  // 'S'
                     14 : c:=Lingue.get_charUp(503);  // 'C'
                     15 : c:=Lingue.get_charUp(504);  // 'G'
                     16 : c:=Lingue.get_charUp(505);  // 'Z'
                     17 : c:=#13;
                     18 : c:=#27;
                    end;
  tasti:   if (c=#9) then
                    begin
                    if html then inc(stato_)
                            else
                             begin
                             case stato_ of
                                  tasto_ok+1: begin
                                              stato_:=3;
                                              stato_OK;
                                              end;
                                  6: stato_:=8;
                                  9: stato_:=11;
                                  else inc(stato_);
                                  end;
                             end;
                    if stato_>tasto_ok+1 then
                                 begin
                                 stato_:=1;
                                 gotoxy(40,25);
                                 write(' ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                    if stato_<tasto_ok then
                                  begin
                                  stato_cursore;
                                  if stato_=6 then
                                       begin
                                       c:=Lingue.get_charUp(491); // 'M'
                                       stato:=1;
                                       mox:=2;
                                       moy:=8;
                                       goto theMouse;
                                       end;
                                  if stato_=7 then
                                       begin
                                       c:=Lingue.get_charUp(493); // 'H'
                                       stato:=1;
                                       mox:=2;
                                       moy:=9;
                                       goto theMouse;
                                       end;
                                  if stato_=8 then
                                       begin
                                       c:=Lingue.get_charUp(494); // 'E'
                                       stato:=1;
                                       mox:=2;
                                       moy:=10;
                                       goto theMouse;
                                       end;
                                  if stato_=9 then
                                       begin
                                       c:=Lingue.get_charUp(496); // 'O'
                                       stato:=1;
                                       mox:=2;
                                       moy:=11;
                                       goto theMouse;
                                       end;
                                  if stato_=10 then
                                       begin
                                       c:=Lingue.get_charUp(497);  // 'F'
                                       stato:=1;
                                       mox:=2;
                                       moy:=12;
                                       goto theMouse;
                                       end;
                                  end
                                 else
                                  begin
                                  cursorOFF;
                                  if stato_=tasto_ok then
                                               begin
                                               gotoxy(34,25);
                                               write('[');
                                               gotoxy(39,25);
                                               write(']');
                                               end
                                              else // tasto ESC
                                               begin
                                               gotoxy(34,25);
                                               write(' ');
                                               gotoxy(39,25);
                                               write(' [');
                                               gotoxy(46,25);
                                               write(']');
                                               end;
                                  end;
                    end else
           if (c=#27) then
                    begin
                    stato:=1;
                    mox:=41;
                    moy:=25;
                    goto theMouse;
                    end else
           if (c=#13) then
                    begin
                    if stato_<>tasto_ok then break
                                  else
                                   begin
                                   stato:=1;
                                   mox:=41;
                                   moy:=25;
                                   goto themouse; {ESC}
                                   end;
                    end else
           if (upcase(c)=Lingue.get_charUp(505){'Z'}) then Metti_X(2,22,htm.selezione)  // ver 2.81
                      else
           if (upcase(c)=Lingue.get_charUp(486){'T'}) and html then Metti_X(2,3,htm.titolo)
                      else
           if (upcase(c)=Lingue.get_charUp(487){'R'}) and html then Metti_X(2,4,htm.fine_riga_br)
                      else
           if (upcase(c)='I') then Metti_X(2,5,htm.corsivo)
                      else
           if (upcase(c)='B') then Metti_X(2,6,htm.grassetto)
                      else
           if (upcase(c)='U') then Metti_X(2,7,htm.sottolineato)
                      else
           if (upcase(c)=Lingue.get_charUp(491){'M'}) then
                      begin
                      stato:=1;
                      mox:=2;
                      moy:=8;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUp(493){'H'}) and html then
                      begin
                      stato:=1;
                      mox:=2;
                      moy:=9;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUp(494){'E'}) then
                      begin
                      stato:=1;
                      mox:=2;
                      moy:=10;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUp(496){'O'}) then // readstring
                      begin
                      stato:=1;
                      mox:=2;
                      moy:=11;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUp(497){'F'}) and html then   // readstring
                      begin
                      stato:=1;
                      mox:=2;
                      moy:=12;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUp(500){'N'}) then indica_scelta_allinea(0)
                      else
           if (upcase(c)=Lingue.get_charUp(501){'D'}) then indica_scelta_allinea(1)
                      else
           if (upcase(c)=Lingue.get_charUp(502){'S'}) then indica_scelta_allinea(2)
                      else
           if (upcase(c)=Lingue.get_charUp(503){'C'}) then indica_scelta_allinea(3)
                      else
           if (upcase(c)=Lingue.get_charUp(504){'G'}) then indica_scelta_allinea(4);

           if length(c)=1 then
              begin
              if (html and (pos(upcase(c[1]),tasti_veloci_htm)>0) ) or (not html and ( pos(upcase(c[1]),tasti_veloci_rtf)>0) ) then stato_OK;
              assegna_stato;
              if (stato_<>tasto_ok) and (stato_<>tasto_ok+1) then stato_cursore;
              end;
           if (c='Down')or(c='Right') then
                          begin  // freccia giu'/destra  #80,#77
                          c:=#9;
                          goto tasti;
                          end else
           if (c='Up')or(c='Left')or(c='SHIFT Key with scancode 3840') then
                          begin // freccia su/sinistra  #72,#75 e shift+tab
                          if stato_ in [tasto_ok,tasto_ok+1] then
                                 begin
                                 gotoxy(34,25);
                                 write(' ');
                                 gotoxy(39,25);
                                 write('  ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                          if stato_=2 then stato_:=tasto_ok+1
                             else if stato_=1 then stato_:=tasto_ok
                                  else
                                   if html then dec(stato_,2)
                                           else case stato_ of
                                                   11: stato_:=8;
                                                    3: stato_:=tasto_ok;
                                                   else dec(stato_,2);
                                                end;
                          c:=#9;
                          goto tasti;
                          end;
           end;
until false;
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
if modifica_configurazione_htm then
   begin
   Editor_Ini.Set_modifica(true);
   Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Htm'{nome_tipo},get_cfg_htm(){valore});
   Editor_Ini.Aggiorna('OPZIONI','Font',htm.font);  // ver 2.95
   end;
Evidenzia_Selezione;
stato:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Select2(k:char;x1,y1:byte);
begin
{$ifdef TxtCrt}
colore;
HideMouse;
case K of
 'n' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+19,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write('[');
       gotoxy(x1+10,y1);
       write(']');
       gotoxy(x,y);
       end;
 's' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+19,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write('[');
       gotoxy(x1+4,y1);
       write(']');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x,y);
       end;
 't' : begin
       gotoxy(x1+11,y1);
       write('[');
       gotoxy(x1+19,y1);
       write(']');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x,y);
       end;
end; {case}
ShowMouse;
{$endif}
{$ifdef TxtVideo}
dec(x1);
dec(y1);
case K of
 'n' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+19,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,'[',255,blue,white);
       outtextxy(x1+10,y1,']',255,blue,white);
       gotoxy(x,y);
       end;
 's' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+19,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,'[',255,blue,white);
       outtextxy(x1+4,y1,']',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       gotoxy(x,y);
       end;
 't' : begin
       outtextxy(x1+11,y1,'[',255,blue,white);
       outtextxy(x1+19,y1,']',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       gotoxy(x,y);
       end;
end; {case}
updatescreen(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasti_SNT(x1,y1:byte):char; // update 3.02
var old_c,c:string;
    cliccato:boolean;
label tab;
begin
HideMouse;
{$ifdef TxtCrt}
textcolor(red);
textbackground(7);
gotoxy(x1,y1);
write('<'+Lingue.get_txt(38)+'>  <'+Lingue.get_txt(39)+'>  <'+Lingue.get_txt(506)+'>'); // <Si>  <No>  <Tutto>
{$endif}
{$ifdef TxtVideo}
outtextxy(x1-1,y1-1,'<'+Lingue.get_txt(38)+'>  <'+Lingue.get_txt(39)+'>  <'+Lingue.get_txt(506)+'>',255,7,red);
{$endif}
colore;
gotoxy(x1+4,y1);
write('  ');
gotoxy(x1+10,y1);          {il mouse puo' cliccare su SI,NO,Tutto}
write('  ');               {oppure premendo i tasti S,N,T}
Select2('t',x1,y1);
sonoro;
ShowMouse;
tast_vuota;
c:='t';  {Tutto e' predefinito}
ShowMouse;
ShowMouse;
repeat
 if (PollKeyEvent<>0) or (not topo) then
        begin
        old_c:=c;
        c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
        if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
        if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
        if length(c)=1 then c:=upcase(c);
        if from_alt_to_char(c)=Lingue.get_charUP(38){'S'} then c:='S' {ALT+S}
                                   else
        if from_alt_to_char(c)=Lingue.get_charUP(506){'T'} then c:='T' {ALT+T}
                                   else
        if from_alt_to_char(c)=Lingue.get_charUP(39){'N'} then c:='N' {ALT+N}
                                   else
        if (c='Right')or(c='Down') then goto tab  // #77,#80
                                   else
        if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then // shift+tab
                         begin // #72,#75
                         if (old_c='s') then old_c:='n'
                                        else
                         if (old_c='n') then old_c:='t'
                                        else
                         if (old_c='t') then old_c:='s';
                         goto tab;
                         end else
        if (c=#27) then c:='N'
                   else
        if (c=#13)or(c=#32) then c:=upcase(old_c)
                            else
        if (c=#9) then
                  begin
                  tab:
                  if (old_c='s') then c:='n'
                                 else
                  if (old_c='n') then c:='t'
                                 else
                  if (old_c='t') then c:='s';
                  Select2(c[1],x1,y1);
                  end
                 else
                  if (c<>'S')and(c<>'N')and(c<>'T') then c:=old_c;
        end
       else   // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=y1) then
            begin
            if (mox>x1-1)  and (mox<4+x1)  then c:='S';
            if (mox>5+x1)  and (mox<10+x1) then c:='N';
            if (mox>11+x1) and (mox<19+x1) then c:='T';
            end;
        sleep(5);
        end;
until (c='S')or(c='N')or(c='T');
Tasti_SNT:=c[1];
{$ifdef TxtCrt}
textcolor(white);
textbackground(blue);
gotoxy(1,y1);
clreol;           // copre la risposta SNT   update 2.52
{$endif}
{$ifdef TxtVideo}
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
setcursorpos(0,y1-1);
TxtClreol;        // copre la risposta SNT   update 2.52
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Print_Now(mx:byte; k:char):char; // update 2.10 , 2.83 , 3.02
var s:string;
begin
info;
if mx-1=0 then pulisci1;
colore;
case k of
     '2' : s:=Lingue.get_txt(507); // 'Stampa foglio attuale.'
     '3' : s:=Lingue.get_txt(508); // 'Stampa fogli.'
     '4' : s:=Lingue.get_txt(509); // 'Stampa righe.'
     '5' : s:=Lingue.get_txt(510); // 'Stampa tutto il testo.'
     '6' : s:=Lingue.get_txt(511); // 'Stampa selezione.'
     end;
{$ifdef TxtCrt}
gotoxy(1,riga_menu+1);
while length(s)<25 do s:=s+' ';
write(s);
gotoxy(1,riga_menu+2);
write(mx-1,Lingue.get_txt(512),copie,'.');  // ' copie su '
gotoxy(22,riga_menu+3);
write(Lingue.get_txt(513)); // 'Stampare ?'
{$else}
while length(s)<78 do s:=s+' ';
outtextxy(0,riga_menu,s,0,blue,white);
outtextxy(0,riga_menu+1,intToStr(mx-1)+Lingue.get_txt(512)+intToStr(copie)+'.');  // ' copie su '
outtextxy(21,riga_menu+2,Lingue.get_txt(513),0,blue,white);  // 'Stampare ?'
{$endif}
if (k='6')and(mx-1=0) then
      begin
      {$ifdef TxtCrt}
      textcolor(yellow);
      textbackground(blue);
      gotoxy(1,riga_menu+3);
      write(Lingue.get_txt(514)+'X:    Y:');       // DA
      gotoxy(1,riga_menu+4);
      write(Lingue.get_txt(515)+'X:    Y:');       // A
      textcolor(white);
      gotoxy(Lingue.get_length_txt(514)+3,riga_menu+3);
      write(selezionato.x1);
      gotoxy(13,riga_menu+3);
      write(selezionato.y1);
      gotoxy(Lingue.get_length_txt(515)+3,riga_menu+4);
      write(selezionato.x2);
      gotoxy(13,riga_menu+4);
      write(selezionato.y2,'            ');
      {$else}
      outtextxy(0,riga_menu+2,Lingue.get_txt(514)+'X:    Y:',0,blue,yellow);  // Da
      outtextxy(0,riga_menu+3,Lingue.get_txt(515)+'X:    Y:',0,blue,yellow); // A
      outtextxy(Lingue.get_length_txt(514)+2,riga_menu+2,IntToStr(selezionato.x1),0,blue,white);
      outtextxy(12,riga_menu+2,IntToStr(selezionato.y1),0,blue,white);
      outtextxy(Lingue.get_length_txt(515)+2,riga_menu+3,IntToStr(selezionato.x2),0,blue,white);
      outtextxy(12,riga_menu+3,IntToStr(selezionato.y2)+'            ',0,blue,white);
      {$endif}
      end;
Exit(Tasti_SNT(34,riga_menu+3));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Foglio_Attuale;
var i:integer;
    a:byte;
    all:boolean;
begin
all:=false;
for a:=1 to copie do
    begin
    if not all then
       case print_now(a,'2') of
         'S': ;
         'N': Exit;
         'T': all:=true;
         end;
    for i:=(foglio(iy)-1)*(riga_menu-1)+1 to foglio(iy)*(riga_menu-1) do
        if i<=ymax then
                   if not Stampante.writeln(testo[i]) then
                          begin
                          Err_Print;
                          Exit;
                          end;
    end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Tutto;
var i:integer;
    a:byte;
    all:boolean;
begin
all:=false;
for a:=1 to copie do
    begin
    if not all then
       case print_now(a,'5') of
         'S': ;
         'N': Exit;
         'T': all:=true;
         end;
    for i:=1 to ymax do
        if not Stampante.writeln(testo[i]) then
               begin
               Err_Print;
               Exit;
               end;
    end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Selezione;   {stampa il testo selezionato}
var i:integer;
    a:byte;
    all:boolean;
begin
all:=false;
if selezione_quadrata then
    for a:=1 to copie do
        begin
        if not all then
           case print_now(a,'6') of
             'S': ;
             'N': Exit;
             'T': all:=true;
             end;
        for i:=selezionato.y1 to selezionato.y2 do
            if not Stampante.writeln(copy(testo[i],selezionato.x1+1,selezionato.x2-selezionato.x1+1)) then
                        begin
                        Err_Print;
                        Exit;
                        end;
        end
   else
    for a:=1 to copie do
         begin
         if not all then
            case print_now(a,'6') of
              'S': ;
              'N': Exit;
              'T': all:=true;
              end;
         if not Stampante.writeln(fDelete(testo[selezionato.y1],1,selezionato.x1)) then
                        begin
                        Err_Print;
                        Exit;
                        end;
         for i:=selezionato.y1+1 to selezionato.y2-1 do
             if not Stampante.writeln(testo[i]) then
                            begin
                            Err_Print;
                            Exit;
                            end;
         if selezionato.y1<>selezionato.y2 then
            if not Stampante.writeln(Copy(testo[selezionato.y2],2,selezionato.x2)) then
                      begin
                      Err_Print;
                      Exit;
                      end;
         end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Fogli;   {stampa fogli da ... a}
var a,b,old_a:int64;
    ii:byte;
    all:boolean;
begin
da_a_graph;
a:=1;
b:=foglio(ymax);
if not Da_A_2(a,b,1,foglio(ymax),Lingue.get_txt(516),Lingue.get_txt(517),Lingue.get_txt(518)) then Exit; // 'Da pagina: '  'A pagina: '  'Stampa'
a:=a*(riga_menu-1)-(riga_menu-2);
b:=b*(riga_menu-1);
old_a:=a;
normale;
all:=false;
for ii:=1 to copie do
    begin
    a:=old_a;
    if not all then
       case print_now(ii,'3') of
         'S': ;
         'N': Exit;
         'T': all:=true;
         end;
    while a<=b do
        begin
        if a<=ymax then
                   if not Stampante.writeln(testo[a]) then
                          begin
                          Err_Print;
                          Exit;
                          end;
        inc(a);
        end;
    end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Righe;    {stampa righe da ... a}
var a,b,old_a:int64;
    ii:byte;
    all:boolean;
begin
da_a_graph;
a:=1;
b:=ymax;
if not Da_A_2(a,b,1,ymax,Lingue.get_txt(519),Lingue.get_txt(520),Lingue.get_txt(518)) then Exit;  // 'Dalla riga: '  'Alla riga: '  'Stampa'
old_a:=a;
all:=false;
for ii:=1 to copie do
    begin
    a:=old_a;
    if not all then
       case print_now(ii,'4') of
         'S': ;
         'N': Exit;
         'T': all:=true;
         end;
    while a<=b do
        begin
        if a<=ymax then
                   if not Stampante.writeln(testo[a]) then
                          begin
                          Err_Print;
                          Exit;
                          end;
        inc(a);
        end;
    end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure DoppioClick;  // ver 2.00
var dc_x,dc_y,x1,x2:byte;
label due_click;
begin
dc_X:=mox;
dc_Y:=moy;
if (dc_y in [1..(riga_menu-1)]) and (dc_x in [1..length(testo[iy])-1] ) then
          begin
          x1:=x_riga+1; // sinistra
          x2:=x_riga+1; // destra
          if (x_riga+1>length(testo[iy])) or (testo[iy][x_riga+1]=' ') then
                begin
                while (x2<length(testo[iy]))and(testo[iy][x2]=' ') do inc(x2);  // destra
                if (x2<length(testo[iy]))and(testo[iy][x2]<>' ') then dec(x2);
                dec(x2);
                while (x1<length(testo[iy]))and(testo[iy][x1]=' ')and(x1>1) do dec(x1);  // sinistra
                if (x1<length(testo[iy]))and(testo[iy][x1]<>' ') then inc(x1);
                dec(x1);
                end
               else //  <>' '   non vuoto
                begin
                while (testo[iy][x2]<>' ')and(x2<length(testo[iy])) do inc(x2);  // destra
                if testo[iy][x2]=' ' then dec(x2);
                dec(x2);
                while (testo[iy][x1]<>' ')and(x1>1) do dec(x1);  // sinistra
                if testo[iy][x1]=' ' then inc(x1);
                dec(x1);
                end;
          Azzera_Selezione;
          selezionato.x1:=x1;
          selezionato.x2:=x2;
          selezionato.y1:=iy;
          selezionato.y2:=iy;
          Evidenzia_Selezione;
          end;
if (dc_y in [1..(riga_menu-1)]) then
   if (dc_x in [length(testo[iy])..255] ) then   // seleziona tutta la riga
          begin
          Due_click:
          if dc_x=0 then Exit;
          Azzera_Selezione;
          if length(testo[iy])>1 then
              begin
              Selezionato.x1:=1;
              Selezionato.x2:=length(testo[iy])-1;
              selezionato.y1:=iy;
              selezionato.y2:=iy;
              end;
          Evidenzia_Selezione;
          end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Seleziona_parola;  //  ver 3.03
begin
azzera_selezione;
mox:=x;
moy:=y;
DoppioClick;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure seleziona_paragrafo;  // ver 3.01
var riga_inizio,riga_fine:integer;
begin
if length(testo[iy])=1 then exit;
riga_inizio:=iy;
while (riga_inizio-1>0)and(length(testo[riga_inizio-1])>1) do riga_inizio:=riga_inizio-1;
riga_fine:=iy;
while (riga_fine<ymax)and(length(testo[riga_fine+1])>1) do riga_fine:=riga_fine+1;
azzera_selezione;
selezionato.x1:=1;
selezionato.y1:=riga_inizio;
selezionato.x2:=length(testo[riga_fine])-1;
selezionato.y2:=riga_fine;
Evidenzia_selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure m_speciale__copia(menu_selezione_speciale:byte);    // ver 3.03
var old_selezione1,old_selezione2:selez;
begin
old_selezione1:=selezionato;
old_selezione2:=old_selezionato;
case menu_selezione_speciale of
     1: seleziona_paragrafo;
     2: Seleziona_Riga_attuale;
     3: Seleziona_parola;
     4: M_speciale__Copia_Righe;
     end;
if menu_selezione_speciale in [1..3] then
    begin
    M_modifica__Copia_Selezione;  // ripristina la vecchia selezione
    selezionato:=old_selezione1;
    old_selezionato:=old_selezione2;
    Evidenzia_Selezione;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Seleziona_Riga_Attuale; // ver 2.45
begin
if testo_vuoto then Exit;
selezionato.x1:=1;
selezionato.y1:=iy;
selezionato.x2:=length(testo[selezionato.y1])-1;
selezionato.y2:=selezionato.y1;
Evidenzia_selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure m_speciale__seleziona(menu_selezione_speciale:byte);  // ver 3.03
begin
case menu_selezione_speciale of
     1: seleziona_paragrafo;
     2: Seleziona_Riga_attuale;
     3: Seleziona_parola;
     4: M_speciale__seleziona_Righe;
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_maiuscolo(s:string):string;  // ver 3.04
var i:integer;
begin
for i:=1 to length(s) do s[i]:=upcase(s[i]);
exit(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_minuscolo(s:string):string;  // ver 3.04
var i:integer;
begin
for i:=1 to length(s) do s[i]:=lowcase(s[i]);
exit(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_iniziali_maiuscole(s:string):string;  // ver 3.04
var i:integer;
begin
for i:=1 to length(s) do
    if i-1>0 then
       if s[i-1] in [' ','.'] then s[i]:=upcase(s[i])
                              else s[i]:=lowcase(s[i]);
exit(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_Invertito(s:string):string;  // ver 3.04
var i:integer;
begin
for i:=1 to length(s) do
    if s[i] in ['A'..'Z'] then s[i]:=lowcase(s[i]) else
    if s[i] in ['a'..'z'] then s[i]:=upcase(s[i]);
exit(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function first_char(s:string; start:integer):integer; // ver 3.04
var i:integer;
begin     // cerca il primo carattere che non sia spazio
for i:=start to length(s) do if s[i]<>' ' then exit(i);
exit(0);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_normale(s1,s2:string):string;  // ver 3.04
var s3:string;
    p:integer;
begin
s3:=s2;

// c'e' un punto alla fine della riga precedente (seguito eventualmente da spazi)?
if ((fReverse(trimRight(s1))+' ')[1]='.') or
   (s1='') then
         begin
         p:=first_char(s3,1);
         if p>0 then s3[p]:=upcase(s3[p]);
         end;
repeat
 p:=pos('.',s2);
 if p=0 then break;
 s2[p]:='X';
 p:=first_char(s2,p+1);
 if (p>0)and(p<=length(s3)) then s3[p]:=upcase(s3[p]);
until false;
exit(s3);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_Alternato(s:string):string;  // ver 3.04
var i:integer;
begin
for i:=1 to length(s) do
    if (i mod 2)=0 then s[i]:=upcase(s[i])
                   else s[i]:=lowcase(s[i]);
exit(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function converti_Spazi_Doppi(s:string):string;  // ver 3.13
var ss:string;
    i:integer;
begin
s:=s+'X';  // serve per gestire l'ultimo carattere
ss:='';
for i:=1 to length(s)-1 do if (s[i]<>' ')or(s[i+1]<>' ') then ss:=ss+s[i];
exit(ss);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure prepara_undo_formattato(originale:string; inizio,fine,attuale,c:integer); // ver 3.04
var ch,tipo:char;
begin
if attuale<>inizio then ch:='0'
                   else ch:='1';
if originale=testo[attuale] then exit
                            else modifica_on;
case c of
     1: tipo:='+';  // maiuscolo
     2: tipo:='-';  // minuscolo
     3: tipo:='S';  // iniziali maiuscole
     4: tipo:=#9;   // tab: invertito
     5: tipo:='';  // +/- (#241): alternato maiuscolo / minuscolo
     6: tipo:='0';  // normale
     7: tipo:='2';  // spazi doppi
     end;
Annulla_Txt.input_iniziale(strnew(stringtopchar( ch+char(x)+char(x_min)+zero(inttostr(y),2)+zero(inttostr(attuale),4)+tipo+copy_end(originale,2) )));
Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Menu_Formattato__formatta_testo(c:byte; speciale:boolean);  // ver 3.04
var a,b,i:int64;
    prima:byte;
    annulla_:boolean;
    ch:char;
    myundo:string;
    messaggio:shortstring;
label speciale_; // ver 3.04
begin
if speciale then goto speciale_;
if not (c in [1,2,3,4]) then Exit;  // eseguita quando c=0
if binario then // MAI
   begin
   No_ASCII;
   Exit;
   end;
Da_A_graph;
gotoxy(27,riga_menu+2);
colore;
case c of
   4: messaggio:=Lingue.get_txt(521); // 'Giustifica il testo'
   3: messaggio:=Lingue.get_txt(522); // 'Centra il testo'
   2: messaggio:=Lingue.get_txt(523); // 'Sposta il testo a Destra'
   1: messaggio:=Lingue.get_txt(524); // 'Sposta il testo a Sinistra'
   end;
hidemouse;
ShowMouse;
a:=1;
b:=ymax;
if not Da_A_2(a,b,1,ymax,Lingue.get_txt(519),Lingue.get_txt(520),messaggio) then Exit;
speciale_:
if speciale then
   begin
   a:=selezionato.y1;
   b:=selezionato.y2;
   end;
normale;
Azzera_Selezione;
annulla_:=FreeAnnulla(b-a+1);
if (iy<=b)and(iy>=a) then Set_Cursore_X(1);
ch:='1';
i:=a-1;
while i<b do
   begin
   inc(i);
   case c of
     4: begin
        myundo:=testo[i];
        Giustifica(testo[i]);
        if i<>a then ch:='0';
        if myundo=testo[i] then
            begin
            if i=a then inc(a); { no modifica: spreco meno heap }
            Continue;
            end
           else modifica_on;
        if annulla_ then
              begin
              Annulla_Txt.input_iniziale(strnew(stringtopchar( ch+#1+#1+zero(inttostr(y),2)+zero(inttostr(i),4)+'|'+copy_end(myundo,2) )));
              Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
              end;
        end;
     3: begin
        myundo:=Centra(testo[i]);
        if i<>a then ch:='0';
        if (copy(myundo,1,3)='000')and(copy(myundo,4,6)=copy(myundo,7,9)) then
            begin
            if i=a then inc(a); { no modifica: spreco meno heap }
            Continue;
            end
           else modifica_on;
        if annulla_ then
           begin
           Annulla_Txt.input_iniziale(strnew(stringtopchar( ch+#1+#1+zero(inttostr(y),2)+zero(inttostr(i),4)+'^'+myundo )));
           Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
           end;
        end;
     2: begin
        myundo:=Destra(testo[i]);
        if i<>a then ch:='0';
        if myundo='000000' then
            begin
            if i=a then inc(a); { no modifica: spreco meno heap }
            Continue;
            end
           else modifica_on;
        if annulla_ then
            begin
            Annulla_Txt.input_iniziale(strnew(stringtopchar( ch+#1+#1+zero(inttostr(y),2)+zero(inttostr(i),4)+'>'+myundo )));
            Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
            end;
        end;
     1: begin
        prima:=length(testo[i]);
        sinistra(testo[i]);
        if i<>a then ch:='0';
        if prima=length(testo[i]) then
            begin
            if i=a then inc(a); { no modifica: spreco meno heap }
            Continue;
            end
           else modifica_on;
        if annulla_ then
            begin
            Annulla_Txt.input_iniziale(strnew(stringtopchar( ch+#1+#1+zero(inttostr(y),2)+zero(inttostr(i),4)+'<'+zero( inttostr(prima),3 ) )));
            Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
            end;
        end;
     end; // del case
   end;
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Formattato(c,riga:integer); // ver 3.15
begin
case c of
     4: Giustifica(testo[riga]);
     3: Centra(testo[riga]);
     2: Destra(testo[riga]);
     1: Sinistra(testo[riga]);
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Menu_Formattato(c:byte); // ver 3.04
var i:longint;
    l:integer;
    s,myundo:string;
    annulla_,was_selezionato:boolean;
    s1,s2:selez;
begin
case c of
     1..5: menu_selezione_formattato:=c;
     6: ;  // vuoto
     7..13: begin
            was_selezionato:=not non_selezione();
            s1:=old_selezionato;
            s2:=selezionato;
            if menu_selezione_formattato-1<>0 then azzera_Selezione;

            m_speciale__seleziona(menu_selezione_formattato-1);
            if non_selezione() then
                               begin
                               old_selezionato:=s1;   // ripristina la selezione
                               selezionato:=s2;
                               if was_selezionato then Evidenzia_Selezione;
                               Exit;
                               end;
            annulla_:=FreeAnnulla(selezionato.y2-selezionato.y1+1);
            l:=length(testo[selezionato.y2]);

            Set_Cursore_X(selezionato.x1);
            iy:=selezionato.y1;
            y:=byte(min(y,iy));

            // ora applica modifiche
            if selezionato.y1=selezionato.y2
               then
                begin
                myundo:=testo[selezionato.y1];
                s:=copy(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1);
                case c-6 of
                         1: s:=converti_maiuscolo(s);
                         2: s:=converti_minuscolo(s);
                         3: s:=converti_iniziali_maiuscole(s);
                         4: s:=converti_invertito(s);
                         5: s:=converti_alternato(s);
                         6: if selezionato.x1>1 then s:=converti_normale(copy(testo[selezionato.y1],1,selezionato.x1),copy(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1))
                                                else
                                                 if selezionato.y1>1 then s:=converti_normale(copy_end(testo[selezionato.y1-1],2),copy(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1))
                                                                     else s:=converti_normale('',copy(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1));
                         7: s:=converti_Spazi_Doppi(s); // ver 3.13
                         end;
                testo[selezionato.y1]:=copy(testo[selezionato.y1],1,selezionato.x1)+s+copy_end(testo[selezionato.y1],selezionato.x2+2);
                if annulla_ then prepara_undo_formattato(myundo,selezionato.y1,selezionato.y2,selezionato.y1,c-6);
                end
               else   // selezionato.y1<>selezionato.y2
                begin                    // parte inzale
                // normale: prima lettera di prima parola dopo punto con carattere maiuscolo (o dopo riga vuota)
                myundo:=testo[selezionato.y1];
                s:=copy_end(testo[selezionato.y1],selezionato.x1+1); // la parte iniziale
                case c-6 of
                         1: s:=converti_maiuscolo(s);
                         2: s:=converti_minuscolo(s);
                         3: s:=converti_iniziali_maiuscole(s);
                         4: s:=converti_invertito(s);
                         5: s:=converti_alternato(s);
                         6: if selezionato.x1>1 then s:=converti_normale(copy(testo[selezionato.y1],1,selezionato.x1),s)
                                                else
                                                 if (selezionato.y1=1) then s:=converti_normale('',s)
                                                                       else s:=converti_normale(copy_end(testo[selezionato.y1-1],1),s);
                         7: s:=converti_Spazi_Doppi(s); // ver 3.13
                         end;
                testo[selezionato.y1]:=copy(testo[selezionato.y1],1,selezionato.x1)+s;
                if annulla_ then prepara_undo_formattato(myundo,selezionato.y1,selezionato.y2,selezionato.y1,c-6);

                for i:=selezionato.y1+1 to selezionato.y2-1 do       // la parte centrale
                    begin
                    myundo:=testo[i];
                    case c-6 of
                         1: testo[i]:=#13+converti_maiuscolo(copy_end(testo[i],2));
                         2: testo[i]:=#13+converti_minuscolo(copy_end(testo[i],2));
                         3: testo[i]:=#13+converti_iniziali_maiuscole(copy_end(testo[i],2));
                         4: testo[i]:=#13+converti_invertito(copy_end(testo[i],2));
                         5: testo[i]:=#13+converti_alternato(copy_end(testo[i],2));
                         6: testo[i]:=#13+converti_normale(copy_end(testo[i-1],2),copy_end(testo[i],2));
                         7: testo[i]:=#13+converti_Spazi_Doppi(copy_end(testo[i],2)); // ver 3.13
                         end;
                    if annulla_ then prepara_undo_formattato(myundo,selezionato.y1,selezionato.y2,i,c-6);
                    end;

                myundo:=testo[selezionato.y2];
                s:=copy(testo[selezionato.y2],1,selezionato.x2+1);  // la parte finale
                case c-6 of
                         1: s:=converti_maiuscolo(s);
                         2: s:=converti_minuscolo(s);
                         3: s:=converti_iniziali_maiuscole(s);
                         4: s:=converti_invertito(s);
                         5: s:=converti_alternato(s);
                         6: s:=#13+converti_normale(copy_end(testo[selezionato.y2-1],2),copy_end(s,2));
                         7: s:=converti_Spazi_Doppi(s); // ver 3.13
                         end;
                testo[selezionato.y2]:=s+copy_end(testo[selezionato.y2],selezionato.x2+2);
                if annulla_ then prepara_undo_formattato(myundo,selezionato.y1,selezionato.y2,selezionato.y2,c-6);
                end;
            if c=13 {togli spazi doppi} then  // ver 3.13
               if menu_selezione_formattato=5 then Azzera_selezione
                                              else selezionato.x2:=selezionato.x2-(l-length(testo[selezionato.y2]));
            Evidenzia_Selezione;
            end;
    14: ;  // vuoto
    15..18: if menu_selezione_formattato=5 then Menu_Formattato__formatta_testo(c-14,false)
                                           else
                                            begin
                                            m_speciale__seleziona(menu_selezione_formattato-1);
                                            if non_selezione() then Exit;
                                            Menu_Formattato__formatta_testo(c-14,true);
                                            end;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Menu_Formattato(riga:string);  // ver 3.15
var a,b:longint;
begin
a:=Annulla_Txt.numelementi();
b:=Annulla_selezione.numelementi();
Undo__Selezione(false);
case riga[10] of
     '+': Menu_Formattato(7);  // maiuscolo
     '-': Menu_Formattato(8);  // minuscolo
     'S': Menu_Formattato(9);  // iniziali maiuscole
     #9 : Menu_Formattato(10); // invertito
     '': Menu_Formattato(11); // alternato
     '0': Menu_Formattato(12); // normale
     '2': Menu_Formattato(13); // Spazi Doppi
     end;
while a<Annulla_Txt.numelementi() do Annulla_Txt.cancella_iniziale;
while b<Annulla_selezione.numelementi() do Annulla_selezione.cancella_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_speciale__Seleziona_Righe;  // ver 3.01
var val_da,val_a:int64;
begin
Da_A_graph;
colore;
ShowMouse;
val_da:=1;
val_a:=ymax;
if not Da_A_2(val_da,val_a,1,ymax,Lingue.get_txt(519),Lingue.get_txt(520),Lingue.get_txt(525)) then Exit;  //  'Dalla riga: '  'Alla riga: '  'Seleziona il testo'
selezionato.x1:=1;
selezionato.y1:=integer(val_da);
selezionato.x2:=length(testo[val_da])-1;
selezionato.y2:=integer(val_a);
Evidenzia_selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function files_non_salvati():boolean; // ver 3.13
var i:longint;
begin
if modifica>0 then exit(true);
for i:=1 to get_numero_files do
    if multi_file[i].modifica>0 then exit(true);
exit(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure messaggio(num:integer);
begin
pulisci1;
case num of
     1: begin
        gotoxy(40-Lingue.get_length_txt(526) div 2,riga_menu+2);
        writeln(Lingue.get_txt(526));  // 'Bisogna prima salvare tutti i files'
        end;
     2: begin
        gotoxy(40-Lingue.get_length_txt(527) div 2,riga_menu+2);
        writeln(Lingue.get_txt(527));  //  'Errore nella creazione della configurazione predefinita'
        end;
     end;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__TE_Esa(selezione:boolean=false); // ver 3.15
var i:longint;
begin
undo__selezione(false);
if selezione then
   for i:=1 to {righe_da_cancellare} abs(selezionato.y2-selezionato.y1) do
       Ripristina_Txt.cancella_iniziale;
M_modifica__Taglia_Selezione(selezione);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__TE_Quadrato; // ver 3.15
begin
undo__selezione(false);
M_modifica__Taglia_Selezione(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__TE_Esa2; // ver 3.15
var a,b:longint;
begin
a:=Annulla_Txt.numelementi();
b:=Annulla_selezione.numelementi();
undo__selezione(false);
M_modifica__Taglia_Selezione(false);
while a<Annulla_Txt.numelementi() do Annulla_Txt.cancella_iniziale;
while b<Annulla_selezione.numelementi() do Annulla_selezione.cancella_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__TE_Righe; // ver 3.15
var a,b:longint;
begin
a:=Annulla_Txt.numelementi();
b:=Annulla_selezione.numelementi();
M_speciale__Taglia_Riga_Attuale(false,false);   // update ver 2.30
while a<Annulla_Txt.numelementi() do Annulla_Txt.cancella_iniziale;
while b<Annulla_selezione.numelementi() do Annulla_selezione.cancella_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Insert(riga:string);   // ver 3.15
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
case length(riga) of
      14: begin
          inc(ymax);
          inc(iy);
          testo[ymax]:=#13+riga[14];
          if iy>=ymax then iy:=ymax;
          Set_Cursore_X(length(testo[ymax]));
          end;
      13: testo[iy]:=testo[iy]+riga[13];
      12: testo[iy][x_riga+1]:=riga[12];
      11: testo[iy][x_riga+1]:=riga[11]{#0};  // per gestire il carattere 0
      15: testo[iy][x_riga+1]:=#0;  // per gestire il carattere 0
      10: ; // carattere #0 sovrascritto da #0
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__UnoS(riga:string);  // struttura 0|1 x y iy U
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
if x_riga=lunghezza_riga+1 then testo[iy+1][2]:=riga[11]
                           else testo[iy][x_riga+1]:=riga[11];
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Mouse_CL(const riga:string);   // struttura 0|1 x y iy M  ...
begin        { ver 3.15 }
iy:=StrToInt(copy(riga,6,4));
while length(testo[iy])<StrToInt(copy(riga,29,3)) do testo[iy]:=testo[iy]+' ';
x:=byte(riga[2]);
x_min:=byte(riga[3]);
y:=byte(StrToInt(copy(riga,4,2)));
x_riga:=StrToInt(copy(riga,26,3));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__F1_F2(riga:string; ann:boolean);  // ver 3.15
begin
if length(riga)>11 then riga[11]:=riga[12];
Undo__F1_F2(riga,ann);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Back_Space;  // ver 3.15
var a,b:longint;
begin
a:=Annulla_Txt.numelementi();
b:=Annulla_selezione.numelementi();
Tasto__Back_Space(false);
while a<Annulla_Txt.numelementi() do Annulla_Txt.cancella_iniziale;
while b<Annulla_selezione.numelementi() do Annulla_selezione.cancella_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Redo__Invio;  // ver 3.15
var a,b:longint;
begin
a:=Annulla_Txt.numelementi();
b:=Annulla_selezione.numelementi();
tasto__invio(false);
while a<Annulla_Txt.numelementi() do Annulla_Txt.cancella_iniziale;
while b<Annulla_selezione.numelementi() do Annulla_selezione.cancella_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Cambia_Lingua;   // ver 3.20, 3.30
var s,messaggio_cambia_lingua,file_lingua,the_files:string;
    carica_lng:integer;
    lingua_cambiata:boolean;
{$define cambia_lng_comune:=
         begin
         Crea_ListaX;
         Crea_ListaY;
         Aggiorna_Campi_Menu;
         grafica;
         Est_note:=Lingue.get_charUp(140);     // 'P'
         Est_non_note:=Lingue.get_charUp(144); // '/'
         lingua_cambiata:=true;
         end}
begin
the_files:='*.lng';
lingua_cambiata:=false;
messaggio_cambia_lingua:=Lingue.get_txt(235);
messaggio_cambia_lingua:=trim(copy(messaggio_cambia_lingua,1,length(messaggio_cambia_lingua)-4));
file_lingua:=SfogliaFile(15,2,true,true,topo,mancino,messaggio_cambia_lingua,pathof(paramstr(0)){percorso},the_files,ClickDelay,ScreenHeight-4,
         Lingue.get_txt(531){nome},Lingue.get_txt(532){lista},Lingue.get_txt(533){elementi},
         Lingue.get_txt(293){data},Lingue.get_txt(294){ora},Lingue.get_txt(291){attributi},Lingue.get_txt(534),Lingue.get_char(531),Lingue.get_char(532)); // 'Cambia lingua'
if file_lingua<>'' then
                    begin
                    carica_lng:=lingue.Carica(file_lingua);
                    if carica_lng=0 then cambia_lng_comune
                                   else
                                    begin
                                    Evidenzia_selezione;
                                    pulisci1;
                                    case carica_lng of
                                       1: s:=Lingue.get_txt(537);  // 'Errore nel contenuto del file della nuova lingua.'
                                       2: s:=Lingue.get_txt(536);  // 'Errore nel leggere il file della nuova lingua.'
                                       3: s:=Lingue.get_txt(538);  // 'File della lingua non trovato.'
                                       end;
                                    gotoxy(40-length(s) div 2,riga_menu+2);
                                    write(s);
                                    esc;
                                    end;
                    end
                   else    // nessuna lingua scelta
                    if not Lingue.italy() then
                       begin
                       Evidenzia_selezione;
                       grafica;
                       pulisci1;
                       gotoxy(40-Lingue.get_length_txt(535) div 2,riga_menu+2);
                       write(Lingue.get_txt(535));  // 'Nessuna lingua ascelta. Ricaricare quella predefinita ?  [Italiano]'
                       if Tasti_SN(35,riga_menu+3)='S' then
                          begin
                          lingue.init;
                          cambia_lng_comune;
                          end;
                       end;
if lingue.italy() then file_lingua:=''
                  else if FExpand(pathOf(file_lingua))=FExpand(pathOf(paramstr(0))) then file_lingua:=nameOf(file_lingua);
if lingua_cambiata then
   begin
   Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Language'{nome_tipo},file_lingua{valore});
   Editor_Ini.Set_Modifica(true);
   end;
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure get_pragrafo_attuale_e_max(var p_att,p_max:longint); // ver 3.22
var i:longint;
    found:boolean;
begin
p_max:=0;
p_att:=0;
found:=false;
i:=1;
while i<=ymax do
         begin
         while (i<=ymax) and (testo[i]=#13) do
               begin
               inc(i);
               if i=iy then p_att:=p_max+1;
               end;
         while (i<=ymax) and (testo[i]<>#13) do
               begin
               inc(i);
               found:=true;
               if i=iy then p_att:=p_max+1;
               end;
         if found then
            begin
            inc(p_max);
            found:=false;
            end;
         end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function vai_al_paragrafo(paragrafo:longint):longint; // ver 3.22
var riga_start,riga_end,i:longint;   // ritorna la prima riga del paragrafo
begin
i:=1;
while (i<=ymax) and (paragrafo>0) do
      begin
      dec(paragrafo);
      while (i<=ymax) and (testo[i]=#13) do inc(i);
      riga_start:=i;
      while (i<=ymax) and (testo[i]<>#13) do
            begin
            inc(i);
            riga_end:=i;
            end;
      end;
if (testo[riga_start]<>#13)and(paragrafo=0) then
                                        begin
                                        result:=riga_start;
                                        selezionato.x1:=1;
                                        selezionato.y1:=riga_start;
                                        selezionato.x2:=length(testo[riga_end])-1;
                                        selezionato.y2:=riga_end;
                                        end
                                       else result:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure riga_piu_lunga(var riga:longint; var colonne:byte);   // ver 3.26
var i:longint;
begin
colonne:=0;
riga:=0;
for i:=1 to ymax do
    if colonne<length(testo[i])-1 then
       begin
       colonne:=length(testo[i])-1;
       riga:=i;
       end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Ricarica;   // ver 2.54 , 2.69
var old_next_length_TXT,old_next_length_ESA:integer;
begin
if not M_file__chiudi() then Exit;
old_next_length_TXT:=next_length_TXT;
old_next_length_ESA:=next_length_ESA;
menu_recenti(4); // riapro il primo file della lista dei recenti con anche le impostazioni salvate
next_length_TXT:=old_next_length_TXT;
next_length_ESA:=old_next_length_ESA;
end;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Cambia_numero_di_colonne;  // ver 3.26
var new_colonne:integer;
    riga:longint;
    colonne:byte;
{$define max_colonne:=254} // oppure const max_colonne=254;
label ricarica;
begin
da_a_graph;
gotoxy(1,riga_menu+3);
write(trim(Lingue.get_txt(546))+':');
riga_piu_lunga(riga,colonne);
if colonne=0 then colonne:=1;
gotoxy(71,riga_menu+3);
if colonne<10 then write('(min   '+IntToStr(colonne)+')')  // 'Numero colonne'
              else
if colonne<100 then write('(min  '+IntToStr(colonne)+')')  // 'Numero colonne'
              else  write('(min '+IntToStr(colonne)+')');  // 'Numero colonne'
gotoxy(71,riga_menu+4);
write('(max ',max_colonne,')');  // 'Numero colonne'
ShowMouse;
ShowMouse;
new_colonne:=lunghezza_riga;
Str_int(new_colonne,colonne,max_colonne);
if (new_colonne<>0)and(new_colonne<>lunghezza_riga) then
   if binario then
              begin
              ricarica:
              lunghezza_riga:=new_colonne;
              M_file__Ricarica;
              end
             else   // formato testo
              if new_colonne>=colonne then
                                      begin
                                      Annulla_Txt.input_iniziale(strnew(stringtopchar('1'+undo__x_prepara()+zero(inttostr(y),2)+zero(inttostr(iy),4)+'Y'+char(lunghezza_riga)+char(new_colonne) )));
                                      Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
                                      lunghezza_riga:=new_colonne;
                                      modifica_on;
                                      end
                                     else goto ricarica;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Informazioni_legali; // ver 3.28   GPL 3
var YY,MM,DD: Word;
begin
DeCodeDate(Date,YY,MM,DD);
HideMouse;
colore;
clrscr;
textcolor(yellow);
gotoxy(1,2);
writeln(' EDiTury   Ver ',ver,'      Today ',IntToStr(yy),'/',IntToStr(mm),'/',IntToStr(dd),invio);
writeln(' A program to read and write on Text and Hexadecimal format',invio);
writeln(' Copyright (C) '+IntToStr(yy)+' by Salvatore Licciardi',invio);
writeln(' Web ',web,'    eMail ',mail);
textcolor(white);
writeln('');
writeln('  This program is free software: you can redistribute it and/or modify it under');
writeln('  the terms of the GNU General Public License as published by the Free Software');
writeln('  Foundation, version 3 of the License.');
writeln('  This program is distributed in the hope  that it will be useful , but WITHOUT');
writeln('  ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS');
writeln('  FOR A PARTICULAR PURPOSE.');
writeln('  See the GNU General Public License for more details. You should have received');
writeln('  a copy of the GNU General Public License along with this program. If not, see');
writeln('  http://www.gnu.org/licenses/');
verticale:=2;   {obbligo l'aggiornamento della barra verticale}
ShowMouse;
Esc;
textbackground(black);
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
Evidenzia_selezione;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_speciale__Svuota_Appunti;  // ver 3.30
begin
Svuota_Appunti;
if sono_Appunti() then
   begin
   modifica_off;
   M_file__Chiudi();
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Informazioni_sul_File;  // ver 2.20
var size_delimitatore,c:byte;
    dt: DateTime;      {UnpackTime}
    F: SearchRec;
    str:string;
    i:longint;
    tot_new_byte:int64;
begin     {note sul file in uso}
HideMouse;
c:=yellow;
colore;
clrscr;
textcolor(lightred);
gotoxy(39-Lingue.get_length_txt(281) div 2,whereY);
writeln(Lingue.get_txt(281)); // 'Informazioni sul file in uso'
colore;
writeln;
{$ifdef Go32v2}
write(Lingue.get_txt(282)); // ' Nome lungo: '
{$else}
write(Lingue.get_txt(283)); // ' Nome : '
{$endif}
textcolor(c);
writeln(percorso+nomefile);
textcolor(white);
writeln;
{$ifdef Go32v2}
write(Lingue.get_txt(284));  // ' Nome corto: '
textcolor(c);
if short_name='' then
                 begin
                 short_name:=percorso+nomefile;
                 if not GetShortName(short_name) then short_name:='';
                 end;
writeln(short_name);
{$endif}
if binario then
   begin
   textcolor(white);
   write(Lingue.get_txt(285)); // ' Numero del blocco del file: '
   textcolor(c);
   writeln(dim_punto(tot));
   end;
textcolor(white);
write(Lingue.get_txt(277));  // ' Formato attuale per salvare: '
textcolor(c);
if binario then write(Lingue.get_txt(286)) else  // 'Esadecimale'
if salva_formato='T' then write(Lingue.get_txt(278)+' 8 bit') else
if salva_formato='L' then write('Unicode Little Endian 16 bit') else
if salva_formato='B' then write('Unicode Big Endian 16 bit') else
if salva_formato='U' then write('UTF-8');
textcolor(white);
writeln;
write(Lingue.get_txt(279));   // ' Formato del file aperto : '
textcolor(c);
if binario then write(Lingue.get_txt(286)) else  // 'Esadecimale'
if apri_formato='T' then write(Lingue.get_txt(278)+' 8 bit') else // Testo
if apri_formato='L' then write('Unicode Little Endian 16 bit') else
if apri_formato='B' then write('Unicode Big Endian 16 bit') else
if apri_formato='U' then write('UTF-8');
textcolor(white);
writeln;
write(Lingue.get_txt(287));  // ' Nomi di file lunghi supportati ? '
textcolor(c);
if lfnSupport then writeln(Lingue.get_txt(528))   // 'Si'
              else Writeln(Lingue.get_txt(39));   // 'No'
textcolor(white);
writeln;
write(Lingue.get_txt(288));  // ' Delimitatore di percorsi : '
textcolor(c);
writeln(PathDelim); // ver 3.00
textcolor(white);
write(Lingue.get_txt(289));  //  ' Delimitatore di fine riga (OS): '
textcolor(c);
for i:=1 to length(LineEnding) do write('#',ord(string(LineEnding)[i]),' ');
writeln;
textcolor(white);
write(Lingue.get_txt(576));  //  ' Delimitatore di fine riga in questo file: '
textcolor(c);
for i:=1 to length(get_delimitatore()) do write('#',ord(get_delimitatore()[i]),' ');
writeln;
FindFirst(percorso+nomefile, Anyfile, F);
textcolor(white);
write(Lingue.get_txt(290));  //  ' Byte attualmente occupati: '
textcolor(c);
if DosError=0 then if (f.attr and directory)<>0 then writeln('_')
                                                else writeln(Dim_punto(f.size))
              else writeln('?');
str:='';
textcolor(white);
write(Lingue.get_txt(291));  // ' Attributi: '
if DosError=0 then
   begin
   if (f.attr and archive)  <>0 then str:='A'     else str:='_';
   if (f.attr and readonly) <>0 then str:=str+'R' else str:=str+'_';
   if (f.attr and hidden)   <>0 then str:=str+'H' else str:=str+'_';
   if (f.attr and sysfile)  <>0 then str:=str+'S' else str:=str+'_';
   end
  else str:='???? ';
textcolor(c);
writeln(str);
textcolor(white);  // ver 2.54
write(' File Name Case Sensitive: ');
textcolor(c);
if FileNameCaseSensitive then writeln(Lingue.get_txt(528))  // 'Si'
                         else writeln(Lingue.get_txt(39));  // 'No'
textcolor(white);  // ver 2.69
write(Lingue.get_txt(292));  // ' Lunghezza massima della riga : '
textcolor(c);
writeln(lunghezza_riga);

UnpackTime(f.time,dt);
textcolor(white);
write(Lingue.get_txt(293)); // ' Data: '
textcolor(c);
if DosError=0 then
              begin
              str:='';
              if dt.day<10 then str:='0';
              str:=str+inttostr(dt.day)+'/';
              if dt.month<10 then str:=str+'0';
              str:=str+inttostr(dt.month)+'/';
              if dt.year<10 then str:=str+'0';
              str:=str+inttostr(dt.year);
              end
             else str:='??/??/????';
writeln(str);
textcolor(white);
write(Lingue.get_txt(294));  // ' Ora : '
if DosError=0 then
   begin
   str:='';
   if dt.hour<10 then str:='0';
   str:=str+inttostr(dt.hour)+':';
   if dt.min<10 then str:=str+'0';
   str:=str+inttostr(dt.min)+':';
   if dt.sec<10 then str:=str+'0';
   str:=str+inttostr(dt.sec);
   end
  else str:='??:??:??';
textcolor(c);
writeln(str);
if selezionato.x1<>0 then
   begin
   textcolor(white);
   write(Lingue.get_txt(295)); // ' Testo selezionato: '
   textcolor(c);
   if selezione_quadrata then writeln('Y:',selezionato.y1,', X:',min(selezionato.x1,selezionato.x2),' --> Y:',selezionato.y2,', X:',max(selezionato.x2,selezionato.x1))
                         else writeln('Y:',selezionato.y1,', X:',selezionato.x1,' --> Y:',selezionato.y2,', X:',selezionato.x2);
   end;
textcolor(white);
write(Lingue.get_txt(296)); // ' Numero del file aperto: '
textcolor(c);
writeln(dim_punto(posizione_file_attuale));
textcolor(white);
write(Lingue.get_txt(297)); // ' Numero di appunti in memoria: '
textcolor(c);
writeln(dim_punto(length(Appunti)));
textcolor(white);
write(Lingue.get_txt(574)); // ' File modificato: '
textcolor(c);
if modifica>0 then writeln(Lingue.get_txt(528))  // 'Si'
              else writeln(Lingue.get_txt(39));  // 'No'
textcolor(white);
write(Lingue.get_txt(577)); // ' Delimitatore di fine riga all''apertura del file : '
textcolor(c);
writeln(EOL_in_apertura);

if not binario then
   begin
   size_delimitatore:=length(get_delimitatore());
   tot_new_byte:=0;
   for i:=1 to ymax do tot_new_byte:=tot_new_byte+length(testo[i])-1+size_delimitatore;
   tot_new_byte:=tot_new_byte-size_delimitatore;
   case salva_formato of
      'T': ;
      'L': tot_new_byte:=tot_new_byte*2+2;
      'B': tot_new_byte:=tot_new_byte*2+2;
      'U': tot_new_byte:=tot_new_byte+3;
      end;
   textcolor(white);
   write(Lingue.get_txt(575)); // ' Byte usati in menmoria: '
   textcolor(c);
   writeln(dim_punto(tot_new_byte));
   end;

verticale:=2;   {obbligo l'aggiornamento della barra verticale}
ShowMouse;
ShowMouse;
Esc;
textbackground(black);
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,(riga_menu-2),blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,(riga_menu-2),white);
{$endif}
Evidenzia_selezione;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_nome_nuovo_file_bak(tmp_dir,the_nomefile:string):string;  // ver 3.40
var progressivo:longint;
    nome:string;
begin
progressivo:=-1;
tmp_dir:=fexpand2(tmp_dir);
if lfnsupport then the_nomefile:=NameOf(the_nomefile)
              else the_nomefile:=NameOf_No_Ext(the_nomefile);
if the_nomefile='' then the_nomefile:=Lingue.get_txt(467); // cioe' "Nuovo"
repeat
 inc(progressivo);
 nome:=tmp_dir+the_nomefile+'.'+intToStr(progressivo);
until exist(nome)=-1;
exit(nome);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure BackUp_automatico(cond:char; n:longint; the_binario:boolean; the_percorso,the_nomefile:string);   // ver 3.40
var nuovo_file{rimuovibile},la_riga_8_bit,s1,s2,s3,old_percorso,old_nomefile:string;
    i,attesa_minima,tot_byte,max_righe,j,ii,filehandle,NumWritten,now_secondi:longint;
    il_formato_per_salvare:char;
    error:boolean;
    size_byte:int64;
    Buf : Array [1..{lunghezza_riga}254*810{ymax}] of char;
begin
error:=false;
now_secondi:=secondi;
if the_binario then attesa_minima:=min_esa*60
               else attesa_minima:=min_txt*60;
case upcase(cond) of
     'A': begin  // backup su controllo continuo
          if n=-2 then    // "backup ora" del file a video
                  begin
                  if (secondi_last_modifica=secondi_last_backup)and(modifica=0) then exit;
                  n:=-1;
                  end else
          if n=-1 then    // n==-1 per indicare il file a video
                   if (secondi_last_backup+attesa_minima<now_secondi) and (secondi_last_modifica>secondi_last_backup) then
                                                                                                                      else exit
                  else
                   if (multi_file[n].secondi_last_backup+attesa_minima<now_secondi) and (multi_file[n].secondi_last_modifica>multi_file[n].secondi_last_backup) then
                                                                                                                                                                else exit;
          end;

     'B','C','D':
          begin
          case upcase(cond) of
              'B': ;                              // backup di tutti
              'C': if the_binario then Exit;      // gestione formato TXT
              'D': if not the_binario then Exit;  // gestione formato ESA
              end;
          if n=-1 then    // n==-1 per indicare il file a video
                   if ( (secondi_last_modifica>secondi_last_backup) and (modifica>1) ) or
                      ( (secondi_last_modifica=secondi_last_backup) and (modifica=1) ) then
                                                                                       else exit
                  else
                   if ( (multi_file[n].secondi_last_modifica>multi_file[n].secondi_last_backup) and (multi_file[n].modifica>1) ) or
                      ( (multi_file[n].secondi_last_modifica=multi_file[n].secondi_last_backup) and (multi_file[n].modifica=1) ) then
                                                                                                                                 else exit;
          end;
     end;
if n=-1 then max_righe:=ymax   // se n=-1  il file a video, altrimenti quello in memoria
        else max_righe:=multi_file[n].ymax;
if the_binario then   // binario
                begin
                old_nomefile:=nomefile;
                old_percorso:=percorso;
                nuovo_file:=get_nome_nuovo_file_bak(tmp_dir_esa,the_nomefile);
                if n<>-1 then
                         begin
                         nomefile:=multi_file[n].nomefile;
                         percorso:=multi_file[n].percorso;
                         end;
                size_byte:=exist(percorso+nomefile);
                if size_byte>-1 then    // file trovato
                                 begin
                                 // procedure Salva_con_Nome_Binario(nomefile_old,nomefile_new:string; start_byte,end_byte:int64);
                                 Salva_con_Nome_Binario(percorso+nomefile,nuovo_file,1,size_byte);
                                 filehandle:=FileOpen(percorso+nomefile,fmOpenWrite);
                                 if n=-1 then if FileSeek(filehandle,tot,0)<0 then error:=true;
                                 if n<>-1 then if FileSeek(filehandle,multi_file[n].tot,0)<0 then error:=true;
                                 end
                                else    // file non trovato
                                 begin
                                 error:=true;
                                 filehandle:=FileCreate(tmp_dir_esa+the_nomefile,fmOpenWrite);
                                 end;
                tot_byte:=0;
                for j:=1 to max_righe do
                    begin
                    if n=-1 then s1:=copy_end(testo[j],2)
                            else s1:=copy_end(multi_file[n].testo[j],2);
                    for ii:=1 to length(s1) do
                        begin
                        inc(tot_byte);
                        buf[tot_byte]:=s1[ii];
                        if tot_byte=length(buf) then
                           begin
                           NumWritten:=FileWrite(filehandle,buf,tot_byte);
                           if NumWritten<0 then error:=true;
                           tot_byte:=0;
                           end;
                        end;
                    end;
                NumWritten:=FileWrite(filehandle,buf,tot_byte);
                if NumWritten<0 then error:=true;
                FileClose(filehandle);
                Tast_Vuota;
                nomefile:=old_nomefile;
                percorso:=old_percorso;
                end
               else   // testo
                begin
                nuovo_file:=get_nome_nuovo_file_bak(tmp_dir_txt,the_nomefile);
                assign(filex,nuovo_file);
                {$i-}
                rewrite(filex);
                {$i+}
                if IOResult<>0 then error:=true;
                if n=-1 then il_formato_per_salvare:=salva_formato
                        else il_formato_per_salvare:=multi_file[n].salva_formato;
                case il_formato_per_salvare of
                     'U': begin
                          {$i-}
                          write(filex,intestazione_UTF);
                          {$i+}
                          if ioresult<>0 then error:=true;
                          end;
                     'B': begin
                          {$i-}
                          write(filex,intestazione_B);
                          {$i+}
                          if ioresult<>0 then error:=true;
                          end;
                     'L': begin
                          {$i-}
                          write(filex,intestazione_L);
                          {$i+}
                          if ioresult<>0 then error:=true;
                          end;
                     end;  //  case
                for j:=1 to max_righe do
                    begin
                    if n=-1 then la_riga_8_bit:=sostituisci_tab(copy_end(testo[j],2))
                            else la_riga_8_bit:=sostituisci_tab(copy_end(multi_file[n].testo[j],2));
                    s1:=copy(la_riga_8_bit,1,100);
                    if s1<>'' then
                       begin
                       {$i-}
                       write(filex,prepara_riga_testo(s1));
                       {$i+}
                       if ioresult<>0 then
                                      begin
                                      error:=true;
                                      break;
                                      end;
                       end;
                    s2:=copy(la_riga_8_bit,101,100);
                    if s2<>'' then
                       begin
                       {$i-}
                       write(filex,prepara_riga_testo(s2));
                       {$i+}
                       if ioresult<>0 then
                                      begin
                                      error:=true;
                                      break;
                                      end;
                       end;
                    s3:=copy_end(la_riga_8_bit,201);
                    if s3<>'' then
                       begin
                       {$i-}
                       write(filex,prepara_riga_testo(s3));
                       {$i+}
                       if ioresult<>0 then
                                      begin
                                      error:=true;
                                      break;
                                      end;
                       end;
                    if j<>max_righe then
                       begin
                       {$i-}
                       write(filex,prepara_riga_testo(get_delimitatore()));
                       {$i+}
                       if ioresult<>0 then
                                      begin
                                      error:=true;
                                      break;
                                      end;
                       end;
                    Tast_Vuota;
                    end;
                {$i-}
                close(filex);
                {$i+}
                if IOResult<>0 then error:=true;
                end;  // testo
if (upcase(cond) in ['B','C','D']) and (n=-1) and (not error) and (secondi_last_modifica=secondi_last_backup) and (modifica=1) then modifica:=2;
if (upcase(cond) in ['B','C','D']) and (n>=0) and (not error) and (multi_file[n].secondi_last_modifica=multi_file[n].secondi_last_backup) and (multi_file[n].modifica=1) then multi_file[n].modifica:=2;
now_secondi:=secondi()-now_secondi+1;
for i:=1 to get_numero_files() do
    begin
    multi_file[i].secondi_last_backup:=multi_file[i].secondi_last_backup+now_secondi;
    multi_file[i].secondi_last_modifica:=multi_file[i].secondi_last_modifica+now_secondi;
    end;
grafica;
info;
secondi_last_backup:=secondi_last_backup+now_secondi;
secondi_last_modifica:=secondi_last_modifica+now_secondi;
if n=-1 then
         begin
         secondi_last_backup:=secondi();
         secondi_last_modifica:=secondi_last_backup;
         end
        else multi_file[n].secondi_last_backup:=secondi();
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Salva_Copia__Crea_BackUp_Ora;  // ver 3.40
begin
BackUp_automatico('A',-2,binario,percorso,nomefile);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Salva_Copia__BackUp_generico(condizione:char);
var i:longint;
begin
BackUp_automatico(condizione,-1,binario,percorso,nomefile);
for i:=1 to get_numero_files() do  // gli altri file
    if multi_file[i].aperto and (i<>posizione_file_attuale) then BackUp_automatico(condizione,i,multi_file[i].binario,multi_file[i].percorso,multi_file[i].nomefile);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Salva_Copia__BackUp_di_tutti;  // ver 3.50
begin
M_File__Salva_Copia__BackUp_generico('B');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Salva_Copia__BackUp_di_solo_TXT; // ver 3.50
begin
M_File__Salva_Copia__BackUp_generico('C');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Salva_Copia__BackUp_di_solo_ESA; // ver 3.50
begin
M_File__Salva_Copia__BackUp_generico('D');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

begin
end.


{  non interfacciati

function  scrivi_rtf(nomefilex:shortstring):boolean;   // ver 2.96
function  scrivi_htm(nomefilex:shortstring):boolean;   // ver 2.77
function  get_riga_per_rtf(riga:longint):shortstring;  // ver 2.96
function  get_riga_per_htm(riga:longint):shortstring;  // ver 2.81
function  get_riga_per_xxx(riga:longint):shortstring;  // ver 2.81

function  Tasti_SNT(x1,y1:byte):char;        // update 3.02
function  Print_Now(mx:byte; k:char):char;   // update 2.10 , 3.02
function  converti_maiuscolo(s:string):string;  // ver 3.04
function  converti_minuscolo(s:string):string;  // ver 3.04
function  converti_iniziali_maiuscole(s:string):string;  // ver 3.04
function  converti_Invertito(s:string):string;  // ver 3.04
function  first_char(s:string; start:integer):integer;
function  converti_normale(s1,s2:string):string;  // ver 3.04
function  converti_Alternato(s:string):string;    // ver 3.04
function  converti_Spazi_Doppi(s:string):string;  // ver 3.13
procedure prepara_undo_formattato(originale:string; inizio,fine,attuale,c:integer); // ver 3.04
procedure Select2(k:char;x1,y1:byte);
procedure Menu_Formattato__formatta_testo(c:byte; speciale:boolean);  // ver 3.04
procedure M_speciale__Seleziona_Righe;  // ver 3.01
procedure riga_piu_lunga(var riga:longint; var colonne:byte);   // ver 3.26
function  get_nome_nuovo_file_bak(tmp_dir,the_nomefile:string):string;  // ver 3.40
procedure M_File__Salva_Copia__BackUp_generico(condizione:char);
}
