{**********************************************************************
Copyright (C) 2010 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit T_Edit20;   // richiede T_edit1x
{$MODE  ObjFpc}  // unit per l' Editor32 principalmente per la versione 2.00
{$MACRO On}
{$H+}  // longstring
{$I txt_mode.inc}

interface

uses Crt,SysUtils,Video,Dos,Math,Keyboard,
     {$ifdef Go32v2}
      MsMouse,Go32,
      {$else}
      Mouse,
     {$endif}
     {$ifdef TxtVideo}
      TxtVideo,Menu_Y_V,
     {$endif}
     {$ifdef TxtCrt}
      Menu_Y,
     {$endif}
     Altro32d,Altro32,LDU_PCH,
     type_var,T_edit1x;

procedure Crea_ListaX;
procedure Crea_ListaY;
procedure alt_menu;
procedure aspetto_Rilascio;
procedure ErrorTextMode_start;
procedure Salva_con_Nome_Binario(nomefile_old,nomefile_new:string; start_byte,end_byte:int64);  // ver 2.83
procedure Salva_con_Nome_Binario(nomefile_old:string; nomefile_new:string);
function  Errore_di_IO(i:integer):boolean;
function  CercaInFile(nomefile1,cerca1:string; reverse1,jolly1,mami1:boolean; start1,end_1:int64;
                      var posizione:int64{per la pausa}):int64;
function  punto_bak(s:string):string;
function  ask_crea_bak_esa:char;
function  Shift():boolean;
function  Testo_Vuoto:boolean;
procedure Error_Multi_Files;                          // ver 2.4
function  Destra(var riga:string):string;             // ver 1.xx
function  Centra(var testo:string):string;            // ver 1.xx
function  Tasto__Pag_Giu():boolean;                   // ver 1.xx
procedure M_opzioni__Informazioni_su_Editor;          // ver 1.xx
procedure CercaMaMi_Su;  {ignora Mai/Min verso sopra} // ver 1.xx
procedure SL_Error;                                   // ver 1.xx
procedure Tasto__Pag_Su;                              // ver 1.xx
procedure Sinistra(var testo:string);                 // ver 1.xx
procedure Giustifica(var testo:string); {Formattato}  // ver 1.xx
procedure Help;  //  opzione /? o -H                  // ver 1.xx
procedure Grafica;                                    // ver 1.xx menu basso
procedure Ingresso(var stringa:string; testo:string); // ver 1.xx per le stringhe nomefile
procedure Tasto__Back_Space(update_video:boolean);
function  FreeAnnulla(righe:longint):boolean;         // ver 1.80
function  influenza(c:char):boolean;                  // ver 1.85
procedure Undo__CL(var riga:string);                  // ver 1.8x
procedure Undo__Back_Space(var riga:string);          // ver 1.80
procedure Undo__Formattato_Centra(var riga:string);   // ver 1.80
procedure Undo__Formattato_Destra(var riga:string);   // ver 1.80
procedure Undo__Formattato_Sinistra(var riga:string); // ver 1.80
procedure Undo__Formattato_Giustifica(var riga:string);  // ver 1.80
procedure Undo__Invio(var riga:string);               // ver 1.80
procedure Undo__Scrivi(riga:string);                  // ver 1.80
procedure Undo__Insert(var riga:string);              // ver 1.80
procedure Undo__UnoS(var riga:string);                // ver 1.8x
procedure Undo__Mouse_CL(const riga:string);          // ver 1.8x
procedure Undo__Canc_UnoS(riga:string);               // ver 1.8x
procedure Undo__F1_F2(riga:string; ann:boolean);      // ver 1.83
procedure Undo__Tastiera;                             // ver 1.80
procedure Undo__Incolla_Riga(riga:string);            // ver 1.80
procedure Undo__Incolla_Righe(riga:string);           // ver 1.80
procedure Undo__Selezione(ann:boolean);               // ver 1.90 , update 2.25 , 3.15
procedure Undo__TE_Righe(riga:string; var first:boolean);     // ver 1.80
procedure Undo__TE_Selezione_Quadrata(var riga:string);       // ver 2.25
procedure Undo__TE_Selezione(riga:string; var first:boolean); // ver 1.80
procedure Undo__I_Esa;                                // ver 2.30
procedure Undo__TE_Esa(var riga:string);              // ver 2.31
function  Tasto__Invio(aggiorna_video:boolean=true):boolean;    // ver 3.15
procedure Recover(riga:string);                       // ver 1.80
procedure M_file__cancella;             // ver 2.10
procedure M_file__rinomina;             // ver 2.10
procedure Resoconto(i:integer);  {numero di sostituzioni}
procedure chk_move(ks:string);          // ver 2.10  se si sposta il cursore, l'annulla deve essere spezzato
procedure Abilita_Disabilita_Mouse;     // ver 2.10
function  fine_linea(var f:text):byte;  // ver 2.10
function  fine_file(var f:text):byte;   // ver 2.10
function  Error_Riapri_IN:boolean;            // ver 2.10
function  sostituisci_tab(s:string):string;   // ver 2.20
function  prepara_riga_testo(s:string):string;// ver 2.20 , 2.64
function  chk_tab_back_space():integer; // ver 2.20
function  chk_tab_canc():integer;       // ver 2.20
procedure M_opzioni__formato_salva_file;           // ver 2.20
procedure M_opzioni__Delimitatore_di_fine_riga;    // ver 2.20
{$ifndef Linux}
 procedure M_Stampa__Stampante;         // ver 2.20
{$endif}
procedure Open_Error6;                  // ver 2.21
procedure Tasto__Inizio;                // ver 2.25
procedure Tasto__Shift_Inizio;          // ver 2.25
procedure Tasto__Shift_Fine;            // ver 2.25
procedure Alt_F5;                       // ver 2.25
procedure CercaMaMi_Giu;                // ver 2.25
procedure M_opzioni__Configura2;                   // ver 2.25
function  get_posizione_cursore:longint;           // ver 2.25
function  get_posizione_fine_selezione:longint;    // ver 2.25
function  get_posizione_inizio_selezione:longint;  // ver 2.25
function  dentro_selezione:boolean;     // ver 2.25
function  Tasto__Fine():boolean;        // ver 2.25
function  non_selezione():boolean;      // ver 2.25
function  Tasto__Ctrl_Inizio():boolean; // posizionamento sul punto iniziale del testo (1,1)
function  Tasto__Ctrl_Pag_Giu():boolean;
procedure Tasto__Ctrl_Shift_Pag_Su;
procedure Non_Trovato(const nomefilex:string); // ver 2.00
procedure Tasto__Ctrl_Shift_Inizio;
procedure Tasto__Shift_Pag_Su;
procedure M_speciale__Taglia_Riga_Attuale(taglia:boolean; redo:boolean=true);
procedure M_modifica__Taglia_Selezione(taglia:boolean);
procedure Cerca_Sost(find:boolean);
procedure Anteprima_Cerca(find:boolean);
procedure Post_Sostituisci;
procedure Anteprima_Sostituisci;
procedure Conto(i:integer);  {numero di volte che una parola compare nel testo}
procedure pulisci_quadre;
procedure No_ASCII;
procedure lo_statoXY(const stato_:byte);
procedure Aggiorna2(const c:char);
procedure Aggiorna1(const c:char);
function  La_selezione:string;      // ver 1.90
function  is_last_block:boolean;    // ver 2.30
function  free_testo_esa:longint;   // ver 2.30
function  determina_tipo_annulla(ann:boolean):string;    // ver 2.25 , update 2.30
function  get_delimitatore():shortstring;   // ver 2.75

{ NON INTERFACCIATO
procedure   Cerca_per_riga; // ver 3.23
}

implementation

const size=4*1024;

var char_letti,start,end_:int64; // per la ricerca dentro il file binario
    letti:word;
    maschera,cerca:string;
    txt: array [1..size] of char;
    jolly,mami{ignora},reverse,first,tuttoletto:boolean;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Select(k:char;x1,y1:byte);
begin
cursorOff;
{$ifdef TxtCrt}
colore;
HideMouse;
case K of
 'e' : begin
       gotoxy(x1,y1);
       write('[');
       gotoxy(x1+6,y1);
       write(']');
       gotoxy(x1+7,y1);
       write(' ');
       gotoxy(x1+15,y1);
       write(' ');
       gotoxy(x,y);
       end;
 'p' : begin
       gotoxy(x1,y1);
       write(' ');
       gotoxy(x1+6,y1);
       write(' ');
       gotoxy(x1+7,y1);
       write('[');
       gotoxy(x1+15,y1);
       write(']');
       end;
end; {case}
ShowMouse;
{$endif}
{$ifdef TxtVideo}
dec(x1);
dec(y1);
case K of
 'e' : begin
       outtextxy(x1+7,y1,' ',255,blue,white);
       outtextxy(x1+15,y1,' ',255,blue,white);
       outtextxy(x1,y1,'[',255,blue,white);
       outtextxy(x1+6,y1,']',255,blue,white);
       gotoxy(x,y);
       end;
 'p' : begin
       outtextxy(x1+7,y1,'[',255,blue,white);
       outtextxy(x1+15,y1,']',255,blue,white);
       outtextxy(x1,y1,' ',255,blue,white);
       outtextxy(x1+6,y1,' ',255,blue,white);
       gotoxy(x,y);
       end;
  end; {case}
updatescreen(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasti_Esc_Pausa(x1,y1:byte;c:char);  // ver 2.00
begin
{$ifdef TxtCrt}
HideMouse;
textcolor(red);
textbackground(7);
gotoxy(x1+1,y1);
write(Lingue.get_txt(151));  //  '<esc>  <Pausa>'
colore;
gotoxy(x1+6,y1);
write('  ');
{$endif}
{$ifdef TxtVideo}
forceupdatexy(0,riga_menu,ScreenWidth*3);
outtextxy(x1,y1-1,Lingue.get_txt(151),0,7,red);   //  '<esc>  <Pausa>'
outtextxy(x1+5,y1-1,'  ',0,blue,white);
updatescreen(false);
{$endif}
cursorOff;
Select(c,x1,y1);
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Errore_di_IO(i:integer):boolean;   // ver 2.00
begin
hidemouse;
gotoxy(1,riga_menu+2);
write('                                                                          ');
gotoxy(1,riga_menu+3);
write('                                                                           ');
gotoxy(1,riga_menu+3);
case i of
     1: write(Lingue.get_txt(152));  //  '  Errore in lettura. Riprovare ?'
     2: write(Lingue.get_txt(153));  //  'Errore in scrittura. Riprovare ?'
     end;
gotoxy(18,riga_menu+4);
write('                                    ');
{$ifdef TxtVideo}
updatescreen(false);   // ver 3.40
{$endif}
Exit(Tasti_SN(35,riga_menu+3)='S');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function CaricaTesto(var c:char; filehandle:longint):byte;
var xxx:longint;
label r1,r2;
begin
CaricaTesto:=0;  // 0=OK   1=Bad
start:=start+size;
if first=false then
                begin
                start:=start-length(cerca)+1;
                char_letti:=char_letti-length(cerca)+1;
                end
               else first:=false;
r1:
if FileSeek(filehandle,start,0)<0 then
               if Errore_di_IO(1) then
                                  begin
                                  gotoxy(1,riga_menu+3);
                                  clreol;
                                  Tasti_Esc_Pausa(33,riga_menu+2,c);
                                  goto r1;
                                  end
                                 else
                                  Exit(1);
letti:=0;
r2:
xxx:=FileRead(filehandle, txt, SizeOf(txt) );
if xxx<0 then
         if Errore_di_IO(1) then
                            begin
                            gotoxy(1,riga_menu+3);
                            clreol;
                            Tasti_Esc_Pausa(33,riga_menu+2,c);
                            goto r2;
                            end
                           else
                            Exit(1);
letti:=letti+xxx;
char_letti:=char_letti+xxx;
if char_letti>=end_ then tuttoletto:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function CaricaTestoReverse(var c:char; filehandle:longint):byte; // 0=OK   1=Bad
var rimasti,xxx:longint;
label r1,r2;
begin
CaricaTestoReverse:=0;
if first=false then end_:=end_+length(cerca)-1
               else first:=false;
if end_<0 then
   begin
   tuttoletto:=true;
   Exit;
   end;
end_:=end_-size;
start:=start+size;
if end_<start then
   begin
   end_:=end_+size;
   rimasti:=end_-start;
   end_:=start;
   end
  else rimasti:=size+1;
r1:
if FileSeek(filehandle,end_,0)<0 then
               if Errore_di_IO(1) then
                                  begin
                                  gotoxy(1,riga_menu+3);
                                  clreol;
                                  Tasti_Esc_Pausa(33,riga_menu+2,c);
                                  goto r1;
                                  end
                                 else
                                  Exit(1);
start:=start-size;
letti:=0;
r2:
xxx:=FileRead(filehandle, txt, SizeOf(txt) );
if xxx<0 then
         if Errore_di_IO(1) then
                            begin
                            gotoxy(1,riga_menu+3);
                            clreol;
                            Tasti_Esc_Pausa(33,riga_menu+2,c);
                            goto r2;
                            end
                           else
                            Exit(1);

letti:=letti+xxx;
rimasti:=rimasti-xxx;
if rimasti<=0 then tuttoletto:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Preleva(ii:longint):string;
var maschera:string;
    i:longint;
begin
maschera:='';
for i:=ii to length(cerca)+ii-1 do maschera:=maschera+txt[i];
preleva:=maschera;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function PrelevaReverse(ii:longint):string;
var maschera:string;
    i:longint;
begin
maschera:='';
for i:=letti-ii+1 downto letti-ii+1+1-length(cerca) do maschera:=txt[i]+maschera;
prelevaReverse:=maschera;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function CercaInFile(nomefile1,cerca1:string; reverse1,jolly1,mami1:boolean; start1,end_1:int64; var posizione:int64):int64;
var s,size_file2:string;
    letture:byte;
    size_file:int64;
    filehandle,i:longint;
    cliccato:boolean;
    e:word;
    c:char;
label r1;
begin
cerca:=cerca1;
reverse:=reverse1;
jolly:=jolly1;
mami:=mami1;
end_:=end_1;
start:=start1;
if jolly and (pos('?',cerca)=0) then jolly:=false;
if mami then cerca:=UpStr(cerca);

first:=true;
tuttoletto:=false;
r1:
size_file:=Exist(nomefile1);
if size_file=-1 then
                if Errore_di_IO(1) then
                                   begin
                                   gotoxy(1,riga_menu+3);
                                   clreol;
                                   goto r1;
                                   end
                                  else
                                   Exit(-5);
if (end_<>1)and(end_>size_file) then Exit(-3);
if end_=-1 then end_:=size_file;
end_1:=end_;
if end_<start then Exit(-4);
if start<1 then Exit(-2);
start:=start1-1;
filehandle:=FileOpen(nomefile1,fmOpenRead);
if filehandle<0 then Exit(-5);
c:='e';
Tasti_Esc_Pausa(33,riga_menu+2,c);
char_letti:=start;
start:=start-size;
size_file2:=dim_punto(size_file);
letture:=127;
repeat
 if reverse then i:=CaricaTestoReverse(c,filehandle)
            else i:=CaricaTesto(c,filehandle);   {normale letti/start/txt}
 inc(letture);
 if letture=128 then
     begin
     letture:=0;
     gotoxy(1,riga_menu+4);
     if reverse then write(Lingue.get_txt(154),dim_punto(end_),' (',trunc( (real(end_1-end_) / end_1)*100),'%) ')  // 'Byte rimasti '
                else write('Byte ',dim_punto(start+letti),' / ',size_file2,' (',99+integer(trunc( real(start+letti-size_file) / size_file*100)),'%)');
     cursorBig;
     end;
 if mami then for e:=1 to letti do txt[e]:=UpCase(txt[e]);
 if i<>0 then
    begin
    CercaInFile:=-5;
    if reverse then posizione:=end_
               else posizione:=start;
    FileClose(filehandle);
    end;
 if (PollKeyEvent<>0) then
         begin
         s:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
         if (pos('SHIFT ',s)<>0)and(length(s)=7) then s:=upcase(s[7]);
         if from_alt_to_char(s)<>#0 then s:=from_alt_to_char(s);
         if length(s)=1 then s:=upcase(s);
         if (s='P') then
                    begin  // Pausa          {ALT+P}
                    if reverse then posizione:=end_
                               else posizione:=start;
                    FileClose(filehandle);
                    Exit(-7);
                    end else
         if (s='Up')or(s='Down')or(s='Left')or(s='Right') then
                    begin
                    if c='e' then c:='p'
                             else if c='p' then c:='e';
                    Select(c,33,riga_menu+2);
                    end else
         if (s=#13)or(s=#32) then
                    begin
                    case c of
                       'e': begin
                            FileClose(filehandle);
                            Exit(-6);
                            end;
                       'p': begin
                            if reverse then posizione:=end_
                                       else posizione:=start;
                            FileClose(filehandle);
                            Exit(-7);
                            end;
                       end;   // del case
                    end else
         if (s=#9) then
                  begin
                  if c='e' then c:='p'
                           else if c='p' then c:='e';
                  Select(c,33,riga_menu+2);
                  end else
         if (s=#27) then
                  begin
                  FileClose(filehandle);
                  Exit(-6);
                  end;
        end
       else if topo then  // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=riga_menu+2) then
           begin
           if (mox>40) and (mox<48) then
                  begin  // Pausa
                  if reverse then posizione:=end_
                             else posizione:=start;
                  FileClose(filehandle);
                  Exit(-7);
                  end;
           if (mox>33) and (mox<39) then
                                    begin
                                    FileClose(filehandle);
                                    Exit(-6);
                                    end;
           end;
        end;
 for i:=1 to letti-length(cerca)+1 do
        begin
        if reverse then maschera:=prelevaReverse(i)
                   else maschera:=preleva(i);
        if Jolly then for e:=1 to length(maschera) do if cerca[e]='?' then maschera[e]:='?';
        if maschera=cerca then
                          begin
                          if start+i>end_-length(cerca)+1 then
                                                          begin
                                                          if tuttoletto and (i>=size) then Break;
                                                          Continue;
                                                          end;
                          if reverse then
                                     if end_1<end_-i+letti-length(cerca)+2 then
                                                                           begin
                                                                           if tuttoletto and (i>=size) then Break;
                                                                           Continue;
                                                                           end
                                                                          else CercaInFile:=end_-i+letti-length(cerca)+2
                                     else CercaInFile:=start+i;
                          FileClose(filehandle);
                          Exit;
                          end;
        end;
 if tuttoletto then Break;
until false;
CercaInFile:=-1;
FileClose(filehandle);
end;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Percentuale(const somma,tot:int64); // ver 2.00
var stringa:string;
begin
gotoxy(1,riga_menu+3);
if tot>0 then stringa:=Lingue.get_txt(155)+dim_punto(somma)+' / '+dim_punto(tot)+' bytes  ('+IntToStr(Trunc(100+real(somma-tot)/tot*100))+'%)'  // 'Scritti '
         else stringa:=Lingue.get_txt(155)+'0 / 0 bytes  (100%)';
while length(stringa)<79 do stringa:=stringa+' ';
write(stringa);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Pausa_copia:boolean;  // ver 2.00
begin
hidemouse;
gotoxy(1,riga_menu+2);
write('                                                                          ');
gotoxy(1,riga_menu+3);
write('                                                                          ');
gotoxy(32-Lingue.get_length_txt(156),riga_menu+3);
write(Lingue.get_txt(156));  //  'Copia in pausa. Continuare ?'
Pausa_copia:=('S'=Tasti_SN(35,riga_menu+3));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Annulla_copia:boolean;  // ver 2.00
begin
{$ifdef TxtCrt}
hidemouse;
gotoxy(1,riga_menu+2);
write('                                                                          ');
gotoxy(40-Lingue.get_length_txt(157) div 2,riga_menu+2);
write(Lingue.get_txt(157));   // 'Copia annullata dall' utente'
gotoxy(40-Lingue.get_length_txt(158),riga_menu+3);
write(Lingue.get_txt(158));   // 'Cancellare il file ?'
{$endif}
{$ifdef TxtVideo}
outtextxy(0,riga_menu  ,'                                                                                 ',0,blue,white);
outtextxy(0,riga_menu+1,'                                                                          ',0,blue,white);
outtextxy(39-Lingue.get_length_txt(157) div 2,riga_menu+1,Lingue.get_txt(157),0,blue,white);  // 'Copia annullata dall' utente'
outtextxy(0,riga_menu+2,'                                                                          ',0,blue,white);
outtextxy(39-Lingue.get_length_txt(158),riga_menu+2,Lingue.get_txt(158),0,blue,white);  // 'Cancellare il file ?'
forceupdatexy(0,riga_menu+1,ScreenWidth*2);
updatescreen(false);
{$endif}
Exit(Tasti_SN(35,riga_menu+3)='S');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_con_Nome_Binario(nomefile_old:string; nomefile_new:string);
begin
Salva_con_Nome_Binario(nomefile_old,nomefile_new,1,file_size_byte);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_con_Nome_Binario(nomefile_old,nomefile_new:string; start_byte,end_byte:int64);
var filehandle_from,filehandle_to,NumRead,NumWritten: longint;
    Buf: array[1..4096] of Char;             // ver 2.00 , update 2.87
    tmp,somma,tot:int64;
    c:char;
    s:string;
    cliccato:boolean;
label r1,r2,r3,r4,r5,r6,pausa,esc;
begin
IOF:=false;
colore;
somma:=0;
tmp:=257000;
gotoxy(1,riga_menu+2);  // informazioni di 'sostituire ?'  nascosti
clreol;
gotoxy(1,riga_menu+4);
clreol;
c:='e';
Tasti_Esc_Pausa(33,riga_menu+2,c);
tot:=end_byte-start_byte+1;
r1:
filehandle_from:=FileOpen(nomefile_old,fmOpenRead);
if filehandle_from<0 then
   if Errore_di_IO(1) then goto r1
                      else goto r5;
r6:
if FileSeek(filehandle_from,start_byte-1,0)<0 then
   if Errore_di_IO(1) then goto r6
                      else goto r5;
r2:
filehandle_to:=FileCreate(nomefile_new,fmOpenWrite);
if filehandle_to<0 then
   if Errore_di_IO(2) then goto r2
                      else
                       begin
                   r5: percorso:=pathOf(nomefile_old);
                       nomefile:=nameOf(nomefile_old);
                       fileclose(filehandle_from);
                       fileclose(filehandle_to);
                       Exit;
                       end;
repeat
 if tmp>256000 then
               begin
               Percentuale(somma,tot);
               tmp:=0;
               end;
 r3:
 NumRead:=FileRead(filehandle_from,buf, SizeOf(Buf));
 if NumRead<0 then
    if Errore_di_IO(1) then
                       begin
                       Percentuale(somma,tot);
                       goto r3;
                       end
                      else
                       goto esc;
 if somma+NumRead>tot then
    begin
    NumRead:=tot-somma;
    if NumRead=0 then Break;
    end;
 r4:
 NumWritten:=FileWrite(filehandle_to, Buf, NumRead);
 sleep(5);
 if NumWritten<0 then
    if Errore_di_IO(2) then
                       begin
                       Percentuale(somma,tot);
                       goto r4
                       end
                      else
                       goto esc;
 somma:=somma+numWritten;
 tmp:=tmp+numWritten;
 if (PollKeyEvent<>0) then
         begin
         s:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
         if (pos('SHIFT ',s)<>0)and(length(s)=7) then s:=s[7];
         if from_alt_to_char(s)<>#0 then s:=from_alt_to_char(s);
         if length(s)=1 then s:=upcase(s);
         if (s='P') then
                    begin  // Pausa    {ALT+P}
                    pausa:
                    if Pausa_copia then
                                   begin
                                   Tasti_Esc_Pausa(33,riga_menu+2,c); // ripristino grafica
                                   tmp:=257000;
                                   end
                                  else
                                   begin
                                   esc:
                                   FileClose(filehandle_from);
                                   FileClose(filehandle_to);
                                   if Annulla_copia then DeleteFile(nomefile_new);  // elimino il file ?
                                   IOF:=true; // operazione annullata, ma correttamente
                                   percorso:=pathOf(nomefile_old);
                                   nomefile:=nameOf(nomefile_old);
                                   Exit;
                                   end;
                    end else
         if (s='Up')or(s='Down')or(s='Left')or(s='Right') then
                    begin
                    if c='e' then c:='p'
                             else if c='p' then c:='e';
                    Select(c,33,riga_menu+2);
                    end else
         if (s=#13)or(s=#32) then
                    begin
                    if c='e' then goto esc;
                    if c='p' then goto pausa;
                    end else
         if s=#9 then
                 begin
                 if c='e' then c:='p'
                          else if c='p' then c:='e';
                 Select(c,33,riga_menu+2);
                 end else
         if s=#27 then goto esc;
         end
       else if topo then { not keypressed }
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=riga_menu+2) then
           begin
           if (mox>39) and (mox<47) then goto pausa;
           if (mox>32) and (mox<38) then goto esc;
           end;
        end;
until (NumRead = 0);
FileClose(filehandle_from);
FileClose(filehandle_to);
nomefile:=nameOf(nomefile_new);
percorso:=pathOf(nomefile_new);
IOF:=true; // salvataggio avvenuto correttamente
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Crea_ListaX;    // 2.00
begin
ListaX.init(ScreenWidth,ScreenHeight);
ListaX.topo:=topo;
ListaX.Fine_Riga:=true;
ListaX.x:=2;
ListaX.y:=riga_menu+1;
ListaX.controllo:=true;
ListaX.Nuovoelemento(Lingue.get_txt(169),ord(Lingue.get_char(169)),true);  {torna la posizione dove inserito}
ListaX.Nuovoelemento(Lingue.get_txt(159),ord(Lingue.get_char(159)),true);  // 'Modifica'
ListaX.Nuovoelemento(Lingue.get_txt(160),ord(Lingue.get_char(160)),true);  // 'Cerca'
ListaX.Nuovoelemento(Lingue.get_txt(161),ord(Lingue.get_char(161)),true);  // 'Formattato'
ListaX.Nuovoelemento(Lingue.get_txt(162),ord(Lingue.get_char(162)),true);  // 'Speciale'
ListaX.Nuovoelemento(Lingue.get_txt(163),ord(Lingue.get_char(163)),true);  // 'Opzioni'
ListaX.Nuovoelemento(Lingue.get_txt(164),ord(Lingue.get_char(164)),true);  // 'Visualizza'
ListaX.Nuovoelemento(Lingue.get_txt(165),ord(Lingue.get_char(165)),false); // 'Recenti'   // all'inizio non vi sono file chiusi
ListaX.txt_Color_Veloce:=lightred;
ListaX.bk_color:=blue;
ListaX.txt_color:=yellow;
ListaX.txt_color_selezione:=white;
ListaX.bk_selezione:=green;
ListaX.txt_Color_Selezione_Disabilitato:=7;
ListaX.mancino:=mancino;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Crea_ListaY;  // ver 2.00 , 2.10 , 2.40 , 2.69 , 2.77
var i:byte;
begin
ListaY[1].init(max_larghezza-5{ScreenWidth},ScreenHeight);
ListaY[1].topo:=topo;
ListaY[1].controllo:=true;
ListaY[1].txt_ColorVeloce:=lightred;
ListaY[1].txt_ColorRigaSelezionata:=white;
ListaY[1].bk_color:=blue;
ListaY[1].txt_ColorCornice:=white;
ListaY[1].txt_ColorRiga:=yellow;
ListaY[1].bk_selezione:=green;
ListaY[1].mancino:=mancino;
for i:=2 to length(ListaY) do ListaY[i]:=ListaY[1];

// FILE
ListaY[1].NuovaRiga(Lingue.get_txt(166),Lingue.get_charB(166)); // ' Nuovo           > ' N {torna la posizione dove inserito}
ListaY[1].NuovaRiga(Lingue.get_txt(167),Lingue.get_charB(167)); // ' Apri... ' A
ListaY[1].NuovaRiga(Lingue.get_txt(168),Lingue.get_charB(168)); // ' Ricarica ' R
ListaY[1].NuovaRiga('',1);
ListaY[1].NuovaRiga(Lingue.get_txt(170),Lingue.get_charB(170)); // ' Salva ' l
ListaY[1].NuovaRiga(Lingue.get_txt(171),Lingue.get_charB(171)); // ' Salva con nome... ' S
ListaY[1].NuovaRiga(Lingue.get_txt(172),Lingue.get_charB(172)); // ' Salva tutti ' v
ListaY[1].NuovaRiga(Lingue.get_txt(173),Lingue.get_charB(173)); // ' Chiudi ' h
ListaY[1].NuovaRiga(Lingue.get_txt(174),Lingue.get_charB(174)); // ' Chiudi tutti ' u
ListaY[1].NuovaRiga('',1);
ListaY[1].NuovaRiga(Lingue.get_txt(175),Lingue.get_charB(175)); // ' Cancella ' C
ListaY[1].NuovaRiga(Lingue.get_txt(176),Lingue.get_charB(176)); // ' Salva copia     > ' p
ListaY[1].NuovaRiga(Lingue.get_txt(177),Lingue.get_charB(177)); // ' Rinomina ' m
ListaY[1].NuovaRiga('',1);
ListaY[1].NuovaRiga(Lingue.get_txt(178),Lingue.get_charB(178)); // ' Command Shell ' d
ListaY[1].NuovaRiga(Lingue.get_txt(179),Lingue.get_charB(179)); // ' Converti        > ' o
ListaY[1].NuovaRiga(Lingue.get_txt(180),Lingue.get_charB(180)); // ' Stampa          > ' t
ListaY[1].Selezionabile(17,{$ifndef linux} true {$else} false {$endif});
ListaY[1].NuovaRiga(Lingue.get_txt(181),Lingue.get_charB(181));  // ' Esci ' E
//MODIFICA
ListaY[2].NuovaRiga(Lingue.get_txt(182),Lingue.get_charB(182));  // ' Annulla     Alt+BackSpace ' A
ListaY[2].NuovaRiga(Lingue.get_txt(183),Lingue.get_charB(183));  // ' Ripristina ' R
ListaY[2].NuovaRiga('',1);
ListaY[2].NuovaRiga(Lingue.get_txt(184),Lingue.get_charB(184));  // ' Seleziona tutto ' S
ListaY[2].NuovaRiga(Lingue.get_txt(185),Lingue.get_charB(185));  // ' Deseleziona     Shift+Esc ' D
ListaY[2].NuovaRiga('',1);
ListaY[2].NuovaRiga(Lingue.get_txt(186),Lingue.get_charB(186));  // ' Taglia         Shift+Canc ' T
ListaY[2].NuovaRiga(Lingue.get_txt(187),Lingue.get_charB(187));  // ' Copia            Ctrl+Ins ' C
ListaY[2].NuovaRiga(Lingue.get_txt(188),Lingue.get_charB(188));  // ' Incolla ultimo  Shift+Ins ' I
ListaY[2].NuovaRiga(Lingue.get_txt(189),Lingue.get_charB(189));  // ' Incolla lista      Ctrl+v '
ListaY[2].NuovaRiga(Lingue.get_txt(190),Lingue.get_charB(190));  // ' Elimina         Ctrl+Canc '
ListaY[2].NuovaRiga('',1);
ListaY[2].NuovaRiga(Lingue.get_txt(549),Lingue.get_charB(549));  // ' Mostra Appunti ' // ver 3.28
//CERCA
ListaY[3].NuovaRiga(Lingue.get_txt(191),Lingue.get_charB(191));  // ' Vai... ' V
ListaY[3].NuovaRiga(Lingue.get_txt(192),Lingue.get_charB(192));  // ' Trova... ' T
ListaY[3].NuovaRiga(Lingue.get_txt(193),Lingue.get_charB(193));  // ' Ripeti Trova         F3 ' i
ListaY[3].NuovaRiga(Lingue.get_txt(194),Lingue.get_charB(194));  // ' Sostituisci... ' S
ListaY[3].NuovaRiga(Lingue.get_txt(195),Lingue.get_charB(195));  // ' Ripeti Sostituisci   F4 ' p
//FORMATTATO
ListaY[4].NuovaRiga(Lingue.get_txt(196),Lingue.get_charB(196));  // ' ... Selezione ' e
ListaY[4].NuovaRiga(Lingue.get_txt(197),Lingue.get_charB(197));  // ' ... Paragrafo attuale ' p
ListaY[4].NuovaRiga(Lingue.get_txt(198),Lingue.get_charB(198));  // ' ... Riga attuale ' l
ListaY[4].NuovaRiga(Lingue.get_txt(199),Lingue.get_charB(199));  // ' ... Parola attuale ' t
ListaY[4].NuovaRiga(Lingue.get_txt(200),Lingue.get_charB(200));  // ' ... Da riga a riga ' r
ListaY[4].NuovaRiga('',1);
ListaY[4].NuovaRiga(Lingue.get_txt(201),Lingue.get_charB(201));  // ' Maiuscolo ' a
ListaY[4].NuovaRiga(Lingue.get_txt(202),Lingue.get_charB(202));  // ' Minuscolo ' i
ListaY[4].NuovaRiga(Lingue.get_txt(203),Lingue.get_charB(203));  // ' Iniziali maiuscole ' z
ListaY[4].NuovaRiga(Lingue.get_txt(204),Lingue.get_charB(204));  // ' Invertito ' v
ListaY[4].NuovaRiga(Lingue.get_txt(205),Lingue.get_charB(205));  // ' Alternato Mai/Min ' n
ListaY[4].NuovaRiga(Lingue.get_txt(206),Lingue.get_charB(206));  // ' Normale ' m
ListaY[4].NuovaRiga(Lingue.get_txt(207),Lingue.get_charB(207));  // ver 3.13  ' Togli spazi doppi ' d
ListaY[4].NuovaRiga('',1);
ListaY[4].NuovaRiga(Lingue.get_txt(208),Lingue.get_charB(208));  // ' Sinistra ' S
ListaY[4].NuovaRiga(Lingue.get_txt(209),Lingue.get_charB(209));  // ' Destra ' D
ListaY[4].NuovaRiga(Lingue.get_txt(210),Lingue.get_charB(210));  // ' Centra ' C
ListaY[4].NuovaRiga(Lingue.get_txt(211),Lingue.get_charB(211));  // ' Giustificato ' G
// SPECIALE
ListaY[5].NuovaRiga(Lingue.get_txt(212),Lingue.get_charB(212));  // ' ... Paragrafo attuale ' P
ListaY[5].NuovaRiga(Lingue.get_txt(213),Lingue.get_charB(213));  // ' ... Riga attuale ' R
ListaY[5].NuovaRiga(Lingue.get_txt(214),Lingue.get_charB(214));  // ' ... Parola attuale ' l
ListaY[5].NuovaRiga(Lingue.get_txt(215),Lingue.get_charB(215));  // ver 3.03 ' ... Da riga a riga ' D
ListaY[5].NuovaRiga('',1);
ListaY[5].NuovaRiga(Lingue.get_txt(216),Lingue.get_charB(216));  // ' Taglia ' T
ListaY[5].NuovaRiga(Lingue.get_txt(217),Lingue.get_charB(217));  // ' Copia ' C
ListaY[5].NuovaRiga(Lingue.get_txt(218),Lingue.get_charB(218));  // ' Elimina ' E
ListaY[5].NuovaRiga(Lingue.get_txt(219),Lingue.get_charB(219));  // ver 3.01 ' Seleziona ' S
ListaY[5].NuovaRiga('',1);
ListaY[5].NuovaRiga(Lingue.get_txt(220),Lingue.get_charB(220));  // ' Incolla in riga... ' I
ListaY[5].NuovaRiga(Lingue.get_txt(221),Lingue.get_charB(221));  // ver 3.14  ' Incolla tutto in riga... ' g
ListaY[5].NuovaRiga(Lingue.get_txt(222),Lingue.get_charB(222));  // ver 3.14  ' Incolla tutto ' o
ListaY[5].NuovaRiga(Lingue.get_txt(554),Lingue.get_charB(554));  // ver 3.30  ' Svuota appunti '
//OPZIONI
ListaY[6].NuovaRiga(Lingue.get_txt(223),Lingue.get_charB(223));  // ver 2.75
ListaY[6].NuovaRiga(Lingue.get_txt(224),Lingue.get_charB(224));  // ver 2.20 ' Delimitatore di riga ' D
ListaY[6].NuovaRiga(Lingue.get_txt(225),Lingue.get_charB(225));  // ver 2.20 ' Formato salva file ' l
ListaY[6].NuovaRiga(Lingue.get_txt(226),Lingue.get_charB(226));  // ' Velocita''' V
ListaY[6].Selezionabile(4,{$ifdef Go32v2} true {$else} false {$endif});
ListaY[6].NuovaRiga(Lingue.get_txt(227),Lingue.get_charB(227));  // ' Memoria      Shift+Tab ' M
ListaY[6].NuovaRiga(Lingue.get_txt(228),Lingue.get_charB(228));  // ' Tabella ASCII ' A
ListaY[6].NuovaRiga('');
ListaY[6].NuovaRiga(Lingue.get_txt(229),Lingue.get_charB(229));  // ' Salva configurazione ' S
ListaY[6].NuovaRiga(Lingue.get_txt(230),Lingue.get_charB(230));  // ' Salva config. in ... ' n
ListaY[6].NuovaRiga(Lingue.get_txt(231),Lingue.get_charB(231));  // ' Config. predefinita ' p
ListaY[6].NuovaRiga(Lingue.get_txt(232),Lingue.get_charB(232));  // ' Configura 1 ' 1
ListaY[6].NuovaRiga(Lingue.get_txt(233),Lingue.get_charB(233));  // ' Configura 2 ' 2
ListaY[6].NuovaRiga(Lingue.get_txt(234),Lingue.get_charB(234));  // ' Configura 3 ' 3
ListaY[6].NuovaRiga(Lingue.get_txt(235),Lingue.get_charB(235));  // ver 3.20  ' Cambia lingua... ' g
ListaY[6].NuovaRiga('');
ListaY[6].NuovaRiga(Lingue.get_txt(236),Lingue.get_charB(236));  // ' Informazioni sul file ' f
ListaY[6].NuovaRiga(Lingue.get_txt(237),Lingue.get_charB(237));  // ' Informazioni su Editor ' I
ListaY[6].NuovaRiga(' ? - Info ',byte('?'));                     // ' ? - Info ' ?  ver 3.28

ListaY[1].x:=2;
ListaY[2].x:=8;
ListaY[3].x:=ListaY[2].x+lingue.get_length_txt(159)+2;
ListaY[4].x:=ListaY[3].x+lingue.get_length_txt(160)+2;
ListaY[5].x:=ListaY[4].x+lingue.get_length_txt(161)+2;
ListaY[6].x:=ListaY[5].x+lingue.get_length_txt(162)+2;
ListaY[7].x:=ListaY[6].x+lingue.get_length_txt(163)+2;
ListaY[8].x:=ListaY[7].x+lingue.get_length_txt(164)+2;
for i:=1 to ListaX.NumElementi do ListaY[i].y:=ListaX.y-ListaY[i].NumElementi-2;
//STAMPA : e' dentro FILE
ListaY[9].NuovaRiga(Lingue.get_txt(238),Lingue.get_charB(238)); // ' Stampante ' m
ListaY[9].NuovaRiga(Lingue.get_txt(239),Lingue.get_charB(239)); // ' N Copie ' C
ListaY[9].NuovaRiga(Lingue.get_txt(240),Lingue.get_charB(240)); // ' Tutto '  T
ListaY[9].NuovaRiga(Lingue.get_txt(241),Lingue.get_charB(241)); // ' Selezione ' S
ListaY[9].NuovaRiga(Lingue.get_txt(242),Lingue.get_charB(242)); // ' Righe... ' R
ListaY[9].NuovaRiga(Lingue.get_txt(243),Lingue.get_charB(243)); // ' Fogli... ' F
ListaY[9].NuovaRiga(Lingue.get_txt(244),Lingue.get_charB(244)); // ' Foglio Attuale ' A
ListaY[9].x:=21;   // non conviene calcolare
ListaY[9].y:=ListaX.y-ListaY[9].NumElementi-4;  // non conviene calcolare

// FILE --> NUOVO
ListaY[10].NuovaRiga(Lingue.get_txt(245),Lingue.get_charB(245)); // ' testo (.TXT) ' T
ListaY[10].NuovaRiga(Lingue.get_txt(246),Lingue.get_charB(246)); // ' esadecimale (.ESA) ' E
ListaY[10].NuovaRiga(Lingue.get_txt(541),Lingue.get_charB(541)); // ' Duplica ' D  // ver 3.24
ListaY[10].x:=21; // non conviene calcolare
ListaY[10].y:=ListaX.y-ListaY[1].NumElementi-1;

// FILE --> CONVERTI
ListaY[11].NuovaRiga(Lingue.get_txt(247),Lingue.get_charB(247)); // ' da Testo ad Esadecimale ' E
ListaY[11].NuovaRiga(Lingue.get_txt(248),Lingue.get_charB(248)); // ' da Esadecimale a Testo ' T
ListaY[11].NuovaRiga(Lingue.get_txt(249),Lingue.get_charB(249)); // ' da Testo ad Htm ' H
ListaY[11].NuovaRiga(Lingue.get_txt(250),Lingue.get_charB(250)); // ' da Testo ad Rtf ' R
ListaY[11].NuovaRiga('');
ListaY[11].NuovaRiga(Lingue.get_txt(251),Lingue.get_charB(251)); // ' opzioni per Htm ' m
ListaY[11].NuovaRiga(Lingue.get_txt(252),Lingue.get_charB(252)); // ' opzioni per Rtf ' f
ListaY[11].x:=21; // non conviene calcolare
ListaY[11].y:=ListaX.y-12;   // non conviene calcolare

// FILE --> SALVA COPIA
ListaY[12].NuovaRiga(Lingue.get_txt(253),Lingue.get_charB(253)); // ' Totale con nome ' T
ListaY[12].NuovaRiga(Lingue.get_txt(254),Lingue.get_charB(254)); // ' da byte a byte ' b
ListaY[12].NuovaRiga(Lingue.get_txt(255),Lingue.get_charB(255)); // ' Selezione ' S
ListaY[12].NuovaRiga('');
ListaY[12].NuovaRiga(Lingue.get_txt(573),Lingue.get_charB(573)); // ' Crea BackUp Ora ' k
ListaY[12].NuovaRiga(Lingue.get_txt(578),Lingue.get_charB(578)); // ' BackUp di tutti ' a
ListaY[12].NuovaRiga(Lingue.get_txt(579),Lingue.get_charB(579)); // ' BackUp solo file di testo ' e
ListaY[12].NuovaRiga(Lingue.get_txt(580),Lingue.get_charB(580)); // ' BackUp solo file in esadecimale ' d
ListaY[12].x:=21;   // non conviene calcolare
ListaY[12].y:=ListaX.y-8-4-3-2; // non conviene calcolare

// FILE --> CARICA  // ver 3.26
ListaY[13].NuovaRiga(Lingue.get_txt(542),Lingue.get_charB(542)); // ' Ricarica ' R
ListaY[13].NuovaRiga(Lingue.get_txt(169),Lingue.get_charB(169)); // ' Riapri in ' i
ListaY[13].NuovaRiga(Lingue.get_txt(543),Lingue.get_charB(543)); // ' Ripeti apri in Esadecimale ' a
ListaY[13].NuovaRiga(Lingue.get_txt(544),Lingue.get_charB(544)); // ' Ripeti apri come Testo ' T
ListaY[13].NuovaRiga(Lingue.get_txt(546),Lingue.get_charB(546)); // ' Cambia numero di colonne ' c
ListaY[13].x:=21;   // non conviene calcolare
ListaY[13].y:=ListaX.y-17; // non conviene calcolare
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Shift():boolean;  // ver 2.00
begin
shift:=pos('SHIFT',upcase(ks))>0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure alt_menu;  // ver 2.00
begin
menu__x:=listaX.selezionato;
listaX.Stampa_Selezionato;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure aspetto_Rilascio;  // ver 2.00
{$ifdef go32v2}
var t,x,y:byte;
begin
CursorOff;
while not Doppio_Click.Mouse_Up(x,y,t) do;
CursorOn;
{$else}
begin
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ErrorTextMode_start;  // update ver 2.00
begin
if (ScreenWidth>=max_larghezza)and(ScreenHeight>=min_righe_video) then Exit;
Estensioni.destroy;
Editor_Ini.destroy;
Stampante.Destroy;
{$ifndef Go32v2}
donemouse;
{$endif}
donekeyboard;
donevideo;
clrscr;
writeln(Lingue.get_txt(256));  // 'Editor non funziona correttamente,'
writeln(Lingue.get_txt(257),max_larghezza,Lingue.get_txt(258),min_righe_video,Lingue.get_txt(259)); // 'poiche'' non e'' stato eseguito nella modalita'' testo minima: '    ' colonne e '     ' righe.'
writeln(Lingue.get_txt(260));  // 'Correggere il problema e riprovare.'
Lingue.Destroy;
writeln;
halt(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function ask_crea_bak_esa():char;  // ver 2.00
begin
pulisci1;
gotoxy(1,riga_menu+2);
write(Lingue.get_txt(261));  //  'Creare un file .bak prima di salvare il file ?'
Exit(Tasti_SNA(30,riga_menu+4));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function punto_bak(s:string):string; // ver 2.00
var new_name:string;
begin
new_name:=ChangeFileExt(s,'.bak');
if lfnSupport then
               if length(new_name)>=256 then Exit('')
                                        else
              else
               if length(new_name)>=64 then Exit('')
                                       else ;
Exit(new_name);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Error_Multi_Files;   //  ver 2.4
begin
pulisci1;
hidemouse;
gotoxy(12,riga_menu+1);
write(Lingue.get_txt(262));  // 'Impossibile aprire altri files. Memoria insufficiente.'
gotoxy(12,riga_menu+2);
write(Lingue.get_txt(263));  // 'Chiudere uno o piu'' files e riprovare.'
showmouse;
showmouse;
Esc;
gotoxy(1,riga_menu+4);
write('                                                                    ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__cancella; // ver 2.10    menu FILE --> Cancella
var bad_canc:boolean;
begin
if nomefile='' then Exit;
bad_canc:=false;
repeat
 pulisci1;
 hidemouse;
 if bad_canc then
      begin
      gotoxy(1,riga_menu+1);
      write(Lingue.get_txt(264)); // 'Errore nella cancellazione del file. Riprovare a cancellare il file ?'
      end
     else
      begin
      gotoxy(39-Lingue.get_length_txt(265) div 2,riga_menu+1);
      write(Lingue.get_txt(265)); // 'Attenzione!!!    Cancellare il file ?'
      end;
 showmouse;
 showmouse;
 if Tasti_SN(35,riga_menu+3)='S' then
                         if not deletefile(percorso+nomefile) then bad_canc:=true
                                                              else
                        else break;
until not bad_canc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Open_Error5; // ver 2.10   per la rinomina
begin
pulisci1;
gotoxy(39-Lingue.get_length_txt(266) div 2,riga_menu+2);
writeln(Lingue.get_txt(266));  // 'Errore in rinomina. Il nome del file esiste gia''. Sceglierne uno diverso.'
writeln('                                                                            ');
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Open_Error6; // ver 2.21
begin
pulisci1;
gotoxy(39-Lingue.get_length_txt(267) div 2,riga_menu+2);
writeln(Lingue.get_txt(267)); // 'Errore in apertura. Il testo contiene righe piu'' lunghe del massimo.'
clreol;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Rinomina;         // ver 2.10
var nuovo_nome_file:string;
    f:file;
label riprova;
begin
assign(f,percorso+nomefile);
riprova:
nuovo_nome_file:=nomefile;
pulisci1;
colore;
gotoxy(40-Lingue.get_length_txt(268) div 2,riga_menu+2);
write(Lingue.get_txt(268)); // 'Rinomina il file'
si_no_str(nuovo_nome_file);
if (nuovo_nome_file='')or(nameof(nomefile)=nuovo_nome_file) then
   begin
   Grafica;
   Exit; // se il nome e' lo stesso e' come se annullassi
   end;
if namereserved(nuovo_nome_file) then
   begin
   gotoxy(1,riga_menu+3);
   clreol;
   InvalidName;
   colore;
   goto riprova;
   end;
{$i-}
rename(f,percorso+nuovo_nome_file);
{$i+}
if ioresult=0 then nomefile:=nameof(nuovo_nome_file)
              else
               begin
               if fileexists(percorso+nuovo_nome_file) then Open_Error5  // il file esiste gia'
                                                       else Open_Error4;
               goto riprova;
               end;
multi_file[posizione_file_attuale].nomefile:=nomefile;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Error_Riapri_IN:boolean;  // ver 2.10
begin
pulisci1;
if binario then
            begin
            gotoxy(39-Lingue.get_length_txt(269) div 2,riga_menu+1);
            write(Lingue.get_txt(269));  //  'Apertura file in formato testo. Modifiche non salvate. Continuare ?'
            end
           else
            begin
            gotoxy(39-Lingue.get_length_txt(270) div 2,riga_menu+1);
            write(Lingue.get_txt(270));  // 'Apertura file in esadecimale. Modifiche non salvate. Continuare ?'
            end;
gotoxy(39-Lingue.get_length_txt(271) div 2,riga_menu+2);
write(Lingue.get_txt(271));  //  'Nota: si possono perdere dati nel file.'
gotoxy(1,riga_menu+4);
write('                                                                 ');
Exit(Tasti_SN(35,riga_menu+3)='S');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function fine_file(var f:text):byte;  // ver 2.10
var b:boolean;
begin
{$i-}
b:=eof(f);
{$i+}
if ioresult<>0 then Exit(2);
if b then Exit(1)
     else Exit(0);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function fine_linea(var f:text):byte;  // ver 2.10
var b:boolean;
begin
{$i-}
b:=eoln(f);
{$i+}
if ioresult<>0 then Exit(2);
if b then Exit(1)
     else Exit(0);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Resoconto(i:integer);  {numero di sostituzioni}
begin
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(272)+': "'); // 'La stringa'
textcolor(10);
write(cerco);
textcolor(white);
writeln('" '+Lingue.get_txt(273));  // 'e'' stata'
write(Lingue.get_txt(274)+': "');   // 'sostituita con'
textcolor(10);
write(sostituto);
textcolor(white);
write('" ',i,Lingue.get_txt(275));  // ' volte.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure UndoTastiera_Forzata;   // mette '1' dove serve nell' heap  ver 2.10
var stringa:string;
begin
if Annulla_Txt.numelementi=0 then Exit;
stringa:=strpas((Annulla_Txt.l)^.info);  // il primo elemento
if stringa[1]='1' then Exit;
if not (stringa[10] in ['e','E','t','T']) then stringa[1]:='1';
Annulla_Txt.cancella_iniziale;
Annulla_Txt.input_iniziale(strnew(stringtopchar(stringa)));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure chk_move(ks:string); // ver 2.10
begin // se ho fatto una delle seguenti pressioni di tasti ed il cursore si e' spostato
if (ks='SHIFT Up')or(ks='Up')or
   (ks='SHIFT Down')or(ks='Down')or
   (ks='SHIFT Right')or(ks='Right')or
   (ks='SHIFT Left')or(ks='Left')or
   (ks='SHIFT Home')or(ks='Home')or
   (ks='SHIFT End')or(ks='End')or
   (ks='SHIFT PgUp')or(ks='PgUp')or
   (ks='SHIFT PgDn')or(ks='PgDn')or
   (ks='SHIFT CTRL Key with scancode 29952')or(ks='CTRL Key with scancode 29952')or(ks='SHIFT CTRL End')or(ks='CTRL End')or
   (ks='SHIFT CTRL Key with scancode 30464')or(ks='CTRL Key with scancode 30464')or(ks='SHIFT CTRL Home')or(ks='CTRL Home')or
   (ks='CTRL Key with scancode 33792')or(ks='SHIFT CTRL Key with scancode 33792')or(ks='SHIFT CTRL PgUp')or(ks='CTRL PgUp')or
   (ks='CTRL Key with scancode 30208')or(ks='SHIFT CTRL Key with scancode 30208')or(ks='SHIFT CTRL PgDn')or(ks='CTRL PgDn')or
   (ks='CTRL Key with scancode 29696')or(ks='SHIFT CTRL Key with scancode 29696')or(ks='SHIFT CTRL Right')or(ks='CTRL Right')or
   (ks='CTRL Key with scancode 29440')or(ks='SHIFT CTRL Key with scancode 29440')or(ks='SHIFT CTRL Left')or(ks='CTRL Left')
   then UndoTastiera_Forzata;
// la parte numerica (scancode) dei tasti, e' relativa al Go32v2, l'altra a Win32
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__formato_salva_file;  // ver 2.20
var formato_salva_testo:MenuLista_Y;
    risultato:byte;
begin
pulisci1;
hidemouse;
gotoxy(2,riga_menu+1);
write(Lingue.get_txt(276)); // 'Selezionare il formato con cui salvare i files di testo:'
gotoxy(2,riga_menu+2);
write(Lingue.get_txt(277));  // 'Formato attuale per salvare: '
textcolor(yellow);
if salva_formato='T' then write(Lingue.get_txt(278)+' 8 bit') else // 'Testo'
if salva_formato='L' then write('Unicode Little Endian 16 bit') else
if salva_formato='B' then write('Unicode Big Endian 16 bit') else
if salva_formato='U' then write('UTF-8');
textcolor(white);
gotoxy(2,riga_menu+3);
write(Lingue.get_txt(279)); // 'Formato del file aperto: '
textcolor(yellow);
if apri_formato='T' then write(Lingue.get_txt(278)+' 8 bit') else  // 'Testo'
if apri_formato='L' then write('Unicode Little Endian 16 bit') else
if apri_formato='B' then write('Unicode Big Endian 16 bit') else
if apri_formato='U' then write('UTF-8');
textcolor(white);
formato_salva_testo.init(ScreenWidth,ScreenHeight);
formato_salva_testo.topo:=topo;
formato_salva_testo.y:=riga_menu-5;
formato_salva_testo.x:=Lingue.get_length_txt(276)+3;
formato_salva_testo.controllo:=true;
formato_salva_testo.txt_ColorVeloce:=lightred;
formato_salva_testo.txt_ColorRigaSelezionata:=white;
formato_salva_testo.bk_color:=blue;
formato_salva_testo.txt_ColorCornice:=white;
formato_salva_testo.txt_ColorRiga:=yellow;
formato_salva_testo.bk_selezione:=green;
formato_salva_testo.NuovaRiga(' --- '+Lingue.get_txt(280)+' --- ',Lingue.get_charB(280));  // Annulla n
formato_salva_testo.NuovaRiga(' '+Lingue.get_txt(278)+' 8 bit ',ord('T'));
formato_salva_testo.NuovaRiga(' Little 16 bit ',ord('L'));
formato_salva_testo.NuovaRiga(' Big 16 bit ',ord('B'));
formato_salva_testo.NuovaRiga(' UTF-8 ',ord('U'));
showmouse;
risultato:=formato_salva_testo.costruisci;
case risultato of
     0,1: ;
     2: salva_formato:='T';
     3: salva_formato:='L';
     4: salva_formato:='B';
     5: salva_formato:='U';
     end;
Evidenzia_selezione;
{$ifdef Win32}
updatescreen(true);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_delimitatore():shortstring;  // ver 2.75
begin
case delimitatore of // delimitatore, e' composto da : 0,1,2,3,4
     0 : get_delimitatore:=lineEnding;
     1 : get_delimitatore:=#10;
     2 : get_delimitatore:=#13+#10;
     3 : get_delimitatore:=#10+#13;  // ver 3.50
     4 : get_delimitatore:=#13;      // ver 3.50
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function prepara_riga_testo(s:string):string;  // ver 2.20
var i:byte;
    s1:string;
begin
if not SFinal then s:=TrimRight(s);
if s='' then s:=get_delimitatore(); // ver 2.69
s1:='';
case salva_formato of
        'B': for i:=1 to length(s) do s1:=s1+#0+s[i];
        'L': for i:=1 to length(s) do s1:=s1+s[i]+#0;
        'U','T': Exit(s);
        end;  //  case
Exit(s1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function is_last_block():boolean;   // ha senso solo nel formato binario
begin      //  "tot" contiene il primo byte del blocco attuale
if not binario then exit(false);
if ymax+1>length(testo) then Exit(false);
if length(testo[ymax])+lunghezza_riga*(ymax-1)<lunghezza_riga*maxr then exit(true)
                                                                   else exit(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Testo_Vuoto():boolean;
begin
if length(testo)=0 then Exit(true); // ver 2.74
Exit( not ( (ymax>1) or ( (ymax=1) and (length(testo[1])>1) ) ) );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function determina_tipo_annulla(ann:boolean):string; // ver 2.25 , update 2.30
var s:string;
    p:ptrx;
begin
if sono_Appunti() then exit(''); // ver 3.28
if ann then if Annulla_Txt.NumElementi()=0 then exit('');
if not ann then if Ripristina_Txt.NumElementi()=0 then exit('');
if ann then p:=Annulla_Txt.l
       else p:=Ripristina_Txt.l;
s:=strpas(p^.info);
case s[10] of
     'F' : s:='F1/F2';      // Undo__F1_F2
     'I' : s:=Lingue.get_txt(298);  //'incolla'     // Undo__Incolla_Riga
     'i' : s:=Lingue.get_txt(298);  // 'incolla';   // Undo__Incolla_Righe
     'R' : s:='???';        // Recover  non dovrebbe mai verificarsi
     'X' : s:=Lingue.get_txt(278);  // 'testo'      // Undo__Scrivi
     'V' : s:=Lingue.get_txt(299);  // 'invio'      // Undo__Invio
     'C' : s:=Lingue.get_txt(300);  // 'cancella'   // Undo__Canc
     'B' : s:='back-space';         // Undo__Back_Space
     'x' : s:=Lingue.get_txt(278);  // 'testo'      // Undo__Insert
     'L' : s:=Lingue.get_txt(301);  // 'spazi'      // Undo__CL
     'U' : s:=Lingue.get_txt(278);  // 'testo'      // Undo__UnoS
     'M' : s:=Lingue.get_txt(278);  // 'spazi'      // Undo__Mouse_CL
     '<' : s:=Lingue.get_txt(302);  // 'sinistra'   // Undo__Formattato_Sinistra
     '>' : s:=Lingue.get_txt(303);  // 'destra'     // Undo__Formattato_Destra
     '^' : s:=Lingue.get_txt(304);  // 'centra'     // Undo__Formattato_Centra
     '|' : s:=Lingue.get_txt(305);  // 'giustifica' // Undo__Formattato_Giustifica
     'q' : s:=Lingue.get_txt(306);  // 'taglia/elimina'    // Undo__TE_Selezione_Quadrata(riga);
     'c','b' : s:=Lingue.get_txt(307);  // 'spazi' // Undo__Canc_UnoS
     'e' : s:=Lingue.get_txt(308);  // 'elimina'   // Undo__TE_Righe
     't' : s:=Lingue.get_txt(309);  // 'taglia'    // Undo__TE_Righe
     'E' : s:=Lingue.get_txt(308);  // 'elimina'   // Undo__TE_Selezione
     'T' : s:=Lingue.get_txt(309);  // 'taglia'    // Undo__TE_Selezione
     '1' : s:=Lingue.get_txt(298);  // 'incolla'   // Undo__I_Esa
     '3' : s:=Lingue.get_txt(308);  // 'elimina'   // Undo__TE_Esa
     '7' : s:=Lingue.get_txt(309);  // 'taglia'    // Undo__TE_Esa
     '+' : s:=Lingue.get_txt(310);  // 'maiuscolo'         // Undo__Formattato_Giustifica personalizzato secondo esigenza
     '-' : s:=Lingue.get_txt(311);  // 'minuscolo'         // Undo__Formattato_Giustifica personalizzato secondo esigenza
     'S' : s:=Lingue.get_txt(312);  // 'iniziali maiuscole' // Undo__Formattato_Giustifica personalizzato secondo esigenza
      #9 : s:=Lingue.get_txt(313);  // 'invertito'         // Undo__Formattato_Giustifica personalizzato secondo esigenza
     '' : s:=Lingue.get_txt(314);  // 'alternato'         // Undo__Formattato_Giustifica personalizzato secondo esigenza
     '0' : s:=Lingue.get_txt(315);  // 'normale'           // Undo__Formattato_Giustifica personalizzato secondo esigenza
     '2' : s:=Lingue.get_txt(316);  // 'spazi doppi'       // Undo__Formattato_Giustifica personalizzato secondo esigenza
     'a','A': s:=Lingue.get_txt(317); // 'incolla tutto'
     'Y': s:=Lingue.get_txt(548); // ver 3.26
     else s:='';   // non dovrebbe mai verificarsi
     end;
if s<>'' then s:='('+s+')';
exit(s);
end;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Grafica;  {menu basso}
var str1:string;
    i:byte;
const str:shortstring='';
begin
hidemouse;
cursoroff;
colore;
for i:=2 to riga_menu-2 do
        begin
        gotoxy(max_larghezza,i);
        write(c_B);  // ''  ALT+177
        end;
verticale:=2;
gotoxy(max_larghezza,2);
write(c_S);    // #9
gotoxy(max_larghezza,1);
write(c_FU);   // #24
gotoxy(max_larghezza,riga_menu-1);
write(c_FD);   // #25
pulisci1;
listaX.Mostra;
if sono_Appunti() then str:=' '+nomefile+' '
   else
    begin
    str1:=str;
    str:=percorso+nomefile;
    if str1<>str then
      if GetLongName(str) then
         begin
         percorso:=pathOf(str);
         nomefile:=nameOf(str);
         short_name:=str;
         GetShortName(short_name);
         end;
    str:=' '+nomeLungo(TruncPath(str,60),60)+' ';
    end;
while length(str)<max_larghezza do str:=c_D2+str+c_D2;   // ''
str1:=inttostr(foglio(ymax))+':'+inttostr(ymax);
str:=str1+copy(str,length(str1)+1,255);
setlength(str,max_larghezza);
colore;
gotoxy(1,riga_menu);
write(str);

gotoxy(1,riga_menu+4);
clreol;
ShowMouse;
if ins then CursorBig else CursorOn;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Grafica;  {menu basso}
var str1:string;
    i:byte;
const str:shortstring='';  // variabile globalmente locale
begin
for i:=2 to riga_menu-2 do outtextxy(79,i-1,c_B,0,blue,white);  // ''
verticale:=2;
outtextxy(79,1,c_S,0,blue,white);              // #9
outtextxy(79,0,c_FU,0,blue,white);             // #24
outtextxy(79,riga_menu-2,c_FD,0,blue,white);   // #25
listaX.Mostra;

if sono_Appunti() then str:=' '+nomefile+' '
   else
    begin
    str1:=str;
    str:=percorso+nomefile;
    if str1<>str then
      if GetLongName(str) then
        begin
        percorso:=pathOf(str);
        nomefile:=nameOf(str);
        end;
    str:=' '+nomeLungo(TruncPath(str,60),60)+' ';
    end;

while length(str)<max_larghezza do str:=c_D2+str+c_D2;   // ''
str1:=inttostr(foglio(ymax))+':'+inttostr(ymax);
str:=str1+copy_end(str,length(str1)+1);
setlength(str,max_larghezza);
outtextxy(0,riga_menu-1,str,0,blue,white);
str:='';
for i:=1 to max_larghezza do str:=str+' ';
outtextxy(0,riga_menu,' ',0,blue,white);
outtextxy(0,riga_menu+1,str,0,blue,white);
outtextxy(0,riga_menu+2,str,0,blue,white);
outtextxy(0,riga_menu+3,str,0,blue,white);
if ins then CursorBig else CursorOn;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ingresso(var stringa:string; testo:string); {per le stringhe nomefile}
label inizio;
begin
{$ifdef TxtVideo}
OutTextXY(0,riga_menu,' ',0,blue,blue,max_larghezza);
{$endif}

inizio:
stringa:=SfogliaFile(15,2,true,true,topo,mancino,testo,percorso,the_files,ClickDelay,ScreenHeight-4,
         Lingue.get_txt(531){nome},Lingue.get_txt(532){lista},Lingue.get_txt(533){elementi},
         Lingue.get_txt(293){data},Lingue.get_txt(294){ora},Lingue.get_txt(291){attributi},Lingue.get_txt(534),Lingue.get_char(531),Lingue.get_char(532));
{$ifdef TxtVideo}
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
{$endif}
Evidenzia_Selezione;
if (stringa<>'') and NameReserved(stringa) then
              begin
              stringa:=#13+stringa;
              Grafica;
              Info;
              colore;
              gotoxy(1,riga_menu+2);
              write('                                                                         ');
              gotoxy(1,riga_menu+1);
              write('                                                                         ');
              InvalidName;
              goto inizio;
              end;
if stringa='' then IOF:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Abilita_Disabilita_Mouse; // ver 2.10
var i:byte;
begin
{$ifdef Go32v2}
topo:=not topo;
{$else}
topo:=false;
{$endif}
if topo then showmouse;
for i:=1 to length(listaY) do listaY[i].topo:=topo;
listaX.topo:=topo;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Destra(var riga:string):string;   // xxx diminuiti, yyy aumentato
var the_x:byte;
begin
if riga=#13 then Exit('000000');
the_x:=length(riga);
riga:=TrimRight(riga);
destra:=zero(inttostr(the_x-length(riga)),3)+zero(inttostr(lunghezza_riga+1-length(riga)),3);
while length(riga)<lunghezza_riga+1 do Insert(' ',riga,2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Sinistra(var testo:string);
begin
testo:=#13+TrimLeft(copy_end(testo,2));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Centra(var testo:string):string; // xxx destra tolti, + yyy sinistra tolti, + zzz sinistra aggiunti
var l:byte;
    output:string;
    inseriti:boolean;
begin
if testo=#13 then Exit('000000000');
l:=length(testo);
testo:=TrimRight(testo);
output:=zero(inttostr(l-length(testo)),3);
l:=length(testo);
testo:=#13+TrimLeft( copy_end(testo,2) );
output:=output+zero(inttostr(l-length(testo)),3);
inseriti:=false;
for l:=1 to (lunghezza_riga+1-length(testo)) div 2 do
    begin
    Insert(' ',testo,2);
    inseriti:=true;
    end;
if not inseriti then l:=0;
Centra:=output+zero(inttostr(l),3);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Giustifica(var testo:string);  {Formattato il testo equispaziandolo}
var n_parole:integer;
    app,app2:string;
    i,j:byte;
    spazi:string;
begin
if testo=#13 then Exit;
app:=testo;
app[1]:=' ';  {sostituisco INVIO con SPAZIO}
i:=0;
N_parole:=0;
repeat   // tolgo spazi superflui
 inc(i);
 if (app[i]=' ')and(app[i+1]=' ') then
       begin
       delete(app,i,1);
       dec(i);
       end;
until i+1>=length(app);  // add -1 in ver 3.04

for i:=1 to length(app) do if app[i]=' ' then inc(N_parole); {N parole}
if app[length(app)]=' ' then delete(app,length(app),1); {tolgo spazi superflui}
if n_parole<=1 then n_parole:=1
               else inc(n_parole);
i:=(lunghezza_riga-length(app)+n_parole) div N_parole; {calcolo il N di spazi per parola}
if N_parole=1 then i:=(lunghezza_riga-length(app)) div 2;
if i>0 then
   begin
   spazi:='';
   app2:='';
   for j:=1 to i-1 do spazi:=spazi+' ';
   for j:=1 to length(app) do
       begin
       app2:=app2+app[j];
       if app[j] in [' '] then app2:=app2+spazi;
       end;
   app:=#13+app2;
   end;
if length(app)<lunghezza_riga+1 then testo:=app;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Pag_Giu():boolean;   // update ver 1.82 , 2.52
var old_x_riga,old_iy:integer;
begin
old_x_riga:=x_riga;
if iy=ymax then Exit(true);
old_iy:=iy;
iy:=iy+(riga_menu-1);
if iy>ymax then iy:=ymax;
if ymax-old_iy<riga_menu-1 then y:=byte(min(y+ymax-old_iy,riga_menu-1));
if ymax<riga_menu then y:=byte(iy);

x_riga:=byte(min(x_riga,length(testo[iy])));
fix_position;
x:=byte(max(x-(old_x_riga-x_riga),1));
x_reale:=x;
if x_min>x_riga then x_min:=x_riga;
Evidenzia_Selezione;
Tasto__Pag_Giu:=false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Pag_Su;
var old_x_riga:integer;
begin
if iy=1 then Exit;
old_x_riga:=x_riga;
iy:=iy-(riga_menu-1);
if iy<1 then
       begin
       iy:=1;
       y:=1;
       end;
x_riga:=byte(min(x_riga,length(testo[iy])));
fix_position;
x:=byte(max(x-(old_x_riga-x_riga),1));
x_reale:=x;
if x_min>x_riga then x_min:=x_riga;
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure SL_Error;  // update 2.52
begin
pulisci1;
gotoxy(39-Lingue.get_length_txt(318) div 2,riga_menu+1);     // da centrare
write(Lingue.get_txt(318)); // 'Impossibile modificare o salvare il testo con queste impostazioni.'
gotoxy(39-Lingue.get_length_txt(319) div 2,riga_menu+2);
write(Lingue.get_txt(319));  // 'Controllare "modalita'' di sola lettura" in OPZIONI --> CONFIGURA1.'
Esc;
gotoxy(1,riga_menu+2);
write('                                                                         ');
grafica;
info;
{$ifdef TxtVideo}
updatescreen(true);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function CercaMaMi_Su_:longint;  //ignora Mai/Min verso sopra  update 2.25
var i,a,old_ii,ii,old_iy,count,old_x_riga,old_x_min:integer;
    cont,old_x,old_y:byte;
    app,cercx:string;
label riprova,restart;
begin
if cerco='' then Exit(-1);
if selezione and (selezionato.x1=0) then
   begin
   not_found;
   exit(-1);
   end;
if ignora then cercx:=UpCase(cerco)
          else cercx:=cerco;
cont:=0;
old_x:=x;
old_y:=y;
old_iy:=iy;
old_x_riga:=x_riga;
old_x_min:=x_min;
count:=0;

restart:
old_ii:=0;   // *** bug non noto :non inizializzato
ii:=iy+1;
repeat
 inc(cont);
 while old_ii-ii>0 do inc(ii);  {correttore di salti}
 dec(ii);
 old_ii:=ii;
 if ignora then app:=UpCase(testo[ii])
           else app:=testo[ii];
 if ii=iy then for i:=x_riga+1 to length(app) do app[i]:=#13;
 if pInt then
          begin
          app:=app+' ';
          app[1]:=' ';
          riprova:
          a:=PosRL(cercx,app,byte(min(length(app),255)));
          if a=0 then else
          if (a>0)and (not ( (app[a-1] in as_word) ) ) and
             (not ( (app[a+length(cercx)] in as_word) ) ) then
                                                          else
                                                           begin
                                                           if app[a+length(cercx)-1]='0' then app[a+length(cercx)-1]:='1'
                                                                                         else app[a+length(cercx)-1]:='0'; // sostituire il carattere con uno non trovabile
                                                           a:=0;
                                                           goto riprova; // stessa riga
                                                           end;
          end
         else if jolly then a:=PosJollyRL(cercx,app,length(app))
                       else a:=PosRL(cercx,app,length(app));
until (a<>0)or(ii=1)or(selezione and (ii<=selezionato.y1));

if a<>0 then
        begin
        x_riga:=a-1;
        x_min:=max(x_riga-79,1);
        x:=byte(max(x_riga-x_min+1,1));
        x_reale:=x;
        if iy-y+1>ii then y:=1
                     else y:=byte(max(y-cont+1,1));
        iy:=ii;
        if SC then
              begin
              if selezione and ((iy-1)*lunghezza_riga+x_riga<(selezionato.y1-1)*lunghezza_riga+selezionato.x1)
                  then
                   exit(count)
                  else
                   begin
                   inc(count);
                   goto restart;
                   end;
              end
             else
              begin
              Azzera_Selezione;
              Selezionato.x1:=byte(x_riga);
              Selezionato.y1:=iy;
              Selezionato.x2:=x_riga+length(cerco)-1;
              Selezionato.y2:=iy;
              Evidenzia_Selezione;
              end
        end
       else
        begin
        if SC then
           begin
           x:=old_x;
           x_riga:=old_x_riga;
           x_min:=old_x_min;
           iy:=old_iy;
           y:=old_y;
           if selezione and not binario and (selezionato.x1<>0) then
                                                                else Conto(count);
           Exit(count);  {non serve Evidenzia_Selezione}
           end;
        if selezione and (not binario) and (selezionato.x1<>0) then Evidenzia_Selezione
                                                               else
                                                                begin
                                                                x:=old_x;
                                                                x_riga:=old_x_riga;
                                                                x_min:=old_x_min;
                                                                iy:=old_iy;
                                                                y:=old_y;
                                                                Evidenzia_Selezione;
                                                                not_found;  {non trovato}
                                                                end;
        exit(0);
        end;
exit(-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function non_selezione():boolean;   // ver 2.25
begin
exit( (selezionato.x1=0)or(selezionato.y1=0)or(selezionato.x2=0)or(selezionato.y2=0) );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_posizione_cursore():longint;  // ver 2.25
begin
if non_selezione then exit(-1);
exit((iy-1)*lunghezza_riga+x_riga);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_posizione_fine_selezione:longint; // ver 2.25
begin
if non_selezione then exit(-1);
exit((selezionato.y2-1)*lunghezza_riga+selezionato.x2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_posizione_inizio_selezione:longint;   // ver 2.25
begin
if non_selezione then exit(-1);
exit((selezionato.y1-1)*lunghezza_riga+selezionato.x1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function dentro_selezione:boolean;   // ver 2.25
var pos_cursore:longint;
begin
if non_selezione then exit(false);
pos_cursore:=get_posizione_cursore;
exit( (get_posizione_inizio_selezione<=pos_cursore) and (pos_cursore<=get_posizione_fine_selezione) )
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Cerca_per_riga; // ver 3.23
var old_iy,i,j,start_iy,end_iy:integer;
    end_x,pos_parola,start_x,pos_min,pos_max:byte;
    cercare,riga,parola,testa,coda:string;
    parole:array of string;
begin
old_iy:=iy;
if sotto_ then
  if selezione then
      begin
      start_iy:=selezionato.y1;
      start_x:=selezionato.x1+1;
      end_iy:=selezionato.y2;
      end_x:=selezionato.x2+1;
      end
     else
      begin
      start_iy:=iy;
      start_x:=byte(min(x_riga+1,255));
      end_iy:=ymax;
      end_x:=length(testo[ymax]);
      end
    else // verso sopra
  if selezione then
      begin
      end_iy:=selezionato.y1;
      start_iy:=selezionato.y2;
      start_x:=selezionato.x2+1;
      end_x:=selezionato.x1+1;
      end
     else
      begin
      start_iy:=iy;
      start_x:=byte(x_riga)+1;
      end_iy:=1;
      end_x:=length(testo[1]);
      end;

if ignora then cercare:=upcase(cerco)
          else cercare:=cerco;
setlength(parole,0);
while cercare>'' do
      begin
      Testa_Coda(cercare,' ',testa,coda);
      cercare:=coda;
      testa:=trim(testa);
      if testa='' then continue;
      setlength(parole,length(parole)+1);
      parole[length(parole)-1]:=testa;
      end;
if length(parole)=0 then Exit; // superfluo
i:=start_iy;
while ( (i<=end_iy) and sotto_ ) or ( (i>=end_iy) and (not sotto_) ) do
    begin
    pos_min:=255;
    pos_max:=0;
    if selezione and (selezionato.y1=selezionato.y2) then
       begin
       if sotto_ then riga:=copy_end(copy(testo[i],2,selezionato.x2),start_x-1)
                 else riga:=copy_end(copy(testo[i],2,selezionato.x2),end_x-1);
       end else
    if sotto_ and (i in [start_iy+1..end_iy-1]) then riga:=copy_end(testo[i],2)
                  else
    if (not sotto_) and (i in [end_iy+1..start_iy-1]) then riga:=copy_end(testo[i],2)
                  else
    if i=start_iy then
                   if sotto_ then riga:=copy_end(testo[i],start_x)
                             else riga:=copy(testo[i],2,start_x-1)
                  else
    if i=end_iy then riga:=copy(testo[i],2,end_x);
    if ignora then riga:=upcase(riga);
    for j:=0 to length(parole)-1 do
        begin
        if ignora then parola:=upcase(parole[j])
                  else parola:=parole[j];
        pos_parola:=1; // basta che sia >0
        while pos_parola>0 do
              begin
              pos_parola:=byte(pos(parola,riga));
              if not pInt then break;
              if pos_min=0 then pos_min:=255;
              if pInt and (pos_parola>0) then // parola intera ?
                 begin
                 if (pos_parola>1) then
                    if riga[pos_parola-1] in as_word then pos_min:=0;
                 if (copy(riga,pos_parola+length(parole[j]),1)+#13)[1] in as_word then pos_min:=0;
                 if pos_min=0 then riga[pos_parola{-1}]:=#13 // ho trovato la parola, ma non era intera. Quindi provo con un'altra sulla stessa riga se c'
                              else
                               break;
                 end;
              end;
        pos_min:=byte(min(pos_parola,pos_min));
        if pos_min=0 then break; // parola non trovata: salto la riga
        pos_max:=byte(max(pos_max,pos_parola+length(parole[j])-1));
        end;
    if pos_min>0 then
       begin
       iy:=i;
       break;
       end;
    if sotto_ then inc(i)
              else dec(i);
    end;
if pos_min>0 then
    begin
    if sotto_ then
        begin
        selezionato.x2:=(start_x-2)*bool(iy=start_iy)+pos_max;
        selezionato.x1:=(start_x-2)*bool(iy=start_iy)+pos_min;
        end
       else
        begin
        if selezione and (selezionato.y1=selezionato.y2) and (not sotto_) then
               begin
               selezionato.x2:=selezionato.x1+pos_max-1;
               selezionato.x1:=selezionato.x1+pos_min-1;
               end
              else
               begin
               selezionato.x2:=pos_max;
               selezionato.x1:=pos_min;
               end;
        end;
    selezionato.y1:=iy;
    selezionato.y2:=iy;
    if sotto_ then Set_Cursore_X(selezionato.x2+1)
              else Set_Cursore_X(selezionato.x1);
    if sotto_ then y:=byte(min(y+(iy-old_iy),riga_menu-1))
              else y:=byte(max(y-(old_iy-iy),1));
    selezione:=false;
    Evidenzia_selezione;
    end
   else not_found;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure CercaMaMi_Su; // ver 2.25
var x_,y_:byte;
    posizione_inizio_selezione,posizione_fine_selezione,posizione_cursore,
    iy_,old_x_min,old_x_riga,trovato:integer;
    selezione_precedente:selez;
    non_in_selezione:boolean;
begin
if per_riga and (not binario) then
   begin
   Cerca_per_riga;
   Exit;
   end;
if (not selezione) or binario or (selezionato.x1=0) then
   begin
   CercaMaMi_Su_;
   Exit;
   end;
selezione_precedente:=selezionato;  // salva dati
x_:=x;
y_:=y;
iy_:=iy;
old_x_min:=x_min;
old_x_riga:=x_riga;
posizione_cursore:=get_posizione_cursore;
posizione_inizio_selezione:=get_posizione_inizio_selezione;
posizione_fine_selezione:=get_posizione_fine_selezione;
non_in_selezione:=false;

if (posizione_cursore<posizione_inizio_selezione+length(cerco))or(posizione_cursore>posizione_fine_selezione) then
   begin
   Set_Cursore_X(selezionato.x2+1);   // aggiorna dati
   iy:=selezionato.y2;
   non_in_selezione:=true;
   end;

y:=1;
evidenzia_selezione;
trovato:=CercaMaMi_Su_;
if trovato=0 then     // ripristina dati
   begin
   x:=x_;
   y:=y_;
   iy:=iy_;
   x_min:=old_x_min;
   x_riga:=old_x_riga;
   end;
selezionato:=selezione_precedente;
evidenzia_selezione;
if trovato=0 then not_found;
if trovato>0 then
             begin
             if (non_in_selezione and SC) then
                begin
                Set_Cursore_X(selezionato.x2+1);   // aggiorna dati
                iy:=selezionato.y2;
                y:=byte(min(y,iy));
                evidenzia_selezione;
                end;
             Conto(trovato);
             end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Error_stampante; // ver 2.20
begin
Evidenzia_selezione;
grafica;
pulisci1;
{$ifdef win32}
updatescreen(true);
{$endif}
gotoxy(1,riga_menu+1);
write('                                                                               ');
gotoxy(39-Lingue.get_length_txt(320) div 2,riga_menu+2);
writeln(Lingue.get_txt(320));  // 'Errore nell''impostazione della stampante. Riprovare.'
write('                                                                            ');
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifndef Linux}
procedure M_Stampa__Stampante;    // ver 2.20  seleziona porta
var porta:MenuLista_Y;
    risultato:byte;
    default_printer:string;
    impostata:longint;
begin
pulisci1;
hidemouse;
default_printer:=Stampante.Get_Printer;
{$ifdef TxtCrt}
gotoxy(2,riga_menu+1);
write(Lingue.get_txt(321));   // 'Selezionare la porta su cui e'' collegata la stampante:'
gotoxy(2,riga_menu+2);
write(Lingue.get_txt(322));   // 'Stampante selezionata: '
textcolor(yellow);
if default_printer<>'' then write(default_printer)
                       else write(Lingue.get_txt(323));  // '<< Nessuna >>'
{$else}
outtextxy(1,riga_menu,Lingue.get_txt(321),0,blue,white);    // 'Selezionare la porta su cui e'' collegata la stampante:'
outtextxy(1,riga_menu+1,Lingue.get_txt(322),0,blue,white);  // 'Stampante selezionata: '
if default_printer<>'' then outtextxy(Lingue.get_length_txt(322)+2,riga_menu+1,default_printer,0,blue,yellow)
                       else outtextxy(Lingue.get_length_txt(322)+2,riga_menu+1,Lingue.get_txt(143),0,blue,yellow);  // '<< Nessuna >>'
{$endif}
gotoxy(2,riga_menu+3);
porta.init(ScreenWidth,ScreenHeight);
porta.topo:=topo;
porta.y:=riga_menu-14;
porta.x:=Lingue.get_length_txt(321)+2;
porta.controllo:=true;
porta.txt_ColorVeloce:=lightred;
porta.txt_ColorRigaSelezionata:=white;
porta.bk_color:=blue;
porta.txt_ColorCornice:=white;
porta.txt_ColorRiga:=yellow;
porta.bk_selezione:=green;
porta.NuovaRiga(Lingue.get_txt(369),Lingue.get_charB(369));  // ' --- Annulla --- '
porta.NuovaRiga('      LPT1 ',1);
porta.NuovaRiga('      LPT2 ',1);
porta.NuovaRiga('      LPT3 ',1);
porta.NuovaRiga('      LPT4 ',1);
porta.NuovaRiga('      LPT5 ',1);
porta.NuovaRiga('      LPT6 ',1);
porta.NuovaRiga('      LPT7 ',1);
porta.NuovaRiga('      LPT8 ',1);
porta.NuovaRiga('      LPT9 ',1);
porta.NuovaRiga('      COM1 ',1);
porta.NuovaRiga('      COM2 ',1);
porta.NuovaRiga('      COM3 ',1);
porta.NuovaRiga('      COM4 ',1);
showmouse;
risultato:=porta.costruisci;
if risultato>1 then Stampante.close_printer;
case risultato of
     0,1   : impostata:=0;    //  esclusi dall' IF
     2..10 : impostata:=stampante.set_printer('LPT'+char(risultato-2+49));
     11..14: impostata:=stampante.set_printer('COM'+char(risultato-11+49));
     end;
if impostata<>0 then error_stampante;
if risultato>1 then
               begin
               Editor_Ini.Set_modifica(true);
               if risultato<11 then Editor_Ini.Aggiorna('OPZIONI','Printer','LPT'+char(risultato-2+49))
                               else Editor_Ini.Aggiorna('OPZIONI','Printer','COM'+char(risultato-11+49));
               end;
Evidenzia_selezione;
{$ifdef Win32}
updatescreen(true);
{$endif}
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Informazioni_su_Editor;   // ver 1.xx
var i:integer;
    str:string;
begin     {note informative / guida}
HideMouse;
colore;
clrscr;
textcolor(yellow);
gotoxy(1,1);
write(c_UL2+c_D2+c_D2+' EDiTury '+c_D2+c_D2+c_D2+'  Version ',ver,'    '+Os_prog+'  '+IntToStr(bit)+' bit '+c_D2+c_D2+c_D2+'    1998/05/27   ',{$I %DATE%},' '+c_D2+c_D2+c_D2+c_UR2);
gotoxy(1,2);
write(c_U2+'                                                                              '+c_U2);
gotoxy(39-Lingue.get_length_txt(325) div 2,2);
write(Lingue.get_txt(325)); // 'Editor creato e idealizzato da Licciardi Salvatore'
gotoxy(1,3);
write(c_U2+'  Web ',web,'    eMail ',mail,'  '+c_U2);
str:='';
for i:=1 to max_larghezza-2 do str:=str+c_D2;
gotoxy(1,4);
writeln(c_DL2+str+c_DR2);
textcolor(white);
writeln(Lingue.get_txt(326)); // '- Menu'': Accedergli col mouse o con F10, nasconderlo con click o Esc.'
writeln(Lingue.get_txt(327),#27,#26,#24,#25,' / Pag',#24,' / Pag',#25,'.');  // '- Selezione: con mouse o Shift + Inizio / Fine / Cursori: '
writeln(Lingue.get_txt(328)); // '- Tasti di scelta rapida:'
writeln(Lingue.get_txt(329)); // '  Shift + Ins/Canc per incolla/taglia selezione,'
writeln(Lingue.get_txt(330)); // '  Ctrl + Ins/Canc per copia/elimina selezione,'
writeln(Lingue.get_txt(331)); // '  Ctrl + Inizio/Fine per andare ad inizio/fine testo,'
writeln('  Ctrl + Pag',#24,' / Pag',#25,Lingue.get_txt(332)); // ' per andare ad inizio/fine pagina,'
writeln(Lingue.get_txt(333)); // '  F1/F2 incrementa/decrementa il carattere ASCII attuale.'
writeln(Lingue.get_txt(334)); // '  F3/F4 per ripeti trova/sostituisci.'
writeln(Lingue.get_txt(335)); // '  F6/F5 (oppure Ctrl + TAB) passa al file precedente/successivo.'
writeln(Lingue.get_txt(336)); // '  Ctrl + F4 (oppure ALT + F3) per chiudere il file attuale.'
writeln(Lingue.get_txt(337)); // '  Shift + Esc per annullare la selezione.'
writeln(Lingue.get_txt(338)); // '  Alt + F4 per chiudere l'' Editor.'
{$ifdef Go32v2}
writeln(Lingue.get_txt(339)); // '  Alt + F5 per visualizzare il contenuto della Shell.'
{$endif}
writeln(Lingue.get_txt(340)); // '- Per annullare un input numerico si puo'' anche inserire il valore 0.'
writeln(Lingue.get_txt(341)); // '- Personalizza la Shell modificando il campo RunShell in Editor.ini'
writeln(Lingue.get_txt(342)); // '- Apri il file EDIT.TXT per la guida.'
textcolor(white);
verticale:=2;   {obbligo l'aggiornamento della barra verticale}
ShowMouse;
ShowMouse;
Esc;
textbackground(black);
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
Evidenzia_selezione;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Help;  //  opzione /? , o -H in Linux
begin
if wherex<>1 then writeln;
if IniFile() then writeln; // se c'e' errore in editor.ini
writeln(Lingue.get_txt(343)); // 'EDITOR : programma di scrittura in formato testo o esadecimale.'
writeln(' ',Lingue.get_txt(344),'                          Ver ',Ver,'  ,  ',{$I %DATE%},'  ,  ',Os_prog+' ',bit,' bit');  // [opzioni]
writeln(' ',opz,{$ifdef Linux}'H'{$else}'?'{$endif},'        ',Lingue.get_txt(345));  // 'Questa schermata'
writeln(Lingue.get_txt(346)); // ' nomefile  Elenco di files da aprire (ammessi i caratteri jolly "*" e "?")'
writeln(' ',opz,'N        ',Lingue.get_txt(347)); // 'Non apre i files da terminale, gia'' caricati precedentemente' // ver 2.85
writeln(' ',opz,'TXT ',opz,'ESA ',Lingue.get_txt(348)); // 'Forzano rispettivamente l'' uso del formato testo ed esadecimale'
writeln(' ',opz,'ASK      ',Lingue.get_txt(349));  // 'Chiede se usare il formato testo o esadecimale'
writeln(' ',opz,'DEF      ',Lingue.get_txt(350),' /ESA , /TXT , /ASK'); // 'Disabilita'
writeln(' ',opz,'<nn>     ',Lingue.get_txt(351));  // 'Lunghezza della riga. Valori validi da 1 a 254.'
writeln(' ',opz,'SF       ',Lingue.get_txt(352));  // 'Salva anche spazi finali (solo con il formato testo)
writeln(' ',opz,'SL       ',Lingue.get_txt(353));  // 'Apre il file in sola lettura: non consente di modificarlo'
writeln(' ',opz,'BACKUP   ',Lingue.get_txt(354));  // 'Crea il file di backup in salva (solo con il formato testo)'
writeln(' ',opz,'CL       ',Lingue.get_txt(355));  // 'Cursore libero (sempre abilitato con il formato esadecimale)'
writeln(' ',opz,'US       ',Lingue.get_txt(356));  // 'Un solo spazio fra parole (ignorato nel formato esadecimale)'
writeln(' ',opz,'I        ',Lingue.get_txt(357));  // 'Ignora il file editor.ini durante l''inizializzazione, se esiste' // ver 1.85
writeln(' ',opz,'D<n>     ',Lingue.get_txt(358));  // 'Delimitatore di riga: n=0 e'' predefinito dal sistema operativo,' // ver 2.20
writeln('           ',Lingue.get_txt(359));        // 'n=1 e'' #10, n=2 e'' #13 #10 (solo con il formato testo)'
{$ifdef Linux}
 writeln(' ',opz,'P        ',Lingue.get_txt(360));  // 'Opzione ignorata in questa versione'
{$else}
 writeln(' ',opz,'P=<p>    ',Lingue.get_txt(361)); // 'Imposta stampante: p tra LPT1..9 e COM1..4 . LPT1 e'' predefinita' // ver 2.20
{$endif}
writeln(' ',opz,'DM       ',Lingue.get_txt(362)); // 'Disabilita il mouse (se supportato, solo per DOS)'
writeln(' ',opz,'MEM      ',Lingue.get_txt(363)); // 'Gestione automatica della memoria per files di testo troppo grandi'
writeln;
writeln(Lingue.get_txt(364),opz,inv,'SF ',opz,inv,'SL ',opz,inv,'BACKUP ',opz,inv,'CL ',opz,inv,'US ',opz,inv,'I ',opz,inv,'DM ',opz,inv,'N ',opz,inv,'MEM'); // 'Opzioni inverse: '
writeln(Lingue.get_txt(365),opz,'SF ',opz,inv,'SL ',opz,inv,'BACKUP ',opz,inv,'CL ',opz,inv,'US ',opz,inv,'I ',opz,'D2 ',opz,inv,'DM '{$ifndef Linux},opz,'P=lpt1'{$endif},' ',opz,inv,'N ',opz,inv,'MEM'); // 'Opzioni predefinite: '
Lingue.Destroy;
{$ifndef Go32v2}
donemouse;
{$endif}
donekeyboard;
Halt(0);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Delimitatore_di_fine_riga; // ver 2.20
var delimitatore_:MenuLista_Y;
    i,risultato:byte;
    os_delimitatore:string;
begin
pulisci1;
hidemouse;
gotoxy(2,riga_menu+1);
write(Lingue.get_txt(366));  //  'Selezionare il delimitatore di fine riga : '
{$ifdef OS2}  // *** per via di qualche bug nelle librerie
OutTextXY(1,riga_menu,Lingue.get_txt(366),0,blue,white);
{$endif}
gotoxy(2,riga_menu+2);
os_delimitatore:='';
for i:=1 to length(LineEnding) do os_delimitatore:=os_delimitatore+'#'+inttostr(ord(string(LineEnding)[i]))+' ';
case delimitatore of
     0: if EOL_in_apertura<>'?' then writeln(EOL_in_apertura)
                                else writeln(os_delimitatore); // inizialmente uguale a quello dell'apertura, o se non esiste a quello dell'OS
     1: writeln('#10 (A)');
     2: writeln('#13 #10 (DA)');
     3: writeln('#10 #13 (AD)');
     4: writeln('#13 (D)');
     end;
if binario then clreol
           else write(Lingue.get_txt(577)+EOL_in_apertura);
gotoxy(2,riga_menu+3);
delimitatore_.init(ScreenWidth,ScreenHeight);
delimitatore_.topo:=topo;
delimitatore_.y:=riga_menu-6;
delimitatore_.x:=Lingue.get_length_txt(366)+2;
delimitatore_.controllo:=true;
delimitatore_.txt_ColorVeloce:=lightred;
delimitatore_.txt_ColorRigaSelezionata:=white;
delimitatore_.bk_color:=blue;
delimitatore_.txt_ColorCornice:=white;
delimitatore_.txt_ColorRiga:=yellow;
delimitatore_.bk_selezione:=green;
delimitatore_.NuovaRiga(Lingue.get_txt(369),Lingue.get_charB(369));  // ' --- Annulla --- ' n
delimitatore_.NuovaRiga(Lingue.get_txt(370)+os_delimitatore+' ',Lingue.get_charB(370));  // ' Predefinito: '
delimitatore_.NuovaRiga(' #13 #10  (DA) ',1);
delimitatore_.NuovaRiga('     #10  ( A) ',1);
delimitatore_.NuovaRiga(' #10 #13  (AD) ',1);
delimitatore_.NuovaRiga('     #13  ( D) ',1);
showmouse;
risultato:=delimitatore_.costruisci;
if risultato>1 then Editor_Ini.Set_modifica(true);
case risultato of
     0,1 : ;
     2   : begin
           delimitatore:=0; // lineending
           Editor_Ini.Aggiorna('OPZIONI','/D0','True');
           Editor_Ini.Aggiorna('OPZIONI','/D1','False');
           Editor_Ini.Aggiorna('OPZIONI','/D2','False');
           Editor_Ini.Aggiorna('OPZIONI','/D3','False');
           Editor_Ini.Aggiorna('OPZIONI','/D4','False');
           end;
     3   : begin
           delimitatore:=2; // #13+#10
           Editor_Ini.Aggiorna('OPZIONI','/D0','False');
           Editor_Ini.Aggiorna('OPZIONI','/D1','False');
           Editor_Ini.Aggiorna('OPZIONI','/D2','True');
           Editor_Ini.Aggiorna('OPZIONI','/D3','False');
           Editor_Ini.Aggiorna('OPZIONI','/D4','False');
           end;
     4   : begin
           delimitatore:=1; // #10
           Editor_Ini.Aggiorna('OPZIONI','/D0','False');
           Editor_Ini.Aggiorna('OPZIONI','/D1','True');
           Editor_Ini.Aggiorna('OPZIONI','/D2','False');
           Editor_Ini.Aggiorna('OPZIONI','/D3','False');
           Editor_Ini.Aggiorna('OPZIONI','/D4','False');
           end;
     5   : begin
           delimitatore:=3; // #10+#13    ver 3.50
           Editor_Ini.Aggiorna('OPZIONI','/D0','False');
           Editor_Ini.Aggiorna('OPZIONI','/D1','False');
           Editor_Ini.Aggiorna('OPZIONI','/D2','False');
           Editor_Ini.Aggiorna('OPZIONI','/D3','True');
           Editor_Ini.Aggiorna('OPZIONI','/D4','False');
           end;
     6   : begin
           delimitatore:=4; // #13        ver 3.50
           Editor_Ini.Aggiorna('OPZIONI','/D0','False');
           Editor_Ini.Aggiorna('OPZIONI','/D1','False');
           Editor_Ini.Aggiorna('OPZIONI','/D2','False');
           Editor_Ini.Aggiorna('OPZIONI','/D3','False');
           Editor_Ini.Aggiorna('OPZIONI','/D4','True');
           end;
     end;
Evidenzia_selezione;
{$ifdef Win32}
updatescreen(true);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function influenza(c:char):boolean;      // ver 1.85 , update 2.25
var mem,i,posizione_cursore,posizione_inizio_selezione,posizione_fine_selezione:longint;
begin
if selezionato.x1=0 then Exit(false);
posizione_cursore:=(iy-1)*lunghezza_riga+x;
posizione_fine_selezione:=(selezionato.y2-1)*lunghezza_riga+selezionato.x2;
posizione_inizio_selezione:=(selezionato.y1-1)*lunghezza_riga+selezionato.x1;
if selezione_quadrata and (selezionato.x1-1=selezionato.x2) then inc(posizione_fine_selezione);
influenza:=(posizione_cursore>=posizione_inizio_selezione)and(posizione_cursore<=posizione_fine_selezione);
if influenza and selezione_quadrata then
   if (ord(c)=8)and(x-1>selezionato.x2) then influenza:=false; // back_space
if (posizione_cursore<posizione_inizio_selezione) and not influenza then
   begin  // verifica se un nuovo inserimento di dati va a finire nella parte selezionata
   mem:=0;
   for i:=iy to selezionato.y1-1 do mem:=mem+lunghezza_riga-length(testo[i])+1;
   case ord(c) of
     32..255 : influenza:=mem<1;
     9       : influenza:=mem<tab_num;  // tab
     8       : ; // back_space
     end;
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function chk_tab_back_space():integer;  // ver 2.20  impongo che un TAB e' separabile al massimo in 2 sole righe
var s:string;
begin
chk_tab_back_space:=1;
s:=copy(testo[iy],2,x_riga-1);  // estraggo tutta la riga
s:=copy(s,length(s)-tab_num+1,tab_num);   // estraggo gli ultimi caratteri della riga
if (length(s)=tab_num) and (trim(s)='') then Exit(tab_num);

if iy=1 then Exit(1);
if testo[iy-1][1]=#10 then Exit(1);
if length(testo[iy-1])<lunghezza_riga+1 then Exit(1);
s:=copy(testo[iy-1],(lunghezza_riga+1)-(tab_num-length(s))+1,lunghezza_riga)+s;
if trim(s)='' then Exit(tab_num+1)
              else Exit(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function chk_tab_canc():integer;  // ver 2.20  impongo che un TAB e' separabile al massimo in 2 sole righe
var s:string;    //  passi e' il numero cancX da fare
begin
chk_tab_canc:=1;
s:=copy(testo[iy],x_riga+1,tab_num);
if length(s)<tab_num then
      begin
      if iy=ymax then Exit(1);
      if testo[iy][1]=#10 then Exit(1);
      if length(testo[iy])-1<lunghezza_riga then Exit(1);
      end
     else
      if trim(s)='' then Exit(tab_num)
                    else Exit(1);
s:=s+copy(testo[iy+1],2,tab_num-length(s));
if length(s)<tab_num then Exit(1);
if trim(s)='' then Exit(tab_num)
              else Exit(1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function sostituisci_tab(s:string):string; // ver  2.20
var l0,l1:integer;
    sub:string;
begin
if not salva_tab then Exit(s);  // ver 3.15
sub:='';
for l0:=1 to tab_num do sub:=sub+' ';
repeat
 l0:=length(s);
 s:=SostituisciLR(1,sub,#9,s);
 l1:=length(s);
until l0=l1;
sostituisci_tab:=s;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Inizio;  // pressione del tasto Home   ver 2.25
var old_x_riga,i:integer;
begin
old_x_riga:=x_riga;
if home then
        if trim(copy(testo[iy],2,x_riga-1))='' then Set_Cursore_X(1)
                                          else
                                           for i:=2 to x_riga do
                                               if testo[iy][i]<>' ' then
                                                  begin
                                                  Set_Cursore_X(i-1);
                                                  if old_x_riga-(i-1)>=79 then
                                                     begin
                                                     x:=1;
                                                     x_reale:=1;
                                                     end;
                                                  break;
                                                  end
                                                 else
        else
         begin
         Set_Cursore_X(1); // Home==false
         x_min:=1;
         end;
if old_x_riga<>x_riga then Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Fine():boolean;  // update ver 1.81 , 2.25
var old_x:byte;
    old_x_min,old_x_riga:integer;
    i:byte;
label next;
begin
if x_riga>=length(testo[iy]) then Exit;
old_x_riga:=x_riga;
old_x:=x;
old_x_min:=x_min;
if Fine_ then
         if trim(copy_end(testo[iy],x_riga+1))='' then goto next
                                                  else
                                                   for i:=length(testo[iy]) downto x+2 do
                                                       if testo[iy][i]<>' ' then
                                                          begin
                                                          Set_Cursore_X(i);
                                                          if abs(old_x_riga-x_riga)<80 then
                                                             begin
                                                             x:=byte(min((i-old_x_riga)+old_x,80));
                                                             x_reale:=x;
                                                             end;
                                                          break;
                                                          end
                                                      else
         else
          begin
          next:
          Set_Cursore_X(length(testo[iy])); // Fine_==false
          if abs(old_x_riga-x_riga)<80 then
             begin
             x:=byte(min((length(testo[iy])-old_x_riga)+old_x,80));
             x_reale:=x;
             end;
          end;
fix_position; // ver 2.62
result:=(old_x=x)and(old_x_min=x_min);
if (old_x_min<>x_min) then Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Shift_Inizio;  {update 2.25}
var old_x_riga:integer;
begin
if x_riga=1 then Exit;
old_selezionato:=selezionato;
old_x_riga:=x_riga;
Tasto__Inizio;
selezionato.x2:=byte(old_x_riga); {se la riga= solo #13}
if length(testo[iy])>1 then dec(selezionato.x2); {se la riga= #13...}
selezionato.y1:=iy;
selezionato.y2:=iy;
selezionato.x1:=byte(x_riga);
if old_selezionato.x1<>0 then adiacente:=true;
testo[0]:='shift_inizio';
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Shift_Fine;    {update 2.25}
var old_x_riga,old_iy:integer;
begin
if length(testo[iy])=x_riga then Exit;
old_selezionato:=selezionato;
old_x_riga:=x_riga;
old_iy:=iy;
Tasto__Fine();
selezionato.x1:=byte(old_x_riga);
selezionato.y1:=old_iy;
selezionato.x2:=x_riga-1;
if length(testo[iy])=1 then selezionato.x2:=1; {se testo[iy]=#13}
selezionato.y2:=iy;
if old_selezionato.x1<>0 then adiacente:=true;
testo[0]:='shift_fine';
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Alt_F5;  // ver 2.25  mostra la shell
{$ifdef Go32v2}
var cliccato:boolean;
begin
dosmemput($B800, 0, save_shell, sizeof(save_shell));
gotoxy(save_shell_x,save_shell_y);
repeat
 if (PollKeyEvent<>0) or (not topo) then
    begin
    GetKeyEvent;
    break;
    end;
 cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
until cliccato;
evidenzia_selezione;
grafica;
{$else}
begin
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function CercaMaMi_Giu_:longint; // ignora Mai/Min    ver 1.1 , update 2.25
var a,yy,ii,old_iy,count,old_x_riga,old_x_min:integer;
    i,old_x,old_y:byte;
    app,appx,app2:string;
label restart,riprova;

begin
if cerco='' then Exit(-1);
if selezione and (selezionato.x1=0) then
   begin
   not_found;
   exit(-1);
   end;
old_x:=x;
old_iy:=iy;
old_y:=y;
old_x_riga:=x_riga;
old_x_min:=x_min;
count:=0;
appX:=cerco;
if ignora then appx:=UpCase(appx);

restart:
ii:=iy-1;
repeat
 if (x_riga=lunghezza_riga+1) and (iy<ymax) then
                                begin
                                inc(iy);         // e' una parte di Destra :inizio
                                inc(y);
                                if y=riga_menu then
                                   begin
                                   y:=riga_menu-1;
                                   Evidenzia_Selezione;
                                   end;
                                Set_Cursore_X(1);  // e' una parte di Destra :fine
                                if x=1 then inc(ii);
                                end;
 inc(ii);
 app:=testo[ii];
 if ignora then app:=UpCase(app);
 if ii=iy then for i:=2 to x_riga do app[i]:=#13;
 if pInt then
          begin
          app2:=app+' ';
          app2[1]:=' ';
          riprova:
          a:=pos(appx,app2);
          if a=0 then else
          if (a>0)and (not ( (app2[a-1] in as_word) ) ) and
             (   (not ( (app2[a+length(appx)] in as_word) ) )  or
                 (a+length(appx)=length(app2)){parola a fine riga}   ) then
                                                          else
                                                           begin
                                                           if app2[a+length(appx)-1]='0' then app2[a+length(appx)-1]:='1'
                                                                                         else app2[a+length(appx)-1]:='0'; // sostituire il carattere con uno non trovabile
                                                           a:=0;
                                                           goto riprova; // stessa riga
                                                           end;
          end
         else
          if jolly then a:=posJolly(appx,app,1)
                   else a:=pos(appx,app);
until (a<>0)or(ii>=ymax);
if a<>0 then
        begin
        Set_Cursore_X(a+length(appx)-1);
        yy:=y+ii-iy;
        iy:=ii;
        if yy>riga_menu-1 then y:=riga_menu-1
                          else y:=byte(yy);
        if SC then
              begin
              inc(count);
              goto restart;
              end
             else
              begin
              Azzera_Selezione;
              Selezionato.x1:=x_riga-1;
              Selezionato.y1:=iy;
              Selezionato.x2:=x_riga-length(cerco);
              Selezionato.y2:=iy;
              Evidenzia_Selezione;
              end;
        end
       else
        begin
        if SC then
           begin
           x:=old_x;
           x_riga:=old_x_riga;
           x_min:=old_x_min;
           iy:=old_iy;
           y:=old_y;
           if selezione and (not binario) and (selezionato.x1<>0) then
                                                                  else Conto(count);
           Exit(count);  {non serve Evidenzia_Selezione}
           end;
        if tutto=false then
           begin
           if selezione and (not binario) and (selezionato.x1<>0) then
                                                                else
                                                                 begin
                                                                 x:=old_x;
                                                                 x_riga:=old_x_riga;
                                                                 x_min:=old_x_min;
                                                                 iy:=old_iy;
                                                                 y:=old_y;
                                                                 Evidenzia_Selezione;
                                                                 not_found;  {non trovato}
                                                                 end;
           exit(0);
           end;
        end;
exit(-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure CercaMaMi_Giu; // ver 2.25
var x_,y_:byte;
    s:string;
    posizione_inizio_selezione,posizione_fine_selezione,posizione_cursore,
    iy_,ymax_,old_x_min,old_x_riga,trovato:integer;
    selezione_precedente:selez;
begin
if per_riga and (not binario) then
   begin
   Cerca_per_riga;
   Exit;
   end;
if (not selezione) or binario or (selezionato.x1=0) then
   begin
   CercaMaMi_Giu_;
   Exit;
   end;
selezione_precedente:=selezionato;

x_:=x;  // salva dati
y_:=y;
iy_:=iy;
ymax_:=ymax;
old_x_min:=x_min;
old_x_riga:=x_riga;
posizione_cursore:=(iy-1)*lunghezza_riga+x;
posizione_fine_selezione:=(selezionato.y2-1)*lunghezza_riga+selezionato.x2;
posizione_inizio_selezione:=(selezionato.y1-1)*lunghezza_riga+selezionato.x1;

if (posizione_cursore<posizione_inizio_selezione)or(posizione_cursore>posizione_fine_selezione) then
   begin
   Set_Cursore_X(selezionato.x1);    // aggiorna dati
   iy:=selezionato.y1;
   end;

y:=1;
ymax:=selezionato.y2;
s:=testo[ymax];
setlength(testo[ymax],selezionato.x2+1);
evidenzia_selezione;

trovato:=CercaMaMi_Giu_;
if trovato=0 then     // ripristina dati
   begin
   x:=x_;
   y:=y_;
   iy:=iy_;
   x_min:=old_x_min;
   x_riga:=old_x_riga;
   end;
testo[ymax]:=s;
ymax:=ymax_;

selezionato:=selezione_precedente;
evidenzia_selezione;
if trovato=0 then not_found;
if trovato>0 then Conto(trovato);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Configura2;  // configurazione EDITOR  ver 2.25 , update ver 2.58
{$define Stato_Cursore:=
          begin
          case stato_ of
            14: gotoxy(45,24);
            13: gotoxy(45,23);
            12: gotoxy(45,21);
            11: gotoxy(45,20);
            10: gotoxy(45,19);
             9: gotoxy(45,16);
             8: gotoxy(45,15);
             7: gotoxy(45,14);
             6: gotoxy(45,11);
             5: gotoxy(45,10);
             4: gotoxy(45,7);
             3: gotoxy(45,6);
             2: gotoxy(45,5);
             1: gotoxy(45,4);
            end;
            cursorON;
          end  }
{$define stato_Ok_End:=
         begin
         gotoxy(34,25);
         write(' ');
         gotoxy(39,25);
         write('  ');
         gotoxy(46,25);
         write(' ');
         end; }
{$define assegna_stato:=
           begin
           if length(c)=1 then
              if upcase(c[1])=Lingue.get_charUp(389) then stato_:=14 else  // 'T'
              if upcase(c[1])=Lingue.get_charUp(388) then stato_:=13 else  // 'E'
              if upcase(c[1])=Lingue.get_charUp(387) then stato_:=12 else  // 'R'
              if upcase(c[1])=Lingue.get_charUp(386) then stato_:=11 else  // 'V'
              if upcase(c[1])=Lingue.get_charUp(385) then stato_:=10 else  // 'G'
              if upcase(c[1])=Lingue.get_charUp(383) then stato_:=9 else   // 'P'
              if upcase(c[1])=Lingue.get_charUp(382) then stato_:=8 else   // 'F'
              if upcase(c[1])=Lingue.get_charUp(381) then stato_:=7 else   // 'I'
              if upcase(c[1])=Lingue.get_charUp(379) then stato_:=6 else   // 'N'
              if upcase(c[1])=Lingue.get_charUp(378) then stato_:=5 else   // 'S'
              if upcase(c[1])=Lingue.get_charUp(376) then stato_:=4 else   // 'Q'
              if upcase(c[1])=Lingue.get_charUp(375) then stato_:=3 else   // 'A'
              if upcase(c[1])=Lingue.get_charUp(374) then stato_:=2 else   // 'M'
              if upcase(c[1])=Lingue.get_charUp(373) then stato_:=1;       // 'C'
           end; }
{$define parentesi_quadre:=
         gotoxy(44,whereY-1);
         writeln('[ ]');
         }
var cliccato,old_barra_pag,old_mancino,old_salva_tab,old_selezione_quadrata,
    old_topo,old_Home,old_fine_,insert,modifica_configura2,
    old_salva_configurazione,old_salva_visualizza,old_salva_recenti,
    salva_configurazione,salva_visualizza,salva_recenti:boolean;
    old_Tab_num,old_next_max_righe_txt,old_next_max_righe_esa:integer;
    old_num_notes:longint;
    i,posto,posto2,posto3,posto4,stato_:byte;
    error:word;
    c,stringa,stringa2,stringa3,stringa4:shortstring;
label theMouse,tasti,read_tab,read_tab1,read_tab2,read_uscita,read_num_notes;
const posto_tasto_ok=15;
begin
modifica_configura2:=true;
hidemouse;
stato_:=posto_tasto_ok;
cursoroff;
textcolor(lightred);
textbackground(blue);
clrscr;
gotoxy(39-Lingue.get_length_txt(371) div 2,1);
writeln(Lingue.get_txt(371)+invio); //  'Configurazione 2 di Editor'

textcolor(white);
writeln(Lingue.get_txt(372)); // 'Impostazioni valide solo per il mouse:'
writeln(Lingue.get_txt(373)); // '- Click su barra verticale come pag Su/Giu [ ]  (anziche'' come percentuale)'
parentesi_quadre;
writeln(Lingue.get_txt(374));  // '- Mancino (inverti tasti)'
parentesi_quadre;
writeln(Lingue.get_txt(375));  // '- Abilita/Disabilita mouse (solo per DOS)  [ ]  (solo se e'' supportato)'
parentesi_quadre;
writeln(Lingue.get_txt(376));  // '- Selezione a forma di quadrato'
parentesi_quadre;

writeln(invio+Lingue.get_txt(377)); // 'Impostazioni valide per il tasto TAB:  (solo nel formato testo)'
writeln(Lingue.get_txt(378)); // '- Salva usando il carattere TAB'
parentesi_quadre;
write(Lingue.get_txt(379)); // '- Numero di spazi usati (consigliato=8)    [    ]'
gotoxy(44,whereY);
writeln('[    ]');

writeln(invio+Lingue.get_txt(380));  // 'Impostazioni generali:'
writeln(Lingue.get_txt(381));  // '- Cursore ad inizio parola premendo INIZIO'
parentesi_quadre;
writeln(Lingue.get_txt(382));  // '- Cursore a fine parola premendo FINE'
parentesi_quadre;
writeln(Lingue.get_txt(383));  // '- Numero massimo di appunti in memoria     [           ]  (0=illimitato)'

writeln(invio+Lingue.get_txt(384));  // 'Impostazioni per editor.ini:  (in uscita dal programma)'
writeln(Lingue.get_txt(385)); // '- Salva la configurazione'
parentesi_quadre;
writeln(Lingue.get_txt(386)); // '- Salva la lista dei file in visualizza'
parentesi_quadre;
writeln(Lingue.get_txt(387)); // '- Salva la lista dei file recenti'
parentesi_quadre;

writeln;
writeln(Lingue.get_txt(388)); // '- Numero di righe nel formato testo        [           ]  (suggerito 6.000)'
writeln(Lingue.get_txt(389)); // '- Numero di righe nel formato esadecimale  [           ]  (suggerito 810)'
gotoxy(34,25);
write('[    ]');
showmouse;
Pre_Tasti(35,25);

old_barra_pag:=barra_pag;    {salvo i valori prima di modificarli}
old_topo:=topo;
old_mancino:=Doppio_Click.get_mancino();
old_salva_tab:=salva_tab;
old_selezione_quadrata:=selezione_quadrata;
old_Tab_num:=Tab_num;
old_Home:=home;
old_fine_:=fine_;
old_num_notes:=num_notes;
salva_configurazione:=editor_ini.get_salva_configurazione;
salva_visualizza:=editor_ini.get_salva_visualizza;
salva_recenti:=editor_ini.get_salva_recenti;
old_salva_configurazione:=salva_configurazione;
old_salva_visualizza:=salva_visualizza;
old_salva_recenti:=salva_recenti;
old_next_max_righe_txt:=next_max_righe_txt;
old_next_max_righe_esa:=next_max_righe_esa;
next_max_righe_txt:=next_max_righe_txt-2;
next_max_righe_esa:=next_max_righe_esa-2;

textcolor(13); // evidenzio i tasti di scelta rapida
gotoxy(Lingue.get_pos_rosso(373),4);
write(Lingue.get_char(373));  // 'C'
gotoxy(Lingue.get_pos_rosso(374),5);
write(Lingue.get_char(374));  // 'M'
gotoxy(Lingue.get_pos_rosso(375),6);
write(Lingue.get_char(375));  // 'A'
gotoxy(Lingue.get_pos_rosso(376),7);
write(Lingue.get_char(376));  // 'q'
gotoxy(Lingue.get_pos_rosso(378),10);
write(Lingue.get_char(378));  // 'S'
gotoxy(Lingue.get_pos_rosso(379),11);
write(Lingue.get_char(379));  // 'N'
gotoxy(Lingue.get_pos_rosso(381),14);
write(Lingue.get_char(381));  // 'I'
gotoxy(Lingue.get_pos_rosso(382),15);
write(Lingue.get_char(382));  // 'F'
gotoxy(Lingue.get_pos_rosso(383),16);
write(Lingue.get_char(383));  // 'p'
gotoxy(Lingue.get_pos_rosso(385),19);
write(Lingue.get_char(385));  // 'g'
gotoxy(Lingue.get_pos_rosso(386),20);
write(Lingue.get_char(386));  // 'v'
gotoxy(Lingue.get_pos_rosso(387),21);
write(Lingue.get_char(387));  // 'r'
gotoxy(Lingue.get_pos_rosso(388),23);
write(Lingue.get_char(388));  // 't'
gotoxy(Lingue.get_pos_rosso(389),24);
write(Lingue.get_char(389));  // 'e'

stringa:=inttostr(Tab_num);
stringa2:=inttostr(num_notes);
stringa3:=inttostr(next_max_righe_txt);
stringa4:=inttostr(next_max_righe_esa);

insert:=false;
posto:=1;
posto2:=1;
posto3:=1;
posto4:=1;
   {sono ripetuti per non annullare il vero valore}
Metti_X(45,7,selezione_quadrata);
Metti_X(45,7,selezione_quadrata);
Metti_X(45,6,topo);
Metti_X(45,6,topo);
Metti_X(45,5,mancino);
Metti_X(45,5,mancino);
Metti_X(45,4,barra_pag);
Metti_X(45,4,barra_pag);
Metti_X(45,10,salva_tab);
Metti_X(45,10,salva_tab);
Metti_X(45,14,Home);
Metti_X(45,14,Home);
Metti_X(45,15,Fine_);
Metti_X(45,15,Fine_);

Metti_X(45,19,salva_configurazione);
Metti_X(45,19,salva_configurazione);
Metti_X(45,20,salva_visualizza);
Metti_X(45,20,salva_visualizza);
Metti_X(45,21,salva_recenti);
Metti_X(45,21,salva_recenti);

gotoxy(45,11);
write(Tab_num);
gotoxy(45,16);
write(num_notes);
gotoxy(45,23);
write(next_max_righe_txt);
gotoxy(45,24);
write(next_max_righe_esa);

showmouse;
repeat
 if (PollKeyEvent=0) and topo then
           begin
           sleep(5);
           {$ifdef go32v2}
            cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
           {$else}
            cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
           {$endif}
           if cliccato then stato:=1
                       else stato:=0;
    theMouse:
           if (stato=1)and(moy= 7)and(mox=45) then
                                              begin
                                              Metti_X(45,7,selezione_quadrata);
                                              stato_Ok_End;
                                              gotoxy(45,7);
                                              stato_:=4;
                                              end else
           {$ifdef Go32v2}  // solo per DOS
           if (stato=1)and(moy= 6)and(mox=45) then
                                              begin
                                              Metti_X(45,6,topo);
                                              stato_Ok_End;
                                              gotoxy(45,6);
                                              stato_:=3;
                                              end else
           {$ENDIF}
           if (stato=1)and(moy= 5)and(mox=45) then
                                              begin
                                              Metti_X(45,5,mancino);
                                              stato_Ok_End;
                                              gotoxy(45,5);
                                              stato_:=2;
                                              end else
           if (stato=1)and(moy= 4)and(mox=45) then
                                              begin
                                              Metti_X(45,4,barra_pag);
                                              stato_Ok_End;
                                              gotoxy(45,4);
                                              stato_:=1;
                                              end else
           if (stato=1)and(moy=10)and(mox=45) then
                                              begin
                                              Metti_X(45,10,salva_tab);
                                              stato_Ok_End;
                                              gotoxy(45,10);
                                              stato_:=5;
                                              end else
           if (stato=1)and(moy=14)and(mox=45) then
                                              begin
                                              Metti_X(45,14,Home);
                                              stato_Ok_End;
                                              gotoxy(45,14);
                                              stato_:=7;
                                              end else
           if (stato=1)and(moy=15)and(mox=45) then
                                              begin
                                              Metti_X(45,15,fine_);
                                              stato_Ok_End;
                                              gotoxy(45,15);
                                              stato_:=8;
                                              end else
           if (stato=1)and(moy=19)and(mox=45) then
                                              begin
                                              Metti_X(45,19,salva_configurazione);
                                              stato_Ok_End;
                                              gotoxy(45,19);
                                              stato_:=10;
                                              end else
           if (stato=1)and(moy=20)and(mox=45) then
                                              begin
                                              Metti_X(45,20,salva_visualizza);
                                              stato_Ok_End;
                                              gotoxy(45,20);
                                              stato_:=11;
                                              end else
           if (stato=1)and(moy=21)and(mox=45) then
                                              begin
                                              Metti_X(45,21,salva_recenti);
                                              stato_Ok_End;
                                              gotoxy(45,21);
                                              stato_:=12;
                                              end;
           if stato=1 then
              if stato_<posto_tasto_ok-1 then cursorON
                                         else cursorOFF;
           if (stato=1)and(mox>40)and(mox<46)and(moy=25) then  {ESC}
                     begin   {ripristino i valori originali}
                read_uscita:
                     modifica_configura2:=false;
                     num_notes:=old_num_notes;
                     barra_pag:=old_barra_pag;
                     topo:=old_topo;
                     mancino:=old_mancino;
                     Doppio_Click.set_mancino(old_mancino);
                     salva_tab:=old_salva_tab;
                     selezione_quadrata:=old_selezione_quadrata;
                     Tab_num:=old_Tab_num;
                     Home:=old_home;
                     fine_:=old_fine_;
                     salva_configurazione:=old_salva_configurazione;
                     salva_visualizza:=old_salva_visualizza;
                     salva_recenti:=old_salva_recenti;
                     next_max_righe_txt:=old_next_max_righe_txt;
                     next_max_righe_esa:=old_next_max_righe_esa;
                     Break;
                     end;
           if (stato=1)and(mox>34)and(mox<39)and(moy=25) then break;  {INVIO}
           if (stato=1)and(mox>44)and(mox<56)and(moy=16) then
              begin
              stato_Ok_End;
      read_num_notes:
              stato_:=9;
              repeat
               gotoxy(wherex,16);
               stringa2:=ReadString(stringa2,45,55,0,topo,true,old_mancino,insert,moy,mox,posto2);
               if (mox=27)and(moy=0)and(stringa2='') then
                                  begin
                                  updatescreen(true);
                                  Evidenzia_Selezione;
                                  goto read_uscita;
                                  end;
               if stringa2='' then
                              begin
                              stringa2:=inttostr(num_notes);
                              write(stringa2);
                              hidemouse;
                              showmouse;
                              end;
               Val_Try(stringa2,num_notes,error);
               if (error>0)or(num_notes<0) then
                                  begin
                                  error:=1;
                                  sonoro;
                                  Continue;
                                  end;
               if moy=255 then // ALT+?
                  if upcase(char(mox)) in // was  ['P','C','M','A','Q','S','N','I','F','G','V','R','T','E'] then
                         [Lingue.get_charUP(373),Lingue.get_charUP(374),Lingue.get_charUP(375),Lingue.get_charUP(376),Lingue.get_charUP(378),Lingue.get_charUP(379),
                          Lingue.get_charUP(381),Lingue.get_charUP(382),Lingue.get_charUP(383),Lingue.get_charUP(385),Lingue.get_charUP(386),Lingue.get_charUP(387),
                          Lingue.get_charUP(388),Lingue.get_charUP(389)] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
              until error=0;
              stato:=bool(moy>0);
              if (moy=0) and (mox=13) then break;
              cursoroff;
              if (moy=0) and (mox=9) then
                                     begin
                                     c:=#9; // tab simulato
                                     goto tasti;
                                     end;
              if (moy=0) and (mox=7) then   // shift+tab
                                     begin
                                     stato_Ok_End;
                                     stato_:=8;
                                     stato_cursore;
                                     end;
              goto theMouse;
              end;
           if (stato=1)and(mox>44)and(mox<49)and(moy=11) then
                   begin        // numero spazi per TAB
                   stato_Ok_End;
                   stato_:=6;
               read_tab:
                   repeat
                    gotoxy(wherex,11);
                    stringa:=ReadString(stringa,45,48,0,topo,true,old_mancino,insert,moy,mox,posto);
                    if (mox=27)and(moy=0)and(stringa='') then
                                  begin
                                  updatescreen(true);
                                  Evidenzia_Selezione;
                                  goto read_uscita;
                                  end;
                    if stringa='' then
                                  begin
                                  stringa:=inttostr(Tab_num);
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    Val_Try(stringa,Tab_num,error);
                    if (error>0)or(tab_num>lunghezza_riga)or(tab_num<1) then
                                  begin
                                  error:=1;
                                  sonoro;
                                  Continue;
                                  end;
                    if moy=255 then  // ALT+?
                       if upcase(char(mox)) in // was  ['P','C','M','A','Q','S','N','I','F','G','V','R','T','E'] then
                         [Lingue.get_charUP(373),Lingue.get_charUP(374),Lingue.get_charUP(375),Lingue.get_charUP(376),Lingue.get_charUP(378),Lingue.get_charUP(379),
                          Lingue.get_charUP(381),Lingue.get_charUP(382),Lingue.get_charUP(383),Lingue.get_charUP(385),Lingue.get_charUP(386),Lingue.get_charUP(387),
                          Lingue.get_charUP(388),Lingue.get_charUP(389)] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   cursoroff;
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_Ok_End;
                                          stato_:=7;
                                          stato_cursore;
                                          end;
                   if (moy=0) and (mox=7) then
                                          begin
                                          stato_Ok_End;
                                          stato_:=5;
                                          stato_cursore;
                                          end;
                   goto theMouse;
                   end else
           if (stato=1)and(mox>44)and(mox<56)and(moy=23) then
                   begin   // max num righe TXT
                   stato_Ok_End;
                   stato_:=13;
               read_tab1:
                   repeat
                    gotoxy(wherex,23);
                    stringa3:=ReadString(stringa3,45,55,0,topo,true,old_mancino,insert,moy,mox,posto3);
                    if (mox=27)and(moy=0)and(stringa3='') then
                                  begin
                                  updatescreen(true);
                                  Evidenzia_Selezione;
                                  goto read_uscita;
                                  end;
                    if stringa3='' then
                                   begin
                                   stringa3:=inttostr(next_max_righe_txt);
                                   write(stringa3);
                                   hidemouse;
                                   showmouse;
                                   end;
                    Val_Try(stringa3,next_max_righe_txt,error);
                    if (error>0)or(next_max_righe_txt<1) then
                                  begin
                                  error:=1;
                                  sonoro;
                                  Continue;
                                  end;
                    if moy=255 then  // ALT+?
                       if upcase(char(mox)) in // was    ['P','C','M','A','Q','S','N','I','F','G','V','R','T','E'] then
                         [Lingue.get_charUP(373),Lingue.get_charUP(374),Lingue.get_charUP(375),Lingue.get_charUP(376),Lingue.get_charUP(378),Lingue.get_charUP(379),
                          Lingue.get_charUP(381),Lingue.get_charUP(382),Lingue.get_charUP(383),Lingue.get_charUP(385),Lingue.get_charUP(386),Lingue.get_charUP(387),
                          Lingue.get_charUP(389)] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   cursoroff;
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_Ok_End;
                                          stato_:=14;
                                          mox:=45;
                                          moy:=24;
                                          stato:=1;
                                          stato_cursore;
                                          end;
                   if (moy=0) and (mox=7) then
                                     begin
                                     stato_Ok_End;
                                     stato_:=12;
                                     stato_cursore;
                                     end;
                   goto theMouse;
                   end else
           if (stato=1)and(mox>44)and(mox<56)and(moy=24) then
                   begin    // max num righe ESA
                   stato_Ok_End;
                   stato_:=14;
               read_tab2:
                   repeat
                    gotoxy(wherex,24);
                    stringa4:=ReadString(stringa4,45,55,0,topo,true,old_mancino,insert,moy,mox,posto4);
                    if (mox=27)and(moy=0)and(stringa4='') then
                                  begin
                                  updatescreen(true);
                                  Evidenzia_Selezione;
                                  goto read_uscita;
                                  end;
                    if stringa4='' then
                                   begin
                                   stringa4:=inttostr(next_max_righe_esa);
                                   write(stringa4);
                                   hidemouse;
                                   showmouse;
                                   end;
                    Val_Try(stringa4,next_max_righe_esa,error);
                    if (error>0)or(next_max_righe_esa<1) then
                                  begin
                                  error:=1;
                                  sonoro;
                                  Continue;
                                  end;
                    if moy=255 then  // ALT+?  // configurazione 1 e 2
                       if upcase(char(mox)) in // was ['P','C','M','A','Q','S','N','I','F','G','V','R','T'] then
                           [Lingue.get_charUP(373),Lingue.get_charUP(374),Lingue.get_charUP(375),Lingue.get_charUP(376),Lingue.get_charUP(378),Lingue.get_charUP(379),
                            Lingue.get_charUP(381),Lingue.get_charUP(382),Lingue.get_charUP(383),Lingue.get_charUP(385),Lingue.get_charUP(386),Lingue.get_charUP(387),
                            Lingue.get_charUP(388)] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   cursoroff;
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_:=14;
                                          c:=#9;
                                          goto tasti;
                                          end;
                    if (moy=0) and (mox=7) then
                                     begin
                                     stato_Ok_End;
                                     stato_:=13;
                                     stato:=1;     // fix ver 3.40
                                     mox:=45;      // fix ver 3.40
                                     moy:=23;      // fix ver 3.40
                                     stato_cursore;
                                     end;
                   goto theMouse;
                   end;
           end
          else
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if length(c)=1 then c:=upcase(c);
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if c=' ' then
                    begin
                    case stato_ of
                      14: c:=Lingue.get_charUp(389); // 'E'
                      13: c:=Lingue.get_charUp(388); // 'T'
                      12: c:=Lingue.get_charUp(387); // 'R'
                      11: c:=Lingue.get_charUp(386); // 'V'
                      10: c:=Lingue.get_charUp(385); // 'G'
                      9 : c:=Lingue.get_charUp(383); // 'P'
                      8 : c:=Lingue.get_charUp(382); // 'F'
                      7 : c:=Lingue.get_charUp(381); // 'I'
                      6 : c:=Lingue.get_charUp(379); // 'N'
                      5 : c:=Lingue.get_charUp(378); // 'S'
                      4 : c:=Lingue.get_charUp(376); // 'Q'
                      {$ifdef Go32v2}
                      3 : c:=Lingue.get_charUp(375); // 'A'
                      {$else}
                      3 : c:=#1; // un valore senza senso
                      {$ENDIF}
                      2 : c:=Lingue.get_charUp(374); // 'M'
                      1 : c:=Lingue.get_charUp(373); // 'C'
                      end;
                    if stato_ in [1..posto_tasto_ok-1] then
                            begin
                            stato_Ok_End;
                            stato_cursore;
                            end;
                    end;
  tasti:   if (c=#9) then
                    begin  // TAB
                    inc(stato_);
                    if stato_=6 then goto read_tab;
                    if stato_=13 then goto read_tab1;
                    if stato_=14 then goto read_tab2;
                    if stato_=9 then goto read_num_notes;
                    if stato_>posto_tasto_ok+1 then
                                 begin
                                 stato_:=1;
                                 gotoxy(40,25);
                                 write(' ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                    if stato_<posto_tasto_ok then stato_cursore
                                else
                                  begin
                                  cursorOFF;
                                  if stato_=posto_tasto_ok then
                                               begin
                                               gotoxy(34,25);
                                               write('[');
                                               gotoxy(39,25);
                                               write(']');
                                               end
                                              else // stato=posto_tasto_ok+1=14
                                               begin
                                               gotoxy(34,25);
                                               write(' ');
                                               gotoxy(39,25);
                                               write(' [');
                                               gotoxy(46,25);
                                               write(']');
                                               end;
                                  end;
                    end else
           if (c=#27) or ( ((c=' ')or(c=#13)) and (stato_=posto_tasto_ok+1) ) then
                    begin
                    stato:=1;
                    mox:=41;
                    moy:=25;
                    goto theMouse;
                    end else
           if (c=#13)or(c=' ') then
                    begin
                    if stato_<=posto_tasto_ok then break
                    end else
           if (c=Lingue.get_charUP(381){'I'}) then Metti_X(45,14,Home) else
           if (c=Lingue.get_charUP(382){'F'}) then Metti_X(45,15,Fine_) else
           if (c=Lingue.get_charUP(376){'Q'}) then Metti_X(45,7,selezione_quadrata) else
           if (c=Lingue.get_charUP(374){'M'}) then Metti_X(45,5,mancino) else
           if (c=Lingue.get_charUP(373){'C'}) then Metti_X(45,4,barra_pag) else
           {$ifdef Go32v2}
           if (c=Lingue.get_charUP(375){'A'}) then Metti_X(45,6,topo) else
           {$ENDIF}
           if (c=Lingue.get_charUP(378){'S'}) then Metti_X(45,10,Salva_tab) else
           if (c=Lingue.get_charUP(385){'G'}) then Metti_X(45,19,salva_configurazione) else
           if (c=Lingue.get_charUP(386){'V'}) then Metti_X(45,20,salva_visualizza) else
           if (c=Lingue.get_charUP(387){'R'}) then Metti_X(45,21,salva_recenti) else
           if (c=Lingue.get_charUP(379){'N'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=11;
                      goto theMouse;
                      end else
           if (c=Lingue.get_charUP(389){'E'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=24;
                      goto theMouse;
                      end else
           if (c=Lingue.get_charUP(388){'T'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=23;
                      goto theMouse;
                      end else
           if (c=Lingue.get_charUP(383){'P'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=16;
                      goto theMouse;
                      end;
           if (length(c)=1) and (upcase(c[1]) in // was ['P','C','M','A','Q','S','N','I','F','G','V','R']) then
                           [Lingue.get_charUP(373),Lingue.get_charUP(374),Lingue.get_charUP(375),Lingue.get_charUP(376),Lingue.get_charUP(378),Lingue.get_charUP(379),
                            Lingue.get_charUP(381),Lingue.get_charUP(382),Lingue.get_charUP(383),Lingue.get_charUP(385),Lingue.get_charUP(386),Lingue.get_charUP(387)] ) then
                      begin
                      stato_Ok_End;
                      assegna_stato;
                      stato_cursore;
                      end
                     else
                      if length(c)=1 then assegna_stato;
           if (c='Down')or(c='Right') then
                          begin  // freccia giu'/destra
                          c:=#9;
                          goto tasti;
                          end else
           if (c='Up')or(c='Left')or(c='SHIFT Key with scancode 3840') then // shift+tab
                          begin      // freccia su/sinistra   72,75
                          if stato_ in [posto_tasto_ok..posto_tasto_ok+1] then
                                 begin
                                 gotoxy(34,25);
                                 write(' ');
                                 gotoxy(39,25);
                                 write('  ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                          if stato_=2 then stato_:=posto_tasto_ok+1
                             else if stato_=1 then stato_:=posto_tasto_ok
                                              else dec(stato_,2);
                          c:=#9;
                          goto tasti;
                          end
                      else c:=#1;
           end;
until false;
editor_ini.set_salva_configurazione(salva_configurazione);
editor_ini.set_salva_visualizza(salva_visualizza);
editor_ini.set_salva_recenti(salva_recenti);

{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,20*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
if not {$ifdef Go32v2}mousefound{$else}(detectMouse>0){$endif} then topo:=false;
Doppio_Click.set_mancino(mancino);
for i:=1 to length(listaY) do
                           begin
                           listaY[i].topo:=topo;
                           listaY[i].mancino:=mancino;
                           end;
listaX.mancino:=mancino;
listaX.topo:=topo;
if old_selezione_quadrata<>selezione_quadrata then Azzera_Selezione;
if (num_notes<old_num_notes)and(num_notes>0) then
   while length(appunti)>num_notes do
         rimuovi_ultimo_appunto
   else
if (num_notes>old_num_notes)and(old_num_notes=0) then
   while length(appunti)>num_notes do
         rimuovi_ultimo_appunto;
if modifica_configura2 then
   begin
   Editor_Ini.Set_modifica(modifica_configura2);
   Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Num_Notes'{nome_tipo},intToStr(num_notes));
   Editor_Ini.Aggiorna('OPZIONI','BarraPag',boolToStr(barra_pag));
   Editor_Ini.Aggiorna('OPZIONI','/DM',boolToStr(not topo));
   Editor_Ini.Aggiorna('OPZIONI','Mancino',boolToStr(mancino));
   Editor_Ini.Aggiorna('OPZIONI','Salva_Tab',boolToStr(salva_tab));
   Editor_Ini.Aggiorna('OPZIONI','Tab',IntToStr(tab_num));
   Editor_Ini.Aggiorna('OPZIONI','Home',boolToStr(home));
   Editor_Ini.Aggiorna('OPZIONI','End',boolToStr(fine_));
   Editor_Ini.Aggiorna('OPZIONI','Selezione_Quadrata',boolToStr(Selezione_Quadrata)); // ver 2.63
   Editor_Ini.Aggiorna('OPZIONI','Salva_Configurazione',boolToStr(editor_ini.get_salva_configurazione())); // ver 2.68
   Editor_Ini.Aggiorna('OPZIONI','Salva_Recenti',boolToStr(editor_ini.get_salva_Recenti())); // ver 2.68
   Editor_Ini.Aggiorna('OPZIONI','Salva_Visualizza',boolToStr(editor_ini.get_salva_Visualizza())); // ver 2.68
   Editor_Ini.Aggiorna('OPZIONI','Max_Righe_Txt',intToStr(next_max_righe_txt)); // ver 2.73
   Editor_Ini.Aggiorna('OPZIONI','Max_Righe_Esa',intToStr(next_max_righe_esa)); // ver 2.73
   next_max_righe_txt:=next_max_righe_txt+2;
   next_max_righe_esa:=next_max_righe_esa+2;
   end;
Evidenzia_Selezione;
stato:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__TE_Esa(var riga:string);   // ver 2.31
var i,j:longint;
    s:string;
begin
for i:=1 to strtoint(copy(riga,11,4)) {numero_righe} do
    begin
    s:=annulla_esa.estrai_iniziale;
    for j:=1 to length(s) do
        if length(testo[ymax])=lunghezza_riga+1 then
                                                begin
                                                inc(ymax);
                                                inc(iy);
                                                testo[ymax]:=#13+s[j];
                                                end
                                               else
                                                testo[ymax]:=testo[ymax]+s[j];
    end;
iy:=ymax;
x_riga:=length(testo[iy]);
x_min:=max(1,x_riga-80+1);
x:=byte(min(x_riga-x_min+1,80));
y:=byte(min(ymax,20));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__I_Esa; // ver 2.30
begin
ymax:=iy;
setlength(testo[iy],x_riga);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__CL(var riga:string);        // ver 1.80
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
case riga[11] of
      'G': case length(riga) of
                11 : begin
                     testo[iy+1]:=#13;
                     dec(ymax);
                     end;
                13 : setlength(testo[iy+1],ord(riga[13])); // riga[12] ignorata
                end;
      'S': begin
           if y=0 then y:=1;
           setlength(testo[iy-1],ord(riga[13])); // riga[12] ignorata
           end;
      'D': case length(riga) of
                11: setlength(testo[iy],length(testo[iy])-1);
                12: begin              // riga[12]=='-'
                    testo[ymax]:=#13;
                    dec(ymax);
                    end;
                end;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function FreeAnnulla(righe:longint):boolean;  // ver 1.80 , update ver 2.31
var i:longint;
    p:ptrx;
    str:string;
    valido,ho_cancellato:boolean;
begin
righe:=righe*(lunghezza_riga+20); // +20 per eccesso, di proposito
ho_cancellato:=false;
while (memAvail<righe)and(Annulla_Txt.numelementi>0) do  // toglie pezzi di annulla vecchi per liberare memoria
      begin     // devo ottenere quello che devo eliminare: se str[10] = 7 o 3 , ripulire anche in annulla_esa
      str:=ldu_pch.get_iesimo(Annulla_Txt.l{pointer},Annulla_Txt.numelementi{iesimo},valido);
      if (copy(str,10,1)='7') or (copy(str,10,1)='3') then
         for i:=1 to strtoint(copy(str,11,4)) do annulla_esa.cancella_iniziale;
      Annulla_Txt.cancella_finale;
      Annulla_Selezione.cancella_finale;
      ho_cancellato:=true;
      end;
if not ho_cancellato then Exit(true);    // serve quando c'e' input carattere x carattere
repeat                  { deve finire quando il primo char = '1' }
 p:=Annulla_Txt.l;
 if Annulla_Txt.numelementi=0 then break;
 for i:=1 to Annulla_Txt.numelementi-1 do p:=p^.next;
 if p<>nil then   // toglie pezzi di annulla incompleti, rimosssi precedentemente
           if strpas(p^.info)[1]='1' then break
                                     else
                                      begin
                                      Annulla_Txt.cancella_finale;
                                      Annulla_Selezione.cancella_finale;
                                      end;
until false;
FreeAnnulla:=not(memAvail<righe);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Invio(aggiorna_video:boolean):boolean;    // update 1.85 , 2.83
var i:integer;
begin
if ymax=MaxR then
   begin
   Righe_Finite;
   {$ifdef TxtVideo}
   grafica;
   UpdateScreen(true);
   {$endif}
   Exit(false);
   end;
Tasto__Invio:=true;
Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
if (selezionato.x1<>0) and (ymax<MaxR) then
   if (iy<selezionato.y1) or ( (iy=selezionato.y1) and (x_riga=1) ) then // almeno una riga prima della selezione
                        begin
                        inc(selezionato.y1);
                        inc(selezionato.y2);
                        end else
   if (iy=selezionato.y1)and(x_riga<selezionato.x1) then   // invio, nella riga selezionata, ma prima della selezione
      begin
      inc(selezionato.y1);
      dec(selezionato.x1,x_riga-1);
      if selezionato.y2=iy then dec(selezionato.x2,x_riga-1);
      inc(selezionato.y2);
      end else
   if (selezionato.y1=selezionato.y2)and(x_riga>=selezionato.x2) then else
   if ( (x_riga>selezionato.x1) and (selezionato.y1=iy) ) or ( (selezionato.y1<iy)and(iy<selezionato.y2) )
      then // dentro la selezione, esclusa l'ultima riga e se sono all'inizio della selezione
       begin
       if selezionato.y1=selezionato.y2 then selezionato.x2:=selezionato.x2+1-x_riga;
       inc(selezionato.y2);
       end else
   if (selezionato.y1<>selezionato.y2)and(x_riga<=selezionato.x2)and(selezionato.y2=iy) then
      begin      // invio nell' ultima riga, fra piu' selezionate
      inc(selezionato.y2);
      dec(selezionato.x2,x_riga-1);
      end else
   if (x_riga=selezionato.x1) and (selezionato.y1=iy) then
      begin   // all'inizio, in assoluto
      inc(selezionato.y2);
      selezionato.x1:=1;
      inc(selezionato.y1);
      if selezionato.y1=selezionato.y2 then dec(selezionato.x2,x_riga-1);
      end;

if iy<MaxR then {taglia la riga a meta' se e' necessario}
       begin
       if vera_tastiera and FreeAnnulla(1) then Annulla_Txt.input_iniziale(strnew(stringtopchar('0'+undo__x_prepara()+zero(inttostr(y),2)+zero(inttostr(iy),4)+'V')));
       inc(ymax);
       if ymax>MaxR then ymax:=MaxR;
       if mem_automatica and (length(testo)-2<ymax) then setlength(testo,ymax*2+2); // ver 2.88
       for i:=ymax downto iy+1 do testo[i]:=testo[i-1];
       inc(iy);
       testo[iy]:=#13+copy(testo[iy-1],x_riga+1,length(testo[iy-1])-x_riga);
       setlength(testo[iy-1],x_riga);
       inc(y);
       x_riga:=1;
       x_min:=x_riga;
       x:=1;
       x_reale:=x;
       end;
if y>(riga_menu-1) then
        begin
        y:=(riga_menu-1);
        {$ifdef TxtVideo}
        _start:=iy-(riga_menu-2);
        _end:=iy;
        {$endif}
        end
       else
        begin
        {$ifdef TxtVideo}
        _start:=iy-1;
        _end:=iy+18;
        {$endif}
        end;
if aggiorna_video then Evidenzia_Selezione;
if iy>MaxR then iy:=MaxR;
modifica_on;
normale;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Back_Space(var riga:string);  { ver 1.80 }
var i:integer;
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
case length(riga) of
      11: insert(riga[11],testo[iy],x_riga);
      18: begin
          inc(ymax);
          for i:=ymax-1 downto iy do testo[i+1]:=testo[i];
          testo[iy+1]:=testo[iy];
          while length(testo[iy+1])>strtoint(copy(riga,11,2)) do testo[iy+1]:=copy_end(testo[iy+1],2);
          testo[iy+1]:=#13+copy_end(testo[iy+1],2);
          setlength(testo[iy],length(testo[iy])-strtoint(copy(riga,11,2))+1);
          Set_Cursore_X(1);
          y:=byte(strtoint(copy(riga,13,2)));
          iy:=strtoint(copy(riga,15,4));
          gotoxy(x,y);
          end;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Back_Space(update_video:boolean);
var i:integer;
    str:string;
    intersezione_:boolean;
begin
if (x_riga=1)and(iy>1)and(length(testo[iy])+length(testo[iy-1])-1>lunghezza_riga+1) then
   begin           {sale di una riga e non comprime}
   Tasto__Sinistra;
   exit;
   end;

if (iy=1)and(x_riga=1) then sonoro
                       else modifica_on;
Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
if (x_riga=1)and(iy>1)and(length(testo[iy])+length(testo[iy-1])-1<=lunghezza_riga+1) then
        begin           {sale di una riga comprimendo}
        x_riga:=length(testo[iy-1]);
        x_min:=max(1,x_riga-40{79/2});
        if x_riga<80 then x_min:=1;
        x:=byte(max(x_riga-x_min+1,1));
        x_reale:=x;
        str:='B'+Zero(IntToStr(length(testo[iy])),2)+Zero(IntToStr(y),2)+Zero(IntToStr(iy),4);
        testo[iy-1]:=testo[iy-1]+copy_end(testo[iy],2);
        for i:=iy to ymax do testo[i]:=testo[i+1];
        dec(iy);
        if (selezionato.x1<>0) then
           if (selezionato.y1>iy) then
                            begin
                            dec(selezionato.y1);
                            dec(selezionato.y2);
                            inc(selezionato.x1,x_riga-1);
                            if selezionato.y1=selezionato.y2 then inc(selezionato.x2,x_riga-1);
                            end else
           if selezionato.y2=iy+1 then
                 begin
                 dec(selezionato.y2);
                 inc(selezionato.x2,x_riga-1);
                 end else
           if (selezionato.y1<=iy)and(selezionato.y2>iy) then dec(selezionato.y2);
        testo[ymax]:=#13;
        dec(ymax);
        {$ifdef TxtVideo}
        _start:=iy-1;
        _end:=iy+riga_menu-2;
        {$endif}
        str:='0'+undo__x_prepara()+Zero(IntToStr(y),2)+Zero(IntToStr(iy),4)+str;
        dec(y);
        if y=0 then y:=1;
        if vera_tastiera and FreeAnnulla(1) then Annulla_Txt.input_iniziale(strnew(stringtopchar(str)));
        if update_video then Evidenzia_Selezione;
        Exit;
        end;

if (x_riga<=length(testo[iy]))and(x_riga>1) then
   begin
   intersezione_:=(selezionato.x1>0) and intersezione(iy,iy,selezionato.y1,selezionato.y2);
   if intersezione_ and(selezionato.y2=iy)and(selezionato.x2<=x_riga-2) then intersezione_:=false;
   if intersezione_ then
      begin
      if (iy=selezionato.y1)and(x_riga<=selezionato.x1) then dec(selezionato.x1);
      if iy=selezionato.y2 then
         begin
         dec(selezionato.x2);
         if selezionato.x2=0 then
                             begin
                             dec(selezionato.y2);
                             selezionato.x2:=length(testo[selezionato.y2])-1;
                             end;
         end;
      if (selezionato.y1=selezionato.y2)and(selezionato.x1>selezionato.x2) then Azzera_Selezione;
      end;
   if vera_tastiera and FreeAnnulla(1) then Annulla_Txt.input_iniziale(strnew(stringtopchar('0'+undo__x_prepara()+Zero(IntToStr(y),2)+Zero(IntToStr(iy),4)+'B'+testo[iy][x_riga])));
   delete(testo[iy],x_riga,1);
   dec(x_riga);
   if x_min>x_riga then x_min:=x_riga;
   x:=byte(max(x-1,1));
   if update_video then Evidenzia_Selezione;
   Exit;
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Formattato_Centra(var riga:string);   { ver 1.80 }
var i:byte;  // xx destra tolti, + yy sinistra tolti, + zz sinistra aggiunti
    riga_:string;
begin
Set_Cursore_X(1);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
riga_:=testo[iy];
for i:=1 to strtoint(copy(riga,11,3)) do insert(' ',riga_,length(riga_)+1);
for i:=1 to strtoint(copy(riga,14,3)) do insert(' ',riga_,2);
testo[iy]:=#13+copy_end( copy_end(riga_,2), strtoint(copy(riga,17,3))+1 );
if (iy<y) then y:=byte(iy);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Formattato_Destra(var riga:string);      { ver 1.80 }
var i:byte;
begin
Set_Cursore_X(1);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
delete(testo[iy],2,StrToInt(copy(riga,14,3)));
for i:=1 to StrToInt(copy(riga,11,3)) do insert(' ',testo[iy],length(testo[iy])+1);
if (iy<y) then y:=byte(iy);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Formattato_Sinistra(var riga:string); { ver 1.80 }
begin
Set_Cursore_X(1);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
while length(testo[iy])<StrToInt(copy(riga,11,3)) do insert(' ',testo[iy],2);
if (iy<y) then y:=byte(iy);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Formattato_Giustifica(var riga:string);  { ver 1.80 }
begin
Set_Cursore_X(1);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
testo[iy]:=#13+copy_end(riga,11);
if (iy<y) then y:=byte(iy);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Invio(var riga:string);  { ver 1.80 }  // struttura 0|1 x y iy V
var i:integer;
begin
iy:=StrToInt(copy(riga,6,4));
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
testo[iy]:=testo[iy]+copy_end(testo[iy+1],2);
for i:=iy+1 to ymax-1 do testo[i]:=testo[i+1];
testo[ymax]:=#13;
dec(ymax);
riga[1]:='1';
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Scrivi(riga:string);  { ver 1.80 }
var xx,valore,i:integer;
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
valore:=StrToInt(copy(riga,11,4)); // ultima iy modificata
xx:=x_riga;
for i:=iy to valore do
     begin
     delete(testo[i],xx+1,1);
     xx:=1;
     if i<valore then testo[i]:=testo[i]+copy(testo[i+1],2,1);
     end;
ymax:=StrToInt(copy(riga,15,4));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Insert(var riga:string);   { ver 1.80 }
begin
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
case length(riga) of
      14: begin
          testo[ymax]:=#13;
          dec(ymax);
          dec(iy);
          if iy=0 then iy:=1;
          if ymax=0 then ymax:=1;
          Set_Cursore_X(length(testo[ymax]));
          end;
      13: setlength(testo[iy],length(testo[iy])-1);
      12: testo[iy][x_riga+1]:=riga[11];
      11: testo[iy][x_riga+1]:=#0;
      15: testo[iy][x_riga+1]:=riga[11]{#0};
      10: ; // carattere #0 sovrascritto da #0
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__UnoS(var riga:string);  // struttura 0|1 x y iy U
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
if x_riga=lunghezza_riga+1 then testo[iy+1][2]:=' '
                           else testo[iy][x_riga+1]:=' ';
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Mouse_CL(const riga:string);   // struttura 0|1 x y iy M  ...
begin           { ver 1.80 , update ver 3.15 }
setlength(testo[iy],StrToInt(copy(riga,11,2+1)));
x:=byte(StrToInt(copy(riga,13+1,2+1)));
x_min:=ord(riga[3]);
x_riga:=StrToInt(copy(riga,26-3,3));
y:=byte(StrToInt(copy(riga,15+2,2)));
iy:=StrToInt(copy(riga,17+2,4));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Canc_UnoS(riga:string);   // struttura 0|1 x y iy  c  length(iy - iy)
var i:byte;                             { ver 1.80 }
begin
i:=byte(StrToInt(copy(riga,11,3)));
testo[iy+1]:=#13+copy_end(testo[iy],length(testo[iy])-i+1)+copy_end(testo[iy+1],2);
setlength(testo[iy],length(testo[iy])-i);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__F1_F2(riga:string; ann:boolean);  //  ver 1.83
begin
undo__x_ripristina(riga);
y:=byte(StrToInt(copy(riga,4,2)));
iy:=StrToInt(copy(riga,6,4));
case length(riga) of
     12: testo[iy][x_riga+1]:=riga[11];
     11: if ann then testo[iy][x_riga+1]:=riga[11]
                else testo[iy][x_riga+1]:=#0;
     13: if not ann then testo[iy][x_riga+1]:=#0
                    else testo[iy][x_riga+1]:=#255;
     else testo[iy][x_riga+1]:=#0;
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Selezione(ann:boolean);         // ver 1.90 , update 2.25
var p:ptrx;
    riga,coda:string;
    num:byte;
begin
if ann then
    begin
    if (Annulla_Txt.numElementi=0)or(Annulla_Selezione.numElementi=0) then
       begin
       Annulla_Txt.destroy;
       annulla_esa.destroy;
       Annulla_Selezione.destroy;
       exit;
       end;
    if Annulla_Txt.numElementi>Annulla_Selezione.numElementi then Exit;
    p:=Annulla_Selezione.l;
    end
   else   // ripristina
    begin
    if (Ripristina_Txt.numElementi=0)or(Ripristina_Selezione.numElementi=0) then
       begin
       Ripristina_Txt.destroy;
       Ripristina_Selezione.destroy;
       exit;
       end;
    if Ripristina_Txt.numElementi>Ripristina_Selezione.numElementi then Exit;
    p:=Ripristina_Selezione.l;
    end;
riga:=strpas(p^.info);
num:=0;
Azzera_Selezione;
if riga='' then Exit;
if riga[length(riga)]='q' then  // selezione quadrata?       update 2.25
    begin
    selezione_quadrata:=true;
    riga:=copy(riga,1,length(riga)-1);
    end
   else selezione_quadrata:=false;
while riga<>'' do
    begin
    Testa_Coda(riga,'a',riga,coda);
    if riga[1]='a' then riga:=copy(riga,2,255);
    inc(num);
    case num of
         1: selezionato.x1:=byte(StrToInt(riga));
         2: selezionato.y1:=strtoint(riga);
         3: selezionato.x2:=byte(strtoint(riga));
         4: selezionato.y2:=strtoint(riga);
         end;
    riga:=coda;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Tastiera;   { mette '1' dove serve nell' heap }  { ver 1.80 }
var stringa:string;
begin
if Annulla_Txt.numelementi=0 then Exit;
stringa:=strpas((Annulla_Txt.l)^.info);  // il primo elemento
if not (stringa[10] in ['X','V','C','B','x','U']) then Exit;
stringa[1]:='1';
Annulla_Txt.cancella_iniziale;
Annulla_Txt.input_iniziale(strnew(stringtopchar(stringa)));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__TE_Selezione(riga:string; var first:boolean);  {ver 1.80}
var i:integer;
    add:string;
    n:longint;
    pos_err:word;
begin
add:=copy_end(riga,11);
if first then
         begin
         if riga[1]='1' then //era una sola riga: intermedia
                begin
                insert(add,testo[iy],x_riga+1);
                x_riga:=length(add)+x_riga;
                x_min:=x_riga-x+1;
                x_reale:=x;
                end
                else
         if x_riga>1 then
                 begin
                 testo[iy]:=testo[iy]+add;
                 inc(iy);
                 end
                else
                 begin
                 inc(ymax);
                 for i:=ymax downto iy+1 do testo[i]:=testo[i-1];
                 testo[iy]:=#13+add;
                 inc(iy);
                 end;
         first:=false;
         end
       else //if first=false then
        if riga[1]='1' then  // ultima riga da gestire
                         begin    // si va a capo ?
                         undo__x_ripristina(riga);
                         Val_Try(copy(riga,11,4),n,pos_err);
                         if (pos_err=0) and (StrToInt('0'+copy(riga,11,4))>ymax) then
                              begin
                              inc(ymax);
                              for i:=ymax downto iy+1 do testo[i]:=testo[i-1];
                              testo[iy]:=#13+copy_end(add,5);
                              Set_Cursore_X(length(testo[iy]));
                              end
                             else
                              begin // non si va a capo: si incolla la riga finale con la successiva
                              if pos_err=0 then testo[iy]:=#13+copy_end(add,5)+copy_end(testo[iy],2)
                                           else testo[iy]:=#13+add+copy_end(testo[iy],2);
                              if pos_err=0 then Set_Cursore_X(max(length(add)-4+1,1))
                                           else Set_Cursore_X(length(add)+1);
                              x_min:=x_riga-x+1;
                              if iy>ymax then ymax:=iy;
                              end;
                         end
                       else
                         begin  // gestione righe intermedie
                         inc(ymax);
                         for i:=ymax downto iy do testo[i]:=testo[i-1];
                         testo[iy]:=#13+add;
                         inc(iy);
                         end; // incolla con spostamento
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__TE_Selezione_Quadrata(var riga:string);  // ver 2.25
var p:ptrx;
    first,uscita:boolean;
begin
first:=true;
uscita:=false;
repeat
 if not first then
              if (riga[10]='q')and(riga[1]='1') then uscita:=true
                                                else
              else first:=false;
 undo__x_ripristina(riga);
 y:=byte(StrToInt(copy(riga,4,2)));
 iy:=StrToInt(copy(riga,6,4));
 testo[iy]:=copy(testo[iy],1,x_riga)+copy(riga,11,length(riga))+copy(testo[iy],x_riga+1,length(testo[iy]));

 if uscita then break
           else
            begin
            p:=Annulla_Txt.l;
            p:=p^.next;
            if p=nil then uscita:=true
                     else
                      begin
                      riga:=strpas(p^.info);
                      if riga='' then uscita:=true;
                      end;
            Annulla_Txt.cancella_iniziale;
            Annulla_Selezione.cancella_iniziale;
            end;
until uscita;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__TE_Righe(riga:string; var first:boolean);  { ver 1.80 }
var i:integer;
begin
first:=false;
inc(ymax);
for i:=ymax downto iy+1 do testo[i]:=testo[i-1];
testo[iy]:=#13+copy_end(riga,11);
Set_Cursore_X(1);
inc(iy);
if iy>ymax then iy:=ymax; // ver 3.03
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Recover(riga:string);  { ver 1.80 }
begin
case riga[9] of
     '1': if ymax>1 then dec(ymax);  // per taglia/elimina
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Incolla_Riga(riga:string);  { ver 1.80 , update 2.58 }
var old_ymax,i,old_length,cancellati:integer;
begin
if length(riga)=14 then      // su di una stessa riga (la lunghezza era 12 prima della ver 2.58)
    begin
    undo__x_ripristina(riga);
    delete(testo[iy],x_riga+1,ord(riga[12])); // riga[11] inutilizzata
    i:=ord(riga[14]); // riga[13] inutilizzata
    if i<length(testo[iy]) then
                           begin
                           testo[iy+1]:=#13+copy_end(testo[iy],i+1)+copy_end(testo[iy+1],2);
                           setlength(testo[iy],i);
                           end;
    end
   else
    begin                    // su 2 righe
    undo__x_ripristina(riga);
    old_length:=length(testo[iy]);
    testo[iy]:=copy(testo[iy],1,x_riga);
    cancellati:=old_length-length(testo[iy]);
    delete(testo[iy+1],2,ord(riga[14])-cancellati);
    while length(testo[iy])<lunghezza_riga+1 do
          begin
          if length(testo[iy+1])=1 then break;
          testo[iy]:=testo[iy]+testo[iy+1][2];
          delete(testo[iy+1],2,1);
          end;
    if testo[iy+1]=#13 then
       begin  // comprime e sale di una riga
       for i:=iy+1 to ymax do testo[i]:=testo[i+1];
       testo[ymax]:=#13;
       dec(ymax);
       end;
    old_ymax:=strToInt(Copy(riga,15,4));    // da qui in poi con ver 2.58
    if old_ymax=ymax+1 then
       begin
       ymax:=ymax+1;
       for i:=ymax downto iy+1 do testo[i]:=testo[i-1];
       testo[iy+1]:=#13+copy_end(testo[iy],x_riga+1);
       testo[iy]:=copy(testo[iy],1,x_riga);
       end;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Undo__Incolla_Righe(riga:string);     { ver 1.80 }
var i,valore:integer;
begin
valore:=StrToInt(Copy(riga,12,4));
if riga[11]='V' then  //  devo far risalire una riga
   begin
   testo[iy]:=testo[iy]+copy_end(testo[iy+1+valore],2);
   inc(valore);
   end;
//if riga[11]=' ' or 'V' then
ymax:=ymax-valore;
for i:=iy+1 to ymax do testo[i]:=testo[i+valore];
if ymax=0 then
          begin
          ymax:=1;
          testo[1]:=#13;     //  iy:=1; y:=1; x:=1;  per sicurezza  ***
          init;
          end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Aggiorna1(const c:char);
var s:string;
begin
hidemouse;
s:='   ';
case c of
    'R' : s[1]:='*';
    'P' : s[2]:='*';
    'B','O' : s[3]:='*';
    end;
textcolor(White);
gotoxy(53,riga_menu+1);
write(s[1]);
gotoxy(53,riga_menu+2);
write(s[2]);
gotoxy(53,riga_menu+3);
write(s[3]);
case c of
    'R' : gotoxy(53,riga_menu+1);
    'P' : gotoxy(53,riga_menu+2);
    'B','O' : gotoxy(53,riga_menu+3);
    end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Aggiorna2(const c:char);
var s:string;
begin
hidemouse;
s:='   ';
case c of
    '+' : s[1]:='*';
    '-' : s[2]:='*';
    '=' : s[3]:='*';
    end;
textcolor(White);
gotoxy(67,riga_menu+1);
write(s[1]);
gotoxy(67,riga_menu+2);
write(s[2]);
gotoxy(67,riga_menu+3);
write(s[3]);
case c of
    '+' : gotoxy(67,riga_menu+1);
    '-' : gotoxy(67,riga_menu+2);
    '=' : gotoxy(67,riga_menu+3);
    end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure stato_2;
begin
textcolor(white);
gotoxy(34,riga_menu+3);
write('[');
gotoxy(39,riga_menu+3);
write('] ');
gotoxy(46,riga_menu+3);
write(' ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure stato_3;
begin
textcolor(white);
gotoxy(34,riga_menu+3);
write(' ');
gotoxy(39,riga_menu+3);
write(' [');
gotoxy(46,riga_menu+3);
write(']');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure lo_statoXY(const stato_:byte);
begin
case stato_ of
     2: stato_2;
     3: stato_3;
     4: gotoxy(53,riga_menu+1);
     5: gotoxy(53,riga_menu+2);
     6: gotoxy(53,riga_menu+3);
     7: gotoxy(67,riga_menu+1);
     8: gotoxy(67,riga_menu+2);
     9: gotoxy(67,riga_menu+3);
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure pulisci_quadre;
begin
gotoxy(34,riga_menu+3);
write(' ');
gotoxy(39,riga_menu+3);
write('  ');
gotoxy(46,riga_menu+3);
write(' ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function riga_menu:longint;  // ver 2.20
begin
Exit(max_righe_video-4);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function La_selezione:string;  // ver 1.90
var stringa:string;
begin
if selezionato.x1=0 then exit('');
stringa:=inttostr(selezionato.x1)+'a'+inttostr(selezionato.y1)+'a'+inttostr(selezionato.x2)+'a'+inttostr(selezionato.y2);
if selezione_quadrata then stringa:=stringa+'q';
exit(stringa);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Conto(i:integer);  {numero di volte che una parola compare nel testo}
begin
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(390));  // 'La stringa "'
textcolor(10);
write(cerco);
textcolor(white);
writeln('"');
if selezione then write(Lingue.get_txt(391),i,Lingue.get_txt(392))   // 'e'' stata trovata '  // ' volte dentro il testo selezionato.'
             else write(Lingue.get_txt(391),i,Lingue.get_txt(393));  // 'e'' stata trovata ',   // ' volte.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Cerca_Sost(find:boolean);
begin
gotoxy(38,riga_menu+1);
write(Lingue.get_txt(394));  // '    Parola intera  [ ]'
gotoxy(67,riga_menu+1);
write(Lingue.get_txt(395));  // 'Conteggio [ ]'
gotoxy(38,riga_menu+2);
write(Lingue.get_txt(396));  // '   Ignora Mai/Min [ ]'
gotoxy(67,riga_menu+2);
write('Jolly     [ ]');
gotoxy(38,riga_menu+3);
write(Lingue.get_txt(397));  // '    Verso  sotto   [ ]'
gotoxy(67,riga_menu+3);
if (selezionato.x1<>0) and (not binario) and (not selezione_quadrata) then write(Lingue.get_txt(398)); // 'Selezione [ ]'
if (not binario) then
   begin
   gotoxy(67,riga_menu+4);
   write(Lingue.get_txt(540)); // 'Per riga  [ ]'
   end;
textcolor(13);
gotoxy(37+Lingue.get_pos_rosso(394),riga_menu+1);
write(Lingue.get_char(394){'P'});
gotoxy(37+Lingue.get_pos_rosso(396),riga_menu+2);
write(Lingue.get_char(396){'I'});
gotoxy(37+Lingue.get_pos_rosso(397),riga_menu+3);
write(Lingue.get_char(397){'V'});
gotoxy(66+Lingue.get_pos_rosso(395),riga_menu+1);
write(Lingue.get_char(395){'C'});
gotoxy(67,riga_menu+2);
write('J');
if (selezionato.x1<>0)and(not binario)and(not selezione_quadrata) then
   begin
   gotoxy(66+Lingue.get_pos_rosso(398),riga_menu+3);
   write(Lingue.get_char(398){'S'});
   end;
if find and (not binario) then
   begin
   gotoxy(66+Lingue.get_pos_rosso(540),riga_menu+4);
   write(Lingue.get_char(540){'r'}); // 'Per riga  [ ]'
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Anteprima_Sostituisci;
begin
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(399));  // 'Sostituisci:'
cerca_sost(false);
textcolor(white);
gotoxy(62,riga_menu+1);
write('                  ');  {toglie la scritta: solo conteggio}
gotoxy(1,riga_menu+3);
write(Lingue.get_txt(400));  // 'La seguente stringa:'
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Post_Sostituisci;
begin
if not selezione then
   begin
   textcolor(white);
   gotoxy(Lingue.get_length_txt(399)+2,riga_menu+1);
   write('"');
   textcolor(10);
   textbackground(blue);
   write(cerco);
   textcolor(white);
   write('"');
   end;
textcolor(white);
gotoxy(1,riga_menu+3);
write(Lingue.get_txt(401)+'                   '); // 'Con la stringa:'
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Anteprima_Cerca(find:boolean);
begin
colore;
gotoxy(1,riga_menu+1);
DelLine;
DelLine;
DelLine;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+4);
clreol;
gotoxy(45,riga_menu+4);  // un pezzo di "info"
textcolor(yellow);
write(Lingue.get_txt(92){'Pag.'});
textcolor(white);
write(foglio(iy),' ');
textcolor(yellow);
write(Lingue.get_txt(93){'Col.'});
textcolor(white);
write(x_riga,' ');
textcolor(yellow);
write(Lingue.get_txt(94){'Riga '});
textcolor(white);
write(iy);
{$ifdef TxtCrt}
gotoxy(27,riga_menu+1);
{$endif}
{$ifdef TxtVideo}
gotoxy(30,riga_menu+1);
{$endif}
write('                                              '); // nasconde [11.111] posizione del byte
if binario then
   begin
   textcolor(yellow);
   gotoxy(1,riga_menu+2);
   write(Lingue.get_txt(402));  // 'Byte attuale '
   textcolor(white);
   write(Dim_Punto(num_byte()+tot)); {*** calcola la posizione del byte}
   end;
colore;
gotoxy(1,riga_menu+3);
write(Lingue.get_txt(403));  // 'Cerca la stringa:  '
cerca_sost(find);
textcolor(white);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Ctrl_Inizio():boolean;  // posizionamento sul punto iniziale del testo (1,1)
var old_y,old_iy,old_x,old_x_reale,old_x_min:integer;
begin
old_y:=y;
old_iy:=iy;
old_x:=x;
old_x_reale:=x_reale;
old_x_min:=x_min;

y:=1;
iy:=1;
x:=1;
x_reale:=x;
x_min:=1;
x_riga:=1;
result:=(old_y<>y)or(old_iy<>iy)or(old_x<>x)or(old_x_reale<>x_reale)or(old_x_min<>x_min);
if (old_iy<riga_menu)and(old_x_min=1)and(old_iy-old_y=0) then
   begin
   gotoxy(x,y);
   exit;
   end;
if result then Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_speciale__Taglia_Riga_Attuale(taglia:boolean; redo:boolean=true);   // update ver 2.30
var ii:integer;  { taglia/elimina la riga attuale }
    c:char;
begin
if SL then
      begin
      SL_Error;
      Exit;
      end;
if (ymax=1) and (testo[1]=#13) then Exit;
Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
if selezionato.x1<>0 then  // ver 1.85
   begin
   if (selezionato.y1<=iy)and(iy<=selezionato.y2) then
         begin
         if iy=selezionato.y1 then selezionato.x1:=1;
         dec(selezionato.y2);
         if selezionato.y2+1=iy then selezionato.x2:=length(testo[selezionato.y2])-1;
         end else
   if iy<selezionato.y2 then
         begin
         dec(selezionato.y2);
         dec(selezionato.y1);
         end;
   if selezionato.y2<selezionato.y1 then Azzera_Selezione;
   end;
normale;         {taglia=false e' l'elimina}
if ( (ymax>1)or((ymax=1)and(testo[1]<>#13)) ) and taglia then
   begin
   if not Din_Mem_Free(1) then Exit;
   nuovi_appunti(appunti_usato);
   Appunti[appunti_usato].input(Copy_end(testo[iy],2)); {tolgo il 1 carattere: #13 invio}
   end;
                                      {0/1,x,y,iy,I/T/E,str}
if taglia then c:='t' else c:='e';
if FreeAnnulla(1) then Annulla_Txt.input_iniziale(strnew(stringtopchar('1'+#1+#1+Zero(IntToStr(y),2)+Zero(IntToStr(iy),4)+c+Copy_end(testo[iy],2))));
modifica_on;
for ii:=iy to ymax do testo[ii]:=testo[ii+1];
testo[ymax]:=#13;
dec(ymax);
dec(y);
dec(iy);
if y=0 then
       if iy-(riga_menu-1)>0 then y:=1
                             else y:=byte(iy);
if redo then Evidenzia_Selezione;
if iy=0 then iy:=1;
if y=0 then y:=1;
if ymax=0 then
          begin
          ymax:=1;
          init;
          iy:=1;
          testo[1]:=#13;
          end;
Set_Cursore_X(1);
if taglia then stato_appunti.nuovo_stato_appunti(1); // ver  2.53
// non necesario per via della riga sopra
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Taglia_Selezione_non_quadrata(taglia:boolean);
var i,ii,old_selezionato_y1,old_selezionato_y2:integer;   {taglia/elimina selezione}
    stringa:string;
    c:char;
begin
if taglia then   // taglia=false e' l'elimina : metto tutto negli appunti
   begin
   if not Din_Mem_Free(selezionato.y2-selezionato.y1+1) then Exit;
   nuovi_appunti(appunti_usato);
   if (selezionato.y1<>selezionato.y2) then
          begin
          stringa:=testo[selezionato.y2];
          if length(stringa)>1 then setlength(stringa,selezionato.x2+1);
          delete(stringa,1,1);
          Appunti[appunti_usato].input(stringa);
          Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));

          for i:=selezionato.y2-1 downto selezionato.y1+1 do
              begin
              Appunti[appunti_usato].input(Copy_end(testo[i],2));
              Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
              end;

          stringa:=testo[selezionato.y1];
          if length(stringa)>1 then delete(stringa,1,selezionato.x1);
          Appunti[appunti_usato].input(stringa);
          Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
          end;
   if (selezionato.y1=selezionato.y2) then
          begin
          stringa:=testo[selezionato.y1];
          if length(stringa)>1 then setlength(stringa,selezionato.x2+1);
          if length(stringa)>1 then delete(stringa,1,selezionato.x1);
          Appunti[appunti_usato].input(stringa);
          Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
          end;
   end;

if binario then
            if taglia then c:='7'  // taglia in binario
                      else c:='3'  // elimina in binario
           else
            if taglia then c:='T'
                      else c:='E';
if binario then  // ver 2.31
   begin
   if not FreeAnnulla(selezionato.y2-selezionato.y1+1) then Exit;
   Annulla_Txt.input_iniziale(strnew(stringtopchar('1'+char(x_min)+char(min(selezionato.x1,selezionato.x2))+Zero(IntToStr(y),2)+Zero(inttostr(selezionato.y1),4)+c+Zero(inttostr(selezionato.y2-selezionato.y1+1),4))));
   Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
   for i:=selezionato.y2 downto selezionato.y1 do
       if i=selezionato.y1 then Annulla_Esa.input(copy_end(testo[i],selezionato.x1+1))
                           else Annulla_Esa.input(copy_end(testo[i],2));
   ymax:=selezionato.y1;
   setlength(testo[ymax],selezionato.x1);
   if (testo[ymax]=#13)and(ymax>1) then
      begin
      dec(ymax);
      Set_Cursore_X(length(testo[ymax]));
      end;
   modifica_on;
   Exit;
   end;

if FreeAnnulla(selezionato.y2-selezionato.y1+1) then
   if selezionato.y2<>selezionato.y1 then
       begin      {le righe piu' in basso (+grandi) sono le prime in annulla}
       Annulla_Txt.input_iniziale(strnew(stringtopchar('1'+char(max(selezionato.x1-x_min{riga}+1,1))+char(min(x_min,selezionato.x1))
                                 +Zero(IntToStr(max(y-(selezionato.y2-selezionato.y1),1)),2)+Zero(inttostr(selezionato.y1),4)+c+Zero(inttostr(ymax),4)+Copy(testo[selezionato.y2],2,selezionato.x2))));
       Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));

       if (selezionato.x1=1)and(selezionato.y1=1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.y2=ymax) then
           begin
           Annulla_Txt.input_iniziale(strnew(stringtopchar('000000001R'+inttostr(ymax))));
           Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
           end;
       for i:=selezionato.y2-1 downto selezionato.y1+1 do
           begin
           Annulla_Txt.input_iniziale(strnew(stringtopchar('0'+#1+#1+Zero(IntToStr(y),2)+Zero(IntToStr(i),4)+c+Copy_end(testo[i],2))));  // righe intermedie
           Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
           end;
       if (selezionato.x1=1)and(selezionato.y1=1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.y2=ymax) then // tutto selezionato
            Annulla_Txt.input_iniziale(strnew(stringtopchar('0'+#1+#1+'010001'+c+Copy_end(testo[1],2))))
           else
            Annulla_Txt.input_iniziale(strnew(stringtopchar('0'+char(max(selezionato.x1-x_min+1,1))+char(min(selezionato.x1,x_min))+Zero(IntToStr(y),2)+Zero(IntToStr(selezionato.y1),4)+c+
                        Copy_end(testo[selezionato.y1],selezionato.x1+1)))); // prima riga selezionata
       Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
       end
      else     // taglia dentro una sola riga
       begin
       Annulla_Txt.input_iniziale(strnew(stringtopchar('1'+char(max(selezionato.x1-x_min{riga}+1,1))+char(min(x_min,selezionato.x1){max(selezionato.x1-x_min+1,1)})+Zero(IntToStr(y),2)+Zero(inttostr(selezionato.y2),4)+c+
               Copy(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1))));
       Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
       end;
modifica_on;
if (selezionato.y1<>selezionato.y2) then
        begin
        setlength(testo[selezionato.y1],selezionato.x1);
        delete(testo[selezionato.y2],1,selezionato.x2+1);
        testo[selezionato.y2]:=#13+testo[selezionato.y2];
        old_selezionato_y1:=selezionato.y1;
        old_selezionato_y2:=selezionato.y2;
        if testo[selezionato.y2]=#13 then inc(selezionato.y2);
        if testo[selezionato.y1]=#13 then dec(selezionato.y1);
        i:=selezionato.y1;
        for ii:=selezionato.y2 to ymax do        {in memoria}
                 begin
                 testo[i+1]:=testo[ii];
                 inc(i);
                 end;
        iy:=max(selezionato.y1-1,1);
        ymax:=max(ymax-(selezionato.y2-selezionato.y1-1),1);
        selezionato.y1:=old_selezionato_y1;
        selezionato.y2:=old_selezionato_y2;
        init;
        end
       else  // if (selezionato.y1=selezionato.y2) then
        delete(testo[selezionato.y1],selezionato.x1+1,selezionato.x2-selezionato.x1+1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Taglia_Selezione_quadrata2(taglia:boolean);
var i:integer;                                 {taglia/elimina selezione}
    stringa:string;             // ver 2.25
    c:char;
    scambia:boolean;
begin
scambia:=selezionato.x1>selezionato.x2;
if scambia then Exchange(selezionato.x1,selezionato.x2);
if taglia then       {taglia=false e' l'elimina}
   begin
   if not Din_Mem_Free(selezionato.y2-selezionato.y1+1) then Exit;
   nuovi_appunti(appunti_usato);
   for i:=selezionato.y2 downto selezionato.y1 do // copia le righe in memoria
       begin
       Appunti[appunti_usato].input(Copy(testo[i],selezionato.x1+1,selezionato.x2-selezionato.x1+1));
       Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
       end;
   end;

c:='0';
if FreeAnnulla(selezionato.y2-selezionato.y1+1) then
   for i:=selezionato.y1 to selezionato.y2 do
       begin
       if i=selezionato.y1 then c:='1'   // se e' alla fine o no, era y2 e 0
                           else c:='0';
       stringa:=copy(testo[i],selezionato.x1+1,selezionato.x2-selezionato.x1+1);
       testo[i]:=copy(testo[i],1,selezionato.x1)+copy(testo[i],selezionato.x2+2,length(testo[i]));
       Annulla_Txt.input_iniziale(strnew(stringtopchar(c+char(max(x-(x_riga-selezionato.x1),1))+char(max(min(x_min,selezionato.x1),1))+Zero(IntToStr(y),2)+Zero(inttostr(i),4)+'q'+stringa)));
       Annulla_Selezione.input_iniziale(strnew(stringtopchar(La_selezione)));
       c:='0';
       end;
if scambia then Exchange(selezionato.x1,selezionato.x2);
modifica_on;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Taglia_Selezione_quadrata(taglia:boolean);   // ver 2.25
var uguali:boolean;
begin
uguali:=(selezionato.x1=selezionato.x2+1)and(selezionato.x1<>0);
if uguali then inc(selezionato.x2);
Taglia_Selezione_quadrata2(taglia);
if uguali then dec(selezionato.x2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_modifica__Taglia_Selezione(taglia:boolean);       {out: y,iy,ymax,x,modifica}
var old_x_riga:integer;
begin                                {taglia/elimina selezione}
if SL then
      begin
      SL_Error;
      Exit;
      end;
if binario then  // in caso di shift canc da tastiera
   if (selezionato.x1<>0) and is_last_block and (selezionato.y2=ymax) and
      (selezionato.x2=length(testo[selezionato.y2])-1) then
                                                       else Exit;
if selezionato.x1=0 then
       begin
       if shift() then {con Shift+Canc non occorre il messaggio d'errore}
                  else no_selezione;
       exit;
       end;
normale;
if binario and selezione_quadrata then
                                  begin
                                  No_ASCII;
                                  Exit;
                                  end;
if selezione_quadrata then taglia_selezione_quadrata(taglia)
                      else taglia_selezione_non_quadrata(taglia);
if ymax=0 then
          begin
          ymax:=1;
          iy:=1;
          init;
          y:=1;
          testo[1]:=#13;
          end;
if selezionato.y1<>iy then
                      begin
                      iy:=selezionato.y1;
                      if iy>ymax then ymax:=iy;
                      init;
                      end;
if selezionato.y1<>selezionato.y2 then
                                   if (x_riga=1)
                                               then Set_Cursore_X(1)
                                               else
                                                begin
                                                x:=byte(max(min(x-(x_riga-selezionato.x1),length(testo[iy])),1));
                                                x_min:=byte(min(x_min,selezionato.x1));
                                                x_riga:=min(x_min+x-1,length(testo[iy]));
                                                end
                                  else
                                   begin
                                   old_x_riga:=x_riga;
                                   x_riga:=selezionato.x1;
                                   if old_x_riga-x_riga>79 then x:=1
                                                           else x:=byte(max(x-abs(old_x_riga-x_riga),1));
                                   x_min:=max(x_riga-x+1,1);
                                   end;
Azzera_Selezione;
if iy<1 then
        begin
        iy:=1;
        Set_Cursore_X(1);
        end;
Evidenzia_Selezione;
if taglia then stato_appunti.nuovo_stato_appunti(1); // ver 2.53
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Ctrl_Pag_Giu():boolean;
var first,old_x_riga,old_x,old_y,old_x_min:integer;  // posizionamento sull' ultima riga della schermata
begin
old_x_riga:=x_riga;
old_x:=x;
old_y:=y;
old_x_min:=x_min;
old_x_riga:=x_riga;
first:=iy-y+1;
iy:=min(iy-y+riga_menu-1,ymax);
x_riga:=min(length(testo[iy]),x_min+79);
if x_riga>old_x_riga then x:=byte(max(x+(x_riga-old_x_riga),1))
                     else x:=byte(max(x-(old_x_riga-x_riga),1));
x_reale:=x;
if x_riga<x_min then x_min:=x_riga;
if iy>riga_menu-1 then y:=riga_menu-1
                  else
                   begin
                   y:=iy mod (riga_menu-1);
                   if y=0 then y:=riga_menu-1;
                   end;
result:=(old_x_riga<>x_riga)or(old_x<>x)or(old_y<>y)or(old_x_min<>x_min)or(old_x_riga<>x_riga);
if (old_x_min<>x_min)or(first<>iy-y+1) then Evidenzia_Selezione
                                       else gotoxy(x,y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Non_Trovato(const nomefilex:string); // ver 2.00
begin
grafica;
info;
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(404)); // 'Apertura file in corso.'
gotoxy(33-Lingue.get_length_txt(405),riga_menu+3);
write(Lingue.get_txt(405)); // 'Riprovare ?'
gotoxy(1,riga_menu+4);
write(Lingue.get_txt(406));  // 'File non trovato: '
textbackground(red);
write(nomeLungo(truncpath(nomefilex,55),55));
if ins then CursorBig else CursorOn;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Selezione_Comune;
begin
Scambio;
if (selezionato.x1>=length(testo[selezionato.y1]))and
   (length(testo[selezionato.y1])>1) then  {.Y1}
   begin
   inc(selezionato.y1);              {riga successiva}
   selezionato.x1:=1;
   if selezionato.y1>ymax then Azzera_Selezione; {annullato}
   end;
if (length(testo[selezionato.y2])<=selezionato.x2)then  {.Y2}
    begin
    if (length(testo[selezionato.y2])>1)
        then selezionato.x2:=length(testo[selezionato.y2])-1
        else
         repeat
          dec(selezionato.y2);
          selezionato.x2:=length(testo[selezionato.y2])-1;
         until (selezionato.y2=0)or(length(testo[selezionato.y2])>1);
    end;
if selezionato.y2<selezionato.y1 then Azzera_Selezione;
  {le zone non valide hanno recato un accavallamento delle posizione di inizio e fine}
if x_riga>length(testo[iy]) then Set_Cursore_X(length(testo[iy]));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Ctrl_Shift_Inizio;
begin              {seleziona da pos attuale a 1:1}
if (x_riga=1)and(iy=1) then Exit;
old_selezionato:=selezionato;
selezionato.x1:=1;
selezionato.y1:=1;
selezionato.y2:=iy;
selezionato.x2:=x_riga-1;
if selezionato.x2=0 then
   begin
   dec(selezionato.y2);
   selezionato.x2:=length(testo[selezionato.y2])-1;
   end;
Selezione_Comune;
adiacente:=true;
testo[0]:='ctrl_shift_inizio';
no_update:=true;
Tasto__Ctrl_Inizio();
no_update:=false;
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Shift_Pag_Su;
begin
if (iy=1) then Exit;
old_selezionato:=selezionato;
selezionato.x2:=byte(x_riga); {se la riga= solo #13}
if (length(testo[iy])>1)and(x_riga=length(testo[iy])) then
           dec(selezionato.x2); {se la riga= #13...}
selezionato.y2:=iy;
if old_selezionato.x1=0 then  {se prima no selezione, occorre eseguire queste righe}
     begin
     selezionato.x1:=selezionato.x2;
     selezionato.y1:=selezionato.y2;
     old_selezionato.y1:=selezionato.y1;
     old_selezionato.y2:=selezionato.y2;
     old_selezionato.x1:=selezionato.x1;
     old_selezionato.x2:=selezionato.x2;
     end;
no_update:=true;
Tasto__Pag_Su;
no_update:=false;
selezionato.y1:=iy;
selezionato.x1:=byte(x_riga);
if (length(testo[selezionato.y1])>1)and(x_riga=length(testo[selezionato.y1])) then
           dec(selezionato.x1); {se la riga= #13...}
adiacente:=true;
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Ctrl_Shift_Pag_Su;
var selezionato_x2,selezionato_y2,old_selezionato_x1:integer;
begin
if (y=1)and(x_riga=1) then Exit;
old_selezionato:=selezionato;
selezionato.y2:=iy;
selezionato.x2:=x_riga-1;
if selezionato.x2=0 then
   begin
   dec(selezionato.y2);
   selezionato.x2:=length(testo[selezionato.y2])-1;
   end;
if old_selezionato.x1=0 then old_selezionato.x1:=1;
selezionato_x2:=selezionato.x2;
selezionato_y2:=selezionato.y2;
old_selezionato_x1:=old_selezionato.x1;
no_update:=true;
Tasto__Ctrl_Pag_Su();
no_update:=false;
selezionato.x2:=byte(selezionato_x2);
selezionato.y2:=selezionato_y2;
old_selezionato.x1:=byte(old_selezionato_x1);
selezionato.y1:=iy;
selezionato.x1:=byte(x_riga);
if (length(testo[selezionato.y1])>1)and(x_riga=length(testo[selezionato.y1])) then
           dec(selezionato.x1); {se la riga= #13...}
adiacente:=true;
testo[0]:='ctrl_shift_pag_su';
Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function free_testo_esa():longint;   // ver 2.30
begin
exit( lunghezza_riga*(maxR-ymax)+(lunghezza_riga-length(testo[ymax])+1) );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure No_ASCII;   // update ver 2.31
begin
pulisci1;
gotoxy(10,riga_menu+2);
write(Lingue.get_txt(407));  // 'Impossibile eseguire questa operazione nel formato esadecimale'
ShowMouse;
Esc;
grafica;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

end.

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

(*
function CercaInFile(nomefile1,cerca1:string; reverse1,jolly1,mami1:boolean;
         start1,end_1:int64; var posizione:int64{stop}):int64;
   la funzione cerca una stringa di max 255 caratteri e minimo 1 (il minimo
   deve essere garantito dal programmatore) in un file indicato in NOMEFILE,
   la stringa viene passato in CERCA1.

   reverse=false indica di fare una ricerca dal byte iniziale a quello finale
   reverse=true indica di fare una ricerca dal byte finale a quello iniziale

   Jolly1=false :disabilita la ricerca jolly
   Jolly1=true : al posto del carattere ? in cerca e' come se potesse essere
   sostituito da un qualunque altro carattere

   mami1=true : ignora maiuscole / minuscole
   mami1=false : notifica la differenza tra maiuscole / minuscole

   start1= byte del file in cui inizia la ricerca
   end_1= byte del file entro il quale finisce la ricerca, se si mette -1,
          si considera la dimensione massima del file

   posizione= ritorna il byte dove ci si e' interrotti, quando si va in PAUSA

   la funzione ritorna la posizione minima (di inizio) in byte in cui e'
   stata trovata la stringa o se e' un valore negativo si ha:
    -1 stringa non trovata
    -2 e' stata indicata la posizione di byte di inizio minore di 1
    -3 e' stata indicata la posizione di byte di fine piu' grande del file
       stesso
    -4 e' stata indicata la posizione di byte di fine piu' grande di quella
       di inizio
    -5 errore di lettura nell'accedere al file
    -6 e' stato premuto il tasto Esc che ha fermato la ricerca
    -7 e' stato premuto il tasto 'P' di pausa, in posizione, vi e' l'ultimo
       byte letto
*)
