{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit t_edit24;    // contiene la parte dei multi_file dell'editor
{$MODE  ObjFpc}   // e tutto cio' che vi e' legato,
                  // principalmente a partire dalla versione 2.45
interface
{$Macro On}
{$H+}  // longstring


{$ifdef Win64}
 {$define Win32}
{$endif}
{$ifdef Go32v2}
 {$define TxtCrt}
{$endif}
{$ifdef Win32}
 {$define TxtVideo}
{$endif}
{$ifdef OS2}
 {$define TxtVideo}
{$endif}
{$ifdef Linux}
 {$define TxtCrt}
{$endif}

uses Crt,Dos,SysUtils,Math,Video,Keyboard,
     {$ifdef Go32v2}
      MsMouse,Go32,
      {$else}
      Mouse,
     {$endif}
     {$ifdef TxtCrt}
      Menu_Y,
     {$endif}
     {$ifdef TxtVideo}
      Menu_Y_V,TxtVideo,
     {$endif}
     Altro32,Altro32D,LDU_PCH,Select,Bit,
     Type_var,T_edit1x,T_edit20;

// l'elemento multi_file[0] viene ignorato: tutte le funzioni considerano come primo elemento multi_file[1]
function  get_numero_file_precedente_aperto(num_file:longint):longint;   // ver 2.40
function  get_numero_file_successivo_aperto(num_file:longint):longint;   // ver 2.40
function  get_next_modificato_dopo(num_file:longint):longint;            // ver 2.40
function  inserisci_file_dopo(num_file:longint):boolean;                 // ver 2.40  shift tutti gli altri + inserimento
function  get_numero_files():longint;                                    // ver 2.40
function  salva_multi_file(num_file:longint):boolean;                    // ver 2.40
function  salva_multi_file(num_file:longint; all:boolean):boolean;       // ver 2.61
function  num_file_aperti():longint;                                     // ver 2.40
function  get_num_file_by_menu_recenti(posizione_menu__y:longint):longint;     // ver 2.40
procedure ricarica_multi_file(num_file:longint);                         // ver 2.40
procedure chiudi_multi_file(num_file:longint);                           // ver 2.40
procedure chiudi_file_non_modificati;                                    // ver 2.40
procedure Aggiorna_Campi_Menu;             // ver 2.00 , update 2.25 , 2.40
procedure M_file__Nuovo;                   // update 2.40
procedure Nuovo_Comune;                    // ver 1.xx
procedure Prec_File_F6;                    // ver 2.40    F6 o CTRL+TAB
procedure Next_File_F5;                    // ver 2.40
procedure menu_visualizza(menu__y:byte);   // ver 2.40
procedure menu_recenti(menu__y:byte);      // ver 2.40
function M_opzioni__Memoria(b:boolean):char;
procedure Autodetect_File;                 // ver 1.84
procedure multi_terminale;                 // ver 2.40
procedure Salva_Con_Nome_mono_file(b:byte;start_byte,end_byte:int64);
// B=0: Salva con nome  B=1: Salva copia  B=2: Salva copia con nome da byte a byte  B=3 Salva la selezione con nome
procedure Salva_Con_Nome_mono_file(b:byte);
procedure Salva_Con_Nome(b:byte; start_byte,end_byte:int64); // update ver 2.40 , 2.52
procedure Salva_Con_Nome(b:byte);          // update ver 2.40
procedure Salva;                           // ver 1.xx
procedure Scrivi;                          // ver 1.xx salvataggio su file
procedure M_file__Chiudi_Tutti;            // update 2.40
procedure M_file__Esci;                    // update 2.40
procedure M_file__Salva_Tutti;             // ver 2.40
function  get_stringa_appunti(i:longint):string;  // ver 2.40
function  M_file__chiudi():boolean;        // ver 2.40
function  Apertura_Txt():boolean;          // update ver 1.85 , 2.20
function  Apertura_Bin():boolean;          // update ver 1.84
function  M_file__Apri(nomefilex:string; lunghezza_riga_:longint; tot_{byte a cui punta}:int64; forza_binario{0:non forza, 1 ESA , 2 TXT}:longint):char;  // update 2.00 , 2.40 , 2.52 , 2.66
function  seleziona_appunti():integer;     // ver 2.58, 3.30
function  get_nuovo_nome_file():string;    // ver 2.59
procedure visualizza_ini;                  // ver 2.61
procedure M_opzioni__Salva_Configurazione;          // ver 2.68
procedure M_opzioni__Salva_Configurazione_In;       // ver 2.68
procedure M_opzioni__Associa_Estensioni;   // ver 2.75
procedure M_file__Nuovo_2(bin:boolean);    // update 2.40 , 2.61 , 2.69 , 2.74
procedure M_opzioni__Configura3;           // ver 2.86
procedure M_File__Converti__txt_esa;       // ver 2.77
procedure M_File__Converti__esa_txt;       // ver 2.77
procedure M_file__Duplica;                 // ver 3.24
procedure Svuota_Appunti;                  // ver 3.30

{
NON INTERFACCIATI
function  get_num_files_modificati:longint;  // ver 2.40
function  get_num_file_by_menu_visualizza(posizione_menu__y:longint):longint;  // ver 2.40
function  trim_unprintable(s:string):string; // ver 2.40
procedure Salva_Tutti_2;                     // ver 2.40
procedure Uscita;                            // ver 1.xx  ripristino delle impostazioni in uscita e libera memoria
procedure Backup(var err:boolean);           // ver 1.xx
procedure libera_mem_din(num_file:longint);  // ver 2.40
function  chk_Apertura_Bin:boolean;          // ver 2.52
function  gli_attributi:word;                // ver 2.52
function  Definisci_Tipo(estensione_conosciuta:boolean):char;  // dice se aprire il file in esa o txt  *** ver 1.50 , update 2.52 ,  2.84
procedure Assegna_Estensione;  // ver 2.84
procedure mesaggio_salva_copia_o_con_nome(b:byte);     // ver 2.56
function  Get_Info__Recenti_Visualizza(pos_file:longint):string; // ver 2.66
procedure Azzera_Selezione_2(posizione_file_attuale);  // ver 2.66
function  non_selezione(pos_file:longint):boolean;     // ver 2.66
procedure visualizza_recenti_ini(separatore,file_estrai_ini:string);   // ver 2.65 : ricarica i dati per visualizza/recenti (messi poi in editor.ini)
procedure Mess_Err_Salva_Configurazione;     // ver 2.68
procedure M_File__Converti__txt(const htm:boolean);    // ver 2.77
function  Tasti_caricamento(x1,y1:byte; var pausa:boolean; var ch:char):char; // ver 2.89

// ver 3.0x
function spunta_menu_speciale(num:byte):char;     // ver 3.03
function spunta_menu_formattato(num:byte):char;   // ver 3.04
function condizione_elimina_e_taglia():boolean;   // ver 3.03
function condizione_copia_e_selezione():boolean;  // ver 3.03
function get_duplica_nome_file():string;          // ver 3.24
}

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure libera_mem_din(num_file:longint);  // ver 2.40
begin
setlength(multi_file[num_file].Testo,0);
multi_file[num_file].Annulla_Txt.destroy;
multi_file[num_file].Annulla_Esa.destroy;
multi_file[num_file].Annulla_Selezione.destroy;
multi_file[num_file].Ripristina_Txt.Destroy;       // ver 3.15
multi_file[num_file].Ripristina_Selezione.Destroy; // ver 3.15
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function non_selezione(pos_file:longint):boolean;   // ver 2.66
begin
exit( (multi_file[pos_file].selezionato.x1=0)or(multi_file[pos_file].selezionato.y1=0)or(multi_file[pos_file].selezionato.x2=0)or(multi_file[pos_file].selezionato.y2=0) );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Get_Info__Recenti_Visualizza(pos_file:longint):string;  // ver 2.66
var sel,separatore:string;
    i_byte,ii_byte,iii_byte,iiii_byte:bits;
begin
separatore:=Editor_Ini.Separatore_Valori();
i_byte.init;
i_byte.SetLength(8);
i_byte.Set_Bit(1,multi_file[pos_file].ignora);     // ignora Maiuscolo / Minuscolo , per ricerca e sostituzione: le variabili 'cerco' e 'sostituto' sono condivise
i_byte.Set_Bit(2,multi_file[pos_file].sotto_);     // direzione ricerca
i_byte.Set_Bit(3,multi_file[pos_file].jolly);      // cerca
i_byte.Set_Bit(4,multi_file[pos_file].SC);         // solo conteggio
i_byte.Set_Bit(5,multi_file[pos_file].tutto);      // sostituzione ovunque con richiesta di conferma
i_byte.Set_Bit(6,multi_file[pos_file].pInt);       // cerca parola intera
i_byte.Set_Bit(7,multi_file[pos_file].selezione);  // cerca/sostituisce dentro la selezione
i_byte.Set_Bit(8,multi_file[pos_file].selezione_quadrata);

ii_byte.init;
ii_byte.SetLength(8);
ii_byte.Set_Bit(1,multi_file[pos_file].BK);          // salva backup
ii_byte.Set_Bit(2,multi_file[pos_file].binario);     // formato esadecimale/testo non noti
ii_byte.Set_Bit(3,multi_file[pos_file].ins);         // tasto insert
ii_byte.Set_Bit(4,multi_file[pos_file].UnoS);        // mantiene uno spazio tra parole
ii_byte.Set_Bit(5,multi_file[pos_file].AutoDetect);  // apertura file intelligente
ii_byte.Set_Bit(6,multi_file[pos_file].sl);          // apre in sola lettura
ii_byte.Set_Bit(7,multi_file[pos_file].CL);          // cursore libero
ii_byte.Set_Bit(8,multi_file[pos_file].sfinal);      // salva spazi finali

iii_byte.init;
iii_byte.SetLength(8);
iii_byte.Set_Bit(1,multi_file[pos_file].per_riga);   // ver 3.23
iii_byte.Set_Bit(2,multi_file[pos_file].Home);
iii_byte.Set_Bit(3,multi_file[pos_file].Fine_);      // tasti
iii_byte.Set_Bit(4,multi_file[pos_file].salva_tab);  // tabulazione
iii_byte.Set_Bit(5,multi_file[pos_file].salva_formato='T');  // testo  8 bit
iii_byte.Set_Bit(6,multi_file[pos_file].salva_formato='B');  // testo 16 bit big endian
iii_byte.Set_Bit(7,multi_file[pos_file].salva_formato='L');  // testo 16 bit little endian
iii_byte.Set_Bit(8,multi_file[pos_file].salva_formato='U');  // testo 16 bit utf

iiii_byte.init;
iiii_byte.SetLength(8);
iiii_byte.Set_Bit(1,multi_file[pos_file].delimitatore=0);
iiii_byte.Set_Bit(2,multi_file[pos_file].delimitatore=1);
iiii_byte.Set_Bit(3,multi_file[pos_file].delimitatore=2); // di fine riga: 0,1,2
iiii_byte.Set_Bit(4,false);
iiii_byte.Set_Bit(5,false);
iiii_byte.Set_Bit(6,false);
iiii_byte.Set_Bit(7,false);
iiii_byte.Set_Bit(8,false);

if non_selezione(pos_file) then sel:='0'+separatore+'0'+separatore+'0'+separatore+'0'
                           else sel:=IntToStr(multi_file[pos_file].selezionato.x1)+separatore+IntToStr(multi_file[pos_file].selezionato.y1)
                                     +separatore+IntToStr(multi_file[pos_file].selezionato.x2)+separatore+IntToStr(multi_file[pos_file].selezionato.y2);
Get_Info__Recenti_Visualizza:=
 multi_file[pos_file].percorso+multi_file[pos_file].nomefile+Editor_Ini.Separatore_File()  // mette l' *
+IntToStr(multi_file[pos_file].lunghezza_riga)
+separatore+IntToStr(multi_file[pos_file].Tot)  // posizione in byte del file Binario
+separatore+intToStr(multi_file[pos_file].X)
+separatore+intToStr(multi_file[pos_file].X_min)
+separatore+intToStr(multi_file[pos_file].Y)
+separatore+intToStr(multi_file[pos_file].iy)
+separatore+FromTo(i_byte.BitToStr(),2,10)
+separatore+FromTo(ii_byte.BitToStr(),2,10)
+separatore+FromTo(iii_byte.BitToStr(),2,10)
+separatore+sel
+separatore+IntToStr(multi_file[pos_file].Tab_num)
+separatore+IntToStr(length(multi_file[pos_file].testo)-2)
+separatore+FromTo(iiii_byte.BitToStr(),2,10)
 ;

i_byte.Destroy;
ii_byte.Destroy;
iii_byte.Destroy;
iiii_byte.Destroy;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure chiudi_multi_file(num_file:longint);  // ver 2.40
begin
if num_file<0 then Exit;
if not multi_file[num_file].aperto then Exit; // controllo estremo
if num_file=posizione_file_attuale then salva_multi_file(num_file,false);    // ver 2.61  e' + veloce
if multi_file[num_file].nomefile<>'' then
   Editor_Ini.Input_File_Recenti(Get_Info__Recenti_Visualizza(num_file));
libera_mem_din(num_file);
multi_file[num_file].aperto:=false;
multi_file[num_file].modifica:=false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_numero_file_precedente_aperto(num_file:longint):longint;  // ver 2.40
var tot_files,cicli:longint;
begin
cicli:=0;
tot_files:=length(multi_file)-1;
while true do
      begin
      dec(num_file);
      inc(cicli);
      if cicli>=tot_files then exit(-1);
      if num_file<1 then num_file:=length(multi_file)-1;
      if multi_file[num_file].aperto then exit(num_file);
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_numero_file_successivo_aperto(num_file:longint):longint;  // ver 2.40
var tot_files,cicli:longint;
begin
cicli:=0;
tot_files:=length(multi_file)-1;
while true do
      begin
      inc(num_file);
      inc(cicli);
      if cicli>=tot_files then exit(-1);
      if num_file>tot_files then num_file:=1;
      if multi_file[num_file].aperto then exit(num_file);
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ricarica_multi_file(num_file:longint);  // ver 2.40
var i:longint;
    valido:boolean;
    s:String;
begin
Annulla_Txt.destroy;
Annulla_Esa.destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.destroy;        // ver 3.15
Ripristina_Selezione.Destroy;  // ver 3.15

salva_formato:=multi_file[num_file].salva_formato;
apri_formato:=multi_file[num_file].apri_formato;
short_name:=multi_file[num_file].short_name;

for i:=1 to multi_file[num_file].Annulla_Selezione.numelementi() do
    begin
    s:=strpas(get_iesimo(multi_file[num_file].Annulla_selezione.l, 1, valido));
    multi_file[num_file].Annulla_selezione.cancella_iniziale;
    annulla_selezione.input_finale(strnew(stringtopchar(s)));
    end;

for i:=1 to multi_file[num_file].Ripristina_Selezione.numelementi() do  // ver 3.15
    begin
    s:=strpas(get_iesimo(multi_file[num_file].Ripristina_selezione.l, 1, valido));
    multi_file[num_file].Ripristina_selezione.cancella_iniziale;
    Ripristina_selezione.input_finale(strnew(stringtopchar(s)));
    end;

salva_tab:=multi_file[num_file].salva_tab;
Tab_num:=multi_file[num_file].Tab_num;
x:=multi_file[num_file].x;
y:=multi_file[num_file].y;
lunghezza_riga:=multi_file[num_file].lunghezza_riga;
x_reale:=multi_file[num_file].x_reale;
ignora:=multi_file[num_file].ignora;
sotto_:=multi_file[num_file].sotto_;
jolly:=multi_file[num_file].jolly;
sc:=multi_file[num_file].SC;
tutto:=multi_file[num_file].tutto;
pInt:=multi_file[num_file].pInt;
BK:=multi_file[num_file].BK;
adiacente:=multi_file[num_file].adiacente;
binario:=multi_file[num_file].binario;
modifica:=multi_file[num_file].modifica;
ins:=multi_file[num_file].ins;
UnoS:=multi_file[num_file].UnoS;
AutoDetect:=multi_file[num_file].AutoDetect;
sl:=multi_file[num_file].sl;
CL:=multi_file[num_file].CL;
sfinal:=multi_file[num_file].sfinal;
selezione:=multi_file[num_file].selezione;
per_riga:=multi_file[num_file].per_riga; // ver 3.23
Home:=multi_file[num_file].Home;
Fine_:=multi_file[num_file].Fine_;
selezione_quadrata:=multi_file[num_file].selezione_quadrata;
iy:=multi_file[num_file].iy;
ymax:=multi_file[num_file].ymax;
old_selezionato:=multi_file[num_file].old_selezionato;
selezionato:=multi_file[num_file].selezionato;
tot:=multi_file[num_file].Tot;
testo:=multi_file[num_file].testo;
setlength(multi_file[num_file].Testo,0);
for i:=1 to multi_file[num_file].Annulla_txt.numelementi do
    begin
    s:=strpas(get_iesimo(multi_file[num_file].Annulla_txt.l, 1, valido));
    multi_file[num_file].Annulla_txt.cancella_iniziale;
    annulla_txt.input_finale(strnew(stringtopchar(s)));
    end;

for i:=1 to multi_file[num_file].Ripristina_txt.numelementi() do  // ver 3.15
    begin
    s:=strpas(get_iesimo(multi_file[num_file].Ripristina_txt.l, 1, valido));
    multi_file[num_file].Ripristina_txt.cancella_iniziale;
    Ripristina_txt.input_finale(strnew(stringtopchar(s)));
    end;

for i:=1 to multi_file[num_file].Annulla_Esa.numelementi do
    annulla_esa.input(multi_file[num_file].Annulla_Esa.Estrai_iniziale);
annulla_esa.reverse;
percorso:=multi_file[num_file].percorso;
nomefile:=multi_file[num_file].nomefile;
multi_file[num_file].delimitatore:=delimitatore;
un_bak:=multi_file[num_file].un_bak;
salvato:=multi_file[num_file].salvato;
file_size_byte:=multi_file[num_file].file_size_byte;
attributi_del_file:=multi_file[num_file].attributi_del_file;  // ver 2.52
x_min:=multi_file[num_file].x_min;           // ver 2.62
x_riga:=multi_file[num_file].x_riga;         // ver 2.62
max_righe:=multi_file[num_file].max_righe;   // ver 2.83
setlength(testo,max_righe+2);
init;
evidenzia_selezione; // 2.52
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_numero_files():longint;       // ver 2.40
begin
exit(length(multi_file)-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function inserisci_file_dopo(num_file:longint):boolean;  // ver 2.40   shift tutti gli altri + inserimento
var i:longint;
    valido:boolean;
begin                     // shift tutti gli altri
inserisci_file_dopo:=true;
setlength(multi_file,length(multi_file)+1);
for i:=get_numero_files-1 downto num_file+1 do
    begin
    multi_file[i+1].salva_formato:=multi_file[i].salva_formato;
    multi_file[i+1].apri_formato:=multi_file[i].apri_formato;
    multi_file[i+1].short_name:=multi_file[i].short_name;
    multi_file[i+1].salva_tab:=multi_file[i].salva_tab;
    multi_file[i+1].Tab_num:=multi_file[i].Tab_num;
    multi_file[i+1].x:=multi_file[i].x;
    multi_file[i+1].y:=multi_file[i].y;
    multi_file[i+1].lunghezza_riga:=multi_file[i].lunghezza_riga;
    multi_file[i+1].x_reale:=multi_file[i].x_reale;
    multi_file[i+1].ignora:=multi_file[i].ignora;
    multi_file[i+1].sotto_:=multi_file[i].sotto_;
    multi_file[i+1].jolly:=multi_file[i].jolly;
    multi_file[i+1].SC:=multi_file[i].SC;
    multi_file[i+1].tutto:=multi_file[i].tutto;
    multi_file[i+1].pInt:=multi_file[i].pInt;
    multi_file[i+1].BK:=multi_file[i].BK;
    multi_file[i+1].adiacente:=multi_file[i].adiacente;
    multi_file[i+1].binario:=multi_file[i].binario;
    multi_file[i+1].modifica:=multi_file[i].modifica;
    multi_file[i+1].ins:=multi_file[i].ins;
    multi_file[i+1].UnoS:=multi_file[i].UnoS;
    multi_file[i+1].AutoDetect:=multi_file[i].AutoDetect;
    multi_file[i+1].sl:=multi_file[i].sl;
    multi_file[i+1].CL:=multi_file[i].CL;
    multi_file[i+1].sfinal:=multi_file[i].sfinal;
    multi_file[i+1].selezione:=multi_file[i].selezione;
    multi_file[i+1].per_riga:=multi_file[i].per_riga;  // ver 3.23
    multi_file[i+1].Home:=multi_file[i].Home;
    multi_file[i+1].Fine_:=multi_file[i].Fine_;
    multi_file[i+1].selezione_quadrata:=multi_file[i].selezione_quadrata;
    multi_file[i+1].iy:=multi_file[i].iy;
    multi_file[i+1].ymax:=multi_file[i].ymax;
    multi_file[i+1].old_selezionato:=multi_file[i].old_selezionato;
    multi_file[i+1].selezionato:=multi_file[i].selezionato;
    multi_file[i+1].Tot:=multi_file[i].Tot;
    multi_file[i+1].percorso:=multi_file[i].percorso;
    multi_file[i+1].nomefile:=multi_file[i].nomefile;
    multi_file[i+1].delimitatore:=multi_file[i].delimitatore;
    multi_file[i+1].un_bak:=multi_file[i].un_bak;
    multi_file[i+1].salvato:=multi_file[i].salvato;
    multi_file[i+1].file_size_byte:=multi_file[i].file_size_byte;
    multi_file[i+1].Annulla_selezione.l:=multi_file[i].Annulla_selezione.l;
    multi_file[i+1].Annulla_txt.l:=multi_file[i].Annulla_txt.l;
    multi_file[i+1].testo:=multi_file[i].testo;
    multi_file[i+1].Annulla_Esa:=multi_file[i].Annulla_Esa;
    multi_file[i+1].attributi_del_file:=multi_file[i].attributi_del_file;   // ver 2.52
    multi_file[i+1].x_min:=multi_file[i].x_min;    // ver 2.62
    multi_file[i+1].x_riga:=multi_file[i].x_riga;  // ver 2.62
    end;

// inserimento vero come se il file fosse aperto
inc(num_file);
setlength(multi_file[num_file].Testo,0);
multi_file[num_file].Annulla_selezione.destroy;
multi_file[num_file].Annulla_selezione.init;
multi_file[num_file].Annulla_txt.destroy;
multi_file[num_file].Annulla_txt.init;
multi_file[num_file].Annulla_Esa.destroy;
multi_file[num_file].Annulla_Esa.init;
multi_file[num_file].Ripristina_selezione.destroy;  // ver 3.15
multi_file[num_file].Ripristina_selezione.init;     // ver 3.15
multi_file[num_file].Ripristina_txt.destroy;        // ver 3.15
multi_file[num_file].Ripristina_txt.init;           // ver 3.15

multi_file[num_file].salva_formato:=salva_formato;   // t_edit_2
multi_file[num_file].apri_formato:=apri_formato;
multi_file[num_file].short_name:=short_name;

for i:=1 to Annulla_Selezione.numelementi() do
    begin
    multi_file[num_file].Annulla_selezione.input_finale(strnew(stringtopchar(get_iesimo(Annulla_selezione.l,i,valido))));
    if memavail<min_mem_avail then
       begin
       libera_mem_din(num_file);
       exit(false);
       end;
    end;
for i:=1 to Ripristina_Selezione.numelementi() do   // ver 3.15
    begin
    multi_file[num_file].Ripristina_selezione.input_finale(strnew(stringtopchar(get_iesimo(Ripristina_selezione.l,i,valido))));
    if memavail<min_mem_avail then
       begin
       libera_mem_din(num_file);
       exit(false);
       end;
    end;

multi_file[num_file].attributi_del_file:=attributi_del_file;   // ver 2.52
multi_file[num_file].salva_tab:=salva_tab;           // da t_edit32
multi_file[num_file].Tab_num:=Tab_num;
multi_file[num_file].x:=x;
multi_file[num_file].y:=y;
multi_file[num_file].lunghezza_riga:=lunghezza_riga;
multi_file[num_file].x_reale:=x_reale;
multi_file[num_file].ignora:=ignora;
multi_file[num_file].sotto_:=sotto_;
multi_file[num_file].jolly:=jolly;
multi_file[num_file].SC:=SC;
multi_file[num_file].tutto:=tutto;
multi_file[num_file].pInt:=pInt;
multi_file[num_file].BK:=BK;
multi_file[num_file].adiacente:=adiacente;
multi_file[num_file].binario:=binario;
multi_file[num_file].modifica:=modifica;
multi_file[num_file].ins:=ins;
multi_file[num_file].UnoS:=UnoS;
multi_file[num_file].AutoDetect:=AutoDetect;
multi_file[num_file].sl:=sl;
multi_file[num_file].CL:=CL;
multi_file[num_file].sfinal:=sfinal;
multi_file[num_file].selezione:=selezione;
multi_file[num_file].per_riga:=per_riga;  // ver 3.23
multi_file[num_file].Home:=Home;
multi_file[num_file].Fine_:=Fine_;
multi_file[num_file].selezione_quadrata:=selezione_quadrata;
multi_file[num_file].iy:=iy;
multi_file[num_file].ymax:=ymax;
multi_file[num_file].old_selezionato:=old_selezionato;
multi_file[num_file].selezionato:=selezionato;
multi_file[num_file].Tot:=Tot;

multi_file[num_file].Testo:=testo;
for i:=1 to Annulla_Txt.numelementi() do
    begin
    multi_file[num_file].Annulla_Txt.input_finale(strnew(stringtopchar(get_iesimo(Annulla_Txt.l,i,valido))));
    if memavail<min_mem_avail then
       begin
       libera_mem_din(num_file);
       exit(false);
       end;
    end;

for i:=1 to Ripristina_Txt.numelementi() do // ver 3.15
    begin
    multi_file[num_file].Ripristina_Txt.input_finale(strnew(stringtopchar(get_iesimo(Ripristina_Txt.l,i,valido))));
    if memavail<min_mem_avail then
       begin
       libera_mem_din(num_file);
       exit(false);
       end;
    end;

for i:=1 to Annulla_Esa.numelementi do
    begin
    multi_file[num_file].Annulla_Esa.Input(Annulla_Esa.Get_stringa(i));
    if memavail<min_mem_avail then
       begin
       libera_mem_din(num_file);
       exit(false);
       end;
    end;

multi_file[num_file].percorso:=percorso;
multi_file[num_file].nomefile:=nomefile;
multi_file[num_file].delimitatore:=delimitatore;
multi_file[num_file].un_bak:=un_bak;
multi_file[num_file].salvato:=salvato;
multi_file[num_file].file_size_byte:=file_size_byte;
multi_file[num_file].aperto:=true;
multi_file[num_file].x_min:=x_min;     // ver 2.62
multi_file[num_file].x_riga:=x_riga;   // ver 2.62
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function salva_multi_file(num_file:longint):boolean;  // ver 2.40  salva tutto
begin
result:=salva_multi_file(num_file,true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function salva_multi_file(num_file:longint; all:boolean):boolean;    // ver 2.40
var i:longint;     // non inserisce un nuovo file ma aggiorna uno preesistente
    valido:boolean;
begin
salva_multi_file:=true;

libera_mem_din(num_file);
setlength(multi_file[num_file].Testo,0);
multi_file[num_file].Annulla_selezione.init;
multi_file[num_file].Annulla_txt.init;
multi_file[num_file].Annulla_Esa.init;

multi_file[num_file].salva_formato:=salva_formato;
multi_file[num_file].apri_formato:=apri_formato;
multi_file[num_file].short_name:=short_name;

if all then
   begin
   for i:=1 to Annulla_Selezione.numelementi() do
       begin
       multi_file[num_file].Annulla_selezione.input_finale(strnew(stringtopchar(get_iesimo(Annulla_selezione.l,i,valido))));
       if memavail<min_mem_avail then
          begin
          libera_mem_din(num_file);
          exit(false);
          end;
       end;
   for i:=1 to Ripristina_Selezione.numelementi() do  // ver 3.15
       begin
       multi_file[num_file].Ripristina_selezione.input_finale(strnew(stringtopchar(get_iesimo(Ripristina_selezione.l,i,valido))));
       if memavail<min_mem_avail then
          begin
          libera_mem_din(num_file);
          exit(false);
          end;
       end;
   end;
multi_file[num_file].salva_tab:=salva_tab;
multi_file[num_file].Tab_num:=Tab_num;
multi_file[num_file].x:=x;
multi_file[num_file].y:=y;
multi_file[num_file].lunghezza_riga:=lunghezza_riga;
multi_file[num_file].x_reale:=x_reale;
multi_file[num_file].ignora:=ignora;
multi_file[num_file].sotto_:=sotto_;
multi_file[num_file].jolly:=jolly;
multi_file[num_file].SC:=SC;
multi_file[num_file].tutto:=tutto;
multi_file[num_file].pInt:=pInt;
multi_file[num_file].BK:=BK;
multi_file[num_file].adiacente:=adiacente;
multi_file[num_file].binario:=binario;
multi_file[num_file].modifica:=modifica;
multi_file[num_file].ins:=ins;
multi_file[num_file].UnoS:=UnoS;
multi_file[num_file].AutoDetect:=AutoDetect;
multi_file[num_file].sl:=sl;
multi_file[num_file].CL:=CL;
multi_file[num_file].sfinal:=sfinal;
multi_file[num_file].selezione:=selezione;
multi_file[num_file].per_riga:=per_riga;
multi_file[num_file].Home:=Home;
multi_file[num_file].Fine_:=Fine_;
multi_file[num_file].selezione_quadrata:=selezione_quadrata;
multi_file[num_file].iy:=iy;
multi_file[num_file].ymax:=ymax;
multi_file[num_file].old_selezionato:=old_selezionato;
multi_file[num_file].selezionato:=selezionato;
multi_file[num_file].Tot:=Tot;
multi_file[num_file].Testo:=testo;

if all then
   begin
   for i:=1 to Annulla_Txt.numelementi() do
       begin
       multi_file[num_file].Annulla_Txt.input_finale(strnew(stringtopchar(get_iesimo(Annulla_Txt.l,i,valido))));
       if memavail<min_mem_avail then
          begin
          libera_mem_din(num_file);
          exit(false);
          end;
       end;
   for i:=1 to Ripristina_Txt.numelementi() do // ver 3.15
       begin
       multi_file[num_file].Ripristina_Txt.input_finale(strnew(stringtopchar(get_iesimo(Ripristina_Txt.l,i,valido))));
       if memavail<min_mem_avail then
          begin
          libera_mem_din(num_file);
          exit(false);
          end;
       end;
   end;

if all then
   for i:=1 to Annulla_Esa.numelementi do
       begin
       multi_file[num_file].Annulla_Esa.Input(Annulla_Esa.Get_stringa(i));
       if memavail<min_mem_avail then
          begin
          libera_mem_din(num_file);
          exit(false);
          end;
       end;

multi_file[num_file].percorso:=percorso;
multi_file[num_file].nomefile:=nomefile;
multi_file[num_file].delimitatore:=delimitatore;
multi_file[num_file].un_bak:=un_bak;
multi_file[num_file].salvato:=salvato;
multi_file[num_file].file_size_byte:=file_size_byte;
multi_file[num_file].aperto:=true;
multi_file[num_file].attributi_del_file:=attributi_del_file; // ver 2.52
multi_file[num_file].x_min:=x_min;           // ver 2.62
multi_file[num_file].x_riga:=x_riga;         // ver 2.62
multi_file[num_file].max_righe:=length(testo)-2;   // ver 2.83
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  get_next_modificato_dopo(num_file:longint):longint;    // ver 2.40
var tot_files,cicli:longint;
begin
cicli:=0;
tot_files:=length(multi_file)-1;
while true do
      begin
      inc(num_file);
      inc(cicli);
      if num_file>tot_files then num_file:=1;
      if multi_file[num_file].aperto and multi_file[num_file].modifica then exit(num_file);
      if cicli=tot_files then exit(-1);
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure chiudi_file_non_modificati;   // ver 2.40
var i:longint;
begin
for i:=1 to get_numero_files do
    if not multi_file[i].modifica then
       chiudi_multi_file(i);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function num_file_aperti():longint;   // ver 2.40
var i,n:longint;
begin
n:=0;
for i:=1 to get_numero_files do
    if multi_file[i].aperto then
       inc(n);
exit(n);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_num_files_modificati():longint;   // ver 2.40
var i,n:longint;
begin
n:=0;
for i:=1 to get_numero_files do
    if multi_file[i].modifica and multi_file[i].aperto {controllo ulteriore per sicurezza} then
       inc(n);
exit(n);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_num_file_by_menu_visualizza(posizione_menu__y:longint):longint;  // ver 2.40
var i:longint;          // update ver 2.52
begin
for i:=get_numero_files downto 1 do
    begin
    if multi_file[i].aperto then dec(posizione_menu__y);
    if posizione_menu__y=0 then Exit(i);
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_num_file_by_menu_recenti(posizione_menu__y:longint):longint;   // ver 2.40
var i:longint;
begin
i:=posizione_file_attuale;
while true do
      begin
      dec(i);
      if i=0 then i:=get_numero_files;
      if (not multi_file[i].aperto) and (multi_file[i].nomefile<>'') then
         begin
         dec(posizione_menu__y);
         if posizione_menu__y=0 then Exit(i);
         end;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function spunta_menu_speciale(num:byte):char;   // ver 3.03
begin
if num=menu_selezione_speciale then Exit(spunta)
                               else Exit(' ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function spunta_menu_formattato(num:byte):char;   // ver 3.04
begin
if num=menu_selezione_formattato then Exit(spunta)
                                 else Exit(' ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function condizione_elimina_e_taglia():boolean;  // ver 3.03
begin
result:=true;
if binario or testo_vuoto() then exit(false);
if (menu_selezione_speciale in [1,3]) and (length(testo[iy])<2) then exit(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function condizione_copia_e_selezione():boolean;  // ver 3.03
begin
result:=true;
if testo_vuoto() then exit(false);
if (menu_selezione_speciale in [1..3]) and (length(testo[iy])<2) then exit(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure  Aggiorna_Campi_Menu;  // ver 2.00 , update 2.25 , 2.40 , 2.52
var s,determina_tipo_annulla_,determina_tipo_ripristina_:string;
    max_lunghezza,i:integer;
    fattibile:boolean;
    j:byte;
begin
// FILE
ListaY[1].Selezionabile(5, not sono_Appunti() ); // salva : non puo' salvare gli appunti  ver 3.28
ListaY[1].Selezionabile(7, modifica or (get_num_files_modificati>0) );   // salva tutti
ListaY[1].Selezionabile(8, not ( (nomefile='') and not modifica and testo_vuoto and (num_file_aperti<=1) ));   // chiudi
ListaY[1].Selezionabile(9, (num_file_aperti>1) or not testo_vuoto or modifica);   // chiudi tutti
ListaY[1].Selezionabile(11,(nomefile<>'') and not sono_Appunti() );  // elimina
ListaY[1].Selezionabile(13,(nomefile<>'') and not sono_Appunti() );  // rinomina

// MODIFICA
ListaY[2].Selezionabile(1,(Annulla_Txt.NumElementi<>0) ); // annulla
ListaY[2].Selezionabile(2,(Ripristina_Txt.NumElementi<>0) );
determina_tipo_annulla_:=determina_tipo_annulla(true);
determina_tipo_ripristina_:=determina_tipo_annulla(false);


if length(determina_tipo_ripristina_)>length(determina_tipo_annulla_) then determina_tipo_annulla_:=determina_tipo_ripristina_;
for i:=1 to length(determina_tipo_annulla_) do determina_tipo_annulla_[i]:=' '; // update 2.25
                                                                              // nn deve essere gi selezionato
ListaY[2].Selezionabile(4,(not Testo_Vuoto) and (not selezione_quadrata) and not ((selezionato.y1=1) and (selezionato.x1=1) and (selezionato.y2=ymax) and (selezionato.x2=length(testo[ymax])-1))  );  // seleziona tutto
ListaY[2].AggiornaRiga(4,Lingue.get_txt(410)+determina_tipo_annulla_,Lingue.get_charB(410)); // ' Seleziona tutto ' S
ListaY[2].Selezionabile(5,selezionato.x1<>0);      // deseleziona
ListaY[2].AggiornaRiga(5,Lingue.get_txt(411)+determina_tipo_annulla_+'   Shift+Esc ',Lingue.get_charB(411)); // ' Deseleziona  '   D
ListaY[2].Selezionabile(7,( (selezionato.x1<>0) and not binario) or ( (selezionato.x1<>0) and binario and is_last_block and (selezionato.y2=ymax) and (selezionato.x2+1=length(testo[ymax])) ) );    // taglia
ListaY[2].AggiornaRiga(7,Lingue.get_txt(412)+determina_tipo_annulla_+'   Shift+Canc ',Lingue.get_charB(412));  // ' Taglia      '  T
ListaY[2].Selezionabile(8,selezionato.x1<>0);      // copia
ListaY[2].AggiornaRiga(8,Lingue.get_txt(413)+determina_tipo_annulla_+'   Ctrl+Ins ',Lingue.get_charB(413));  // ' Copia         ' C
ListaY[2].Selezionabile(9,(num_Elementi_appunti<>0) and ( (not binario) or (binario and is_last_block and (iy=ymax)and(x=length(testo[iy])) )) ); // incolla
ListaY[2].AggiornaRiga(9,Lingue.get_txt(414)+determina_tipo_annulla_+'  Shift+Ins ',Lingue.get_charB(414));  // ' Incolla ultimo' I
ListaY[2].Selezionabile(10,(num_Elementi_appunti<>0) and ( (not binario) or (binario and is_last_block and (iy=ymax)and(x=length(testo[iy])) )) ); // incolla
ListaY[2].AggiornaRiga(10,Lingue.get_txt(415)+determina_tipo_annulla_+'      Ctrl+v ',Lingue.get_charB(415));  //  ' Incolla lista'  l
ListaY[2].Selezionabile(11,( (selezionato.x1<>0) and (not binario)) or (binario and is_last_block and (not testo_vuoto) and (selezionato.x1<>0) and (selezionato.y2=ymax)and(selezionato.x2+1=length(testo[ymax])) ));      // elimina
ListaY[2].AggiornaRiga(11,Lingue.get_txt(416)+determina_tipo_annulla_+'   Ctrl+Canc ',Lingue.get_charB(416));  //  ' Elimina      '  E
ListaY[2].Selezionabile(13,num_Elementi_appunti<>0 ); // Mostra appunti  ver 3.28
if sono_Appunti() then ListaY[2].AggiornaRiga(13,Lingue.get_txt(551),Lingue.get_charB(551))     // Nascondi appunti
                  else ListaY[2].AggiornaRiga(13,Lingue.get_txt(549),Lingue.get_charB(549));    // Mostra appunti
i:=length(ListaY[2].TestoRiga(5));
if sono_Appunti() then for j:=1 to ListaY[2].NumElementi()-1 do ListaY[2].Selezionabile(j,false);

s:=Lingue.get_txt(417)+determina_tipo_annulla(true)+'    Alt+BackSpace '; // ' Annulla '
while length(s)<i do insert(' ',s,length(s)-17);
ListaY[2].AggiornaRiga(1,s,Lingue.get_charB(417));

s:=Lingue.get_txt(418)+determina_tipo_annulla(false);  //  ' Ripristina '
while length(s)<i do s:=s+' ';
ListaY[2].AggiornaRiga(2,s,Lingue.get_charB(418));

// CERCA
ListaY[3].Selezionabile(1,not testo_vuoto);  // vai
ListaY[3].Selezionabile(2,not testo_vuoto);  // cerca
ListaY[3].Selezionabile(3,(not testo_vuoto) and ((not selezione) or (selezione and(selezionato.x1<>0))) );  // ripeti cerca
ListaY[3].Selezionabile(4,not sono_Appunti and (not binario) and (not testo_vuoto) );  // sostituisci
ListaY[3].Selezionabile(5,not sono_Appunti and (not binario) and (not testo_vuoto)and ((not selezione) or (selezione and(selezionato.x1<>0))) );  // ripeti sostituisci

// FORMATTATO
ListaY[4].AggiornaRiga(1,spunta_menu_formattato(1)+Lingue.get_txt(419),Lingue.get_charB(419));  //  '... Selezione ' e
ListaY[4].AggiornaRiga(2,spunta_menu_formattato(2)+Lingue.get_txt(420),Lingue.get_charB(420));  //  '... Paragrafo attuale ' P
ListaY[4].AggiornaRiga(3,spunta_menu_formattato(3)+Lingue.get_txt(421),Lingue.get_charB(421));  //  '... Riga attuale '   l
ListaY[4].AggiornaRiga(4,spunta_menu_formattato(4)+Lingue.get_txt(422),Lingue.get_charB(422));  //  '... Parola attuale ' t
ListaY[4].AggiornaRiga(5,spunta_menu_formattato(5)+Lingue.get_txt(423),Lingue.get_charB(423));  //  '... Da riga a riga ' r
if spunta_menu_formattato(1)<>' ' then fattibile:=selezionato.x1<>0 // selezione
                                  else
if (spunta_menu_formattato(2)<>' ')or(spunta_menu_formattato(3)<>' ') then fattibile:= (trim(copy_end(testo[iy],2))<>'') // paragrafo o riga attuale
                                  else
if spunta_menu_formattato(5)<>' ' then fattibile:=not Testo_Vuoto() // da riga a riga
                                  else fattibile:=true; // parola attuale
ListaY[4].Selezionabile(7,fattibile);
ListaY[4].Selezionabile(8,fattibile);
ListaY[4].Selezionabile(9,fattibile);
ListaY[4].Selezionabile(10,fattibile);
ListaY[4].Selezionabile(11,fattibile);
ListaY[4].Selezionabile(12,fattibile);
ListaY[4].Selezionabile(13,( (not binario) or (binario and (iy=ymax))) and fattibile );
ListaY[4].Selezionabile(15,not binario);  // sinistra
ListaY[4].Selezionabile(16,not binario);  // destra
ListaY[4].Selezionabile(17,not binario);  // centra
ListaY[4].Selezionabile(18,not binario);  // giustificato
if sono_Appunti() then for j:=1 to ListaY[4].NumElementi() do ListaY[4].Selezionabile(j,false);

// SPECIALE
ListaY[5].AggiornaRiga(1,spunta_menu_speciale(1)+Lingue.get_txt(424),Lingue.get_charB(424));  //  '... Paragrafo attuale '  P
ListaY[5].AggiornaRiga(2,spunta_menu_speciale(2)+Lingue.get_txt(425),Lingue.get_charB(425));  //  '... Riga attuale '   R
ListaY[5].AggiornaRiga(3,spunta_menu_speciale(3)+Lingue.get_txt(426),Lingue.get_charB(426));  //  '... Parola attuale ' l
ListaY[5].AggiornaRiga(4,spunta_menu_speciale(4)+Lingue.get_txt(427),Lingue.get_charB(427));  //  '... Da riga a riga ' D
ListaY[5].Selezionabile(6,condizione_elimina_e_taglia());  // menu speciale / taglia  ...
ListaY[5].Selezionabile(7,condizione_copia_e_selezione()); // copia riga attuale
ListaY[5].Selezionabile(8,condizione_elimina_e_taglia());  // menu speciale / taglia  ...
ListaY[5].Selezionabile(9,condizione_copia_e_selezione()); // copia riga attuale
ListaY[5].Selezionabile(11,(not binario)and(length(appunti)=1)); // incolla in riga ... (solo l'ultimo)
ListaY[5].Selezionabile(12,(not binario)and(length(appunti)>0)); // incolla tutto in riga ...
ListaY[5].Selezionabile(13,(not binario)and(length(appunti)>0)); // incolla tutto
ListaY[5].Selezionabile(14, length(appunti)>0 );                 // svuota appunti  ver 3.30
if sono_Appunti() then for j:=1 to ListaY[5].NumElementi()-1 do ListaY[5].Selezionabile(j,false);

// OPZIONI
ListaY[6].Selezionabile(1,(nomefile<>'') and (not sono_Appunti) );  // associa estensione
ListaY[6].Selezionabile(3,not binario);   // formato salva testo

// VISUALIZZA
ListaY[7].destroy;
Lista_Visualizza.init;
Lista_Visualizza.set_menu_ciclico(true);
max_larghezza_menu_visualizza:=0;

for i:=1 to get_numero_files do
    if multi_file[i].aperto then
           Lista_Visualizza.Input(' '+TruncPath(multi_file[i].percorso+multi_file[i].nomefile,60)+' ');
for i:=1 to Lista_Visualizza.numElementi do
    max_larghezza_menu_visualizza:=max(max_larghezza_menu_visualizza,length(Lista_Visualizza.Get_stringa(i)));
max_larghezza_menu_visualizza:=min(60,max_larghezza_menu_visualizza);

// RECENTI
ListaX.AggiornaElemento(8,Editor_Ini.numElementi_File_Recenti>0);
ListaY[8].destroy;

max_lunghezza:=0;
while true do
      begin
      if ListaY[8].NumElementi=9 then break;
      s:=Editor_Ini.Get_File_Recenti(ListaY[8].NumElementi+1,false);  //  gruppo [RECENTI]  : files chiusi
      if s='' then break;
      i:=pos(Editor_Ini.Separatore_File(),s);  // estraggo il nome del file
      if i=0 then s:=trim(s)
             else s:=copy(s,1,i-1);
      ListaY[8].NuovaRiga(' '+IntToStr(ListaY[8].NumElementi+1)+' '+TruncPath(s,50)+' ',ListaY[8].NumElementi+49);
      max_lunghezza:=max(max_lunghezza,length(ListaY[8].TestoRiga(ListaY[8].NumElementi)));
      end;
if ListaY[8].NumElementi>0 then
   begin
   ListaY[8].Inserisci(1,'',1);
   ListaY[8].Inserisci(1,Lingue.get_txt(428),Lingue.get_charB(428)); // update 2.45  // ' Svuota lista '  S
   end;

ListaY[8].x:=0;
for i:=1 to 8 do
    ListaY[8].x:=ListaY[8].x+length(ListaX.Get_nome(byte(i)))+2;
ListaY[8].x:=byte(max(ListaY[8].x-max_lunghezza,2)); // se il nome del file e' troppo lungo, il risultato puo' essere negativo
ListaY[8].y:=ListaX.y-ListaY[8].NumElementi-2;

// FILE --> STAMPA
ListaY[9].Selezionabile(3,not Testo_Vuoto);
ListaY[9].Selezionabile(4, (not Testo_Vuoto) and (selezionato.x1<>0) );
ListaY[9].Selezionabile(5,not Testo_Vuoto);
ListaY[9].Selezionabile(6,not Testo_Vuoto);
ListaY[9].Selezionabile(7,not Testo_Vuoto);

// FILE --> CARICA
ListaY[13].Selezionabile(1,(nomefile<>'') and not sono_Appunti() );   // ricarica
ListaY[13].Selezionabile(2,(nomefile<>'') and not sono_Appunti() );   // riapri in...
if binario then ListaY[13].AggiornaRiga(2,Lingue.get_txt(408),Lingue.get_charB(408))  // ' Riapri in TXT '
           else ListaY[13].AggiornaRiga(2,Lingue.get_txt(409),Lingue.get_charB(409)); // ' Riapri in ESA '
ListaY[13].Selezionabile(3, not sono_Appunti() );   // ripeti apri come testo      // ver 3.28
ListaY[13].Selezionabile(4, not sono_Appunti() );   // ripeti apri in esadecimale  // ver 3.28
ListaY[13].Selezionabile(5, not sono_Appunti() );   // cambia numero di colonne    // ver 3.28
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Nuovo_Comune;
begin
attributi_del_file:='____'; // update 2.52
SL:=false;                  // update 2.52
if binario then setlength(testo,next_max_righe_esa)
           else setlength(testo,next_max_righe_txt);
max_righe:=length(testo)-2; // ver 2.83
testo[1]:=#13;
nomefile:='';
Set_Cursore_X(1);
iy:=1;
y:=1;
ymax:=1;
init;
modifica:=false;
normale;
clrscr;
Azzera_Selezione;  // update ver 2.10
{$ifdef TxtVideo}
 ForceUpdateXY(0,0,ScreenWidth*(riga_menu-1));
 SetTextColorXY(0,riga_menu+2,white,ScreenWidth*2);
 SetBackColorXY(0,riga_menu+2,blue,ScreenWidth*2);
 Evidenzia_Selezione;
{$endif}
gotoxy(x,y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Nuovo_2(bin:boolean);  // update 2.40 , 2.61 , 2.69 , 2.74
begin
if not salva_multi_file(posizione_file_attuale) then  // aggiorno il file attuale
   begin
   Error_Multi_Files;
   exit;
   end;
setlength(multi_file,length(multi_file)+1);    // ver 2.61 , 2.74
posizione_file_attuale:=get_numero_files;      // ver 2.61 , 2.74
Nuovo_Comune;
Annulla_Txt.destroy;
Annulla_Esa.destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
salvato:=nil;
binario:=bin;
ins:=bin;
if binario then lunghezza_riga:=next_length_ESA
           else lunghezza_riga:=next_length_TXT;
nomefile:=get_nuovo_nome_file();  // ver 2.59
if not salva_multi_file(posizione_file_attuale) then  // aggiorno il file appena creato
   begin
   Error_Multi_Files;
   exit;
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_duplica_nome_file():string; // ver 3.24
var error:boolean;
    nome_,duplica:string;
    pos_spazio,n:longint;
    pos_err:word;
const duplicato:longint=0;

begin
inc(duplicato);
error:=false;
duplica:=trim(upcase(Lingue.get_txt(541)));
nome_:=(nomefile);
if pos(duplica,upcase(nome_))=1 then
                        begin
                        nome_:=copy_end(nome_,length(duplica)+1);
                        pos_spazio:=pos(' ',nome_);
                        if pos_spazio>1 then
                                        begin
                                        Val_Try(copy(nome_,1,pos_spazio-1),n,pos_err);
                                        if pos_err>0 then error:=true;
                                        end
                                       else error:=true;
                        end
                       else error:=true;
if error then nome_:=nomefile
         else nome_:=copy_end(nome_,pos_spazio+1);
get_duplica_nome_file:=trim(trim(Lingue.get_txt(541))+IntToStr(duplicato)+' '+nome_);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Duplica; // ver 3.24
begin
if not salva_multi_file(posizione_file_attuale) then  // aggiorno il file attuale
   begin
   Error_Multi_Files;
   exit;
   end;
setlength(multi_file,length(multi_file)+1);
posizione_file_attuale:=get_numero_files;
if binario then
   begin
   tot:=0;
   modifica:=true; // in binario modifica sempre TRUE poiche'  un solo blocco del file in memoria (quindi una modifica)
   end;

nomefile:=get_duplica_nome_file();
evidenzia_selezione;
if not salva_multi_file(posizione_file_attuale) then  // aggiorno il file appena creato
   begin
   Error_Multi_Files;
   exit;
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Nuovo; // ver 2.69
begin
ListaY[1].Mostra;
menu__x:=10;
listaX.stampa_selezionato;
case {menu__y} ListaY[10].costruisci of
     0: Evidenzia_Selezione;
     1: M_file__Nuovo_2(false);  // nuovo TXT
     2: M_file__Nuovo_2(true);   // nuovo ESA
     3: M_file__Duplica;         // ver 3.24
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Prec_File_F6;  // ver 2.40    F6 o CTRL+TAB
var precedente_posizione_file_attuale:longint;
begin
if sono_Appunti() then
   begin
   M_file__Chiudi();
   grafica;
   Exit; // sono gli appunti ver 3.28
   end;

precedente_posizione_file_attuale:=posizione_file_attuale;
posizione_file_attuale:=get_numero_file_precedente_aperto(posizione_file_attuale);
if posizione_file_attuale>0 then
      begin
      if not salva_multi_file(precedente_posizione_file_attuale) then
             begin
             posizione_file_attuale:=precedente_posizione_file_attuale;
             Error_Multi_Files;
             exit;
             end;
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      grafica;
      end
     else  // c'era un solo file aperto
      begin
      posizione_file_attuale:=precedente_posizione_file_attuale;
      exit;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Next_File_F5;  // ver 2.40
var precedente_posizione_file_attuale:longint;
begin
if sono_Appunti() then
   begin
   M_file__Chiudi();
   grafica;
   Exit; // sono gli appunti ver 3.28
   end;
precedente_posizione_file_attuale:=posizione_file_attuale;
posizione_file_attuale:=get_numero_file_successivo_aperto(posizione_file_attuale);
if posizione_file_attuale>0 then
      begin
      if not salva_multi_file(precedente_posizione_file_attuale) then
             begin
             posizione_file_attuale:=precedente_posizione_file_attuale;
             Error_Multi_Files;
             exit;
             end;
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      grafica;
      end
     else  // c'era un solo file aperto
      begin
      posizione_file_attuale:=precedente_posizione_file_attuale;
      exit;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure menu_visualizza(menu__y:byte);   // ver 2.40
begin   // salvo lo stato del file corrente, e ricarico quello indicato
if menu__y>0 then
             begin
             if (not sono_Appunti()) and (not salva_multi_file(posizione_file_attuale)) then
                    begin
                    Error_Multi_Files;
                    exit;
                    end;
             if sono_Appunti() then
                begin
                modifica:=false;
                M_file__Chiudi();
                salva_multi_file(posizione_file_attuale);
                end;
             posizione_file_attuale:=get_num_file_by_menu_visualizza(menu__y);
             ricarica_multi_file(posizione_file_attuale);
             end;
Evidenzia_Selezione;
grafica;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function chk_Apertura_Bin:boolean; //  ver 2.52
var i,j:longint;
begin
chk_Apertura_Bin:=false;
if file_size_byte=0 then Exit(true);
for i:=1 to ymax do
    for j:=1 to length(testo[i]) do
        if ord(testo[i][j]) in [0..9,11,12,14..31] then exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Select__apertura_file(k:char;x1,y1:byte);  // ver 2.89
begin
cursorOff;
{$ifdef TxtCrt}
colore;
HideMouse;
case upcase(K) of
 'C','P'
     : begin   // Pausa & Continua
       gotoxy(x1-1,y1);
       write('[');
       gotoxy(x1+10,y1);
       write('] ');
       gotoxy(x1+21,y1);
       write('  ');
       gotoxy(x1+38,y1);
       write(' ');
       end;
 'A' : begin   // Annulla
       gotoxy(x1+10,y1);
       write(' [');
       gotoxy(x1+21,y1);
       write('] ');
       gotoxy(x1+38,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write(' ');
       end;
 'T' : begin   // annulla  Tutti
       gotoxy(x1+21,y1);
       write(' [');
       gotoxy(x1+38,y1);
       write(']');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write('  ');
       end;
  end; {case}
ShowMouse;
{$endif}
{$ifdef TxtVideo}
dec(x1);
dec(y1);
case upcase(K) of
 'C','P'
     : begin   // Pausa & Continua
       outtextxy(x1-1,y1,'[',255,blue,white);
       outtextxy(x1+10,y1,'] ',255,blue,white);
       outtextxy(x1+21,y1,'  ',255,blue,white);
       outtextxy(x1+38,y1,' ',255,blue,white);
       end;
 'A' : begin   // Annulla
       outtextxy(x1+10,y1,' [',255,blue,white);
       outtextxy(x1+21,y1,'] ',255,blue,white);
       outtextxy(x1+38,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       end;
 'T' : begin   // annulla  Tutti
       outtextxy(x1+21,y1,' [',255,blue,white);
       outtextxy(x1+38,y1,']',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,'  ',255,blue,white);
       end;
  end; {case}
updatescreen(false);
{$endif}
gotoxy(x,y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasti_Carica_Files(x1,y1:byte; c:char; pausa:boolean);  // ver 2.89
begin
dec(x1);
pausa:=not pausa;
{$ifdef TxtCrt}
HideMouse;
textbackground(blue);
gotoxy(1,riga_menu+1);
clreol;
textcolor(red);
textbackground(7);
gotoxy(x1+1,y1);
if pausa then write(Lingue.get_txt(429)+Lingue.get_txt(431)+Lingue.get_txt(432))    // '< Pausa  >  <Annulla>  <annulla Tutti>'
         else write(Lingue.get_txt(430)+Lingue.get_txt(431)+Lingue.get_txt(432));   // '<Continua>  <Annulla>  <annulla Tutti>'
{$endif}
{$ifdef TxtVideo}
forceupdatexy(0,riga_menu,ScreenWidth*3);
if pausa then outtextxy(x1,y1-1,Lingue.get_txt(429)+Lingue.get_txt(431)+Lingue.get_txt(432),0,7,red)  // '< Pausa  >  <Annulla>  <annulla Tutti>'
         else outtextxy(x1,y1-1,Lingue.get_txt(430)+Lingue.get_txt(431)+Lingue.get_txt(432),0,7,red); // '<Continua>  <Annulla>  <annulla Tutti>'
outtextxy(x1+10,y1-1,'  ',0,blue,white);
outtextxy(x1+21,y1-1,'  ',0,blue,white);
updatescreen(false);
{$endif}
cursorOff;
Select__apertura_file(c,x1+1,y1);
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasti_caricamento(x1,y1:byte; var pausa:boolean; var ch:char):char; // ver 2.89
var old_c,c:string;
    cliccato:boolean;
label tab;
begin
c:=ch;
ShowMouse;
ShowMouse;
if (PollKeyEvent<>0) then
        begin
        old_c:=c;
        c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
        if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
        if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
        if length(c)=1 then c:=upcase(c);
        if (c=Lingue.get_charUP(429)) and pausa then c:='P' else
        if (c=Lingue.get_charUP(430)) and not pausa then c:='C' else
        if (c=Lingue.get_charUP(431)) then c:='A' else
        if (c=Lingue.get_charUP(432)) then c:='T';

        if (c='A')or(c='T')or(c='P')or(c='C') then else  //  N T S
        if (c='Right')or(c='Down') then goto tab // destra  #77,#80
                                   else
        if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then  //  sinistra  #72,#75 shift+tab
                         begin
                         if length(old_c)=1 then
                                  begin
                                  case old_c[1] of       // CP AT
                                       'c' : c:='t';
                                       'p' : c:='t';
                                       'a' : if pausa then c:='c'
                                                      else c:='p';
                                       't' : c:='a';
                                       end;
                                  old_c:=c;
                                  Select__apertura_file(c[1],x1,y1);
                                  end;
                         end else
        if (c=#27) then c:='A' else
        if (c=#13)or(c=#32) then
                            begin
                            c:=upcase(old_c);
                            if c='P' then
                                     begin
                                     c:='C';
                                     pausa:=true;
                                     end
                                    else if c='C' then
                                                  begin
                                                  c:='P';
                                                  pausa:=false;
                                                  end;
                            end else
        if (c=#9) then
                   begin
                   tab:
                   if length(old_c)=1 then
                                  begin
                                  case old_c[1] of
                                       'c' : c:='a';
                                       'p' : c:='a';
                                       'a' : c:='t';
                                       't' : if pausa then c:='c'
                                                      else c:='p';
                                       end;
                                  Select__apertura_file(c[1],x1,y1);
                                  end;
                   end
                  else
                   c:=old_c;
        end
       else // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=y1) then
            begin
            if (mox>x1-1) and (mox<10+x1) then
                                         if pausa then c:='C'
                                                  else c:='P';
            if (mox>11+x1) and (mox<21+x1) then c:='A';
            if (mox>22+x1) and (mox<38+x1) then c:='T';
            end;
        end;
ch:=lowcase(c[1]);
exit(c[1]);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Apertura_Bin():boolean;  //  update ver 1.84
var Buffer: array [1..4*1024] of Char;
    NumRead{quantita' di caratteri letti},filehandle,i:Longint;
    risposta,c:char; // c:  =p==Pausa  =c==Continua  =a==Annulla  =t==annulla Tutti
    pausa:boolean;
begin
c:='p';
pausa:=false;
max_righe:=next_max_righe_esa-2;
setlength(testo,max_righe+2);
Apertura_Bin:=false;
IOF:=true;

textcolor(white);
textbackground(blue);
gotoxy(1,riga_menu+2);
clreol;
{$ifdef TxtCrt}
gotoxy(40-Lingue.get_length_txt(433) div 2,riga_menu+2);
write(Lingue.get_txt(433));  // ' Caricamento file in corso ...'
{$endif}
{$ifdef TxtVideo}
setcursorPos(0,riga_menu);
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
TxtClreol;
outtextxy(39-Lingue.get_length_txt(433) div 2,riga_menu+1,Lingue.get_txt(433),0,blue,white);  // ' Caricamento file in corso ...'
updatescreen(false);
{$endif}
ShowMouse;
iy:=1;
ymax:=1;
normale;
testo[1]:=#13;
Init;
{$ifdef TxtCrt}
gotoxy(1,1);
for i:=1 to (riga_menu-1) do write('                                                                               '+invio);
{$endif}
{$ifdef TxtVideo}
WindowsStr(0,0,78,riga_menu-2,' ',(max_larghezza-1)*(riga_menu-1));
{$endif}
cursoroff;
filehandle:=FileOpen(percorso+nomefile,fmOpenRead);
if filehandle<0 then
    begin
    hidemouse;
    colore;
    gotoxy(1,riga_menu+1);
    writeln(Lingue.get_txt(434)); // '  Impossibile aprire il file. Riprovare impostando Editor in formato testo, o '
    writeln(Lingue.get_txt(435)); // '  assicurarsi che l''unita'' non sia protetta, che il file non abbia l''attributo'
    write  (Lingue.get_txt(436)); // '  di sola lettura (R) , che non sia piu'' presente o gia'' in uso.                   '
    showmouse;
    showmouse;
    if ins then CursorBig else CursorOn;
    Esc;
    Nuovo_Comune;
    tot:=0;
    Annulla_Txt.Destroy;
    Annulla_esa.destroy;
    Annulla_Selezione.Destroy;
    Ripristina_Txt.Destroy;       // ver 3.15
    Ripristina_Selezione.Destroy; // ver 3.15
    salvato:=nil; // cioe' salvato:=Annulla[numfile].l;
    file_size_byte:=0;
    Azzera_Selezione;
    IOF:=false;
    Exit;
    end
   else file_size_byte:=exist(percorso+nomefile);
gotoxy(1,1);
modifica:=false;
hideMouse;

if FileSeek(filehandle,tot,0)<0 then IOF:=false else
begin
Tasti_Carica_Files(21,riga_menu+3,'P',pausa);  // ver 2.89
repeat
 risposta:=Tasti_caricamento(21,riga_menu+3,pausa,c);
 case risposta of  // ver 2.89
      'C' : if pausa then
               begin
               pausa:=false;
               Tasti_Carica_Files(21,riga_menu+3,'P',pausa);  // ver 2.89
               end;
      'P' : if not pausa then
               begin
               pausa:=true;
               Tasti_Carica_Files(21,riga_menu+3,'P',pausa);  // ver 2.89
               Continue;
               end;
      'A','T' :
            begin;
            FileClose(filehandle);
            if risposta='T' then
                             begin
                             files_da_terminale.destroy;
                             while Editor_Ini.Estrai_File_Aperti()<>'' do;
                             end
                            else ;
            IOF:=false;
            exit(false);
            end;
      end;
 if pausa then Continue;
 NumRead:=FileRead(filehandle,Buffer,SizeOf(Buffer));
 if NumRead<0 then
              begin
              IOF:=false;
              break;
              end;
 for i:=1 to numread do
     if iy<=MaxR() then        {per non fare cicli inutili}
        begin
        testo[iy]:=testo[iy]+buffer[i];
        if (length(testo[iy])=lunghezza_riga+1)and(iy<=MaxR() ) then
                            begin
                            inc(iy);
                            if iy=MaxR()+1 then
                               begin
                               iy:=MaxR();
                               Break;
                               end;
                            testo[iy]:=#13;
                            end;
        end;
 Tast_Vuota;
 if iy>=maxR() then
    begin
    iy:=maxR();
    Break;
    end;
until (NumRead = 0);
end;

showMouse;
if length(testo[MaxR])>lunghezza_riga+1 then setlength(testo[MaxR],lunghezza_riga+1);
FileClose(filehandle);
if (tot=0) then // ver 2.20
   if copy(testo[1],1,2)=intestazione_B then apri_formato:='B' else
   if copy(testo[1],1,2)=intestazione_L then apri_formato:='L' else
   if copy(testo[1],1,3)=intestazione_UTF then apri_formato:='U';
if apri_formato in ['B','L','U'] then apertura_bin:=false;
if ins then CursorBig else CursorOn;
if iy>MaxR then iy:=MaxR;
ymax:=iy;
while (testo[ymax]=#13)and(ymax>1) do dec(ymax);
init;
iy:=1;
y:=1;
Apertura_Bin:=chk_Apertura_Bin; // ver 2.52
Set_Cursore_X(1);
{$ifdef TxtVideo}
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
setcursorPos(0,riga_menu+1);
TxtClreol;
setcursorPos(0,riga_menu+2);
TxtClreol;
{$endif}

evidenzia_selezione;
if IOF then
        begin
        textbackground(blue);
        gotoxy(1,riga_menu+2);
        clreol;                   // toglie: "Caricamento file in corso ..."
        gotoxy(1,riga_menu+3);
        clreol;                   // toglie: "Caricamento file in corso ..."
        un_bak:=true;
        end
       else Open_Error3;
Annulla_Txt.Destroy;
Annulla_Esa.Destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
salvato:=nil;
Azzera_Selezione;
binario:=true;
ins:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Apertura_Txt():boolean;           // update ver 1.85 , 2.20
var gia_letti,carattere,i:integer;
    risposta,c,ch:char;
    pausa,riga_troppo_lunga,a_capo,IO_error,non_di_testo,mem_esaurita:boolean;
    buffer:string;
    filex: file of char;
begin
pausa:=false;
ch:='p';
max_righe:=next_max_righe_txt-2;
setlength(testo,max_righe+2);
riga_troppo_lunga:=false;
a_capo:=false;
IO_error:=false;
non_di_testo:=false;
mem_esaurita:=false;
buffer:='';
Apertura_txt:=true;
iy:=1;
ymax:=1;
modifica:=false;
testo[1]:=#13;
init;
colore;
gotoxy(1,riga_menu+3);
clreol;
{$ifdef TxtCrt}
gotoxy(40-Lingue.get_length_txt(433) div 2,riga_menu+2);
write(Lingue.get_txt(433));  // ' Caricamento file in corso ...'
{$endif}
{$ifdef TxtVideo}
setcursorPos(0,riga_menu);
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
TxtClreol;
outtextxy(39-Lingue.get_length_txt(433) div 2,riga_menu+1,Lingue.get_txt(433),0,blue,white);  // ' Caricamento file in corso ...'
updatescreen(false);
{$endif}
ShowMouse;
ShowMouse;
ShowMouse;
normale;
hideMouse;
apri_formato:='T'; // ver 2.20
filemode:=0;
assign(filex,percorso+nomefile);
{$i-}
reset(filex);
{$i+}
if IOResult<>0
   then IO_error:=true
   else
    begin
    file_size_byte:=max(exist(percorso+nomefile),0);
    buffer:='';    // determinazione del tipo di formato testo
    Tasti_Carica_Files(21,riga_menu+3,'P',pausa);
    for carattere:=1 to min(3,file_size_byte) do
        begin
        {$i-}
        read(filex,c);
        {$i+}
        if ioresult<>0 then
           begin
           modifica:=true;
           IO_error:=true;
           break;
           end;
        buffer:=buffer+c;
        if copy(buffer,1,2)=intestazione_B then
           begin
           apri_formato:='B';
           gia_letti:=2;
           break;
           end;
        if copy(buffer,1,2)=intestazione_L then
           begin
           apri_formato:='L';
           gia_letti:=2;
           break;
           end;
        if copy(buffer,1,3)=intestazione_UTF then
           begin
           apri_formato:='U';
           gia_letti:=3;
           end;
        end;
    if apri_formato='T' then
                        begin
                        gia_letti:=0;
                        {$i-}
                        seek(filex,gia_letti);
                        {$i+}
                        if ioresult<>0 then
                           begin
                           modifica:=true;
                           IO_error:=true;
                           end;
                        end;
    salva_formato:=apri_formato;
    while gia_letti<file_size_byte do
        begin
        if iy>maxR then
                    begin
                    modifica:=true;
                    mem_esaurita:=true;
                    break;
                    end;
        if apri_formato in ['U','T'] then  // UTF, TXT
           begin
           {$i-}
           read(filex,c);
           {$i+}
           if IOResult<>0 then
                          begin
                          modifica:=true;
                          IO_error:=true;
                          break;
                          end;
           inc(gia_letti);
           buffer:=c;
           end;
        if apri_formato in ['B','L'] then  // Unicode
           begin
           {$i-}
           read(filex,c);
           {$i+}
           if IOResult<>0 then
                          begin
                          modifica:=true;
                          IO_error:=true;
                          break;
                          end;
           inc(gia_letti);
           buffer:=c;
           {$i-}
           read(filex,c);
           {$i+}
           if IOResult<>0 then
                          begin
                          modifica:=true;
                          IO_error:=true;
                          break;
                          end;
           inc(gia_letti);
           buffer:=buffer+c; // catturo i 16 bit e poi ne estraggo solo 8
           if buffer[1]=#0 then buffer:=buffer[2]
                           else buffer:=buffer[1];
           end;
        if buffer=#9 then
           begin
           buffer:='';
           for i:=1 to tab_num do buffer:=buffer+' '; // simulo TAB
           end;
        if buffer=#13 then
           begin
           buffer:='';
           continue;
           end;
        if (buffer<>#10)and(buffer<>#13) and (length(testo[iy])>=lunghezza_riga+1) then riga_troppo_lunga:=true;
        if (buffer=#10) or (length(testo[iy])=lunghezza_riga+1) then
           begin
           if (buffer=#10) and a_capo then
                    begin
                    a_capo:=false;
                    buffer:='';
                    continue;
                    end;
           if iy=maxR then
                 begin
                 modifica:=true;
                 mem_esaurita:=true;
                 break;
                 end;
           inc(iy);
           if mem_automatica and (iy>length(testo)-2) then setlength(testo,length(testo)*2); // ver 2.88
           if (length(testo[iy])=lunghezza_riga) then a_capo:=true;
           testo[iy]:=#13;
           if (buffer=#10)or(buffer=#13) then buffer:='';
           end;
        while buffer<>'' do
           begin
           c:=buffer[1];
           buffer:=copy_end(buffer,2);
           if ord(c) in not_text then
              begin
              modifica:=true;
              non_di_testo:=true;
              continue;
              end;
           if (length(testo[iy])=lunghezza_riga+1) then
              begin
              inc(iy);
              testo[iy]:=#13;
              end;
           if (iy=maxR) and (length(testo[iy])=lunghezza_riga) and (buffer<>'') then
              begin
              modifica:=true;
              mem_esaurita:=true;
              break;
              end;
           testo[iy]:=testo[iy]+c;
           end;  // while del buffer
        repeat
         risposta:=Tasti_caricamento(21,riga_menu+3,pausa,ch);
         case risposta of  // ver 2.89
              'C' : if pausa then
                       begin
                       pausa:=false;
                       Tasti_Carica_Files(21,riga_menu+3,'P',pausa);  // ver 2.89
                       end;
              'P' : if not pausa then
                       begin
                       pausa:=true;
                       Tasti_Carica_Files(21,riga_menu+3,'P',pausa);  // ver 2.89
                       Continue;
                       end;
              'A','T' :
                    begin
                    {$i-}
                    close(filex);
                    {$i+}
                    if IOResult<>0 then;
                    if risposta='T' then
                             begin
                             files_da_terminale.destroy;
                             while Editor_Ini.Estrai_File_Aperti()<>'' do;
                             end
                            else ;
                    IOF:=false;
                    exit(false);
                    end;
              end;
        until not pausa;
        end;     // while della lettura del file
    end; // apertura file avvenuta correttamente
showMouse;
{$i-}
close(filex);
{$i+}
if IOResult<>0 then;
if not IO_error then
        begin
        textbackground(blue);
        gotoxy(1,riga_menu+3);
        clreol;                   // toglie: "Caricamento file in corso ..."
        end;
if mem_esaurita then Open_error1;
if non_di_testo then Apertura_txt:=false;
if IO_error then Open_error3;
IOF:=not IO_error;
if riga_troppo_lunga then Open_error6;
ymax:=iy;
iy:=1;
y:=1;
Set_Cursore_X(1);
init;
Azzera_Selezione;
evidenzia_selezione;
Annulla_Txt.Destroy;
Annulla_esa.destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
salvato:=nil; // cioe' salvato:=Annulla[numfile].l;
{$ifdef TxtVideo}
updateScreen(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Select4(k:char;x1,y1:byte); // ver 2.52
begin
{$ifdef TxtCrt}
colore;
HideMouse;
case K of
 'n' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+17,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write('[');
       gotoxy(x1+10,y1);
       write(']');
       gotoxy(x1+18,y1);
       write(' ');
       gotoxy(x1+34,y1);
       write(' ');
       end;
 's' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+17,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write('[');
       gotoxy(x1+4,y1);
       write(']');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x1+18,y1);
       write(' ');
       gotoxy(x1+34,y1);
       write(' ');
       end;
 'a' : begin
       gotoxy(x1+11,y1);
       write('[');
       gotoxy(x1+17,y1);
       write(']');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x1+18,y1);
       write(' ');
       gotoxy(x1+34,y1);
       write(' ');
       end;
 't' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+17,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x1+18,y1);
       write('[');
       gotoxy(x1+34,y1);
       write(']');
       end;
 end; {case}
gotoxy(x,y);
ShowMouse;
{$endif}
{$ifdef TxtVideo}
dec(x1);
dec(y1);
case K of
 'n' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+17,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,'[',255,blue,white);
       outtextxy(x1+10,y1,']',255,blue,white);
       outtextxy(x1+18,y1,' ',255,blue,white);
       outtextxy(x1+34,y1,' ',255,blue,white);
       end;
 's' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+17,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,'[',255,blue,white);
       outtextxy(x1+4,y1,']',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       outtextxy(x1+18,y1,' ',255,blue,white);
       outtextxy(x1+34,y1,' ',255,blue,white);
       end;
 'a' : begin
       outtextxy(x1+11,y1,'[',255,blue,white);
       outtextxy(x1+17,y1,']',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       outtextxy(x1+18,y1,' ',255,blue,white);
       outtextxy(x1+34,y1,' ',255,blue,white);
       end;
 't' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+17,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       outtextxy(x1+18,y1,'[',255,blue,white);
       outtextxy(x1+34,y1,']',255,blue,white);
       end;
 end; {case}
gotoxy(x,y);
updatescreen(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasti_SNAT(x1,y1:byte):char; // ver 2.52
var old_c,c:string;
    cliccato:boolean;
label tab;
begin
HideMouse;
{$ifdef TxtCrt}
textcolor(red);
textbackground(7);
gotoxy(x1,y1);
write(Lingue.get_txt(437)+Lingue.get_txt(438)+Lingue.get_txt(432));    // '<Si>  <No>  <esc>  <annulla Tutti>'
{$endif}
{$ifdef TxtVideo}
outtextxy(x1-1,y1-1,Lingue.get_txt(437)+Lingue.get_txt(438)+Lingue.get_txt(432),255,7,red);  //  '<Si>  <No>  <esc>  <annulla Tutti>'
{$endif}
colore;
gotoxy(x1+4,y1);
write('  ');
gotoxy(x1+10,y1);    {il mouse puo' cliccare su SI,NO,ESC,ANNULLA TUTTI}
write('  ');               {oppure premendo i tasti S,N,Esc,T}
Select4('a',x1,y1);
sonoro;
ShowMouse;
tast_vuota;
c:='a';  {annulla (ESC) e' predefinito}
ShowMouse;
ShowMouse;
repeat
 if (PollKeyEvent<>0) or (not topo) then
        begin
        old_c:=c;
        c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
        if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
        if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
        if length(c)=1 then c:=upcase(c);
        if (c=Lingue.get_charUP(437)) then c:='S' else
        if (c=Lingue.get_charUP(438)) then c:='N' else
        if (c=Lingue.get_charUP(432)) then c:='T';
        if (c='N')or(c='T')or(c='S') then else
        if (c='Right')or(c='Down') then goto tab // destra  #77,#80
                                   else
        if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then  //  sinistra  #72,#75 shift+tab
                         begin
                         if length(old_c)=1 then
                                  begin
                                  case old_c[1] of
                                       's' : c:='t';
                                       'n' : c:='s';
                                       'a' : c:='n';
                                       't' : c:='a';
                                       end;
                                  old_c:=c;
                                  Select4(c[1],x1,y1);
                                  end;
                         end else
        if (c=#27) then c:='A' else
        if (c=#13)or(c=#32) then c:=upcase(old_c) else
        if (c=#9) then
                   begin
                   tab:
                   if length(old_c)=1 then
                                  begin
                                  case old_c[1] of
                                       's' : c:='n';
                                       'n' : c:='a';
                                       'a' : c:='t';
                                       't' : c:='s';
                                       end;
                                  Select4(c[1],x1,y1);
                                  end;
                   end
                  else
                   c:=old_c;
        end
       else // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=y1) then
            begin
            if (mox>x1-1)  and (mox<4+x1)  then c:='S';
            if (mox>5+x1)  and (mox<10+x1) then c:='N';
            if (mox>11+x1) and (mox<17+x1) then c:='A';
            if (mox>18+x1) and (mox<33+x1) then c:='T';
            end;
        end;
until (c='S')or(c='N')or(c='A')or(c='T');
Tasti_SNAT:=c[1];
{$ifdef TxtVideo}
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
setcursorpos(0,y1-1);
TxtClreol;        // copre la risposta SNAT   update 2.52
{$endif}
gotoxy(1,y1);
clreol;           // copre la risposta SNAT   update 2.52
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function open_ASK4(nomefile:string):char;  // ver 1.82    update 2.00 , 2.52
begin
open_ASK_comune(nomefile);
exit(Tasti_SNAT(32,riga_menu+3));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Definisci_Tipo(var estensione_conosciuta:boolean):char; // dice se aprire il file in esa o txt  *** ver 1.50 , update 2.52
var nomefilex:shortstring;
    estensione:string; // senza punto  // deve tornare SNAT
    a:byte;
    posC,posT,posE:longint;
    risposta,est_nota:char;
label richiesta;

begin
Definisci_Tipo:='S';
nomefilex:=percorso+nomefile;
GetLongName(nomefilex);   { ver 1.80 }
a:=posRL('.',nomefilex,255);
if a=0 then estensione:=''
       else estensione:=UpCase(Copy_end(nomefilex,a+1));
posE:=posizione(Estensioni.l,stringtopchar('E'+estensione));  // ESA
posT:=posizione(Estensioni.l,stringtopchar('T'+estensione));  // TXT
posC:=posizione(Estensioni.l,stringtopchar('A'+estensione));  // ASK
estensione_conosciuta:=posE+posC+posT>0;
if estensione_conosciuta then
   begin
   if upcase(est_note)=lingue.get_charUp(137) then
        begin   // 'E'
        binario:=true;
        definisci_tipo:='S';
        end else
   if upcase(est_note)=lingue.get_charUp(138) then
        begin   // 'T'
        binario:=false;
        definisci_tipo:='N';
        end else
   if upcase(est_note)=lingue.get_charUp(139) then
        goto richiesta else  // 'C'
   if upcase(est_note)=lingue.get_charUp(140) then
        begin   // 'P'       // predefinito
        if posE=0 then posE:=MaxLongint;
        if posT=0 then posT:=MaxLongint;
        if posC=0 then posC:=MaxLongint;
        est_nota:='E';
        if posE>posC then
                 begin
                 est_nota:='C';
                 posE:=posC;
                 end;
        if posE>posT then est_nota:='T';
              case est_nota of
                   'E' : begin
                         binario:=true;
                         definisci_tipo:='S';
                         end;
                   'T' : begin
                         binario:=false;
                         definisci_tipo:='N';
                         end;
                   'C' : goto richiesta;
                   end;
        end;
   end
  else  {estensione non conosciuta}
   begin
   if upcase(est_non_note)=lingue.get_charUp(142) then
        begin  // 'A'
        binario:=true;     // apro in ASCII
        definisci_tipo:='S';
        end else
   if upcase(est_non_note)=lingue.get_charUp(143) then
        begin  // 'X'
        binario:=false;    // apro in TXT
        definisci_tipo:='N';
        end else
   if upcase(est_non_note)=lingue.get_charUp(144) then
        begin  // '/'
        richiesta:         // apro ASK chiedendo
        if forza_apertura<>0 then  // cioe' file non richiamato da terminale
                    begin
                    risposta:=open_ASK(nomefilex);
                    definisci_tipo:=risposta;
                    case risposta of  // apro chiedendo
                       'S' : begin
                             binario:=true;
                             definisci_tipo:='S';
                             end;
                       'N' : begin
                             binario:=false;
                             definisci_tipo:='N';
                             end;
                       'A' : definisci_tipo:='A';
                       end;
                    end
                  else  // file richiesto da terminale
                    begin
                    risposta:=open_ASK4(nomefilex);
                    definisci_tipo:=risposta;
                    case risposta of
                         'S' : binario:=true;
                         'N' : binario:=false;
                         'A' : ;
                         'T' : ;
                         end;
                    end;
        end;
   end;
ins:=binario;
if ins then CursorBig else CursorOn;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Definisci_Tipo2(const il_file:string):char;  // ver 2.50 , update 2.52
var risposta:char;
begin
Definisci_Tipo2:='S';
case forza_apertura of
     4:  Exit; // gia' fatto la prima volta, non serve piu'
     0:  ; // forzatura non richiesta da terminale
     1:  binario:=false; // richiesto formato forzato in TXT
     2:  binario:=true;  // richiesto formato forzato in Esa
     3:  begin
         risposta:=open_ASK4(il_file);
         definisci_tipo2:=risposta;
         case risposta of
                   'S' : binario:=true;
                   'N' : binario:=false;
                   'A' : ;
                   'T' : ;
                   end;
         end;
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Assegna_Estensione;  // ver 2.84
var estensione,tipo:shortstring;
    a:integer;
begin
if binario then tipo:=Lingue.get_txt(286)   //  'Esadecimale'
           else tipo:=Lingue.get_txt(278);  //  'Testo'
a:=posRL('.',nomefile,255);
if a=0 then estensione:=''
       else estensione:=UpCase(Copy_end(nomefile,a+1));
colore;
gotoxy(1,riga_menu+4);
clreol;
gotoxy(1,riga_menu+5);
clreol;
pulisci1;
gotoxy(1,riga_menu+1);
writeln(Lingue.get_txt(439),estensione,Lingue.get_txt(440),tipo,' ?');  // 'Associare l''estensione "'   '" al formato '
{$ifdef TxtVideo}
setcursorPos(0,riga_menu+2);
TxtClreol;
setcursorPos(0,riga_menu+1);
TxtClreol;
setcursorPos(0,riga_menu);
TxtClreol;
outtextxy(0,riga_menu,Lingue.get_txt(439)+estensione+Lingue.get_txt(440)+tipo+' ?',255,blue,white);
Updatescreen(true);
{$endif}
if Tasti_SN(35,riga_menu+3)='N' then Exit;
// rimozione per evitare duplicati
while Estensioni.cerca_e_cancella(strnew(stringtopchar('T'+estensione)),1)<>-1 do ; // ritorna la posizione dove era
while Estensioni.cerca_e_cancella(strnew(stringtopchar('E'+estensione)),1)<>-1 do ;
while Estensioni.cerca_e_cancella(strnew(stringtopchar('A'+estensione)),1)<>-1 do ;
Editor_Ini.Set_Modifica(true);
if binario then Estensioni.input_iniziale(strnew(stringtopchar('E'+estensione)))
           else Estensioni.input_iniziale(strnew(stringtopchar('T'+estensione)));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function M_file__Apri(nomefilex:string; lunghezza_riga_:longint; tot_:int64; forza_binario:longint):char; // Si,No,Annulla,annulla Tutti,Errore  // update 2.00 , 2.40 , 2.52 , 3.20
var c:char;                                   // tot= byte a cui punta
    nomefile_originale:string;
    estensione_conosciuta,lunghezza_riga_sconosciuta:boolean;
    old_posizione_file_attuale:longint; // ver 2.74
label forzatura_binario_recenti,riapri;

begin
M_file__Apri:='S';
nomefile_originale:=nomefilex;
riapri:
colore;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+1);
clreol;
ShowMouse;
if nomefilex='' then
                begin
                ingresso(nomefilex,Lingue.get_txt(441));  //  'Apri file'
                lunghezza_riga_sconosciuta:=true;
                end
               else lunghezza_riga_sconosciuta:=false;
if nomefilex='' then Exit('A');
if Exist(nomefilex)<0 then // file non trovato
        begin
        Non_Trovato(nomefilex);
        c:=Tasti_SN(35,riga_menu+3);
        if c='N' then Exit('A') // annulla
                 else       // c='S' : riprova a riaprire
                  begin
                  Grafica;
                  Info;
                  if nomefile_originale='' then nomefilex:='';
                  goto riapri;
                  end;
        end;
if not salva_multi_file(posizione_file_attuale) then
   begin
   Error_Multi_Files;
   exit('E');
   end;
Nuovo_Comune;
nomefile:=nomefilex;
percorso:=PathOf(nomefile);
nomefile:=NameOf(nomefile);
tot:=tot_;
grafica;

if forza_binario>0 then goto forzatura_binario_recenti;
c:=#0;
if forza_apertura in [0,4] then
   begin
   c:=Definisci_Tipo(estensione_conosciuta); // S N A
   if not (c in ['S','N']) then
      begin
      ricarica_multi_file(posizione_file_attuale);
      Exit(c);
      end;
   end;
c:=Definisci_Tipo2(nomefilex);
if c in ['A','T'] then
   begin
   ricarica_multi_file(posizione_file_attuale);
   Exit(c);   // eseguito solo all'avvio
   end;
forzatura_binario_recenti:

old_posizione_file_attuale:=posizione_file_attuale;
posizione_file_attuale:=get_numero_files;    // ver 2.61
setlength(multi_file,length(multi_file)+1);  // ver 2.61
case forza_binario of
     0: if binario then lunghezza_riga_:=next_length_ESA  // non e' recenti/visualizza
                   else lunghezza_riga_:=next_length_TXT;
     1: binario:=true;   // e' recenti/visualizza
     2: binario:=false;  // e' recenti/visualizza
     end;
if lunghezza_riga_sconosciuta then
                               if binario then lunghezza_riga:=next_length_ESA
                                          else lunghezza_riga:=next_length_TXT
                              else lunghezza_riga:=lunghezza_riga_;
if lunghezza_riga_forzata>0 then lunghezza_riga:=lunghezza_riga_forzata;
if binario then // sono rimossi le seguenti istruzioni, perche' presenti in apertura_txt/esa: Annulla_Txt/Esa/Selezione.destroy;
            if not Apertura_Bin() then  // update ver 2.74
                                   if IOF then Autodetect_file
                                          else
                                           begin
                                           posizione_file_attuale:=old_posizione_file_attuale;
                                           setlength(multi_file,length(multi_file)-1);
                                           ricarica_multi_file(posizione_file_attuale);
                                           Exit('E');
                                           end
                                  else
                                  begin
                                  skip;
                                  end
           else
            if not Apertura_Txt() then
                                   if IOF then Autodetect_file
                                          else
                                           begin
                                           posizione_file_attuale:=old_posizione_file_attuale;
                                           setlength(multi_file,length(multi_file)-1);
                                           ricarica_multi_file(posizione_file_attuale);
                                           Exit('E');
                                           end;
attributi_del_file:=Attr(nomefilex);  // ver 2.52
SL:=(pos('R',attributi_del_file)<>0); // ver 2.52
salva_multi_file(posizione_file_attuale,false);
if not estensione_conosciuta then Assegna_Estensione; // ver 2.84
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Svuota_Appunti; // ver 3.30
var i:integer;
begin
for i:=0 to length(appunti)-1 do Appunti[i].destroy;
setlength(Appunti,0);
appunti_usato:=-1;
stato_appunti.nuovo_stato_appunti(0);  // ver 2.53
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function M_opzioni__Memoria(b:boolean):char;    // ver 1.80 , update 2.40, 3.11
var i:longint;
    c:char;
begin
hidemouse;
pulisci1;
if b then
      begin
      gotoxy(40-Lingue.get_length_txt(442) div 2,riga_menu+2);
      write(Lingue.get_txt(442)) // 'Svuotare gli Appunti, l'' Annulla e Ripristina di tutti i files ?'
      end
     else
      begin
      gotoxy(40-Lingue.get_length_txt(443) div 2,riga_menu+2);
      write(Lingue.get_txt(443)); // 'Riavviare il programma con la configurazione predefinita ?'
      end;
showmouse;
c:=Tasti_SN(35,riga_menu+3);
if c='S' then
   begin
   Svuota_Appunti;
   Annulla_Txt.Destroy;
   annulla_esa.destroy;
   Annulla_Selezione.Destroy;
   Ripristina_Txt.Destroy;
   for i:=1 to get_numero_files do
       begin
       multi_file[i].Annulla_Txt.destroy;
       multi_file[i].Annulla_Esa.destroy;
       multi_file[i].Annulla_Selezione.destroy;   // ver 3.15
       multi_file[i].Ripristina_Txt.Destroy;      // ver 3.15
       end;
   if sono_Appunti() then M_File__Chiudi; // ver 3.28
   end;
M_opzioni__Memoria:=c;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Mess_Err_Salva_Configurazione; // ver 2.68
begin
pulisci1;
hidemouse;
gotoxy(40-Lingue.get_length_txt(444) div 2,riga_menu+2);
write(Lingue.get_txt(444)); // 'Errore durante l''operazione di salvataggio della configurazione'
showmouse;
showmouse;
Esc;
gotoxy(1,riga_menu+2);
write('                                                                       ');
gotoxy(1,riga_menu+4);
write('                                                                    ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Salva_Configurazione;          // ver 2.68
begin
if not editor_Ini.Salva_Ora(estensioni) then Mess_Err_Salva_Configurazione; // update 2.75
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Salva_Configurazione_In;       // ver 2.68
var nuova_configurazione,the_files:string;
label inizio;
begin
the_files:='*.ini';
inizio:
nuova_configurazione:=SfogliaFile(15,2,true,true,topo,mancino,Lingue.get_txt(445),percorso,the_files,ClickDelay,ScreenHeight-4,
         Lingue.get_txt(531){nome},Lingue.get_txt(532){lista},Lingue.get_txt(533){elementi},
         Lingue.get_txt(293){data},Lingue.get_txt(294){ora},Lingue.get_txt(291){attributi},Lingue.get_txt(534),Lingue.get_char(531),Lingue.get_char(532));  // 'Salva configurazione in ...'
Evidenzia_Selezione;
if nuova_configurazione='' then Exit;
if Exist(nuova_configurazione)>0 then   // sovrascrivere ?
   begin
   Grafica;
   Sovrascrivere(nuova_configurazione);
   case Tasti_SNA(31,riga_menu+4) of
        'S': ;
        'N': begin
             Info;
             goto inizio;
             end;
        'A': Exit;
        end;
   end;
if not editor_Ini.Salva_Ora(nuova_configurazione,estensioni) then Mess_Err_Salva_Configurazione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Autodetect_File;   //  ver 1.84  update 2.50
begin
if not autodetect then Exit;
hidemouse;
pulisci1;
gotoxy(1,riga_menu+4);
clreol;
if not binario then
         begin
         gotoxy(40-Lingue.get_length_txt(446) div 2,riga_menu+1);
         writeln(Lingue.get_txt(446)+invio); // 'AUTODETECT: il file appena aperto e'' di tipo esadecimale, e non di testo.'
         gotoxy(33-Lingue.get_length_txt(447),whereY);
         write(Lingue.get_txt(447));     // 'Riaprirlo in esadecimale ?'
         end
       else
         begin
         gotoxy(40-Lingue.get_length_txt(448) div 2,riga_menu+1);
         writeln(Lingue.get_txt(448)+invio); // 'AUTODETECT: il file appena aperto e'' di tipo testo, e non esadecimale.'
         gotoxy(33-Lingue.get_length_txt(449),whereY);
         write(Lingue.get_txt(449));     // 'Riaprirlo nel formato testo ?'
         end;
showmouse;
if Tasti_SN(35,riga_menu+3)='N' then Exit;
pulisci1;
binario:=not binario;
if binario then Apertura_Bin   {assign all'interno delle 2 proc}
           else Apertura_Txt;
Evidenzia_Selezione;
ins:=binario;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function caricato(nomefile:string):boolean;  // ver 2.85
var i:longint;
begin
caricato:=false;
for i:=1 to length(multi_file)-1 do
    if nomefile=multi_file[i].percorso+multi_file[i].nomefile then Exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure multi_terminale;  // ver 2.50 ,  update 2.52
var  DirInfo: SearchRec;
     file_da_prompt,apri_questo_file,percorso2:string;
     trovati:boolean;
     apro_SNA:char;
begin
while files_da_terminale.numElementi>0 do
      begin
      file_da_prompt:=files_da_terminale.Estrai_iniziale;
      If NameReserved(file_da_prompt) then
         begin
         showMouse;
         showMouse;
         pulisci1;
         InvalidName;
         Continue;
         end;
      file_da_prompt:=FExpand2(file_da_prompt);
      if isDir(file_da_prompt) then
         begin
         if copy(file_da_prompt,length(file_da_prompt),1)<>pathdelim then file_da_prompt:=file_da_prompt+pathdelim;
         file_da_prompt:=file_da_prompt+{$ifdef Linux}'*'{$else}'*.*'{$endif};
         end;
      percorso2:=pathOf(file_da_prompt);
      Dos.FindFirst(file_da_prompt, ReadOnly + Archive + SysFile + Hidden + AnyFile, DirInfo);
      trovati:=false;
      while (DosError=0) or (not trovati) do
            begin
            trovati:=true;
            if dosError<>0 then apri_questo_file:=file_da_prompt
                           else apri_questo_file:=percorso2+DirInfo.Name;
            if apri_file_caricati or (not caricato(apri_questo_file)) then
               begin
               apro_SNA:=M_file__Apri(apri_questo_file,lunghezza_riga_forzata,0,0); // tot + bin
               if apro_SNA='T' then  //  annulla Tutti 2.52 ***
                  begin
                  files_da_terminale.destroy; // annulla pure i file successivi da aprire
                  break;
                  end;
               end;
            Dos.FindNext(DirInfo);
            end;
      end; // del while
Aggiorna_Campi_Menu;
forza_apertura:=4;
lunghezza_riga_forzata:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function M_file__chiudi():boolean;   // ver 2.40, torna FALSE se non chiude
var old_percorso,old_nomefile:string;
    precedente_posizione_file_attuale:longint;
begin
old_percorso:=percorso;
old_nomefile:=nomefile;
M_file__chiudi:=true;
if (nomefile='') and (not modifica) and testo_vuoto and (num_file_aperti<=1)
   then Exit(false); // mai e' di fatto num_file_aperti=0

if modifica then
   begin
   pulisci1;
   gotoxy(1,riga_menu+1);
   write(Lingue.get_txt(450));  //  'Chiusura del testo.'
   ShowMouse;
   save_ask;
   case Tasti_SNA(32,riga_menu+3) of
        'S': if Free then
                     begin
                     if nomefile='' then Salva_Con_Nome(0)
                                    else
                                    if SL then
                                        begin
                                        SL_Error;  // ver 2.52
                                        Exit(false);
                                        end
                                       else Salva;
                     if nomefile='' then Exit(false); // salvataggio annullato, che annulla chiudi
                     if IOF=false then
                        begin
                        attrib;
                        percorso:=old_percorso;
                        nomefile:=old_nomefile;
                        Exit(false); // salvataggio fallito
                        end;
                     end
                    else
                     begin
                     Hd_Low;
                     Exit(false);    // salvataggio fallito
                     end;
        'N': begin   // si perde il salvataggio in multi_file e cio' che non e' salvato
             Annulla_Txt.Destroy;
             Annulla_esa.destroy;
             Annulla_Selezione.Destroy;
             Ripristina_Txt.Destroy;       // ver 3.15
             Ripristina_Selezione.Destroy; // ver 3.15
             end;
        'A': begin
             {$ifdef TxtVideo}
             ForceUpdateXY(0,0,ScreenWidth*(riga_menu-1));
             {$else}
             pulisci1;
             ListaX.mostra;
             {$endif}
             Exit(false);  // l'utente sceglie di non chiudere il file non salvato
             end;
        end;
   end;
Ripristina_Txt.Destroy;
Ripristina_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
chiudi_multi_file(posizione_file_attuale);
salvato:=nil;
Nuovo_Comune;
precedente_posizione_file_attuale:=posizione_file_attuale;
posizione_file_attuale:=get_numero_file_precedente_aperto(posizione_file_attuale);
if posizione_file_attuale>0 then
      begin
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      end
     else  // tutti i files sono stati chiusi, allora apro quello predefinito (vuoto)
      begin               // crea nouvo file vuoto senza nome
      posizione_file_attuale:=precedente_posizione_file_attuale;
      inserisci_file_dopo(posizione_file_attuale);
      posizione_file_attuale:=posizione_file_attuale+1;
      tot:=0;  // ver 3.03
      end;
Aggiorna_Campi_Menu;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure mesaggio_salva_copia_o_con_nome(b:byte);  // ver 2.56
var m:shortstring;
begin
case b of
     0: m:=Lingue.get_txt(451); // 'Salva con nome in corso ...'
     1: m:=Lingue.get_txt(452); // 'Salva copia in corso ...'
     2: m:=Lingue.get_txt(453); // 'Salva copia con nome da byte a byte in corso ...'
     3: m:=Lingue.get_txt(454); // 'Salva la selezione con nome in corso ...'
     end;
while length(m)<80 do m:=m+' ';
{$ifdef TxtCrt}
gotoxy(1,riga_menu+1);
write(m);
{$else}
outtextxy(0,riga_menu,m,0,blue,white);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_Con_Nome_mono_file(b:byte);
begin // B=0: Salva con nome  B=1: Salva copia  B=2: Salva copia con nome da byte a byte  B=3 Salva la selezione con nome
Salva_Con_Nome_mono_file(b,-1,-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Mess_path(n:integer); // ver 3.12
begin
pulisci1;
hidemouse;
{$ifdef TxtVideo}
case n of
     1: outtextxy(40-Lingue.get_length_txt(455) div 2,riga_menu+1,Lingue.get_txt(455),255,blue,white); //  'Percorso inesistente. Crearlo ?'
     2: outtextxy(40-Lingue.get_length_txt(456) div 2,riga_menu+1,Lingue.get_txt(456),255,blue,white); //  'Errore nel creare il percorso. Riprovare.'
     end;
{$endif}
{$ifdef TxtCrt}
case n of
     1: begin
        gotoxy(40-Lingue.get_length_txt(455) div 2,riga_menu+2);
        write(Lingue.get_txt(455));  // 'Percorso inesistente. Crearlo ?'
        end;
     2: begin
        gotoxy(40-Lingue.get_length_txt(456) div 2,riga_menu+2);
        write(Lingue.get_txt(456));  // 'Errore nel creare il percorso. Riprovare.'
        end;
     end;
{$endif}
showmouse;
gotoxy(1,riga_menu+4);
write('                                                                    ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_Con_Nome_mono_file(b:byte;start_byte,end_byte:int64);
var nomefilex,app3,nome_f:string;
    c:char;
    un_bak_tmp:boolean;
label inizio,scrittura,r1;
// B=0: Salva con nome  B=1: Salva copia  B=2: Salva copia con nome da byte a byte  B=3 Salva la selezione con nome
begin
inizio:
repeat
 HideMouse;
 colore;
 gotoxy(1,riga_menu+1);
 clreol;
 gotoxy(1,riga_menu+3);
 clreol;
 gotoxy(1,riga_menu+2);
 write('                                                              ');
 nomefilex:='';
 app3:=percorso;
 nome_f:=nomefile;
 ShowMouse;
 case b of
      0: ingresso(nomefilex,Lingue.get_txt(457)); // 'Salva con nome'
      1: ingresso(nomefilex,Lingue.get_txt(458)); // 'Salva copia con nome'
      2: ingresso(nomefilex,Lingue.get_txt(459)); // 'Salva copia con nome da byte a byte'
      3: ingresso(nomefilex,Lingue.get_txt(460)); // 'Salva la selezione con nome'
      end;
 if nomefilex='' then Exit;
 percorso:=PathOf(nomefilex);
 nomefilex:=NameOf(nomefilex);
 exchange(nomefilex,nomefile);
 Grafica;
 exchange(nomefilex,nomefile);
 colore;
 gotoxy(1,riga_menu+1);
 clreol;
 gotoxy(1,riga_menu+2);
 clreol;
 {$ifdef TxtCrt}
 Info;
 {$endif}
 mesaggio_salva_copia_o_con_nome(b);
 assign(filex,percorso+nomefilex);     // pare inutile
 if Exist(percorso+nomefilex)<0 then
      begin
      if not DirectoryExists(percorso) then
         begin
         Mess_path(1);
         case upcase(Tasti_SN(35,riga_menu+3)) of
               'S': if NewDir(percorso)<>0 then
                                           begin
                                           Mess_path(2);
                                           updatescreen(false);
                                           Esc;
                                           updatescreen(not false);
                                           percorso:=app3;
                                           nomefile:=nome_f;
                                           goto inizio;
                                           end;
               'N': begin
                    percorso:=app3;
                    nomefile:=nome_f;
                    goto inizio;
                    end;
               end;
         end;
      scrittura:   // richiamato da:  Sovrascivere? [si]
      if binario then
                 if modifica then
                             begin
                             if nomefile='' then  // update 2.10
                                        begin      // file senza nome, salvato in esadecimale
                                        un_bak_tmp:=un_bak;
                                        un_bak:=false;
                                        nomefile:=nameOf(percorso+nomefilex);
                                        Scrivi;
                                        un_bak:=un_bak_tmp;
                                        if iof=false then nomefile:='';
                                        Exit;
                                        end
                                       else
                                        begin
                                        mesaggio_salva_copia_o_con_nome(b);
                                        Salva_con_Nome_Binario({old}app3+nomefile,{new}percorso+nomefilex);
                                        if IOF then
                                           begin
                                           nomefile:=nomefilex;
                                           un_bak:=false;
                                           scrivi;
                                           end;
                                        end;
                             end
                            else  // modifica=false in esadecimale
                             begin
                             mesaggio_salva_copia_o_con_nome(b);
                             if b=2 then Salva_con_Nome_Binario(app3+nomefile,percorso+nomefilex,start_byte,end_byte);
                             if (b=1)or(b=0) then Salva_con_Nome_Binario(app3+nomefile,percorso+nomefilex);
                             gotoxy(1,riga_menu+3);  // add ver 2.52
                             clreol;                 // add ver 2.52
                             Exit;
                             end
                 else // testo
                  begin
                  nomefile:=nomefilex;
              r1: Scrivi;
                  if not IOF then
                             begin
                             updatescreen(false);
                             if Errore_di_IO(2) then goto r1
                                                     else
                                                      begin
                                                      percorso:=app3;
                                                      nomefile:=nome_f;
                                                      end;
                             end;
                  end;
      assign(filex,percorso+nomefile);  // pare inutile
      end
    else
      begin          // impossibile salvare copia del file su se stesso
      if (b=0)or(b=3) then  // e' copia file con nome o selezione
         if upcase(nomefilex)=upcase(nomefile) then
             begin
             pulisci1;
             {$ifdef TxtVideo}
             updatescreen(true);
             {$endif}
             gotoxy(40-Lingue.get_length_txt(461) div 2,riga_menu+2);
             write(Lingue.get_txt(461));  // 'Impossibile copiare il file su se stesso. Scegliere un nome diverso.'
             gotoxy(33-Lingue.get_length_txt(405),riga_menu+3);
             write(Lingue.get_txt(405)); // 'Riprovare ?'bbb
             gotoxy(1,riga_menu+4);
             write('                                                                 ');
             if Tasti_SN(35,riga_menu+3)='N' then Exit;
             goto inizio;
             end;
      Sovrascrivere(percorso+nomefilex);
      c:=Tasti_SNA(31,riga_menu+4);
      if c='S' then goto scrittura;
      if c='A' then
               begin
               percorso:=app3;
               IOF:=true;
               end;
      if c='N' then
          begin
          percorso:=app3;
          colore;
          gotoxy(1,riga_menu+4);
          write('                                                         ');
          goto inizio; {riprova}
          end;
      end;   {attributi}
gotoxy(1,riga_menu+3);
colore;
clreol;
until (nomefilex<>'')or(c='A');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_Con_Nome(b:byte); //  update ver 2.40 , 2.52
begin
Salva_Con_Nome(b,-1,-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_Con_Nome(b:byte; start_byte,end_byte:int64); // update ver 2.40 , 2.52
var old_nome_file,old_path,old_attributi_del_file:string;
begin // B=0: Salva con nome  B=1: Salva copia  B=2: Salva copia con nome da byte a byte  B=3 Salva la selezione con nome
if (b=0)or(b=3) then
   if not salva_multi_file(posizione_file_attuale) then
      begin
      Error_Multi_Files;
      exit;
      end;
old_nome_file:=nomefile;
old_path:=percorso;
old_attributi_del_file:=attributi_del_file;
attributi_del_file:='____';
Salva_Con_Nome_mono_file(b,start_byte,end_byte); // B=0: Salva con nome  B=1: Salva copia  B=2: Salva copia con nome da byte a byte  B=3 Salva la selezione con nome
// se non e' "salva copia con nome" e se i nomi sono diversi dagli originali e non nulli, allora fa lavoro di multi file
attributi_del_file:=old_attributi_del_file;
if ((b=0)or(b=3)) and (old_path+old_nome_file<>percorso+nomefile) and (nomefile<>'') then
   if not salva_multi_file(posizione_file_attuale) then
      begin
      Error_Multi_Files;
      exit;
      end
     else
      if (b<>0)and(b<>3) then posizione_file_attuale:=posizione_file_attuale+1;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Backup(var err:boolean);  // ver 1.xx
var stringa:string;
    f:file;
begin
err:=false;
if (length(nomefile)>4) and (upcase(copy(nomefile,length(nomefile)-3,255))='.BAK') then Exit;
stringa:=ChangeFileExt(nomefile,'.bak');
{$i-}
close(filex);
{$i+}
if ioresult<>0 then;
if FileExists(percorso+nomefile) then
   begin
   DeleteFile(percorso+stringa); {il file .bak puo' non esistere se e' la prima volta}
   assign(f,percorso+nomefile);
   {$i-}
   Rename(f,percorso+stringa);
   {$i+}
   if IOResult<>0 then err:=true;
   end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function gli_attributi:word; // ver 2.52
var att:word;
begin
att:=0;
if pos('A',attributi_del_file)<>0 then att:=att+archive;
if pos('R',attributi_del_file)<>0 then att:=att+ReadOnly;
if pos('H',attributi_del_file)<>0 then att:=att+Hidden;
if pos('S',attributi_del_file)<>0 then att:=att+SysFile;
gli_attributi:=att;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Scrivi;  // salvataggio su file    ver 1.xx
var j:integer;
    ii:byte;
    bin: file of char;
    err:boolean;
    tot_byte,NumWritten,filehandle: longint;
    Buf : Array [1..{lunghezza_riga}254*810{ymax}] of char;
    nomefile_originale,la_riga_8_bit,s1,s2,s3:string;
label r0,r1;
begin
IOF:=false;           // IOF=false == errori in scrittura
filemode:=1; // per scrivere: serve nel formato testo
if binario then
   begin
   filehandle:=FileOpen(percorso+nomefile,fmOpenWrite);
   if filehandle<0 then
      begin    //se num byte (tot>0) then goto .....
      if tot=0 then
               begin
               filehandle:=FileCreate(percorso+nomefile,fmOpenWrite);
               if filehandle<0 then Exit;
               for j:=1 to ymax do
                   begin
                   if FileWrite(filehandle,copy_end(testo[j],2),length(testo[j])-1)<0 then
                      begin
                      FileClose(filehandle);
                      Exit;
                      end;
                   Tast_Vuota;
                   end;
               end
              else goto r0;
     end
    else     // ancora binario, ma file gia' esistente
     begin
     FileClose(filehandle);
     if un_bak then
               if (upcase(ExtractFileExt(nomefile))='.BAK') or {se e' gia' .bak non posso fare nulla}
                  (punto_bak(percorso+nomefile)='') then {se cambio in .bak ed il nome del file e' troppo lungo non posso fare nulla}
                  else
                  case upcase(ask_crea_bak_esa) of
                    'S': begin
                         nomefile_originale:=nomefile;
                         Salva_con_Nome_Binario(percorso+nomefile,punto_bak(percorso+nomefile));
                         nomefile:=nomefile_originale;
                         if IOF then un_bak:=false  // file .bak salvato correttamente
                                else
                                 begin
                                 IOF:=true; // perche' tutti gli errori sono stati gestiti da Salva_con_Nome_Binario,
                                 Exit;
                                 end;
                         end;
                    'N': ;
                    'A': begin
                         IOF:=true;
                         Exit;
                         end;
                    end;
     filehandle:=FileOpen(percorso+nomefile,fmOpenWrite);
     r0:
     if FileSeek(filehandle,tot,0)<0 then
        if Errore_di_IO(2) then goto r0
                           else
                            begin
                            IOF:=true; // come se fosse tutto OK: messaggio a video di errore gia' mostrato
                            FileClose(filehandle);
                            Exit;
                            end;
     tot_byte:=0;
     for j:=1 to ymax do
         for ii:=2 to length(testo[j]) do
                       begin
                       inc(tot_byte);
                       buf[tot_byte]:=testo[j][ii];
                       end;
     r1:
     NumWritten:=FileWrite(filehandle,buf,tot_byte);
     if NumWritten<0 then
        if Errore_di_IO(2) then goto r1
                           else
                            begin
                            IOF:=true; // come se fosse tutto OK: messaggio a video di errore gia' mostrato
                            FileClose(filehandle);
                            Exit;
                            end;
     if tot_byte<>NumWritten then Exit;
     Tast_Vuota;
     end;
   modifica:=false;
   salvato:=Annulla_Txt.l;
   FileClose(filehandle);
   IOF:=true;
   end
  else  {binario=false    file di testo}
   begin
   if Segnala_Errori and BK then Backup(err); {crea il file .BAK di backup}
   assign(filex,percorso+nomefile);
   {$i-}
   rewrite(filex);
   {$i+}
   if IOResult<>0 then Exit;
   case salva_formato of
        'U': begin
             {$i-}
             write(filex,intestazione_UTF);
             {$i+}
             if ioresult<>0 then;
             end;
        'B': begin
             {$i-}
             write(filex,intestazione_B);
             {$i+}
             if ioresult<>0 then;
             end;
        'L': begin
             {$i-}
             write(filex,intestazione_L);
             {$i+}
             if ioresult<>0 then;
             end;
        end;  //  case
   for j:=1 to ymax do
       begin
       la_riga_8_bit:=sostituisci_tab(copy_end(testo[j],2));
       s1:=copy(la_riga_8_bit,1,100);
       if s1<>'' then
                 begin
                 {$i-}
                 write(filex,prepara_riga_testo(s1));
                 {$i+}
                 if ioresult<>0 then break;
                 end;

       s2:=copy(la_riga_8_bit,101,100);
       if s2<>'' then
                 begin
                 {$i-}
                 write(filex,prepara_riga_testo(s2));
                 {$i+}
                 if ioresult<>0 then break;
                 end;

       s3:=copy_end(la_riga_8_bit,201);
       if s3<>'' then
                 begin
                 {$i-}
                 write(filex,prepara_riga_testo(s3));
                 {$i+}
                 if ioresult<>0 then break;
                 end;

       if j<>ymax then
                  begin
                  {$i-}
                  write(filex,prepara_riga_testo(get_delimitatore()));
                  {$i+}
                  if ioresult<>0 then break;
                  end;
       Tast_Vuota;
       end;
  if IOResult<>0 then
                 begin
                 {$i-}
                 close(bin);
                 {$i+}
                 if IOResult<>0 then ;
                 {$i-}
                 close(filex);
                 {$i+}
                 if IOResult<>0 then Exit;
                 Exit;
                 end;
  salvato:=Annulla_Txt.l;
  {$i-}
  close(filex);
  {$i+}
  if IOResult<>0 then Exit;
  modifica:=false;
  if Segnala_Errori and BK and err then Err_Backup; {deve stare prima della riga successiva}
  IOF:=true;
  end;
SetFAttr(filex,gli_attributi); // ver 2.52
Tast_Vuota;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva;  // ver 1.xx
begin
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(462)); // 'Salvataggio del testo su file.'
ShowMouse;
ShowMouse;
Scrivi;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Chiudi_Tutti;  // update 2.40
label chiusura_tutti;
var old_percorso,old_nomefile:string;
    precedente_posizione_file_attuale:longint;
begin
old_percorso:=percorso;
old_nomefile:=nomefile;
chiusura_tutti:
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(463)); // 'Chiusura di tutti i files.'
chiudi_file_non_modificati;
ShowMouse;
if modifica then
   begin
   save_ask;
   case Tasti_SNA(32,riga_menu+3) of
        'N': modifica:=false; // verra' eseguito dopo: chiudi_multi_file(posizione_file_attuale);
        'A': Exit;
        'S': if Free then
                     begin
                     if nomefile<>'' then
                                      if SL then
                                          begin
                                          SL_Error;  // ver 2.52
                                          Exit;
                                          end
                                         else Salva
                                     else Salva_Con_Nome_mono_file(0);
                     if nomefile='' then Exit; // salvataggio annullato, che annulla esci
                     multi_file[posizione_file_attuale].percorso:=percorso;
                     multi_file[posizione_file_attuale].nomefile:=nomefile;
                     if IOF=false then
                           begin
                           attrib;
                           percorso:=old_percorso;
                           nomefile:=old_nomefile;
                           Exit; // salvataggio fallito
                           end;
                     end
                    else
                     begin
                     Hd_Low;
                     Exit;
                     end;
        end;   // del case
   chiudi_multi_file(posizione_file_attuale);
   end;        // di modifica
Annulla_Txt.Destroy;
Annulla_esa.destroy;
Annulla_Selezione.Destroy; // redo destroy?
salvato:=nil;
Nuovo_Comune;

precedente_posizione_file_attuale:=posizione_file_attuale;
posizione_file_attuale:=get_numero_file_precedente_aperto(posizione_file_attuale);
if posizione_file_attuale>0 then
      begin
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      grafica;
      goto chiusura_tutti;
      end
     else  // tutti i files sono stati chiusi, allora apro quello predefinito (vuoto)
      begin               // crea nouvo file vuoto senza nome
      posizione_file_attuale:=precedente_posizione_file_attuale;
      inserisci_file_dopo(posizione_file_attuale);
      posizione_file_attuale:=posizione_file_attuale+1;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Uscita; // ver 1.xx  ripristino delle impostazioni in uscita e libera memoria
var i:longint;
begin
{$i-}
chdir(start_dir_prompt); // update 2.45
{$i+}
if IOResult<>0 then ;
normale;
cursorOn;
HideMouse;
donevideo;
{$ifdef Go32v2}
 TextMode(old_textmode);
 dosmemput($B800, 0, save_screen, sizeof(save_screen));
 gotoxy(old_x,old_y);
 {$else}
 clrscr;
{$endif}
for i:=0 to length(multi_file)-1 do
    begin
    setlength(multi_file[i].Testo,0);
    multi_file[i].Annulla_Txt.destroy;
    multi_file[i].Annulla_Esa.destroy;
    multi_file[i].Ripristina_Txt.Destroy;       // ver 3.15
    multi_file[i].Ripristina_Selezione.Destroy; // ver 3.15
    end;
setlength(Multi_file,0);
for i:=0 to length(appunti)-1 do Appunti[i].destroy;
Annulla_Txt.destroy;
Annulla_Esa.destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
Lista_Visualizza.Destroy; // ver 2.52
{$ifndef Linux}
Stampante.Destroy;
{$endif}
{$ifndef Go32v2}
donemouse;
{$endif}
Donekeyboard;
if not Editor_Ini.Salva_in_Uscita() then writeln(invio+lingue.get_txt(444)); // 'Errore durante l'operazione di salvataggio della configurazione'
Estensioni.destroy;  // ver 2.76 , 2.77
Editor_Ini.Destroy;
Lingue.Destroy;
Halt(0);   // il programma viene terminato regolarmente
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ini_annullato(n:longint); // ver 2.60
begin
while (Editor_Ini.numElementi<>0)and(Editor_Ini.numElementi>n) do Editor_Ini.Estrai_Iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure prepara_riga_file_ini_salva(pos_file_attuale:longint);    // ver 2.61
begin
Editor_Ini.Input('File='+Get_Info__Recenti_Visualizza(pos_file_attuale) );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure prima_riga_visualizza_ini_salva;  // ver 2.61, update 2.66
var separatore,ultima_riga_ini:string;
begin
Editor_Ini.Set_Modifica(true);
separatore:=Editor_Ini.Separatore_Opzioni();
ultima_riga_ini:=trim(Editor_Ini.Get_stringa(Editor_Ini.NumElementi()));
if (ultima_riga_ini='') or (ultima_riga_ini=separatore+separatore) then
                                                                   else Editor_Ini.Input('');
Editor_Ini.Input('[VISUALIZZA]  ; lista dei files aperti');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure prima_riga_recenti_ini_salva;   // ver 2.61
begin
Editor_Ini.Set_Modifica(true);
if trim(Editor_Ini.Rimuovi_Separatore_Opzioni(Editor_Ini.Get_stringa(Editor_Ini.NumElementi())))<>'' then Editor_Ini.Input('');
Editor_Ini.Input('[RECENTI]  ; verranno considerati solo i primi 9 files');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function visualizza_ini_salva():longint; // ver 2.61
var i,num_visualizza_ini:longint;
begin
i:=posizione_file_attuale;
num_visualizza_ini:=0;
result:=Editor_Ini.NumElementi();
while true do
      begin
      if multi_file[i].aperto and (multi_file[i].nomefile<>'') and (Exist(multi_file[i].percorso+multi_file[i].nomefile)>=0) then
         begin
         inc(num_visualizza_ini);
         if num_visualizza_ini=1 then prima_riga_visualizza_ini_salva;
         prepara_riga_file_ini_salva(i);    // ver 2.61
         end;
      dec(i);
      if i=0 then i:=get_numero_files;
      if i=posizione_file_attuale then break;  // fatta tutta la scansione
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function recenti_ini_salva():longint; // ver 2.60  ritorna il numero di righe prima dell'inserimento dei recenti
var num_recenti_ini:longint;
begin
result:=Editor_Ini.NumElementi();
for num_recenti_ini:=1 to min(9,Editor_Ini.numElementi_File_Recenti) do
    begin
    if num_recenti_ini=1 then
       prima_riga_recenti_ini_salva;   // ver 2.61
    Editor_Ini.Input('File='+Editor_Ini.Get_File_Recenti(num_recenti_ini));
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Esci;     // update 2.40
var old_percorso,old_nomefile:string;
    precedente_posizione_file_attuale,num_righe_senza_recenti,num_righe_senza_visualizza:longint;
label chiusura;

begin
salva_multi_file(posizione_file_attuale,true);
editor_ini.inserisci_associazione_estensioni(estensioni);  // ver 2.75
num_righe_senza_recenti:=recenti_ini_salva(); // ver 2.60
num_righe_senza_visualizza:=visualizza_ini_salva(); // ver 2.61

chiusura:
old_percorso:=percorso;
old_nomefile:=nomefile;
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(464)); // 'Chiusura di EDITOR in corso.'
chiudi_file_non_modificati;
ShowMouse;
if modifica then
   begin
   save_ask;
   case Tasti_SNA(32,riga_menu+3) of
        'N': modifica:=false; // verra' eseguito dopo: chiudi_multi_file(posizione_file_attuale);
        'A': begin
             ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
             Exit;
             end;
        'S': if Free then
                     begin
                     if nomefile<>'' then
                                      if SL then
                                          begin
                                          SL_Error;  // ver 2.52
                                          ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
                                          Exit;
                                          end
                                         else Salva
                                     else
                                      begin
                                      Salva_Con_Nome_mono_file(0);
                                      if nomefile<>'' then
                                                  begin
                                                  multi_file[posizione_file_attuale].percorso:=percorso;
                                                  multi_file[posizione_file_attuale].nomefile:=nomefile;
                                                  if num_righe_senza_visualizza=Editor_Ini.numElementi() then prima_riga_visualizza_ini_salva;
                                                  prepara_riga_file_ini_salva(posizione_file_attuale);    // ver 2.61
                                                  end;
                                      end;
                     if nomefile='' then
                                    begin
                                    ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
                                    Exit; // salvataggio annullato, che annulla esci
                                    end;
                     multi_file[posizione_file_attuale].percorso:=percorso;
                     multi_file[posizione_file_attuale].nomefile:=nomefile;
                     if IOF=false then
                           begin
                           attrib;
                           percorso:=old_percorso;
                           nomefile:=old_nomefile;
                           ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
                           Exit; // salvataggio fallito
                           end;
                     end
                    else
                     begin
                     Hd_Low;
                     ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
                     Exit;
                     end;
        end;   // del case
   end;        // di modifica
chiudi_multi_file(posizione_file_attuale);
while true do
      begin
      precedente_posizione_file_attuale:=posizione_file_attuale;
      posizione_file_attuale:=get_next_modificato_dopo(posizione_file_attuale);
      if posizione_file_attuale=-1 then break; // non vi sono altri file da salvare in uscita
      if not salva_multi_file(precedente_posizione_file_attuale) then  // aggiorno il file appena salvato
             begin
             posizione_file_attuale:=precedente_posizione_file_attuale;
             Error_Multi_Files;
             ini_annullato(min(num_righe_senza_visualizza,num_righe_senza_recenti));
             exit;
             end;
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      grafica;
      info;      // update 2.45
      goto chiusura;
      end;
Uscita;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function trim_unprintable(s:string):string;    // ver 2.40
var s1:string;
    i:longint;
begin
s1:='';
for i:=1 to length(s) do
    if (not (ord(s[i]) in unprintable)) or (s[i]=#13) then s1:=s1+s[i];
exit(s1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_stringa_appunti(i:longint):string;  // ver 2.40
begin  // se la riga da incollare e' piu' lunga della lunghezza massima della riga stessa, verra' troncata
if binario and (Appunti[appunti_usato].numelementi>0) then Exit(copy(Appunti[appunti_usato].get_stringa(i),1,lunghezza_riga));
if (not binario) and (Appunti[appunti_usato].numelementi>0) then Exit(copy(trim_unprintable(Appunti[appunti_usato].get_stringa(i)),1,lunghezza_riga));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Salva_Tutti_2;   // ver 2.40
label salvataggio_tutti;
var old_percorso,old_nomefile:string;
    precedente_posizione_file_attuale:longint;
begin
old_percorso:=percorso;
old_nomefile:=nomefile;
salvataggio_tutti:
pulisci1;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(465));  // 'Salvataggio di tutti i files.'
ShowMouse;
if modifica then
   begin
   if Free then
           begin
           if nomefile<>'' then
                            if SL then
                                  begin
                                  SL_Error;  // ver 2.52
                                  Exit;
                                  end
                                 else Salva
                           else Salva_Con_Nome_mono_file(0);
           if nomefile='' then
                          begin
                          if not salva_multi_file(posizione_file_attuale) then  // aggiorno il file in uso
                                 begin
                                 Error_Multi_Files;
                                 exit;
                                 end;
                          Exit; // salvataggio annullato, che annulla i successivi
                          end;
           multi_file[posizione_file_attuale].percorso:=percorso;
           multi_file[posizione_file_attuale].nomefile:=nomefile;
           if IOF=false then
                        begin
                        attrib;
                        percorso:=old_percorso;
                        nomefile:=old_nomefile;
                        Exit; // salvataggio fallito
                        end;
           end
          else
           begin
           Hd_Low;
           Exit;
           end;
   end;        // di modifica

while true do
      begin
      precedente_posizione_file_attuale:=posizione_file_attuale;
      if not salva_multi_file(precedente_posizione_file_attuale) then  // aggiorno il file in uso
             begin
             posizione_file_attuale:=precedente_posizione_file_attuale;
             Error_Multi_Files;
             exit;
             end;
      posizione_file_attuale:=get_next_modificato_dopo(posizione_file_attuale);
      if posizione_file_attuale=-1 then break; // non vi sono altri file da salvare
      ricarica_multi_file(posizione_file_attuale);
      Evidenzia_selezione;
      grafica;
      goto salvataggio_tutti;
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_file__Salva_Tutti;  // ver 2.40
var originale_posizione_file_attuale:longint;
begin
originale_posizione_file_attuale:=posizione_file_attuale;
Salva_Tutti_2;
posizione_file_attuale:=originale_posizione_file_attuale;
ricarica_multi_file(posizione_file_attuale);  // ripristino del primo file visualizzato
Evidenzia_selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function seleziona_appunti():integer; //  ver 2.58, 3.30
var Lista_Appunti:Sfoglia_Dati;  // 0=non incolla  1=incolla  2=incolla tutto  3=tasto canc
    s,add:string;
    riga_scelta,i,j,x_Lista_Appunti,y_Lista_Appunti,larghezza_Lista_Appunti,altezza_Lista_Appunti:longint;
begin
seleziona_appunti:=0;
if binario then
       begin
       if not is_last_block then Exit;  // devo essere all'ultimo blocco
       if not ( (iy=ymax)and(x_riga=length(testo[iy])) ) then Exit;  // devo essere all'ultimo byte
       end;
if length(appunti)=0 then exit; // non c'e' nulla da incollare
// length(appunti)>=1     c'e' qualcosa da in collare
Lista_Appunti.init;
Lista_Appunti.set_menu_ciclico(true);
Lista_Appunti.Input(Lingue.get_txt(466));  //  '*Annulla*'
Lista_Appunti.Input(Lingue.get_txt(552));  //  '*Incolla tutto*'  // ver 3.30
Lista_Appunti.Input(Lingue.get_txt(553));  //  '*Cancella tutto*' // ver 3.30
larghezza_Lista_Appunti:=max(10,max(Lingue.get_length_txt(553),max(Lingue.get_length_txt(552),Lingue.get_length_txt(466))));
for i:=0 to length(appunti)-1 do
    begin
    s:='';
    for j:=1 to appunti[i].numElementi do  // prendo le prime righe
             begin
             add:=appunti[i].Get_stringa(j);
             if add='' then add:='.'; // la stringa vuota indica l'andare a capo. La rappresento con un punto
             s:=s+add;
             if length(s)>(max_larghezza div 2)-5 then break;
             end;
    for j:=1 to length(s) do
        if ord(s[j]) in unprintable then s[j]:='.';
    s:=' '+s+' ';
    if length(s)>(max_larghezza div 2)-1 then
             begin
             setlength(s,(max_larghezza div 2)-5);
             s[(max_larghezza div 2)-5]:=' ';
             end;
    larghezza_Lista_Appunti:=max(length(s),larghezza_Lista_Appunti);
    Lista_Appunti.Input(s);
    end;
altezza_Lista_Appunti:=min(length(appunti)+6,((riga_menu-1)div 2)-1);

x_Lista_Appunti:=x+1;
if x_Lista_Appunti+larghezza_Lista_Appunti>max_larghezza-1 then x_Lista_Appunti:=x_Lista_Appunti-larghezza_Lista_Appunti-3;
y_Lista_Appunti:=y;
if y_Lista_Appunti+altezza_Lista_Appunti>riga_menu-1 then y_Lista_Appunti:=max(1,y_Lista_Appunti-altezza_Lista_Appunti);
riga_scelta:=Lista_Appunti.Costruisci(byte(x_Lista_Appunti),byte(y_Lista_Appunti),byte(larghezza_Lista_Appunti),topo,mancino,Lingue.get_txt(530),ClickDelay,altezza_Lista_Appunti); // 'Incolla'
if (riga_scelta=0)or(riga_scelta=Lista_Appunti.NumElementi) then { annulla } else
if (riga_scelta=Lista_Appunti.NumElementi-1) and (Lista_Appunti.Ultimo_Tasto='invio') then seleziona_appunti:=2 {incolla tutto} else
if (riga_scelta=Lista_Appunti.NumElementi-2) and (Lista_Appunti.Ultimo_Tasto='invio') then Svuota_Appunti {cancella tutto} else
if Lista_Appunti.Ultimo_Tasto='invio' then
                            begin
                            appunti_usato:=length(appunti)-riga_scelta;
                            seleziona_appunti:=1;
                            end else
if (Lista_Appunti.Ultimo_Tasto='canc') and (riga_scelta<length(appunti)) then
                            begin
                            riga_scelta:=length(appunti)-riga_scelta+1;
                            for i:=riga_scelta-1 to length(appunti)-2 do
                                appunti[i]:=appunti[i+1];
                            appunti[length(appunti)-1].destroy;
                            setlength(appunti,length(appunti)-1);
                            if appunti_usato>length(appunti)-1 then appunti_usato:=length(appunti)-1;
                            seleziona_appunti:=3;
                            end;
Evidenzia_Selezione;
Lista_Appunti.Destroy;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_nuovo_nome_file():string; // ver 2.59 , 2.69
var nome:string;
    i,numero,valore_successivo:longint;
    code:word;
begin
valore_successivo:=0;
for i:=1 to length(multi_file)-1 do
    begin
    nome:=upcase(nameOf_No_ext(multi_file[i].nomefile));
    if pos(upcase(Lingue.get_txt(467)),nome)=1 then nome:=copy_end(nome,Lingue.get_length_txt(467)+1)   // 'Nuovo' , 6
                                               else continue;
    val(nome,numero,code);
    if code=0 then valore_successivo:=max(valore_successivo,numero);
    end;
if binario then get_nuovo_nome_file:=Lingue.get_txt(467)+IntToStr(valore_successivo+1)+'.esa' // ver 2.69  'Nuovo'
           else get_nuovo_nome_file:=Lingue.get_txt(467)+IntToStr(valore_successivo+1)+'.txt';      // 'Nuovo'
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Azzera_Selezione_2(posizione_file_attuale:longint);  // ver 2.66
begin
Azzera_Selezione;
multi_file[posizione_file_attuale].selezionato.x1:=0;
multi_file[posizione_file_attuale].selezionato.y1:=0;
multi_file[posizione_file_attuale].selezionato.x2:=0;
multi_file[posizione_file_attuale].selezionato.y2:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure visualizza_recenti_ini(separatore,file_estrai_ini:string);   // ver 2.61, update 2.66 : ricarica i dati per visualizza/recenti (messi poi in editor.ini)
var s_next_length,s_tot,s_x,s_y,s_iy,s_x_min,str,nome_file,
    s_x1,s_x2,s_y1,s_y2,s_tab_num:string;
    c:char;
    code:word;
    intero:integer;
    estrai_byte_1,estrai_byte_2,estrai_byte_3,estrai_byte_4:bits;
    lunghezza_riga_,l_longint,old_next_max_righe_esa,
    old_next_max_righe_txt:longint;
    binario_:boolean;
    l_int64:int64;
begin
testa_coda(file_estrai_ini,Editor_Ini.Separatore_File(),nome_file,file_estrai_ini);
testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_next_length:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_tot:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_x:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_x_min:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_y:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_iy:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
estrai_byte_1.init;
estrai_byte_1.Assign(FromTo(copy_end(str,2),10,2));

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
estrai_byte_2.init;
estrai_byte_2.Assign(FromTo(copy_end(str,2),10,2));

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
estrai_byte_3.init;
estrai_byte_3.Assign(FromTo(copy_end(str,2),10,2));

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_x1:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_y1:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_x2:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_y2:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
s_tab_num:=copy_end(str,2);

testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
val(copy_end(str,2),l_longint,code);  // numero di righe
if (code<>0)or(l_longint<1) then
                             if binario then l_longint:=next_max_righe_esa
                                        else l_longint:=next_max_righe_txt
                            else l_longint:=l_longint+2;
old_next_max_righe_esa:=next_max_righe_esa;
old_next_max_righe_txt:=next_max_righe_txt;

next_max_righe_esa:=l_longint;
next_max_righe_txt:=l_longint;
testa_coda(file_estrai_ini,Separatore,str,file_estrai_ini);
estrai_byte_4.init;
estrai_byte_4.Assign(FromTo(copy_end(str,2),10,2));
binario_:=estrai_byte_2.Get_Bit(2);

val(s_next_length,intero,code); // per coerenza, estrarre prima BINARIO
if (code=0)and(intero>=1)and(intero<=254)
   then lunghezza_riga_:=intero
   else
    if binario_ then lunghezza_riga_:=next_length_ESA
                else lunghezza_riga_:=next_length_TXT;
val_try(s_tot,l_int64,code);
if code<>0 then l_int64:=0;
                                                         // 0=normale, 1=ESA, 2=Txt
c:=M_file__Apri(nome_file,lunghezza_riga_,l_int64{tot byte},bool(not binario_)+1 );   //  Si,No,Annulla,annulla Tutti,Errore
next_max_righe_esa:=old_next_max_righe_esa;
next_max_righe_txt:=old_next_max_righe_txt;

if c<>'S' then
          begin
          editor_ini.Set_Modifica(true);
          Exit;
          end;

// assegnamento valori, controllo coerenza, ed esecuzione
multi_file[posizione_file_attuale].ignora:=estrai_byte_1.Get_Bit(1);
ignora:=multi_file[posizione_file_attuale].ignora;
multi_file[posizione_file_attuale].sotto_:=estrai_byte_1.Get_Bit(2);
sotto_:=multi_file[posizione_file_attuale].sotto_;
multi_file[posizione_file_attuale].jolly :=estrai_byte_1.Get_Bit(3);
jolly:=multi_file[posizione_file_attuale].jolly;
multi_file[posizione_file_attuale].SC    :=estrai_byte_1.Get_Bit(4);
SC:=multi_file[posizione_file_attuale].SC;
multi_file[posizione_file_attuale].tutto :=estrai_byte_1.Get_Bit(5);
tutto:=multi_file[posizione_file_attuale].tutto; // sostituisci tutto?
multi_file[posizione_file_attuale].pInt  :=estrai_byte_1.Get_Bit(6);
pInt:=multi_file[posizione_file_attuale].pInt;
multi_file[posizione_file_attuale].selezione:=estrai_byte_1.Get_Bit(7); // cerca dentro la selezione
selezione:=multi_file[posizione_file_attuale].selezione;
multi_file[posizione_file_attuale].selezione_quadrata:=estrai_byte_1.Get_Bit(8);
selezione_quadrata:=multi_file[posizione_file_attuale].selezione_quadrata;

multi_file[posizione_file_attuale].BK        :=estrai_byte_2.Get_Bit(1);  // salva backup
bk:=multi_file[posizione_file_attuale].BK;
//      multi_file[posizione_file_attuale].binario   :=estrai_byte_2.Get_Bit(2);  // formato esadecimale/testo non noti
//      binario:=multi_file[posizione_file_attuale].binario;
multi_file[posizione_file_attuale].binario:=binario;
multi_file[posizione_file_attuale].ins       :=estrai_byte_2.Get_Bit(3);  // tasto insert
ins:=multi_file[posizione_file_attuale].ins;
multi_file[posizione_file_attuale].UnoS      :=estrai_byte_2.Get_Bit(4);  // mantiene uno spazio tra parole
UnoS:=multi_file[posizione_file_attuale].UnoS;
multi_file[posizione_file_attuale].AutoDetect:=estrai_byte_2.Get_Bit(5);  // apertura file intelligente
AutoDetect:=multi_file[posizione_file_attuale].AutoDetect;
multi_file[posizione_file_attuale].sl        :=estrai_byte_2.Get_Bit(6);  // apre in sola lettura
sl:=multi_file[posizione_file_attuale].sl;
multi_file[posizione_file_attuale].CL        :=estrai_byte_2.Get_Bit(7);  // cursore libero
CL:=multi_file[posizione_file_attuale].CL;
multi_file[posizione_file_attuale].sfinal    :=estrai_byte_2.Get_Bit(8);  // salva spazi finali
sfinal:=multi_file[posizione_file_attuale].sfinal;

multi_file[posizione_file_attuale].per_riga:=estrai_byte_3.Get_Bit(1);
per_riga:=multi_file[posizione_file_attuale].per_riga; // ver 3.24
multi_file[posizione_file_attuale].Home         :=estrai_byte_3.Get_Bit(2);
Home:=multi_file[posizione_file_attuale].Home;
multi_file[posizione_file_attuale].Fine_        :=estrai_byte_3.Get_Bit(3);  // tasti
Fine_:=multi_file[posizione_file_attuale].Fine_;
multi_file[posizione_file_attuale].salva_tab    :=estrai_byte_3.Get_Bit(4);  // tabulazione
salva_tab:=multi_file[posizione_file_attuale].salva_tab;
multi_file[posizione_file_attuale].salva_formato:='T'; // predefinito
if estrai_byte_3.Get_Bit(5) then multi_file[posizione_file_attuale].salva_formato:='T';  // testo  8 bit
if estrai_byte_3.Get_Bit(6) then multi_file[posizione_file_attuale].salva_formato:='B';  // testo 16 bit big endian
if estrai_byte_3.Get_Bit(7) then multi_file[posizione_file_attuale].salva_formato:='L';  // testo 16 bit little endian
if estrai_byte_3.Get_Bit(8) then multi_file[posizione_file_attuale].salva_formato:='U';  // testo 16 bit utf
salva_formato:=multi_file[posizione_file_attuale].salva_formato; // predefinito

val(s_x,intero,code);
if code<>0 then intero:=1;
multi_file[posizione_file_attuale].x:=byte(min(max(intero,1),80));
multi_file[posizione_file_attuale].x_reale:=multi_file[posizione_file_attuale].x;
x:=multi_file[posizione_file_attuale].x;

val(s_x_min,intero,code);
if code<>0 then intero:=1;
multi_file[posizione_file_attuale].x_min:=byte(max(intero,1));
x_min:=multi_file[posizione_file_attuale].x_min;

val(s_y,intero,code);
if code<>0 then intero:=1;
multi_file[posizione_file_attuale].y:=byte(max(intero,1));
y:=multi_file[posizione_file_attuale].y;

val(s_iy,intero,code);
if code<>0 then intero:=1;
multi_file[posizione_file_attuale].iy:=max(intero,1);
iy:=multi_file[posizione_file_attuale].iy;

      // integrita' X, Y e iY con yMax
if iy>ymax then iy:=ymax;
if y>riga_menu-1 then y:=riga_menu-1;
if y>iy then y:=byte(iy);
if x>length(testo[iy]) then Set_Cursore_X(length(testo[iy]));
x_riga:=x+x_min-1;
while x+x_min-1>length(testo[iy]) do // controllo integrita'
              begin
              x:=byte(max(1,x-1));
              x_riga:=max(x_riga-1,1);
              if x_min>x_riga then x_min:=x_riga;
              end;
x_reale:=x;

      // selezione
val(s_x1,intero,code);
if code<>0 then intero:=0;
multi_file[posizione_file_attuale].selezionato.x1:=byte(intero);
selezionato.x1:=multi_file[posizione_file_attuale].selezionato.x1;

val(s_y1,intero,code);
if code<>0 then intero:=0;
multi_file[posizione_file_attuale].selezionato.y1:=intero;
selezionato.y1:=multi_file[posizione_file_attuale].selezionato.y1;

val(s_x2,intero,code);
if code<>0 then intero:=0;
multi_file[posizione_file_attuale].selezionato.x2:=byte(intero);
selezionato.x2:=multi_file[posizione_file_attuale].selezionato.x2;

val(s_y2,intero,code);
if code<>0 then intero:=0;
multi_file[posizione_file_attuale].selezionato.y2:=intero;
selezionato.y2:=multi_file[posizione_file_attuale].selezionato.y2;

if (multi_file[posizione_file_attuale].selezionato.x1<1)or
   (multi_file[posizione_file_attuale].selezionato.y1<1)or
   (multi_file[posizione_file_attuale].selezionato.x2<1)or
   (multi_file[posizione_file_attuale].selezionato.y2<1) then Azzera_Selezione_2(posizione_file_attuale) else
if (multi_file[posizione_file_attuale].selezionato.y1>multi_file[posizione_file_attuale].selezionato.y2) then Azzera_Selezione_2(posizione_file_attuale) else
if (multi_file[posizione_file_attuale].selezionato.y1=multi_file[posizione_file_attuale].selezionato.y2) and
   (multi_file[posizione_file_attuale].selezionato.x1>multi_file[posizione_file_attuale].selezionato.x2) then Azzera_Selezione_2(posizione_file_attuale) else
if (multi_file[posizione_file_attuale].selezionato.y1>ymax) or
   (multi_file[posizione_file_attuale].selezionato.y2>ymax) then Azzera_Selezione_2(posizione_file_attuale) else
if (multi_file[posizione_file_attuale].selezionato.x1>length(testo[selezionato.y1])) or
   (multi_file[posizione_file_attuale].selezionato.x2>length(testo[selezionato.y2])) then Azzera_Selezione_2(posizione_file_attuale);
if (multi_file[posizione_file_attuale].selezionato.x1>multi_file[posizione_file_attuale].lunghezza_riga) or
   (multi_file[posizione_file_attuale].selezionato.x2>multi_file[posizione_file_attuale].lunghezza_riga) then Azzera_Selezione_2(posizione_file_attuale);

val(s_tab_num,intero,code);
if (code<>0) or (intero<1) or (intero>multi_file[posizione_file_attuale].lunghezza_riga) then multi_file[posizione_file_attuale].Tab_num:=8
                                                                                         else multi_file[posizione_file_attuale].Tab_num:=intero;
Tab_num:=multi_file[posizione_file_attuale].Tab_num;

multi_file[posizione_file_attuale].delimitatore:=0;
if estrai_byte_4.Get_Bit(1) then multi_file[posizione_file_attuale].delimitatore:=0;
if estrai_byte_4.Get_Bit(2) then multi_file[posizione_file_attuale].delimitatore:=1;
if estrai_byte_4.Get_Bit(3) then multi_file[posizione_file_attuale].delimitatore:=2;
delimitatore:=multi_file[posizione_file_attuale].delimitatore;

estrai_byte_1.Destroy;
estrai_byte_2.Destroy;
estrai_byte_3.Destroy;
estrai_byte_4.Destroy;
Evidenzia_Selezione;  // serve perche' il file non viene solitamente aperto in X,Y=1,1
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure visualizza_ini;   // ver 2.61 : ricarica i file prendendoli da editor.ini
var file_estrai_ini:string;
begin
while true do
      begin
      file_estrai_ini:=Editor_Ini.Estrai_File_Aperti();
      if file_estrai_ini='' then break;
      visualizza_recenti_ini(Editor_Ini.Separatore_Valori(),file_estrai_ini);
      end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure menu_recenti(menu__y:byte);   // ver 2.40   update 2.45, 2.66
var riapri_nomefile:string;
begin
case menu__y of
     0: Exit;
     1: begin   // SVUOTA LISTA RECENTI : devo rendere impossibile la riapertura dei file precedentemente chiusi
        Editor_Ini.Svuota_File_Recenti;
        Aggiorna_Campi_Menu;
        end;
     2: ; // separatore: annullato
     else
       if menu__y>2 then  // apro un file precedentemente chiuso
          begin
          riapri_nomefile:=Editor_Ini.Estrai_File_Recenti(Editor_Ini.numElementi_File_Recenti-(menu__y-2)+1);
          visualizza_recenti_ini(Editor_Ini.Separatore_Valori(),riapri_nomefile);
          Aggiorna_Campi_Menu;
          end;
     end;
Evidenzia_Selezione;
grafica;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_formato_estensione(estensione:string):char;  // ritorna Esa Txt Ask Unknow
var posA,posT,posE:longint;   // ver 2.75
begin
get_formato_estensione:='U';
posE:=posizione(Estensioni.l,stringtopchar('E'+estensione));  // ESA
posT:=posizione(Estensioni.l,stringtopchar('T'+estensione));  // TXT
posA:=posizione(Estensioni.l,stringtopchar('A'+estensione));  // ASK
if posT=0 then posT:=maxLongint;
if posE=0 then posE:=maxLongint;
if posA=0 then posA:=maxLongint;
if (posA<posT)and(posA<posE) then get_formato_estensione:='A' else
if (posE<posT)and(posE<posA) then get_formato_estensione:='E' else
if (posT<posA)and(posT<posE) then get_formato_estensione:='T' else
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure  M_opzioni__Associa_Estensioni; // ver 2.75
var Associa_Estensioni_:MenuLista_Y;
    i,risultato:byte;
    estensione:string;
    formato_estensione:char;
begin
pulisci1;
hidemouse;
gotoxy(2,riga_menu+1);
write(Lingue.get_txt(468)); // 'A quale formato associare l''estensione ?  '
{$ifdef OS2}  // *** per via di qualche bug nelle librerie
OutTextXY(1,riga_menu,Lingue.get_txt(468),0,blue,white);  // 'A quale formato associare l''estensione ?  '
{$endif}
gotoxy(2,riga_menu+2);
write(Lingue.get_txt(469)); // 'Formato predefinito : '
i:=posRL('.',nomefile,255);      //  ExtractFileExt
if i=0 then estensione:=''
       else estensione:=UpCase(Copy_end(nomefile,i+1));
formato_estensione:=get_formato_estensione(estensione);
textcolor(yellow);
case formato_estensione of
     'T': writeln(Lingue.get_txt(278));    // Txt  'Testo'
     'E': writeln(Lingue.get_txt(286));    // Esa  'Esadecimale'
     'A': writeln(Lingue.get_txt(470));    // Ask  'a richiesta'
     'U': writeln(Lingue.get_txt(471));    // sconosciuto  'sconosciuto'
     end;
textcolor(white);
write(Lingue.get_txt(472)); // ' Formato attuale in apertura: '
textcolor(yellow);
if binario then writeln('ESA')
           else writeln('TXT');
textcolor(white);
clreol;
write(Lingue.get_txt(473)); // ' Estensione del file: '
textcolor(yellow);
write(estensione);
gotoxy(2,riga_menu+3);
Associa_Estensioni_.init(ScreenWidth,ScreenHeight);
Associa_Estensioni_.topo:=topo;
Associa_Estensioni_.y:=riga_menu-5;
Associa_Estensioni_.x:=Lingue.get_length_txt(468)+1;
Associa_Estensioni_.controllo:=true;
Associa_Estensioni_.txt_ColorVeloce:=lightred;
Associa_Estensioni_.txt_ColorRigaSelezionata:=white;
Associa_Estensioni_.bk_color:=blue;
Associa_Estensioni_.txt_ColorCornice:=white;
Associa_Estensioni_.txt_ColorRiga:=yellow;
Associa_Estensioni_.bk_selezione:=green;
Associa_Estensioni_.NuovaRiga(Lingue.get_txt(369),Lingue.get_charB(369));  // ' --- Annulla --- ' n
Associa_Estensioni_.NuovaRiga(Lingue.get_txt(474),Lingue.get_charB(474));  // ' Testo        (TXT) ' T
Associa_Estensioni_.NuovaRiga(Lingue.get_txt(475),Lingue.get_charB(475));  // ' Esadecimale  (ESA) ' E
Associa_Estensioni_.NuovaRiga(Lingue.get_txt(476),Lingue.get_charB(476));  // ' Chiedi       (ASK) ' C
Associa_Estensioni_.NuovaRiga(Lingue.get_txt(477),Lingue.get_charB(477));  // ' Rimuovi associazione ' R
Associa_Estensioni_.Selezionabile(5,formato_estensione in ['T','E','A']);
showmouse;
risultato:=Associa_Estensioni_.costruisci;
if risultato>1 then
               begin  // rimozione per evitare duplicati
               while Estensioni.cerca_e_cancella(strnew(stringtopchar('T'+estensione)),1)<>-1 do ; // ritorna la posizione dove era
               while Estensioni.cerca_e_cancella(strnew(stringtopchar('E'+estensione)),1)<>-1 do ;
               while Estensioni.cerca_e_cancella(strnew(stringtopchar('A'+estensione)),1)<>-1 do ;
               Editor_Ini.Set_Modifica(true);
               end;
case risultato of
     0,1: ;
     2: Estensioni.input_iniziale(strnew(stringtopchar('T'+estensione)));
     3: Estensioni.input_iniziale(strnew(stringtopchar('E'+estensione)));
     4: Estensioni.input_iniziale(strnew(stringtopchar('A'+estensione)));
     5: ; // estensioni gia' rimosse
     end;
Evidenzia_selezione;
{$ifdef TxtVideo}
updatescreen(true);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Converti__esa_txt;  // ver 2.77
var ii:integer;
    i:byte;
    app:string;
begin
grafica; // add ver 2.92
pulisci1;
{$ifdef TxtCrt}
gotoxy(40-Lingue.get_length_txt(478) div 2,riga_menu+1);
write(Lingue.get_txt(478)); // 'Convertire il file dal formato esadecimale a testo ?');
gotoxy(40-Lingue.get_length_txt(479) div 2,riga_menu+2);
write(Lingue.get_txt(479)); // 'Nota: si possono perdere dati nel file.'
{$endif}
{$ifdef TxtVideo}
setcursorPos(0,riga_menu);
TxtClreol;
outtextxy(39-Lingue.get_length_txt(478) div 2,riga_menu,Lingue.get_txt(478),255,blue,white);
outtextxy(39-Lingue.get_length_txt(479) div 2,riga_menu+1,Lingue.get_txt(479),255,blue,white);
{$endif}
gotoxy(1,riga_menu+4);
write('                                                                 ');
gotoxy(1,riga_menu+3);
write('                                                                 ');
if Tasti_SN(35,riga_menu+3)<>'S' then Exit;
Azzera_Selezione;
modifica:=true;
Annulla_Txt.Destroy;
annulla_esa.destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
Annulla_Selezione.Destroy;
salvato:=nil;
for ii:=1 to ymax do
    begin
    app:=#13;
    for i:=2 to length(testo[ii]) do
        if not (ord(testo[ii][i]) in unprintable) then app:=app+testo[ii][i];
    testo[ii]:=app;
    end;
salvato:=@salvato;  // indirizzo non valido di proposito per l'annulla
Ins:=false;
binario:=false;
Evidenzia_selezione;
if x>length(testo[iy]) then Set_Cursore_X(length(testo[iy]));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_File__Converti__txt_esa;  // ver 2.77
var ii:integer;
    Max_Lunghezza_Riga:byte;
begin
Max_Lunghezza_Riga:=0;
for ii:=1 to ymax do Max_Lunghezza_Riga:=byte(max(Max_Lunghezza_Riga,length(testo[ii])-1));
Max_Lunghezza_Riga:=byte(max(Max_Lunghezza_Riga,next_length_ESA));
grafica; // add ver 2.92
pulisci1;
gotoxy(40-Lingue.get_length_txt(480) div 2,riga_menu+1);
write(Lingue.get_txt(480));  // 'Convertire il file dal formato testo ad esadecimale ?'
gotoxy(40-Lingue.get_length_txt(481) div 2,riga_menu+2);
write(Lingue.get_txt(481));  // 'La lunghezza della riga e'' la massima tra quella attuale e quella configurata.'
gotoxy(1,riga_menu+4);
write('                                                                 ');
if Tasti_SN(35,riga_menu+3)<>'S' then Exit;
Azzera_Selezione;
modifica:=true;
Annulla_Txt.Destroy;
Annulla_esa.destroy;
Annulla_Selezione.Destroy;
Ripristina_Txt.Destroy;       // ver 3.15
Ripristina_Selezione.Destroy; // ver 3.15
salvato:=nil;
for ii:=1 to ymax-1 do while length(testo[ii])<Max_Lunghezza_Riga+1 do testo[ii]:=testo[ii]+' '; // era ymax nel ciclo, e <80 la condizione,  update 2.10
lunghezza_riga:=Max_Lunghezza_Riga;
salvato:=@salvato; // indirizzo non valido di proposito per l'annulla
Ins:=true;
Evidenzia_selezione;
binario:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Configura3;  // ver 2.86 , 2.88
{$define Stato_Cursore:=
          begin
          case stato_ of
             1: gotoxy(2,3);
             2: gotoxy(2,4);
            end;
          cursorON;
          end  }
{$define stato_OK:=
         begin
         gotoxy(34,25);
         write(' ');
         gotoxy(39,25);
         write('  ');
         gotoxy(46,25);
         write(' ');
         end; }
{$define assegna_stato:=
           begin
           case c[1] of
                'N' : stato_:=1;  // non apre i files da terminale, gia' caricati precedentemente
                'M' : stato_:=2;  // gestione automatica della memoria per files di testo troppo grandi
               end;
           end; }
var cliccato,modifica_configurazione,old_apri_file_caricati,old_mem_automatica:boolean;
    stato_:byte;
    c:shortstring;
const tasto_ok=3;
label theMouse,tasti,read_uscita;

begin
hidemouse;
stato_:=tasto_ok;
modifica_configurazione:=true;
cursoroff;
textcolor(lightred);
textbackground(blue);
clrscr;
gotoxy(40-Lingue.get_length_txt(482) div 2,1);
writeln(Lingue.get_txt(482)+invio);  // 'Configurazione 3 di Editor'

textcolor(white);
writeln(Lingue.get_txt(483)); // '[ ] Non apre i files da terminale, gia'' caricati precedentemente'
writeln(Lingue.get_txt(484)); // '[ ] Gestione automatica della memoria per files di testo troppo grandi'

showmouse;
Pre_Tasti(35,25);
gotoxy(34,25);
write('[');
gotoxy(39,25);
write(']');
old_mem_automatica:=mem_automatica;
old_apri_file_caricati:=apri_file_caricati;     {salvo i valori prima di modificarli}
apri_file_caricati:=not apri_file_caricati;
textcolor(13);
gotoxy(Lingue.get_pos_rosso(483),3);
write(Lingue.get_char(483){'N'});
gotoxy(Lingue.get_pos_rosso(484),4);
write(Lingue.get_char(484){'m'});
Metti_X(2,3,apri_file_caricati);  {sono ripetuti per non annullare il vero valore}
Metti_X(2,3,apri_file_caricati);
Metti_X(2,4,mem_automatica);
Metti_X(2,4,mem_automatica);
showmouse;
repeat
 if (PollKeyEvent=0) and topo then
           begin
           sleep(5);
           {$ifdef go32v2}
            cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
           {$else}
            cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
           {$endif}
           if cliccato then stato:=1
                       else stato:=0;
    theMouse:
           if (stato=1)and(moy= 3)and(mox= 2) then
                                              begin
                                              Metti_X(mox,moy,apri_file_caricati);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=1;
                                              end else
           if (stato=1)and(moy= 4)and(mox= 2) then
                                              begin
                                              Metti_X(mox,moy,mem_automatica);
                                              stato_OK;
                                              gotoxy(mox,moy);
                                              stato_:=2;
                                              end else ;
           if stato=1 then if stato_<tasto_ok then cursorON
                                              else cursorOFF;
           if (stato=1)and(mox>40)and(mox<46)and(moy=25) then  {ESC}
                     begin
                read_uscita:
                     modifica_configurazione:=false;
                     apri_file_caricati:=old_apri_file_caricati;   {ripristino i valori originali}
                     mem_automatica:=old_mem_automatica;
                     Break;
                     end;
           if (stato=1)and(mox>34)and(mox<39)and(moy=25) then break;  {INVIO}
           end
          else
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if length(c)=1 then c:=upcase(c);
           if c=#32 then
                    case stato_ of
                      1 : c:=Lingue.get_charUP(483); // 'N'
                      2 : c:=Lingue.get_charUP(484); // 'M'
                      3 : c:=#13;
                      4 : c:=#27;
                    end;
  tasti:   if (c=#9) then
                    begin
                    inc(stato_);
                    if stato_>tasto_ok+1 then
                                 begin
                                 stato_:=1;
                                 gotoxy(40,25);
                                 write(' ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                    if stato_<tasto_ok then
                                  begin
                                  stato_cursore;
                                  end
                                 else
                                  begin
                                  cursorOFF;
                                  if stato_=tasto_ok then
                                               begin
                                               gotoxy(34,25);
                                               write('[');
                                               gotoxy(39,25);
                                               write(']');
                                               end
                                              else // tasto ESC
                                               begin
                                               gotoxy(34,25);
                                               write(' ');
                                               gotoxy(39,25);
                                               write(' [');
                                               gotoxy(46,25);
                                               write(']');
                                               end;
                                  end;
                    end else
           if (c=#27) then
                    begin
                    stato:=1;
                    mox:=41;
                    moy:=25;
                    goto theMouse;
                    end else
           if (c=#13) then
                    begin
                    if stato_<>tasto_ok then break
                                  else
                                   begin
                                   stato:=1;
                                   mox:=41;
                                   moy:=25;
                                   goto themouse; {ESC}
                                   end;
                    end else
           if (c=Lingue.get_charUP(483{'N'})) then Metti_X(2,3,apri_file_caricati) else
           if (c=Lingue.get_charUP(484{'M'})) then Metti_X(2,4,mem_automatica)
                                              else ;
           if length(c)=1 then
              begin
              if c[1] in [Lingue.get_charUP(483),Lingue.get_charUP(484)]  then
                                      begin
                                      stato_OK;
                                      assegna_stato;
                                      stato_cursore;
                                      end;
              assegna_stato;
              end;
           if (c='Down')or(c='Right') then
                          begin  // freccia giu'/destra  #80,#77
                          c:=#9;
                          goto tasti;
                          end else
           if (c='Up')or(c='Left')or(c='SHIFT Key with scancode 3840') then
                          begin // freccia su/sinistra  #72,#75  shift+tab
                          if stato_ in [tasto_ok,tasto_ok+1] then
                                 begin
                                 gotoxy(34,25);
                                 write(' ');
                                 gotoxy(39,25);
                                 write('  ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                          if stato_=2 then stato_:=tasto_ok+1
                             else if stato_=1 then stato_:=tasto_ok
                                  else dec(stato_,2);
                          c:=#9;
                          goto tasti;
                          end;
           end;
until false;
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
if modifica_configurazione then
   begin
   Editor_Ini.Set_modifica(true);

   Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'/N'{nome_tipo},BoolToStr(apri_file_caricati){valore});
   apri_file_caricati:=not apri_file_caricati;
   Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'/Mem'{nome_tipo},BoolToStr(mem_automatica){valore});
   if (not mem_automatica) and old_mem_automatica then
      begin
      max_righe:=max(max_righe,length(testo))-2;
      setlength(testo,max_righe+2);
      end;
   end;
Evidenzia_Selezione;
stato:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

end.

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

Versione:    Data:    Righe:   Modifica:

2.5.8.786    14/04/05   2618   multi-incolla;
2.4.0.705    06/10/04   1951   versione base completata.
