/*      MOUSE.C - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <dos.h>
#include <conio.h>
#include <mouse.h>

struct MouseStruc Mouse;

void OpenMouse()
{
 union REGS regs;
 Mouse.present=NO;
 if(getvect(0x33)!=0L)
 {
  regs.x.ax=0;
  int86(0x33,&regs,&regs);
  if(regs.x.ax)
  {
   Mouse.present=YES;
   Mouse.visible=NO;
   ClearBtn();
  }
 }
}

int MouseLeftClicked()
{
 Mouse.lefthit=Mouse.righthit=NO;
 while(!Mouse.lefthit)
  ReadMouseDown();
 return Mouse.lefthit;
}

void CloseMouse()
{
 union REGS regs;
 if(Mouse.present)
 {
  if(Mouse.visible)
  {
   regs.x.ax=0x02;
   int86(0x33,&regs,&regs);
   Mouse.visible=NO;
  }
  Mouse.present=NO;
 }
}

void SetMouseLimits(int x1, int y1, int x2, int y2)
{
 union REGS regs;
 if(Mouse.present)
 {
  regs.x.cx=x1;
  regs.x.dx=x2;
  regs.x.ax=0x07;
  int86(0x33,&regs,&regs);
  regs.x.cx=y1;
  regs.x.dx=y2;
  regs.x.ax=0x08;
  int86(0x33,&regs,&regs);
 }
}

void ShowMouse()
{
 union REGS regs;
 if(Mouse.present)
 {
  regs.x.ax=0x01;
  int86(0x33,&regs,&regs);
  Mouse.visible=YES;
 }
}

void HideMouse()
{
 union REGS regs;
 if(Mouse.present&&Mouse.visible)
 {
  regs.x.ax=0x02;
  int86(0x33,&regs,&regs);
  Mouse.visible=NO;
 }
}

void SetMousePosition(int x, int y)
{
 union REGS regs;
 if(Mouse.present)
 {
  regs.x.ax=0x04;
  regs.x.cx=x;
  regs.x.dx=y;
  int86(0x33,&regs,&regs);
 }
}

void ReadMouseDown()
{
 union REGS regs;
 if(Mouse.present)
 {
  regs.x.ax=0x03;
  int86(0x33,&regs,&regs);
  if(!Mouse.leftdn&(regs.x.bx&1))
   Mouse.lefthit=YES;
  else
   Mouse.lefthit=NO;
  if(!Mouse.rightdn&(regs.x.bx&2))
   Mouse.righthit=YES;
  else
   Mouse.righthit=NO;
  Mouse.leftdn=regs.x.bx&1;
  Mouse.rightdn=regs.x.bx&2;
  Mouse.x=regs.x.cx;
  Mouse.y=regs.x.dx;
 }
}

void ReadMouseUp()
{
 union REGS regs;
 if(Mouse.present)
 {
  regs.x.ax=0x06;
  regs.x.bx=0;
  int86(0x33,&regs,&regs);
  Mouse.leftup=regs.x.bx;
  if(Mouse.leftup)
  {
   Mouse.x=regs.x.cx;
   Mouse.y=regs.x.dx;
  }
  regs.x.ax=0x06;
  regs.x.bx=1;
  int86(0x33,&regs,&regs);
  Mouse.rightup=regs.x.bx;
  if(Mouse.rightup)
  {
   Mouse.x=regs.x.cx;
   Mouse.y=regs.x.dx;
  }
 }
}

void ClearBtn()
{
 Mouse.leftdn=NO;
 Mouse.rightdn=NO;
 Mouse.leftup=NO;
 Mouse.rightup=NO;
 Mouse.lefthit=NO;
 Mouse.righthit=NO;
}

int WaitBtn()
{
 int key=0;
 while(kbhit())
  getch();
 Mouse.lefthit=Mouse.righthit=NO;
 while(!Mouse.lefthit&!Mouse.righthit&!kbhit())
  ReadMouseDown();
 if(kbhit())
  key=getch();
 return key;
}

void ChangeMouse(unsigned char far *shape, int hotx, int hoty)
{
 union REGS regs;
 struct SREGS sregs;
 if(Mouse.present)
 {
  regs.x.ax=0x09;
  regs.x.bx=hotx;
  regs.x.cx=hoty;
  regs.x.dx=FP_OFF(shape);
  sregs.es=FP_SEG(shape);
  int86x(0x33,&regs,&regs,&sregs);
 }
}

int MouseIn(int x, int y, int x1, int y1)
{
 if((Mouse.x>x)&&(Mouse.y>y)&&(Mouse.x<x1)&&(Mouse.y<y1))
  return 1;
 return 0;
}
