/*      DAPI.H - part of the FreeDAPI
	Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef _DAPI_H_
#define _DAPI_H_

#define  TXTHIGH	8
#define  TXTWIDTH	8
#define  VOID		void huge

#define BEGIN_EVENT(window)			while(1){ WaitBtn(); CheckEvents(window);
#define END_EVENT()				}
#define CreateTextx(win,x,y,txt)        	win=CreateText(win,x,y,txt)
#define CreateButtonx(win,x,y,txt)		win=CreateButton(win,x,y,txt)
#define CreateCheckx(win,x,y,txt)		win=CreateCheck(win,x,y,txt)
#define CreateWindowx(win,x,y,x1,y1,t,p,type) 	win=CreateWindow(x,y,x1,y1,t,p,type)
#define Showx(win)				win=Show(win)

//ID's
#define WINDOW			0x001
#define	BUTTON			0x002
#define CHECK			0x003
#define RADIO			0x004
#define TEXT			0x005
#define ENTER			0x006

//Type's
#define SIZEABLE		0x01

typedef struct Text{
 char txt[255];
 int x,y;
 int active;
} HTXT;

typedef struct Button{
 char txt[255];
 int x,y,x1,y1;
 int i;        	//Invert
 int active;
} HBUTTON;

typedef struct Check{
 char txt[255];
 int x,y;
 int i;		//Checked
 int active;
} HCHECK;

typedef struct Radio{
 char txt[255];
 int x,y;
 int i;		//Active
 int active;
} HRADIO;

typedef struct Enter{
 int x, y;
 char buffer[255];
} HENTER;

typedef struct Window{
 char title[255];
 struct Window *parent;
 int x,y,x1,y1;
 int type;
 HTXT Text[16];
 HBUTTON Button[16];
 HCHECK Check[16];
 HRADIO Radio[16];
 HENTER Enter[16];
 int t;		//How many text
 int st;	//default: 0, is 1 if a text is set
 int b;		//How many buttons
 int sb;        //default: 0, is 1 if a button is set
 int c;		//How many checkbuttons
 int sc;        //default: 0, is 1 if a checkbutton is set
 int r;		//How many radiobuttons
 int sr;	//default: 0, is 1 if a radiobutton is set
 int e;		//How many enterline
 int se;	//default: 0, is 1 if a enterline is set
 int ap;	//actual component position
 int ac;	//actual component (see ID's)
 int active;
} * HWND;

#endif
