/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchTypeDefaultEager;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.ISingleRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractJavaJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaRelationshipMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularPluralTopLevelAnnotationAdapter;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public abstract class JavaSingleRelationshipMappingModelAdapter
extends JavaRelationshipMappingModelAdapter
implements ISingleRelationshipMappingModelAdapter {
    private BooleanAnnotationElementAdapter optionalAdapter;
    private SingularPluralTopLevelAnnotationAdapter joinColumnsAdapter = new SingularPluralTopLevelAnnotationAdapter(this.buildJoinColumnsAnnotationInfo());
    static final String JOIN_COLUMN_ANNOTATION = "JoinColumn";
    static final String JOIN_COLUMNS_ANNOTATION = "JoinColumns";

    protected JavaSingleRelationshipMappingModelAdapter() {
        this.optionalAdapter = new BooleanAnnotationElementAdapter(this.buildOptionalInfo());
    }

    protected EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildFetchTypeInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String fetchType) {
                if (fetchType == null) {
                    return;
                }
                if (fetchType.equals("EAGER")) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setFetchType(FetchTypeDefaultEager.EAGER_LITERAL);
                } else if (fetchType.equals("LAZY")) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setFetchType(FetchTypeDefaultEager.LAZY_LITERAL);
                } else if (fetchType.equals(FetchTypeDefaultEager.DEFAULT_LITERAL.getName())) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setFetchType(FetchTypeDefaultEager.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                FetchTypeDefaultEager fetchType = JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().getFetchType();
                if (((Object)((Object)fetchType)).equals((Object)FetchTypeDefaultEager.EAGER_LITERAL)) {
                    return "EAGER";
                }
                if (((Object)((Object)fetchType)).equals((Object)FetchTypeDefaultEager.LAZY_LITERAL)) {
                    return "LAZY";
                }
                return FetchTypeDefaultEager.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "FetchType";
            }

            public String annotationElementName() {
                return "fetch";
            }

            public String annotationName() {
                return JavaSingleRelationshipMappingModelAdapter.this.attributeMappingName();
            }

            public Member member() {
                return JavaSingleRelationshipMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return FetchTypeDefaultEager.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    private SingularPluralTopLevelAnnotationAdapter.AnnotationInfo buildJoinColumnsAnnotationInfo() {
        return new SingularPluralTopLevelAnnotationAdapter.AnnotationInfo(){

            public String singularAnnotationName() {
                return JavaSingleRelationshipMappingModelAdapter.JOIN_COLUMN_ANNOTATION;
            }

            public String pluralAnnotationName() {
                return JavaSingleRelationshipMappingModelAdapter.JOIN_COLUMNS_ANNOTATION;
            }

            public Member member() {
                return JavaSingleRelationshipMappingModelAdapter.this.getAttribute();
            }

            public int listSize() {
                return JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().getJoinColumns().size();
            }

            public boolean supportsDefault() {
                return true;
            }

            public boolean isDefault() {
                return JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().isDefaultJoinColumns();
            }
        };
    }

    public IJoinColumnModelAdapter buildJoinColumnModelAdapter() {
        return new JavaJoinColumnModelAdapter(this.buildJoinColumnOwner(), this.getAttribute());
    }

    private IJoinColumnModelAdapter.JoinColumnOwner buildJoinColumnOwner() {
        return new IJoinColumnModelAdapter.JoinColumnOwner(){

            public RelationshipMapping relationshipMapping() {
                return JavaSingleRelationshipMappingModelAdapter.this.getRelationshipMapping();
            }

            public int index(JoinColumn joinColumn) {
                return JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().getJoinColumns().indexOf((Object)joinColumn);
            }

            public String getTableName(JoinColumn joinColumn) {
                return joinColumn.getTableName();
            }

            public String getReferencedTableName(JoinColumn joinColumn) {
                Entity entity = this.relationshipMapping().getResolvedTargetEntity();
                if (entity == null) {
                    return null;
                }
                return entity.getTable().getName();
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildOptionalInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                if (newValue == null) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setOptional(Optional.DEFAULT_LITERAL);
                } else if (newValue.equalsIgnoreCase("true")) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setOptional(Optional.TRUE_LITERAL);
                } else if (newValue.equalsIgnoreCase("false")) {
                    JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().setOptional(Optional.FALSE_LITERAL);
                }
            }

            public String persValue() {
                switch (JavaSingleRelationshipMappingModelAdapter.this.getSingleRelationshipMapping().getOptional().getValue()) {
                    case 1: {
                        return "true";
                    }
                    case 2: {
                        return "false";
                    }
                }
                return null;
            }

            public String annotationElementName() {
                return "optional";
            }

            public String annotationName() {
                return JavaSingleRelationshipMappingModelAdapter.this.attributeMappingName();
            }

            public Member member() {
                return JavaSingleRelationshipMappingModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return false;
            }
        };
    }

    protected SingleRelationshipMapping getSingleRelationshipMapping() {
        return (SingleRelationshipMapping)this.getAttributeMapping();
    }

    public void optionalChanged() {
        this.updateJavaOptional();
    }

    private void updateJavaOptional() {
        this.optionalAdapter.updateJavaElement();
    }

    public void defaultJoinColumnsChanged() {
        if (this.joinColumnsAdapter.javaElementsSize(this.getAttribute().createASTRoot()) == 0) {
            if (!this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
                JoinColumn defaultJoinColumn = (JoinColumn)this.getSingleRelationshipMapping().getJoinColumns().get(0);
                defaultJoinColumn.setSpecifiedName(defaultJoinColumn.getDefaultName());
                defaultJoinColumn.setSpecifiedReferencedColumnName(defaultJoinColumn.getDefaultReferencedColumnName());
            }
        } else if (this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
            while (this.getSingleRelationshipMapping().getJoinColumns().size() > 0) {
                this.getSingleRelationshipMapping().getJoinColumns().remove(0);
            }
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
            this.getSingleRelationshipMapping().getJoinColumns().add((Object)joinColumn);
        }
    }

    public void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersDefaultJoinColumns(astRoot);
        this.updatePersJoinColumns(astRoot);
        this.updateOptional(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        super.postUpdatePersModel(astRoot);
        this.postUpdatePersJoinColumns(astRoot);
    }

    private void postUpdatePersJoinColumns(CompilationUnit astRoot) {
        Iterator i = this.getSingleRelationshipMapping().getJoinColumns().iterator();
        while (i.hasNext()) {
            ((AbstractJavaJoinColumnModelAdapter)((JoinColumn)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void updatePersDefaultJoinColumns(CompilationUnit astRoot) {
        if (this.joinColumnsAdapter.javaElementsSize(astRoot) == 0) {
            if (!this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
                this.getSingleRelationshipMapping().setDefaultJoinColumns(true);
            }
        } else if (this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
            this.getSingleRelationshipMapping().setDefaultJoinColumns(false);
        }
    }

    private void updatePersJoinColumns(CompilationUnit astRoot) {
        Annotation joinColumnAnnotation = this.getAttribute().getAnnotation(JOIN_COLUMN_ANNOTATION, astRoot);
        int numJoinColumns = 0;
        if (joinColumnAnnotation != null) {
            if (this.getSingleRelationshipMapping().getJoinColumns().size() <= numJoinColumns) {
                JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                this.getSingleRelationshipMapping().getJoinColumns().add((Object)joinColumn);
                ((JavaJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
            } else {
                ((JavaJoinColumnModelAdapter)((JoinColumn)this.getSingleRelationshipMapping().getJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
            }
            ++numJoinColumns;
        } else {
            Annotation joinColumnsAnnotation = this.getAttribute().getAnnotation(JOIN_COLUMNS_ANNOTATION, astRoot);
            if (joinColumnsAnnotation != null) {
                MemberValuePair valueValuePair;
                Expression valueExpression = null;
                if (joinColumnsAnnotation.getNodeType() == 79) {
                    valueExpression = ((SingleMemberAnnotation)joinColumnsAnnotation).getValue();
                } else if (joinColumnsAnnotation.getNodeType() == 77 && (valueValuePair = ASTTools.memberValuePair(joinColumnsAnnotation, "value")) != null) {
                    valueExpression = valueValuePair.getValue();
                }
                if (valueExpression != null) {
                    if (valueExpression.getNodeType() == 77) {
                        if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(JOIN_COLUMN_ANNOTATION)) {
                            if (this.getSingleRelationshipMapping().getJoinColumns().size() <= numJoinColumns) {
                                JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                                this.getSingleRelationshipMapping().getJoinColumns().add((Object)joinColumn);
                                ((JavaJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                            } else {
                                ((JavaJoinColumnModelAdapter)((JoinColumn)this.getSingleRelationshipMapping().getJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numJoinColumns;
                        }
                    } else if (valueExpression.getNodeType() == 4) {
                        Iterator i = ((ArrayInitializer)valueExpression).expressions().iterator();
                        while (i.hasNext()) {
                            Expression expression = (Expression)i.next();
                            if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(JOIN_COLUMN_ANNOTATION)) continue;
                            if (this.getSingleRelationshipMapping().getJoinColumns().size() <= numJoinColumns) {
                                JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                                this.getSingleRelationshipMapping().getJoinColumns().add((Object)joinColumn);
                                ((JavaJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                            } else {
                                ((JavaJoinColumnModelAdapter)((JoinColumn)this.getSingleRelationshipMapping().getJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numJoinColumns;
                        }
                    }
                }
            }
        }
        if (numJoinColumns != 0 || this.getSingleRelationshipMapping().getJoinColumns().size() != 1) {
            int i = this.getSingleRelationshipMapping().getJoinColumns().size();
            while (i > numJoinColumns) {
                this.getSingleRelationshipMapping().getJoinColumns().remove(i - 1);
                --i;
            }
        }
        if (numJoinColumns == 0) {
            JoinColumn joinColumn;
            if (!this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
                this.getSingleRelationshipMapping().setDefaultJoinColumns(true);
            }
            if (this.getSingleRelationshipMapping().getJoinColumns().size() == 0) {
                joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                this.getSingleRelationshipMapping().getJoinColumns().add((Object)joinColumn);
            } else {
                joinColumn = (JoinColumn)this.getSingleRelationshipMapping().getJoinColumns().get(0);
            }
            ((JavaJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
        } else if (this.getSingleRelationshipMapping().isDefaultJoinColumns()) {
            this.getSingleRelationshipMapping().setDefaultJoinColumns(false);
        }
    }

    private void updateOptional(CompilationUnit astRoot) {
        this.optionalAdapter.updatePersElement(astRoot);
    }

    public void joinColumnAdded() {
        this.joinColumnsAdapter.modelElementAdded();
    }

    public void joinColumnRemoved(int position) {
        this.joinColumnsAdapter.modelElementRemoved(position);
    }

    protected String javaDefaultTargetEntity() {
        String typeName = super.javaDefaultTargetEntity();
        return JavaSingleRelationshipMappingModelAdapter.typeNamedIsContainer(typeName) ? null : typeName;
    }
}

