/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.InvalidMapping;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.adapters.IPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.IJavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaDefaultAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInvalidMappingModelAdapter;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistentAttributeModelAdapter
implements IPersistentAttributeModelAdapter {
    private Attribute attribute;
    private PersistentAttribute persistentAttribute;

    public JavaPersistentAttributeModelAdapter(Attribute attribute) {
        this.attribute = attribute;
    }

    public void setPersistentAttribute(PersistentAttribute persistentAttribute) {
        this.persistentAttribute = persistentAttribute;
    }

    public boolean isPersistentAttributeFor(IMember member) {
        return this.attribute.isPersistentAttributeFor(member);
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersAttributeMapping(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersAttributeMappingFromJavaDefault(astRoot);
        ((JavaAttributeMappingModelAdapter)this.persistentAttribute.getAttributeMapping().getModelAdapter()).postUpdatePersModel(astRoot);
    }

    private void updatePersAttributeMapping(CompilationUnit astRoot) {
        IJavaAttributeMappingModelAdapter adapter;
        IConfigurationElement javaAttributeMapping = this.javaConfigurationElement(astRoot);
        AttributeMapping persAttributeMapping = this.persistentAttribute.getAttributeMapping();
        if (javaAttributeMapping == null) {
            return;
        }
        if (persAttributeMapping != null && !persAttributeMapping.isDefault() && javaAttributeMapping.getAttribute(this.attributeMappingNameExtensionAttribute()).equals(persAttributeMapping.mappingName())) {
            IJavaAttributeMappingModelAdapter adapter2 = (IJavaAttributeMappingModelAdapter)persAttributeMapping.getModelAdapter();
            adapter2.updatePersModel(astRoot);
            return;
        }
        try {
            adapter = (IJavaAttributeMappingModelAdapter)javaAttributeMapping.createExecutableExtension(this.mappingModelAdapterExtensionAttribute());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        AttributeMapping persistentAttributeType = adapter.createAttributeMapping(false, this.attribute);
        adapter.updatePersModel(astRoot);
        this.persistentAttribute.setAttributeMapping(persistentAttributeType);
    }

    private void updatePersAttributeMappingFromJavaDefault(CompilationUnit astRoot) {
        IJavaAttributeMappingModelAdapter adapter;
        if (this.javaConfigurationElement(astRoot) != null) {
            return;
        }
        IConfigurationElement javaAttributeMapping = this.javaDefaultConfigurationElement();
        AttributeMapping persAttributeMapping = this.persistentAttribute.getAttributeMapping();
        if (javaAttributeMapping == null) {
            if (persAttributeMapping instanceof InvalidMapping) {
                return;
            }
            JavaInvalidMappingModelAdapter adapter2 = new JavaInvalidMappingModelAdapter();
            this.persistentAttribute.setAttributeMapping(adapter2.createAttributeMapping(false, this.attribute));
            return;
        }
        if (persAttributeMapping != null && persAttributeMapping.isDefault() && javaAttributeMapping.getAttribute(this.attributeMappingNameExtensionAttribute()).equals(persAttributeMapping.mappingName())) {
            IJavaAttributeMappingModelAdapter adapter3 = (IJavaAttributeMappingModelAdapter)persAttributeMapping.getModelAdapter();
            adapter3.updatePersModel(astRoot);
            return;
        }
        try {
            adapter = (IJavaAttributeMappingModelAdapter)javaAttributeMapping.createExecutableExtension("javaDefaultModelAdapter");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        AttributeMapping persistentAttributeType = adapter.createAttributeMapping(true, this.attribute);
        adapter.updatePersModel(astRoot);
        this.persistentAttribute.setAttributeMapping(persistentAttributeType);
    }

    private IConfigurationElement configurationElementFor(String key) {
        IConfigurationElement[] mappingChoices = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dali.core.mappings");
        int i = 0;
        while (i < mappingChoices.length) {
            if (key.equals(mappingChoices[i].getAttribute("key"))) {
                return mappingChoices[i];
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public void setAttributeMappingKey(String attributeMappingKey, boolean isDefault) {
        IJavaAttributeMappingModelAdapter modelAdapter;
        AttributeMapping oldAttributeMapping = this.persistentAttribute.getAttributeMapping();
        IConfigurationElement element = this.configurationElementFor(attributeMappingKey);
        try {
            modelAdapter = (IJavaAttributeMappingModelAdapter)element.createExecutableExtension(this.mappingModelAdapterExtensionAttribute());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        AttributeMapping attributeMapping = modelAdapter.createAttributeMapping(isDefault, this.attribute);
        modelAdapter.updatePersModel(this.attribute.createASTRoot());
        this.persistentAttribute.setAttributeMapping(attributeMapping);
        modelAdapter.postUpdatePersModel(this.attribute.createASTRoot());
        if (oldAttributeMapping != null) {
            if (oldAttributeMapping.isDefault() || oldAttributeMapping.mappingName() == null) {
                if (attributeMapping.isDefault()) {
                    return;
                }
                this.getAttribute().addAnnotation(attributeMapping.mappingName());
            } else if (attributeMapping.isDefault() || attributeMapping.mappingName() == null) {
                this.getAttribute().removeAnnotation(oldAttributeMapping.mappingName());
            } else {
                this.getAttribute().replaceAnnotation(oldAttributeMapping.mappingName(), attributeMapping.mappingName());
            }
        } else {
            this.getAttribute().addAnnotation(attributeMapping.mappingName());
        }
    }

    private IConfigurationElement javaConfigurationElement(CompilationUnit astRoot) {
        Iterator i = DaliPlugin.getPlugin().annotationMappingConfigurationElements();
        while (i.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)i.next();
            String annotationName = element.getAttribute(this.attributeMappingNameExtensionAttribute());
            if (!this.containsAnnotation(annotationName, astRoot)) continue;
            return element;
        }
        return null;
    }

    private IConfigurationElement javaDefaultConfigurationElement() {
        Iterator i = DaliPlugin.getPlugin().defaultAnnotationMappingConfigurationElements();
        while (i.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)i.next();
            try {
                IJavaDefaultAttributeMappingModelAdapter adapter = (IJavaDefaultAttributeMappingModelAdapter)element.createExecutableExtension("javaDefaultModelAdapter");
                if (!adapter.defaultApplies(this.attribute, this.persistentAttribute)) continue;
                return element;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return ASTTools.annotation(this.attribute.bodyDeclaration(astRoot), annotationName);
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public ITextRange getTextRange() {
        ISourceRange sourceRange;
        try {
            sourceRange = this.attribute.getJDTMember().getNameRange();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return new ITextRange(){

            public int getOffset() {
                return sourceRange.getOffset();
            }

            public int getLength() {
                return sourceRange.getLength();
            }

            public int getLineNumber() {
                return ((CompilationUnit)JavaPersistentAttributeModelAdapter.this.getAttribute().bodyDeclaration().getRoot()).getLineNumber(this.getOffset());
            }
        };
    }

    public String mappingModelAdapterExtensionAttribute() {
        return "javaModelAdapter";
    }

    public String attributeMappingNameExtensionAttribute() {
        return "annotationName";
    }
}

