/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.Generator;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.TableGenerator;
import org.eclipse.dali.orm.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.ITableGeneratorModelAdapter;
import org.eclipse.dali.orm.provider.GeneratorItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.GeneratorComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TableGeneratorComposite
extends GeneratorComposite
implements IPersistenceComposite {
    private Combo tableNameCombo;
    private Combo pkColumnNameCombo;
    private Combo valueColumnNameCombo;
    private Combo pkColumnValueCombo;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private Connection connection;
    static /* synthetic */ Class class$0;

    protected TableGeneratorComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected GeneratorItemProvider createGeneratorItemProvider(OrmItemProviderAdapterFactory adapterFactory) {
        return (GeneratorItemProvider)adapterFactory.createTableGeneratorAdapter();
    }

    protected void createGenerator() {
        ITableGeneratorModelAdapter modelAdapter = ((IIdMappingModelAdapter)this.idMapping().getModelAdapter()).createTableGeneratorModelAdapter();
        TableGenerator tableGenerator = OrmFactory.eINSTANCE.createTableGenerator(modelAdapter);
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping(), (Object)OrmPackage.eINSTANCE.getIdMapping_TableGenerator(), (Object)tableGenerator));
    }

    protected Generator generator(IdMapping idMapping) {
        return idMapping.getTableGenerator();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Label tableGeneratorLabel = new Label((Composite)this, 16384);
        tableGeneratorLabel.setText(DaliUiMessages.TableGeneratorComposite_name);
        this.nameViewer = this.buildNameViewer(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameViewer.getTextWidget().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameViewer.getTextWidget(), "org.eclipse.dali.ui.mapping_tableGeneratorName");
        Label tableNameLabel = new Label((Composite)this, 16384);
        tableNameLabel.setText(DaliUiMessages.TableGeneratorComposite_table);
        this.tableNameCombo = this.buildTableNameCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableNameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tableNameCombo, "org.eclipse.dali.ui.mapping_tableGeneratorTable");
        Label pkColumnNameLabel = new Label((Composite)this, 16384);
        pkColumnNameLabel.setText(DaliUiMessages.TableGeneratorComposite_pkColumn);
        this.pkColumnNameCombo = this.buildPkColumnNameCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.pkColumnNameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pkColumnNameCombo, "org.eclipse.dali.ui.mapping_tableGeneratorPrimaryKeyColumn");
        Label valueColumnNameLabel = new Label((Composite)this, 16384);
        valueColumnNameLabel.setText(DaliUiMessages.TableGeneratorComposite_valueColumn);
        this.valueColumnNameCombo = this.buildValueColumnNameCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.valueColumnNameCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.valueColumnNameCombo, "org.eclipse.dali.ui.mapping_tableGeneratorValueColumn");
        Label pkColumnValueLabel = new Label((Composite)this, 16384);
        pkColumnValueLabel.setText(DaliUiMessages.TableGeneratorComposite_pkColumnValue);
        this.pkColumnValueCombo = this.buildPkColumnValueCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.pkColumnValueCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pkColumnValueCombo, "org.eclipse.dali.ui.mapping_tableGeneratorPrimaryKeyColumnValue");
    }

    private Combo buildTableNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add(DaliUiMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildTableNameListener());
        return combo;
    }

    private Combo buildPkColumnNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add(DaliUiMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildPkColumnNameListener());
        return combo;
    }

    private Combo buildValueColumnNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add(DaliUiMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildValueColumnNameListener());
        return combo;
    }

    private Combo buildPkColumnValueCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add(DaliUiMessages.TableGeneratorComposite_default);
        combo.select(0);
        combo.addModifyListener(this.buildPkColumnValueListener());
        return combo;
    }

    private ModifyListener buildTableNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableGeneratorComposite.this.populating) {
                    return;
                }
                String text = ((Combo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.tableNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.tableNameCombo.getItem(0))) {
                    text = null;
                }
                if (TableGeneratorComposite.this.getGenerator() == null) {
                    TableGeneratorComposite.this.createGenerator();
                }
                TableGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableGeneratorComposite.this.editingDomain, (Object)TableGeneratorComposite.this.getGenerator(), (Object)OrmPackage.eINSTANCE.getTableGenerator_SpecifiedTableName(), (Object)text));
            }
        };
    }

    private ModifyListener buildPkColumnNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableGeneratorComposite.this.populating) {
                    return;
                }
                String text = ((Combo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.pkColumnNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.pkColumnNameCombo.getItem(0))) {
                    text = null;
                }
                if (TableGeneratorComposite.this.getGenerator() == null) {
                    TableGeneratorComposite.this.createGenerator();
                }
                TableGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableGeneratorComposite.this.editingDomain, (Object)TableGeneratorComposite.this.getGenerator(), (Object)OrmPackage.eINSTANCE.getTableGenerator_SpecifiedPkColumnName(), (Object)text));
            }
        };
    }

    private ModifyListener buildValueColumnNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableGeneratorComposite.this.populating) {
                    return;
                }
                String text = ((Combo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.valueColumnNameCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.valueColumnNameCombo.getItem(0))) {
                    text = null;
                }
                if (TableGeneratorComposite.this.getGenerator() == null) {
                    TableGeneratorComposite.this.createGenerator();
                }
                TableGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableGeneratorComposite.this.editingDomain, (Object)TableGeneratorComposite.this.getGenerator(), (Object)OrmPackage.eINSTANCE.getTableGenerator_SpecifiedValueColumnName(), (Object)text));
            }
        };
    }

    private ModifyListener buildPkColumnValueListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableGeneratorComposite.this.populating) {
                    return;
                }
                String text = ((Combo)e.getSource()).getText();
                if (text != null && TableGeneratorComposite.this.pkColumnValueCombo.getItemCount() > 0 && text.equals(TableGeneratorComposite.this.pkColumnValueCombo.getItem(0))) {
                    text = null;
                }
                if (TableGeneratorComposite.this.getGenerator() == null) {
                    TableGeneratorComposite.this.createGenerator();
                }
                TableGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableGeneratorComposite.this.editingDomain, (Object)TableGeneratorComposite.this.getGenerator(), (Object)OrmPackage.eINSTANCE.getTableGenerator_SpecifiedPkColumnValue(), (Object)text));
            }
        };
    }

    protected void generatorChanged(Notification notification) {
        super.generatorChanged(notification);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.TableGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 9) {
            final String tableName = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (tableName == null) {
                        TableGeneratorComposite.this.tableNameCombo.select(0);
                    } else if (!TableGeneratorComposite.this.tableNameCombo.getText().equals(tableName)) {
                        TableGeneratorComposite.this.tableNameCombo.setText(tableName);
                    }
                    TableGeneratorComposite.this.populatePkColumnNameCombo();
                    TableGeneratorComposite.this.populateValueColumnNameCombo();
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.TableGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 18) {
                final String columnName = notification.getNewStringValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (columnName == null) {
                            TableGeneratorComposite.this.pkColumnNameCombo.select(0);
                        } else if (!TableGeneratorComposite.this.pkColumnNameCombo.getText().equals(columnName)) {
                            TableGeneratorComposite.this.pkColumnNameCombo.setText(columnName);
                        }
                    }
                });
            } else {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.TableGenerator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 21) {
                    final String columnName = notification.getNewStringValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (columnName == null) {
                                TableGeneratorComposite.this.valueColumnNameCombo.select(0);
                            } else if (!TableGeneratorComposite.this.valueColumnNameCombo.getText().equals(columnName)) {
                                TableGeneratorComposite.this.valueColumnNameCombo.setText(columnName);
                            }
                        }
                    });
                } else {
                    Class<?> clazz4 = class$0;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$0 = Class.forName("org.eclipse.dali.orm.TableGenerator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz4) == 24) {
                        final String columnValue = notification.getNewStringValue();
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                if (columnValue == null) {
                                    TableGeneratorComposite.this.pkColumnValueCombo.select(0);
                                } else if (!TableGeneratorComposite.this.pkColumnValueCombo.getText().equals(columnValue)) {
                                    TableGeneratorComposite.this.pkColumnValueCombo.setText(columnValue);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (model == null) {
            this.populating = false;
            return;
        }
        this.populateTableNameCombo();
        this.populatePkColumnNameCombo();
        this.populateValueColumnNameCombo();
        this.populatePkColumnValueCombo();
        this.populating = false;
    }

    protected void engageListeners() {
        super.engageListeners();
        this.addConnectionListener();
    }

    protected void disengageListeners() {
        if (this.getTableGenerator() != null) {
            this.removeConnectionListener();
        }
        super.disengageListeners();
    }

    private void populateTableNameCombo() {
        String tableName;
        this.populating = true;
        if (this.getGenerator() == null) {
            return;
        }
        PersistenceProject persistenceProject = this.getGenerator().getPersistenceProject();
        Connection connectionInfo = persistenceProject.getConnection();
        if (connectionInfo.isConnected()) {
            this.tableNameCombo.remove(1, this.tableNameCombo.getItemCount() - 1);
            Schema schema = connectionInfo.getDatabase().schemaNamed(persistenceProject.getSchemaName());
            if (schema != null) {
                Iterator stream = CollectionTools.sort((Iterator)schema.tableNames());
                while (stream.hasNext()) {
                    this.tableNameCombo.add((String)stream.next());
                }
            }
        }
        if ((tableName = this.getTableGenerator().getSpecifiedTableName()) != null) {
            if (!this.tableNameCombo.getText().equals(tableName)) {
                this.tableNameCombo.setText(tableName);
            }
        } else {
            this.tableNameCombo.select(0);
        }
        this.populating = false;
    }

    private void populatePkColumnNameCombo() {
        String pkColumnName;
        this.populating = true;
        if (this.getGenerator() == null) {
            return;
        }
        PersistenceProject persistenceProject = this.getGenerator().getPersistenceProject();
        Connection connectionInfo = persistenceProject.getConnection();
        if (connectionInfo.isConnected()) {
            this.pkColumnNameCombo.remove(1, this.pkColumnNameCombo.getItemCount() - 1);
            if (!this.tableNameCombo.getText().equals(DaliUiMessages.TableGeneratorComposite_default)) {
                Table table;
                String tableName = this.tableNameCombo.getText();
                Schema schema = connectionInfo.getDatabase().schemaNamed(persistenceProject.getSchemaName());
                if (schema != null && (table = schema.tableNamed(tableName)) != null) {
                    Iterator stream = CollectionTools.sort((Iterator)table.columnNames());
                    while (stream.hasNext()) {
                        this.pkColumnNameCombo.add((String)stream.next());
                    }
                }
            }
        }
        if ((pkColumnName = this.getTableGenerator().getSpecifiedPkColumnName()) != null) {
            if (!this.pkColumnNameCombo.getText().equals(pkColumnName)) {
                this.pkColumnNameCombo.setText(pkColumnName);
            }
        } else {
            this.pkColumnNameCombo.select(0);
        }
        this.populating = false;
    }

    private void populateValueColumnNameCombo() {
        String valueColumnName;
        this.populating = true;
        if (this.getGenerator() == null) {
            return;
        }
        PersistenceProject persistenceProject = this.getGenerator().getPersistenceProject();
        Connection connectionInfo = persistenceProject.getConnection();
        if (connectionInfo.isConnected()) {
            this.valueColumnNameCombo.remove(1, this.valueColumnNameCombo.getItemCount() - 1);
            if (!this.tableNameCombo.getText().equals(DaliUiMessages.TableGeneratorComposite_default)) {
                Table table;
                String tableName = this.tableNameCombo.getText();
                Schema schema = connectionInfo.getDatabase().schemaNamed(persistenceProject.getSchemaName());
                if (schema != null && (table = schema.tableNamed(tableName)) != null) {
                    Iterator stream = CollectionTools.sort((Iterator)table.columnNames());
                    while (stream.hasNext()) {
                        this.valueColumnNameCombo.add((String)stream.next());
                    }
                }
            }
        }
        if ((valueColumnName = this.getTableGenerator().getSpecifiedValueColumnName()) != null) {
            if (!this.valueColumnNameCombo.getText().equals(valueColumnName)) {
                this.valueColumnNameCombo.setText(valueColumnName);
            }
        } else {
            this.valueColumnNameCombo.select(0);
        }
        this.populating = false;
    }

    private void populatePkColumnValueCombo() {
        if (this.getGenerator() == null) {
            return;
        }
        String pkColumnValue = this.getTableGenerator().getSpecifiedPkColumnValue();
        if (pkColumnValue != null) {
            if (!this.pkColumnValueCombo.getText().equals(pkColumnValue)) {
                this.pkColumnValueCombo.setText(pkColumnValue);
            }
        } else {
            this.pkColumnValueCombo.select(0);
        }
    }

    protected TableGenerator getTableGenerator() {
        return (TableGenerator)this.getGenerator();
    }

    protected void clear() {
        super.clear();
        this.tableNameCombo.select(0);
    }

    private void addConnectionListener() {
        this.connection = this.getGenerator().getPersistenceProject().getConnection();
        this.connection.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.connection.removeConnectionListener(this.connectionListener);
        this.connection = null;
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                TableGeneratorComposite.this.populateTableNameCombo();
                TableGeneratorComposite.this.populatePkColumnNameCombo();
                TableGeneratorComposite.this.populateValueColumnNameCombo();
            }

            public void disconnected(Connection connection) {
                TableGeneratorComposite.this.populateTableNameCombo();
                TableGeneratorComposite.this.populatePkColumnNameCombo();
                TableGeneratorComposite.this.populateValueColumnNameCombo();
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                TableGeneratorComposite.this.populateTableNameCombo();
                TableGeneratorComposite.this.populatePkColumnNameCombo();
                TableGeneratorComposite.this.populateValueColumnNameCombo();
            }

            public void tableChanged(Table table) {
            }

            public void databaseAdded(Connection connection, Database database) {
                TableGeneratorComposite.this.populateTableNameCombo();
                TableGeneratorComposite.this.populatePkColumnNameCombo();
                TableGeneratorComposite.this.populateValueColumnNameCombo();
            }

            public void databaseRemove(Connection connection, Database database) {
                TableGeneratorComposite.this.populateTableNameCombo();
                TableGeneratorComposite.this.populatePkColumnNameCombo();
                TableGeneratorComposite.this.populateValueColumnNameCombo();
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }
        };
    }
}

