/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.dump;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipException;
import org.eclipse.virgo.kernel.services.work.WorkArea;
import org.eclipse.virgo.kernel.userregion.internal.DumpExtractor;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.io.ZipUtils;

public final class StandardDumpExtractor
implements DumpExtractor {
    private final File stagingDir;

    public StandardDumpExtractor(WorkArea workArea) {
        this.stagingDir = workArea.getWorkDirectory().newChild("extracted-state-dumps").createDirectory().toFile();
    }

    @Override
    public File getStateDump(File dump) throws ZipException, IOException {
        File stateDumpZipFile = this.getDumpFile(dump, "osgi.zip");
        return this.unzip(stateDumpZipFile);
    }

    private File getDumpFile(File dumpDirectory, final String fileName) throws IOException {
        if (dumpDirectory == null) {
            throw new IllegalArgumentException("Requested dump cannot be null");
        }
        File[] dumpFiles = FileSystemUtils.listFiles((File)dumpDirectory, (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(fileName);
            }
        });
        if (dumpFiles.length != 1) {
            throw new IOException(String.format("Exactly one dump file with name '%s' expected, found '%s'", fileName, dumpFiles.length));
        }
        return dumpFiles[0];
    }

    private File unzip(File stateDumpZipFile) throws IOException {
        PathReference zipFile = new PathReference(stateDumpZipFile);
        PathReference dest = new PathReference(this.stagingDir);
        return new File(ZipUtils.unzipTo((PathReference)zipFile, (PathReference)dest).toFile(), "state");
    }

    @Override
    public File getRegionDigraphDump(File dump) throws IOException {
        return this.getDumpFile(dump, "region.digraph");
    }
}

