/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.management.internal;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.BundleArtifact;
import org.eclipse.virgo.kernel.model.CompositeArtifact;
import org.eclipse.virgo.kernel.model.internal.ArtifactRepositoryListener;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableArtifact;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableBundleArtifact;
import org.eclipse.virgo.kernel.model.management.internal.DelegatingManageableCompositeArtifact;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxArtifactRepositoryListener
implements ArtifactRepositoryListener {
    private final Logger logger;
    private final MBeanServer server;
    private final RuntimeArtifactModelObjectNameCreator artifactObjectNameCreator;

    public JmxArtifactRepositoryListener(@NonNull RuntimeArtifactModelObjectNameCreator artifactObjectNameCreator) {
        RuntimeArtifactModelObjectNameCreator runtimeArtifactModelObjectNameCreator = artifactObjectNameCreator;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactModelObjectNameCreator);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.server = ManagementFactory.getPlatformMBeanServer();
            this.artifactObjectNameCreator = artifactObjectNameCreator;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void added(Artifact artifact) {
        try {
            ObjectName objectName = this.getModelObjectName(artifact);
            try {
                if (artifact instanceof CompositeArtifact) {
                    this.server.registerMBean(new DelegatingManageableCompositeArtifact(this.artifactObjectNameCreator, (CompositeArtifact)artifact), objectName);
                } else if (artifact instanceof BundleArtifact) {
                    this.server.registerMBean(new DelegatingManageableBundleArtifact(this.artifactObjectNameCreator, (BundleArtifact)artifact), objectName);
                } else {
                    this.server.registerMBean(new DelegatingManageableArtifact(this.artifactObjectNameCreator, artifact), objectName);
                }
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.error(String.format("Unable to register '%s'", objectName.toString()), (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void removed(Artifact artifact) {
        try {
            ObjectName objectName = this.getModelObjectName(artifact);
            try {
                this.server.unregisterMBean(objectName);
            }
            catch (MBeanRegistrationException e) {
                this.logger.error(String.format("Unable to unregister '%s'", objectName.toString()), (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.error(String.format("Unable to unregister '%s'", objectName.toString()), (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void destroy() {
        try {
            Set<ObjectName> objectNames = this.server.queryNames(this.artifactObjectNameCreator.createAllArtifactsQuery(), null);
            for (ObjectName objectName : objectNames) {
                try {
                    this.server.unregisterMBean(objectName);
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ObjectName getModelObjectName(Artifact artifact) {
        try {
            ObjectName objectName = this.artifactObjectNameCreator.createArtifactModel(artifact);
            return objectName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

