/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.virgo.management.console.Activator;
import org.eclipse.virgo.management.console.ContentServlet;
import org.eclipse.virgo.management.console.IndexServlet;
import org.eclipse.virgo.management.console.ResourceServlet;
import org.eclipse.virgo.management.console.UploadServlet;
import org.eclipse.virgo.management.console.internal.AdminHttpContext;
import org.jolokia.osgi.servlet.JolokiaServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    protected static final String APPLICATION_NAME = "Virgo Admin Console";
    private static final String CONTENT_CONTEXT_PATH = "/content";
    private static final String RESOURCES_CONTEXT_PATH = "/resources";
    private static final String UPLOAD_CONTEXT_PATH = "/upload";
    private static final String JOLOKIA_CONTEXT_PATH = "/jolokia";
    protected static String contextPath = null;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private ServiceTracker<URLStreamHandlerService, URLStreamHandlerService> urlEncoderServiceTracker;
    private transient HttpService registeredHttpService = null;
    private transient boolean isRegisteredWithHttpService = false;
    private final Object lock = new Object();
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        contextPath = (String)this.bundleContext.getBundle().getHeaders().get("Web-ContextPath");
        this.httpServiceTracker = new ServiceTracker(context, HttpService.class, (ServiceTrackerCustomizer)new HttpServiceTrackerCustomizer(this, context));
        Filter createFilter = context.createFilter("(&(objectClass=" + URLStreamHandlerService.class.getSimpleName() + ")(url.handler.protocol=webbundle))");
        this.urlEncoderServiceTracker = new ServiceTracker(context, createFilter, (ServiceTrackerCustomizer)new UrlEncoderServiceTrackerCustomizer(this, context));
        this.httpServiceTracker.open();
        this.urlEncoderServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        this.urlEncoderServiceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithHttpService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registeredHttpService != null) {
                try {
                    AdminHttpContext adminHttpContext = new AdminHttpContext(this.bundleContext.getBundle());
                    Hashtable<String, String> contentServletInitParams = new Hashtable<String, String>();
                    ((Dictionary)contentServletInitParams).put("prefix", "/WEB-INF/layouts");
                    ((Dictionary)contentServletInitParams).put("suffix", ".html");
                    ContentServlet contentServlet = new ContentServlet();
                    this.registeredHttpService.registerServlet(contextPath, (Servlet)new IndexServlet(contentServlet), null, (HttpContext)adminHttpContext);
                    this.registeredHttpService.registerServlet(String.valueOf(contextPath) + CONTENT_CONTEXT_PATH, (Servlet)contentServlet, contentServletInitParams, (HttpContext)adminHttpContext);
                    this.registeredHttpService.registerServlet(String.valueOf(contextPath) + RESOURCES_CONTEXT_PATH, (Servlet)new ResourceServlet(), null, (HttpContext)adminHttpContext);
                    this.registeredHttpService.registerServlet(String.valueOf(contextPath) + UPLOAD_CONTEXT_PATH, (Servlet)new UploadServlet(this.bundleContext), null, (HttpContext)adminHttpContext);
                    this.registeredHttpService.registerServlet(String.valueOf(contextPath) + JOLOKIA_CONTEXT_PATH, (Servlet)new JolokiaServlet(this.bundleContext), null, null);
                    this.isRegisteredWithHttpService = true;
                    log.info("Admin console registered to HttpService: " + contextPath);
                }
                catch (Exception e) {
                    log.error("Failed to register AdminConsole with HttpService", (Throwable)e);
                    this.unRegisterWithHttpService();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterWithHttpService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registeredHttpService != null) {
                this.doSafeUnregister(String.valueOf(contextPath) + CONTENT_CONTEXT_PATH);
                this.doSafeUnregister(String.valueOf(contextPath) + RESOURCES_CONTEXT_PATH);
                this.doSafeUnregister(String.valueOf(contextPath) + UPLOAD_CONTEXT_PATH);
                this.doSafeUnregister(String.valueOf(contextPath) + JOLOKIA_CONTEXT_PATH);
                this.doSafeUnregister(contextPath);
            }
            this.isRegisteredWithHttpService = false;
            log.info("Admin console unregistering from HttpService at " + contextPath);
        }
    }

    private void doSafeUnregister(String path) {
        try {
            this.registeredHttpService.unregister(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Failed to unregister '" + path + "' from HttpService");
        }
    }

    static /* synthetic */ ServiceTracker access$0(Activator activator) {
        return activator.urlEncoderServiceTracker;
    }

    static /* synthetic */ boolean access$1(Activator activator) {
        return activator.isRegisteredWithHttpService;
    }

    static /* synthetic */ void access$2(Activator activator, HttpService httpService) {
        activator.registeredHttpService = httpService;
    }

    static /* synthetic */ void access$3(Activator activator) {
        activator.registerWithHttpService();
    }

    static /* synthetic */ HttpService access$4(Activator activator) {
        return activator.registeredHttpService;
    }

    static /* synthetic */ void access$5(Activator activator) {
        activator.unRegisterWithHttpService();
    }
}

