/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.splash;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    private ByteArrayOutputStream byteStream = null;
    private GZIPOutputStream gzipStream = null;
    private boolean closed = false;
    private HttpServletResponse response = null;
    private ServletOutputStream servletStream = null;

    public GZIPResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.servletStream = response.getOutputStream();
        this.byteStream = new ByteArrayOutputStream();
        this.gzipStream = new GZIPOutputStream(this.byteStream);
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        this.gzipStream.finish();
        byte[] bytes = this.byteStream.toByteArray();
        this.response.setContentLength(bytes.length);
        this.response.addHeader("Content-Encoding", "gzip");
        this.servletStream.write(bytes);
        this.servletStream.flush();
        this.servletStream.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        this.gzipStream.flush();
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipStream.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipStream.write(b, off, len);
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener arg0) {
    }
}

