/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.permissionadmin;

import java.io.IOException;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionManager
implements PermissionAdminMBean {
    private PermissionAdmin admin;

    public PermissionManager(PermissionAdmin admin) {
        this.admin = admin;
    }

    public String[] listLocations() throws IOException {
        return this.admin.getLocations();
    }

    public String[] getPermissions(String location) throws IOException {
        if (location == null) {
            throw new IOException("Locatin must not be null");
        }
        PermissionInfo[] permissions = this.admin.getPermissions(location);
        if (permissions == null) {
            return null;
        }
        String[] encodedPermissions = new String[permissions.length];
        int i = 0;
        PermissionInfo[] permissionInfoArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionInfo permission = permissionInfoArray[n2];
            encodedPermissions[i++] = permission.getEncoded();
            ++n2;
        }
        return encodedPermissions;
    }

    public void setDefaultPermissions(String[] encodedPermissions) throws IOException {
        if (encodedPermissions == null) {
            throw new IOException("Encoded permissions must not be null");
        }
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        int i = 0;
        String[] stringArray = encodedPermissions;
        int n = encodedPermissions.length;
        int n2 = 0;
        while (n2 < n) {
            String encodedPermission = stringArray[n2];
            try {
                permissions[i] = new PermissionInfo(encodedPermission);
            }
            catch (Throwable e) {
                IOException iox = new IOException("Invalid encoded permission: " + encodedPermission);
                iox.initCause(e);
                throw iox;
            }
            ++n2;
        }
        this.admin.setDefaultPermissions(permissions);
    }

    public String[] listDefaultPermissions() throws IOException {
        PermissionInfo[] permissions = this.admin.getDefaultPermissions();
        if (permissions == null) {
            return null;
        }
        String[] encodedPermissions = new String[permissions.length];
        int i = 0;
        PermissionInfo[] permissionInfoArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionInfo permission = permissionInfoArray[n2];
            encodedPermissions[i++] = permission.getEncoded();
            ++n2;
        }
        return encodedPermissions;
    }

    public void setPermissions(String location, String[] encodedPermissions) throws IOException {
        if (location == null) {
            throw new IOException("Location must not be null");
        }
        if (encodedPermissions == null) {
            throw new IOException("Encoded permissions must not be null");
        }
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        int i = 0;
        String[] stringArray = encodedPermissions;
        int n = encodedPermissions.length;
        int n2 = 0;
        while (n2 < n) {
            String encodedPermission = stringArray[n2];
            try {
                permissions[i] = new PermissionInfo(encodedPermission);
            }
            catch (Throwable e) {
                IOException iox = new IOException("Invalid encoded permission: " + encodedPermission);
                iox.initCause(e);
                throw iox;
            }
            ++n2;
        }
        this.admin.setPermissions(location, permissions);
    }
}

