/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.BundleInstallArtifactGatheringGraphVisitor;
import org.eclipse.virgo.kernel.osgi.framework.ImportExpander;
import org.eclipse.virgo.kernel.osgi.framework.ImportMergeException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

final class ImportExpandingTransformer
implements Transformer {
    private final ImportExpander importExpander;

    ImportExpandingTransformer(ImportExpander importExpander) {
        this.importExpander = importExpander;
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new ImportExpandingGraphVisitor(installEnvironment));
    }

    void expandImportsOfBundlesInScopedPlan(GraphNode<InstallArtifact> planGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        BundleInstallArtifactGatheringGraphVisitor visitor = new BundleInstallArtifactGatheringGraphVisitor();
        planGraph.visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        this.expandImports(visitor.getChildBundles(), installEnvironment);
    }

    void expandImports(Set<BundleInstallArtifact> bundleInstallArtifacts, InstallEnvironment installEnvironment) throws DeploymentException {
        ArrayList<BundleManifest> bundleManifestList = new ArrayList<BundleManifest>(bundleInstallArtifacts.size());
        for (BundleInstallArtifact bundleInstallArtifact : bundleInstallArtifacts) {
            try {
                BundleManifest bundleManifest = bundleInstallArtifact.getBundleManifest();
                bundleManifestList.add(bundleManifest);
            }
            catch (IOException e) {
                installEnvironment.getInstallLog().log(this, "I/O error getting bundle manifest for  %s", bundleInstallArtifact.toString());
                throw new DeploymentException("I/O error getting bundle manifest for " + bundleInstallArtifact, (Throwable)e);
            }
        }
        try {
            this.importExpander.expandImports(bundleManifestList);
            installEnvironment.getInstallLog().log(this, "Expanded imports of %s", bundleInstallArtifacts.toString());
        }
        catch (ImportMergeException e) {
            installEnvironment.getInstallLog().log(this, "Error in %s merging expanded imports for package %s from %s", bundleInstallArtifacts.toString(), e.getConflictingPackageName(), e.getSources());
            throw new DeploymentException("Error merging expanded imports for " + bundleInstallArtifacts, (Throwable)e);
        }
        catch (UnableToSatisfyDependenciesException e) {
            installEnvironment.getInstallLog().log(this, "Unsatisfied dependencies in %s: %s", bundleInstallArtifacts.toString(), e.getFailureDescription());
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private final class ImportExpandingGraphVisitor
    implements GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException> {
        private final InstallEnvironment installEnvironment;

        ImportExpandingGraphVisitor(InstallEnvironment installEnvironment) {
            this.installEnvironment = installEnvironment;
        }

        public boolean visit(GraphNode<InstallArtifact> graph) throws DeploymentException {
            if (graph.getValue() instanceof PlanInstallArtifact) {
                PlanInstallArtifact planInstallArtifact = (PlanInstallArtifact)graph.getValue();
                if (planInstallArtifact.isScoped()) {
                    ImportExpandingTransformer.this.expandImportsOfBundlesInScopedPlan(graph, this.installEnvironment);
                    return false;
                }
            } else if (graph.getValue() instanceof BundleInstallArtifact) {
                ImportExpandingTransformer.this.expandImports(Collections.singleton((BundleInstallArtifact)graph.getValue()), this.installEnvironment);
            }
            return true;
        }
    }
}

