/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import java.lang.instrument.ClassFileTransformer;
import org.eclipse.gemini.blueprint.util.BundleDelegatingClassLoader;
import org.eclipse.virgo.kernel.osgi.framework.InstrumentableClassLoader;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.instrument.classloading.LoadTimeWeaver;

final class KernelLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware {
    private volatile InstrumentableClassLoader instrumentableClassLoader;

    KernelLoadTimeWeaver() {
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.instrumentableClassLoader.addClassFileTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return (ClassLoader)this.instrumentableClassLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.instrumentableClassLoader.createThrowAway();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        Bundle bundle;
        ClassLoader bundleClassLoader;
        InstrumentableClassLoader instrumentableClassLoader = null;
        if (classLoader instanceof InstrumentableClassLoader) {
            instrumentableClassLoader = (InstrumentableClassLoader)classLoader;
        } else if (classLoader instanceof BundleDelegatingClassLoader && (bundleClassLoader = this.getBundleClassLoader(bundle = ((BundleDelegatingClassLoader)classLoader).getBundle())) instanceof InstrumentableClassLoader) {
            instrumentableClassLoader = (InstrumentableClassLoader)bundleClassLoader;
        }
        if (instrumentableClassLoader == null) {
            throw new IllegalStateException("ClassLoader '" + classLoader + "' is not instrumentable.");
        }
        this.instrumentableClassLoader = instrumentableClassLoader;
    }

    private ClassLoader getBundleClassLoader(Bundle bundle) {
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(OsgiFramework.class);
        try {
            OsgiFramework framework = (OsgiFramework)bundleContext.getService(serviceReference);
            ClassLoader classLoader = framework.getBundleClassLoader(bundle);
            return classLoader;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }
}

