/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl;

import java.io.PrintStream;
import java.util.Locale;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.impl.ExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.LoggingLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TeeLoggingPrintStreamWrapper
extends PrintStream {
    private static final String GOGO_PACKAGE_NAME_PREFIX = "org.apache.felix.gogo";
    private static final String TEE_LOGGING_PRINT_STREAM_WRAPPER_NAME = "org.eclipse.virgo.medic.log.impl.TeeLoggingPrintStreamWrapper";
    private static final String LOGBACK_PACKAGE_NAME_PREFIX = "ch.qos.logback";
    private final ThreadLocal<StringBuilder> entryBuilders;
    private final Logger logger;
    private final ExecutionStackAccessor executionStackAccessor;
    private final ConfigurationProvider configurationProvider;
    private final String configurationProperty;
    private final PrintStream originalPrintStream;
    private final LoggingLevel loggingLevel;
    private static final String NULL_STRING = "null";

    public TeeLoggingPrintStreamWrapper(PrintStream printStream, String loggerName, LoggingLevel loggingLevel, ExecutionStackAccessor executionStackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        super(printStream);
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.loggingLevel = loggingLevel;
        this.executionStackAccessor = executionStackAccessor;
        this.entryBuilders = new StringBuilderThreadLocal();
        this.configurationProvider = configurationProvider;
        this.configurationProperty = configurationProperty;
        this.originalPrintStream = printStream;
    }

    public TeeLoggingPrintStreamWrapper(PrintStream printStream, String loggerName, ExecutionStackAccessor executionStackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        this(printStream, loggerName, LoggingLevel.DEBUG, executionStackAccessor, configurationProvider, configurationProperty);
    }

    @Override
    public PrintStream append(char c) {
        super.append(c);
        if (this.isLoggingEnabled()) {
            this.internalAppend(c);
        }
        return this;
    }

    private boolean internalAppend(char c) {
        if (c == '\n' || c == '\r') {
            this.createEntryAndLog(this.entryBuilders.get());
            return true;
        }
        this.entryBuilders.get().append(c);
        return false;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        super.append(csq, start, end);
        if (this.isLoggingEnabled()) {
            this.internalAppend(csq, start, end);
        }
        return this;
    }

    private void internalAppend(CharSequence csq, int start, int end) {
        int i = start;
        while (i < end) {
            char c;
            boolean loggedEntry = this.internalAppend(csq.charAt(i));
            if (loggedEntry && i < end - 1 && ((c = csq.charAt(i + 1)) == '\n' || c == '\r')) {
                ++i;
            }
            ++i;
        }
    }

    @Override
    public PrintStream append(CharSequence csq) {
        super.append(csq);
        if (this.isLoggingEnabled()) {
            if (csq == null) {
                throw new NullPointerException("Character Sequence to be added to the printStream from source '" + this.logger.getName() + "' is null");
            }
            this.internalAppend(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public boolean checkError() {
        if (this.isLoggingEnabled()) {
            return false;
        }
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        super.format(l, format, args);
        if (this.isLoggingEnabled()) {
            this.internalPrint(String.format(l, format, args));
        }
        return this;
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        super.format(format, args);
        if (this.isLoggingEnabled()) {
            this.internalPrint(String.format(format, args));
        }
        return this;
    }

    @Override
    public void print(boolean b) {
        super.print(b);
        if (this.isLoggingEnabled()) {
            this.internalPrint(b);
        }
    }

    private void internalPrint(boolean b) {
        this.entryBuilders.get().append(b);
    }

    @Override
    public void print(char c) {
        super.print(c);
        if (this.isLoggingEnabled()) {
            this.internalAppend(c);
        }
    }

    @Override
    public void print(char[] ca) {
        super.print(ca);
        if (this.isLoggingEnabled()) {
            this.internalPrint(ca);
        }
    }

    private void internalPrint(char[] ca) {
        String s = new String(ca);
        this.internalAppend(s, 0, s.length());
    }

    @Override
    public void print(double d) {
        super.print(d);
        if (this.isLoggingEnabled()) {
            this.internalPrint(d);
        }
    }

    private void internalPrint(double d) {
        this.entryBuilders.get().append(d);
    }

    @Override
    public void print(float f) {
        super.print(f);
        if (this.isLoggingEnabled()) {
            this.internalPrint(f);
        }
    }

    private void internalPrint(float f) {
        this.entryBuilders.get().append(f);
    }

    @Override
    public void print(int i) {
        super.print(i);
        if (this.isLoggingEnabled()) {
            this.internalPrint(i);
        }
    }

    private void internalPrint(int i) {
        this.entryBuilders.get().append(i);
    }

    @Override
    public void print(long l) {
        super.print(l);
        if (this.isLoggingEnabled()) {
            this.internalPrint(l);
        }
    }

    private void internalPrint(long l) {
        this.entryBuilders.get().append(l);
    }

    @Override
    public void print(Object obj) {
        super.print(obj);
        if (this.isLoggingEnabled()) {
            this.internalPrint(obj);
        }
    }

    private void internalPrint(Object obj) {
        if (obj == null) {
            this.entryBuilders.get().append(NULL_STRING);
        } else {
            this.internalPrint(obj.toString().toCharArray());
        }
    }

    @Override
    public void print(String s) {
        super.print(s);
        if (this.isLoggingEnabled()) {
            this.internalPrint(s);
        }
    }

    private void internalPrint(String s) {
        if (s == null) {
            s = NULL_STRING;
        }
        this.internalAppend(s, 0, s.length());
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        super.printf(l, format, args);
        if (this.isLoggingEnabled()) {
            this.internalPrint(String.format(l, format, args));
        }
        return this;
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        super.printf(format, args);
        if (this.isLoggingEnabled()) {
            this.internalPrint(String.format(format, args));
        }
        return this;
    }

    @Override
    public void println() {
        super.println();
        if (this.isLoggingEnabled()) {
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(boolean x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(char x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalAppend(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(char[] x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(double x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(float x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(int x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(long x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(Object x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    public void println(String x) {
        super.println(x);
        if (this.isLoggingEnabled()) {
            this.internalPrint(x);
            this.createEntryAndLog(this.entryBuilders.get());
        }
    }

    @Override
    protected void setError() {
        super.setError();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        if (this.isLoggingEnabled()) {
            byte[] outputBytes = new byte[len];
            System.arraycopy(buf, off, outputBytes, 0, len);
            this.internalPrint(new String(outputBytes));
        }
    }

    @Override
    public void write(int b) {
        super.write(b);
        if (this.isLoggingEnabled()) {
            if (b == 10 || b == 13) {
                this.createEntryAndLog(this.entryBuilders.get());
            } else {
                this.entryBuilders.get().append(new String(new byte[]{(byte)b}));
            }
        }
    }

    private void createEntryAndLog(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        switch (this.loggingLevel) {
            case DEBUG: {
                this.logger.debug(string);
                break;
            }
            case ERROR: {
                this.logger.error(string);
                break;
            }
            case INFO: {
                this.logger.info(string);
                break;
            }
            case WARNING: {
                this.logger.warn(string);
            }
        }
        this.entryBuilders.remove();
    }

    private boolean isLoggingEnabled() {
        return this.isEnabledInConfiguration() && !this.isWithinLogback() && !this.isWithinTeeOperation() && !this.isWithinGoGoCall();
    }

    private boolean isWithinLogback() {
        return this.isWithinCallContainingPackage(LOGBACK_PACKAGE_NAME_PREFIX);
    }

    private boolean isWithinGoGoCall() {
        return this.isWithinCallContainingPackage(GOGO_PACKAGE_NAME_PREFIX);
    }

    private boolean isWithinCallContainingPackage(String expectedPkg) {
        Class<?>[] executionStack;
        Class<?>[] classArray = executionStack = this.executionStackAccessor.getExecutionStack();
        int n = executionStack.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName;
            Class<?> clazz = classArray[n2];
            Package pkg = clazz.getPackage();
            if (pkg != null && (pkgName = pkg.getName()) != null && pkgName.startsWith(expectedPkg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isWithinTeeOperation() {
        Class<?>[] executionStack = this.executionStackAccessor.getExecutionStack();
        int i = 3;
        while (i < executionStack.length) {
            String className;
            Class<?> clazz = executionStack[i];
            if (clazz != null && (className = clazz.getCanonicalName()) != null && className.equals(TEE_LOGGING_PRINT_STREAM_WRAPPER_NAME)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnabledInConfiguration() {
        return "tee".equals((String)this.configurationProvider.getConfiguration().get(this.configurationProperty));
    }

    public PrintStream getOriginalPrintStream() {
        return this.originalPrintStream;
    }

    private static final class StringBuilderThreadLocal
    extends ThreadLocal<StringBuilder> {
        private StringBuilderThreadLocal() {
        }

        @Override
        public StringBuilder initialValue() {
            return new StringBuilder();
        }
    }
}

