/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.webjars.MultipleMatchesException;
import org.webjars.WebJarAssetLocator;

public class WebJarsResourceResolver
extends AbstractResourceResolver {
    private static final String WEBJARS_LOCATION = "META-INF/resources/webjars";
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars".length();
    private final WebJarAssetLocator webJarAssetLocator = new WebJarAssetLocator();

    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved == null && (webJarResourcePath = this.findWebJarResourcePath(requestPath)) != null) {
            return chain.resolveResource(request, webJarResourcePath, locations);
        }
        return resolved;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        String path = chain.resolveUrlPath(resourceUrlPath, locations);
        if (path == null && (webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath)) != null) {
            return chain.resolveUrlPath(webJarResourcePath, locations);
        }
        return path;
    }

    protected String findWebJarResourcePath(String path) {
        block5: {
            try {
                int startOffset = path.startsWith("/") ? 1 : 0;
                int endOffset = path.indexOf("/", 1);
                if (endOffset != -1) {
                    String webjar = path.substring(startOffset, endOffset);
                    String partialPath = path.substring(endOffset);
                    String webJarPath = this.webJarAssetLocator.getFullPath(webjar, partialPath);
                    return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
                }
            }
            catch (MultipleMatchesException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("WebJar version conflict for \"" + path + "\""), (Throwable)ex);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace((Object)("No WebJar resource found for \"" + path + "\""));
            }
        }
        return null;
    }
}

