/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.sshd.agent.AprLibrary;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentClient
extends Thread
implements SshAgent {
    private final String authSocket;
    private final long pool;
    private final long handle;
    private final Buffer receiveBuffer;
    private final Queue<Buffer> messages;
    private boolean closed;

    public AgentClient(String authSocket) throws IOException {
        try {
            this.authSocket = authSocket;
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            int result = Local.connect((long)this.handle, (long)0L);
            if (result != 0) {
                this.throwException(result);
            }
            this.receiveBuffer = new Buffer();
            this.messages = new ArrayBlockingQueue<Buffer>(10);
            this.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                byte[] buf = new byte[1024];
                while (!this.closed) {
                    int result = Socket.recv((long)this.handle, (byte[])buf, (int)0, (int)buf.length);
                    if (result < 0) {
                        this.throwException(result);
                    }
                    this.messageReceived(new Buffer(buf, 0, result));
                }
                Object var4_4 = null;
                this.close();
            }
            catch (Exception e) {
                if (!this.closed) {
                    e.printStackTrace();
                }
                Object var4_5 = null;
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(Buffer buffer) throws Exception {
        Buffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(buffer);
            if (this.receiveBuffer.available() >= 4) {
                int rpos = this.receiveBuffer.rpos();
                int len = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(rpos);
                if (this.receiveBuffer.available() >= 4 + len) {
                    message = new Buffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }

    @Override
    public List<SshAgent.Pair<PublicKey, String>> getIdentities() throws IOException {
        Buffer buffer = this.createBuffer((byte)11);
        byte type = (buffer = this.request(buffer)).getByte();
        if (type != 12) {
            throw new SshException("SSH agent failure");
        }
        int nbIdentities = buffer.getInt();
        if (nbIdentities > 1024) {
            throw new SshException("SSH agent failure");
        }
        ArrayList<SshAgent.Pair<PublicKey, String>> keys = new ArrayList<SshAgent.Pair<PublicKey, String>>();
        for (int i = 0; i < nbIdentities; ++i) {
            PublicKey key = buffer.getPublicKey();
            keys.add(new SshAgent.Pair<PublicKey, String>(key, buffer.getString()));
        }
        return keys;
    }

    @Override
    public byte[] sign(PublicKey key, byte[] data) throws IOException {
        Buffer buffer = this.createBuffer((byte)13);
        buffer.putPublicKey(key);
        buffer.putBytes(data);
        buffer.putInt(0L);
        buffer = this.request(buffer);
        if (buffer.getByte() != 14) {
            throw new SshException("SSH agent failure");
        }
        Buffer buf = new Buffer(buffer.getBytes());
        buf.getString();
        return buf.getBytes();
    }

    @Override
    public void addIdentity(KeyPair key, String comment) throws IOException {
        Buffer buffer = this.createBuffer((byte)17);
        buffer.putKeyPair(key);
        buffer.putString(comment);
        buffer = this.request(buffer);
        if (buffer.available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        Buffer buffer = this.createBuffer((byte)18);
        buffer.putPublicKey(key);
        buffer = this.request(buffer);
        if (buffer.available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void removeAllIdentities() throws IOException {
        Buffer buffer = this.createBuffer((byte)19);
        if ((buffer = this.request(buffer)).available() != 1 || buffer.getByte() != 6) {
            throw new SshException("SSH agent failure");
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            Socket.close((long)this.handle);
        }
    }

    protected Buffer createBuffer(byte cmd) {
        Buffer buffer = new Buffer();
        buffer.putInt(0L);
        buffer.putByte(cmd);
        return buffer;
    }

    protected synchronized Buffer request(Buffer buffer) throws IOException {
        int wpos = buffer.wpos();
        buffer.wpos(0);
        buffer.putInt(wpos - 4);
        buffer.wpos(wpos);
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            try {
                int result = Socket.send((long)this.handle, (byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
                if (result < 0) {
                    this.throwException(result);
                }
                if (this.messages.isEmpty()) {
                    this.messages.wait();
                }
                return this.messages.poll();
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

