/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.util.Date;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class CronTrigger
implements Trigger {
    private final CronSequenceGenerator sequenceGenerator;

    public CronTrigger(String cronExpression) {
        this.sequenceGenerator = new CronSequenceGenerator(cronExpression);
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        Date date = triggerContext.lastCompletionTime();
        if (date == null) {
            date = new Date();
        }
        return this.sequenceGenerator.next(date);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CronTrigger && this.sequenceGenerator.equals(((CronTrigger)obj).sequenceGenerator);
    }

    public int hashCode() {
        return this.sequenceGenerator.hashCode();
    }
}

