/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyPlaceholderResolver {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([^:\\}]*):?([^\\}]*)?\\}");
    private static final PlaceholderValueTransformer IDENTITY_TRANSFORMER = new PlaceholderValueTransformer(){

        public String transform(String propertyName, String propertyValue, String modifier) {
            return propertyValue;
        }
    };

    public Properties resolve(Properties input) {
        return this.resolve(input, IDENTITY_TRANSFORMER);
    }

    public Properties resolve(Properties input, PlaceholderValueTransformer transformer) {
        Properties result = new Properties();
        Enumeration<?> propertyNames = input.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            result.setProperty(propertyName, this.resolveProperty(propertyName, input, transformer));
        }
        return result;
    }

    public String resolve(String input, Properties props) {
        return this.resolve(input, props, IDENTITY_TRANSFORMER);
    }

    public String resolve(String input, Properties props, PlaceholderValueTransformer transformer) {
        String key = UUID.randomUUID().toString();
        props.put(key, input);
        String value = this.resolveProperty(key, props, transformer);
        props.remove(key);
        return value;
    }

    private String resolveProperty(String name, Properties props, PlaceholderValueTransformer transformer) {
        Stack<String> visitState = new Stack<String>();
        return this.resolve(name, props, transformer, visitState);
    }

    private String resolve(String name, Properties props, PlaceholderValueTransformer transformer, Stack<String> visitState) {
        visitState.push(name);
        String initialValue = props.getProperty(name);
        if (initialValue == null) {
            throw new RuntimeException("No value found for placeholder '" + name + "'");
        }
        Matcher matcher = PATTERN.matcher(initialValue);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String propName = matcher.group(1);
            if (visitState.contains(propName)) {
                throw new IllegalArgumentException(this.formatPropertyCycleMessage(visitState));
            }
            String value = this.resolve(propName, props, transformer, visitState);
            if (matcher.group(2).length() > 0) {
                value = transformer.transform(propName, value, matcher.group(2));
            }
            matcher.appendReplacement(sb, PropertyPlaceholderResolver.escapeBackslashes(value));
        }
        matcher.appendTail(sb);
        visitState.pop();
        return sb.toString();
    }

    private static String escapeBackslashes(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        int bsIndex = string.indexOf("\\");
        int pos = 0;
        while (bsIndex != -1) {
            sb.append(string.substring(pos, bsIndex + 1));
            sb.append("\\");
            pos = bsIndex + 1;
            bsIndex = string.indexOf("\\", pos);
        }
        sb.append(string.substring(pos, string.length()));
        return new String(sb);
    }

    private String formatPropertyCycleMessage(Stack<String> visitState) {
        StringBuilder sb = new StringBuilder();
        sb.append("Circular reference in property definitions: ");
        for (String name : visitState) {
            sb.append(name).append(" -> ");
        }
        sb.append((String)visitState.iterator().next());
        return sb.toString();
    }

    public static interface PlaceholderValueTransformer {
        public String transform(String var1, String var2, String var3);
    }
}

