/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleClasspathHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.pde.internal.ui.editor.plugin.BundleSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionHyperLink;
import org.eclipse.pde.internal.ui.editor.plugin.PluginFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleObject;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportLibraryObject;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditorContributor;
import org.eclipse.virgo.ide.ui.editors.SpringBundleFoldingStructureProvider;
import org.eclipse.virgo.ide.ui.editors.SpringBundleHyperlinkDetector;
import org.eclipse.virgo.ide.ui.editors.text.BundleColorManager;
import org.eclipse.virgo.ide.ui.editors.text.BundleManifestConfiguration;
import org.eclipse.virgo.ide.ui.internal.actions.ManifestFormatAction;

public class SpringBundleSourcePage
extends BundleSourcePage {
    private final String ID_CONTEXT_MENU = "org.eclipse.virgo.ide.bundlemanifest.text.menu";
    private IFoldingStructureProvider fFoldingStructureProvider;
    private final ChangeAwareSourceViewerConfiguration fConfiguration = this.createSourceViewerConfiguration(BundleColorManager.getDefault());

    public SpringBundleSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        if (this.fConfiguration != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fConfiguration);
        }
    }

    protected ChangeAwareSourceViewerConfiguration createSourceViewerConfiguration(IColorManager colorManager) {
        return new BundleManifestConfiguration(colorManager, (PDESourcePage)this);
    }

    protected void setEditorContextMenuId(String contextMenuId) {
        super.setEditorContextMenuId("org.eclipse.virgo.ide.bundlemanifest.text.menu");
    }

    public void projectionEnabled() {
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof IEditingModel) {
            this.fFoldingStructureProvider = this.getFoldingStructureProvider((IEditingModel)model);
            if (this.fFoldingStructureProvider != null) {
                this.fFoldingStructureProvider.initialize();
                IReconciler rec = this.getSourceViewerConfiguration().getReconciler(this.getSourceViewer());
                IReconcilingStrategy startegy = rec.getReconcilingStrategy(new String());
                if (startegy instanceof ReconcilingStrategy) {
                    ((ReconcilingStrategy)startegy).addParticipant((IReconcilingParticipant)this.fFoldingStructureProvider);
                }
            }
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider(IEditingModel model) {
        if (model instanceof PluginModel) {
            return new PluginFoldingStructureProvider((PDESourcePage)this, model);
        }
        if (model instanceof BundleModel) {
            return new SpringBundleFoldingStructureProvider((PDESourcePage)this, model);
        }
        return null;
    }

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (this.fConfiguration == null) {
            return false;
        }
        return this.fConfiguration.affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    public void dispose() {
        if (this.fConfiguration != null) {
            this.fConfiguration.dispose();
        }
        super.dispose();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            ISourceViewer sourceViewer;
            if (this.fConfiguration != null && (sourceViewer = this.getSourceViewer()) != null) {
                this.fConfiguration.adaptToPreferenceChange(event);
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        PDEFormEditorContributor contributor = ((PDEFormEditor)this.getEditor()).getContributor();
        if (contributor instanceof BundleManifestEditorContributor) {
            ManifestFormatAction formatManifestAction;
            BundleManifestEditorContributor textContributor = (BundleManifestEditorContributor)contributor;
            HyperlinkAction action = textContributor.getHyperlinkAction();
            if (action != null && action.isEnabled() && !(action.getHyperLink() instanceof ExtensionHyperLink)) {
                menu.add((IAction)action);
            }
            if ((formatManifestAction = textContributor.getFormatAction()) != null && formatManifestAction.isEnabled()) {
                menu.insertAfter("org.eclipse.pde.ui.quickOutline", (IAction)formatManifestAction);
            }
        }
    }

    protected void createActions() {
        super.createActions();
        PDEFormEditorContributor contributor = ((PDEFormEditor)this.getEditor()).getContributor();
        if (contributor instanceof BundleManifestEditorContributor) {
            BundleManifestEditorContributor textContributor = (BundleManifestEditorContributor)contributor;
            this.setAction("org.eclipse.pde.ui.actions.Open", (IAction)textContributor.getHyperlinkAction());
            this.setAction("org.eclipse.pde.ui.actions.Format", (IAction)textContributor.getFormatAction());
            if (textContributor.supportsContentAssist()) {
                this.createContentAssistAction();
            }
        }
    }

    private void createContentAssistAction() {
        ContentAssistAction contentAssist = new ContentAssistAction(SpringBundleSourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        contentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)contentAssist);
        this.markAsStateDependentAction("ContentAssist", true);
    }

    public ILabelProvider createOutlineLabelProvider() {
        return new SpringBundleLabelProvider();
    }

    public ITreeContentProvider createOutlineContentProvider() {
        return new SpringBundleOutlineContentProvider();
    }

    public IDocumentRange findRange() {
        Field field = null;
        Class<?> classAncestor = ((Object)((Object)this)).getClass();
        while (classAncestor != Object.class) {
            try {
                field = classAncestor.getDeclaredField("fSelection");
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                classAncestor = classAncestor.getSuperclass();
            }
        }
        if (field != null) {
            Object selection;
            field.setAccessible(true);
            try {
                selection = field.get((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException("Internal Error", e);
            }
            if (selection instanceof ImportLibraryObject) {
                return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ImportLibraryObject)selection).getModel(), (String)"Import-Library", (String)((ImportLibraryObject)selection).getId());
            }
            if (selection instanceof ImportBundleObject) {
                return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ImportBundleObject)selection).getModel(), (String)"Import-Bundle", (String)((ImportBundleObject)selection).getId());
            }
            if (selection instanceof ImportPackageObject) {
                ImportPackageObject impObj = (ImportPackageObject)selection;
                String key = impObj.getHeader().getKey();
                if (key != null && key.equalsIgnoreCase("Import-Template")) {
                    return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ImportPackageObject)selection).getModel(), (String)"Import-Template", (String)((ImportPackageObject)selection).getValue());
                }
                if (key != null && key.equalsIgnoreCase("Excluded-Imports")) {
                    return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ImportPackageObject)selection).getModel(), (String)"Excluded-Imports", (String)((ImportPackageObject)selection).getValue());
                }
                if (key != null && key.equalsIgnoreCase("Unversioned-Imports")) {
                    return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ImportPackageObject)selection).getModel(), (String)"Unversioned-Imports", (String)((ImportPackageObject)selection).getValue());
                }
            } else if (selection instanceof ExportPackageObject) {
                ExportPackageObject expObj = (ExportPackageObject)selection;
                String key = expObj.getHeader().getKey();
                if (key != null && key.equalsIgnoreCase("Export-Template")) {
                    return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ExportPackageObject)selection).getModel(), (String)"Export-Template", (String)((ExportPackageObject)selection).getValue());
                }
                if (key != null && key.equalsIgnoreCase("Excluded-Exports")) {
                    return SpringBundleSourcePage.getSpecificRange((IBundleModel)((ExportPackageObject)selection).getModel(), (String)"Excluded-Exports", (String)((ExportPackageObject)selection).getValue());
                }
            }
        }
        return super.findRange();
    }

    private IPluginLibrary[] getBundleClasspathLibraries() {
        PDEFormEditor formEditor;
        IBaseModel baseModel;
        FormEditor editor = this.getEditor();
        if (editor instanceof PDEFormEditor && (baseModel = (formEditor = (PDEFormEditor)editor).getAggregateModel()) instanceof IPluginModelBase) {
            IPluginLibrary[] libraries = ((IPluginModelBase)baseModel).getPluginBase().getLibraries();
            return libraries;
        }
        return null;
    }

    private boolean isSpringHeader(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.virgo.ide.ui.editors.text.headers");
        ArrayList<String> headers = Collections.list(bundle.getKeys());
        return headers.contains(key);
    }

    public Object getAdapter(Class adapter) {
        if (IHyperlinkDetector.class.equals((Object)adapter)) {
            return new SpringBundleHyperlinkDetector((PDESourcePage)this);
        }
        return super.getAdapter(adapter);
    }

    private class SpringBundleLabelProvider
    extends LabelProvider {
        private SpringBundleLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof PackageObject) {
                return ((PackageObject)obj).getName();
            }
            if (obj instanceof ExecutionEnvironment) {
                return ((ExecutionEnvironment)obj).getName();
            }
            if (obj instanceof RequireBundleObject) {
                return this.getTextRequireBundle((RequireBundleObject)obj);
            }
            if (obj instanceof ImportLibraryObject) {
                return ((ImportLibraryObject)obj).getId();
            }
            if (obj instanceof ImportBundleObject) {
                return ((ImportBundleObject)obj).getId();
            }
            if (obj instanceof ManifestHeader) {
                return ((ManifestHeader)obj).getName();
            }
            return super.getText(obj);
        }

        private String getTextRequireBundle(RequireBundleObject bundle) {
            StringBuffer label = new StringBuffer();
            label.append(bundle.getId());
            String version = bundle.getVersion();
            if (version == null || version.length() == 0) {
                return label.toString();
            }
            label.append(' ');
            char firstChar = version.charAt(0);
            if (firstChar != '(' && firstChar != '[') {
                label.append('(');
            }
            label.append(version);
            char lastChar = version.charAt(version.length() - 1);
            if (lastChar != ')' && lastChar != ']') {
                label.append(')');
            }
            return label.toString();
        }

        public Image getImage(Object obj) {
            PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
            if (obj instanceof PackageObject) {
                return labelProvider.get(PDEPluginImages.DESC_PACKAGE_OBJ);
            }
            if (obj instanceof ExecutionEnvironment) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            if (obj instanceof RequireBundleObject) {
                int flags = 32;
                if (((RequireBundleObject)obj).isReexported()) {
                    flags |= 4;
                }
                return labelProvider.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ, flags);
            }
            if (obj instanceof ImportLibraryObject) {
                return labelProvider.get(PDEPluginImages.DESC_JAR_LIB_OBJ);
            }
            if (obj instanceof ImportBundleObject) {
                return labelProvider.get(PDEPluginImages.DESC_BUNDLE_OBJ);
            }
            if (obj instanceof ManifestHeader) {
                if (SpringBundleSourcePage.this.isSpringHeader(((ManifestHeader)obj).getKey())) {
                    return labelProvider.get(ServerIdeUiPlugin.getImageDescriptor("full/view16/green_ball_obj.gif"));
                }
                return labelProvider.get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            if (obj instanceof IPluginLibrary) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            return null;
        }
    }

    private class SpringBundleOutlineContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        private SpringBundleOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ImportPackageHeader) {
                return ((ImportPackageHeader)parent).getPackages();
            }
            if (parent instanceof ExportPackageHeader) {
                return ((ExportPackageHeader)parent).getPackages();
            }
            if (parent instanceof RequiredExecutionEnvironmentHeader) {
                return ((RequiredExecutionEnvironmentHeader)parent).getEnvironments();
            }
            if (parent instanceof RequireBundleHeader) {
                return ((RequireBundleHeader)parent).getRequiredBundles();
            }
            if (parent instanceof BundleClasspathHeader) {
                return this.getPluginLibraries();
            }
            if (parent instanceof ImportBundleHeader) {
                return ((ImportBundleHeader)parent).getImportedBundles();
            }
            if (parent instanceof ImportLibraryHeader) {
                return ((ImportLibraryHeader)parent).getImportedLibraries();
            }
            return new Object[0];
        }

        private Object[] getPluginLibraries() {
            Object[] libraries = SpringBundleSourcePage.this.getBundleClasspathLibraries();
            if (libraries == null || libraries.length == 0) {
                return new Object[0];
            }
            return libraries;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof BundleModel) {
                BundleModel model = (BundleModel)parent;
                Map manifest = ((Bundle)model.getBundle()).getHeaders();
                ArrayList<IDocumentKey> keys = new ArrayList<IDocumentKey>();
                Iterator elements = manifest.keySet().iterator();
                while (elements.hasNext()) {
                    IDocumentKey key = (IDocumentKey)manifest.get(elements.next());
                    if (key.getOffset() <= -1) continue;
                    keys.add(key);
                }
                return keys.toArray();
            }
            return new Object[0];
        }
    }
}

