/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.StatusHandler;
import org.eclipse.virgo.ide.ui.editors.BundleImportLibrarySection;
import org.eclipse.virgo.ide.ui.editors.BundleImportPackageSection;
import org.eclipse.virgo.ide.ui.editors.BundleImportSection;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.virgo.ide.ui.editors.IBundleManifestSaveListener;
import org.eclipse.virgo.ide.ui.editors.ManifestEditorUtils;

public class BundleDependenciesPage
extends PDEFormPage
implements IBundleManifestSaveListener {
    public static final String PAGE_ID = "bundle_dependencies";
    private BundleImportPackageSection bundleImportPackageSection = null;
    private BundleImportSection bundleImportSection = null;
    private BundleImportLibrarySection bundleImportLibrarySection = null;
    protected ScrolledForm form = null;
    protected IResource resource = null;
    private static final String MANIFEST_ERRORS = "Dependencies: Please correct one or more errors in the manifest";

    public BundleDependenciesPage(FormEditor editor) {
        super(editor, PAGE_ID, "Dependencies");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        this.form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ));
        this.form.setText(PDEUIMessages.DependenciesPage_title);
        Composite body = this.form.getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)true, (int)2));
        FormToolkit toolkit = managedForm.getToolkit();
        Composite left = toolkit.createComposite(body, 0);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout((boolean)false, (int)1));
        left.setLayoutData((Object)new GridData(1808));
        Composite right = toolkit.createComposite(body, 0);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout((boolean)false, (int)1));
        right.setLayoutData((Object)new GridData(1808));
        this.bundleImportPackageSection = new BundleImportPackageSection(this, left);
        this.bundleImportSection = new BundleImportSection(this, right);
        this.bundleImportLibrarySection = new BundleImportLibrarySection(this, right);
        managedForm.addPart((IFormPart)this.bundleImportPackageSection);
        managedForm.addPart((IFormPart)this.bundleImportSection);
        managedForm.addPart((IFormPart)this.bundleImportLibrarySection);
        IPluginModelBase model = (IPluginModelBase)((BundleManifestEditor)this.getEditor()).getAggregateModel();
        this.resource = model.getUnderlyingResource();
        this.updateFormText();
    }

    public void manifestSaved() {
        if (this.resource != null) {
            this.updateFormText();
        }
    }

    protected void updateFormText() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (OperationCanceledException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Could not update page title text", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {}
        try {
            if (this.resource != null) {
                IMarker[] markers = this.resource.findMarkers(null, true, 0);
                if (ManifestEditorUtils.hasErrorSeverityMarker(markers)) {
                    this.form.setText(MANIFEST_ERRORS);
                    this.form.setImage(ServerIdeUiPlugin.getImage("full/obj16/manifest_error.png"));
                } else {
                    this.form.setText(PDEUIMessages.DependenciesPage_title);
                    this.form.setImage(ServerIdeUiPlugin.getImage("full/obj16/osgi_obj.gif"));
                }
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Could not update page title text", (Throwable)e));
        }
    }

    public BundleImportPackageSection getBundleImportPackageSection() {
        return this.bundleImportPackageSection;
    }

    public BundleImportSection getBundleImportSection() {
        return this.bundleImportSection;
    }

    public BundleImportLibrarySection getBundleImportLibrarySection() {
        return this.bundleImportLibrarySection;
    }
}

