/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.ManifestReader;
import org.eclipse.virgo.bundlor.support.contributors.xml.AllClassesValueAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.StandardXmlArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.bundlor.util.AntPathMatcher;
import org.eclipse.virgo.bundlor.util.SimpleParserLogger;
import org.eclipse.virgo.bundlor.util.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class BlueprintArtifactAnalyzer
implements ManifestReader,
ArtifactAnalyzer {
    private static final Map<String, String> NAMESPACE_MAPPING = new HashMap<String, String>();
    private static final String DEFAULT_CONTEXT_LOCATION = "OSGI-INF/blueprint/*.xml";
    private static final String CONTEXT_PATH_HEADER = "Bundle-Blueprint";
    private static final String EXPRESSION = "//bp:bean/bp:argument/@type | //bp:bean/@class | //bp:service/@interface | //bp:reference/@interface | //bp:reference-list/@interface | //bp:map/@key-type | //bp:map/@value-type | //bp:list/@value-type | //bp:set/@value-type | //bp:array/@value-type | //bp:interfaces/bp:value";
    private final List<String> contextPaths = new ArrayList<String>();

    static {
        NAMESPACE_MAPPING.put("bp", "http://www.osgi.org/xmlns/blueprint/v1.0.0");
    }

    @Override
    public final void readJarManifest(ManifestContents manifest) {
        this.readContextPaths(manifest);
    }

    @Override
    public final void readManifestTemplate(ManifestContents manifestTemplate) {
        this.readContextPaths(manifestTemplate);
    }

    private final void readContextPaths(ManifestContents manifest) {
        String value = (String)manifest.getMainAttributes().get(CONTEXT_PATH_HEADER);
        List<HeaderDeclaration> headers = this.parseTemplate(value);
        if (headers.size() == 0) {
            this.contextPaths.add(DEFAULT_CONTEXT_LOCATION);
        } else {
            for (HeaderDeclaration header : headers) {
                this.contextPaths.add((String)header.getNames().get(0));
            }
        }
    }

    private final List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }

    @Override
    public void analyse(InputStream artifact, String artifactName, PartialManifest partialManifest) throws Exception {
        new StandardXmlArtifactAnalyzer(artifact, NAMESPACE_MAPPING).analyzeValues(EXPRESSION, new AllClassesValueAnalyzer(partialManifest));
    }

    @Override
    public final boolean canAnalyse(String artefactName) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String contextPath : this.contextPaths) {
            if (!matcher.match(contextPath, artefactName)) continue;
            return true;
        }
        return false;
    }
}

