/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.bundlor.support.ManifestMerger;
import org.eclipse.virgo.bundlor.support.PartialManifestResolver;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.util.SimpleManifestContents;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

final class StandardManifestMerger
implements ManifestMerger {
    private final PartialManifestResolver partialManifestResolver;

    public StandardManifestMerger(PartialManifestResolver partialManifestResolver) {
        this.partialManifestResolver = partialManifestResolver;
    }

    @Override
    public ManifestContents merge(ManifestContents existingManifest, ManifestContents manifestTemplate, ManifestContents contributedManifest, ReadablePartialManifest partialManifest, List<String> templateOnlyHeaderNames) {
        SimpleManifestContents manifest = new SimpleManifestContents();
        this.mergeManifests(manifest, existingManifest);
        this.mergeManifests(manifest, manifestTemplate);
        this.mergeManifests(manifest, contributedManifest);
        BundleManifest resolved = this.partialManifestResolver.resolve(manifestTemplate, partialManifest);
        this.mergeManifests(manifest, this.toManifestContents(resolved));
        this.removeTemplateOnlyHeaders(manifest, templateOnlyHeaderNames);
        return manifest;
    }

    private void mergeManifests(ManifestContents base, ManifestContents add) {
        base.getMainAttributes().putAll(add.getMainAttributes());
        for (String sectionName : add.getSectionNames()) {
            base.getAttributesForSection(sectionName).putAll(add.getAttributesForSection(sectionName));
        }
    }

    private ManifestContents toManifestContents(BundleManifest bundleManifest) {
        Dictionary headers = bundleManifest.toDictionary();
        SimpleManifestContents manifest = new SimpleManifestContents((String)headers.get("Manifest-Version"));
        Map attributes = manifest.getMainAttributes();
        Enumeration headerNames = headers.keys();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            attributes.put(headerName, (String)headers.get(headerName));
        }
        return manifest;
    }

    private void removeTemplateOnlyHeaders(ManifestContents manifest, List<String> names) {
        for (String name : names) {
            manifest.getMainAttributes().remove(name);
        }
    }
}

