/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractImportSection
extends TableSection
implements IModelChangedListener {
    protected TableViewer fViewer;
    private Action fAddAction;
    private Action fRemoveAction;
    private Action fPropertiesAction;

    public AbstractImportSection(PDEFormPage page, Composite parent) {
        this(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
    }

    public AbstractImportSection(PDEFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        super(formPage, parent, style, true, buttonLabels);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ImportPackageSection_required);
        section.setDescription(PDEUIMessages.ImportPackageSection_desc);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fViewer = tablePart.getTableViewer();
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = e1.toString();
                String s2 = e2.toString();
                if (s1.indexOf(" ") != -1) {
                    s1 = s1.substring(0, s1.indexOf(" "));
                }
                if (s2.indexOf(" ") != -1) {
                    s2 = s2.substring(0, s2.indexOf(" "));
                }
                return super.compare(viewer, (Object)s1, (Object)s2);
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        this.fViewer.setInput((Object)model);
        model.addModelChangedListener((IModelChangedListener)this);
        this.updateButtons();
    }

    protected abstract ITableLabelProvider getLabelProvider();

    protected abstract IContentProvider getContentProvider();

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    protected void updateButtons() {
        Object[] selected = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        int size = selected.length;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(this.getAddIndex(), this.isEditable());
        tablePart.setButtonEnabled(this.getRemoveIndex(), this.isEditable() && size > 0);
        tablePart.setButtonEnabled(this.getPropertiesIndex(), this.shouldEnableProperties(selected));
    }

    protected void buttonSelected(int index) {
        if (index == this.getAddIndex()) {
            this.handleAdd();
        } else if (index == this.getRemoveIndex()) {
            this.handleRemove();
        } else if (index == this.getPropertiesIndex()) {
            this.handleOpenProperties();
        }
    }

    protected abstract int getAddIndex();

    protected abstract int getRemoveIndex();

    protected abstract int getPropertiesIndex();

    protected abstract void handleRemove();

    protected abstract void handleAdd();

    protected abstract void handleOpenProperties();

    public void refresh() {
        this.fViewer.refresh();
        super.refresh();
    }

    protected void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiresSection_add){

            public void run() {
                AbstractImportSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.RequiresSection_delete){

            public void run() {
                AbstractImportSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fPropertiesAction = new Action(PDEUIMessages.ImportPackageSection_propertyAction){

            public void run() {
                AbstractImportSection.this.handleOpenProperties();
            }
        };
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.fViewer.getSelection();
        manager.add((IAction)this.fAddAction);
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        if (this.shouldEnableProperties(((IStructuredSelection)this.fViewer.getSelection()).toArray())) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fPropertiesAction);
        }
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    protected IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context != null ? (IBundleModel)context.getModel() : null;
    }

    protected IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model != null ? model.getBundle() : null;
    }

    protected boolean createCount() {
        return true;
    }

    protected boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ImportPackageObject)selected[0]).getVersion();
        boolean optional = ((ImportPackageObject)selected[0]).isOptional();
        int i = 1;
        while (i < selected.length) {
            ImportPackageObject object = (ImportPackageObject)selected[i];
            if (version == null ? object.getVersion() != null || optional != object.isOptional() : !version.equals(object.getVersion()) || optional != object.isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract String getHeaderConstant();

    public void modelChanged(IModelChangedEvent event) {
        Object[] objects;
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).fireModelChanged(event);
        }
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (this.getHeaderConstant().equals(event.getChangedProperty())) {
            this.refresh();
            return;
        }
        Object[] objectArray = objects = event.getChangedObjects();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof PDEManifestElement && ((PDEManifestElement)element).getHeader().getName().equals(this.getHeaderConstant())) {
                switch (event.getChangeType()) {
                    case 1: {
                        this.fViewer.add(element);
                        this.fViewer.setSelection((ISelection)new StructuredSelection(element));
                        this.fViewer.getTable().setFocus();
                        break;
                    }
                    case 2: {
                        Table table = this.fViewer.getTable();
                        int index = table.getSelectionIndex();
                        this.fViewer.remove(element);
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                        break;
                    }
                    default: {
                        this.fViewer.refresh(element);
                    }
                }
            }
            ++n2;
        }
    }

    protected abstract class AbstractSectionViewerLabelProvider
    implements ITableLabelProvider {
        protected AbstractSectionViewerLabelProvider() {
        }

        public abstract Image getColumnImage(Object var1, int var2);

        public abstract String getColumnText(Object var1, int var2);

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class ImportListSelectionDialog
    extends ElementListSelectionDialog {
        private Object[] fElements;

        public ImportListSelectionDialog(Shell parent, ILabelProvider renderer) {
            super(parent, renderer);
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = (Composite)super.createDialogArea(parent);
            Object[] allElements = new Object[this.fElements.length];
            if (this.fElements != null) {
                System.arraycopy(this.fElements, 0, allElements, 0, this.fElements.length);
            }
            return comp;
        }

        public void setElements(Object[] elements) {
            super.setElements(elements);
            this.fElements = elements;
        }
    }
}

