/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.blint.support.contributors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.bundlor.blint.support.Validator;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class ExportedNotImportedValidator
implements Validator {
    private static final String MESSAGE = "The manifest both imports and exports the package %s";

    @Override
    public Set<String> validate(ManifestContents manifest) {
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest((ManifestContents)manifest);
        HashSet<String> warnings = new HashSet<String>();
        for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
            String exportedName = exportedPackage.getPackageName();
            for (ImportedPackage importedPackage : bundleManifest.getImportPackage().getImportedPackages()) {
                if (!importedPackage.getPackageName().equals(exportedName)) continue;
                warnings.add(String.format(MESSAGE, exportedName));
            }
        }
        return warnings;
    }
}

