/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

class RemoteExporter {
    private IHost _host = null;

    public RemoteExporter(IHost s) {
        this._host = s;
    }

    public RemoteExporter() {
    }

    public void createFolder(IPath destinationPath) {
        if (this._host != null) {
            new UniFilePlus(Utilities.getIRemoteFile(this._host, destinationPath.toString())).mkdir();
        } else {
            new File(destinationPath.toOSString()).mkdir();
        }
    }

    public void write(IResource resource, IPath destinationPath) throws IOException, CoreException, SystemMessageException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws IOException, CoreException, SystemMessageException {
        if (folder.isAccessible()) {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++i;
            }
        }
    }

    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException, SystemMessageException {
        IRemoteFileSubSystem rfss = RemoteFileUtility.getFileSubSystem((IHost)this._host);
        String dest = destinationPath.toString();
        char sep = rfss.getSeparatorChar();
        if (sep != '/') {
            dest = dest.replace('/', sep);
        }
        rfss.upload(file.getLocation().makeAbsolute().toOSString(), SystemEncodingUtil.ENCODING_UTF_8, dest, System.getProperty("file.encoding"), null);
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws IOException, CoreException, SystemMessageException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

