/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.DefaultTrustAuthority;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.eclipse.osgi.internal.verifier.SignedStorageHook;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class SignedBundleHook
implements AdaptorHook,
BundleFileWrapperFactoryHook,
HookConfigurator,
CertificateVerifierFactory {
    static final int VERIFY_CERTIFICATE = 1;
    static final int VERIFY_TRUST = 2;
    static final int VERIFY_RUNTIME = 4;
    static final int VERIFY_ALL = 7;
    private static String SUPPORT_CERTIFICATE = "certificate";
    private static String SUPPORT_TRUST = "trust";
    private static String SUPPORT_RUNTIME = "runtime";
    private static String SUPPORT_ALL = "all";
    private static String SUPPORT_TRUE = "true";
    private static ServiceTracker trustAuthorityTracker;
    private static BaseAdaptor ADAPTOR;
    private static String SIGNED_BUNDLE_SUPPORT;
    private static int supportSignedBundles;
    private static CertificateTrustAuthority trustAuthority;
    private ServiceRegistration certVerifierReg;
    private ServiceRegistration trustAuthorityReg;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
        trustAuthority = new DefaultTrustAuthority(7);
    }

    public boolean matchDNChain(String pattern, String[] dnChain) {
        boolean satisfied = false;
        if (dnChain != null) {
            int i = 0;
            while (i < dnChain.length) {
                if (DNChainMatching.match(dnChain[i], pattern)) {
                    satisfied = true;
                    break;
                }
                ++i;
            }
        }
        return satisfied;
    }

    public void initialize(BaseAdaptor adaptor) {
        ADAPTOR = adaptor;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateVerifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.certVerifierReg = context.registerService(clazz.getName(), (Object)this, null);
        Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
        properties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        properties.put("osgi.certificate.trust.authority", JarVerifierConstant.DEFAULT_TRUST_AUTHORITY);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.trustAuthorityReg = context.registerService(clazz2.getName(), (Object)trustAuthority, properties);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        if (this.certVerifierReg != null) {
            this.certVerifierReg.unregister();
            this.certVerifierReg = null;
        }
        if (this.trustAuthorityReg != null) {
            this.trustAuthorityReg.unregister();
            this.trustAuthorityReg = null;
        }
        if (trustAuthorityTracker != null) {
            trustAuthorityTracker.close();
            trustAuthorityTracker = null;
        }
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) {
        try {
            if (bundleFile != null) {
                SignedBundleFile signedBaseFile;
                SignedStorageHook hook = (SignedStorageHook)data.getStorageHook(SignedStorageHook.KEY);
                if (base && hook != null) {
                    if (hook.signedBundleFile == null) {
                        hook.signedBundleFile = new SignedBundleFile();
                    }
                    signedBaseFile = hook.signedBundleFile;
                } else {
                    signedBaseFile = new SignedBundleFile();
                }
                signedBaseFile.setBundleFile(bundleFile, supportSignedBundles);
                if (signedBaseFile.isSigned()) {
                    bundleFile = signedBaseFile;
                } else if (base) {
                    hook.signedBundleFile = null;
                }
            }
        }
        catch (IOException iOException) {}
        return bundleFile;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
        String[] support = ManifestElement.getArrayFromList(FrameworkProperties.getProperty(SIGNED_BUNDLE_SUPPORT), ",");
        int i = 0;
        while (i < support.length) {
            if (SUPPORT_CERTIFICATE.equals(support[i])) {
                supportSignedBundles |= 1;
            } else if (SUPPORT_TRUST.equals(support[i])) {
                supportSignedBundles |= 3;
            } else if (SUPPORT_RUNTIME.equals(support[i])) {
                supportSignedBundles |= 5;
            } else if (SUPPORT_TRUE.equals(support[i]) || SUPPORT_ALL.equals(support[i])) {
                supportSignedBundles |= 7;
            }
            ++i;
        }
        if ((supportSignedBundles & 1) != 0) {
            hookRegistry.addStorageHook(new SignedStorageHook());
            hookRegistry.addBundleFileWrapperFactoryHook(this);
        }
    }

    public CertificateVerifier getVerifier(File content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        BundleFile contentBundleFile = content.isDirectory() ? new DirBundleFile(content) : new ZipBundleFile(content, null);
        SignedBundleFile result = new SignedBundleFile();
        result.setBundleFile(contentBundleFile, 7);
        return result;
    }

    public CertificateVerifier getVerifier(Bundle bundle) throws IOException {
        SignedBundleFile signedBundle;
        BundleData data = ((AbstractBundle)bundle).getBundleData();
        if (!(data instanceof BaseData)) {
            throw new IllegalArgumentException("Invalid bundle object.  No BaseData found.");
        }
        SignedStorageHook hook = (SignedStorageHook)((BaseData)data).getStorageHook(SignedStorageHook.KEY);
        SignedBundleFile signedBundleFile = signedBundle = hook != null ? hook.signedBundleFile : null;
        if (signedBundle != null) {
            return signedBundle;
        }
        return this.getVerifier(((BaseData)data).getBundleFile().getBaseFile());
    }

    static void log(String msg, int severity, Throwable t) {
        if (ADAPTOR == null) {
            System.err.println(msg);
            t.printStackTrace();
            return;
        }
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", severity, 0, msg, 0, t, null);
        ADAPTOR.getFrameworkLog().log(entry);
    }

    static BundleContext getContext() {
        if (ADAPTOR == null) {
            return null;
        }
        return ADAPTOR.getContext();
    }

    static CertificateTrustAuthority getTrustAuthority() {
        BundleContext context = SignedBundleHook.getContext();
        if (context == null) {
            return trustAuthority;
        }
        if (trustAuthorityTracker == null) {
            String trustAuthorityProp = Security.getProperty("osgi.certificate.trust.authority");
            Filter filter = null;
            if (trustAuthorityProp != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    filter = FrameworkUtil.createFilter(stringBuffer.append(clazz.getName()).append(")(").append("osgi.certificate.trust.authority").append("=").append(trustAuthorityProp).append("))").toString());
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (filter != null) {
                trustAuthorityTracker = new ServiceTracker(context, filter, null);
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                trustAuthorityTracker = new ServiceTracker(context, clazz.getName(), null);
            }
            trustAuthorityTracker.open();
        }
        return (CertificateTrustAuthority)trustAuthorityTracker.getService();
    }
}

