/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.IReportFormatter;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISingleReportOutput;
import org.jacoco.report.internal.xml.XMLDocument;
import org.jacoco.report.internal.xml.XMLElement;
import org.jacoco.report.internal.xml.XMLReportNodeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormatter
implements IReportFormatter {
    private static final String PUBID = "-//JACOCO//DTD Report 1.0//EN";
    private static final String SYSTEM = "report.dtd";
    private ISingleReportOutput output;
    private String outputEncoding = "UTF-8";

    @Override
    public IReportVisitor createReportVisitor(ICoverageNode rootNode, final List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("No report output set.");
        }
        XMLDocument root = new XMLDocument("report", PUBID, SYSTEM, this.outputEncoding, true, this.output.createFile());
        return new XMLReportNodeHandler(root, rootNode){

            protected void insertElementsBefore(XMLElement element) throws IOException {
                XMLFormatter.this.writeSessionInfos(element, sessionInfos);
            }
        };
    }

    private void writeSessionInfos(XMLElement root, List<SessionInfo> infos) throws IOException {
        for (SessionInfo i : infos) {
            XMLElement sessioninfo = root.element("sessioninfo");
            sessioninfo.attr("id", i.getId());
            sessioninfo.attr("start", i.getStartTimeStamp());
            sessioninfo.attr("dump", i.getDumpTimeStamp());
        }
    }

    public void setReportOutput(ISingleReportOutput output) {
        this.output = output;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

