/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.eclipse.equinox.internal.prov.engine.EngineActivator;
import org.eclipse.equinox.internal.prov.engine.Messages;
import org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus;
import org.eclipse.equinox.prov.core.helpers.ServiceHelper;
import org.eclipse.equinox.prov.engine.IProfileRegistry;
import org.eclipse.equinox.prov.engine.Profile;
import org.eclipse.equinox.prov.engine.ProfileEvent;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class SimpleProfileRegistry
implements IProfileRegistry {
    private static String STORAGE = "profileRegistry.xml";
    private LinkedHashMap profiles = new LinkedHashMap(8);
    private Properties properties = new Properties();
    private String self = EngineActivator.getContext().getProperty("eclipse.prov.profile");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SimpleProfileRegistry() {
        this.restore();
        this.updateRoamingProfile();
    }

    private void updateRoamingProfile() {
        Profile selfProfile = this.getProfile("_SELF_");
        if (selfProfile == null) {
            return;
        }
        if (!Boolean.valueOf(selfProfile.getValue("eclipse.prov.roaming")).booleanValue()) {
            return;
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        String locationString = installLocation.getURL().getPath();
        boolean changed = false;
        if (!locationString.equals(selfProfile.getValue("eclipse.prov.installFolder"))) {
            selfProfile.setValue("eclipse.prov.installFolder", locationString);
            changed = true;
        }
        if (!locationString.equals(selfProfile.getValue("eclipse.prov.cache"))) {
            selfProfile.setValue("eclipse.prov.cache", locationString);
            changed = true;
        }
        if (changed) {
            this.persist();
        }
    }

    public String toString() {
        return this.profiles.toString();
    }

    public Profile getProfile(String id) {
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        return (Profile)this.profiles.get(id);
    }

    public Profile[] getProfiles() {
        return this.profiles.values().toArray(new Profile[this.profiles.size()]);
    }

    public void addProfile(Profile toAdd) throws IllegalArgumentException {
        if (this.isNamedSelf(toAdd)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Not_Named_Self, (Object)toAdd.getProfileId()));
        }
        String id = toAdd.getProfileId();
        if (this.getProfile(id) != null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Duplicate_Profile_Id, (Object)id));
        }
        this.profiles.put(id, toAdd);
        this.broadcastChangeEvent(toAdd, ProfileEvent.ADDED);
        this.persist();
    }

    private void broadcastChangeEvent(Profile profile, byte reason) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((ProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).publishEvent((EventObject)new ProfileEvent(profile, reason));
    }

    /*
     * Exception decompiling
     */
    private void restore() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 146->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persist() {
        try {
            Location agent;
            BundleContext bundleContext = EngineActivator.getContext();
            Class<?> clazz = class$2;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.equinox.prov.core.location.AgentLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$2 = clazz2;
            }
            if ((agent = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), null)) == null) {
                return;
            }
            if (!agent.getURL().getProtocol().equals("file")) {
                throw new IOException("can't write at the given location");
            }
            File outputFile = new File(agent.getURL().getFile(), STORAGE);
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new RuntimeException("can't persist profile registry at: " + outputFile);
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));
            try {
                XStream xstream = new XStream();
                xstream.toXML((Object)new Object[]{this.properties, this.profiles}, (OutputStream)os);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                ((OutputStream)os).close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                ((OutputStream)os).close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeProfile(Profile toRemove) {
        if (this.isNamedSelf(toRemove)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Not_Named_Self, (Object)toRemove.getProfileId()));
        }
        if (this.profiles.remove(toRemove.getProfileId()) == null) {
            return;
        }
        this.broadcastChangeEvent(toRemove, ProfileEvent.REMOVED);
        this.persist();
    }

    private boolean isNamedSelf(Profile p) {
        return "_SELF_".equals(p.getParentProfile());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }
}

