/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.undo;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class Box {
    public int x1;
    public int y1;
    public int x2;
    public int y2;

    public Box(int x1, int y1, int x2, int y2) {
        this.set(x1, y1, x2, y2);
    }

    public void move(Point origin) {
        this.set(origin.x, origin.y, origin.x + this.getWidth(), origin.y + this.getHeight());
    }

    public void draw(GC gc) {
        gc.drawRectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
    }

    private void set(int x1, int y1, int x2, int y2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
    }

    public boolean contains(int x, int y) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2;
    }

    public int getWidth() {
        return this.x2 - this.x1;
    }

    public int getHeight() {
        return this.y2 - this.y1;
    }
}

