/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.utils;

public class BundleInfo {
    public static final int NO_LEVEL = -1;
    private String symbolicName = null;
    private String version = null;
    private String location;
    private boolean markedAsStarted = false;
    private int startLevel = -1;
    private boolean resolved = false;

    public BundleInfo(String symbolic, String version, String location, int startLevel, boolean started) {
        this.symbolicName = symbolic;
        this.version = version;
        this.location = location.trim();
        this.markedAsStarted = started;
        this.startLevel = startLevel;
    }

    public boolean equals(Object toCompare) {
        if (toCompare instanceof BundleInfo) {
            BundleInfo info = (BundleInfo)toCompare;
            if (info.symbolicName != null && info.version != null && this.symbolicName != null && this.version != null) {
                if (info.symbolicName.equals(this.symbolicName) && info.version.equals(this.version) && (info.location == null || this.location == null || info.location.equals(this.location))) {
                    return true;
                }
            } else {
                return info.location == null || this.location == null ? false : info.location.equals(this.location);
            }
        }
        return false;
    }

    public String getLocation() {
        return this.location;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = this.symbolicName == null ? 0 : this.symbolicName.hashCode();
        result += this.version == null ? 0 : this.version.hashCode();
        return result += this.location == null ? 0 : this.location.hashCode();
    }

    public boolean isMarkedAsStarted() {
        return this.markedAsStarted;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BundleInfo(");
        if (this.symbolicName != null) {
            buffer.append(this.symbolicName);
        }
        buffer.append(", ");
        if (this.version != null) {
            buffer.append(this.version);
        }
        buffer.append(", ");
        buffer.append("location=");
        buffer.append(this.location);
        buffer.append(", startLevel=");
        buffer.append(this.startLevel);
        buffer.append(", toBeStarted=");
        buffer.append(this.markedAsStarted);
        buffer.append(", resolved=");
        buffer.append(this.resolved);
        buffer.append(')');
        return buffer.toString();
    }
}

