/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.UserRestriction;
import org.eclipse.swtchart.extensions.menu.AbstractChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class UserRestrictionHandler
extends AbstractChartMenuEntry
implements IChartMenuEntry {
    private String category = "";

    public UserRestrictionHandler() {
        this("");
    }

    public UserRestrictionHandler(String category) {
        this.category = category;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getName() {
        return "User Restriction";
    }

    @Override
    public Image getIcon() {
        return ResourceSupport.getImage("restrict_range.gif");
    }

    @Override
    public void execute(Shell shell, ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        UserRestriction userRestriction = baseChart.getUserRestriction();
        if (userRestriction.isRestrictFrame()) {
            userRestriction.resetRestriction();
        } else {
            IAxisSet axisSet = baseChart.getAxisSet();
            IAxis axisX = axisSet.getXAxis(0);
            IAxis axisY = axisSet.getYAxis(0);
            Range rangeX = new Range(axisX.getRange());
            Range rangeY = new Range(axisY.getRange());
            userRestriction.setRange(rangeX, rangeY);
        }
    }
}

