/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.util.ProcessUtil;
import org.junit.rules.ExternalResource;

public class BuildFileRule
extends ExternalResource {
    private Project project;
    private StringBuffer logBuffer;
    private StringBuffer fullLogBuffer;
    private StringBuffer outputBuffer;
    private StringBuffer errorBuffer;

    protected void after() {
        if (this.project == null) {
            return;
        }
        String tearDown = "tearDown";
        if (this.project.getTargets().containsKey("tearDown")) {
            this.project.executeTarget("tearDown");
        }
    }

    public String getLog() {
        return this.logBuffer.toString();
    }

    public String getFullLog() {
        return this.fullLogBuffer.toString();
    }

    public String getOutput() {
        return this.cleanBuffer(this.outputBuffer);
    }

    public String getError() {
        return this.cleanBuffer(this.errorBuffer);
    }

    private String cleanBuffer(StringBuffer buffer) {
        StringBuilder cleanedBuffer = new StringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            if (ch == '\r') continue;
            cleanedBuffer.append(ch);
        }
        return cleanedBuffer.toString();
    }

    public void configureProject(String filename) throws BuildException {
        this.configureProject(filename, 4);
    }

    public void configureProject(String filename, int logLevel) throws BuildException {
        this.logBuffer = new StringBuffer();
        this.fullLogBuffer = new StringBuffer();
        this.project = new Project();
        if (Boolean.getBoolean("ant.test.basedir.ignore")) {
            System.clearProperty("basedir");
        }
        this.project.init();
        File antFile = new File(System.getProperty("root"), filename);
        this.project.setProperty("ant.processid", ProcessUtil.getProcessId((String)"<Process>"));
        this.project.setProperty("ant.threadname", Thread.currentThread().getName());
        this.project.setUserProperty("ant.file", antFile.getAbsolutePath());
        this.project.addBuildListener((BuildListener)new AntTestListener(logLevel));
        ProjectHelper.configureProject((Project)this.project, (File)antFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTarget(String targetName) {
        this.outputBuffer = new StringBuffer();
        PrintStream out = new PrintStream(new AntOutputStream(this.outputBuffer));
        this.errorBuffer = new StringBuffer();
        PrintStream err = new PrintStream(new AntOutputStream(this.errorBuffer));
        this.logBuffer = new StringBuffer();
        this.fullLogBuffer = new StringBuffer();
        PrintStream printStream = System.out;
        synchronized (printStream) {
            PrintStream sysOut = System.out;
            PrintStream sysErr = System.err;
            sysOut.flush();
            sysErr.flush();
            try {
                System.setOut(out);
                System.setErr(err);
                this.project.executeTarget(targetName);
            }
            finally {
                System.setOut(sysOut);
                System.setErr(sysErr);
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    public File getOutputDir() {
        return new File(this.getProject().getProperty("output"));
    }

    private class AntTestListener
    implements BuildListener {
        private int logLevel;

        public AntTestListener(int logLevel) {
            this.logLevel = logLevel;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.logLevel) {
                return;
            }
            if (event.getPriority() == 2 || event.getPriority() == 1 || event.getPriority() == 0) {
                BuildFileRule.this.logBuffer.append(event.getMessage());
            }
            BuildFileRule.this.fullLogBuffer.append(event.getMessage());
        }
    }

    protected static class AntOutputStream
    extends OutputStream {
        private StringBuffer buffer;

        public AntOutputStream(StringBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.append((char)b);
        }
    }
}

