/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.cdt.cmake.core.CMakeErrorParser;
import org.eclipse.cdt.core.ConsoleOutputStream;

public class ParsingConsoleOutputStream
extends ConsoleOutputStream {
    private final ConsoleOutputStream os;
    private final CMakeErrorParser parser;

    public ParsingConsoleOutputStream(ConsoleOutputStream outputStream, CMakeErrorParser cmakeErrorParser) {
        this.os = Objects.requireNonNull(outputStream);
        this.parser = Objects.requireNonNull(cmakeErrorParser);
    }

    public void write(int c) throws IOException {
        this.write(new byte[]{(byte)c}, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.parser.addInput(new String(b, off, len));
    }

    public synchronized void write(String msg) throws IOException {
        this.os.write(msg);
        this.parser.addInput(msg);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        this.os.close();
        this.parser.close();
    }
}

